/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TierReplicaComponents;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\r\u001b\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00043\u0001\u0001\u0006IA\f\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019Y\u0004\u0001)A\u0005k!9A\b\u0001b\u0001\n\u0013i\u0004B\u0002&\u0001A\u0003%a\bC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rQ\u0003\u0001\u0015!\u0003N\u0011\u001d)\u0006A1A\u0005\nYCaa\u0017\u0001!\u0002\u00139\u0006\"\u0003/\u0001\u0001\u0004\u0005\r\u0011\"\u0003^\u0011%\t\u0007\u00011AA\u0002\u0013%!\rC\u0005i\u0001\u0001\u0007\t\u0011)Q\u0005=\"I\u0011\u000e\u0001a\u0001\u0002\u0004%IA\u001b\u0005\ns\u0002\u0001\r\u00111A\u0005\niD\u0011\u0002 \u0001A\u0002\u0003\u0005\u000b\u0015B6\t\u000bu\u0004A\u0011\u0001@\t\r\u0005U\u0001\u0001\"\u0001\u007f\u0011\u0019\ty\u0002\u0001C\u0001}\"1\u00111\u0005\u0001\u0005\u0002yDa!a\n\u0001\t\u0003q\bbBA\u0019\u0001\u0011%\u00111\u0007\u0005\b\u0003W\u0002A\u0011BA7\u0005eyeMZ:fiN4uN\u001d'fC\u0012,'/\u00129pG\"$Vm\u001d;\u000b\u0005ma\u0012!B3q_\u000eD'BA\u000f\u001f\u0003\u0019\u0019XM\u001d<fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00025\u000511m\u001c8gS\u001e,\u0012A\f\t\u0003_Aj\u0011\u0001H\u0005\u0003cq\u00111bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0003qy\tQ!\u001e;jYNL!AO\u001c\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nq!\\3ue&\u001c7/F\u0001?!\ty\u0004*D\u0001A\u0015\ta\u0014I\u0003\u0002C\u0007\u000611m\\7n_:T!a\b#\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0002\u0013q!T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003=\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014X#A'\u0011\u00059\u000bfB\u0001\u001cP\u0013\t\u0001v'A\u0005UKN$X\u000b^5mg&\u0011!k\u0015\u0002\u0014\u001b>\u001c7.\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u0003!^\n\u0001#\u00197uKJL5O]'b]\u0006<WM\u001d\u0011\u0002\u0005Q\u0004X#A,\u0011\u0005aKV\"A!\n\u0005i\u000b%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002=B\u0011qfX\u0005\u0003Ar\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\nsKBd\u0017nY1NC:\fw-\u001a:`I\u0015\fHCA2g!\t\u0019C-\u0003\u0002fI\t!QK\\5u\u0011\u001d9W\"!AA\u0002y\u000b1\u0001\u001f\u00132\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001D9v_R\fW*\u00198bO\u0016\u0014X#A6\u0011\u000514hBA7u\u001d\tq7O\u0004\u0002pe6\t\u0001O\u0003\u0002rA\u00051AH]8pizJ\u0011aH\u0005\u0003;yI!!\u001e\u000f\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005]D(!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002v9\u0005\u0001\u0012/^8uC6\u000bg.Y4fe~#S-\u001d\u000b\u0003GnDqa\u001a\t\u0002\u0002\u0003\u00071.A\u0007rk>$\u0018-T1oC\u001e,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002G\"\u001a!#!\u0001\u0011\t\u0005\r\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005\u0019\u0011\r]5\u000b\t\u0005-\u0011QB\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tyAR\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003'\t)A\u0001\u0006CK\u001a|'/Z#bG\"\f!d\u001d5pk2$w)\u001a;Fa>\u001c\u0007n\u001d$s_6\u0014V\r\u001d7jG\u0006D3aEA\r!\u0011\t\u0019!a\u0007\n\t\u0005u\u0011Q\u0001\u0002\u0005)\u0016\u001cH/\u0001\u0015tQ>,H\u000e\u001a*fiV\u0014hNT8MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t\u0017J\u001a+ie><h\u000eK\u0002\u0015\u00033\t1f\u001d5pk2$'+\u001a;ve:,fn\u001b8po:$v\u000e]5d\u001fJ\u0004\u0016M\u001d;ji&|g.\u00134UQJ|wO\u001c\u0015\u0004+\u0005e\u0011\u0001\u0003;fCJ$un\u001e8)\u0007Y\tY\u0003\u0005\u0003\u0002\u0004\u00055\u0012\u0002BA\u0018\u0003\u000b\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002/9,wo\u00144gg\u0016$hi\u001c:MK\u0006$WM\u001d+pa&\u001cG\u0003CA\u001b\u00037\ni&a\u001a\u0011\t\u0005]\u0012Q\u000b\b\u0005\u0003s\tyE\u0004\u0003\u0002<\u0005-c\u0002BA\u001f\u0003\u0013rA!a\u0010\u0002H9!\u0011\u0011IA#\u001d\ry\u00171I\u0005\u0002\u000f&\u0011QIR\u0005\u0003?\u0011K!AQ\"\n\u0007\u00055\u0013)A\u0004nKN\u001c\u0018mZ3\n\t\u0005E\u00131K\u0001 \u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;ECR\f'bAA'\u0003&!\u0011qKA-\u0005QyeMZ:fi\u001a{'\u000fT3bI\u0016\u0014Hk\u001c9jG*!\u0011\u0011KA*\u0011\u0015)v\u00031\u0001X\u0011\u001d\tyf\u0006a\u0001\u0003C\n!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQB\u00191%a\u0019\n\u0007\u0005\u0015DEA\u0002J]RDq!!\u001b\u0018\u0001\u0004\t\t'A\u0006mK\u0006$WM]#q_\u000eD\u0017!\b8fo>3gm]3u\r>\u0014H*Z1eKJ$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u0015\u0015\u0005=\u0014QPA@\u0003\u001f\u000b\t\n\u0005\u0003\u0002r\u0005]d\u0002BA\u001d\u0003gJA!!\u001e\u0002T\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\tI(a\u001f\u00035=3gm]3u\r>\u0014H*Z1eKJ$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u000b\t\u0005U\u00141\u000b\u0005\u0006+b\u0001\ra\u0016\u0005\b\u0003\u0003C\u0002\u0019AAB\u0003\u0015)'O]8s!\u0011\t))a#\u000e\u0005\u0005\u001d%bAAE\u0003\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002\u000e\u0006\u001d%AB#se>\u00148\u000fC\u0004\u0002ja\u0001\r!!\u0019\t\u000f\u0005M\u0005\u00041\u0001\u0002\u0016\u0006IQM\u001c3PM\u001a\u001cX\r\u001e\t\u0004G\u0005]\u0015bAAMI\t!Aj\u001c8h\u0001")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableLike)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom())).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TestUtils.MockAlterIsrManager alterIsrManager = TestUtils$.MODULE$.createAlterIsrManager();
    private final TopicPartition tp = new TopicPartition("topic", 1);
    private ReplicaManager replicaManager;
    private QuotaFactory.QuotaManagers quotaManager;

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    private QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    private void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), "", QuotaFactory$.MODULE$.instantiate$default$5()));
    }

    @Test
    public void shouldGetEpochsFromReplica() {
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(42L, 5);
        int epochRequested = 5;
        .colon.colon request = new .colon.colon((Object)this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested), (List)Nil$.MODULE$);
        AbstractLog mockLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)mockLog.endOffsetForEpoch(epochRequested)).thenReturn((Object)new Some((Object)offsetAndEpoch));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(this.config().brokerId(), MetadataCache$.MODULE$.zkMetadataCache$default$2());
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterIsrManager x$9 = this.alterIsrManager();
        BrokerTopicStats x$10 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
        AtomicBoolean x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        TierReplicaComponents x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Option x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
        Partition partition = this.replicaManager().createPartition(this.tp());
        partition.setLog(mockLog, false);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.config().brokerId())));
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.newOffsetForLeaderTopicResult(this.tp(), Errors.NONE, offsetAndEpoch.leaderEpoch(), offsetAndEpoch.offset()), (List)Nil$.MODULE$), (Object)response);
    }

    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(this.config().brokerId(), MetadataCache$.MODULE$.zkMetadataCache$default$2());
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterIsrManager x$9 = this.alterIsrManager();
        BrokerTopicStats x$10 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
        AtomicBoolean x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        TierReplicaComponents x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Option x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
        this.replicaManager().createPartition(this.tp());
        int epochRequested = 5;
        .colon.colon request = new .colon.colon((Object)this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested), (List)Nil$.MODULE$);
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.newOffsetForLeaderTopicResult(this.tp(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L), (List)Nil$.MODULE$), (Object)response);
    }

    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = this.config();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(this.config().brokerId(), MetadataCache$.MODULE$.zkMetadataCache$default$2());
        LogDirFailureChannel x$8 = new LogDirFailureChannel(this.config().logDirs().size());
        TestUtils.MockAlterIsrManager x$9 = this.alterIsrManager();
        BrokerTopicStats x$10 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
        AtomicBoolean x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        TierReplicaComponents x$18 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Option x$19 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        Option x$20 = ReplicaManager$.MODULE$.$lessinit$greater$default$20();
        Option x$21 = ReplicaManager$.MODULE$.$lessinit$greater$default$21();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, null, logManager, x$6, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
        int epochRequested = 5;
        .colon.colon request = new .colon.colon((Object)this.newOffsetForLeaderTopic(this.tp(), -1, epochRequested), (List)Nil$.MODULE$);
        Seq response = this.replicaManager().lastOffsetForLeaderEpoch((Seq)request);
        Assertions.assertEquals((Object)new .colon.colon((Object)this.newOffsetForLeaderTopicResult(this.tp(), Errors.UNKNOWN_TOPIC_OR_PARTITION, -1, -1L), (List)Nil$.MODULE$), (Object)response);
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopic newOffsetForLeaderTopic(TopicPartition tp, int currentLeaderEpoch, int leaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(tp.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setLeaderEpoch(leaderEpoch), (List)Nil$.MODULE$)).asJava());
    }

    private OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult newOffsetForLeaderTopicResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(tp.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset), (List)Nil$.MODULE$)).asJava());
    }
}

