/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointBuffer;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\u001d:\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004Y\u0001\u0001\u0006I!\u0014\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u0019\t\u0007\u0001)A\u00057\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB4\u0001A\u0003%A\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003y\u0001\u0011\u0005\u0011\u000eC\u0003~\u0001\u0011\u0005\u0011\u000eC\u0003\u0000\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002\u0004\u0001!\t!\u001b\u0005\u0007\u0003\u000f\u0001A\u0011A5\t\r\u0005-\u0001\u0001\"\u0001j\u0011\u0019\ty\u0001\u0001C\u0001S\"1\u00111\u0003\u0001\u0005\u0002%Da!a\u0006\u0001\t\u0003I\u0007BBA\u000e\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002 \u0001!\t!\u001b\u0005\u0007\u0003G\u0001A\u0011A5\t\r\u0005\u001d\u0002\u0001\"\u0001j\u0011\u0019\tY\u0003\u0001C\u0001S\"1\u0011q\u0006\u0001\u0005\u0002%Da!a\r\u0001\t\u0003I\u0007BBA\u001c\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002<\u0001!\t!\u001b\u0005\u0007\u0003\u007f\u0001A\u0011A5\t\r\u0005\r\u0003\u0001\"\u0001j\u0011\u0019\t9\u0005\u0001C\u0001S\"1\u00111\n\u0001\u0005\u0002%Da!a\u0014\u0001\t\u0003I\u0007BBA*\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002X\u0001!\t!\u001b\u0005\u0007\u00037\u0002A\u0011A5\t\r\u0005}\u0003\u0001\"\u0001j\u0011\u0019\t\u0019\u0007\u0001C\u0001S\"1\u0011q\r\u0001\u0005\u0002%Da!a\u001b\u0001\t\u0003I\u0007BBA8\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002t\u0001!\t!\u001b\u0005\u0007\u0003o\u0002A\u0011A5\t\r\u0005m\u0004\u0001\"\u0001j\u0011\u0019\ty\b\u0001C\u0001S\"1\u00111\u0011\u0001\u0005\u0002%Da!a\"\u0001\t\u0003I\u0007BBAF\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002\u0010\u0002!\t!\u001b\u0005\u0007\u0003'\u0003A\u0011A5\t\r\u0005]\u0005\u0001\"\u0001j\u0011\u0019\tY\n\u0001C\u0001S\"1\u0011q\u0014\u0001\u0005\u0002%Da!a)\u0001\t\u0003I\u0007BBAT\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002,\u0002!\t!\u001b\u0005\u0007\u0003_\u0003A\u0011A5\u000311+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f)\u0016\u001cHO\u0003\u0002;w\u0005)Q\r]8dQ*\u0011A(P\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003y\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0003B\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A%\u0011\u0005)\u0003Q\"A\u001d\u0002\u0005Q\u0004X#A'\u0011\u000593V\"A(\u000b\u0005A\u000b\u0016AB2p[6|gN\u0003\u0002?%*\u00111\u000bV\u0001\u0007CB\f7\r[3\u000b\u0003U\u000b1a\u001c:h\u0013\t9vJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%\u0001\u0006dQ\u0016\u001c7\u000e]8j]R,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=n\n1b\u00195fG.\u0004x.\u001b8ug&\u0011\u0001-\u0018\u0002\u0016\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00115fG.\u0004x.\u001b8u\u0003-\u0019\u0007.Z2la>Lg\u000e\u001e\u0011\u0002\u000b\r\f7\r[3\u0016\u0003\u0011\u0004\"AS3\n\u0005\u0019L$\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW-\u0001\u0004dC\u000eDW\rI\u0001\ti\u0016\f'\u000fR8x]R\t!\u000e\u0005\u0002CW&\u0011An\u0011\u0002\u0005+:LG\u000f\u000b\u0002\t]B\u0011qN^\u0007\u0002a*\u0011\u0011O]\u0001\u0004CBL'BA:u\u0003\u001dQW\u000f]5uKJT!!\u001e+\u0002\u000b),h.\u001b;\n\u0005]\u0004(!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;Qe\u00164\u0018n\\;t\u000bB|7\r\u001b\u0015\u0003\u0013i\u0004\"a\\>\n\u0005q\u0004(\u0001\u0002+fgR\fQe\u001d5pk2$\u0017\t\u001a3Fa>\u001c\u0007.\u00118e\u001b\u0016\u001c8/Y4f\u001f\u001a47/\u001a;U_\u000e\u000b7\r[3)\u0005)Q\u0018aH:i_VdGmU3u%\u0016\u001cX\r\u001e$mC\u001e$\u0015N\u001d;z\u001f:\f5o]5h]\"\u00121B_\u0001/g\"|W\u000f\u001c3SKR,(O\u001c'pO\u0016sGm\u00144gg\u0016$\u0018J\u001a'bi\u0016\u001cH/\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002\ru\u0006!4\u000f[8vY\u0012\u0014V\r^;s]VsG-\u001a4j]\u0016$wJ\u001a4tKRLe-\u00168eK\u001aLg.\u001a3Fa>\u001c\u0007NU3rk\u0016\u001cH/\u001a3)\u00055Q\u0018AQ:i_VdGMT8u\u001fZ,'o\u001e:ji\u0016dunZ#oI>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u0012aB_\u00011g\"|W\u000f\u001c3F]\u001a|'oY3N_:|Go\u001c8jG\u0006dG._%oGJ,\u0017m]5oON#\u0018M\u001d;PM\u001a\u001cX\r^:)\u0005=Q\u0018\u0001P:i_VdGMT8u\u001fZ,'o\u001e:ji\u0016|eMZ:fi\u001a{'/\u0011'fC\u0012,'/\u00129pG\"|enY3Ji\"\u000b7OQ3f]\u0006\u001b8/[4oK\u0012D#\u0001\u0005>\u0002QMDw.\u001e7e%\u0016$XO\u001d8V]N,\b\u000f]8si\u0016$\u0017J\u001a(p\u000bB|7\r\u001b*fG>\u0014H-\u001a3)\u0005EQ\u0018AQ:i_VdGMU3ukJtWK\\:vaB|'\u000f^3e\u0013\u001atu.\u00129pG\"\u0014VmY8sI\u0016$\u0017I\u001c3V]\u0012,g-\u001b8fI\u0016\u0003xn\u00195SKF,Xm\u001d;fI\"\u0012!C_\u00019g\"|W\u000f\u001c3SKR,(O\u001c$jeN$X\t]8dQ&3'+Z9vKN$X\rZ#q_\u000eDG*Z:t)\"\fgNR5sgR,\u0005o\\2iQ\t\u0019\"0A\u001btQ>,H\u000e\u001a+sk:\u001c\u0017\r^3JM6\u000bGo\u00195j]\u001e,\u0005o\\2i\u0005V$X)\u0019:mS\u0016\u00148\u000b^1si&twm\u00144gg\u0016$\bF\u0001\u000b{\u0003!\u001b\bn\\;mI\u001e+GOR5sgR|eMZ:fi>37+\u001e2tKF,XM\u001c;Fa>\u001c\u0007n\u00165f]>3gm]3u%\u0016\fX/Z:uK\u00124uN\u001d)sKZLw.^:Fa>\u001c\u0007\u000e\u000b\u0002\u0016u\u0006)5\u000f[8vY\u0012\u0014V\r^;s]:+\u0007\u0010^!wC&d\u0017M\u00197f\u000bB|7\r[%g)\",'/Z%t\u001d>,\u00050Y2u\u000bB|7\r\u001b$peRCWm\u00148f%\u0016\fX/Z:uK\u0012D#A\u0006>\u0002eMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016,\u0005o\\2i\u0003:$7\u000b^1si>3gm]3u\u0013\u001aLE\u000fR5e\u001d>$8\t[1oO\u0016D#a\u0006>\u0002\u000bNDw.\u001e7e%\u0016$XO\u001d8J]Z\fG.\u001b3PM\u001a\u001cX\r^%g\u000bB|7\r[%t%\u0016\fX/Z:uK\u0012<\u0006.[2i\u0013Ntu\u000e^\"veJ,g\u000e\u001e7z)J\f7m[3eQ\tA\"0A\u0015tQ>,H\u000eZ*vaB|'\u000f^#q_\u000eD7\u000f\u00165bi\u0012{gj\u001c;Ti\u0006\u0014HO\u0012:p[j+'o\u001c\u0015\u00033i\f1e\u001d5pk2$\u0007+\u001a:tSN$X\t]8dQN\u0014U\r^<fK:Len\u001d;b]\u000e,7\u000f\u000b\u0002\u001bu\u0006Q3\u000f[8vY\u0012,eNZ8sG\u0016luN\\8u_:L7-\u00197ms&s7M]3bg&tw-\u00129pG\"\u001c\bFA\u000e{\u0003%\u001a\bn\\;mI\u0016sgm\u001c:dK>3gm]3ug&s7M]3bg\u0016luN\\8u_:L7-\u00197ms\"\u0012AD_\u00015g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003NdU-\u00193feN\u001c\u0005.\u00198hK6\u000bg.\u001f+j[\u0016\u001c\bFA\u000f{\u0003i\u001a\bn\\;mI&s7M]3bg\u0016\fe\u000e\u001a+sC\u000e\\W\t]8dQN\f5OR8mY><XM\u001d*fG\u0016Lg/Z:NC:LX*Z:tC\u001e,7\u000f\u000b\u0002\u001fu\u0006I4\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:P]\u0016\u0003xn\u00195C_VtG-\u0019:z/\",gNU3n_ZLgn\u001a'bi\u0016\u001cH/\u00128ue&,7\u000f\u000b\u0002 u\u0006\u00194\u000f[8vY\u0012\u0004&/Z:feZ,'+Z:fi>3gm]3u\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3ti&3wJ\\3Fq&\u001cHo\u001d\u0015\u0003Ai\f\u0011h\u001d5pk2$W\u000b\u001d3bi\u0016\u001c\u0016M^3e\u001f\u001a47/\u001a;XQ\u0016twJ\u001a4tKR$vn\u00117fCJ$v.S:CKR<X-\u001a8Fa>\u001c\u0007n\u001d\u0015\u0003Ci\fQe\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u0016\u000b'\u000f\\=)\u0005\tR\u0018aK:i_VdGMT8u\u00072,\u0017M]!osRD\u0017N\\4JM>3gm]3u)>4\u0015N]:u\u001f\u001a47/\u001a;)\u0005\rR\u0018!K:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH\u000f\u000b\u0002%u\u000694\u000f[8vY\u0012,\u0006\u000fZ1uK>3gm]3u\u0005\u0016$x/Z3o\u000bB|7\r\u001b\"pk:$\u0017M]5fg>s7\t\\3be\u0016\u000b'\u000f\\5fgRD#!\n>\u0002qMDw.\u001e7e+B$\u0017\r^3PM\u001a\u001cX\r\u001e\"fi^,WM\\#q_\u000eD'i\\;oI\u0006\u0014\u0018.Z:P]\u000ecW-\u0019:FCJd\u0017.Z:ue!\u0012aE_\u0001<g\"|W\u000f\u001c3SKR\f\u0017N\u001c'bi\u0016\u001cH/\u00129pG\"|en\u00117fCJ\fE\u000e\\#be2LWm\u001d;B]\u0012,\u0006\u000fZ1uK&#8o\u00144gg\u0016$\bFA\u0014{\u0003\u0001\"Xm\u001d;UeVt7-\u0019;f\rJ|Wn\u0015;beR<\u0016\u000e\u001e5O_\u001acWo\u001d5)\u0005!R\u0018aN:i_VdG\r\u0012:pa\u0016sGO]5fg\n+Go^3f]\u0016\u0003xn\u00195C_VtG-\u0019:z/\",gNU3n_ZLgn\u001a(fo\u0016\u001cH\u000f\u000b\u0002*u\u0006i2\u000f[8vY\u0012\u001cE.Z1s\u0003:$g\t\\;tQ\u0006cG.\u00128ue&,7\u000f\u000b\u0002+u\u0006)2\u000f[8vY\u0012\u001cE.Z1s\u00032dWI\u001c;sS\u0016\u001c\bFA\u0016{\u0003=\u001a\bn\\;mI:{GOU3tKR,\u0005o\\2i\u0011&\u001cHo\u001c:z\u0011\u0016\fG-\u00134V]\u0012,g-\u001b8fIB\u000b7o]3eQ\ta#0A\u0018tQ>,H\u000e\u001a(piJ+7/\u001a;Fa>\u001c\u0007\u000eS5ti>\u0014\u0018\u0010V1jY&3WK\u001c3fM&tW\r\u001a)bgN,G\r\u000b\u0002.u\u0006\u00113\u000f[8vY\u0012\u001cuN\u001d:fGRd\u0017PU3ti>\u0014XMR;mYNs\u0017\r]:i_RD#A\f>\u0002EMDw.\u001e7e\r\u0016$8\r\u001b'bi\u0016\u001cH/\u00129pG\"|e-R7qif\u001c\u0015m\u00195fQ\ty#0\u0001\u0011tQ>,H\u000e\u001a$fi\u000eDWI\u001c3PM\u001a\u001cX\r^(g\u000b6\u0004H/_\"bG\",\u0007F\u0001\u0019{\u0003}\u0019\bn\\;mI\u000ecW-\u0019:FCJd\u0017.Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0003ci\fQd\u001d5pk2$7\t\\3be2\u000bG/Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0003ei\fae\u001d5pk2$'+\u001a;ve:\u001cuN\u001d:fGR\u001cF/\u0019:u\u001f\u001a47/\u001a;G_J,\u0005o\\2iQ\t\u0019$0\u0001\ruS\u0016\u0014X\rZ#q_\u000eD7)Y2iKNs\u0017\r]:i_RD#\u0001\u000e>\u0002SMDw.\u001e7e\u001d>$(+\u001a9peR$\u0015N^3sO\u0016t7-Z,iK:tu\u000eR5wKJ<WM\\2fQ\t)$0A\u0012tQ>,H\u000e\u001a*fa>\u0014H\u000fR5wKJ<WM\\2f/\",g\u000eR5wKJ<\u0017N\\4)\u0005YR\u0018!J:i_VdGmQ8oi&tW/Z,sSR,Gk\\\"bG\",wJ\u001c#jg.\u0004\u0016-^:fQ\t9$\u0010")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;
        private final File file;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public File file() {
            return this.file;
        }

        public void write(Iterable<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
        }

        public byte[] toByteArray(Seq<EpochEntry> epochs) {
            throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = Nil$.MODULE$;
            this.file = TestUtils$.MODULE$.tempFile();
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.checkpoint().file());
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
    }

    @Test
    public void shouldSetResetFlagDirtyOnAssign() {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().maybeFlush();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1, 0L);
        Assertions.assertEquals((Object)expectedEpochEndOffset, (Object)epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0, 0L));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.cache().endOffsetFor(-1, 73L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4, 0L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6, 0L));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2, 17L));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3, 0L));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int logEndOffset = 100;
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3, (long)logEndOffset));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        cache.assign(2, 6L);
        cache.maybeFlush();
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), (Object)this.cache().endOffsetFor(0, (long)logEndOffset));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(1L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void testTruncateFromStartWithNoFlush() {
        .colon.colon epochs = new .colon.colon((Object)new EpochEntry(2, 6L), (List)new .colon.colon((Object)new EpochEntry(3, 8L), (List)new .colon.colon((Object)new EpochEntry(4, 11L), (List)Nil$.MODULE$)));
        epochs.foreach((Function1 & Serializable & scala.Serializable)epoch -> {
            LeaderEpochFileCacheTest.$anonfun$testTruncateFromStartWithNoFlush$1(this, epoch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(8L, false);
        Seq updatedEpochs = (Seq)epochs.tail();
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals((Object)epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals((Object)updatedEpochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAndFlushAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldClearAllEntries() {
        .colon.colon epochs = new .colon.colon((Object)new EpochEntry(2, 6L), (List)new .colon.colon((Object)new EpochEntry(3, 8L), (List)new .colon.colon((Object)new EpochEntry(4, 11L), (List)Nil$.MODULE$)));
        epochs.foreach((Function1 & Serializable & scala.Serializable)epoch -> {
            LeaderEpochFileCacheTest.$anonfun$shouldClearAllEntries$1(this, epoch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().clear();
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldCorrectlyRestoreFullSnapshot() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        .colon.colon snapshot = new .colon.colon((Object)new EpochEntry(3, 8L), (List)new .colon.colon((Object)new EpochEntry(4, 11L), (List)new .colon.colon((Object)new EpochEntry(5, 14L), (List)Nil$.MODULE$)));
        this.cache().restore((List)snapshot);
        Assertions.assertEquals((Object)snapshot, (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7, 0L));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L, this.cache().truncateFromStart$default$2());
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }

    @Test
    public void shouldReturnCorrectStartOffsetForEpoch() {
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        int requestedEpoch = 0;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 4;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 1;
        Assertions.assertEquals((long)10L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
    }

    @Test
    public void tieredEpochCacheSnapshot() {
        File checkpointFile = TestUtils$.MODULE$.tempFile();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(checkpointFile, null);
        LeaderEpochFileCache newCache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        newCache.assign(3, 43L);
        newCache.assign(5, 50L);
        newCache.assign(7, 70L);
        newCache.assign(8, 80L);
        byte[] bytesOut = newCache.snapshotForSegment(70L);
        LeaderEpochCheckpointBuffer checkPointBuffer = new LeaderEpochCheckpointBuffer("frombuffer", new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytesOut))));
        Assertions.assertEquals((Object)new .colon.colon((Object)new EpochEntry(3, 43L), (List)new .colon.colon((Object)new EpochEntry(5, 50L), (List)new .colon.colon((Object)new EpochEntry(7, 70L), (List)Nil$.MODULE$))), (Object)checkPointBuffer.read().toList());
    }

    @Test
    public void shouldNotReportDivergenceWhenNoDivergence() {
        this.cache().assign(5, 50L);
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        this.cache().assign(8, 80L);
        List tieredEpochState = this.cache().epochEntries().toList();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 50L, 89L), (String)"False positive for divergence while comparing with identical tier state");
        this.cache().clearAndFlush();
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 60L, 79L), (String)"False positive for divergence while comparing with an identical but superset tier state");
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 0L, -1L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = Nil$.MODULE$;
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, -1L, 100L, 119L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(5, 50L), (List)new .colon.colon((Object)new EpochEntry(6, 60L), (List)new .colon.colon((Object)new EpochEntry(7, 70L), (List)new .colon.colon((Object)new EpochEntry(8, 80L), (List)Nil$.MODULE$))));
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        this.cache().assign(12, 120L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 100L, 129L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 0L, 39L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)new .colon.colon((Object)new EpochEntry(4, 40L), (List)new .colon.colon((Object)new EpochEntry(5, 40L), (List)new .colon.colon((Object)new EpochEntry(6, 40L), (List)Nil$.MODULE$)))))));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        this.cache().assign(6, 40L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 49L), (String)"False positive for divergence when follower had not recorded leader with no messages");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$))));
        this.cache().clearAndFlush();
        this.cache().assign(0, 5L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 5L, 29L), (String)"False positive for divergence when local log had been incremented");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 100L, 999L), (String)"False positive for divergence when single entry in leaderCache, local log incremented and lastLocalOffset != lastTieredOffset");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 0L, 999L), (String)"False positive for divergence when end offset for an epoch mismatch due to lastLocalOffset != lastTieredOffset");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 100L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 199L, 0L, 49L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldReportDivergenceWhenDiverging() {
        .colon.colon tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$))));
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$)));
        this.cache().clearAndFlush();
        this.cache().assign(1, 5L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)5L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 10L, 39L, 5L, 39L), (String)"False negative when first local epoch has offset lower than tiered offset for the same epoch");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$))));
        this.cache().clearAndFlush();
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)20L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 39L, 25L, 59L), (String)"False negative when local cache misses an epoch but includes the corresponding offset");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(3, 30L), (List)new .colon.colon((Object)new EpochEntry(4, 40L), (List)new .colon.colon((Object)new EpochEntry(5, 50L), (List)Nil$.MODULE$)));
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(5, 50L), (List)new .colon.colon((Object)new EpochEntry(6, 60L), (List)new .colon.colon((Object)new EpochEntry(7, 70L), (List)Nil$.MODULE$)));
        this.cache().clearAndFlush();
        this.cache().assign(2, 60L);
        this.cache().assign(3, 70L);
        this.cache().assign(4, 80L);
        Assertions.assertEquals((long)60L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 50L, 79L, 60L, 89L), (String)"False negative when offsets at tieredEpochState and localCache do not increase monotonically");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(1, 100L), (List)new .colon.colon((Object)new EpochEntry(2, 150L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)150L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 100L, 179L, 100L, 199L), (String)"False negative when localCache is missing an epoch but the corresponding offsets are written to by a different epoch");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 100L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(0, 50L);
        this.cache().assign(1, 75L);
        Assertions.assertEquals((long)75L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 199L, 50L, 199L), (String)"False negative when end offset for start epoch mismatches");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 100L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)100L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 149L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 50L);
        Assertions.assertEquals((long)50L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 99L, 0L, 199L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldContinueWriteToCacheOnDiskPause() {
        TopicPartition tp = new TopicPartition("TestTopic", 5);
        LeaderEpochCheckpoint pausedDiskCheckpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Iterable<EpochEntry> epochs) {
                Thread.sleep(100L);
                this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
            }

            public byte[] toByteArray(Seq<EpochEntry> epochs) {
                throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = Nil$.MODULE$;
                this.file = TestUtils$.MODULE$.tempFile();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp, pausedDiskCheckpoint);
        cache.assign(1, 10L);
        cache.assign(2, 20L);
        cache.assign(3, 30L);
        ExecutionContextExecutor ec = ExecutionContext$.MODULE$.fromExecutor((Executor)Executors.newFixedThreadPool(3));
        Future maybeFlushTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.maybeFlush();
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future assignTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.assign(4, 40L);
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future endOffsetForEpochTask = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            long tBefore = System.currentTimeMillis();
            cache.endOffsetFor(3, 50L);
            return System.currentTimeMillis() - tBefore < 100L;
        }, (ExecutionContext)ec);
        Future tasks = Future$.MODULE$.sequence((TraversableOnce)new .colon.colon((Object)maybeFlushTask, (List)new .colon.colon((Object)assignTask, (List)new .colon.colon((Object)endOffsetForEpochTask, (List)Nil$.MODULE$))), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)ec);
        Seq res = (Seq)Await$.MODULE$.result((Awaitable)tasks, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true, true})), (Object)res);
    }

    public static final /* synthetic */ void $anonfun$testTruncateFromStartWithNoFlush$1(LeaderEpochFileCacheTest $this, EpochEntry epoch) {
        $this.cache().assign(epoch.epoch(), epoch.startOffset());
    }

    public static final /* synthetic */ void $anonfun$shouldClearAllEntries$1(LeaderEpochFileCacheTest $this, EpochEntry epoch) {
        $this.cache().assign(epoch.epoch(), epoch.startOffset());
    }
}

