/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.StorageProbe;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000112A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)\u0001\u0006\u0001C\u0001/!)!\u0006\u0001C\u0001/\t\u00012\u000b^8sC\u001e,\u0007K]8cKR+7\u000f\u001e\u0006\u0003\u000f!\taa]3sm\u0016\u0014(\"A\u0005\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0002CA\u000b\u0001\u001b\u00051\u0011\u0001\b;fgR\u001cFo\u001c:bO\u0016\u0004&o\u001c2f'&tw\r\\3M_\u001e$\u0017N\u001d\u000b\u00021A\u0011Q\"G\u0005\u000359\u0011A!\u00168ji\"\u0012!\u0001\b\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\n1!\u00199j\u0015\t\t#%A\u0004kkBLG/\u001a:\u000b\u0005\r\"\u0013!\u00026v]&$(\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(=\t!A+Z:u\u0003}!Xm\u001d;Ti>\u0014\u0018mZ3Qe>\u0014W-T;mi&\u0004H.\u001a'pO\u0012L'o\u001d\u0015\u0003\u0007q\tq\u0003^3ti\u0012K7/\u00192mKN#xN]1hKB\u0013xNY3)\u0005\u0011a\u0002")
public class StorageProbeTest {
    @Test
    public void testStorageProbeSingleLogdir() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(500000000L, 1600592000000L, 1600592000000L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(0)), (Object)BoxesRunTime.boxToInteger((int)500000000))})), (Object)storageProbe.probe(), (String)"mock time should have calculated storage latency as 1ms for each logdir");
        config.logDirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StorageProbeTest.$anonfun$testStorageProbeSingleLogdir$1(dir);
            return BoxedUnit.UNIT;
        });
        storageProbe.shutdown();
    }

    @Test
    public void testStorageProbeMultipleLogdirs() {
        int x$1 = 1;
        String x$2 = "localhost:2181";
        int x$3 = 2;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(100000000L, 1600592000000L, 1600592000000L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(0)), (Object)BoxesRunTime.boxToInteger((int)100000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.logDirs().apply(1)), (Object)BoxesRunTime.boxToInteger((int)100000000))})), (Object)storageProbe.probe(), (String)"mock time should have calculated storage latency for each logdir");
        Assertions.assertEquals((Object)"0,1600692000000", (Object)Utils.readFileAsString((String)Paths.get((String)config.logDirs().apply(0), "storage.probe").toFile().getAbsolutePath()), (String)"time of the first write should have been recorded");
        Assertions.assertEquals((Object)"0,1601092000000", (Object)Utils.readFileAsString((String)Paths.get((String)config.logDirs().apply(1), "storage.probe").toFile().getAbsolutePath()), (String)"time of the last write should have been recorded later than the first");
        storageProbe.shutdown();
    }

    @Test
    public void testDisableStorageProbe() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.StorageProbePeriodMsProp(), "-1");
        KafkaConfig config = new KafkaConfig((Map)props);
        MockTime time = new MockTime(1L);
        StorageProbe storageProbe = new StorageProbe(config, (Time)time, false);
        storageProbe.startup();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)storageProbe.probe(), (String)"Storage probe should not return any results");
        Assertions.assertFalse((boolean)Paths.get((String)config.logDirs().head(), "storage.probe").toFile().exists());
        storageProbe.shutdown();
    }

    public static final /* synthetic */ void $anonfun$testStorageProbeSingleLogdir$1(String dir) {
        Assertions.assertEquals((Object)"0,1601092000000", (Object)Utils.readFileAsString((String)Paths.get(dir, "storage.probe").toFile().getAbsolutePath()), (String)"time of the last write should have been recorded");
    }
}

