/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013\u0005A\u0007\u0003\u0004>\u0001\u0001\u0006I!\u000e\u0005\b}\u0001\u0011\r\u0011\"\u00015\u0011\u0019y\u0004\u0001)A\u0005k!9\u0001\t\u0001b\u0001\n\u0003\t\u0005B\u0002'\u0001A\u0003%!\tC\u0004N\u0001\t\u0007I\u0011A!\t\r9\u0003\u0001\u0015!\u0003C\u0011\u001dy\u0005A1A\u0005\u0002ACaa\u0016\u0001!\u0002\u0013\t\u0006b\u0002-\u0001\u0001\u0004%\t!\u0017\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0011\u0019A\u0007\u0001)Q\u00055\")\u0011\u000e\u0001C!U\")q\u000e\u0001C!a\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!a!\u0001\t\u0003\t)\tC\u0004\u0002\u0010\u0002!I!!%\t\u0011\u0005-\u0007\u0001)C\u0005\u0003\u001bDq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002d\u0002!\t!!:\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9!1\u0004\u0001\u0005\u0002\tu\u0001b\u0002B\u0014\u0001\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oAqAa\u0010\u0001\t\u0013\t\t\u000fC\u0004\u0003B\u0001!I!!9\t\u000f\t\r\u0003\u0001\"\u0003\u0003F\t\u00112+\u001a:wKJ\u001c\u0006.\u001e;e_^tG+Z:u\u0015\t!S%\u0001\u0004tKJ4XM\u001d\u0006\u0002M\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001*!\tQS&D\u0001,\u0015\taS%A\u0006j]R,wM]1uS>t\u0017B\u0001\u0018,\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001$\u0003\u0011Awn\u001d;\u0016\u0003U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\t1\fgn\u001a\u0006\u0002u\u0005!!.\u0019<b\u0013\tatG\u0001\u0004TiJLgnZ\u0001\u0006Q>\u001cH\u000fI\u0001\u0006i>\u0004\u0018nY\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u000bM,g\u000e^\u0019\u0016\u0003\t\u00032a\u0011&6\u001b\u0005!%BA#G\u0003%IW.\\;uC\ndWM\u0003\u0002H\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013#\u0003\t1K7\u000f^\u0001\u0007g\u0016tG/\r\u0011\u0002\u000bM,g\u000e\u001e\u001a\u0002\rM,g\u000e\u001e\u001a!\u0003a\u0001(o\u001c9t)>\u001c\u0005.\u00198hKV\u0003xN\u001c*fgR\f'\u000f^\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011A+O\u0001\u0005kRLG.\u0003\u0002W'\nQ\u0001K]8qKJ$\u0018.Z:\u00023A\u0014x\u000e]:U_\u000eC\u0017M\\4f+B|gNU3ti\u0006\u0014H\u000fI\u0001\faJLwN]\"p]\u001aLw-F\u0001[!\rYFLX\u0007\u0002\u0011&\u0011Q\f\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Iz\u0016B\u00011$\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001fA\u0014\u0018n\u001c:D_:4\u0017nZ0%KF$\"a\u00194\u0011\u0005m#\u0017BA3I\u0005\u0011)f.\u001b;\t\u000f\u001dl\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002\u0019A\u0014\u0018n\u001c:D_:4\u0017n\u001a\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\u001b\t\u0004Y6tV\"\u0001$\n\u000594%aA*fc\u0006)1/\u001a;VaR\u00111-\u001d\u0005\u0006eB\u0001\ra]\u0001\ti\u0016\u001cH/\u00138g_B\u0011A/`\u0007\u0002k*\u0011ao^\u0001\u0004CBL'B\u0001=z\u0003\u001dQW\u000f]5uKJT!A_>\u0002\u000b),h.\u001b;\u000b\u0003q\f1a\u001c:h\u0013\tqXO\u0001\u0005UKN$\u0018J\u001c4pQ\r\u0001\u0012\u0011\u0001\t\u0004i\u0006\r\u0011bAA\u0003k\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002#Q,7\u000f^\"mK\u0006t7\u000b[;uI><h\u000eF\u0002d\u0003\u0017Aq!!\u0004\u0012\u0001\u0004\ty!\u0001\u0004rk>\u0014X/\u001c\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000b\u00116\u0011\u0011q\u0003\u0006\u0004\u000339\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u001e!\u000ba\u0001\u0015:fI\u00164\u0017b\u0001\u001f\u0002\")\u0019\u0011Q\u0004%)\u000fE\t)#!\u000e\u00028A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005=r/\u0001\u0004qCJ\fWn]\u0005\u0005\u0003g\tICA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003s\ti$\t\u0002\u0002<\u0005\u0011!p[\u0011\u0003\u0003\u007f\tQa\u001b:bMRDs!EA\"\u0003\u0017\ni\u0005\u0005\u0003\u0002F\u0005\u001dSBAA\u0017\u0013\u0011\tI%!\f\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA(\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001$i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;q)\r\u0019\u0017Q\u000b\u0005\b\u0003\u001b\u0011\u0002\u0019AA\bQ\u001d\u0011\u0012QEA\u001b\u00033bC!!\u000f\u0002>!:!#a\u0011\u0002L\u00055\u0013!\u000e;fgRtun\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;q\tV,Gk\\\"peJ,\b\u000f\u001e'pON$2aYA1\u0011\u001d\tia\u0005a\u0001\u0003\u001fAsaEA\u0013\u0003k\t)\u0007\f\u0003\u0002:\u0005u\u0002fB\n\u0002D\u0005-\u0013QJ\u0001#i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tw+\u001b;i5.,f.\u0019<bS2\f'\r\\3\u0015\u0007\r\fi\u0007C\u0004\u0002\u000eQ\u0001\r!a\u0004)\u000fQ\t\t(a\u001e\u0002zA\u0019A/a\u001d\n\u0007\u0005UTO\u0001\u0005ESN\f'\r\\3e\u0003\u00151\u0018\r\\;fC\t\tY(\u0001\u0005L\u001b\u0016#\u0016)L\u001a9Q\u001d!\u0012QEA\u001b\u0003\u007fb#!!\u000f)\u000fQ\t\u0019%a\u0013\u0002N\u0005yC/Z:u\u00072,\u0017M\\*ikR$wn\u001e8XSRD7JU1gi\u000e{g\u000e\u001e:pY2,'/\u00168bm\u0006LG.\u00192mKR\u00191-a\"\t\u000f\u00055Q\u00031\u0001\u0002\u0010!:Q#!\n\u00026\u0005-EFAA\u001fQ\u001d)\u00121IA&\u0003\u001b\nQE^3sS\u001aL8\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9\u0016\t\u0005M\u00151\u0016\u000b\u0005\u0003+\u000bI\rF\u0002d\u0003/Cq!!'\u0017\u0001\b\tY*A\tfq\u000e,\u0007\u000f^5p]\u000ec\u0017m]:UC\u001e\u0004b!!(\u0002$\u0006\u001dVBAAP\u0015\r\t\t\u000bS\u0001\be\u00164G.Z2u\u0013\u0011\t)+a(\u0003\u0011\rc\u0017m]:UC\u001e\u0004B!!+\u0002,2\u0001AaBAW-\t\u0007\u0011q\u0016\u0002\u0002\u000bF!\u0011\u0011WA\\!\rY\u00161W\u0005\u0004\u0003kC%a\u0002(pi\"Lgn\u001a\t\u0005\u0003s\u000b\u0019M\u0004\u0003\u0002<\u0006}f\u0002BA\u000b\u0003{K\u0011!S\u0005\u0004\u0003\u0003D\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\f9MA\u0005Fq\u000e,\u0007\u000f^5p]*\u0019\u0011\u0011\u0019%\t\u000f\u00055a\u00031\u0001\u0002\u0010\u00051\u0012n\u001d(p]\u0012\u000bW-\\8o\u0017\u000647.\u0019+ie\u0016\fG\r\u0006\u0003\u0002P\u0006U\u0007cA.\u0002R&\u0019\u00111\u001b%\u0003\u000f\t{w\u000e\\3b]\"9\u0011q[\fA\u0002\u0005e\u0017!\u0001;\u0011\u0007Y\nY.C\u0002\u0002^^\u0012a\u0001\u00165sK\u0006$\u0017\u0001\b<fe&4\u0017PT8o\t\u0006,Wn\u001c8UQJ,\u0017\rZ:Ti\u0006$Xo\u001d\u000b\u0002G\u00069B/Z:u\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\u001c\u000b\u0004G\u0006\u001d\bbBA\u00073\u0001\u0007\u0011q\u0002\u0015\b3\u0005\u0015\u0012QGAvY\u0011\tI$!\u0010)\u000fe\t\u0019%a\u0013\u0002N\u0005\tB/Z:u\u0005\u0016<\u0017N\\*ikR$wn\u001e8\u0015\u000b\r\f\u00190!>\t\u000f\u00055!\u00041\u0001\u0002\u0010!9\u0011q\u001f\u000eA\u0002\u0005e\u0018a\u00048v[\"#H\u000f\u001d*fcV,7\u000f^:\u0011\u0007m\u000bY0C\u0002\u0002~\"\u00131!\u00138uQ\u001dQ\"\u0011AA<\u0005\u000f\u0001B!a\n\u0003\u0004%!!QAA\u0015\u0005%\u00195O^*pkJ\u001cW\r\f\u0005\u0003\n\t5!\u0011\u0003B\u000bC\t\u0011Y!\u0001\u0003{W2\n\u0014E\u0001B\b\u0003\u0011Q8\u000e\f\u001a\"\u0005\tM\u0011aB6sC\u001a$H&M\u0011\u0003\u0005/\tqa\u001b:bMRd#\u0007K\u0004\u001b\u0003\u0007\nY%!\u0014\u00027Q,7\u000f\u001e\"fO&t7\u000b[;uI><hn\u0016:p]\u001e,\u0005o\\2i)\r\u0019'q\u0004\u0005\b\u0003\u001bY\u0002\u0019AA\bQ\u001dY\u0012QEA\u001b\u0005GaC!!\u000f\u0002>!:1$a\u0011\u0002L\u00055\u0013\u0001\t;fgR\u001cuN\u001c;s_2dWM]*ikR$wn\u001e8EkJLgnZ*f]\u0012D3\u0001\bB\u0016!\r!(QF\u0005\u0004\u0005_)(\u0001\u0002+fgR\faaY8oM&<W#\u00010\u0002\r\t\u0014xn[3s+\t\u0011I\u0004E\u00023\u0005wI1A!\u0010$\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\u0002\u001dMDW\u000f\u001e3po:\u0014%o\\6fe\u0006i!/Z:uCJ$(I]8lKJ\faB]3de\u0016\fG/\u001a\"s_.,'\u000fF\u0002d\u0005\u000fBqA!\u0013\"\u0001\u0004\ty-A\u0004ti\u0006\u0014H/\u001e9)\u000f\u0001\u0011i%a\u001e\u0003TA\u0019AOa\u0014\n\u0007\tESOA\u0004US6,w.\u001e;\u001f\u0003q\u0002")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable & scala.Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).head(), this.propsToChangeUponRestart())));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        ((List)this.sent1().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.shutdownBroker();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        producer.elem = this.createProducer$1();
        KafkaConsumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.value(), Seq$.MODULE$.canBuildFrom()));
        ((List)this.sent2().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.value(), Seq$.MODULE$.canBuildFrom()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        String string = quorum;
        String string2 = "zk";
        if (string != null && string.equals(string2)) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
            this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
        this.shutdownBroker();
        this.shutdownKRaftController();
        this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(CancellationException.class));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        void setHaltProcedure_haltProcedure;
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.shutdownBroker();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        Some expectedStatusCode = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        VolatileObjectRef receivedStatusCode = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        VolatileBooleanRef hasHaltProcedureCalled = VolatileBooleanRef.create((boolean)false);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(statusCode, x$5) -> ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(hasHaltProcedureCalled, receivedStatusCode, BoxesRunTime.unboxToInt((Object)statusCode), x$5);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertDoesNotThrow(() -> this.recreateBroker(true));
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(hasHaltProcedureCalled, expectedStatusCode, receivedStatusCode)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ServerShutdownTest.$anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(expectedStatusCode, hasHaltProcedureCalled, receivedStatusCode));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            Exit$.MODULE$.resetHaltProcedure();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    @Disabled(value="KMETA-38")
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.shutdownBroker();
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.shutdownBroker();
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(String quorum, ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)exceptionClassTag.runtimeClass().isInstance(e), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
                String string = quorum;
                String string2 = "zk";
                Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)this.broker().brokerState());
            }
        }
        finally {
            this.shutdownBroker();
        }
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray())).map((Function1 & Serializable & scala.Serializable)x$6 -> (Thread)x$6, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class))))).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.shutdownBroker();
        this.broker().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @CsvSource(value={"zk,1", "zk,2", "kraft,1", "kraft,2"})
    public void testBeginShutdown(String quorum, int numHttpRequests) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdown$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numHttpRequests).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            this.broker().beginShutdown(this.broker().brokerEpoch());
            Assertions.assertEquals((Object)BrokerState.SHUTTING_DOWN, (Object)this.broker().brokerState(), (String)"broker should only be in shutting down state");
        });
        this.broker().shutdown();
        this.broker().awaitShutdown();
        String string = quorum;
        String string2 = "zk";
        Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)this.broker().brokerState(), (String)"expected broker to be fully shut down");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBeginShutdownWrongEpoch(String quorum) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ServerShutdownTest.$anonfun$testBeginShutdownWrongEpoch$1(this);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        long wrongBrokerEpoch = this.broker().brokerEpoch() - 1L;
        Assertions.assertThrows(StaleBrokerEpochException.class, () -> this.broker().beginShutdown(wrongBrokerEpoch), () -> "expected a begin shutdown requests at a different epoch to result in an exception");
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)this.broker().brokerState(), (String)"broker shutdown should not have started");
    }

    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrBatch batch = new LeaderAndIsrBatch(1).setControllerId(controllerId).setControllerEpoch(1).setBrokerEpoch(0L).addPartitionState(new TopicPartition("topic", 0), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState()).addLiveLeaders(((TraversableOnce)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.node(listenerName), Iterable$.MODULE$.canBuildFrom())).toSet()).addTopicId(this.topic(), Uuid.randomUuid());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            int x$1 = 1;
            Function2 x$3 = qual$1.sendControlMetadataBatch$default$3();
            qual$1.sendControlMetadataBatch(x$1, (ControlMetadataBatch)batch, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.shutdownBroker();
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16);
    }

    private final KafkaConsumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$2();
        Option<String> x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        String x$7 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$8 = TestUtils$.MODULE$.createConsumer$default$5();
        boolean x$9 = TestUtils$.MODULE$.createConsumer$default$6();
        int x$10 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$11 = TestUtils$.MODULE$.createConsumer$default$9();
        Option<Properties> x$12 = TestUtils$.MODULE$.createConsumer$default$10();
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$2, x$11, x$12, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$3(VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1, int statusCode, Option x$5) {
        hasHaltProcedureCalled$1.elem = true;
        receivedStatusCode$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        return (Nothing$)BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$5(VolatileBooleanRef hasHaltProcedureCalled$1, Some expectedStatusCode$1, VolatileObjectRef receivedStatusCode$1) {
        if (hasHaltProcedureCalled$1.elem) {
            Some some = expectedStatusCode$1;
            Option option = (Option)receivedStatusCode$1.elem;
            if (!(some != null ? !some.equals(option) : option != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoCleanShutdownAfterFailedStartupDueToCorruptLogs$6(Some expectedStatusCode$1, VolatileBooleanRef hasHaltProcedureCalled$1, VolatileObjectRef receivedStatusCode$1) {
        return new StringBuilder(117).append("Expected to halt directly with the expected status code:").append(expectedStatusCode$1.get()).append(", ").append("but got hasHaltProcedureCalled: ").append(hasHaltProcedureCalled$1.elem).append(" and received status code: ").append(((Option)receivedStatusCode$1.elem).orNull(Predef$.MODULE$.$conforms())).toString();
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdown$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public static final /* synthetic */ void $anonfun$testBeginShutdownWrongEpoch$1(ServerShutdownTest $this) {
        Assertions.assertEquals((Object)BrokerState.RUNNING, (Object)$this.broker().brokerState(), (String)"broker should be started");
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

