/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.Defaults$;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory$;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u00015!)Q\u0006\u0001C\u00015!)q\u0006\u0001C\u00015!)\u0011\u0007\u0001C\u00015!)1\u0007\u0001C\u00015\t\u0001\u0012+^8uC\u001a\u000b7\r^8ssR+7\u000f\u001e\u0006\u0003\u0015-\taa]3sm\u0016\u0014(\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005I\u0011!\u000e;fgR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_:4\u0017nZ*fiN\u001cuN\u001d:fGR\u0014\u0016\r^3G_JdU-\u00193feRC'o\u001c;uY\u0016$\u0012a\u0007\t\u0003!qI!!H\t\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0002%K\u00059!.\u001e9ji\u0016\u0014(B\u0001\u0014(\u0003\u0015QWO\\5u\u0015\u0005A\u0013aA8sO&\u0011!&\t\u0002\u0005)\u0016\u001cH/A\u001cuKN$(+\u001a9mS\u000e\fG/[8o\u0007>tg-[4TKR\u001c8i\u001c:sK\u000e$(+\u0019;f\r>\u0014hi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u0015\u0003\u0007}\t!\t^3tiJ+\u0007\u000f\\5dCRLwN\\\"p]\u001aLwmU3ug\u0012+g-Y;mi\u001a{'/\u00117uKJdun\u001a#jeN\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UQJ|G\u000f\u001e7fQ\t!q$A\u001buKN$8\t\\5f]R\u0014V-];fgR\u001cuN\u001c4jON+Go]\"peJ,7\r\u001e\"bG.\u0004(/Z:tkJ,7i\u001c8gS\u001e\u001c\bFA\u0003 \u0003m!Xm\u001d;ESN\\')Y2laJ,7o];sK\u000e{gNZ5hg\"\u0012aaH\u0001\u0015i\u0016\u001cHo\u00117vgR,'\u000fT5oWF+x\u000e^1)\u0005\u001dy\u0002")
public class QuotaFactoryTest {
    @Test
    public void testReplicationConfigSetsCorrectRateForLeaderThrottle() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1111");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "2222");
        ReplicationQuotaManagerConfig config = QuotaFactory$.MODULE$.replicationConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.LeaderReplication$.MODULE$);
        Assertions.assertTrue((boolean)config.allReplicasThrottled(), (String)"Expected all leader replicas to be throttled");
        Assertions.assertEquals((long)1111L, (long)config.quotaBytesPerSecond());
    }

    @Test
    public void testReplicationConfigSetsCorrectRateForFollowerThrottle() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1111");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "2222");
        ReplicationQuotaManagerConfig config = QuotaFactory$.MODULE$.replicationConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.FollowerReplication$.MODULE$);
        Assertions.assertTrue((boolean)config.allReplicasThrottled(), (String)"Expected all follower replicas to be throttled");
        Assertions.assertEquals((long)2222L, (long)config.quotaBytesPerSecond());
    }

    @Test
    public void testReplicationConfigSetsDefaultForAlterLogDirsReplicationThrottle() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1111");
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "2222");
        ReplicationQuotaManagerConfig config = QuotaFactory$.MODULE$.replicationConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.AlterLogDirsReplication$.MODULE$);
        Assertions.assertFalse((boolean)config.allReplicasThrottled(), (String)"Expected no log dir replicas to be throttled");
        Assertions.assertEquals((long)Defaults$.MODULE$.QuotaBytesPerSecond(), (long)config.quotaBytesPerSecond());
    }

    @Test
    public void testClientRequestConfigSetsCorrectBackpressureConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.QueuedMaxRequestsProp(), "500");
        props.put("confluent.backpressure.types", "request");
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://localhost:0,EXTERNAL://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:0,EXTERNAL://localhost:0");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        ClientQuotaManagerConfig config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertFalse((boolean)config.backpressureConfig().backpressureEnabledInConfig(), (String)"Expected request backpressure disabled");
        Assertions.assertEquals((Object)new .colon.colon((Object)"EXTERNAL", (List)Nil$.MODULE$), (Object)config.backpressureConfig().tenantEndpointListenerNames());
        Assertions.assertEquals((double)500.0, (double)config.backpressureConfig().maxQueueSize(), (double)0.0);
        Assertions.assertEquals((double)Predef$.MODULE$.Long2long(ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT), (double)config.backpressureConfig().minBrokerRequestQuota(), (double)0.0);
        Assertions.assertEquals((Object)"p95", (Object)config.backpressureConfig().queueSizePercentile());
        props.put("confluent.backpressure.request.min.broker.limit", "100");
        props.put("confluent.backpressure.request.queue.size.percentile", "p99");
        ClientQuotaManagerConfig config2 = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertEquals((double)100.0, (double)config2.backpressureConfig().minBrokerRequestQuota(), (double)0.0);
        Assertions.assertEquals((Object)"p99", (Object)config2.backpressureConfig().queueSizePercentile());
        props.put("confluent.backpressure.request.min.broker.limit", "0");
        props.put("confluent.backpressure.request.queue.size.percentile", "p105");
        ClientQuotaManagerConfig config3 = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Request$.MODULE$);
        Assertions.assertEquals((double)BrokerBackpressureConfig$.MODULE$.MinBrokerRequestQuota(), (double)config3.backpressureConfig().minBrokerRequestQuota(), (double)0.0);
        Assertions.assertEquals((Object)"p95", (Object)config3.backpressureConfig().queueSizePercentile());
    }

    @Test
    public void testDiskBackpressureConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("confluent.cluster.link.enable", "true");
        props.put("confluent.backpressure.types", "request");
        props.put("confluent.multitenant.listener.names", "EXTERNAL");
        ClientQuotaManagerConfig config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)0x500000000L, (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
        props.put("confluent.backpressure.disk.free.threshold.bytes", "1234567");
        config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
        long thresholdBytes = 0x80000000L;
        props.put("confluent.backpressure.disk.free.threshold.bytes", Long.toString(thresholdBytes));
        config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)thresholdBytes, (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
        props.put("confluent.cluster.link.enable", "false");
        config = QuotaFactory$.MODULE$.clientConfig(KafkaConfig$.MODULE$.fromProps(props), (QuotaType)QuotaType.Produce$.MODULE$);
        Assertions.assertEquals((long)thresholdBytes, (long)config.diskThrottlingConfig().freeDiskThresholdBytes());
    }

    @Test
    public void testClusterLinkQuota() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("confluent.cluster.link.enable", "true");
        props.put("confluent.cluster.link.io.max.bytes.per.second", "10000");
        ReplicationQuotaManagerConfig quotaConfig = QuotaFactory$.MODULE$.clusterLinkReplicationConfig(KafkaConfig$.MODULE$.fromProps(props));
        Assertions.assertEquals((long)10000L, (long)quotaConfig.quotaBytesPerSecond());
        Assertions.assertTrue((boolean)quotaConfig.allReplicasThrottled());
        props.put("confluent.cluster.link.io.max.bytes.per.second", Long.toString(Long.MAX_VALUE));
        ReplicationQuotaManagerConfig quotaConfig2 = QuotaFactory$.MODULE$.clusterLinkReplicationConfig(KafkaConfig$.MODULE$.fromProps(props));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)quotaConfig2.quotaBytesPerSecond());
        Assertions.assertFalse((boolean)quotaConfig2.allReplicasThrottled());
    }
}

