/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.Configuration;
import kafka.controller.ClusterBalanceManager;
import kafka.raft.KafkaRaftManager;
import kafka.raft.RaftManager;
import kafka.server.ControllerServer;
import kafka.server.ControllerServer$;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t\u001de!\u0002\u001a4\u0003\u0003A\u0004\"B#\u0001\t\u00031\u0005bB%\u0001\u0005\u0004%\tA\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000f=\u0003!\u0019!C\u0001\u0015\"1\u0001\u000b\u0001Q\u0001\n-Cq!\u0015\u0001C\u0002\u0013\u0005!\n\u0003\u0004S\u0001\u0001\u0006Ia\u0013\u0005\u0006'\u0002!\t\u0002\u0016\u0005\u00067\u0002!\t\u0002\u0018\u0005\u0006Y\u0002!\t\"\u001c\u0005\by\u0002\u0001\r\u0011\"\u0003~\u0011%\t\u0019\u0001\u0001a\u0001\n\u0013\t)\u0001C\u0004\u0002\u0012\u0001\u0001\u000b\u0015\u0002@\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u000e\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003;\u0001A\u0011BA\u0010\u0011\u001d\t9\u0003\u0001C\u0005\u0003SAq!!\r\u0001\t\u0003\t\u0019\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005-\u0003\u0001\"\u0001\u0002D!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003BBA,\u0001\u0011\u0005!\nC\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005M\u0004\u0001\"\u0001\u0002\\!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011%\t9\t\u0001a\u0001\n\u0003\tI\tC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0001\u0002\u001c\"A\u0011q\u0014\u0001!B\u0013\tY\tC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"I\u00111\u001e\u0001\u0012\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0005\u0007\u0001\u0011\u0013!C\u0001\u0005\u000bAqA!\u0003\u0001\t\u0003\tI\u0002C\u0004\u0003\f\u0001!\t!!\u0007\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!\u0011\u0006\u0001\u0005\u0002\t-\u0002b\u0002B\u0018\u0001\u0011%\u0011q\u0004\u0005\b\u0005c\u0001A\u0011AA\r\u0011\u001d\u0011Y\u0004\u0001C\u0001\u0005{9qAa\u00174\u0011\u0003\u0011iF\u0002\u00043g!\u0005!q\f\u0005\u0007\u000b2\"\tA!\u0019\t\u0013\t\rDF1A\u0005\u0002\t\u0015\u0004\u0002\u0003B9Y\u0001\u0006IAa\u001a\t\u000f\tMD\u0006\"\u0001\u0002\u001a!9!Q\u0010\u0017\u0005\u0002\u0005e!!E)v_J,X\u000eV3ti\"\u000b'O\\3tg*\u0011A'N\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0007C\u0001!D\u001b\u0005\t%B\u0001\"6\u0003\u0015)H/\u001b7t\u0013\t!\u0015IA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00059\u0005C\u0001%\u0001\u001b\u0005\u0019\u0014a\u0005>l\u0007>tg.Z2uS>tG+[7f_V$X#A&\u0011\u0005ib\u0015BA'<\u0005\rIe\u000e^\u0001\u0015u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002!i\\7+Z:tS>tG+[7f_V$\u0018!\u0005>l'\u0016\u001c8/[8o)&lWm\\;uA\u0005)\"p['bq&sg\t\\5hQR\u0014V-];fgR\u001c\u0018A\u0006>l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\u0002\u001bi\\\u0017i\u00197t\u000b:\f'\r\\3e+\u0005)\u0006c\u0001\u001eW1&\u0011qk\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005iJ\u0016B\u0001.<\u0005\u001d\u0011un\u001c7fC:\f!eY8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW#A/\u0011\u0005ySW\"A0\u000b\u0005\u0001\f\u0017\u0001B1vi\"T!AY2\u0002\u0011M,7-\u001e:jifT!\u0001Z3\u0002\r\r|W.\\8o\u0015\t1dM\u0003\u0002hQ\u00061\u0011\r]1dQ\u0016T\u0011![\u0001\u0004_J<\u0017BA6`\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\fle\u00064GoQ8oiJ|G\u000e\\3s\u0007>tg-[4t)\u0005q\u0007cA8si6\t\u0001O\u0003\u0002rw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005M\u0004(aA*fcB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0005kRLGNC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m4(A\u0003)s_B,'\u000f^5fg\u0006q\u0011.\u001c9mK6,g\u000e^1uS>tW#\u0001@\u0011\u0005!{\u0018bAA\u0001g\t!\u0012+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:\f!#[7qY\u0016lWM\u001c;bi&|gn\u0018\u0013fcR!\u0011qAA\u0007!\rQ\u0014\u0011B\u0005\u0004\u0003\u0017Y$\u0001B+oSRD\u0001\"a\u0004\r\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\n\u0014aD5na2,W.\u001a8uCRLwN\u001c\u0011\u0002\u0017%\u001c8JU1giR+7\u000f\u001e\u000b\u00021\u0006i1\r[3dW&\u001b(l\u0013+fgR$\"!a\u0002\u0002!\rDWmY6Jg.\u0013\u0016M\u001a;UKN$\u0018\u0001B1t5.$\"!!\t\u0011\u0007!\u000b\u0019#C\u0002\u0002&M\u0012QDW8p\u0017\u0016,\u0007/\u001a:Rk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\bCN\\%+\u00194u)\t\tY\u0003E\u0002I\u0003[I1!a\f4\u0005eY%+\u00194u#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002\u0013i|wn[3fa\u0016\u0014XCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001ek\u0005\u0011!p[\u0005\u0005\u0003\u007f\tIDA\tF[\n,G\rZ3e5>|7.Z3qKJ\f\u0001B_6DY&,g\u000e^\u000b\u0003\u0003\u000b\u0002B!a\u000e\u0002H%!\u0011\u0011JA\u001d\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006q!p[\"mS\u0016tGo\u0014:Ok2d\u0017!D1e[&t'l[\"mS\u0016tG/\u0006\u0002\u0002RA!\u0011qGA*\u0013\u0011\t)&!\u000f\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003\u0019Q8\u000eU8si\u0006I!p[\"p]:,7\r^\u000b\u0003\u0003;\u0002B!a\u0018\u0002n9!\u0011\u0011MA5!\r\t\u0019gO\u0007\u0003\u0003KR1!a\u001a8\u0003\u0019a$o\\8u}%\u0019\u00111N\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\ty'!\u001d\u0003\rM#(/\u001b8h\u0015\r\tYgO\u0001\u0010u.\u001cuN\u001c8fGR|%OT;mY\u0006\u00012m\u001c8ue>dG.\u001a:TKJ4XM]\u000b\u0003\u0003s\u00022\u0001SA>\u0013\r\tih\r\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\fqC]3ti\u0006\u0014HoQ8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0002#\r|g\u000e\u001e:pY2,'oU3sm\u0016\u00148/\u0006\u0002\u0002\u0006B!qN]A=\u0003U\u0019G.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ,\"!a#\u0011\ti2\u0016Q\u0012\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*\u0019\u00111S\u001b\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0002\u0018\u0006E%!F\"mkN$XM\u001d\"bY\u0006t7-Z'b]\u0006<WM]\u0001\u001aG2,8\u000f^3s\u0005\u0006d\u0017M\\2f\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0005u\u0005\"CA\b=\u0005\u0005\t\u0019AAF\u0003Y\u0019G.^:uKJ\u0014\u0015\r\\1oG\u0016l\u0015M\\1hKJ\u0004\u0013!B:fiV\u0003H\u0003BA\u0004\u0003KCq!a*!\u0001\u0004\tI+\u0001\u0005uKN$\u0018J\u001c4p!\u0011\tY+!/\u000e\u0005\u00055&\u0002BAX\u0003c\u000b1!\u00199j\u0015\u0011\t\u0019,!.\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u00175\u0002\u000b),h.\u001b;\n\t\u0005m\u0016Q\u0016\u0002\t)\u0016\u001cH/\u00138g_\"\u001a\u0001%a0\u0011\t\u0005-\u0016\u0011Y\u0005\u0005\u0003\u0007\fiK\u0001\u0006CK\u001a|'/Z#bG\"\fAb\u0019:fCR,'I]8lKJ$\u0002\"!3\u0002P\u0006e\u0017q\u001d\t\u0004\u0011\u0006-\u0017bAAgg\tY1*\u00194lC\n\u0013xn[3s\u0011\u001d\t\t.\ta\u0001\u0003'\faaY8oM&<\u0007c\u0001%\u0002V&\u0019\u0011q[\u001a\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\n\u00037\f\u0003\u0013!a\u0001\u0003;\fA\u0001^5nKB!\u0011q\\Ar\u001b\t\t\tO\u0003\u0002CG&!\u0011Q]Aq\u0005\u0011!\u0016.\\3\t\u0011\u0005%\u0018\u0005%AA\u0002a\u000bqa\u001d;beR,\b/\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tyO\u000b\u0003\u0002^\u0006E8FAAz!\u0011\t)0a@\u000e\u0005\u0005](\u0002BA}\u0003w\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005u8(\u0001\u0006b]:|G/\u0019;j_:LAA!\u0001\u0002x\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uIM*\"Aa\u0002+\u0007a\u000b\t0A\ttQV$Hm\\<o5>|7*Z3qKJ\fqc\u001d5vi\u0012|wO\\&SC\u001a$8i\u001c8ue>dG.\u001a:\u0002#\u0019|'/\\1u\t&\u0014Xm\u0019;pe&,7\u000f\u0006\u0004\u0002\b\tE!q\u0004\u0005\b\u0005'1\u0003\u0019\u0001B\u000b\u0003-!\u0017N]3di>\u0014\u0018.Z:\u0011\r\t]!QDA/\u001b\t\u0011IBC\u0002\u0003\u001cA\f\u0011\"[7nkR\f'\r\\3\n\u0007M\u0014I\u0002C\u0004\u0003\"\u0019\u0002\rAa\t\u0002\u001d5,G/\u0019)s_B,'\u000f^5fgB\u0019\u0001J!\n\n\u0007\t\u001d2G\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0002\u001d9,wo\u0013*bMR\fVo\u001c:v[R!\u00111\u0006B\u0017\u0011\u001d\t9k\na\u0001\u0003S\u000b!C\\3x5>|7*Z3qKJ\fVo\u001c:v[\u0006AA/Z1s\t><h\u000eK\u0002*\u0005k\u0001B!a+\u00038%!!\u0011HAW\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0016de\u0016\fG/\u001a.p_.+W\r]3s\u00072LWM\u001c;U_R\u0013\u0018nZ4feN+7o]5p]\u0016C\b/\u001b:z)\u0011\u0011yD!\u0013\u0011\t\t\u0005#QI\u0007\u0003\u0005\u0007R1!!\rg\u0013\u0011\u00119Ea\u0011\u0003\u0013i{wnS3fa\u0016\u0014\bb\u0002B&U\u0001\u0007!qH\u0001\nu>|7*Z3qKJDs\u0001\u0001B(\u0005+\u00129\u0006\u0005\u0003\u0002,\nE\u0013\u0002\u0002B*\u0003[\u00131\u0001V1h\u0003\u00151\u0018\r\\;fC\t\u0011I&A\u0006j]R,wM]1uS>t\u0017!E)v_J,X\u000eV3ti\"\u000b'O\\3tgB\u0011\u0001\nL\n\u0003Ye\"\"A!\u0018\u00023i[7\t\\5f]R,e/\u001a8u)\"\u0014X-\u00193Tk\u001a4\u0017\u000e_\u000b\u0003\u0005O\u0002BA!\u001b\u0003p5\u0011!1\u000e\u0006\u0004\u0005[B\u0018\u0001\u00027b]\u001eLA!a\u001c\u0003l\u0005Q\"l[\"mS\u0016tG/\u0012<f]R$\u0006N]3bIN+hMZ5yA\u0005Q1/\u001a;Va\u000ec\u0017m]:)\u0007A\u00129\b\u0005\u0003\u0002,\ne\u0014\u0002\u0002B>\u0003[\u0013\u0011BQ3g_J,\u0017\t\u001c7\u0002\u001bQ,\u0017M\u001d#po:\u001cE.Y:tQ\r\t$\u0011\u0011\t\u0005\u0003W\u0013\u0019)\u0003\u0003\u0003\u0006\u00065&\u0001C!gi\u0016\u0014\u0018\t\u001c7")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private QuorumImplementation implementation;
    private Option<ClusterBalanceManager> clusterBalanceManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public boolean isKRaftTest() {
        return this.implementation() instanceof KRaftQuorumImplementation;
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public void restartControllerServer() {
        if (!this.isKRaftTest()) {
            throw new UnsupportedOperationException("Non-KRaft tests do not have a controller server");
        }
        this.asKRaft().restartController();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public Option<ClusterBalanceManager> clusterBalanceManager() {
        return this.clusterBalanceManager;
    }

    public void clusterBalanceManager_$eq(Option<ClusterBalanceManager> x$1) {
        this.clusterBalanceManager = x$1;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        String name;
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String string = name = testInfo.getTestMethod().isPresent() ? ((Method)testInfo.getTestMethod().get()).toString() : "[unspecified]";
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup) {
        return this.implementation().createBroker(config, time, startup);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    public KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), nodeId);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        Metrics controllerMetrics = new Metrics();
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        if (!props.containsKey(KafkaConfig$.MODULE$.ControllerListenerNamesProp())) {
            String proto = this.controllerListenerSecurityProtocol().toString();
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
            props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        }
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        props.setProperty(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = new KafkaConfig((Map)props);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        String threadNamePrefix = new StringBuilder(11).append("Controller_").append(testInfo.getDisplayName()).toString();
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        KafkaRaftManager raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)MetadataRecordSerde.INSTANCE, new TopicPartition(KafkaRaftServer$.MODULE$.MetadataTopic(), 0), KafkaRaftServer$.MODULE$.MetadataTopicId(), Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            this.clusterBalanceManager_$eq((Option<ClusterBalanceManager>)Option$.MODULE$.apply((Object)ClusterBalanceManager.clusterBalanceManager((KafkaConfig)config)));
            controllerServer.elem = new ControllerServer(metaProperties, config, (RaftManager)raftManager, this.clusterBalanceManager(), Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture, KafkaRaftServer$.MODULE$.configSchema(), ControllerServer$.MODULE$.$lessinit$greater$default$10());
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
            raftManager.startup();
        }
        catch (Throwable e2) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raftManager.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            this.clusterBalanceManager().foreach((Function1 & Serializable & scala.Serializable)c -> {
                QuorumTestHarness.$anonfun$newKRaftQuorum$5(this, c);
                return BoxedUnit.UNIT;
            });
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw e2;
        }
        return new KRaftQuorumImplementation((KafkaRaftManager<ApiMessageAndVersion>)raftManager, (ControllerServer)controllerServer.elem, metadataDir, controllerQuorumVotersFuture, metaProperties.clusterId(), this);
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        this.clusterBalanceManager().foreach((Function1 & Serializable & scala.Serializable)c -> {
            QuorumTestHarness.$anonfun$tearDown$1(this, c);
            return BoxedUnit.UNIT;
        });
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$newKRaftQuorum$5(QuorumTestHarness $this, ClusterBalanceManager c) {
        c.onLeaderUpdate(LeaderAndEpoch.UNKNOWN.leaderId());
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c.shutdown(), (Logging)$this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(QuorumTestHarness $this, ClusterBalanceManager c) {
        c.onLeaderUpdate(LeaderAndEpoch.UNKNOWN.leaderId());
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> c.shutdown(), (Logging)$this, CoreUtils$.MODULE$.swallow$default$3());
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.implementation = null;
        this.clusterBalanceManager = Option$.MODULE$.empty();
    }
}

