/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MockTopicCreatePolicy;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0005\u000b\u0001=AQ\u0001\u0006\u0001\u0005\u0002UAQa\u0006\u0001\u0005BaAQ!\u000b\u0001\u0005B)BQ!\u0010\u0001\u0005\u0002yBQa\u0011\u0001\u0005\n\u0011CQa\u0018\u0001\u0005\n\u0001DQa\u0019\u0001\u0005\n\u0011Dq!\u001e\u0001\u0012\u0002\u0013%aOA\u000fNKR\fG-\u0019;b%\u0016\fX/Z:u/&$\b\u000eU8mS\u000eLH+Z:u\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u000b\u0013\t\u0019\"BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0012\u0001\u00059\"M]8lKJ\u0004&o\u001c9feRLxJ^3se&$Wm\u001d\u000b\u00033}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011A!\u00168ji\")\u0001E\u0001a\u0001C\u0005Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001B;uS2T\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u000bM,G/\u00169\u0015\u0005eY\u0003\"\u0002\u0017\u0004\u0001\u0004i\u0013\u0001\u0003;fgRLeNZ8\u0011\u00059:T\"A\u0018\u000b\u0005A\n\u0014aA1qS*\u0011!gM\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!T'A\u0003kk:LGOC\u00017\u0003\ry'oZ\u0005\u0003q=\u0012\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u0007i\u0002\"AL\u001e\n\u0005qz#A\u0003\"fM>\u0014X-R1dQ\u0006AC/Z:u\u001b\u0016$\u0018\rZ1uC^KG\u000f[!vi>\u001c%/Z1uKJ+7\u000f]3diN\u0004v\u000e\\5dsR\t\u0011\u0004\u000b\u0002\u0005\u0001B\u0011a&Q\u0005\u0003\u0005>\u0012A\u0001V3ti\u0006yb/\u001a:jMf\u001cVoY2fgN4W\u000f\\!vi>\u001c%/Z1uKR{\u0007/[2\u0015\u0007e)%\u000bC\u0003G\u000b\u0001\u0007q)\u0001\tbkR|7I]3bi\u0016$Gk\u001c9jGB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"AS\u000e\u000e\u0003-S!\u0001\u0014\b\u0002\rq\u0012xn\u001c;?\u0013\tq5$\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(\u001c\u0011\u0015\u0019V\u00011\u0001U\u0003!\u0011Xm\u001d9p]N,\u0007CA+^\u001b\u00051&BA,Y\u0003!\u0011X-];fgR\u001c(BA-[\u0003\u0019\u0019w.\\7p]*\u0011Qb\u0017\u0006\u00039V\na!\u00199bG\",\u0017B\u00010W\u0005AiU\r^1eCR\f'+Z:q_:\u001cX-A\u0011wKJLg-_+ogV\u001c7-Z:tMVd\u0017)\u001e;p\u0007J,\u0017\r^3U_BL7\rF\u0002\u001aC\nDQA\u0012\u0004A\u0002\u001dCQa\u0015\u0004A\u0002Q\u000b1c]3oI6+G/\u00193bi\u0006\u0014V-];fgR$2\u0001V3k\u0011\u00151w\u00011\u0001h\u0003\u001d\u0011X-];fgR\u0004\"!\u00165\n\u0005%4&aD'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f-<\u0001\u0013!a\u0001Y\u0006YA-Z:uS:\fG/[8o!\rQRn\\\u0005\u0003]n\u0011aa\u00149uS>t\u0007C\u00019t\u001b\u0005\t(B\u0001:\r\u0003\u001dqW\r^<pe.L!\u0001^9\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002;M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\u0012a\u001e\u0016\u0003Yb\\\u0013!\u001f\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005y\\\u0012AC1o]>$\u0018\r^5p]&\u0019\u0011\u0011A>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class MetadataRequestWithPolicyTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
        properties.setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockTopicCreatePolicy.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @Test
    public void testMetadataWithAutoCreateRespectsPolicy() {
        String testAllowedTopic = "random-auto-created-topic";
        MetadataResponse responseForValidCreationPolicy = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testAllowedTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        this.verifySuccessfulAutoCreateTopic(testAllowedTopic, responseForValidCreationPolicy);
        String testDisallowedTopic = "disallowed-topic";
        MetadataResponse responseForInvalidCreationPolicy = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testDisallowedTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        this.verifyUnsuccessfulAutoCreateTopic(testDisallowedTopic, responseForInvalidCreationPolicy);
    }

    private void verifySuccessfulAutoCreateTopic(String autoCreatedTopic, MetadataResponse response) {
        Assertions.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, response.errors().get(autoCreatedTopic));
        Assertions.assertEquals((Object)new Some((Object)((KafkaServer)this.servers().head()).config().numPartitions()), (Object)this.zkClient().getTopicPartitionCount(autoCreatedTopic));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaServer)this.servers().head()).config().numPartitions())).foreach((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), autoCreatedTopic, BoxesRunTime.unboxToInt((Object)i), TestUtils$.MODULE$.waitForPartitionMetadata$default$4()));
    }

    private void verifyUnsuccessfulAutoCreateTopic(String autoCreatedTopic, MetadataResponse response) {
        Assertions.assertEquals((Object)Errors.TOPIC_AUTHORIZATION_FAILED, response.errors().get(autoCreatedTopic));
        Assertions.assertFalse((boolean)this.zkClient().topicExists(autoCreatedTopic));
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        return (MetadataResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }
}

