/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterLeadershipPriorityOptions;
import org.apache.kafka.clients.admin.AlterLeadershipPrioritySpec;
import org.apache.kafka.clients.admin.BrokerLeadershipPriorityResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.AlterLeadershipPriorityRequestData;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityRequest;
import org.apache.kafka.common.requests.AlterLeadershipPriorityResponse;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityRequest;
import org.apache.kafka.common.requests.DescribeLeadershipPriorityResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001\u0002\u0013&\u0001)BQa\f\u0001\u0005\u0002ABqA\r\u0001A\u0002\u0013\u00051\u0007C\u0004B\u0001\u0001\u0007I\u0011\u0001\"\t\r-\u0003\u0001\u0015)\u00035\u0011\u001da\u0005A1A\u0005\u00025CaA\u0016\u0001!\u0002\u0013q\u0005bB,\u0001\u0005\u0004%\t\u0001\u0017\u0005\u00079\u0002\u0001\u000b\u0011B-\t\u000fu\u0003!\u0019!C\u00011\"1a\f\u0001Q\u0001\neCqa\u0018\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004a\u0001\u0001\u0006I!\u0017\u0005\u0006C\u0002!\tE\u0019\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006s\u0002!\t\u0001\u001e\u0005\u0006w\u0002!\t\u0001\u001e\u0005\u0006{\u0002!\t\u0001\u001e\u0005\u0006\u007f\u0002!\t\u0001\u001e\u0005\u0007\u0003\u0007\u0001A\u0011\u0001;\t\r\u0005\u001d\u0001\u0001\"\u0001u\u0011\u0019\tY\u0001\u0001C\u0001i\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003\u001f\u0003A\u0011BAI\u0011%\tY\u000eAI\u0001\n\u0013\ti\u000eC\u0005\u0002t\u0002\t\n\u0011\"\u0003\u0002v\"I\u0011\u0011 \u0001\u0012\u0002\u0013%\u00111 \u0005\n\u0003\u007f\u0004\u0011\u0013!C\u0005\u0005\u0003AqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003,\u0001!IA!\f\t\u000f\tE\u0002\u0001\"\u0003\u00034!9!q\u0007\u0001\u0005\n\te\u0002b\u0002B\"\u0001\u0011%!Q\t\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/\u0012a\u0003T3bI\u0016\u00148\u000f[5q!JLwN]5usR+7\u000f\u001e\u0006\u0003M\u001d\naa]3sm\u0016\u0014(\"\u0001\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000b\t\u0003Y5j\u0011!J\u0005\u0003]\u0015\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"\u0001\f\u0001\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0002iA\u0011QgP\u0007\u0002m)\u0011q\u0007O\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003si\nqa\u00197jK:$8O\u0003\u0002)w)\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h\u0013\t\u0001eG\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u001f\u0005$W.\u001b8DY&,g\u000e^0%KF$\"aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u000e\t\t\u00111\u00015\u0003\rAH%M\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\ni>\u0004\u0018n\u0019(b[\u0016,\u0012A\u0014\t\u0003\u001fRk\u0011\u0001\u0015\u0006\u0003#J\u000bA\u0001\\1oO*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u0019\u0019FO]5oO\u0006QAo\u001c9jG:\u000bW.\u001a\u0011\u0002\u0005A\u0004T#A-\u0011\u0005\u0011S\u0016BA.F\u0005\rIe\u000e^\u0001\u0004aB\u0002\u0013A\u000192\u0003\r\u0001\u0018\u0007I\u0001\u0003aJ\n1\u0001\u001d\u001a!\u0003\u0015\u0019X\r^+q)\t\u00195\rC\u0003e\u001b\u0001\u0007Q-\u0001\u0005uKN$\u0018J\u001c4p!\t1W.D\u0001h\u0015\tA\u0017.A\u0002ba&T!A[6\u0002\u000f),\b/\u001b;fe*\u0011A.P\u0001\u0006UVt\u0017\u000e^\u0005\u0003]\u001e\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0003\u001bA\u0004\"AZ9\n\u0005I<'A\u0003\"fM>\u0014X-R1dQ\u0006)C/Z:u\u00032$XM\u001d'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jif<\u0016\u000e\u001e5U_BL7m\u001d\u000b\u0002\u0007\"\u0012aB\u001e\t\u0003M^L!\u0001_4\u0003\tQ+7\u000f^\u00012i\u0016\u001cH/\u00117uKJdU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=XSRD7i\u001c8ue>dG.\u001a:GC&dwN^3sQ\tya/\u0001\u001auKN$8i\u001c8ue>dG.\u001a:GC&dwN^3s\u00136lW\rZ5bi\u0016d\u00170\u00114uKJ$U-\\8uK\n\u0013xn[3sQ\t\u0001b/A\u000euKN$\u0018\t\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f\u0015\u0003#Y\fa\u0004^3ti\u0006cG/\u001a:MK\u0006$WM]:iSBLE-Z7q_R,gnY3)\u0005I1\u0018\u0001\u000f;fgR\fE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018\u0010S1oI2,7OT8u\u0007>tGO]8mY\u0016\u0014X\t_2faRLwN\u001c\u0015\u0003'Y\f\u0011\b^3ti\u0006cG/\u001a:MK\u0006$WM]:iSB\u0004&/[8sSRL\b*\u00198eY\u0016\u001c\u0018J\u001c<bY&$'+Z9vKN$X\t_2faRLwN\u001c\u0015\u0003)Y\f1\b^3ti\u0012+7o\u0019:jE\u0016dU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=IC:$G.Z:O_R\u001cuN\u001c;s_2dWM]#yG\u0016\u0004H/[8oQ\t)b/\u0001\u0013de\u0016\fG/\u001a\"s_.,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5usJ+7/\u001e7u)!\t\u0019\"a\u0011\u0002H\u0005\u0005\u0004\u0003BA\u000b\u0003{qA!a\u0006\u000289!\u0011\u0011DA\u0019\u001d\u0011\tY\"!\f\u000f\t\u0005u\u00111\u0006\b\u0005\u0003?\tIC\u0004\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#K\u0001\u0007yI|w\u000e\u001e \n\u0003yJ!\u0001P\u001f\n\u0005!Z\u0014bAA\u0018u\u000511m\\7n_:LA!a\r\u00026\u00059Q.Z:tC\u001e,'bAA\u0018u%!\u0011\u0011HA\u001e\u0003\r\nE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018PU3ta>t7/\u001a#bi\u0006TA!a\r\u00026%!\u0011qHA!\u0005y\u0011%o\\6fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f*fgVdGO\u0003\u0003\u0002:\u0005m\u0002BBA#-\u0001\u0007\u0011,\u0001\u0005ce>\\WM]%e\u0011\u001d\tIE\u0006a\u0001\u0003\u0017\na\u0003\\3bI\u0016\u00148\u000f[5q!JLwN]5us\u0016sW/\u001c\t\u0005\u0003\u001b\nYF\u0004\u0003\u0002P\u0005]c\u0002BA)\u0003+rA!a\u0007\u0002T%\u0011\u0011HO\u0005\u0003oaJ1!!\u00177\u0003y\u0011%o\\6fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/\u001f*fgVdG/\u0003\u0003\u0002^\u0005}#A\u0006'fC\u0012,'o\u001d5jaB\u0013\u0018n\u001c:jif,e.^7\u000b\u0007\u0005ec\u0007C\u0004\u0002dY\u0001\r!!\u001a\u0002\u000b\u0015\u0014(o\u001c:\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SRA!a\u001b\u00026\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002p\u0005%$AB#se>\u00148/\u0001\rhKRdU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=NCB,\"!!\u001e\u0011\u000f\u0005]\u0014qP-\u0002\u0006:!\u0011\u0011PA>!\r\t\t#R\u0005\u0004\u0003{*\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0006\r%aA'ba*\u0019\u0011QP#\u0011\r\u0005]\u0014qQAF\u0013\u0011\tI)a!\u0003\u0007M+G\u000f\u0005\u0003\u0002x\u00055\u0015bA+\u0002\u0004\u0006)\u0013\r\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/_!oI\u001e+GOU3ta>t7/\u001a\u000b\u000b\u0003'\u000by*!.\u0002:\u0006-\u0007\u0003BAK\u00037k!!a&\u000b\t\u0005e\u0015QG\u0001\te\u0016\fX/Z:ug&!\u0011QTAL\u0005}\tE\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u0018PU3ta>t7/\u001a\u0005\n\u0003CC\u0002\u0013!a\u0001\u0003G\u000b\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u000b\u0005\u0015\u0016qV-\u000f\t\u0005\u001d\u00161\u0016\b\u0005\u0003C\tI+C\u0001G\u0013\r\ti+R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0007M+\u0017OC\u0002\u0002.\u0016C\u0011\"a.\u0019!\u0003\u0005\r!a#\u0002\rI,\u0017m]8o\u0011%\tY\f\u0007I\u0001\u0002\u0004\ti,A\u000bqe&|'/\u001b;z\u001fB,'/\u0019;j_:,e.^7\u0011\t\u0005}\u0016Q\u0019\b\u0005\u0003\u001f\n\t-C\u0002\u0002DZ\n1$\u00117uKJdU-\u00193feND\u0017\u000e\u001d)sS>\u0014\u0018\u000e^=Ta\u0016\u001c\u0017\u0002BAd\u0003\u0013\u0014Q\u0003\u0015:j_JLG/_(qKJ\fG/[8o\u000b:,XNC\u0002\u0002DZB\u0011\"!4\u0019!\u0003\u0005\r!a4\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0011\t\u0005E\u0017q[\u0007\u0003\u0003'T1!!6(\u0003\u001dqW\r^<pe.LA!!7\u0002T\na1k\\2lKR\u001cVM\u001d<fe\u0006y\u0013\r\u001c;fe2+\u0017\rZ3sg\"L\u0007\u000f\u0015:j_JLG/_!oI\u001e+GOU3ta>t7/\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001c\u0016\u0005\u0003G\u000b\to\u000b\u0002\u0002dB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018!C;oG\",7m[3e\u0015\r\ti/R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAy\u0003O\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=\nG\u000e^3s\u0019\u0016\fG-\u001a:tQ&\u0004\bK]5pe&$\u00180\u00118e\u000f\u0016$(+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t9P\u000b\u0003\u0002\f\u0006\u0005\u0018aL1mi\u0016\u0014H*Z1eKJ\u001c\b.\u001b9Qe&|'/\u001b;z\u0003:$w)\u001a;SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001aTCAA\u007fU\u0011\ti,!9\u0002_\u0005dG/\u001a:MK\u0006$WM]:iSB\u0004&/[8sSRL\u0018I\u001c3HKR\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r!\u0006BAh\u0003C\f1b\u0019:fCR,Gk\u001c9jGR91I!\u0003\u0003\u0012\tM\u0001B\u0002\u001a\u001e\u0001\u0004\u0011Y\u0001E\u00026\u0005\u001bI1Aa\u00047\u0005\u0015\tE-\\5o\u0011\u0019aU\u00041\u0001\u0002\f\"9!QC\u000fA\u0002\t]\u0011a\u0004;pa&\u001c\u0017i]:jO:lWM\u001c;\u0011\u000f\te!1E-\u0003&5\u0011!1\u0004\u0006\u0005\u0005;\u0011y\"A\u0005j[6,H/\u00192mK*\u0019!\u0011E#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0002\nm\u0001#\u0002B\r\u0005OI\u0016\u0002\u0002B\u0015\u00057\u0011A\u0001T5ti\u0006aA-Z7pi\u0016\u0014%o\\6feR\u00191Ia\f\t\r\u0005\u0015c\u00041\u0001Z\u00035\u0001(o\\7pi\u0016\u0014%o\\6feR\u00191I!\u000e\t\r\u0005\u0015s\u00041\u0001Z\u0003\u00052\u0018\r\\5eCR,gj\u001c'fC\u0012,'o](o\t\u0016lw\u000e^3e\u0005J|7.\u001a:t)\u0015\u0019%1\bB\u001f\u0011\u0019a\u0005\u00051\u0001\u0002\f\"9!q\b\u0011A\u0002\t\u0005\u0013\u0001\u00053f[>$X\r\u001a\"s_.,'/\u00133t!\u0015\t9(a\"Z\u0003\u00192\u0018\r\\5eCR,G*Z1eKJ\u001c\bK]3tK:$xJ\u001c)s_6|G/\u001a3Ce>\\WM\u001d\u000b\u0006\u0007\n\u001d#\u0011\n\u0005\u0007\u0019\u0006\u0002\r!a#\t\r\u0005\u0015\u0013\u00051\u0001Z\u0003\t2\u0018\r\\5eCR,G*Z1eKJ\u001c\bK]3tK:$xJ\\!mY\n\u0013xn[3sgR)1Ia\u0014\u0003R!1AJ\ta\u0001\u0003\u0017CaAa\u0015#\u0001\u0004I\u0016a\u00048v[\n,'o\u00144Ce>\\WM]:\u0002\u001b\rDWmY6SKN\u0004xN\\:f)\u0015\u0019%\u0011\fB1\u0011\u001d\u0011Yf\ta\u0001\u0005;\nq\"\u001a=qK\u000e$X\r\u001a*fgVdGo\u001d\t\u0007\u0003K\u0013y&a\u0005\n\t\t%\u00121\u0017\u0005\b\u0005G\u001a\u0003\u0019\u0001B3\u00039\t7\r^;bYJ+7\u000f]8og\u0016\u0004BAa\u001a\u0003j5\u0011\u00111H\u0005\u0005\u0005W\nYDA\u0012BYR,'\u000fT3bI\u0016\u00148\u000f[5q!JLwN]5usJ+7\u000f]8og\u0016$\u0015\r^1")
public class LeadershipPriorityTest
extends BaseRequestTest {
    private ConfluentAdmin adminClient = null;
    private final String topicName;
    private final int p0;
    private final int p1;
    private final int p2;

    public ConfluentAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(ConfluentAdmin x$1) {
        this.adminClient = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int p0() {
        return this.p0;
    }

    public int p1() {
        return this.p1;
    }

    public int p2() {
        return this.p2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.adminClient_$eq(this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p0())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p1())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.p2())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopic((Admin)this.adminClient(), this.topicName(), (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
    }

    @Test
    public void testAlterLeadershipPriorityWithTopics() {
        this.demoteBroker(0);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        this.promoteBroker(0);
        this.validateLeadersPresentOnPromotedBroker(this.topicName(), 0);
        this.demoteBroker(0);
        this.demoteBroker(1);
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        this.demoteBroker(2);
        this.validateLeadersPresentOnAllBrokers(this.topicName(), 3);
    }

    @Test
    public void testAlterLeadershipPriorityWithControllerFailover() {
        this.demoteBroker(0);
        KafkaServer controller = this.getController();
        controller.shutdown();
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        controller.startup();
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), controller.config().brokerId());
        this.validateNoLeadersOnDemotedBrokers(this.topicName(), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerFailoverImmediatelyAfterDemoteBroker() {
        this.killAllBrokers();
        this.zkClient().setLeadershipPriorityState((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})));
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.adminClientConfig().put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(this.servers(), this.listenerName()));
        this.adminClient_$eq(this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()));
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 2);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 1);
        TestUtils$.MODULE$.waitForOnlineBroker((Admin)this.adminClient(), 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testAlterLeadershipPriority() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(2, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(2, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), "reason2", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason", "reason2"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(3, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason", "reason2"})))})), this.getLeadershipPriorityMap());
    }

    @Test
    public void testAlterLeadershipIdempotence() {
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(1, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.DEMOTED, Errors.NONE), (List)Nil$.MODULE$)), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), "reason", this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        this.checkResponse((List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult>)new .colon.colon((Object)this.createBrokerLeadershipPriorityResult(0, BrokerLeadershipPriorityResult.LeadershipPriorityEnum.NORMAL, Errors.NONE), (List)Nil$.MODULE$), this.alterLeadershipPriorityAndGetResponse((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), "reason", AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, this.alterLeadershipPriorityAndGetResponse$default$4()).data());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})))})), this.getLeadershipPriorityMap());
    }

    @Test
    public void testAlterLeadershipPriorityHandlesNotControllerException() {
        SocketServer x$1 = this.notControllerSocketServer();
        Seq<Object> x$2 = this.alterLeadershipPriorityAndGetResponse$default$1();
        String x$3 = this.alterLeadershipPriorityAndGetResponse$default$2();
        AlterLeadershipPrioritySpec.PriorityOperationEnum x$4 = this.alterLeadershipPriorityAndGetResponse$default$3();
        AlterLeadershipPriorityResponse response = this.alterLeadershipPriorityAndGetResponse(x$2, x$3, x$4, x$1);
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    @Test
    public void testAlterLeadershipPriorityHandlesInvalidRequestException() {
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)this.alterLeadershipPriorityAndGetResponse(this.alterLeadershipPriorityAndGetResponse$default$1(), this.alterLeadershipPriorityAndGetResponse$default$2(), this.alterLeadershipPriorityAndGetResponse$default$3(), this.alterLeadershipPriorityAndGetResponse$default$4()).data().errorCode());
    }

    @Test
    public void testDescribeLeadershipPriorityHandlesNotControllerException() {
        DescribeLeadershipPriorityRequest request = (DescribeLeadershipPriorityRequest)new DescribeLeadershipPriorityRequest.Builder().build();
        DescribeLeadershipPriorityResponse response = (DescribeLeadershipPriorityResponse)this.connectAndReceive((AbstractRequest)request, this.notControllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeLeadershipPriorityResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.NOT_CONTROLLER.code(), (short)response.data().errorCode());
    }

    private AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult createBrokerLeadershipPriorityResult(int brokerId, BrokerLeadershipPriorityResult.LeadershipPriorityEnum leadershipPriorityEnum, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        String msg = !(errors != null ? !errors.equals(errors2) : errors2 != null) ? "" : error.message();
        return new AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult().setBrokerId(brokerId).setLeadershipPriority(leadershipPriorityEnum.id()).setErrorCode(error.code()).setErrorMessage(msg);
    }

    private scala.collection.immutable.Map<Object, scala.collection.immutable.Set<String>> getLeadershipPriorityMap() {
        DescribeLeadershipPriorityRequest request = (DescribeLeadershipPriorityRequest)new DescribeLeadershipPriorityRequest.Builder().build();
        DescribeLeadershipPriorityResponse response = (DescribeLeadershipPriorityResponse)this.connectAndReceive((AbstractRequest)request, this.controllerSocketServer(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeLeadershipPriorityResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)response.data().errorCode());
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        response.data().demotedBrokers().forEach(demotedBroker -> {
            scala.collection.mutable.Set reasons = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            demotedBroker.reasons().forEach(reason -> reasons.add((Object)reason.reason()));
            result.put((Object)BoxesRunTime.boxToInteger((int)demotedBroker.brokerId()), (Object)reasons.toSet());
        });
        return result.toMap(Predef$.MODULE$.$conforms());
    }

    private AlterLeadershipPriorityResponse alterLeadershipPriorityAndGetResponse(Seq<Object> brokerIds, String reason, AlterLeadershipPrioritySpec.PriorityOperationEnum priorityOperationEnum, SocketServer socketServer) {
        AlterLeadershipPriorityRequest request = (AlterLeadershipPriorityRequest)new AlterLeadershipPriorityRequest.Builder(new AlterLeadershipPriorityRequestData().setBrokerIds((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokerIds.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)x), Seq$.MODULE$.canBuildFrom())).asJava()).setReason(reason).setPriorityOperationCode(priorityOperationEnum.id())).build();
        return (AlterLeadershipPriorityResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterLeadershipPriorityResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Seq<Object> alterLeadershipPriorityAndGetResponse$default$1() {
        return Nil$.MODULE$;
    }

    private String alterLeadershipPriorityAndGetResponse$default$2() {
        return "";
    }

    private AlterLeadershipPrioritySpec.PriorityOperationEnum alterLeadershipPriorityAndGetResponse$default$3() {
        return AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE;
    }

    private SocketServer alterLeadershipPriorityAndGetResponse$default$4() {
        return this.controllerSocketServer();
    }

    private void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = x0$1._1$mcI$sp();
            List value = (List)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)value.map((Function1 & Serializable & scala.Serializable)x -> LeadershipPriorityTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    private void demoteBroker(int brokerId) {
        this.adminClient().alterLeadershipPriority(new AlterLeadershipPrioritySpec((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.DEMOTE, "testing"), new AlterLeadershipPriorityOptions()).all().get();
    }

    private void promoteBroker(int brokerId) {
        this.adminClient().alterLeadershipPriority(new AlterLeadershipPrioritySpec((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{BoxesRunTime.boxToInteger((int)brokerId)}))).asJava(), AlterLeadershipPrioritySpec.PriorityOperationEnum.PROMOTE, "testing"), new AlterLeadershipPriorityOptions()).all().get();
    }

    /*
     * WARNING - void declaration
     */
    private void validateNoLeadersOnDemotedBrokers(String topicName, scala.collection.immutable.Set<Object> demotedBrokerIds) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$1(this, topicName, demotedBrokerIds)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnPromotedBroker(String topicName, int brokerId) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$1(this, topicName, brokerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$4(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateLeadersPresentOnAllBrokers(String topicName, int numberOfBrokers) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeadershipPriorityTest.$anonfun$validateLeadersPresentOnAllBrokers$1(this, topicName, numberOfBrokers)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnAllBrokers$3(topicName));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void checkResponse(List<AlterLeadershipPriorityResponseData.BrokerLeadershipPriorityResult> expectedResults, AlterLeadershipPriorityResponseData actualResponse) {
        Assertions.assertEquals((int)expectedResults.size(), (int)actualResponse.brokerLeadershipPriorityResults().size());
        expectedResults.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)expectedResults.apply(i), actualResponse.brokerLeadershipPriorityResults().get(i)));
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(TopicPartitionInfo p) {
        return p.leader().id() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$1(LeadershipPriorityTest $this) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList($this.topicName())).topicNameValues().get($this.topicName())).get();
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$2(p)), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$testControllerFailoverImmediatelyAfterDemoteBroker$4(LeadershipPriorityTest $this) {
        return new StringBuilder(45).append("Topic ").append($this.topicName()).append(" does not have all leaders on broker 2.").toString();
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$2(scala.collection.immutable.Set demotedBrokerIds$1, TopicPartitionInfo p) {
        return !demotedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)p.leader().id()));
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$3(boolean x, boolean y) {
        return x && y;
    }

    public static final /* synthetic */ boolean $anonfun$validateNoLeadersOnDemotedBrokers$1(LeadershipPriorityTest $this, String topicName$1, scala.collection.immutable.Set demotedBrokerIds$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$1)).topicNameValues().get(topicName$1)).get();
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$2(demotedBrokerIds$1, p)), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateNoLeadersOnDemotedBrokers$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateNoLeadersOnDemotedBrokers$4(String topicName$1) {
        return new StringBuilder(38).append("Topic ").append(topicName$1).append(" has a demoted broker as leader.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$2(int brokerId$1, TopicPartitionInfo p) {
        return p.leader().id() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$3(boolean x, boolean y) {
        return x || y;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnPromotedBroker$1(LeadershipPriorityTest $this, String topicName$2, int brokerId$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$2)).topicNameValues().get(topicName$2)).get();
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$2(brokerId$1, p)), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnPromotedBroker$3(BoxesRunTime.unboxToBoolean((Object)x), BoxesRunTime.unboxToBoolean((Object)y)))));
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnPromotedBroker$4(String topicName$2) {
        return new StringBuilder(41).append("Topic ").append(topicName$2).append(" has no leaders on promoted broker.").toString();
    }

    public static final /* synthetic */ int $anonfun$validateLeadersPresentOnAllBrokers$2(TopicPartitionInfo p) {
        return p.leader().id();
    }

    public static final /* synthetic */ boolean $anonfun$validateLeadersPresentOnAllBrokers$1(LeadershipPriorityTest $this, String topicName$3, int numberOfBrokers$1) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)$this.adminClient().describeTopics(Collections.singletonList(topicName$3)).topicNameValues().get(topicName$3)).get();
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)LeadershipPriorityTest.$anonfun$validateLeadersPresentOnAllBrokers$2(p)), Buffer$.MODULE$.canBuildFrom())).toSet().size() == numberOfBrokers$1;
    }

    public static final /* synthetic */ String $anonfun$validateLeadersPresentOnAllBrokers$3(String topicName$3) {
        return new StringBuilder(44).append("Topic ").append(topicName$3).append(" does not have leaders on all brokers.").toString();
    }

    public LeadershipPriorityTest() {
        this.topicName = "topic";
        this.p0 = 0;
        this.p1 = 1;
        this.p2 = 2;
    }
}

