/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000114A\u0001E\t\u0001-!)1\u0004\u0001C\u00019!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0014\u0001A\u0003%\u0001\u0005C\u0004(\u0001\t\u0007I\u0011A\u0010\t\r!\u0002\u0001\u0015!\u0003!\u0011\u001dI\u0003\u00011A\u0005\u0002)BqA\u000f\u0001A\u0002\u0013\u00051\b\u0003\u0004B\u0001\u0001\u0006Ka\u000b\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0011\u001d9\u0005\u00011A\u0005\u0002!CaA\u0013\u0001!B\u0013!\u0005\"B&\u0001\t\u0003b\u0005\"B0\u0001\t\u0003\u0002\u0007\"B3\u0001\t\u0003\u0001\u0007\"\u00026\u0001\t\u0003\u0001'A\u0005'fC\u0012,'/\u00127fGRLwN\u001c+fgRT!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\r\u000e\u0003EI!AG\t\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\nEJ|7.\u001a:JIF*\u0012\u0001\t\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0004\u0013:$\u0018A\u00032s_.,'/\u001332A\u0005I!M]8lKJLEMM\u0001\u000bEJ|7.\u001a:JIJ\u0002\u0013aB:feZ,'o]\u000b\u0002WA\u0019A\u0006N\u001c\u000f\u00055\u0012dB\u0001\u00182\u001b\u0005y#B\u0001\u0019\u0016\u0003\u0019a$o\\8u}%\t1%\u0003\u00024E\u00059\u0001/Y2lC\u001e,\u0017BA\u001b7\u0005\r\u0019V-\u001d\u0006\u0003g\t\u0002\"\u0001\u0007\u001d\n\u0005e\n\"aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0011Ah\u0010\t\u0003CuJ!A\u0010\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u001e\t\t\u00111\u0001,\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005a2\u000f^1mK\u000e{g\u000e\u001e:pY2,'/\u00129pG\"$U\r^3di\u0016$W#\u0001#\u0011\u0005\u0005*\u0015B\u0001$#\u0005\u001d\u0011un\u001c7fC:\f\u0001e\u001d;bY\u0016\u001cuN\u001c;s_2dWM]#q_\u000eDG)\u001a;fGR,Gm\u0018\u0013fcR\u0011A(\u0013\u0005\b\u0001*\t\t\u00111\u0001E\u0003u\u0019H/\u00197f\u0007>tGO]8mY\u0016\u0014X\t]8dQ\u0012+G/Z2uK\u0012\u0004\u0013!B:fiV\u0003HC\u0001\u001fN\u0011\u0015qE\u00021\u0001P\u0003!!Xm\u001d;J]\u001a|\u0007C\u0001)Z\u001b\u0005\t&B\u0001*T\u0003\r\t\u0007/\u001b\u0006\u0003)V\u000bqA[;qSR,'O\u0003\u0002W/\u0006)!.\u001e8ji*\t\u0001,A\u0002pe\u001eL!AW)\u0003\u0011Q+7\u000f^%oM>D#\u0001\u0004/\u0011\u0005Ak\u0016B\u00010R\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\tA\b\u000b\u0002\u000eEB\u0011\u0001kY\u0005\u0003IF\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u00025Q,7\u000f\u001e'fC\u0012,'/\u00127fGRLwN\\!oI\u0016\u0003xn\u00195)\u000599\u0007C\u0001)i\u0013\tI\u0017K\u0001\u0003UKN$\u0018A\u000b;fgRdU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5Ti\u0006dWmQ8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0015\u0003\u001f\u001d\u0004")
public class LeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private boolean staleControllerEpochDetected = false;

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public boolean staleControllerEpochDetected() {
        return this.staleControllerEpochDetected;
    }

    public void staleControllerEpochDetected_$eq(boolean x$1) {
        this.staleControllerEpochDetected = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties configProps1 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Properties configProps2 = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        configProps1.put("unclean.leader.election.enable", "true");
        configProps2.put("unclean.leader.election.enable", "true");
        KafkaServer server1 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps1), TestUtils$.MODULE$.createServer$default$2());
        KafkaServer server2 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(configProps2), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionAndEpoch() {
        void var6_11;
        Tuple2 tuple2;
        String topic = "new-topic";
        int partitionId = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(topicPartition).get());
        Assertions.assertTrue((leader1 == 0 ? 1 : 0) != 0, (String)"Leader should be broker 0");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        ((KafkaServer)this.servers().head()).shutdown();
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Option computeUntilTrue_result;
            if ((computeUntilTrue_result = LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$1(this, topicPartition)).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == 1)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option leader2 = (Option)tuple2._1();
        int leaderEpoch2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)(leaderEpoch1 + 2), (int)leaderEpoch2, (String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch1 + 2))})));
        ((KafkaServer)this.servers().head()).startup();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$4(this, topic, partitionId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.servers().last()).shutdown();
        Thread.sleep(this.zookeeper().tickTime());
        KafkaZkClient x$1 = this.zkClient();
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int leader3 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, topic, partitionId, x$5, (Option<Object>)var6_11, x$6);
        int leaderEpoch3 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        Assertions.assertEquals((int)0, (int)leader3, (String)"Leader must return to 0");
        Assertions.assertEquals((int)(leaderEpoch2 + 2), (int)leaderEpoch3, (String)new StringOps(Predef$.MODULE$.augmentString("Second epoch value should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(leaderEpoch2 + 2))})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderElectionWithStaleControllerEpoch() {
        String topic = "new-topic";
        int partitionId = 0;
        int leader1 = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        int leaderEpoch1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getEpochForPartition(new TopicPartition(topic, partitionId)).get());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("leader Epoch: ").append(leaderEpoch1).toString());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Leader is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leader1)})));
        Assertions.assertTrue((leader1 == 0 || leader1 == 1 ? 1 : 0) != 0, (String)"Leader could be broker 0 or broker 1");
        Assertions.assertEquals((int)0, (int)leaderEpoch1, (String)"First epoch value should be 0");
        int controllerId = 2;
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaBroker)s, TestUtils$.MODULE$.boundPort$default$2()), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)s.kafkaController().brokerEpoch())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.node(listenerName), Iterable$.MODULE$.canBuildFrom());
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokers((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
        controllerChannelManager.startup();
        try {
            int staleControllerEpoch = 0;
            LeaderAndIsrBatch batch = new LeaderAndIsrBatch(this.brokerId2()).setControllerId(controllerId).setControllerEpoch(staleControllerEpoch).setBrokerEpoch(((KafkaServer)this.servers().apply(this.brokerId2())).kafkaController().brokerEpoch()).addPartitionState(new TopicPartition(topic, partitionId), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(topic).setPartitionIndex(partitionId).setControllerEpoch(2).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(false)).addLiveLeaders(nodes.toSet()).addTopicId(topic, Uuid.randomUuid());
            BooleanRef staleControllerEpochDetected = BooleanRef.create((boolean)false);
            controllerChannelManager.sendControlMetadataBatch(this.brokerId2(), (ControlMetadataBatch)batch, (Function2 & Serializable & scala.Serializable)(x$5, result) -> {
                LeaderElectionTest.$anonfun$testLeaderElectionWithStaleControllerEpoch$7(staleControllerEpochDetected, x$5, result);
                return BoxedUnit.UNIT;
            });
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!staleControllerEpochDetected.elem) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)LeaderElectionTest.$anonfun$testLeaderElectionWithStaleControllerEpoch$10());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)staleControllerEpochDetected.elem, (String)"Stale controller epoch not detected by the broker");
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    public static final /* synthetic */ Option $anonfun$testLeaderElectionAndEpoch$1(LeaderElectionTest $this, TopicPartition topicPartition$1) {
        return $this.zkClient().getLeaderForPartition(topicPartition$1);
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$5(UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.isr().size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderElectionAndEpoch$4(LeaderElectionTest $this, String topic$1, int partitionId$1) {
        return ((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo(topic$1, partitionId$1).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LeaderElectionTest.$anonfun$testLeaderElectionAndEpoch$5(x$3)));
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionAndEpoch$6() {
        return "Inconsistent metadata after second broker startup";
    }

    public static final /* synthetic */ void $anonfun$testLeaderElectionWithStaleControllerEpoch$7(BooleanRef staleControllerEpochDetected$1, ControlMetadataBatch x$5, ControlMetadataBatchResult result) {
        Errors error;
        Errors errors = error = (Errors)result.responses().foldLeft((Object)Errors.NONE, (Function2 & Serializable & scala.Serializable)(x$6, response) -> response.error());
        Errors errors2 = Errors.STALE_CONTROLLER_EPOCH;
        staleControllerEpochDetected$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ String $anonfun$testLeaderElectionWithStaleControllerEpoch$10() {
        return "Controller epoch should be stale";
    }

    public LeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }

    public static final /* synthetic */ Object $anonfun$testLeaderElectionAndEpoch$2$adapted(Option x$1) {
        return BoxesRunTime.boxToBoolean((boolean)x$1.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == 1));
    }
}

