/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002B\u0002\u0016\u0001A\u0003%Q\u0004C\u0003,\u0001\u0011\u0005A\u0006C\u0003<\u0001\u0011\u0005A\u0006C\u0003>\u0001\u0011\u0005A\u0006C\u0003@\u0001\u0011%\u0001\tC\u0003G\u0001\u0011%q\tC\u0003N\u0001\u0011%aJA\fLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000fV3ti*\u0011A\"D\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00039\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001#A\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\r\u0011\u0005i\u0001Q\"A\u0006\u0002\tQLW.Z\u000b\u0002;A\u0011a\u0004K\u0007\u0002?)\u0011\u0001%I\u0001\u0006kRLGn\u001d\u0006\u0003E\r\naaY8n[>t'B\u0001\b%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%z\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002'Q,7\u000f\u001e*fcV,7\u000f\u001e$jYR,'/\u001a3\u0015\u00035\u0002\"A\u0005\u0018\n\u0005=\u001a\"\u0001B+oSRD#\u0001B\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014aA1qS*\u0011agN\u0001\bUV\u0004\u0018\u000e^3s\u0015\tAd%A\u0003kk:LG/\u0003\u0002;g\t!A+Z:u\u0003Y!Xm\u001d;SKF,Xm\u001d;O_R4\u0015\u000e\u001c;fe\u0016$\u0007FA\u00032\u0003E!Xm\u001d;F]\u001eLg.Z'fiJL7m\u001d\u0015\u0003\rE\naB]3dK&4XMU3rk\u0016\u001cH\u000f\u0006\u0002B\tB\u0011aDQ\u0005\u0003\u0007~\u0011\u0011\u0002T8h\u0003\u000e$\u0018n\u001c8\t\u000b\u0015;\u0001\u0019A!\u0002\u00131|w-Q2uS>t\u0017\u0001\u0006;fgR\u0014V-];fgR4\u0015\u000e\u001c;fe&tw\r\u0006\u0002.\u0011\")\u0011\n\u0003a\u0001\u0015\u0006\t\u0012n\u001d*fcV,7\u000f\u001e$jYR,'/\u001a3\u0011\u0005IY\u0015B\u0001'\u0014\u0005\u001d\u0011un\u001c7fC:\f\u0001CY;jY\u0012$Vm\u001d;SKF,Xm\u001d;\u0015\u0003=\u0003\"\u0001\u0015,\u000f\u0005E#V\"\u0001*\u000b\u0005Mk\u0011a\u00028fi^|'o[\u0005\u0003+J\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002X1\n9!+Z9vKN$(BA+S\u0001")
public class KafkaRequestHandlerTest {
    private final MockTime time = new MockTime();

    public MockTime time() {
        return this.time;
    }

    @Test
    public void testRequestFiltered() {
        this.testRequestFiltering(true);
    }

    @Test
    public void testRequestNotFiltered() {
        this.testRequestFiltering(false);
    }

    @Test
    public void testEngineMetrics() {
        ThreadCountersManager.threadCountersManagerEnabled = true;
        Thread thread = new Thread(() -> {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            this.receiveRequest(LogAction.NOT_LOGGED);
        });
        thread.start();
        thread.join();
        Map threadLocalCountersForAllThreads = ThreadCountersManager.getThreadLocalCounterSnapshotForAllKnownThreads();
        Assertions.assertTrue((boolean)threadLocalCountersForAllThreads.containsKey(thread));
        ((List)threadLocalCountersForAllThreads.get(thread)).forEach(counter -> {
            block7: {
                block6: {
                    ThreadLocalCounters.MetricComponentType metricComponentType;
                    ThreadLocalCounters.MetricComponentType metricComponentType2;
                    block5: {
                        Assertions.assertEquals((Object)counter.threadGroupType, (Object)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
                        metricComponentType2 = counter.metricComponentType;
                        metricComponentType = ThreadLocalCounters.MetricComponentType.ENGINE;
                        if (metricComponentType2 != null) break block5;
                        if (metricComponentType != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!metricComponentType2.equals(metricComponentType)) break block7;
                }
                Assertions.assertEquals((long)1L, (long)counter.numSuccessOps);
            }
        });
    }

    private LogAction receiveRequest(LogAction logAction) {
        Meter aggregateIdleMeter = (Meter)Mockito.mock(Meter.class);
        RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
        RequestLogFilter requestLogFilter = (RequestLogFilter)Mockito.mock(RequestLogFilter.class);
        RequestLogFilter detailedAuditLogFilter = (RequestLogFilter)Mockito.mock(RequestLogFilter.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, "cluster", 0, aggregateIdleMeter, new AtomicInteger(1), requestChannel, requestLogFilter, detailedAuditLogFilter, apiHandler, (Time)this.time(), KafkaRequestHandler$.MODULE$.$lessinit$greater$default$11());
        RequestChannel.Request request = this.buildTestRequest();
        Mockito.when((Object)requestChannel.receiveRequest(0L)).thenReturn((Object)request);
        Mockito.when((Object)requestLogFilter.processRequest((RequestContext)ArgumentMatchers.eq((Object)request.context()), ArgumentMatchers.anyLong())).thenReturn((Object)logAction);
        Mockito.when((Object)detailedAuditLogFilter.processRequest((RequestContext)ArgumentMatchers.eq((Object)request.context()), ArgumentMatchers.anyLong())).thenReturn((Object)logAction);
        handler.poll(0);
        ((ApiRequestHandler)Mockito.verify((Object)apiHandler)).handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        return logAction;
    }

    private void testRequestFiltering(boolean isRequestFiltered) {
        LogAction logAction = isRequestFiltered ? LogAction.LOGGED : LogAction.NOT_LOGGED;
        LogAction requestLogAction = this.receiveRequest(logAction);
        Assertions.assertEquals((Object)logAction, (Object)requestLogAction);
    }

    private RequestChannel.Request buildTestRequest() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 1379);
        RequestContext requestContext = new RequestContext(requestHeader, "connectionId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        ByteBuffer buffer = ((MetadataRequest)MetadataRequest.Builder.allTopics().build()).serialize();
        RequestChannel.Metrics requestMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        return new RequestChannel.Request(0, requestContext, this.time().nanoseconds(), MemoryPool.NONE, buffer, requestMetrics, (Option)None$.MODULE$, RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }
}

