/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.InconsistentNodeIdException;
import kafka.common.KafkaException;
import kafka.log.MergedLog$;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003<\u0001\u0011\u0005!\u0006C\u0003>\u0001\u0011%a\bC\u0003`\u0001\u0011%\u0001\rC\u0003k\u0001\u0011\u0005!\u0006C\u0003m\u0001\u0011\u0005!\u0006C\u0003o\u0001\u0011\u0005!\u0006C\u0003q\u0001\u0011\u0005!\u0006C\u0003s\u0001\u0011\u0005!FA\nLC\u001a\\\u0017MU1giN+'O^3s)\u0016\u001cHO\u0003\u0002\u0010!\u000511/\u001a:wKJT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"!\b\u0001\u000e\u00039\tqb\u00197vgR,'/\u00133CCN,g\u0007N\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB*ue&tw-\u0001\tdYV\u001cH/\u001a:JI\n\u000b7/\u001a\u001c5A\u0005\u0001C/Z:u'V\u001c7-Z:tMVdGj\\1e\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t)\u0005Y\u0003CA\u000b-\u0013\ticC\u0001\u0003V]&$\bF\u0001\u00030!\t\u0001\u0014(D\u00012\u0015\t\u00114'A\u0002ba&T!\u0001N\u001b\u0002\u000f),\b/\u001b;fe*\u0011agN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002q\u0005\u0019qN]4\n\u0005i\n$\u0001\u0002+fgR\fA\u0006^3ti2{\u0017\rZ'fi\u0006\u0004&o\u001c9feRLWm],ji\"LenY8og&\u001cH/\u001a8u\u001d>$W-\u00133)\u0005\u0015y\u0013\u0001G5om>\\W\rT8bI6+G/\u0019)s_B,'\u000f^5fgR\u0019q(V,\u0011\tU\u0001%)R\u0005\u0003\u0003Z\u0011a\u0001V;qY\u0016\u0014\u0004CA\u000fD\u0013\t!eB\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0011\u0007\u0019K5*D\u0001H\u0015\tAe#\u0001\u0006d_2dWm\u0019;j_:L!AS$\u0003\u0007M+\u0017\u000f\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001dZi\u0011a\u0014\u0006\u0003!J\ta\u0001\u0010:p_Rt\u0014B\u0001*\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0005\u0016\u0006\u0003%ZAQA\u0016\u0004A\u0002\t\u000ba\"\\3uCB\u0013x\u000e]3si&,7\u000fC\u0003Y\r\u0001\u0007\u0011,\u0001\td_:4\u0017n\u001a)s_B,'\u000f^5fgB\u0011!,X\u0007\u00027*\u0011A\fJ\u0001\u0005kRLG.\u0003\u0002_7\nQ\u0001K]8qKJ$\u0018.Z:\u0002']\u0014\u0018\u000e^3NKR\f\u0007K]8qKJ$\u0018.Z:\u0015\u0007-\n\u0017\u000eC\u0003c\u000f\u0001\u00071-\u0001\u0004m_\u001e$\u0015N\u001d\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0012\n!![8\n\u0005!,'\u0001\u0002$jY\u0016DQAV\u0004A\u0002\t\u000b1\u0007^3tiN#\u0018M\u001d;va\u001a\u000b\u0017\u000e\\:JM6+G/\u0019)s_B,'\u000f^5fg6K7o]5oO&s7k\\7f\u0019><G)\u001b:)\u0005!y\u0013!\n;fgR\u001cF/\u0019:ukB4\u0015-\u001b7t\u0013\u001alU\r^1M_\u001e$\u0015N]%t\u001f\u001a4G.\u001b8fQ\tIq&\u0001\u0015uKN$8\u000b^1siV\u0004Hi\\3t\u001d>$h)Y5m\u0013\u001a$\u0015\r^1ESJL5o\u00144gY&tW\r\u000b\u0002\u000b_\u00059C/Z:u'R\f'\u000f^;q\r\u0006LGn]%g+:,\u0007\u0010]3di\u0016$W*\u001a;bI\u0006$\u0018\rR5sQ\tYq&\u0001\u0017uKN$Hj\\1e!J|\u0007/\u001a:uS\u0016\u001cx+\u001b;i\u0013:\u001cwN\\:jgR,g\u000e^\"mkN$XM]%eg\"\u0012Ab\f")
public class KafkaRaftServerTest {
    private final String clusterIdBase64;

    private String clusterIdBase64() {
        return this.clusterIdBase64;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulLoadMetaProperties() {
        void var7_7;
        void var6_6;
        String clusterId = this.clusterIdBase64();
        int nodeId = 0;
        MetaProperties metaProperties = new MetaProperties(clusterId, nodeId);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker,controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://127.0.0.1:9092,SSL://127.0.0.1:9093");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId).append("@localhost:9093").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        Tuple2<MetaProperties, Seq<String>> tuple2 = this.invokeLoadMetaProperties(metaProperties, configProperties);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaProperties loadedMetaProperties = (MetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        void loadedMetaProperties2 = var6_6;
        void offlineDirs2 = var7_7;
        Assertions.assertEquals((Object)metaProperties, (Object)loadedMetaProperties2);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)offlineDirs2);
    }

    @Test
    public void testLoadMetaPropertiesWithInconsistentNodeId() {
        String clusterId = this.clusterIdBase64();
        int metaNodeId = 1;
        int configNodeId = 0;
        MetaProperties metaProperties = new MetaProperties(clusterId, metaNodeId);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(configNodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(configNodeId).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        Assertions.assertThrows(InconsistentNodeIdException.class, () -> this.invokeLoadMetaProperties(metaProperties, configProperties));
    }

    private Tuple2<MetaProperties, Seq<String>> invokeLoadMetaProperties(MetaProperties metaProperties, Properties configProperties) {
        Tuple2 tuple2;
        File tempLogDir = TestUtils.tempDirectory();
        try {
            this.writeMetaProperties(tempLogDir, metaProperties);
            configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), tempLogDir.getAbsolutePath());
            KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
            tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        }
        finally {
            Utils.delete((File)tempLogDir);
        }
        return tuple2;
    }

    private void writeMetaProperties(File logDir, MetaProperties metaProperties) {
        File metaPropertiesFile = new File(logDir.getAbsolutePath(), "meta.properties");
        new BrokerMetadataCheckpoint(metaPropertiesFile).write(metaProperties.toProperties());
    }

    @Test
    public void testStartupFailsIfMetaPropertiesMissingInSomeLogDir() {
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File logDir1 = TestUtils.tempDirectory();
        File logDir2 = TestUtils.tempDirectory();
        this.writeMetaProperties(logDir1, new MetaProperties(clusterId, nodeId));
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), ((TraversableOnce)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    @Test
    public void testStartupFailsIfMetaLogDirIsOffline() {
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File validDir = TestUtils.tempDirectory();
        this.writeMetaProperties(validDir, new MetaProperties(clusterId, nodeId));
        File invalidDir = TestUtils.tempFile((String)"blah");
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), invalidDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), validDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupDoesNotFailIfDataDirIsOffline() {
        void var9_9;
        void var8_8;
        String clusterId = this.clusterIdBase64();
        int nodeId = 1;
        File validDir = TestUtils.tempDirectory();
        this.writeMetaProperties(validDir, new MetaProperties(clusterId, nodeId));
        File invalidDir = TestUtils.tempFile((String)"blah");
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), validDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), invalidDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Tuple2 tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaProperties loadedProperties = (MetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        void loadedProperties2 = var8_8;
        void offlineDirs2 = var9_9;
        Assertions.assertEquals((int)nodeId, (int)loadedProperties2.nodeId());
        Assertions.assertEquals((Object)new .colon.colon((Object)invalidDir.getAbsolutePath(), (List)Nil$.MODULE$), (Object)offlineDirs2);
    }

    @Test
    public void testStartupFailsIfUnexpectedMetadataDir() {
        int nodeId = 1;
        String clusterId = this.clusterIdBase64();
        File metadataDir = TestUtils.tempDirectory();
        File dataDir = TestUtils.tempDirectory();
        new .colon.colon((Object)metadataDir, (List)new .colon.colon((Object)dataDir, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.writeMetaProperties(dir, new MetaProperties(clusterId, nodeId));
            return BoxedUnit.UNIT;
        });
        Files.createDirectory(new File(dataDir, MergedLog$.MODULE$.logDirName(KafkaRaftServer$.MODULE$.MetadataPartition())).toPath(), new FileAttribute[0]);
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), dataDir.getAbsolutePath());
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(KafkaException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    @Test
    public void testLoadPropertiesWithInconsistentClusterIds() {
        int nodeId = 1;
        File logDir1 = TestUtils.tempDirectory();
        File logDir2 = TestUtils.tempDirectory();
        new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.writeMetaProperties(dir, new MetaProperties(Uuid.randomUuid().toString(), nodeId));
            return BoxedUnit.UNIT;
        });
        Properties configProperties = new Properties();
        configProperties.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        configProperties.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(nodeId + 1).append("@localhost:9092").toString());
        configProperties.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(nodeId));
        configProperties.put(KafkaConfig$.MODULE$.LogDirProp(), ((TraversableOnce)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        configProperties.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        configProperties.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(configProperties);
        Assertions.assertThrows(InconsistentBrokerMetadataException.class, () -> KafkaRaftServer$.MODULE$.initializeLogDirs(config));
    }

    public KafkaRaftServerTest() {
        this.clusterIdBase64 = "H3KKO4NTRPaCWtEmm3vW7A";
    }
}

