/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kafka.network.RequestChannel;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerNodeProvider;
import kafka.server.ForwardingManager;
import kafka.server.ForwardingManagerImpl;
import kafka.server.MockBrokerToControllerChannelManager;
import kafka.server.MockBrokerToControllerChannelManager$;
import kafka.utils.MockTime;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.EnvelopeRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004;\u0001\u0001\u0006I\u0001\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019A\u0005\u0001)A\u0005{!9\u0011\n\u0001b\u0001\n\u0013Q\u0005B\u0002(\u0001A\u0003%1\nC\u0004P\u0001\t\u0007I\u0011\u0002)\t\rQ\u0003\u0001\u0015!\u0003R\u0011\u001d)\u0006A1A\u0005\nYCaA\u0017\u0001!\u0002\u00139\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007O\u0002\u0001\u000b\u0011B/\t\u000b!\u0004A\u0011B5\t\u000b5\u0004A\u0011\u00018\u0007\tu\u0004\u0001A \u0005\u0007]A!\t!!\u0002\t\u0013\u0005-\u0001\u00031A\u0005\u0002\u00055\u0001\"CA\u000b!\u0001\u0007I\u0011AA\f\u0011!\ti\u0002\u0005Q!\n\u0005=\u0001bBA\u0014!\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003O\u0001B\u0011IA5\u0011\u0019A\u0007\u0003\"\u0011\u00020\"1\u00111\u0017\u0001\u0005\u00029Da!a.\u0001\t\u0003q\u0007BBA^\u0001\u0011\u0005a\u000e\u0003\u0004\u0002@\u0002!\tA\u001c\u0005\u0007\u0003\u0007\u0004A\u0011\u00018\t\r\u0005\u001d\u0007\u0001\"\u0001o\u0011\u001d\tY\r\u0001C\u0005\u0003\u001bDq!a3\u0001\t\u0013\tI\u000fC\u0004\u0003\u0004\u0001!IA!\u0002\u0003+\u0019{'o^1sI&tw-T1oC\u001e,'\u000fV3ti*\u00111\u0005J\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u0012\u0002\tQLW.Z\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007J\u0001\u0006kRLGn]\u0005\u0003sY\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0007G2LWM\u001c;\u0016\u0003u\u0002\"A\u0010$\u000e\u0003}R!\u0001Q!\u0002\u000f\rd\u0017.\u001a8ug*\u0011QE\u0011\u0006\u0003\u0007\u0012\u000ba!\u00199bG\",'\"A#\u0002\u0007=\u0014x-\u0003\u0002H\u007f\tQQj\\2l\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u000512m\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'/F\u0001L!\t\tD*\u0003\u0002NE\t12i\u001c8ue>dG.\u001a:O_\u0012,\u0007K]8wS\u0012,'/A\fd_:$(o\u001c7mKJtu\u000eZ3Qe>4\u0018\u000eZ3sA\u0005\u0011\"M]8lKJ$vnQ8oiJ|G\u000e\\3s+\u0005\t\u0006CA\u0019S\u0013\t\u0019&E\u0001\u0013N_\u000e\\'I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003M\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:!\u0003E1wN]<be\u0012LgnZ'b]\u0006<WM]\u000b\u0002/B\u0011\u0011\u0007W\u0005\u00033\n\u0012QCR8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s\u00136\u0004H.\u0001\ng_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJ\u0004\u0013\u0001\u00059sS:\u001c\u0017\u000e]1m\u0005VLG\u000eZ3s+\u0005i\u0006C\u00010f\u001b\u0005y&B\u00011b\u00035\tW\u000f\u001e5f]RL7-\u0019;pe*\u0011!mY\u0001\tg\u0016\u001cWO]5us*\u0011A-Q\u0001\u0007G>lWn\u001c8\n\u0005\u0019|&\u0001\b#fM\u0006,H\u000e^&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c\"vS2$WM]\u0001\u0012aJLgnY5qC2\u0014U/\u001b7eKJ\u0004\u0013!F2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018NV3sg&|gn]\u000b\u0002UB\u0011ah[\u0005\u0003Y~\u0012qBT8eK\u0006\u0003\u0018NV3sg&|gn]\u0001\"i\u0016\u001cHOU3ta>t7/Z\"peJ,G.\u0019;j_:LE-T5t[\u0006$8\r\u001b\u000b\u0002_B\u0011\u0011\u0006]\u0005\u0003c*\u0012A!\u00168ji\"\u0012qb\u001d\t\u0003inl\u0011!\u001e\u0006\u0003m^\f1!\u00199j\u0015\tA\u00180A\u0004kkBLG/\u001a:\u000b\u0005i$\u0015!\u00026v]&$\u0018B\u0001?v\u0005\u0011!Vm\u001d;\u0003G\u0019{'o^1sI&tw-T1oC\u001e,'OR8s\u001bVdG/\u001b+f]\u0006tG\u000fV3tiN\u0019\u0001\u0003K@\u0011\u0007E\n\t!C\u0002\u0002\u0004\t\u0012\u0011CR8so\u0006\u0014H-\u001b8h\u001b\u0006t\u0017mZ3s)\t\t9\u0001E\u0002\u0002\nAi\u0011\u0001A\u0001\u0011e\u0016\u001cXM]5bY&TX\r\u001a\"pIf,\"!a\u0004\u0011\u0007%\n\t\"C\u0002\u0002\u0014)\u0012qAQ8pY\u0016\fg.\u0001\u000bsKN,'/[1mSj,GMQ8es~#S-\u001d\u000b\u0004_\u0006e\u0001\"CA\u000e'\u0005\u0005\t\u0019AA\b\u0003\rAH%M\u0001\u0012e\u0016\u001cXM]5bY&TX\r\u001a\"pIf\u0004\u0003f\u0001\u000b\u0002\"A\u0019\u0011&a\t\n\u0007\u0005\u0015\"F\u0001\u0005w_2\fG/\u001b7f\u000391wN]<be\u0012\u0014V-];fgR$ra\\A\u0016\u0003\u0007\n\u0019\u0006C\u0004\u0002.U\u0001\r!a\f\u0002\u001f=\u0014\u0018nZ5oC2\u0014V-];fgR\u0004B!!\r\u0002>9!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028\u0011\nqA\\3uo>\u00148.\u0003\u0003\u0002<\u0005U\u0012A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003\u007f\t\tEA\u0004SKF,Xm\u001d;\u000b\t\u0005m\u0012Q\u0007\u0005\b\u0003\u000b*\u0002\u0019AA$\u00039qWm\u001e*fcV,7\u000f\u001e\"pIf\u0004B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\u001a\u0017\u0001\u0003:fcV,7\u000f^:\n\t\u0005E\u00131\n\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\"9\u0011QK\u000bA\u0002\u0005]\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0019I\u0013\u0011LA/_&\u0019\u00111\f\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#B\u0015\u0002`\u0005\r\u0014bAA1U\t1q\n\u001d;j_:\u0004B!!\u0013\u0002f%!\u0011qMA&\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rF\u0006p\u0003W\n)(!#\u0002\u000e\u00065\u0006bBA7-\u0001\u0007\u0011qN\u0001\u000fe\u0016\fX/Z:u\u0007>tG/\u001a=u!\u0011\tI%!\u001d\n\t\u0005M\u00141\n\u0002\u000f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\t9H\u0006a\u0001\u0003s\n\u0011C]3rk\u0016\u001cHOQ;gM\u0016\u00148i\u001c9z!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b1A\\5p\u0015\t\t\u0019)\u0001\u0003kCZ\f\u0017\u0002BAD\u0003{\u0012!BQ=uK\n+hMZ3s\u0011\u001d\tYI\u0006a\u0001\u0003\u000f\n1B]3rk\u0016\u001cHOQ8es\"9\u0011q\u0012\fA\u0002\u0005E\u0015a\u0004:fcV,7\u000f\u001e+p'R\u0014\u0018N\\4\u0011\u000b%\n\u0019*a&\n\u0007\u0005U%FA\u0005Gk:\u001cG/[8oaA!\u0011\u0011TAT\u001d\u0011\tY*a)\u0011\u0007\u0005u%&\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t)KK\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00161\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015&\u0006C\u0004\u0002VY\u0001\r!a\u0016\u0016\u0005\u0005E\u0006\u0003B\u0015\u0002`)\f\u0011\u0004^3ti6+H\u000e^5UK:\fg\u000e\u001e$pe^\f'\u000fZ5oO\"\u0012\u0001d]\u0001\u0018i\u0016\u001cH/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]ND#!G:\u0002eQ,7\u000f\u001e$pe^\f'\u000fZ5oORKW.Z8vi^\u000b\u0017\u000e^5oO\u001a{'oQ8oiJ|G\u000e\\3s\t&\u001c8m\u001c<fefD#AG:\u0002?Q,7\u000f\u001e$pe^\f'\u000fZ5oORKW.Z8vi\u00063G/\u001a:SKR\u0014\u0018\u0010\u000b\u0002\u001cg\u00069C/Z:u+:\u001cX\u000f\u001d9peR,GMV3sg&|gN\u0012:p[:+Go^8sW\u000ec\u0017.\u001a8uQ\ta2/\u0001\ruKN$h)Y5mK\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:D#!H:\u0002\u0019\t,\u0018\u000e\u001c3SKF,Xm\u001d;\u0015\r\u0005=\u00171\\Ap!\u001dI\u0013\u0011[Ak\u0003sJ1!a5+\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011JAl\u0013\u0011\tI.a\u0013\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\tiN\ba\u0001\u0003\u000f\nAAY8es\"9\u0011\u0011\u001d\u0010A\u0002\u0005\r\u0018!D2peJ,G.\u0019;j_:LE\rE\u0002*\u0003KL1!a:+\u0005\rIe\u000e\u001e\u000b\t\u0003_\tY/a<\u0002t\"9\u0011Q^\u0010A\u0002\u0005U\u0017!\u0004:fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0004\u0002r~\u0001\r!!\u001f\u0002\u001bI,\u0017/^3ti\n+hMZ3s\u0011\u001d\t)p\ba\u0001\u0003o\f\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\t\u0005e\u0018q`\u0007\u0003\u0003wT1!!@b\u0003\u0011\tW\u000f\u001e5\n\t\t\u0005\u00111 \u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003Y!Xm\u001d;BYR,'oQ8oM&<'+Z9vKN$XC\u0001B\u0004!\u0011\tIE!\u0003\n\t\t-\u00111\n\u0002\u0014\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f\u001e")
public class ForwardingManagerTest {
    private final MockTime time = new MockTime();
    private final MockClient client = new MockClient((Time)this.time());
    private final ControllerNodeProvider controllerNodeProvider = (ControllerNodeProvider)Mockito.mock(ControllerNodeProvider.class);
    private final MockBrokerToControllerChannelManager brokerToController = new MockBrokerToControllerChannelManager(this.client(), this.time(), this.controllerNodeProvider(), this.controllerApiVersions(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$5(), MockBrokerToControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
    private final ForwardingManagerImpl forwardingManager = new ForwardingManagerImpl((BrokerToControllerChannelManager)this.brokerToController());
    private final DefaultKafkaPrincipalBuilder principalBuilder = new DefaultKafkaPrincipalBuilder(null, null);

    private MockTime time() {
        return this.time;
    }

    private MockClient client() {
        return this.client;
    }

    private ControllerNodeProvider controllerNodeProvider() {
        return this.controllerNodeProvider;
    }

    private MockBrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    private ForwardingManagerImpl forwardingManager() {
        return this.forwardingManager;
    }

    private DefaultKafkaPrincipalBuilder principalBuilder() {
        return this.principalBuilder;
    }

    private NodeApiVersions controllerApiVersions() {
        ApiVersionsResponseData.ApiVersion envelopeApiVersion = new ApiVersionsResponseData.ApiVersion().setApiKey(ApiKeys.ENVELOPE.id).setMinVersion(ApiKeys.ENVELOPE.oldestVersion()).setMaxVersion(ApiKeys.ENVELOPE.latestVersion());
        return NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)envelopeApiVersion, (List)Nil$.MODULE$)).asJava()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseCorrelationIdMismatch() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)(requestCorrelationId + 1));
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)new Node(0, "host", 1234)));
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.NONE));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertTrue((boolean)Option$.MODULE$.apply(responseOpt.get()).isDefined());
        AbstractResponse response = (AbstractResponse)((Option)responseOpt.get()).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)response.errorCounts());
    }

    @Test
    public void testMultiTenantForwarding() {
        ForwardingManagerForMultiTenantTest forwardingManager = new ForwardingManagerForMultiTenantTest();
        RequestChannel.Request request = (RequestChannel.Request)Mockito.mock(RequestChannel.Request.class);
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        MultiTenantPrincipal principal = (MultiTenantPrincipal)Mockito.mock(MultiTenantPrincipal.class);
        Mockito.when((Object)request.context()).thenReturn((Object)context);
        Mockito.when((Object)context.getPrincipal()).thenReturn((Object)principal);
        forwardingManager.forwardRequest(request, (Function1<Option<AbstractResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$2 -> {
            ForwardingManagerTest.$anonfun$testMultiTenantForwarding$1(x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)forwardingManager.reserializedBody());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersions() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request2 = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        ByteBuffer responseBuffer = RequestTestUtils.serializeResponseWithHeader((AbstractResponse)new AlterConfigsResponse(new AlterConfigsResponseData()), (short)requestHeader2.apiVersion(), (int)requestCorrelationId);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)new Node(0, "host", 1234)));
        MockClient.RequestMatcher isEnvelopeRequest = request -> request instanceof EnvelopeRequest;
        this.client().prepareResponse(isEnvelopeRequest, (AbstractResponse)new EnvelopeResponse(responseBuffer, Errors.UNSUPPORTED_VERSION));
        AtomicReference responseOpt = new AtomicReference();
        this.forwardingManager().forwardRequest(request2, (Function1 & Serializable & scala.Serializable)x$1 -> {
            responseOpt.set(x$1);
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertEquals((Object)None$.MODULE$, responseOpt.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutWaitingForControllerDiscovery() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)None$.MODULE$);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$1.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testForwardingTimeoutAfterRetry() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)new Node(0, "host", 1234)));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$2.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNull(response.get());
        this.time().sleep(this.brokerToController().retryTimeoutMs());
        this.client().respond(this.testAlterConfigRequest().getErrorResponse(0, (Throwable)Errors.UNKNOWN_SERVER_ERROR.exception()), true);
        this.brokerToController().poll();
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.REQUEST_TIMED_OUT), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnsupportedVersionFromNetworkClient() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Node controllerNode = new Node(0, "host", 1234);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)controllerNode));
        this.client().prepareUnsupportedVersionResponse(arg_0 -> ForwardingManagerTest.$anonfun$testUnsupportedVersionFromNetworkClient$1((RequestHeader)requestHeader2, arg_0));
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$3.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFailedAuthentication() {
        void var5_5;
        void var4_4;
        int requestCorrelationId = 27;
        KafkaPrincipal clientPrincipal = new KafkaPrincipal("User", "client");
        Tuple2<RequestHeader, ByteBuffer> tuple2 = this.buildRequest((AbstractRequest)this.testAlterConfigRequest(), requestCorrelationId);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RequestHeader requestHeader = (RequestHeader)tuple2._1();
        ByteBuffer requestBuffer = (ByteBuffer)tuple2._2();
        void requestHeader2 = var4_4;
        void requestBuffer2 = var5_5;
        RequestChannel.Request request = this.buildRequest((RequestHeader)requestHeader2, (ByteBuffer)requestBuffer2, clientPrincipal);
        Node controllerNode = new Node(0, "host", 1234);
        Mockito.when((Object)this.controllerNodeProvider().get()).thenReturn((Object)new Some((Object)controllerNode));
        this.client().createPendingAuthenticationError(controllerNode, 50L);
        AtomicReference response = new AtomicReference();
        this.forwardingManager().forwardRequest(request, (Function1 & Serializable & scala.Serializable)res -> {
            res.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                response$4.set(x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.brokerToController().poll();
        Assertions.assertNotNull(response.get());
        AlterConfigsResponse alterConfigResponse = (AlterConfigsResponse)response.get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.UNKNOWN_SERVER_ERROR), (Object)BoxesRunTime.boxToInteger((int)1))}))).asJava(), (Object)alterConfigResponse.errorCounts());
    }

    private Tuple2<RequestHeader, ByteBuffer> buildRequest(AbstractRequest body, int correlationId) {
        RequestHeader header = new RequestHeader(body.apiKey(), body.version(), "clientId", correlationId);
        ByteBuffer buffer = body.serializeWithHeader(header);
        RequestHeader.parse((ByteBuffer)buffer);
        return new Tuple2((Object)header, (Object)buffer);
    }

    private RequestChannel.Request buildRequest(RequestHeader requestHeader, ByteBuffer requestBuffer, KafkaPrincipal principal) {
        RequestContext requestContext = new RequestContext(requestHeader, "1", InetAddress.getLocalHost(), principal, new ListenerName("client"), SecurityProtocol.SASL_PLAINTEXT, ClientInformation.EMPTY, null, false, Optional.of(this.principalBuilder()));
        return new RequestChannel.Request(1, requestContext, this.time().nanoseconds(), MemoryPool.NONE, requestBuffer, new RequestChannel.Metrics(ApiMessageType.ListenerType.CONTROLLER), (Option)None$.MODULE$, RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }

    private AlterConfigsRequest testAlterConfigRequest() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, "foo");
        java.util.List configs = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new AlterConfigsRequest.ConfigEntry("min.insync.replicas", "1"), (List)Nil$.MODULE$)).asJava();
        return (AlterConfigsRequest)new AlterConfigsRequest.Builder((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)new AlterConfigsRequest.Config((Collection)configs))}))).asJava(), false).build();
    }

    public static final /* synthetic */ void $anonfun$testMultiTenantForwarding$1(Option x$2) {
    }

    public static final /* synthetic */ boolean $anonfun$testUnsupportedVersionFromNetworkClient$1(RequestHeader requestHeader$1, AbstractRequest req) {
        ApiKeys apiKeys = req.apiKey();
        ApiKeys apiKeys2 = requestHeader$1.apiKey();
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public class ForwardingManagerForMultiTenantTest
    implements ForwardingManager {
        private volatile boolean reserializedBody;

        public void forwardRequest(RequestChannel.Request originalRequest, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            ForwardingManager.forwardRequest$((ForwardingManager)this, (RequestChannel.Request)originalRequest, responseCallback);
        }

        public boolean reserializedBody() {
            return this.reserializedBody;
        }

        public void reserializedBody_$eq(boolean x$1) {
            this.reserializedBody = x$1;
        }

        public void forwardRequest(RequestChannel.Request originalRequest, AbstractRequest newRequestBody, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            this.reserializedBody_$eq(true);
        }

        public void forwardRequest(RequestContext requestContext, ByteBuffer requestBufferCopy, AbstractRequest requestBody, Function0<String> requestToString, Function1<Option<AbstractResponse>, BoxedUnit> responseCallback) {
            throw new UnsupportedOperationException();
        }

        public Option<NodeApiVersions> controllerApiVersions() {
            return None$.MODULE$;
        }

        public /* synthetic */ ForwardingManagerTest kafka$server$ForwardingManagerTest$ForwardingManagerForMultiTenantTest$$$outer() {
            return ForwardingManagerTest.this;
        }

        public ForwardingManagerForMultiTenantTest() {
            if (ForwardingManagerTest.this == null) {
                throw null;
            }
            ForwardingManager.$init$((ForwardingManager)this);
            this.reserializedBody = false;
        }
    }
}

