/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Stream;
import kafka.cluster.PartitionListener;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FetchSessionTest$;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSetLike;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\r\u0005f\u0001B A\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025CQ\u0001\u0015\u0001\u0005\u0002ECQA\u0019\u0001\u0005\u0002\rDQ!\u001d\u0001\u0005\nIDQ\u0001 \u0001\u0005\u0002ECQA \u0001\u0005\u0002ECa!!\u0001\u0001\t\u0003\t\u0006BBA\u0003\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u0002\n\u0001!\t!\u0015\u0005\u0007\u0003\u001b\u0001A\u0011A)\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u001c\u0001\u0001\u0006I!!\u0006\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!I\u0011\u0011\u0012\u0001\u0012\u0002\u0013\u0005\u00111\u0012\u0005\b\u0003C\u0003A\u0011AAR\u0011\u0019\ti\u000b\u0001C\u0001#\"1\u0011\u0011\u0017\u0001\u0005\u0002ECq!!.\u0001\t\u0013\t9\f\u0003\u0004\u0002v\u0002!\t!\u0015\u0005\b\u0003s\u0004A\u0011AA~\u0011\u0019\u0011)\u0003\u0001C\u0001#\"1!\u0011\u0006\u0001\u0005\u0002ECaA!\f\u0001\t\u0003\t\u0006B\u0002B\u0019\u0001\u0011\u0005\u0011\u000b\u0003\u0004\u00036\u0001!\t!\u0015\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011\u001d\u0011I\u0005\u0001C\u0005\u0005\u0017BaA!\u0015\u0001\t\u0003\t\u0006b\u0002B+\u0001\u0011\u0005!q\u000b\u0005\u0007\u0005g\u0002A\u0011A)\t\r\t]\u0004\u0001\"\u0001R\u0011\u0019\u0011Y\b\u0001C\u0001#\"1!q\u0010\u0001\u0005\u0002ECaAa!\u0001\t\u0003\t\u0006B\u0002BD\u0001\u0011\u0005\u0011\u000bC\u0004\u0003\f\u0002!IA!$\t\r\t\u001d\u0006\u0001\"\u0001R\u0011\u0019\u0011Y\u000b\u0001C\u0001#\"9!q\u0016\u0001\u0005\n\tE\u0006\"\u0003Bx\u0001E\u0005I\u0011\u0002By\u0011%\u0011)\u0010AI\u0001\n\u0013\u0011\t\u0010C\u0005\u0003x\u0002\t\n\u0011\"\u0003\u0003z\"I!Q \u0001\u0012\u0002\u0013%!q \u0005\b\u0007\u0007\u0001A\u0011BB\u0003\u0011%\u0019)\u0003AI\u0001\n\u0013\u00199\u0003C\u0005\u0004,\u0001\t\n\u0011\"\u0003\u0003r\"I1Q\u0006\u0001\u0012\u0002\u0013%!\u0011\u001f\u0005\n\u0007_\u0001\u0011\u0013!C\u0005\u0005cDqa!\r\u0001\t\u0013\u0019\u0019\u0004C\u0005\u0004H\u0001\t\n\u0011\"\u0003\u0004J!I1Q\n\u0001\u0012\u0002\u0013%1q\n\u0005\b\u0007'\u0002A\u0011BB+\u0011%\u0019)\u0007AI\u0001\n\u0013\u00199\u0003C\u0005\u0004h\u0001\t\n\u0011\"\u0003\u0003r\"I1\u0011\u000e\u0001\u0012\u0002\u0013%!\u0011\u001f\u0005\n\u0007W\u0002\u0011\u0013!C\u0005\u0005cDqa!\u001c\u0001\t\u0013\u0019y\u0007C\u0005\u0004z\u0001\t\n\u0011\"\u0003\u0004J\u001d91Q\u0011!\t\u0002\r\u001deAB A\u0011\u0003\u0019I\t\u0003\u0004My\u0011\u000511\u0012\u0005\b\u0005_bD\u0011ABG\u0005A1U\r^2i'\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002B\u0005\u000611/\u001a:wKJT\u0011aQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"a\u0014\u0001\u000e\u0003\u0001\u000b\u0001\u0003^3ti:+woU3tg&|g.\u00133\u0015\u0003I\u0003\"aR*\n\u0005QC%\u0001B+oSRD#A\u0001,\u0011\u0005]\u0003W\"\u0001-\u000b\u0005eS\u0016aA1qS*\u00111\fX\u0001\bUV\u0004\u0018\u000e^3s\u0015\tif,A\u0003kk:LGOC\u0001`\u0003\ry'oZ\u0005\u0003Cb\u0013A\u0001V3ti\u0006\u0019\u0012m]:feR\u001c\u0015m\u00195f\u0007>tG/Y5ogR\u0019!\u000bZ5\t\u000b\u0015\u001c\u0001\u0019\u00014\u0002\u000b\r\f7\r[3\u0011\u0005=;\u0017B\u00015A\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\u0005\u0006U\u000e\u0001\ra[\u0001\u000bg\u0016\u001c8/[8o\u0013\u0012\u001c\bcA$m]&\u0011Q\u000e\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0004CA$p\u0013\t\u0001\bJA\u0002J]R\f1\u0002Z;n[f\u001c%/Z1uKR\u00111O\u001f\t\u0003i^t!aT;\n\u0005Y\u0004\u0015\u0001\u0004$fi\u000eD7+Z:tS>t\u0017B\u0001=z\u0005%\u0019\u0015i\u0011%F?6\u000b\u0005K\u0003\u0002w\u0001\")1\u0010\u0002a\u0001]\u0006!1/\u001b>f\u0003A!Xm\u001d;TKN\u001c\u0018n\u001c8DC\u000eDW\r\u000b\u0002\u0006-\u00069C/Z:u'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.Z\"m_N,7+Z:tS>tw\u000b[3o%\u0016lwN^3eQ\t1a+A\u000fuKN$8+Z:tS>t7)Y2iK\u00163\u0018n\u0019;j_:\u0014V\u000f\\3tQ\t9a+A\u000euKN$8+Y7f'&TXmU3tg&|g.\u0012<jGRLwN\u001c\u0015\u0003\u0011Y\u000bq\u0004^3ti\u0006\u001bG/\u001b<f'\u0016\u001c8/[8o\u000bZL7\r^5p]NlU\r^3sQ\tIa+\u0001\ruKN$(+Z:ju\u0016\u001c\u0015m\u00195fIN+7o]5p]ND#A\u0003,\u0002\u001f\u0015k\u0005\u000bV-`!\u0006\u0013Fk\u0018'J'R+\"!!\u0006\u0011\r\u0005]\u0011\u0011EA\u0013\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001B;uS2T!!a\b\u0002\t)\fg/Y\u0005\u0005\u0003G\tIB\u0001\u0003MSN$\b\u0003BA\u0014\u0003gi!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0007G>lWn\u001c8\u000b\u0007\r\u000byCC\u0002\u00022y\u000ba!\u00199bG\",\u0017\u0002BA\u001b\u0003S\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002!\u0015k\u0005\u000bV-`!\u0006\u0013Fk\u0018'J'R\u0003\u0013!D2sK\u0006$XMU3rk\u0016\u001cH\u000f\u0006\u0007\u0002>\u0005%\u00131KA9\u0003k\ny\b\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\u0011\t\u0019%!\u000b\u0002\u0011I,\u0017/^3tiNLA!a\u0012\u0002B\taa)\u001a;dQJ+\u0017/^3ti\"9\u00111J\u0007A\u0002\u00055\u0013\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005}\u0012qJ\u0005\u0005\u0003#\n\tEA\u0007GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0005\b\u0003+j\u0001\u0019AA,\u0003%1W\r^2i\t\u0006$\u0018\r\u0005\u0005\u0002\u0018\u0005e\u0013QLA2\u0013\u0011\tY&!\u0007\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002(\u0005}\u0013\u0002BA1\u0003S\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002f\u0005-d\u0002BA \u0003OJA!!\u001b\u0002B\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u0011QNA8\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011\u0011NA!\u0011\u001d\t\u0019(\u0004a\u0001\u0003+\t\u0001\u0002^8G_J<W\r\u001e\u0005\b\u0003oj\u0001\u0019AA=\u00039I7O\u0012:p[\u001a{G\u000e\\8xKJ\u00042aRA>\u0013\r\ti\b\u0013\u0002\b\u0005>|G.Z1o\u0011%\t\t)\u0004I\u0001\u0002\u0004\t\u0019)A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0007\u001d\u000b))C\u0002\u0002\b\"\u0013Qa\u00155peR\fqc\u0019:fCR,'+Z9vKN$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u00055%\u0006BAB\u0003\u001f[#!!%\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037C\u0015AC1o]>$\u0018\r^5p]&!\u0011qTAK\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dGJ,\u0017\r^3SKF,Xm\u001d;XSRDw.\u001e;U_BL7-\u00133t))\ti$!*\u0002(\u0006%\u00161\u0016\u0005\b\u0003\u0017z\u0001\u0019AA'\u0011\u001d\t)f\u0004a\u0001\u0003/Bq!a\u001d\u0010\u0001\u0004\t)\u0002C\u0004\u0002x=\u0001\r!!\u001f\u0002+Q,7\u000f^\"bG\",G\rT3bI\u0016\u0014X\t]8dQ\"\u0012\u0001CV\u0001\u0015i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195)\u0005E1\u0016!G1tg\u0016\u0014H\u000fU1si&$\u0018n\u001c8t\u0013:\u001cuN\u001c;fqR$rAUA]\u0003\u0013\fY\u000fC\u0004\u0002<J\u0001\r!!0\u0002)\u0015D\b/Z2uK\u00124U\r^2i%\u0016\fX/Z:u!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003S\tq!\\3tg\u0006<W-\u0003\u0003\u0002H\u0006\u0005'\u0001\u0005$fi\u000eD'+Z9vKN$H)\u0019;b\u0011\u001d\tYM\u0005a\u0001\u0003\u001b\f!\u0002^8qS\u000et\u0015-\\3t!!\t9\"!\u0017\u0002P\u0006U\u0007\u0003BA\u0014\u0003#LA!a5\u0002*\t!Q+^5e!\u0011\t9.!:\u000f\t\u0005e\u0017\u0011\u001d\t\u0004\u00037DUBAAo\u0015\r\ty\u000eR\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\b*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\fIO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003GD\u0005bBAw%\u0001\u0007\u0011q^\u0001\bG>tG/\u001a=u!\ry\u0015\u0011_\u0005\u0004\u0003g\u0004%\u0001\u0004$fi\u000eD7i\u001c8uKb$\u0018!\u0005;fgR4U\r^2i%\u0016\fX/Z:ug\"\u00121CV\u0001\u001ci\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195TKN\u001c\u0018n\u001c8\u0015\u0007I\u000bi\u0010C\u0004\u0002\u0000R\u0001\r!!\u001f\u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:)\u000fQ\u0011\u0019Aa\u0005\u0003\u0016A!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0007\t5!,\u0001\u0004qCJ\fWn]\u0005\u0005\u0005#\u00119AA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\t]!\u0011D\r\u0002\u0003e\t\u0001\u0001K\u0002\u0015\u0005;\u0001BAa\b\u0003\"5\u0011!1B\u0005\u0005\u0005G\u0011YAA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fa\u0006^3ti\u001a+Go\u00195TKN\u001c\u0018n\u001c8XSRDWK\\6o_^t\u0017\nZ(mIJ+\u0017/^3tiZ+'o]5p]\"\u0012QCV\u0001\u001ei\u0016\u001cHOR3uG\"\u001cVm]:j_:<\u0016\u000e\u001e5V].twn\u001e8JI\"\u0012aCV\u0001;i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u001a+Go\u00195TKN\u001c\u0018n\u001c8XSRD\u0017\nZ:XQ\u0016t7+Z:tS>tGi\\3t\u001d>$Xk]3JIND#a\u0006,\u0002oQ,7\u000f^%oGJ,W.\u001a8uC24U\r^2i'\u0016\u001c8/[8o/&$\bn\\;u\u0013\u0012\u001cx\u000b[3o'\u0016\u001c8/[8o+N,7/\u00133tQ\tAb+\u0001\u0015uKN$h)\u001a;dQN+7o]5p]V\u0003H-\u0019;f)>\u0004\u0018nY%eg\n\u0013xn[3s'&$W\r\u000b\u0002\u001a-\u0006yan\\#se>\u0014(+Z:q_:\u001cX-\u0006\u0002\u0003>A!!q\bB#\u001d\u0011\tyL!\u0011\n\t\t\r\u0013\u0011Y\u0001\u0012\r\u0016$8\r\u001b*fgB|gn]3ECR\f\u0017\u0002BA7\u0005\u000fRAAa\u0011\u0002B\u0006iQM\u001d:peJ+7\u000f]8og\u0016$BA!\u0010\u0003N!9!qJ\u000eA\u0002\u0005\r\u0015!C3se>\u00148i\u001c3f\u0003q!Xm\u001d;SKN|GN^3V].twn\u001e8QCJ$\u0018\u000e^5p]ND#\u0001\b,\u0002-Q,7\u000f\u001e+p\r>\u0014x-\u001a;QCJ$\u0018\u000e^5p]N$RA\u0015B-\u0005;BqAa\u0017\u001e\u0001\u0004\tI(A\tg_>\u001cF/\u0019:ugJ+7o\u001c7wK\u0012DqAa\u0018\u001e\u0001\u0004\tI(A\bg_>,e\u000eZ:SKN|GN^3eQ\u001di\"1\rB5\u0005W\u0002BA!\u0002\u0003f%!!q\rB\u0004\u00051iU\r\u001e5pIN{WO]2f\u0003\u00151\u0018\r\\;fY\t\u0011i'\t\u0002\u0003p\u0005\u0019\u0012\u000eZ+tC\u001e,7i\\7cS:\fG/[8og\"\u001aQD!\b\u0002CQ,7\u000f^+qI\u0006$X-\u00118e\u000f\u0016tWM]1uKJ+7\u000f]8og\u0016$\u0015\r^1)\u0005y1\u0016A\u0007;fgR4U\r^2i'\u0016\u001c8/[8o\u000bb\u0004\u0018N]1uS>t\u0007FA\u0010W\u0003u!Xm\u001d;Qe&4\u0018\u000e\\3hK\u0012\u001cVm]:j_:D\u0015M\u001c3mS:<\u0007F\u0001\u0011W\u0003a!Xm\u001d;[KJ|7+\u001b>f\r\u0016$8\r[*fgNLwN\u001c\u0015\u0003CY\u000b!\u0003^3ti\u0012Kg/\u001a:hS:<W\t]8dQ\"\u0012!EV\u0001+i\u0016\u001cH\u000fR3qe&|'/\u001b;ju\u0016\u001c\b+\u0019:uSRLwN\\:XSRD'+Z2pe\u0012\u001cxJ\u001c7zQ\t\u0019c+A\u000bbgN,'\u000f\u001e)beRLG/[8og>\u0013H-\u001a:\u0015\u000bI\u0013yI!%\t\u000f\u00055H\u00051\u0001\u0002p\"9!1\u0013\u0013A\u0002\tU\u0015A\u00039beRLG/[8ogB1!q\u0013BQ\u0003KqAA!'\u0003\u001e:!\u00111\u001cBN\u0013\u0005I\u0015b\u0001BP\u0011\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002BR\u0005K\u00131aU3r\u0015\r\u0011y\nS\u0001\u0012i\u0016\u001cHoU3tg&|g.\u00169eCR,\u0007FA\u0013W\u0003A!Xm\u001d;TKN\u001c\u0018n\u001c8DY>\u001cX\r\u000b\u0002'-\u0006\u0001R.Y6f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u000b\u000b\u0003{\u0013\u0019La.\u0003<\n\r\b\u0002\u0003B[OA\u0005\t\u0019\u00018\u0002\u0013M,7o]5p]&#\u0007\u0002\u0003B]OA\u0005\t\u0019\u00018\u0002\u0019M,7o]5p]\u0016\u0003xn\u00195\t\u0013\tuv\u0005%AA\u0002\t}\u0016A\u0002;pa&\u001c7\u000f\u0005\u0004\u0003\u0018\n\u0005&\u0011\u0019\t\u0005\u0005\u0007\u0014iN\u0004\u0003\u0003F\neg\u0002\u0002Bd\u0005/tAA!3\u0003V:!!1\u001aBj\u001d\u0011\u0011iM!5\u000f\t\u0005m'qZ\u0005\u0002?&\u0019\u0011\u0011\u00070\n\u0007\r\u000by#\u0003\u0003\u0002,\u00055\u0012\u0002BAb\u0003SIAAa7\u0002B\u0006\u0001b)\u001a;dQJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005?\u0014\tO\u0001\u0006GKR\u001c\u0007\u000eV8qS\u000eTAAa7\u0002B\"I!Q]\u0014\u0011\u0002\u0003\u0007!q]\u0001\u0010M>\u0014xm\u001c;uK:$v\u000e]5dgB1!q\u0013BQ\u0005S\u0004BAa1\u0003l&!!Q\u001eBq\u000591uN]4piR,g\u000eV8qS\u000e\f!$\\1lK\u001a+Go\u00195SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIE*\"Aa=+\u00079\fy)\u0001\u000enC.,g)\u001a;dQJ+\u0017/^3ti\u0012\"WMZ1vYR$#'\u0001\u000enC.,g)\u001a;dQJ+\u0017/^3ti\u0012\"WMZ1vYR$3'\u0006\u0002\u0003|*\"!qXAH\u0003ii\u0017m[3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\tA\u000b\u0003\u0003h\u0006=\u0015aF7bW\u00164U\r^2i)>\u0004\u0018n\u0019)beRLG/[8o)9\u0011\tma\u0002\u0004\f\rU1\u0011DB\u000f\u0007CAqa!\u0003-\u0001\u0004\t)#\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]\"91Q\u0002\u0017A\u0002\r=\u0011a\u00034fi\u000eDwJ\u001a4tKR\u00042aRB\t\u0013\r\u0019\u0019\u0002\u0013\u0002\u0005\u0019>tw\rC\u0005\u0004\u00181\u0002\n\u00111\u0001\u0004\u0010\u0005qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$\b\u0002CB\u000eYA\u0005\t\u0019\u00018\u0002\u00115\f\u0007PQ=uKND\u0001ba\b-!\u0003\u0005\rA\\\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0005\u0004$1\u0002\n\u00111\u0001o\u0003Aa\u0017m\u001d;GKR\u001c\u0007.\u001a3Fa>\u001c\u0007.A\u0011nC.,g)\u001a;dQR{\u0007/[2QCJ$\u0018\u000e^5p]\u0012\"WMZ1vYR$3'\u0006\u0002\u0004*)\"1qBAH\u0003\u0005j\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003\u0005j\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136\u0003\u0005j\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u00039i\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e$\u0002B!1\u00046\re2Q\b\u0005\n\u0007o\t\u0004\u0013!a\u0001\u0003+\fQ\u0001^8qS\u000eD\u0011ba\u000f2!\u0003\u0005\r!a4\u0002\u000fQ|\u0007/[2JI\"9!1S\u0019A\u0002\r}\u0002C\u0002BL\u0005C\u001b\t\u0005\u0005\u0003\u0003D\u000e\r\u0013\u0002BB#\u0005C\u0014aBR3uG\"\u0004\u0016M\u001d;ji&|g.\u0001\rnC.,g)\u001a;dQR{\u0007/[2%I\u00164\u0017-\u001e7uIE*\"aa\u0013+\t\u0005U\u0017qR\u0001\u0019[\u0006\\WMR3uG\"$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012TCAB)U\u0011\ty-a$\u0002%5\f7.\u001a$fi\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u000f\u0007\u0003\u001a9fa\u0017\u0004^\r}3\u0011MB2\u0011\u0019\u0019I\u0006\u000ea\u0001]\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0007\u001b!\u0004\u0019AB\b\u0011%\u00199\u0002\u000eI\u0001\u0002\u0004\u0019y\u0001\u0003\u0005\u0004\u001cQ\u0002\n\u00111\u0001o\u0011!\u0019y\u0002\u000eI\u0001\u0002\u0004q\u0007\u0002CB\u0012iA\u0005\t\u0019\u00018\u000295\f7.\u001a$fi\u000eD\u0007+\u0019:uSRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005aR.Y6f\r\u0016$8\r\u001b)beRLG/[8oI\u0011,g-Y;mi\u0012\"\u0014\u0001H7bW\u00164U\r^2i!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$H%N\u0001\u001d[\u0006\\WMR3uG\"\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137\u0003Ii\u0017m[3G_J<w\u000e\u001e;f]R{\u0007/[2\u0015\u0011\t%8\u0011OB:\u0007kB\u0011ba\u000e:!\u0003\u0005\r!!6\t\u000f\rm\u0012\b1\u0001\u0002P\"9!1S\u001dA\u0002\r]\u0004#\u0002BL\u0005Cs\u0017\u0001H7bW\u00164uN]4piR,g\u000eV8qS\u000e$C-\u001a4bk2$H%\r\u0015\b\u0001\ru$\u0011NBB!\r96qP\u0005\u0004\u0007\u0003C&a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\u0006\u0001b)\u001a;dQN+7o]5p]R+7\u000f\u001e\t\u0003\u001fr\u001a\"\u0001\u0010$\u0015\u0005\r\u001dUCABH!\u0019\u0019\tja&\u0004\u001c6\u001111\u0013\u0006\u0005\u0007+\u000bI\"\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u00073\u001b\u0019J\u0001\u0004TiJ,\u0017-\u001c\t\u0005\u0005\u000b\u0019i*\u0003\u0003\u0004 \n\u001d!!C!sOVlWM\u001c;t\u0001")
public class FetchSessionTest {
    private final java.util.List<TopicIdPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    public static Stream<Arguments> idUsageCombinations() {
        return FetchSessionTest$.MODULE$.idUsageCombinations();
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> Assertions.assertTrue((cache.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cache.get(sessionId).isDefined(), (String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("test", Uuid.randomUuid());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata("test", (Uuid)topicIds.get("test"), i)));
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(30L, false, 40, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(410L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testSessionCacheCloseSessionWhenRemoved() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection();
        IncrementalPartitionFetchMetadata partition1 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("foo", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition1);
        IncrementalPartitionFetchMetadata partition2 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("bar", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition2);
        int sessionId = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> cacheMap);
        Assertions.assertTrue((boolean)cache.get(sessionId).isDefined());
        Assertions.assertTrue((boolean)cache.remove(sessionId).isDefined());
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition1)).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition2)).close();
    }

    @Test
    public void testSessionCacheEvictionRules() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        int id1 = cache.maybeCreateSession(0L, false, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id2 = cache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id3 = cache.maybeCreateSession(0L, false, 30, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        cache.touch((FetchSession)cache.get(id1).get(), 101L);
        cache.touch((FetchSession)cache.get(id2).get(), 101L);
        cache.touch((FetchSession)cache.get(id3).get(), 101L);
        int id4 = cache.maybeCreateSession(102L, false, 31, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(31));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 102L);
        cache.touch((FetchSession)cache.get(id3).get(), 102L);
        int id5 = cache.maybeCreateSession(203L, false, 9, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(9));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id5}));
        int id6 = cache.maybeCreateSession(204L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
        int id7 = cache.maybeCreateSession(204L, true, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id5, id6, id7}));
        int id8 = cache.maybeCreateSession(204L, true, 30, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id7, id8}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 40, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        cache.touch((FetchSession)cache.get(id6).get(), 205L);
        cache.touch((FetchSession)cache.get(id8).get(), 305L);
        int id9 = cache.maybeCreateSession(305L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id8, id9}));
        cache.touch((FetchSession)cache.get(id6).get(), 305L);
        int id10 = cache.maybeCreateSession(305L, true, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id8, id10}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(306L, true, 6, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(6)));
        cache.touch((FetchSession)cache.get(id6).get(), 406L);
        cache.touch((FetchSession)cache.get(id8).get(), 406L);
        cache.touch((FetchSession)cache.get(id10).get(), 406L);
        int id11 = cache.maybeCreateSession(407L, true, 40, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id8, id11}));
        cache.touch((FetchSession)cache.get(id6).get(), 407L);
        int id12 = cache.maybeCreateSession(508L, true, 50, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id11, id12}));
    }

    @Test
    public void testSameSizeSessionEviction() {
        FetchSessionCache privilegedCache = new FetchSessionCache(2, 100L);
        int id1 = privilegedCache.maybeCreateSession(0L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = privilegedCache.maybeCreateSession(0L, true, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        FetchSessionCache unprivilegedCache = new FetchSessionCache(2, 100L);
        int id3 = unprivilegedCache.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id4 = unprivilegedCache.maybeCreateSession(0L, false, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        Assertions.assertEquals((int)0, (int)privilegedCache.maybeCreateSession(99L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)unprivilegedCache.maybeCreateSession(99L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        privilegedCache.touch((FetchSession)privilegedCache.get(id1).get(), 101L);
        privilegedCache.touch((FetchSession)privilegedCache.get(id2).get(), 101L);
        Assertions.assertEquals((int)0, (int)privilegedCache.maybeCreateSession(102L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        unprivilegedCache.touch((FetchSession)unprivilegedCache.get(id3).get(), 101L);
        unprivilegedCache.touch((FetchSession)unprivilegedCache.get(id4).get(), 101L);
        Assertions.assertEquals((int)0, (int)unprivilegedCache.maybeCreateSession(102L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        FetchSessionCache privilegedCache2 = new FetchSessionCache(2, 100L);
        int id5 = privilegedCache2.maybeCreateSession(0L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id6 = privilegedCache2.maybeCreateSession(0L, true, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        FetchSessionCache unprivilegedCache2 = new FetchSessionCache(2, 100L);
        int id7 = unprivilegedCache2.maybeCreateSession(0L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id8 = unprivilegedCache2.maybeCreateSession(0L, false, 20, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        privilegedCache2.touch((FetchSession)privilegedCache2.get(id5).get(), 98L);
        privilegedCache2.touch((FetchSession)privilegedCache2.get(id6).get(), 98L);
        Assertions.assertEquals((int)0, (int)privilegedCache2.maybeCreateSession(99L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)privilegedCache2.maybeCreateSession(101L, true, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        unprivilegedCache2.touch((FetchSession)unprivilegedCache2.get(id7).get(), 98L);
        unprivilegedCache2.touch((FetchSession)unprivilegedCache2.get(id8).get(), 98L);
        Assertions.assertEquals((int)0, (int)unprivilegedCache2.maybeCreateSession(99L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)unprivilegedCache2.maybeCreateSession(101L, false, 10, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
    }

    @Test
    public void testActiveSessionEvictionsMeter() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(301L, false, 2, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        FetchSession session3 = (FetchSession)cache.get(id3).get();
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        cache.touch(session2, 402L);
        cache.touch(session3, 402L);
        int id4 = cache.maybeCreateSession(402L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id4}));
        Assertions.assertEquals((long)2L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)1L, (long)cache.activeSessionEvictionsMeter().count());
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, true, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    private java.util.List<TopicIdPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    public FetchRequest createRequest(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, boolean isFromFollower, short version) {
        return (FetchRequest)new FetchRequest.Builder(version, version, isFromFollower ? 1 : -1, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    public short createRequest$default$5() {
        return ApiKeys.FETCH.latestVersion();
    }

    public FetchRequest createRequestWithoutTopicIds(FetchMetadata metadata, java.util.Map<TopicPartition, FetchRequest.PartitionData> fetchData, java.util.List<TopicIdPartition> toForget, boolean isFromFollower) {
        return (FetchRequest)new FetchRequest.Builder(12, 12, isFromFollower ? 1 : -1, 0, 0, fetchData).metadata(metadata).removed(toForget).build();
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$7 = foo0.topicId();
        int x$12 = foo1.partition();
        long x$2 = 10L;
        int x$3 = 1;
        long x$4 = this.makeFetchPartition$default$3();
        int x$5 = this.makeFetchPartition$default$4();
        int x$6 = this.makeFetchPartition$default$6();
        .colon.colon x$8 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(x$12, x$2, x$4, x$5, x$3, x$6), (List)Nil$.MODULE$));
        String x$9 = this.makeFetchTopic$default$1();
        Uuid x$16 = bar1.topicId();
        int x$10 = bar1.partition();
        long x$11 = 10L;
        int x$122 = 2;
        long x$13 = this.makeFetchPartition$default$3();
        int x$14 = this.makeFetchPartition$default$4();
        int x$15 = this.makeFetchPartition$default$6();
        .colon.colon x$17 = new .colon.colon((Object)this.makeFetchPartition(x$10, x$11, x$13, x$14, x$122, x$15), (List)Nil$.MODULE$);
        String x$18 = this.makeFetchTopic$default$1();
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchTopic(x$9, x$7, (Seq<FetchRequestData.FetchPartition>)x$8), (List)new .colon.colon((Object)this.makeFetchTopic(x$18, x$16, (Seq<FetchRequestData.FetchPartition>)x$17), (List)Nil$.MODULE$));
        int x$20 = this.makeFetchRequest$default$1();
        int x$21 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$22 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$20, x$21, (Seq<FetchRequestData.FetchTopic>)x$19, x$22);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        scala.collection.immutable.Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)foo0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)bar1));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        scala.collection.immutable.Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs2.apply((Object)foo0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)bar1));
        context2.updateAndGenerateResponseData(response).sessionId();
        Uuid x$29 = foo0.topicId();
        int x$23 = foo0.partition();
        long x$24 = 0L;
        int x$25 = 6;
        long x$26 = this.makeFetchPartition$default$3();
        int x$27 = this.makeFetchPartition$default$4();
        int x$28 = this.makeFetchPartition$default$6();
        .colon.colon x$30 = new .colon.colon((Object)this.makeFetchPartition(x$23, x$24, x$26, x$27, x$25, x$28), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$31 = this.makeFetchTopic$default$1();
        Uuid x$38 = (Uuid)topicIds.get(bar1.topic());
        int x$32 = bar1.partition();
        long x$33 = 10L;
        int x$34 = 3;
        long x$35 = this.makeFetchPartition$default$3();
        int x$36 = this.makeFetchPartition$default$4();
        int x$37 = this.makeFetchPartition$default$6();
        .colon.colon x$39 = new .colon.colon((Object)this.makeFetchPartition(x$32, x$33, x$35, x$36, x$34, x$37), (List)Nil$.MODULE$);
        String x$40 = this.makeFetchTopic$default$1();
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$31, x$29, (Seq<FetchRequestData.FetchPartition>)x$30), (List)new .colon.colon((Object)this.makeFetchTopic(x$40, x$38, (Seq<FetchRequestData.FetchPartition>)x$39), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        scala.collection.immutable.Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(version, fetchRequest3, false, topicNames));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)foo0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)bar1));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$7 = foo0.topicId();
        int x$1 = foo1.partition();
        long x$22 = 10L;
        int x$3 = 1;
        long x$4 = this.makeFetchPartition$default$3();
        int x$5 = this.makeFetchPartition$default$4();
        int x$6 = this.makeFetchPartition$default$6();
        .colon.colon x$8 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(x$1, x$22, x$4, x$5, x$3, x$6), (List)Nil$.MODULE$));
        String x$9 = this.makeFetchTopic$default$1();
        Uuid x$16 = bar1.topicId();
        int x$10 = bar1.partition();
        long x$11 = 10L;
        int x$12 = 2;
        int x$13 = 1;
        long x$14 = this.makeFetchPartition$default$3();
        int x$15 = this.makeFetchPartition$default$4();
        .colon.colon x$17 = new .colon.colon((Object)this.makeFetchPartition(x$10, x$11, x$14, x$15, x$12, x$13), (List)Nil$.MODULE$);
        String x$18 = this.makeFetchTopic$default$1();
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchTopic(x$9, x$7, (Seq<FetchRequestData.FetchPartition>)x$8), (List)new .colon.colon((Object)this.makeFetchTopic(x$18, x$16, (Seq<FetchRequestData.FetchPartition>)x$17), (List)Nil$.MODULE$));
        int x$20 = this.makeFetchRequest$default$1();
        int x$21 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$222 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$20, x$21, (Seq<FetchRequestData.FetchTopic>)x$19, x$222);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestData3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        requestData3.put(foo0.topicPartition(), new FetchRequest.PartitionData(foo0.topicId(), 0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        requestData3.put(foo1.topicPartition(), new FetchRequest.PartitionData(foo1.topicId(), 10L, 0L, 100, Optional.empty(), Optional.empty()));
        requestData3.put(bar1.topicPartition(), new FetchRequest.PartitionData(bar1.topicId(), 10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        Uuid x$29 = foo0.topicId();
        int x$23 = foo0.partition();
        long x$24 = 0L;
        int x$25 = 6;
        int x$26 = 5;
        long x$27 = this.makeFetchPartition$default$3();
        int x$28 = this.makeFetchPartition$default$4();
        .colon.colon x$30 = new .colon.colon((Object)this.makeFetchPartition(x$23, x$24, x$27, x$28, x$25, x$26), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$31 = this.makeFetchTopic$default$1();
        Uuid x$38 = bar1.topicId();
        int x$32 = bar1.partition();
        long x$33 = 10L;
        int x$34 = 3;
        int x$35 = 3;
        long x$36 = this.makeFetchPartition$default$3();
        int x$37 = this.makeFetchPartition$default$4();
        .colon.colon x$39 = new .colon.colon((Object)this.makeFetchPartition(x$32, x$33, x$36, x$37, x$34, x$35), (List)Nil$.MODULE$);
        String x$40 = this.makeFetchTopic$default$1();
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$31, x$29, (Seq<FetchRequestData.FetchPartition>)x$30), (List)new .colon.colon((Object)this.makeFetchTopic(x$40, x$38, (Seq<FetchRequestData.FetchPartition>)x$39), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        FetchContext context3 = fetchManager.newContext(version, fetchRequest3, false, topicNames);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    private void assertPartitionsInContext(FetchRequestData expectedFetchRequest, java.util.Map<Uuid, String> topicNames, FetchContext context) {
        Iterator iterator = ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(expectedFetchRequest.topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)topic -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicIdPartition(topic.topicId(), partition.partition(), (String)topicNames.get(topic.topicId()))), partition), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).iterator();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPartition, data) -> {
            FetchSessionTest.$anonfun$assertPartitionsInContext$3(iterator, topicNames, topicPartition, data);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar0 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 0));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        short version = ApiKeys.FETCH.latestVersion();
        int x$1 = -1;
        int x$2 = this.makeFetchRequest$default$1();
        Seq<FetchRequestData.FetchTopic> x$3 = this.makeFetchRequest$default$3();
        Seq<FetchRequestData.ForgottenTopic> x$42 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$2, x$1, x$3, x$42);
        FetchContext context = fetchManager.newContext(version, fetchRequest1, true, topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        Uuid x$5 = (Uuid)topicIds.get("foo");
        .colon.colon x$6 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$7 = this.makeFetchTopic$default$1();
        .colon.colon x$8 = new .colon.colon((Object)this.makeFetchTopic(x$7, x$5, (Seq<FetchRequestData.FetchPartition>)x$6), (List)Nil$.MODULE$);
        int x$9 = this.makeFetchRequest$default$1();
        int x$10 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$11 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(x$9, x$10, (Seq<FetchRequestData.FetchTopic>)x$8, x$11);
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        this.assertPartitionsInContext(fetchRequest2, topicNames, context2);
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo0).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo1).get()));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(respData2).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            FetchResponseData.PartitionData data = (FetchResponseData.PartitionData)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)tp.topicPartition(), (Object)data);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava(), (Object)resp2.responseData(topicNames, version));
        FetchContext context3 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId(), 5, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        fetchRequest2.setSessionId(resp2.sessionId() + 1).setSessionEpoch(1);
        FetchContext context4 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId() + 1, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        FetchRequestData fetchRequest3 = this.makeFetchRequest(resp2.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context5 = fetchManager.newContext(version, fetchRequest3, false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsInContext(fetchRequest2, topicNames, context5);
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(foo1).get()));
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        Iterator reqData5Iter = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0, foo1}))).iterator();
        context5.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$3(reqData5Iter, topicIdPart, data);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(foo1).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData(topicNames, version).size());
        FetchContext context6 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId(), 5, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        FetchResponse resp7 = fetchManager.newContext(version, this.makeFetchRequest(resp2.sessionId(), 2, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            Uuid x$12 = (Uuid)topicIds.get("bar");
            .colon.colon x$13 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
            String x$14 = this.makeFetchTopic$default$1();
            FetchRequestData fetchRequest8 = this.makeFetchRequest(prevSessionId, -1, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(x$14, x$12, (Seq<FetchRequestData.FetchPartition>)x$13), (List)Nil$.MODULE$), this.makeFetchRequest$default$4());
            FetchContext context8 = fetchManager.newContext(version, fetchRequest8, false, topicNames);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cache.size());
            LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
            respData8.put(bar0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            respData8.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testIncrementalFetchSession(boolean usesTopicIds) {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = usesTopicIds ? (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava() : (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        short version = usesTopicIds ? ApiKeys.FETCH.latestVersion() : (short)12;
        Uuid fooId = topicIds.getOrDefault("foo", Uuid.ZERO_UUID);
        Uuid barId = topicIds.getOrDefault("bar", Uuid.ZERO_UUID);
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition bar0 = new TopicIdPartition(barId, new TopicPartition("bar", 0));
        TopicIdPartition bar2 = new TopicIdPartition(barId, new TopicPartition("bar", 2));
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", fooId, (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest0 = this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest0, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopicPartition(bar0, 15L, this.makeFetchTopicPartition$default$3(), this.makeFetchTopicPartition$default$4(), this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$), (Seq<FetchRequestData.ForgottenTopic>)new .colon.colon((Object)this.makeForgottenTopic("foo", fooId, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{foo0.partition()})))), (List)Nil$.MODULE$));
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo1, bar0}))).iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, x$6) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$2(reqData2Iter, topicPart, x$6);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(foo0));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo1).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(bar0).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(bar2));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(bar0, new FetchResponseData.PartitionData().setPartitionIndex(bar0.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData(topicNames, version).size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionWithUnknownIdOldRequestVersion() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 1));
        short version = (short)12;
        String x$1 = foo0.topic();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        Uuid x$3 = this.makeFetchTopic$default$2();
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$1, x$3, (Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = this.makeFetchRequest$default$1();
        int x$6 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$72 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$5, x$6, (Seq<FetchRequestData.FetchTopic>)x$4, x$72);
        java.util.Map topicNamesOnlyBar = Collections.singletonMap(topicIds.get("bar"), "bar");
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        resp1.responseData(topicNames, version).forEach((tp, resp) -> Assertions.assertEquals((short)Errors.NONE.code(), (short)resp.errorCode(), (String)new StringBuilder(62).append("Unexpected response from TopicPartition: ").append(tp).append(". ").append("Expected ").append(Errors.NONE.code()).append(" but got ").append(resp.errorCode()).append(".").toString()));
    }

    @Test
    public void testFetchSessionWithUnknownId() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        Uuid barId = Uuid.randomUuid();
        Uuid zarId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zarId), (Object)"zar")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        TopicIdPartition zar0 = new TopicIdPartition(zarId, new TopicPartition("zar", 0));
        TopicIdPartition emptyFoo0 = new TopicIdPartition(fooId, new TopicPartition(null, 0));
        TopicIdPartition emptyFoo1 = new TopicIdPartition(fooId, new TopicPartition(null, 1));
        TopicIdPartition emptyZar0 = new TopicIdPartition(zarId, new TopicPartition(null, 0));
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$1 = foo0.topicId();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$3 = this.makeFetchTopic$default$1();
        Uuid x$4 = zar0.topicId();
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchPartition(zar0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$);
        String x$6 = this.makeFetchTopic$default$1();
        .colon.colon x$7 = new .colon.colon((Object)this.makeFetchTopic(x$3, x$1, (Seq<FetchRequestData.FetchPartition>)x$2), (List)new .colon.colon((Object)this.makeFetchTopic(x$6, x$4, (Seq<FetchRequestData.FetchPartition>)x$5), (List)Nil$.MODULE$));
        int x$8 = this.makeFetchRequest$default$1();
        int x$9 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$10 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$8, x$9, (Seq<FetchRequestData.FetchTopic>)x$7, x$10);
        java.util.Map<Uuid, String> topicNamesOnlyBar = Collections.singletonMap(barId, "bar");
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNamesOnlyBar);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (Seq<TopicIdPartition>)new .colon.colon((Object)emptyFoo0, (List)new .colon.colon((Object)emptyFoo1, (List)new .colon.colon((Object)emptyZar0, (List)Nil$.MODULE$))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(emptyFoo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyFoo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        respData1.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)resp1.responseData(topicNames, version)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        java.util.Map topicNamesNoZar = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)barId), (Object)"bar")}))).asJava();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), fetchRequest2, false, topicNamesNoZar);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)emptyZar0, (List)Nil$.MODULE$))));
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(emptyZar0, new FetchResponseData.PartitionData().setPartitionIndex(1).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)resp2.responseData(topicNames, version).size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar0.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)resp2.responseData(topicNames, version)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testIncrementalFetchSessionWithIdsWhenSessionDoesNotUseIds() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.ZERO_UUID, new TopicPartition("foo", 0));
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", Uuid.ZERO_UUID, (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext context1 = fetchManager.newContext((short)12, fetchRequest1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Uuid fooId = Uuid.randomUuid();
        topicNames.put(fooId, "foo");
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(ApiKeys.FETCH.latestVersion(), fetchRequest2, false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testIncrementalFetchSessionWithoutIdsWhenSessionUsesIds() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        topicNames.put(fooId, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$);
        String x$3 = this.makeFetchTopic$default$1();
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = this.makeFetchRequest$default$1();
        int x$6 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$5, x$6, (Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        topicNames.remove(fooId);
        Uuid newFooId = Uuid.randomUuid();
        topicNames.put(newFooId, "foo");
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext((short)12, fetchRequest2, false, topicNames);
        Assertions.assertEquals(SessionErrorContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_TOPIC_ID_ERROR, (Object)context2.updateAndGenerateResponseData(respData2).error());
    }

    @Test
    public void testFetchSessionUpdateTopicIdsBrokerSide() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition foo0 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 0));
        TopicIdPartition bar1 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 1));
        short version = ApiKeys.FETCH.latestVersion();
        Uuid x$1 = (Uuid)topicIds.get(foo0.topic());
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$);
        String x$3 = this.makeFetchTopic$default$1();
        Uuid x$4 = (Uuid)topicIds.get(bar1.topic());
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchPartition(bar1.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$);
        String x$6 = this.makeFetchTopic$default$1();
        .colon.colon x$7 = new .colon.colon((Object)this.makeFetchTopic(x$3, x$1, (Seq<FetchRequestData.FetchPartition>)x$2), (List)new .colon.colon((Object)this.makeFetchTopic(x$6, x$4, (Seq<FetchRequestData.FetchPartition>)x$5), (List)Nil$.MODULE$));
        int x$82 = this.makeFetchRequest$default$1();
        int x$9 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$10 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$82, x$9, (Seq<FetchRequestData.FetchTopic>)x$7, x$10);
        FetchContext context1 = fetchManager.newContext(version, fetchRequest1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        java.util.Map topicNamesFooChanged = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicIds.get("bar")), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo")}))).asJava();
        FetchContext context2 = fetchManager.newContext(version, fetchRequest2, false, topicNamesFooChanged);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData2.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(Errors.INCONSISTENT_TOPIC_ID.code()));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
        LinkedHashMap responseData2 = resp2.responseData(topicNames, version);
        Assertions.assertEquals((short)Errors.INCONSISTENT_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData2.get(foo0.topicPartition())).errorCode());
    }

    private FetchResponseData.PartitionData noErrorResponse() {
        return new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L);
    }

    private FetchResponseData.PartitionData errorResponse(short errorCode) {
        return new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(-1L).setLastStableOffset(-1L).setLogStartOffset(-1L).setErrorCode(errorCode);
    }

    @Test
    public void testResolveUnknownPartitions() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("zar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        TopicIdPartition zarUnresolved = new TopicIdPartition(zar.topicId(), new TopicPartition(null, zar.partition()));
        FetchContext context1 = this.newContext$1(FetchMetadata.INITIAL, (Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (Seq<TopicIdPartition>)new .colon.colon((Object)fooUnresolved, (List)new .colon.colon((Object)barUnresolved, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        int sessionId = this.updateAndGenerateResponseData$1(context1);
        FetchContext context2 = this.newContext$1(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)barUnresolved, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context2);
        FetchContext context3 = this.newContext$1(new FetchMetadata(sessionId, 2), (Seq)new .colon.colon((Object)bar, (List)Nil$.MODULE$), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zarUnresolved, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context3);
        FetchContext context4 = this.newContext$1(new FetchMetadata(sessionId, 3), (Seq)Nil$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar.topicId()), (Object)zar.topic())})), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context4.getClass());
        this.assertPartitionsOrder(context4, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))));
        this.updateAndGenerateResponseData$1(context4);
        FetchContext context5 = this.newContext$1(new FetchMetadata(sessionId, 4), (Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsOrder(context4, (Seq<TopicIdPartition>)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)zar, (List)Nil$.MODULE$))));
    }

    @ParameterizedTest
    @MethodSource(value={"idUsageCombinations"})
    public void testToForgetPartitions(boolean fooStartsResolved, boolean fooEndsResolved) {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        TopicIdPartition fooUnresolved = new TopicIdPartition(foo.topicId(), new TopicPartition(null, foo.partition()));
        TopicIdPartition barUnresolved = new TopicIdPartition(bar.topicId(), new TopicPartition(null, bar.partition()));
        scala.collection.immutable.Map context1Names = fooStartsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext1 = fooStartsResolved ? foo : fooUnresolved;
        FetchContext context1 = this.newContext$2(FetchMetadata.INITIAL, (Seq)new .colon.colon((Object)fooContext1, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), (Seq)Nil$.MODULE$, context1Names, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        this.assertPartitionsOrder(context1, (Seq<TopicIdPartition>)new .colon.colon((Object)fooContext1, (List)new .colon.colon((Object)barUnresolved, (List)Nil$.MODULE$)));
        int sessionId = this.updateAndGenerateResponseData$2(context1);
        scala.collection.immutable.Map context2Names = fooEndsResolved ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())})) : Predef$.MODULE$.Map().empty();
        TopicIdPartition fooContext2 = fooEndsResolved ? foo : fooUnresolved;
        FetchContext context2 = this.newContext$2(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)fooContext2, (List)Nil$.MODULE$), context2Names, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)barUnresolved, (List)Nil$.MODULE$));
        this.updateAndGenerateResponseData$2(context2);
        FetchContext context3 = this.newContext$2(new FetchMetadata(sessionId, 2), (Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)bar, (List)Nil$.MODULE$), Predef$.MODULE$.Map().empty(), fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context3.getClass());
        this.assertPartitionsOrder(context3, (Seq<TopicIdPartition>)Nil$.MODULE$);
    }

    @Test
    public void testUpdateAndGenerateResponseData() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicIdPartition foo = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("foo", 0));
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("bar", 0));
        scala.collection.immutable.Map receivingBrokerTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic())}));
        scala.collection.immutable.Map sendingTopicNames = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo.topicId()), (Object)foo.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar.topicId()), (Object)bar.topic())}));
        FetchContext context1 = this.newContext$3(FetchMetadata.LEGACY, (Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionlessFetchContext.class, context1.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context1), foo, bar, sendingTopicNames);
        FetchContext context2 = this.newContext$3(FetchMetadata.INITIAL, (Seq)new .colon.colon((Object)foo, (List)new .colon.colon((Object)bar, (List)Nil$.MODULE$)), receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        FetchResponse response2 = this.updateAndGenerateResponseData$3(context2);
        int sessionId = response2.sessionId();
        FetchSessionTest.checkResponseData$1(response2, foo, bar, sendingTopicNames);
        FetchContext context3 = this.newContext$3(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(IncrementalFetchContext.class, context3.getClass());
        FetchSessionTest.checkResponseData$1(this.updateAndGenerateResponseData$3(context3), foo, bar, sendingTopicNames);
        FetchContext context4 = this.newContext$3(new FetchMetadata(sessionId, 1), (Seq)Nil$.MODULE$, receivingBrokerTopicNames, fetchManager);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals(Collections.emptyList(), (Object)this.updateAndGenerateResponseData$3(context4).data().responses());
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$3 = this.makeFetchTopic$default$1();
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = this.makeFetchRequest$default$1();
        int x$6 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData session1req = this.makeFetchRequest(x$5, x$6, (Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext session1context1 = fetchManager.newContext(version, session1req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$10 = this.makeFetchTopic$default$1();
        .colon.colon x$11 = new .colon.colon((Object)this.makeFetchTopic(x$10, fooId, (Seq<FetchRequestData.FetchPartition>)x$9), (List)Nil$.MODULE$);
        int x$12 = this.makeFetchRequest$default$1();
        int x$13 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$14 = this.makeFetchRequest$default$4();
        FetchRequestData session2req = this.makeFetchRequest(x$12, x$13, (Seq<FetchRequestData.FetchTopic>)x$11, x$14);
        FetchContext session2context = fetchManager.newContext(version, session2req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1.topicPartition(), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchContext context1v2 = fetchManager.newContext(version, this.makeFetchRequest(session1resp.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        .colon.colon x$16 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$17 = this.makeFetchTopic$default$1();
        .colon.colon x$18 = new .colon.colon((Object)this.makeFetchTopic(x$17, fooId, (Seq<FetchRequestData.FetchPartition>)x$16), (List)Nil$.MODULE$);
        int x$19 = this.makeFetchRequest$default$1();
        int x$20 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$21 = this.makeFetchRequest$default$4();
        FetchRequestData session3req = this.makeFetchRequest(x$19, x$20, (Seq<FetchRequestData.FetchTopic>)x$18, x$21);
        FetchContext session3context = fetchManager.newContext(version, session3req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 0)), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicIdPartition(fooId, new TopicPartition("foo", 1)), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$3 = this.makeFetchTopic$default$1();
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = this.makeFetchRequest$default$1();
        int x$6 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData session1req = this.makeFetchRequest(x$5, x$6, (Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext session1context = fetchManager.newContext(version, session1req, true, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData(topicNames, version).size());
        Assertions.assertEquals((int)1, (int)cache.size());
        time.sleep(500L);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$10 = this.makeFetchTopic$default$1();
        .colon.colon x$11 = new .colon.colon((Object)this.makeFetchTopic(x$10, fooId, (Seq<FetchRequestData.FetchPartition>)x$9), (List)Nil$.MODULE$);
        int x$12 = this.makeFetchRequest$default$1();
        int x$13 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$14 = this.makeFetchRequest$default$4();
        FetchRequestData session2req = this.makeFetchRequest(x$12, x$13, (Seq<FetchRequestData.FetchTopic>)x$11, x$14);
        FetchContext session2context = fetchManager.newContext(version, session2req, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        session2RespData.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(500L);
        .colon.colon x$16 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$17 = this.makeFetchTopic$default$1();
        .colon.colon x$18 = new .colon.colon((Object)this.makeFetchTopic(x$17, fooId, (Seq<FetchRequestData.FetchPartition>)x$16), (List)Nil$.MODULE$);
        int x$19 = this.makeFetchRequest$default$1();
        int x$20 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$21 = this.makeFetchRequest$default$4();
        FetchRequestData session3req = this.makeFetchRequest(x$19, x$20, (Seq<FetchRequestData.FetchTopic>)x$18, x$21);
        FetchContext session3context = fetchManager.newContext(version, session3req, true, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData(topicNames, version).size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(501L);
        .colon.colon x$23 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$24 = this.makeFetchTopic$default$1();
        .colon.colon x$25 = new .colon.colon((Object)this.makeFetchTopic(x$24, fooId, (Seq<FetchRequestData.FetchPartition>)x$23), (List)Nil$.MODULE$);
        int x$26 = this.makeFetchRequest$default$1();
        int x$27 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$28 = this.makeFetchRequest$default$4();
        FetchRequestData session4req = this.makeFetchRequest(x$26, x$27, (Seq<FetchRequestData.FetchTopic>)x$25, x$28);
        FetchContext session4context = fetchManager.newContext(version, session4req, true, topicNames);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData4.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData4.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData(topicNames, version).size());
        Assertions.assertFalse((boolean)cache.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        Uuid fooId = Uuid.randomUuid();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fooId), (Object)"foo")}))).asJava();
        TopicIdPartition foo0 = new TopicIdPartition(fooId, new TopicPartition("foo", 0));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, new TopicPartition("foo", 1));
        short version = ApiKeys.FETCH.latestVersion();
        .colon.colon x$2 = new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$));
        String x$3 = this.makeFetchTopic$default$1();
        .colon.colon x$4 = new .colon.colon((Object)this.makeFetchTopic(x$3, fooId, (Seq<FetchRequestData.FetchPartition>)x$2), (List)Nil$.MODULE$);
        int x$5 = this.makeFetchRequest$default$1();
        int x$6 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$7 = this.makeFetchRequest$default$4();
        FetchRequestData reqData1 = this.makeFetchRequest(x$5, x$6, (Seq<FetchRequestData.FetchTopic>)x$4, x$7);
        FetchContext context1 = fetchManager.newContext(version, reqData1, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData(topicNames, version).size());
        int x$11 = resp1.sessionId();
        int x$12 = 1;
        Seq x$9 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        String x$10 = this.makeForgottenTopic$default$1();
        .colon.colon x$13 = new .colon.colon((Object)this.makeForgottenTopic(x$10, fooId, (Seq<Object>)x$9), (List)Nil$.MODULE$);
        Seq<FetchRequestData.FetchTopic> x$14 = this.makeFetchRequest$default$3();
        FetchRequestData reqData2 = this.makeFetchRequest(x$11, x$12, x$14, (Seq<FetchRequestData.ForgottenTopic>)x$13);
        FetchContext context2 = fetchManager.newContext(version, reqData2, false, topicNames);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData(topicNames, version).isEmpty());
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"foo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Uuid.randomUuid()), (Object)"bar")}))).asJava();
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicNames).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition tp1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition tp2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        short version = ApiKeys.FETCH.latestVersion();
        long x$2 = 0L;
        int x$3 = 5;
        int x$4 = 4;
        long x$5 = this.makeFetchTopicPartition$default$3();
        int x$6 = this.makeFetchTopicPartition$default$4();
        long x$8 = 0L;
        int x$9 = 5;
        int x$10 = 4;
        long x$11 = this.makeFetchTopicPartition$default$3();
        int x$122 = this.makeFetchTopicPartition$default$4();
        .colon.colon x$13 = new .colon.colon((Object)this.makeFetchTopicPartition(tp1, x$2, x$5, x$6, x$3, x$4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(tp2, x$8, x$11, x$122, x$9, x$10), (List)Nil$.MODULE$));
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$16 = this.makeFetchRequest$default$4();
        FetchRequestData reqData = this.makeFetchRequest(x$14, x$15, (Seq<FetchRequestData.FetchTopic>)x$13, x$16);
        FetchContext context1 = fetchManager.newContext(version, reqData, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L));
        FetchResponseData.EpochEndOffset divergingEpoch = new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L);
        respData.put(tp2, new FetchResponseData.PartitionData().setPartitionIndex(tp2.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp1.responseData(topicNames, version).keySet());
        FetchContext context2 = fetchManager.newContext(version, this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(tp2.topicPartition()), resp2.responseData(topicNames, version).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp3.responseData(topicNames, version).keySet());
        respData.put(tp1, new FetchResponseData.PartitionData().setPartitionIndex(tp1.partition()).setHighWatermark(110L).setLastStableOffset(110L).setLogStartOffset(0L));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1.topicPartition(), tp2.topicPartition()}), resp4.responseData(topicNames, version).keySet());
    }

    @Test
    public void testDeprioritizesPartitionsWithRecordsOnly() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        java.util.Map topicIds = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zar"), (Object)Uuid.randomUuid())}))).asJava();
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(topicIds).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.swap(), Map$.MODULE$.canBuildFrom())).asJava();
        TopicIdPartition foo1 = new TopicIdPartition((Uuid)topicIds.get("foo"), new TopicPartition("foo", 1));
        TopicIdPartition bar2 = new TopicIdPartition((Uuid)topicIds.get("bar"), new TopicPartition("bar", 2));
        TopicIdPartition zar3 = new TopicIdPartition((Uuid)topicIds.get("zar"), new TopicPartition("zar", 3));
        short version = ApiKeys.FETCH.latestVersion();
        long x$2 = 0L;
        int x$3 = 5;
        int x$4 = 4;
        long x$5 = this.makeFetchTopicPartition$default$3();
        int x$6 = this.makeFetchTopicPartition$default$4();
        long x$8 = 0L;
        int x$9 = 5;
        int x$10 = 4;
        long x$11 = this.makeFetchTopicPartition$default$3();
        int x$12 = this.makeFetchTopicPartition$default$4();
        long x$14 = 0L;
        int x$15 = 5;
        int x$16 = 4;
        long x$17 = this.makeFetchTopicPartition$default$3();
        int x$18 = this.makeFetchTopicPartition$default$4();
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchTopicPartition(foo1, x$2, x$5, x$6, x$3, x$4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar2, x$8, x$11, x$12, x$9, x$10), (List)new .colon.colon((Object)this.makeFetchTopicPartition(zar3, x$14, x$17, x$18, x$15, x$16), (List)Nil$.MODULE$)));
        int x$20 = this.makeFetchRequest$default$1();
        int x$21 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$22 = this.makeFetchRequest$default$4();
        FetchRequestData reqData = this.makeFetchRequest(x$20, x$21, (Seq<FetchRequestData.FetchTopic>)x$19, x$22);
        FetchContext context1 = fetchManager.newContext(version, reqData, false, topicNames);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(zar3, new FetchResponseData.PartitionData().setPartitionIndex(zar3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1.topicPartition(), bar2.topicPartition(), zar3.topicPartition()}), resp1.responseData(topicNames, version).keySet());
        FetchContext context2 = fetchManager.newContext(version, this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false, topicNames);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar2, (List)new .colon.colon((Object)zar3, (List)Nil$.MODULE$))));
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.emptySet(), resp2.responseData(topicNames, version).keySet());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData3.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(100L, null)})));
        respData3.put(zar3, new FetchResponseData.PartitionData().setPartitionIndex(zar3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1.topicPartition(), bar2.topicPartition()}), resp3.responseData(topicNames, version).keySet());
        this.assertPartitionsOrder(context2, (Seq<TopicIdPartition>)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)zar3, (List)new .colon.colon((Object)bar2, (List)Nil$.MODULE$))));
    }

    private void assertPartitionsOrder(FetchContext context, Seq<TopicIdPartition> partitions) {
        ArrayBuffer partitionsInContext = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, x$14) -> {
            partitionsInContext.$plus$eq((Object)tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(partitions, (Object)partitionsInContext.toSeq());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSessionUpdate() {
        void var43_43;
        void var42_42;
        void var41_41;
        void var28_28;
        void var27_27;
        void var26_26;
        void var15_15;
        void var14_14;
        void var13_13;
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.maybeAddListener((TopicPartition)ArgumentMatchers.any(), (PartitionListener)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchSession session = new FetchSession(0, false, new ImplicitLinkedHashCollection(), true, 0L, 0L, 0);
        TopicIdPartition foo0 = new TopicIdPartition(Uuid.randomUuid(), 0, "foo");
        TopicIdPartition bar1 = new TopicIdPartition(Uuid.randomUuid(), 1, "bar");
        TopicIdPartition zar2 = new TopicIdPartition(Uuid.randomUuid(), 2, "zar");
        java.util.Map topicNames = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0.topicId()), (Object)foo0.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1.topicId()), (Object)bar1.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)zar2.topicId()), (Object)zar2.topic())}))).asJava();
        boolean fetchRequestUsesTopicIds = true;
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopicPartition(foo0, 10L, 1L, this.makeFetchTopicPartition$default$4(), this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar1, 20L, 2L, 200, this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$));
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        Tuple3 tuple3 = session.update(fetchRequestUsesTopicIds, this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4), topicNames);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        ArrayList added1 = (ArrayList)tuple3._1();
        ArrayList updated1 = (ArrayList)tuple3._2();
        ArrayList removed1 = (ArrayList)tuple3._3();
        void added12 = var13_13;
        void updated12 = var14_14;
        void removed12 = var15_15;
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)2, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0, bar1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)added12).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)updated12).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)removed12).asScala()).toSet());
        IncrementalPartitionFetchMetadata foo0Metadata = FetchSessionTest.assertPartitionState$1(foo0, 10L, 1L, 100, Optional.empty(), Optional.empty(), session);
        IncrementalPartitionFetchMetadata bar1Metadata = FetchSessionTest.assertPartitionState$1(bar1, 20L, 2L, 200, Optional.empty(), Optional.empty(), session);
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchTopicPartition(foo0, 30L, 3L, 300, 2, 1), (List)new .colon.colon((Object)this.makeFetchTopicPartition(zar2, 50L, 5L, 500, this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$));
        int x$6 = this.makeFetchRequest$default$1();
        int x$7 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$8 = this.makeFetchRequest$default$4();
        Tuple3 tuple32 = session.update(fetchRequestUsesTopicIds, this.makeFetchRequest(x$6, x$7, (Seq<FetchRequestData.FetchTopic>)x$5, x$8), topicNames);
        if (tuple32 == null) {
            throw new MatchError(null);
        }
        ArrayList added2 = (ArrayList)tuple32._1();
        ArrayList updated2 = (ArrayList)tuple32._2();
        ArrayList removed2 = (ArrayList)tuple32._3();
        void added22 = var26_26;
        void updated22 = var27_27;
        void removed22 = var28_28;
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)3, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)added22).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)updated22).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)removed22).asScala()).toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 30L, 3L, 300, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1)), session);
        FetchSessionTest.assertPartitionState$1(bar1, 20L, 2L, 200, Optional.empty(), Optional.empty(), session);
        IncrementalPartitionFetchMetadata zar2Metadata = FetchSessionTest.assertPartitionState$1(zar2, 50L, 5L, 500, Optional.empty(), Optional.empty(), session);
        .colon.colon x$12 = new .colon.colon((Object)this.makeFetchTopicPartition(zar2, 100L, 55L, this.makeFetchTopicPartition$default$4(), this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$);
        Uuid x$9 = bar1.topicId();
        Seq x$10 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{bar1.partition()}));
        String x$11 = this.makeForgottenTopic$default$1();
        .colon.colon x$13 = new .colon.colon((Object)this.makeForgottenTopic(x$11, x$9, (Seq<Object>)x$10), (List)Nil$.MODULE$);
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Tuple3 tuple33 = session.update(fetchRequestUsesTopicIds, this.makeFetchRequest(x$14, x$15, (Seq<FetchRequestData.FetchTopic>)x$12, (Seq<FetchRequestData.ForgottenTopic>)x$13), topicNames);
        if (tuple33 == null) {
            throw new MatchError(null);
        }
        ArrayList added3 = (ArrayList)tuple33._1();
        ArrayList updated3 = (ArrayList)tuple33._2();
        ArrayList removed3 = (ArrayList)tuple33._3();
        void added32 = var41_41;
        void updated32 = var42_42;
        void removed32 = var43_43;
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)2, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)added32).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)updated32).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{bar1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)removed32).asScala()).toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 30L, 3L, 300, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1)), session);
        FetchSessionTest.assertPartitionRemoved$1(bar1, session);
        FetchSessionTest.assertPartitionState$1(zar2, 100L, 55L, 100, Optional.empty(), Optional.empty(), session);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(foo0.topicPartition(), (PartitionListener)foo0Metadata);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(bar1.topicPartition(), (PartitionListener)bar1Metadata);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(zar2.topicPartition(), (PartitionListener)zar2Metadata);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).removeListener(bar1.topicPartition(), (PartitionListener)bar1Metadata);
    }

    @Test
    public void testSessionClose() {
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        IncrementalPartitionFetchMetadata partition1 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("foo", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition1);
        topicIds.put(partition1.topic(), partition1.topicId());
        IncrementalPartitionFetchMetadata partition2 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("bar", Uuid.randomUuid(), 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition2);
        topicIds.put(partition2.topic(), partition2.topicId());
        new FetchSession(0, false, cacheMap, true, 0L, 0L, 0).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition1)).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition2)).close();
    }

    private FetchRequestData makeFetchRequest(int sessionId, int sessionEpoch, Seq<FetchRequestData.FetchTopic> topics, Seq<FetchRequestData.ForgottenTopic> forgottenTopics) {
        return new FetchRequestData().setSessionId(sessionId).setSessionEpoch(sessionEpoch).setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).setForgottenTopicsData((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(forgottenTopics).asJava());
    }

    private int makeFetchRequest$default$1() {
        return 0;
    }

    private int makeFetchRequest$default$2() {
        return 0;
    }

    private Seq<FetchRequestData.FetchTopic> makeFetchRequest$default$3() {
        return Nil$.MODULE$;
    }

    private Seq<FetchRequestData.ForgottenTopic> makeFetchRequest$default$4() {
        return Nil$.MODULE$;
    }

    private FetchRequestData.FetchTopic makeFetchTopicPartition(TopicIdPartition topicIdPartition, long fetchOffset, long logStartOffset, int maxBytes, int currentLeaderEpoch, int lastFetchedEpoch) {
        return this.makeFetchTopic(topicIdPartition.topic(), topicIdPartition.topicId(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(topicIdPartition.partition(), fetchOffset, logStartOffset, maxBytes, currentLeaderEpoch, lastFetchedEpoch), (List)Nil$.MODULE$));
    }

    private FetchRequestData.FetchTopic makeFetchTopic(String topic, Uuid topicId, Seq<FetchRequestData.FetchPartition> partitions) {
        return new FetchRequestData.FetchTopic().setTopic(topic).setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava());
    }

    private long makeFetchTopicPartition$default$3() {
        return 0L;
    }

    private int makeFetchTopicPartition$default$4() {
        return 100;
    }

    private int makeFetchTopicPartition$default$5() {
        return -1;
    }

    private int makeFetchTopicPartition$default$6() {
        return -1;
    }

    private String makeFetchTopic$default$1() {
        return "";
    }

    private Uuid makeFetchTopic$default$2() {
        return Uuid.ZERO_UUID;
    }

    private FetchRequestData.FetchPartition makeFetchPartition(int partition, long fetchOffset, long logStartOffset, int maxBytes, int currentLeaderEpoch, int lastFetchedEpoch) {
        return new FetchRequestData.FetchPartition().setPartition(partition).setFetchOffset(fetchOffset).setLogStartOffset(logStartOffset).setPartitionMaxBytes(maxBytes).setCurrentLeaderEpoch(currentLeaderEpoch).setLastFetchedEpoch(lastFetchedEpoch);
    }

    private long makeFetchPartition$default$3() {
        return 0L;
    }

    private int makeFetchPartition$default$4() {
        return 100;
    }

    private int makeFetchPartition$default$5() {
        return -1;
    }

    private int makeFetchPartition$default$6() {
        return -1;
    }

    private FetchRequestData.ForgottenTopic makeForgottenTopic(String topic, Uuid topicId, Seq<Object> partitions) {
        return new FetchRequestData.ForgottenTopic().setTopic(topic).setTopicId(topicId).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions.map((Function1 & Serializable & scala.Serializable)x -> FetchSessionTest.$anonfun$makeForgottenTopic$1(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    private String makeForgottenTopic$default$1() {
        return "";
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch()));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch()));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    private static final scala.collection.immutable.Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch()));
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)mapBuilder.result();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assertPartitionsInContext$3(Iterator iterator$1, java.util.Map topicNames$1, TopicIdPartition topicPartition, PartitionFetchMetadata data) {
        void var6_6;
        void var5_5;
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Tuple2 tuple2 = (Tuple2)iterator$1.next();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicIdPartition expectedTopicPartition = (TopicIdPartition)tuple2._1();
        FetchRequestData.FetchPartition expectedPartition = (FetchRequestData.FetchPartition)tuple2._2();
        void expectedTopicPartition2 = var5_5;
        void expectedPartition2 = var6_6;
        Assertions.assertEquals((Object)expectedTopicPartition2, (Object)topicPartition);
        Assertions.assertEquals((Object)expectedTopicPartition2.topic(), topicNames$1.get(data.topicId()));
        Assertions.assertEquals((long)expectedPartition2.fetchOffset(), (long)data.fetchOffset());
        Assertions.assertEquals((long)expectedPartition2.logStartOffset(), (long)data.startOffset());
        Assertions.assertEquals((int)expectedPartition2.partitionMaxBytes(), (int)data.maxBytes());
        Assertions.assertEquals((Object)RequestUtils.getLeaderEpoch((int)expectedPartition2.currentLeaderEpoch()), (Object)data.currentLeaderEpoch());
        Assertions.assertEquals((Object)RequestUtils.getLeaderEpoch((int)expectedPartition2.lastFetchedEpoch()), (Object)data.lastFetchedEpoch());
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$3(Iterator reqData5Iter$1, TopicIdPartition topicIdPart, PartitionFetchMetadata data) {
        TopicIdPartition tidp = (TopicIdPartition)reqData5Iter$1.next();
        Assertions.assertEquals((Object)tidp.topicPartition(), (Object)topicIdPart.topicPartition());
        Assertions.assertEquals((Object)tidp.topicId(), (Object)topicIdPart.topicId());
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$2(Iterator reqData2Iter$1, TopicIdPartition topicPart, PartitionFetchMetadata x$6) {
        Assertions.assertEquals((Object)reqData2Iter$1.next(), (Object)topicPart);
    }

    private final FetchContext newContext$1(FetchMetadata metadata, Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$1.newContext(fetchRequest.version(), fetchRequest.data(), fetchRequest.isFromFollower(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$1(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPartition, x$9) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$2(FetchMetadata metadata, Seq partitions, Seq toForget, scala.collection.immutable.Map topicNames, FetchManager fetchManager$2) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)toForget.toList()).asJava(), false, this.createRequest$default$5());
        return fetchManager$2.newContext(fetchRequest.version(), fetchRequest.data(), fetchRequest.isFromFollower(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava());
    }

    private final int updateAndGenerateResponseData$2(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPartition, x$10) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.noErrorResponse());
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data).sessionId();
    }

    private final FetchContext newContext$3(FetchMetadata metadata, Seq partitions, scala.collection.immutable.Map topicNames, FetchManager fetchManager$3) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> data = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitions.foreach((Function1 & Serializable & scala.Serializable)topicIdPartition -> data.put(topicIdPartition.topicPartition(), new FetchRequest.PartitionData(topicIdPartition.topicId(), 0L, 0L, 100, Optional.empty())));
        FetchRequest fetchRequest = this.createRequest(metadata, data, this.EMPTY_PART_LIST(), false, this.createRequest$default$5());
        return fetchManager$3.newContext(fetchRequest.version(), fetchRequest.data(), fetchRequest.isFromFollower(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava());
    }

    private final FetchResponse updateAndGenerateResponseData$3(FetchContext context) {
        LinkedHashMap data = new LinkedHashMap();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicIdPartition, x$11) -> {
            data.put(topicIdPartition, topicIdPartition.topic() == null ? this.errorResponse(Errors.UNKNOWN_TOPIC_ID.code()) : this.errorResponse(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()));
            return BoxedUnit.UNIT;
        });
        return context.updateAndGenerateResponseData(data);
    }

    private static final void checkResponseData$1(FetchResponse response, TopicIdPartition foo$1, TopicIdPartition bar$1, scala.collection.immutable.Map sendingTopicNames$1) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar$1.topicPartition()), (Object)BoxesRunTime.boxToShort((short)Errors.UNKNOWN_TOPIC_ID.code()))})), (Object)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)response.responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)sendingTopicNames$1).asJava(), ApiKeys.FETCH.latestVersion())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            FetchResponseData.PartitionData resp = (FetchResponseData.PartitionData)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToShort((short)resp.errorCode()));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
    }

    private static final IncrementalPartitionFetchMetadata assertPartitionState$1(TopicIdPartition tp, long fetchOffset, long startOffset, int maxBytes, Optional currentLeaderEpoch, Optional lastFetchedEpoch, FetchSession session$1) {
        IncrementalPartitionFetchMetadata partitionMetadata = (IncrementalPartitionFetchMetadata)session$1.partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(tp.topic(), tp.topicId(), tp.partition()));
        Assertions.assertNotNull((Object)partitionMetadata, (String)new StringBuilder(23).append("Metadata of ").append(tp).append(" not found.").toString());
        Assertions.assertEquals((long)fetchOffset, (long)partitionMetadata.fetchOffset());
        Assertions.assertEquals((long)startOffset, (long)partitionMetadata.startOffset());
        Assertions.assertEquals((int)maxBytes, (int)partitionMetadata.maxBytes());
        Assertions.assertEquals((Object)currentLeaderEpoch, (Object)partitionMetadata.currentLeaderEpoch());
        Assertions.assertEquals((Object)lastFetchedEpoch, (Object)partitionMetadata.lastFetchedEpoch());
        return partitionMetadata;
    }

    private static final void assertPartitionRemoved$1(TopicIdPartition tp, FetchSession session$1) {
        Assertions.assertNull((Object)((IncrementalPartitionFetchMetadata)session$1.partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(tp.topic(), tp.topicId(), tp.partition()))), (String)new StringBuilder(25).append("Metadata of ").append(tp).append(" not deleted.").toString());
    }

    private static final void maybeRegisterListeners$1(FetchSession session$1, ReplicaManager replicaManager$1) {
        session$1.partitionMap().forEach(partitionMetadata -> partitionMetadata.maybeRegisterAsListener(replicaManager$1));
    }

    public static final /* synthetic */ Integer $anonfun$makeForgottenTopic$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

