/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y2A\u0001B\u0003\u0001\u0015!)q\u0002\u0001C\u0001!!)!\u0003\u0001C\u0001'!)q\u0005\u0001C\u0005Q\tIB)\u001a7fi\u0016lUm]:bO\u0016\u001c(+Z9vKN$H+Z:u\u0015\t1q!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0011\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\f!\taQ\"D\u0001\u0006\u0013\tqQAA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\r\u0001\u0005IE/Z:u\t\u0016dW\r^3SK\u000e|'\u000fZ:SKF,Xm\u001d;EkJLgn\u001a)beRLG/[8o%\u0016\u001cwN^3ss\u00063G/\u001a:V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8\u0015\u0003Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011A!\u00168ji\"\u0012!a\u0007\t\u00039\u0015j\u0011!\b\u0006\u0003=}\t1!\u00199j\u0015\t\u0001\u0013%A\u0004kkBLG/\u001a:\u000b\u0005\t\u001a\u0013!\u00026v]&$(\"\u0001\u0013\u0002\u0007=\u0014x-\u0003\u0002';\t!A+Z:u\u0003a\u0019XM\u001c3EK2,G/\u001a*fG>\u0014Hm\u001d*fcV,7\u000f\u001e\u000b\u0004SQJ\u0004C\u0001\u00163\u001b\u0005Y#B\u0001\u0017.\u0003!\u0011X-];fgR\u001c(B\u0001\u00180\u0003\u0019\u0019w.\\7p]*\u0011\u0001\u0002\r\u0006\u0003c\r\na!\u00199bG\",\u0017BA\u001a,\u0005U!U\r\\3uKJ+7m\u001c:egJ+7\u000f]8og\u0016DQ!N\u0002A\u0002Y\n\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003+]J!\u0001\u000f\f\u0003\u0007%sG\u000fC\u0003;\u0007\u0001\u00071(A\u0004sKF,Xm\u001d;\u0011\u0005)b\u0014BA\u001f,\u0005Q!U\r\\3uKJ+7m\u001c:egJ+\u0017/^3ti\u0002")
public class DeleteMessagesRequestTest
extends BaseRequestTest {
    @Test
    public void testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "test-topic";
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        Set replicas = this.zkClient().getReplicasForPartition(topicPartition).toSet();
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DeleteMessagesRequestTest.$anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        Partition partition = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteMessagesRequestTest.$anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(leader, x$4))).get()).replicaManager().getPartitionOrException(topicPartition);
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), topic, 500, -1);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteMessagesRequestTest.$anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$5))).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERED);
        this.deleteRecordsAndValidateResponse$1(leader, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NONE.code(), topic);
        this.deleteRecordsAndValidateResponse$1(follower, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
        this.deleteRecordsAndValidateResponse$1(nonReplica, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteMessagesRequestTest.$anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(leader, x$6))).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERING);
        this.deleteRecordsAndValidateResponse$1(leader, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
        this.deleteRecordsAndValidateResponse$1(follower, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
        this.deleteRecordsAndValidateResponse$1(nonReplica, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
        TestUtils$.MODULE$.forceOverrideLeaderRecoveryState(((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteMessagesRequestTest.$anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(leader, x$7))).get()).replicaManager().getPartitionOrException(topicPartition), LeaderRecoveryState.RECOVERED);
        this.deleteRecordsAndValidateResponse$1(leader, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NONE.code(), topic);
        this.deleteRecordsAndValidateResponse$1(follower, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
        this.deleteRecordsAndValidateResponse$1(nonReplica, Predef$.MODULE$.long2Long(partition.logStartOffset() + 10L), Errors.NOT_LEADER_OR_FOLLOWER.code(), topic);
    }

    private DeleteRecordsResponse sendDeleteRecordsRequest(int brokerId, DeleteRecordsRequest request) {
        return (DeleteRecordsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteRecordsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public static final /* synthetic */ int $anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(int leader$1, KafkaServer x$4) {
        return x$4.config().brokerId() == leader$1;
    }

    private final void deleteRecordsAndValidateResponse$1(int brokerId, Long offset, int errorCode, String topic$1) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.DELETE_RECORDS.oldestVersion()), (int)ApiKeys.DELETE_RECORDS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ver -> {
            DeleteRecordsRequestData.DeleteRecordsPartition deleteRecordsPartition = new DeleteRecordsRequestData.DeleteRecordsPartition().setPartitionIndex(0).setOffset(Predef$.MODULE$.Long2long(offset));
            DeleteRecordsRequestData.DeleteRecordsTopic deleteRecordsTopic = new DeleteRecordsRequestData.DeleteRecordsTopic().setName(topic$1).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)deleteRecordsPartition, (List)Nil$.MODULE$)).asJava());
            DeleteRecordsRequestData deleteRecordsRequestData = new DeleteRecordsRequestData().setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)deleteRecordsTopic, (List)Nil$.MODULE$)).asJava()).setTimeoutMs(15000);
            DeleteRecordsRequest request = new DeleteRecordsRequest.Builder(deleteRecordsRequestData).build((short)ver);
            DeleteRecordsResponse deleteRecordsResponse = this.sendDeleteRecordsRequest(brokerId, request);
            Assertions.assertEquals((int)1, (int)deleteRecordsResponse.data().topics().size(), (String)"Response for unexpected number of topics");
            Assertions.assertEquals((Object)topic$1, (Object)deleteRecordsResponse.data().topics().find(topic$1).name(), (String)"Response for expected topic not found");
            Assertions.assertEquals((int)1, (int)deleteRecordsResponse.data().topics().find(topic$1).partitions().size(), (String)"Response for unexpected number of partitions");
            Assertions.assertNotNull((Object)deleteRecordsResponse.data().topics().find(topic$1).partitions().find(0), (String)"Response for expected partition not found");
            Assertions.assertEquals((int)errorCode, (int)deleteRecordsResponse.data().topics().find(topic$1).partitions().find(0).errorCode(), (String)"Unexpected error for tested partition");
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$1, KafkaServer x$5) {
        return x$5.config().brokerId() == leader$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$7(int leader$1, KafkaServer x$6) {
        return x$6.config().brokerId() == leader$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteRecordsRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(int leader$1, KafkaServer x$7) {
        return x$7.config().brokerId() == leader$1;
    }
}

