/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.server.ConfluentObserverTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Iterable$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

public final class ConfluentObserverTest$ {
    public static ConfluentObserverTest$ MODULE$;

    static {
        new ConfluentObserverTest$();
    }

    public AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        List configEntries = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfigs).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    public Map<String, Object> createConfig(Seq<KafkaServer> servers) {
        return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(servers)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"20000")}));
    }

    public Optional<NewPartitionReassignment> reassignmentEntry(Seq<Object> replicas, Seq<Object> observers) {
        return Optional.of(NewPartitionReassignment.ofReplicasAndObservers((List)((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)r -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom())).asJava()), (List)((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)observers.map((Function1 & Serializable & scala.Serializable)o -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o)), Seq$.MODULE$.canBuildFrom())).asJava())));
    }

    public void waitForAllReassignmentsToComplete(AdminClient client) {
        long x$3 = 100L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConfluentObserverTest$.$anonfun$waitForAllReassignmentsToComplete$1(client)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)ConfluentObserverTest$.$anonfun$waitForAllReassignmentsToComplete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), x$3));
        }
    }

    public Option<TopicPartitionInfo> describeTopicPartition(AdminClient client, TopicPartition topicPartition) {
        return Option$.MODULE$.apply(((TopicDescription)((java.util.Map)client.describeTopics(Arrays.asList((Object[])new String[]{topicPartition.topic()})).allTopicNames().get()).get(topicPartition.topic())).partitions().get(topicPartition.partition()));
    }

    public String bootstrapServers(Seq<KafkaServer> servers) {
        return Option$.MODULE$.option2Iterable(((TraversableLike)servers.map((Function1 & Serializable & scala.Serializable)server -> {
            int port = server.socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
            return new StringBuilder(10).append("localhost:").append(port).toString();
        }, Seq$.MODULE$.canBuildFrom())).headOption()).mkString(",");
    }

    public String basicTopicPlacement(ConfluentObserverTest.BasicConstraint replicaConstraint, Option<ConfluentObserverTest.BasicConstraint> observerConstraint) {
        String observers = (String)observerConstraint.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)constraint -> new StringBuilder(53).append(",\"observers\":[{\"count\": ").append(constraint.count()).append(", \"constraints\":{\"rack\":\"").append(constraint.rack()).append("\"}}]").toString());
        return new StringBuilder(65).append("{\"version\":1,\"replicas\":[{\"count\": ").append(replicaConstraint.count()).append(", \"constraints\":{\"rack\":\"").append(replicaConstraint.rack()).append("\"}}]").append(observers).append("}").toString();
    }

    public String v2TopicPlacement(String observerPromotionPolicy, ConfluentObserverTest.BasicConstraint replicaConstraint, Option<ConfluentObserverTest.BasicConstraint> observerConstraint) {
        String observers = (String)observerConstraint.fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)constraint -> new StringBuilder(53).append(",\"observers\":[{\"count\": ").append(constraint.count()).append(", \"constraints\":{\"rack\":\"").append(constraint.rack()).append("\"}}]").toString());
        return new StringBuilder(94).append("{\"version\":2,\"observerPromotionPolicy\":\"").append(observerPromotionPolicy).append("\",\"replicas\":[{\"count\": ").append(replicaConstraint.count()).append(", \"constraints\":{\"rack\":\"").append(replicaConstraint.rack()).append("\"}}]").append(observers).append("}").toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForAllReassignmentsToComplete$1(AdminClient client$6) {
        return ((java.util.Map)client$6.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForAllReassignmentsToComplete$2() {
        return "There still are ongoing reassignments";
    }

    private ConfluentObserverTest$() {
        MODULE$ = this;
    }
}

