/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.admin.BrokerMetadata;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfluentBrokerTagsTest$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.ConfluentNode;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.MapLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mv!\u0002\u0012$\u0011\u0003Ac!\u0002\u0016$\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%\t!\u000e\u0005\u0007\u0003\u0006\u0001\u000b\u0011\u0002\u001c\t\u000f\t\u000b!\u0019!C\u0001k!11)\u0001Q\u0001\nYBq\u0001R\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004F\u0003\u0001\u0006IA\u000e\u0004\u0005U\r\u0002a\tC\u00033\u0013\u0011\u00051\u000bC\u0004V\u0013\t\u0007I\u0011\u0001,\t\riK\u0001\u0015!\u0003X\u0011\u001dY\u0016B1A\u0005\u0002YCa\u0001X\u0005!\u0002\u00139\u0006bB/\n\u0005\u0004%\tA\u0018\u0005\u0007O&\u0001\u000b\u0011B0\t\u0013!L\u0001\u0019!a\u0001\n\u0003I\u0007\"C<\n\u0001\u0004\u0005\r\u0011\"\u0001y\u0011%q\u0018\u00021A\u0001B\u0003&!\u000e\u0003\u0004\u0000\u0013\u0011\u0005\u0013\u0011\u0001\u0005\u0007\u007f&!\t!a\u0007\t\u000f\u0005\u001d\u0012\u0002\"\u0001\u0002*!9\u0011\u0011G\u0005\u0005B\u0005M\u0002bBA+\u0013\u0011\u0005\u0013q\u000b\u0005\b\u0003CJA\u0011AA,\u0011\u001d\tY'\u0003C\u0001\u0003/Bq!a\u001c\n\t\u0003\t9\u0006C\u0004\u0002t%!\t!a\u0016\t\u000f\u0005]\u0014\u0002\"\u0003\u0002z!9\u0011\u0011Q\u0005\u0005\n\u0005\r\u0005bBAF\u0013\u0011%\u0011Q\u0012\u0005\b\u0003\u0017KA\u0011BAI\u0011\u001d\t9*\u0003C\u0005\u00033\u000bqcQ8oM2,XM\u001c;Ce>\\WM\u001d+bON$Vm\u001d;\u000b\u0005\u0011*\u0013AB:feZ,'OC\u0001'\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!K\u0001\u000e\u0003\r\u0012qcQ8oM2,XM\u001c;Ce>\\WM\u001d+bON$Vm\u001d;\u0014\u0005\u0005a\u0003CA\u00171\u001b\u0005q#\"A\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Er#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002Q\u0005\u0001\"I]8lKJ$\u0016mZ:Qe\u00164\u0017\u000e_\u000b\u0002mA\u0011qG\u0010\b\u0003qq\u0002\"!\u000f\u0018\u000e\u0003iR!aO\u0014\u0002\rq\u0012xn\u001c;?\u0013\tid&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f/\u0003E\u0011%o\\6feR\u000bwm\u001d)sK\u001aL\u0007\u0010I\u0001\n\u0007\u0016dG.\u00133UC\u001e\f!bQ3mY&#G+Y4!\u0003)\tE\u000e\u001c\"s_.,'o]\u0001\f\u00032d'I]8lKJ\u001c\beE\u0002\n\u000f6\u0003\"\u0001S&\u000e\u0003%S!AS\u0013\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u0019&\u0013acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\u0016\nQ!\u001e;jYNL!AU(\u0003\u000f1{wmZ5oOR\tA\u000b\u0005\u0002*\u0013\u0005Qa.^7TKJ4XM]:\u0016\u0003]\u0003\"!\f-\n\u0005es#aA%oi\u0006Ya.^7TKJ4XM]:!\u0003!\u0019W\r\u001c7TSj,\u0017!C2fY2\u001c\u0016N_3!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#A0\u0011\u0005\u0001,W\"A1\u000b\u0005\t\u001c\u0017\u0001B;uS2T\u0011\u0001Z\u0001\u0005U\u00064\u0018-\u0003\u0002gC\nQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013aC1e[&t7\t\\5f]R,\u0012A\u001b\t\u0003WVl\u0011\u0001\u001c\u0006\u0003[:\fQ!\u00193nS:T!a\u001c9\u0002\u000f\rd\u0017.\u001a8ug*\u0011a%\u001d\u0006\u0003eN\fa!\u00199bG\",'\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002wY\n)\u0011\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002zyB\u0011QF_\u0005\u0003w:\u0012A!\u00168ji\"9QPEA\u0001\u0002\u0004Q\u0017a\u0001=%c\u0005a\u0011\rZ7j]\u000ec\u0017.\u001a8uA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/\u0006\u0002\u0002\u0004A1\u0011QAA\b\u0003+qA!a\u0002\u0002\f9\u0019\u0011(!\u0003\n\u0003=J1!!\u0004/\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\t\u00191+Z9\u000b\u0007\u00055a\u0006E\u0002*\u0003/I1!!\u0007$\u0005-Y\u0015MZ6b\u0007>tg-[4\u0015\t\u0005\r\u0011Q\u0004\u0005\b\u0003?)\u0002\u0019AA\u0011\u00039yg/\u001a:sS\u0012Lgn\u001a+bON\u0004RaNA\u0012mYJ1!!\nA\u0005\ri\u0015\r]\u0001\u000bEJ|7.\u001a:UC\u001e\u001cHCBA\u0011\u0003W\ti\u0003C\u0004\u0002 Y\u0001\r!!\t\t\r\u0005=b\u00031\u0001X\u0003!\u0011'o\\6fe&#\u0017!B:fiV\u0003HcA=\u00026!9\u0011qG\fA\u0002\u0005e\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005m\u0012\u0011J\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005\u0019\u0011\r]5\u000b\t\u0005\r\u0013QI\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t9e]\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u0017\niD\u0001\u0005UKN$\u0018J\u001c4pQ\r9\u0012q\n\t\u0005\u0003w\t\t&\u0003\u0003\u0002T\u0005u\"A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eF\u0001zQ\rA\u00121\f\t\u0005\u0003w\ti&\u0003\u0003\u0002`\u0005u\"!C!gi\u0016\u0014X)Y2i\u0003=!Xm\u001d;Ce>\\WM]:UC\u001e\u001c\bfA\r\u0002fA!\u00111HA4\u0013\u0011\tI'!\u0010\u0003\tQ+7\u000f^\u0001\u0019i\u0016\u001cHOU8mY\n\u0013xn[3sgR{\u0017\t\u001a3UC\u001e\u001c\bf\u0001\u000e\u0002f\u0005yA/Z:u\tft\u0017-\\5d)\u0006<7\u000fK\u0002\u001c\u0003K\n1\u0003^3ti\u0012+7o\u0019:jE\u0016\u001cE.^:uKJD3\u0001HA3\u0003=\tG\rZ(s+B$\u0017\r^3UC\u001e\u001cH#B=\u0002|\u0005u\u0004BBA\u0018;\u0001\u0007a\u0007C\u0004\u0002\u0000u\u0001\r!!\t\u0002\tQ\fwm]\u0001\u000be\u0016lwN^3UC\u001e\u001cH#B=\u0002\u0006\u0006\u001d\u0005BBA\u0018=\u0001\u0007a\u0007C\u0004\u0002\u0000y\u0001\r!!#\u0011\u000b\u0005\u0015\u0011q\u0002\u001c\u0002\u0015Y,'/\u001b4z)\u0006<7\u000fF\u0002z\u0003\u001fCq!a\b \u0001\u0004\t\t\u0003F\u0003z\u0003'\u000b)\nC\u0004\u0002 \u0001\u0002\r!!\t\t\r\u0005=\u0002\u00051\u0001X\u00035!\u0018mZ:G_J\u0014%o\\6feR1\u00111TAS\u0003_\u0003b!!(\u0002$Z2TBAAP\u0015\r\t\tKL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0013\u0003?Cq!a*\"\u0001\u0004\tI+A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\t\u0004S\u0005-\u0016bAAWG\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016Da!!-\"\u0001\u00049\u0016AA5e\u0001")
public class ConfluentBrokerTagsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int cellSize;
    private final Properties overridingProps = new Properties();
    private Admin adminClient;

    public static String AllBrokers() {
        return ConfluentBrokerTagsTest$.MODULE$.AllBrokers();
    }

    public static String CellIdTag() {
        return ConfluentBrokerTagsTest$.MODULE$.CellIdTag();
    }

    public static String BrokerTagsPrefix() {
        return ConfluentBrokerTagsTest$.MODULE$.BrokerTagsPrefix();
    }

    public int numServers() {
        return this.numServers;
    }

    public int cellSize() {
        return this.cellSize;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateConfigs((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Seq<KafkaConfig> generateConfigs(scala.collection.immutable.Map<String, String> overridingTags) {
        return (Seq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numServers()).map((Function1 & Serializable & scala.Serializable)brokerId -> ConfluentBrokerTagsTest.$anonfun$generateConfigs$1(this, overridingTags, BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Map<String, String> brokerTags(scala.collection.immutable.Map<String, String> overridingTags, int brokerId) {
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfluentBrokerTagsTest$.MODULE$.CellIdTag()), (Object)Integer.toString(brokerId / this.cellSize()))}))).$plus$plus(overridingTags);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
        super.tearDown();
    }

    @Test
    public void testBrokersTags() {
        this.verifyTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    @Test
    public void testRollBrokersToAddTags() {
        scala.collection.immutable.Map newTags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}));
        this.verifyTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        Seq<KafkaConfig> newConfigs = this.generateConfigs((scala.collection.immutable.Map<String, String>)newTags);
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)serverIdx -> {
            this.killBroker(serverIdx);
            KafkaConfig config = (KafkaConfig)newConfigs.apply(serverIdx);
            this.servers().update(serverIdx, (Object)TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId())));
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        });
        this.verifyTags((scala.collection.immutable.Map<String, String>)newTags);
    }

    @Test
    public void testDynamicTags() {
        this.verifyTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        scala.collection.immutable.Map newTags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}));
        this.addOrUpdateTags(ConfluentBrokerTagsTest$.MODULE$.AllBrokers(), (scala.collection.immutable.Map<String, String>)newTags);
        this.verifyTags((scala.collection.immutable.Map<String, String>)newTags);
        this.removeTags(ConfluentBrokerTagsTest$.MODULE$.AllBrokers(), (Seq<String>)newTags.keys().toSeq());
        this.verifyTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        int brokerId = 0;
        scala.collection.immutable.Map newTagsBroker0 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo-0"), (Object)"bar-0")}));
        this.addOrUpdateTags(Integer.toString(brokerId), (scala.collection.immutable.Map<String, String>)newTagsBroker0);
        this.verifyTags((scala.collection.immutable.Map<String, String>)newTagsBroker0, brokerId);
        this.removeTags(Integer.toString(brokerId), (Seq<String>)newTagsBroker0.keys().toSeq());
        this.verifyTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), brokerId);
        this.verifyTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    @Test
    public void testDescribeCluster() {
        Collection nodes = (Collection)this.adminClient().describeCluster().nodes().get();
        scala.collection.immutable.Map expectedTagsByBroker = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numServers()).map((Function1 & Serializable & scala.Serializable)brokerId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)brokerId))), this.brokerTags((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), BoxesRunTime.unboxToInt((Object)brokerId))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map tagsByBrokers = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)node.id())), (Object)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfluentNode.tags((Node)node)).asScala()).toMap(Predef$.MODULE$.$conforms())), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)expectedTagsByBroker, (Object)tagsByBrokers);
    }

    private void addOrUpdateTags(String brokerId, scala.collection.immutable.Map<String, String> tags) {
        this.adminClient().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, brokerId)), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)tags.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(new StringBuilder(0).append(ConfluentBrokerTagsTest$.MODULE$.BrokerTagsPrefix()).append(name).toString(), value), AlterConfigOp.OpType.SET);
            return alterConfigOp;
        }, Iterable$.MODULE$.canBuildFrom())).asJavaCollection())}))).asJava()).all();
    }

    private void removeTags(String brokerId, Seq<String> tags) {
        this.adminClient().incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, brokerId)), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)tags.map((Function1 & Serializable & scala.Serializable)name -> new AlterConfigOp(new ConfigEntry(new StringBuilder(0).append(ConfluentBrokerTagsTest$.MODULE$.BrokerTagsPrefix()).append((String)name).toString(), ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom())).asJavaCollection())}))).asJava()).all();
    }

    private void verifyTags(scala.collection.immutable.Map<String, String> overridingTags) {
        scala.collection.immutable.Map expectedTagsByBroker = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numServers()).map((Function1 & Serializable & scala.Serializable)brokerId -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)brokerId))), this.brokerTags((scala.collection.immutable.Map<String, String>)overridingTags, BoxesRunTime.unboxToInt((Object)brokerId))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ConfluentBrokerTagsTest.$anonfun$verifyTags$2(this, expectedTagsByBroker, server);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyTags(scala.collection.immutable.Map<String, String> overridingTags, int brokerId) {
        scala.collection.immutable.Map<String, String> expectedTags = this.brokerTags(overridingTags, brokerId);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ConfluentBrokerTagsTest.$anonfun$verifyTags$5(this, brokerId, expectedTags, server);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, String> tagsForBroker(MetadataCache metadataCache, int id) {
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfluentNode.tags((Node)((Node)metadataCache.getAliveBrokerNode(id, ListenerName.normalised((String)"plaintext")).get()))).asScala();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Properties $anonfun$generateConfigs$1(ConfluentBrokerTagsTest $this, scala.collection.immutable.Map overridingTags$1, int brokerId) {
        void var3_3;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(brokerId, $this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> props.put(new StringBuilder(0).append(ConfluentBrokerTagsTest$.MODULE$.BrokerTagsPrefix()).append((String)name).toString(), value);
        Map map = Implicits$.MODULE$.MapExtensionMethods($this.brokerTags((scala.collection.immutable.Map<String, String>)overridingTags$1, brokerId));
        if (Implicits.MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$verifyTags$3(ConfluentBrokerTagsTest $this, KafkaServer server$1, scala.collection.immutable.Map expectedTagsByBroker$1) {
        scala.collection.immutable.Map tagsByBroker = ((TraversableOnce)server$1.metadataCache().getAliveBrokers().map((Function1 & Serializable & scala.Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)broker.id())), $this.tagsForBroker((MetadataCache)server$1.metadataCache(), broker.id())), scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)expectedTagsByBroker$1, (Object)tagsByBroker);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyTags$2(ConfluentBrokerTagsTest $this, scala.collection.immutable.Map expectedTagsByBroker$1, KafkaServer server) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ConfluentBrokerTagsTest.$anonfun$verifyTags$3($this, server, expectedTagsByBroker$1);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += scala.math.package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyTags$7(int brokerId$1, BrokerMetadata x$2) {
        return x$2.id() == brokerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyTags$6(ConfluentBrokerTagsTest $this, KafkaServer server$2, int brokerId$1, scala.collection.immutable.Map expectedTags$1) {
        Option tags = ((TraversableLike)((TraversableLike)server$2.metadataCache().getAliveBrokers().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ConfluentBrokerTagsTest.$anonfun$verifyTags$7(brokerId$1, x$2)))).map((Function1 & Serializable & scala.Serializable)broker -> $this.tagsForBroker((MetadataCache)server$2.metadataCache(), broker.id()), scala.collection.Iterable$.MODULE$.canBuildFrom())).headOption();
        Assertions.assertEquals((Object)new Some((Object)expectedTags$1), (Object)tags);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$verifyTags$5(ConfluentBrokerTagsTest $this, int brokerId$1, scala.collection.immutable.Map expectedTags$1, KafkaServer server) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ConfluentBrokerTagsTest.$anonfun$verifyTags$6($this, server, brokerId$1, expectedTags$1);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += scala.math.package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public ConfluentBrokerTagsTest() {
        this.numServers = 6;
        this.cellSize = 3;
        this.overridingProps().put(KafkaConfig$.MODULE$.NumPartitionsProp(), "1");
        this.overridingProps().put(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
    }
}

