/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.QuotaType;
import org.apache.kafka.common.message.ReportQuotaConsumptionRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rea\u0001B)S\u0001]CQ\u0001\u0018\u0001\u0005\u0002uCqa\u0018\u0001C\u0002\u0013%\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019Q\u0007\u0001)A\u0005O\")1\u000e\u0001C\u0005Y\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAz\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003o\u0004A\u0011AAl\u0011\u001d\tY\u0010\u0001C\u0001\u0003/Dq!a@\u0001\t\u0003\t9\u000eC\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002X\"9!1\u0006\u0001\u0005\u0002\u0005]\u0007b\u0002B\u0018\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0005g\u0001A\u0011AAl\u0011\u001d\u00119\u0004\u0001C\u0001\u0003/DqAa\u000f\u0001\t\u0003\t9\u000eC\u0004\u0003@\u0001!\t!a6\t\u000f\t\r\u0003\u0001\"\u0001\u0002X\"9!q\t\u0001\u0005\u0002\u0005]\u0007b\u0002B&\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0005\u001f\u0002A\u0011AAl\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0003/DqAa\u0016\u0001\t\u0003\t9\u000eC\u0004\u0003\\\u0001!\t!a6\t\u000f\t}\u0003\u0001\"\u0001\u0002X\"9!1\r\u0001\u0005\u0002\u0005]\u0007b\u0002B4\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0005W\u0002A\u0011AAl\u0011\u001d\u0011y\u0007\u0001C\u0001\u0003/DqAa\u001d\u0001\t\u0003\t9\u000eC\u0004\u0003x\u0001!\t!a6\t\u000f\tm\u0004\u0001\"\u0001\u0002X\"9!q\u0010\u0001\u0005\n\t\u0005\u0005b\u0002BK\u0001\u0011\u0005\u0011q\u001b\u0005\b\u00053\u0003A\u0011AAl\u0011\u001d\u0011i\n\u0001C\u0001\u0003/DqA!)\u0001\t\u0003\t9\u000eC\u0004\u0003&\u0002!\t!a6\t\u000f\t%\u0006\u0001\"\u0001\u0002X\"9!Q\u0016\u0001\u0005\u0002\u0005]\u0007b\u0002BY\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0005k\u0003A\u0011\u0001B\\\u0011\u001d\u0011i\f\u0001C\u0001\u0005\u007fCqAa2\u0001\t\u0003\u0011IM\u0002\u0003y\u0001\u0011K\bBCA\u0004_\tU\r\u0011\"\u0001\u0002\n!Q\u0011\u0011E\u0018\u0003\u0012\u0003\u0006I!a\u0003\t\u0015\u0005\rrF!f\u0001\n\u0003\tI\u0001\u0003\u0006\u0002&=\u0012\t\u0012)A\u0005\u0003\u0017A!\"a\n0\u0005+\u0007I\u0011AA\u0015\u0011)\t\td\fB\tB\u0003%\u00111\u0006\u0005\u000b\u0003gy#Q3A\u0005\u0002\u0005%\u0002BCA\u001b_\tE\t\u0015!\u0003\u0002,!1Al\fC\u0001\u0003oAq!!\u00110\t\u0003\t\u0019\u0005C\u0005\u0002V=\n\t\u0011\"\u0001\u0002X!I\u0011\u0011M\u0018\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003sz\u0013\u0013!C\u0001\u0003GB\u0011\"a\u001f0#\u0003%\t!! \t\u0013\u0005\u0005u&%A\u0005\u0002\u0005u\u0004\"CAB_\u0005\u0005I\u0011IAC\u0011%\t9iLA\u0001\n\u0003\tI\tC\u0005\u0002\u0012>\n\t\u0011\"\u0001\u0002\u0014\"I\u0011qT\u0018\u0002\u0002\u0013\u0005\u0013\u0011\u0015\u0005\n\u0003_{\u0013\u0011!C\u0001\u0003cC\u0011\"a/0\u0003\u0003%\t%!0\t\u0013\u0005}v&!A\u0005B\u0005\u0005\u0007\"CAb_\u0005\u0005I\u0011IAc\u000f%\u0011\t\u000fAA\u0001\u0012\u0013\u0011\u0019O\u0002\u0005y\u0001\u0005\u0005\t\u0012\u0002Bs\u0011\u0019a\u0006\n\"\u0001\u0003t\"I\u0011q\u0018%\u0002\u0002\u0013\u0015\u0013\u0011\u0019\u0005\n\u0005kD\u0015\u0011!CA\u0005oD\u0011b!\u0001I#\u0003%\t!! \t\u0013\r\r\u0001*%A\u0005\u0002\u0005u\u0004\"CB\u0003\u0011\u0006\u0005I\u0011QB\u0004\u0011%\u0019)\u0002SI\u0001\n\u0003\ti\bC\u0005\u0004\u0018!\u000b\n\u0011\"\u0001\u0002~\t12\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002T)\u000611/\u001a:wKJT\u0011!V\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\f\u0005\u0002Z56\t!+\u0003\u0002\\%\nQ\")Y:f\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\u0018\t\u00033\u0002\taaY8oM&<W#A1\u0011\u0005e\u0013\u0017BA2S\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\bG>tg-[4!\u00039\u0019\u0007.\u00198oK2l\u0015M\\1hKJ,\u0012a\u001a\t\u00033\"L!!\u001b*\u00037\u0005\u00137\u000f\u001e:bGR\fVo\u001c;b\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003=\u0019\u0007.\u00198oK2l\u0015M\\1hKJ\u0004\u0013\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)%i7\u000f^Ae\u0003\u001b\f\t\u000e\u0005\u0002oc6\tqNC\u0001q\u0003\u0015\u00198-\u00197b\u0013\t\u0011xN\u0001\u0003V]&$\b\"B0\u0007\u0001\u0004\t\u0007\"B;\u0007\u0001\u00041\u0018aB2mS\u0016tG/\r\t\u0003o>j\u0011\u0001\u0001\u0002\u000b+N,'o\u00117jK:$8#B\u0018{{\u0006\u0005\u0001C\u00018|\u0013\taxN\u0001\u0004B]f\u0014VM\u001a\t\u0003]zL!a`8\u0003\u000fA\u0013x\u000eZ;diB\u0019a.a\u0001\n\u0007\u0005\u0015qN\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003vg\u0016\u0014XCAA\u0006!\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\t\u0004\u0003#yWBAA\n\u0015\r\t)BV\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005eq.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033y\u0017!B;tKJ\u0004\u0013\u0001C2mS\u0016tG/\u00133\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013AC2p]\u001aLw-V:feV\u0011\u00111\u0006\t\u0006]\u00065\u00121B\u0005\u0004\u0003_y'AB(qi&|g.A\u0006d_:4\u0017nZ+tKJ\u0004\u0013AD2p]\u001aLwm\u00117jK:$\u0018\nZ\u0001\u0010G>tg-[4DY&,g\u000e^%eAQIa/!\u000f\u0002<\u0005u\u0012q\b\u0005\b\u0003\u000fA\u0004\u0019AA\u0006\u0011\u001d\t\u0019\u0003\u000fa\u0001\u0003\u0017A\u0011\"a\n9!\u0003\u0005\r!a\u000b\t\u0013\u0005M\u0002\b%AA\u0002\u0005-\u0012aF:b]&$\u0018N_3e\u0007>tg-[4DY&,g\u000e^%e+\t\t)\u0005E\u0003o\u0003[\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\t1\fgn\u001a\u0006\u0003\u0003#\nAA[1wC&!\u0011QDA&\u0003\u0011\u0019w\u000e]=\u0015\u0013Y\fI&a\u0017\u0002^\u0005}\u0003\"CA\u0004uA\u0005\t\u0019AA\u0006\u0011%\t\u0019C\u000fI\u0001\u0002\u0004\tY\u0001C\u0005\u0002(i\u0002\n\u00111\u0001\u0002,!I\u00111\u0007\u001e\u0011\u0002\u0003\u0007\u00111F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)G\u000b\u0003\u0002\f\u0005\u001d4FAA5!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Mt.\u0001\u0006b]:|G/\u0019;j_:LA!a\u001e\u0002n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA@U\u0011\tY#a\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0012\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0005c\u00018\u0002\u000e&\u0019\u0011qR8\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00151\u0014\t\u0004]\u0006]\u0015bAAM_\n\u0019\u0011I\\=\t\u0013\u0005u\u0015)!AA\u0002\u0005-\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002$B1\u0011QUAV\u0003+k!!a*\u000b\u0007\u0005%v.\u0001\u0006d_2dWm\u0019;j_:LA!!,\u0002(\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019,!/\u0011\u00079\f),C\u0002\u00028>\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001e\u000e\u000b\t\u00111\u0001\u0002\u0016\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002H\u00051Q-];bYN$B!a-\u0002H\"I\u0011Q\u0014$\u0002\u0002\u0003\u0007\u0011Q\u0013\u0005\u0007\u0003\u00174\u0001\u0019\u0001<\u0002\u000f\rd\u0017.\u001a8ue!1\u0011q\u001a\u0004A\u0002Y\fAB]1oI>l7\t\\5f]RDa!a5\u0007\u0001\u00041\u0018a\u00053fM\u0006,H\u000e^\"p]\u001aLwm\u00117jK:$\u0018\u0001\u0007;fgR\u001cE.[3oi&#\u0017+^8uCB\u000b'o]5oOR\tQ\u000eK\u0002\b\u00037\u0004B!!8\u0002p6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/A\u0002ba&TA!!:\u0002h\u00069!.\u001e9ji\u0016\u0014(\u0002BAu\u0003W\fQA[;oSRT!!!<\u0002\u0007=\u0014x-\u0003\u0003\u0002r\u0006}'\u0001\u0002+fgR\fA\u0003^3tiV\u001bXM])v_R\f\u0007+\u0019:tS:<\u0007f\u0001\u0005\u0002\\\u0006aB/Z:u+N,'o\u00117jK:$\u0018\nZ)v_R\f\u0007+\u0019:tS:<\u0007fA\u0005\u0002\\\u0006aC/Z:u+N,'/U;pi\u0006\u0004\u0016M]:j]\u001e<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;DY&,g\u000e^%e#V|G/\u0019\u0015\u0004\u0015\u0005m\u0017\u0001\u000e;fgR,6/\u001a:DY&,g\u000e^)v_R\f\u0007+\u0019:tS:<\u0017\nZ,ji\"$UMZ1vYR\u001cE.[3oi&#\u0017+^8uC\"\u001a1\"a7\u0002\u0015\rDWmY6Rk>$\u0018\rF\u0007n\u0005\u000f\u0011\tBa\u0005\u0003\u0016\t}!1\u0005\u0005\b\u0005\u0013a\u0001\u0019\u0001B\u0006\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s!\rI&QB\u0005\u0004\u0005\u001f\u0011&AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJDq!a\u0002\r\u0001\u0004\tY\u0001C\u0004\u0002$1\u0001\r!a\u0003\t\u000f\t]A\u00021\u0001\u0003\u001a\u0005iQ\r\u001f9fGR,GMQ8v]\u0012\u00042A\u001cB\u000e\u0013\r\u0011ib\u001c\u0002\u0005\u0019>tw\rC\u0004\u0003\"1\u0001\r!a#\u0002\u000bY\fG.^3\t\u000f\t\u0015B\u00021\u0001\u00024\u0006qQ\r\u001f9fGR$\u0006N]8ui2,\u0017!\u000e;fgR<U\r^'bqZ\u000bG.^3J]F+x\u000e^1XS:$wn^,ji\"tuN\u001c#fM\u0006,H\u000e^)v_R\fw+\u001b8e_^D3!DAn\u0003\u0001\"Xm\u001d;TKR\fe\u000e\u001a*f[>4X\rR3gCVdG/V:feF+x\u000e^1)\u00079\tY.A\ruKN$8+\u001a;B]\u0012\u0014V-\\8wKV\u001bXM])v_R\f\u0007fA\b\u0002\\\u0006yB/Z:u'\u0016$\u0018I\u001c3SK6|g/Z+tKJ\u001cE.[3oiF+x\u000e^1)\u0007A\tY.A\ruKN$\u0018+^8uC\u000e{gNZ5h!J,7-\u001a3f]\u000e,\u0007fA\t\u0002\\\u0006\u0011B/Z:u#V|G/\u0019,j_2\fG/[8oQ\r\u0011\u00121\\\u0001\u001di\u0016\u001cH/\u0012=qSJ,G\u000b\u001b:piRdW\rV5nKN+gn]8sQ\r\u0019\u00121\\\u0001\u0017i\u0016\u001cH/\u0012=qSJ,\u0017+^8uCN+gn]8sg\"\u001aA#a7\u00021Q,7\u000f^\"mS\u0016tG/\u00133O_R\u001c\u0016M\\5uSj,G\rK\u0002\u0016\u00037\fq\u0004^3tiVs\u0017N^3sg\u0006d\u0017\u000e^=PM\u0006\u001bG/\u001b<f)\u0016t\u0017M\u001c;tQ\r1\u00121\\\u0001\u001di\u0016\u001cHO\u0012:fcV,gnY=PM\u0006+Ho\u001c+v]\u0016\fVo\u001c;bQ\r9\u00121\\\u0001\u001ei\u0016\u001cH/\u00138bGRLg/\u001a+f]\u0006tGo\u001d*fg\u0016$\u0018+^8uC\"\u001a\u0001$a7\u0002WQ,7\u000f^!vi>$VO\\3CC:$w/\u001b3uQF+x\u000e^1BY2\f%m\u001c<f\r\u0006L'\u000fT5nSRD3!GAn\u0003A\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u0003\n|g/Z!oI\n+Gn\\<GC&\u0014H*[7ji\"\u001a!$a7\u0002WQ,7\u000f^!vi>$VO\\3CC:$w/\u001b3uQF+x\u000e^1BY2\u0014U\r\\8x\r\u0006L'\u000fT5nSRD3aGAn\u0003%\"Xm\u001d;BkR|G+\u001e8f\u0005\u0006tGm^5ei\"\fVo\u001c;b\u001bVdG/\u001b9mKR+g.\u00198ug\"\u001aA$a7\u0002QQ,7\u000f^!vi>$VO\\3XSRD7\t[1oO&twM\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;)\u0007u\tY.A\u0016uKN$\u0018)\u001e;p)VtWmV5uQ\u000eC\u0017M\\4j]\u001e|%/[4j]\u0006d7\t\\5f]R\fVo\u001c;bQ\rq\u00121\\\u0001'i\u0016\u001cH/Q;u_R+h.Z,iK:\u001cE.[3oiN#x\u000e]:TK:$\u0017N\\4M_\u0006$\u0007fA\u0010\u0002\\\u0006\u0019D/Z:u\u0003V$x\u000eV;oK^CWM\\\"mS\u0016tG/V:bO\u0016$Um\u0019:fCNLgnZ!gi\u0016\u0014H\u000b\u001b:piRdW\r\u001a\u0015\u0004A\u0005m\u0017!\t;fgR\fVo\u001c;b%\u0016\u0004xN\u001d;j]\u001e\u001c\u0015\r\u001c7cC\u000e\\WI\\1cY\u0016$\u0007fA\u0011\u0002\\\u0006yC/Z:u#V|G/\u0019*fa>\u0014H/\u001b8h\u0007\u0006dGNY1dW^KG\u000f[!di&4XmQ8ogVl\u0007\u000f^5p]\"\u001a!%a7\u0002'Y,'/\u001b4z\tft\u0017-\\5d#V|G/Y:\u0015\u000b5\u0014\u0019I!\"\t\u000f\t%1\u00051\u0001\u0003\f!9!qQ\u0012A\u0002\t%\u0015\u0001G3ya\u0016\u001cG/\u001a3Rk>$\u0018m\u001d$pe\u000ec\u0017.\u001a8ugBA\u0011Q\u0002BF\u0003\u0017\u0011y)\u0003\u0003\u0003\u000e\u0006}!aA'baB\u0019aN!%\n\u0007\tMuN\u0001\u0004E_V\u0014G.Z\u00014i\u0016\u001cH/Q;u_R+h.\u001b8h\u00032dwnY1uKN\u0014\u0015M\u001c3xS\u0012$\b\u000e\u0015:pa>\u0014H/[8oC2$v.U;pi\u0006D3\u0001JAn\u0003%\"Xm\u001d;BkR|G+\u001e8j]\u001e,f\u000e\\5nSR,G-U;pi\u00064uN]!mY\u000ec\u0017.\u001a8ug\"\u001aQ%a7\u0002UQ,7\u000f^!vi>$VO\\5oOVsG.[7ji\u0016$\u0017+^8uC\u001a{'oU8nK\u000ec\u0017.\u001a8ug\"\u001aa%a7\u0002_Q,7\u000f^!vi>$VO\\5oOVsG.[7ji\u0016$\u0017+^8uC^KG\u000f\u001b'poV\u001b\u0018mZ3DY&,g\u000e^:)\u0007\u001d\nY.\u0001\u0015uKN$\u0018)\u001e;p)Vt\u0017N\\4V]2LW.\u001b;fIF+x\u000e^1XSRDGj\\<Vg\u0006<W\rK\u0002)\u00037\fa\u0004^3ti\u0006+Ho\u001c+v]&tw\rS1oI2,7OW3s_F+x\u000e^1)\u0007%\nY.\u0001\u0011uKN$\u0018)\u001e;p)Vt\u0017N\\4T_J$8OQ=Vi&d\u0017N_1uS>t\u0007f\u0001\u0016\u0002\\\u0006IC/Z:u!J|G-^2fe&\u001bH\u000b\u001b:piRdW\rZ,iK:$\u0015n]6Ta\u0006\u001cW-S:M_^D3aKAn\u0003=i\u0017\u000e\u001c7jgR{\u0007+\u001a:dK:$H\u0003\u0002BH\u0005sCqAa/-\u0001\u0004\u0011y)\u0001\u0004nS2d\u0017n]\u0001\u000b[\u0016$(/[2UC\u001e\u001cHC\u0002Ba\u0005\u0007\u0014)\r\u0005\u0005\u0002\u000e\t-\u00151BA\u0006\u0011\u001d\t9!\fa\u0001\u0003\u0017Aq!a\t.\u0001\u0004\tY!\u0001\u0006oK^lU\r\u001e:jGN,\"Aa3\u0011\t\t5'Q\\\u0007\u0003\u0005\u001fTAA!5\u0003T\u00069Q.\u001a;sS\u000e\u001c(\u0002\u0002Bk\u0005/\faaY8n[>t'bA+\u0003Z*!!1\\Av\u0003\u0019\t\u0007/Y2iK&!!q\u001cBh\u0005\u001diU\r\u001e:jGN\f!\"V:fe\u000ec\u0017.\u001a8u!\t9\bjE\u0003I\u0005O\f\t\u0001E\u0007\u0003j\n=\u00181BA\u0006\u0003W\tYC^\u0007\u0003\u0005WT1A!<p\u0003\u001d\u0011XO\u001c;j[\u0016LAA!=\u0003l\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\t\r\u0018!B1qa2LH#\u0003<\u0003z\nm(Q B\u0000\u0011\u001d\t9a\u0013a\u0001\u0003\u0017Aq!a\tL\u0001\u0004\tY\u0001C\u0005\u0002(-\u0003\n\u00111\u0001\u0002,!I\u00111G&\u0011\u0002\u0003\u0007\u00111F\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r%1\u0011\u0003\t\u0006]\u0006521\u0002\t\f]\u000e5\u00111BA\u0006\u0003W\tY#C\u0002\u0004\u0010=\u0014a\u0001V;qY\u0016$\u0004\u0002CB\n\u001d\u0006\u0005\t\u0019\u0001<\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6());
    private final AbstractQuotaChannelManager channelManager = (AbstractQuotaChannelManager)EasyMock.createMock(AbstractQuotaChannelManager.class);

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private AbstractQuotaChannelManager channelManager() {
        return this.channelManager;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 600 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            this.time().sleep((long)(throttleTimeMs + 1));
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds() * (this.config().numQuotaSamples() - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6());
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        RequestChannel.Session userSession = new RequestChannel.Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4(), ClientQuotaManagerConfig$.MODULE$.apply$default$5(), ClientQuotaManagerConfig$.MODULE$.apply$default$6()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            this.time().sleep(1000L);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 6550.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testUniversalityOfActiveTenants() {
        Metrics metrics = this.newMetrics();
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        ClientRequestQuotaManager requestQuotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager));
        scala.collection.mutable.Set activeTenants = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            requestQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(quotaManager, "User1", "Client1", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client1"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
            this.maybeRecord((ClientQuotaManager)requestQuotaManager, "User3", "Client3", 100.0);
            activeTenants.$plus$eq(this.metricTags("", "Client3"));
            Assertions.assertEquals((Object)activeTenants, (Object)activeTenantsManager.getActiveTenants().toSet());
        }
        finally {
            quotaManager.shutdown();
            requestQuotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testFrequencyOfAutoTuneQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testInactiveTenantsResetQuota() {
        Metrics metrics = this.newMetrics();
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(true, 1000L, (Seq)Nil$.MODULE$, BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBackpressure, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)quotaManager.quota("", "Client1").bound(), (double)0.0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
                this.time().sleep(100L);
            });
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            this.time().sleep(11000L);
            this.maybeRecord(quotaManager, "", "", 300.0);
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllAboveFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAboveAndBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaAllBelowFairLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client1").bound())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)quotaManager.quota("", "Client2").bound()))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneBandwidthQuotaMultipleTenants() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            Assertions.assertEquals((Object)quotaManager.quota("", "Client1"), (Object)quotaManager.dynamicQuota("", "Client1"));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertTrue((boolean)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.maybeRecord(quotaManager, "", "Client1", 250.0), this.maybeRecord(quotaManager, "", "Client2", 100.0), this.maybeRecord(quotaManager, "", "Client3", 200.0), this.maybeRecord(quotaManager, "", "Client4", 50.0)})).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)throttleTime -> throttleTime == 0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client2"), (Object)BoxesRunTime.boxToDouble((double)150.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client3"), (Object)BoxesRunTime.boxToDouble((double)175.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client4"), (Object)BoxesRunTime.boxToDouble((double)125.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingBrokerQuotaLimit() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)0.0, (double)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.setBrokerQuotaLimit(500.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
            quotaManager.setBrokerQuotaLimit(250.0);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWithChangingOriginalClientQuota() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 250.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "Client1", 300.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"Client1"), (Option)new Some((Object)"Client1"), (Option)new Some((Object)new Quota(200.0, true)));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Client1"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientStopsSendingLoad() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 200.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)250.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)300.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
            int throttleTimeMs1 = this.maybeRecord(quotaManager, "", "C2", 400.0);
            this.time().sleep((long)Math.max(1000, throttleTimeMs1));
            quotaManager.maybeAutoTuneQuota();
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C1").bound(), (double)0.0);
            Assertions.assertEquals((double)500.0, (double)quotaManager.dynamicQuota("", "C2").bound(), (double)0.0);
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuneWhenClientUsageDecreasingAfterThrottled() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 200.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 350.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 190.0));
            this.time().sleep(1000L);
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)310.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)250.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testQuotaReportingCallbackEnabled() {
        Metrics metrics = this.newMetrics();
        long x$1 = 30000L;
        int x$2 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        double x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(x$2, x$3, x$4, x$5, x$6, x$1);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.eq((long)config.consumptionReportingIntervalMs()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, (Option)new Some((Object)activeTenantsManager), (Option)new Some((Object)this.channelManager()));
        EasyMock.verify((Object[])new Object[]{this.channelManager()});
        quotaManager.shutdown();
    }

    @Test
    public void testQuotaReportingCallbackWithActiveConsumption() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        long x$2 = 1000L;
        double x$3 = 1000.0;
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(x$1, x$4, x$5, x$6, x$3, x$2);
        DynamicQuotaReportingRequestThread reportingRequestThread = (DynamicQuotaReportingRequestThread)EasyMock.createMock(DynamicQuotaReportingRequestThread.class);
        EasyMock.expect((Object)this.channelManager().getReportRequestThread()).andReturn((Object)reportingRequestThread).times(1);
        reportingRequestThread.schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong());
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        ReportQuotaConsumptionRequestData.EntryData entryData = new ReportQuotaConsumptionRequestData.EntryData();
        entryData.setEntity(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntityData[]{new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C1")}));
        entryData.setConsumptions(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.ConsumptionData[]{new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(100.0).setThrottled(false)}));
        ReportQuotaConsumptionRequestData.EntryData entryData2 = new ReportQuotaConsumptionRequestData.EntryData();
        entryData2.setEntity(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.EntityData[]{new ReportQuotaConsumptionRequestData.EntityData().setEntityType("user").setEntityName(""), new ReportQuotaConsumptionRequestData.EntityData().setEntityType("client-id").setEntityName("C2")}));
        entryData2.setConsumptions(Arrays.asList((Object[])new ReportQuotaConsumptionRequestData.ConsumptionData[]{new ReportQuotaConsumptionRequestData.ConsumptionData().setQuotaType("PRODUCE").setUsage(1600.0).setThrottled(true)}));
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.addEntryForNode(EasyMock.eq((Object)entryData2));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        reportingRequestThread.wakeup();
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.channelManager()});
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(config, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), Option$.MODULE$.apply((Object)this.channelManager()));
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(300.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 100.0));
            int throttleTime = this.maybeRecord(quotaManager, "", "C2", 800 * config.numQuotaSamples());
            Assertions.assertTrue((throttleTime > 0 ? 1 : 0) != 0);
            this.throttle(quotaManager, "", "C2", throttleTime, this.callback());
            quotaManager.quotaUsageReportingCallback();
            EasyMock.verify((Object[])new Object[]{this.channelManager()});
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    private void verifyDynamicQuotas(ClientQuotaManager quotaManager, Map<String, Object> expectedQuotasForClients) {
        expectedQuotasForClients.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClientQuotaManagerTest.$anonfun$verifyDynamicQuotas$1(quotaManager, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAutoTuningAllocatesBandwidthProportionalToQuota() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(1400.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)700.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForAllClients() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 600.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 800.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaForSomeClients() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)200.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsageClients() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 600.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(600.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(600.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 0.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)600.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)200.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)100.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningUnlimitedQuotaWithLowUsage() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(9.223372036854776E18, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 100.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)9.223372036854776E18)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningHandlesZeroQuota() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 500.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(0.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(700.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 0.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 600.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)0.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)500.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testAutoTuningSortsByUtilization() {
        Metrics metrics = this.newMetrics();
        int x$1 = 2;
        double x$2 = 1000.0;
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        BrokerBackpressureConfig x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$3();
        DiskUsageBasedThrottlingConfig x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$4();
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBrokerQuotaLimit = new ClientQuotaManagerConfig(x$1, x$3, x$4, x$5, x$2, x$6);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 10000L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(configWithBrokerQuotaLimit, metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", (Option)None$.MODULE$, Option$.MODULE$.apply((Object)activeTenantsManager), ClientQuotaManager$.MODULE$.$lessinit$greater$default$8());
        try {
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C1"), (Option)new Some((Object)"C1"), (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C2"), (Option)new Some((Object)"C2"), (Option)new Some((Object)new Quota(500.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"C3"), (Option)new Some((Object)"C3"), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C1", 400.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C2", 300.0));
            Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "", "C3", 400.0));
            quotaManager.maybeAutoTuneQuota();
            this.verifyDynamicQuotas(quotaManager, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C1"), (Object)BoxesRunTime.boxToDouble((double)500.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C2"), (Object)BoxesRunTime.boxToDouble((double)300.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"C3"), (Object)BoxesRunTime.boxToDouble((double)300.0))}))));
        }
        finally {
            quotaManager.shutdown();
            metrics.close();
        }
    }

    @Test
    public void testProducerIsThrottledWhenDiskSpaceIsLow() {
        Path tempLogDir = Files.createTempDirectory("some-dir", new FileAttribute[0]);
        long diskThreshold = Long.MAX_VALUE;
        Metrics metrics = this.newMetrics();
        int throttledBandwidth = 300;
        long x$1 = throttledBandwidth;
        .colon.colon x$2 = new .colon.colon((Object)((Object)tempLogDir).toString(), (List)Nil$.MODULE$);
        boolean x$3 = true;
        long x$4 = 1000L;
        long x$5 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1();
        double x$6 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6();
        boolean x$7 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7();
        DiskUsageBasedThrottlingConfig qual$1 = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$5, x$1, (Seq)x$2, x$3, x$4, x$6, x$7);
        long x$9 = 300L;
        Seq x$10 = qual$1.copy$default$3();
        boolean x$11 = qual$1.copy$default$4();
        long x$12 = qual$1.copy$default$5();
        double x$13 = qual$1.copy$default$6();
        boolean x$14 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig diskThrottlingConfig = qual$1.copy(diskThreshold, x$9, x$10, x$11, x$12, x$13, x$14);
        int x$15 = 2;
        BrokerBackpressureConfig x$16 = new BrokerBackpressureConfig(BrokerBackpressureConfig$.MODULE$.apply$default$1(), BrokerBackpressureConfig$.MODULE$.apply$default$2(), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        int x$18 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        double x$19 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        long x$20 = ClientQuotaManagerConfig$.MODULE$.apply$default$6();
        ClientQuotaManagerConfig configWithBackpressure = new ClientQuotaManagerConfig(x$15, x$18, x$16, diskThrottlingConfig, x$19, x$20);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(metrics, (Time)this.time(), 1L);
        ClientQuotaManager quotaManager = new ClientQuotaManager(this, configWithBackpressure, metrics, activeTenantsManager){
            private final DiskThrottleListenerManager listenerManager;

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                QuotaType.Produce$ x$3 = QuotaType.Produce$.MODULE$;
                MockTime x$4 = $outer.time();
                String x$5 = "";
                Some x$6 = new Some((Object)activeTenantsManager$1);
                Option x$7 = ClientQuotaManager$.MODULE$.$lessinit$greater$default$6();
                Option x$8 = ClientQuotaManager$.MODULE$.$lessinit$greater$default$8();
                super(configWithBackpressure$1, metrics$1, (QuotaType)x$3, (Time)x$4, x$5, x$7, (Option)x$6, x$8);
                this.listenerManager = new DiskThrottleListenerManager(null){
                    private final ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                    }
                };
            }
        };
        quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(1000.0, true)));
        quotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)quotaManager);
        Assertions.assertEquals((double)9.223372036854776E18, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertFalse((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        this.time().sleep(Math.max(configWithBackpressure.backpressureConfig().backpressureCheckFrequencyMs(), quotaManager.getCurrentDiskThrottlingConfig().diskCheckFrequencyMs()) + 1000L);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(quotaManager, "ANONYMOUS", "client1", 400.0));
        Assertions.assertEquals((double)throttledBandwidth, (double)quotaManager.getBrokerQuotaLimit(), (double)0.0);
        Assertions.assertTrue((boolean)quotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)quotaManager));
        Assertions.assertEquals((long)throttledBandwidth, (long)BoxesRunTime.unboxToLong((Object)((Option)quotaManager.lastSignalledQuotaOptRef().get()).get()));
        quotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
    }

    public double millisToPercent(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public Map<String, String> metricTags(String user, String clientId) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)}));
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$verifyDynamicQuotas$1(ClientQuotaManager quotaManager$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            String clientId = (String)x0$1._1();
            Assertions.assertEquals((double)x0$1._2$mcD$sp(), (double)quotaManager$3.dynamicQuota("", clientId).bound(), (double)0.1, (String)new StringBuilder(21).append("Unexpected quota for ").append(clientId).toString());
            return;
        }
        throw new MatchError(null);
    }

    private class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return ConfigEntityName$.MODULE$.Default();
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof UserClient)) return false;
            if (((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

