/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.ZkIsrManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0011\u0019Q\u0006\u0001)A\u0005)\"91\f\u0001b\u0001\n\u0003a\u0006BB5\u0001A\u0003%Q\fC\u0004k\u0001\t\u0007I\u0011A6\t\r=\u0004\u0001\u0015!\u0003m\u0011%\u0001\b\u00011AA\u0002\u0013\u0005\u0011\u000fC\u0005v\u0001\u0001\u0007\t\u0019!C\u0001m\"IA\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001d\u0005\b{\u0002\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t9\u0001\u0001Q\u0001\n}D\u0001\"!\u0003\u0001\u0005\u0004%\tA \u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003\u0000\u0011!\ti\u0001\u0001b\u0001\n\u0003q\bbBA\b\u0001\u0001\u0006Ia \u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005M\u0001bBAR\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003O\u0003A\u0011AA\n\u0011\u001d\tY\u000b\u0001C\u0001\u0003'Aq!a,\u0001\t\u0003\t\u0019\u0002C\u0004\u00024\u0002!\t!a\u0005\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u00111\u001a\u0001\u0005\n\u00055\u0007bBAp\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003G\u0004A\u0011AA\n\u0011\u001d\t9\u000f\u0001C\u0001\u0003'Aq!a;\u0001\t\u0003\t\u0019\u0002C\u0004\u0002p\u0002!I!!=\t\u000f\u0005U\b\u0001\"\u0003\u0002x\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001b\u0002B\t\u0001\u0011\u0005!1\u0003\u0005\b\u0005;\u0001A\u0011AA\n\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005GAqA!\f\u0001\t\u0013\u0011y\u0003C\u0005\u0003j\u0001\t\n\u0011\"\u0003\u0003l!I!\u0011\u0011\u0001\u0012\u0002\u0013%!1\u0011\u0005\n\u0005\u000f\u0003\u0011\u0013!C\u0005\u0005\u0013C\u0011B!$\u0001#\u0003%IA!#\t\u0013\t=\u0005!%A\u0005\n\t%\u0005\"\u0003BI\u0001E\u0005I\u0011\u0002BJ\u000f\u001d\u00119j\u000eE\u0001\u000533aAN\u001c\t\u0002\tm\u0005BB\"3\t\u0003\u0011i\nC\u0004\u0002VI\"\tAa(\t\u000f\u0005u$\u0007\"\u0001\u00032\n\u0019\u0012\t\u001c;fe&\u001b(/T1oC\u001e,'\u000fV3ti*\u0011\u0001(O\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001{A\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A#\u0011\u0005\u0019\u0003Q\"A\u001c\u0002\u000bQ|\u0007/[2\u0016\u0003%\u0003\"AS(\u000e\u0003-S!\u0001T'\u0002\t1\fgn\u001a\u0006\u0002\u001d\u0006!!.\u0019<b\u0013\t\u00016J\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\tQLW.Z\u000b\u0002)B\u0011Q\u000bW\u0007\u0002-*\u0011q+O\u0001\u0006kRLGn]\u0005\u00033Z\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005i\u0006C\u00010h\u001b\u0005y&BA.a\u0015\t\t'-\u0001\u0004d_6lwN\u001c\u0006\u0003u\rT!\u0001Z3\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0017aA8sO&\u0011\u0001n\u0018\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u00032s_.,'/\u00133\u0016\u00031\u0004\"AP7\n\u00059|$aA%oi\u0006I!M]8lKJLE\rI\u0001\u0013EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'/F\u0001s!\t15/\u0003\u0002uo\t\u0001#I]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003Y\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:`I\u0015\fHCA<{!\tq\u00040\u0003\u0002z\u007f\t!QK\\5u\u0011\u001dY8\"!AA\u0002I\f1\u0001\u001f\u00132\u0003M\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:!\u0003\r!\b\u000fM\u000b\u0002\u007fB!\u0011\u0011AA\u0002\u001b\u0005\u0001\u0017bAA\u0003A\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qa\u0001\n1\u0001\u001e92\u0003\u0011!\b/\r\u0011\u0002\u0007Q\u0004('\u0001\u0003uaJ\u0002\u0013!B:fiV\u0004H#A<)\u0007M\t9\u0002\u0005\u0003\u0002\u001a\u0005\u001dRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\"\u0005\r\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003K)\u0017!\u00026v]&$\u0018\u0002BA\u0015\u00037\u0011!BQ3g_J,W)Y2i\u0003%!Xm\u001d;CCNL7\rF\u0002x\u0003_Aq!!\r\u0015\u0001\u0004\t\u0019$\u0001\u0006ba&4VM]:j_:\u0004B!!\u000e\u0002:5\u0011\u0011q\u0007\u0006\u0004\u0003;I\u0014\u0002BA\u001e\u0003o\u0011!\"\u00119j-\u0016\u00148/[8oQ\u001d!\u0012qHA(\u0003#\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\tI%a\b\u0002\rA\f'/Y7t\u0013\u0011\ti%a\u0011\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005M\u0013EAA+\u0003I\u0001(o\u001c<jI\u0016\f\u0005/\u001b,feNLwN\\:)\u0007Q\tI\u0006\u0005\u0003\u0002\\\u0005uSBAA$\u0013\u0011\ty&a\u0012\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0011uKN$()Y:jGN+g\u000e\u001e'fC\u0012,'OU3d_Z,'/_*uCR,G#B<\u0002f\u0005\u001d\u0004bBA\u0019+\u0001\u0007\u00111\u0007\u0005\b\u0003S*\u0002\u0019AA6\u0003MaW-\u00193feJ+7m\u001c<fef\u001cF/\u0019;f!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9E\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002v\u0005=$a\u0005'fC\u0012,'OU3d_Z,'/_*uCR,\u0007fB\u000b\u0002@\u0005=\u0013\u0011\u0010\u0017\u0003\u0003w\n#!! \u00025A\u0014xN^5eK2+\u0017\rZ3s%\u0016\u001cwN^3ssN#\u0018\r^3)\u0007U\tI&\u0001\ruKN$xJ^3soJLG/Z,ji\"LgNQ1uG\"$2a^AC\u0011\u001d\t\tD\u0006a\u0001\u0003gAsAFA \u0003\u001f\nI\t\f\u0002\u0002T!\u001aa#!\u0017\u0002\u001fQ,7\u000f^*j]\u001edWMQ1uG\"$2a^AI\u0011\u001d\t\td\u0006a\u0001\u0003gAsaFA \u0003\u001f\n)\n\f\u0002\u0002T!\u001aq#!\u0017\u0002-Q,7\u000f^*vE6LGO\u0012:p[\u000e\u000bG\u000e\u001c2bG.D3\u0001GAO!\u0011\tI\"a(\n\t\u0005\u0005\u00161\u0004\u0002\u0005)\u0016\u001cH/A\fuKN$\u0018)\u001e;i_JL'0\u0019;j_:4\u0015-\u001b7fI\"\u001a\u0011$!(\u0002)Q,7\u000f^*uC2,'I]8lKJ,\u0005o\\2iQ\rQ\u0012QT\u0001\u0012i\u0016\u001cH/\u00168l]><hnU3sm\u0016\u0014\bfA\u000e\u0002\u001e\u0006\u0001C/Z:u%\u0016$(/_(o\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\ra\u0012QT\u0001#i\u0016\u001cHOU3uef|e.\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016\u0013(o\u001c:)\u0007u\ti*\u0001\ruKN$(+\u001a;ss>sGk\u001c9MKZ,G.\u0012:s_J$2a^A^\u0011\u001d\tiL\ba\u0001\u0003\u007f\u000bQ!\u001a:s_J\u0004B!!1\u0002H6\u0011\u00111\u0019\u0006\u0004\u0003\u000b\u0004\u0017\u0001\u00039s_R|7m\u001c7\n\t\u0005%\u00171\u0019\u0002\u0007\u000bJ\u0014xN]:\u00021Q,7\u000f\u001e*fiJLxJ\\#se>\u0014(+Z:q_:\u001cX\rF\u0002x\u0003\u001fDq!!5 \u0001\u0004\t\u0019.\u0001\u0005sKN\u0004xN\\:f!\u0011\t).a7\u000e\u0005\u0005]'bAAmE\u000691\r\\5f]R\u001c\u0018\u0002BAo\u0003/\u0014ab\u00117jK:$(+Z:q_:\u001cX-\u0001\ruKN$\u0018J\u001c<bY&$W\u000b\u001d3bi\u00164VM]:j_:D3\u0001IAO\u0003e!Xm\u001d;V].twn\u001e8U_BL7\rU1si&$\u0018n\u001c8)\u0007\u0005\ni*A\fuKN$hj\u001c;MK\u0006$WM](s\r>dGn\\<fe\"\u001a!%!(\u0002%Q,7\u000f^%om\u0006d\u0017\u000e\u001a*fcV,7\u000f\u001e\u0015\u0004G\u0005u\u0015aE2iK\u000e\\\u0007+\u0019:uSRLwN\\#se>\u0014HcA<\u0002t\"9\u0011Q\u0018\u0013A\u0002\u0005}\u0016A\u0005;fgR\u0004\u0016M\u001d;ji&|g.\u0012:s_J$b!!?\u0002\u0000\n\r\u0001c\u0001$\u0002|&\u0019\u0011Q`\u001c\u0003\u001f\u0005cG/\u001a:JgJl\u0015M\\1hKJDaA!\u0001&\u0001\u0004y\u0018A\u0001;q\u0011\u001d\ti,\na\u0001\u0003\u007f\u000bq\u0002^3ti>sW-\u00138GY&<\u0007\u000e\u001e\u000b\u0004o\n%\u0001bBA\u0019M\u0001\u0007\u00111\u0007\u0015\bM\u0005}\u0012q\nB\u0007Y\t\t\u0019\u0006K\u0002'\u00033\na\u0004^3tiB\u000b'\u000f^5uS>tW*[:tS:<\u0017J\u001c*fgB|gn]3\u0015\u0007]\u0014)\u0002C\u0004\u00022\u001d\u0002\r!a\r)\u000f\u001d\ny$a\u0014\u0003\u001a1\u0012\u00111\u000b\u0015\u0004O\u0005e\u0013a\u0003;fgRT6NQ1tS\u000eD3\u0001KAO\u0003e!Xm\u001d;DC:\u001cVOY7ji\u001a\u0013x.\\\"bY2\u0014\u0017mY6\u0015\u0007]\u0014)\u0003C\u0004\u00022%\u0002\r!a\r)\u000f%\ny$a\u0014\u0003*1\u0012\u00111\u000b\u0015\u0004S\u0005e\u0013!\u00059beRLG/[8o%\u0016\u001c\bo\u001c8tKRq!\u0011\u0007B\u001f\u0005\u007f\u0011\tE!\u0012\u0003J\t5\u0003\u0003\u0002B\u001a\u0005si!A!\u000e\u000b\u0007\t]\u0002-\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011YD!\u000e\u0003-\u0005cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016D\u0001B!\u0001+!\u0003\u0005\ra \u0005\n\u0003{S\u0003\u0013!a\u0001\u0003\u007fC\u0001Ba\u0011+!\u0003\u0005\r\u0001\\\u0001\u000fa\u0006\u0014H/\u001b;j_:,\u0005o\\2i\u0011!\u00119E\u000bI\u0001\u0002\u0004a\u0017\u0001\u00037fC\u0012,'/\u00133\t\u0011\t-#\u0006%AA\u00021\f1\u0002\\3bI\u0016\u0014X\t]8dQ\"I!q\n\u0016\u0011\u0002\u0003\u0007!\u0011K\u0001\u0004SN\u0014\b#\u0002B*\u0005Gbg\u0002\u0002B+\u0005?rAAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057Z\u0014A\u0002\u001fs_>$h(C\u0001A\u0013\r\u0011\tgP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ga\u001a\u0003\t1K7\u000f\u001e\u0006\u0004\u0005Cz\u0014a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003n)\u001aqPa\u001c,\u0005\tE\u0004\u0003\u0002B:\u0005{j!A!\u001e\u000b\t\t]$\u0011P\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u001f@\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u007f\u0012)HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u0012TC\u0001BCU\u0011\tyLa\u001c\u00027A\f'\u000f^5uS>t'+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YIK\u0002m\u0005_\n1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\"\u0014a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$S'A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0005+SCA!\u0015\u0003p\u0005\u0019\u0012\t\u001c;fe&\u001b(/T1oC\u001e,'\u000fV3tiB\u0011aIM\n\u0003eu\"\"A!'\u0015\u0005\t\u0005\u0006C\u0002BR\u0005[\u000b\u0019$\u0004\u0002\u0003&*!!q\u0015BU\u0003\u0019\u0019HO]3b[*\u0019!1V'\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005_\u0013)K\u0001\u0004TiJ,\u0017-\u001c\u000b\u0003\u0005g\u0003bAa)\u0003.\nU\u0006\u0003BA!\u0005oKAA!/\u0002D\tI\u0011I]4v[\u0016tGo\u001d")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterIsrManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<ApiVersion> provideApiVersions() {
        return AlterIsrManagerTest$.MODULE$.provideApiVersions();
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testBasic(ApiVersion apiVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(ApiVersion apiVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        LeaderRecoveryState expectedLeaderRecoveryState = apiVersion.$greater$eq((Object)KAFKA_3_2_IV0$.MODULE$) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED;
        AlterPartitionRequestData.PartitionData partitionReq = (AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0);
        Assertions.assertEquals((byte)expectedLeaderRecoveryState.value(), (byte)partitionReq.leaderRecoveryState());
        LeaderRecoveryState leaderRecoveryState2 = leaderRecoveryState;
        LeaderRecoveryState leaderRecoveryState3 = LeaderRecoveryState.RECOVERING;
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!(leaderRecoveryState2 != null ? !leaderRecoveryState2.equals(leaderRecoveryState3) : leaderRecoveryState3 != null) ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)partitionReq.isUnclean()));
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOverwriteWithinBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        CompletableFuture failedSubmitFuture = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.partitionResponse$default$1(), this.partitionResponse$default$2(), this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testSingleBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(new TopicPartition(this.topic(), 0), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable & scala.Serializable)i -> alterIsrManager.submit(new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)i)), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse errorResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionRespWithPartitionError);
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterPartitionManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$1, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0, false).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterPartitionResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), leaderAndIsr, 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.partitionResponse$default$1(), this.partitionResponse$default$2(), this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterPartitionResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false).isDone());
    }

    private AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        CompletableFuture future = alterIsrManager.submit(tp, new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterIsrManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOneInFlight(ApiVersion apiVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testPartitionMissingInResponse(ApiVersion apiVersion) {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> brokerEpoch, apiVersion);
        alterIsrManager.start();
        CompletableFuture future1 = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        ControllerRequestCompletionHandler callback1 = this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0()})));
        CompletableFuture future2 = alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        CompletableFuture future3 = alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        callback1.onComplete(this.clientResponse$1(this.tp0(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()}))).onComplete(this.clientResponse$1(this.tp2(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()}))).onComplete(this.clientResponse$1(this.tp1(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2, (Option)None$.MODULE$), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3, (Option)None$.MODULE$), 0, false);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testCanSubmitFromCallback(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        CompletableFuture future = this.submitAndVerify$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), alterIsrManager);
        future.whenComplete((x$4, x$5) -> this.submitAndVerify$1(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), alterIsrManager));
        AlterPartitionResponse alterIsrResp = this.partitionResponse(this.tp0(), Errors.NONE, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    private AlterPartitionResponse partitionResponse(TopicPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isr.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setErrorCode(error.code()))))));
    }

    private TopicPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return List$.MODULE$.empty();
    }

    private static final AbstractRequest.Builder matchesAlterIsr$1(Set topicPartitions) {
        return (AbstractRequest.Builder)ArgumentMatchers.argThat(request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Set requestTopicPartitions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(alterPartitionRequest.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)topicData -> {
                String topic = topicData.name();
                return (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicData.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionData -> new TopicPartition(topic, partitionData.partitionIndex()), Buffer$.MODULE$.canBuildFrom());
            }, Buffer$.MODULE$.canBuildFrom())).toSet();
            Set set = topicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        });
    }

    private final ControllerRequestCompletionHandler verifySendAlterIsr$1(Set topicPartitions) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest(AlterIsrManagerTest.matchesAlterIsr$1(topicPartitions), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private final ClientResponse clientResponse$1(TopicPartition topicPartition, Errors error) {
        AlterPartitionResponse alterIsrResponse = this.partitionResponse(topicPartition, error, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        return new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResponse);
    }

    /*
     * WARNING - void declaration
     */
    private final CompletableFuture submitAndVerify$1(List isr, DefaultAlterIsrManager alterIsrManager$2) {
        void var3_3;
        CompletableFuture future = alterIsrManager$2.submit(this.tp0(), new LeaderAndIsr(1, 1, isr, LeaderRecoveryState.RECOVERED, 10, (Option)None$.MODULE$), 0, false);
        Assertions.assertFalse((boolean)future.isDone());
        return var3_3;
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

