/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mga\u0002\u0010 !\u0003\r\tA\n\u0005\u0006[\u0001!\tA\f\u0005\u0006A\u00011\tA\r\u0005\b\u007f\u0001\u0011\r\u0011\"\u0001A\u0011\u001dI\u0005A1A\u0005\u0002\u0001CqA\u0013\u0001C\u0002\u0013\u0005\u0001\tC\u0004L\u0001\t\u0007I\u0011\u0001'\t\u000fY\u0003!\u0019!C\u0001\u0019\"9q\u000b\u0001b\u0001\n\u0003A\u0006bB0\u0001\u0005\u0004%\t\u0001\u0011\u0005\nA\u0002\u0001\r\u00111A\u0005\u0002\u0005D\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00015\t\u0013-\u0004\u0001\u0019!a\u0001\n\u0003a\u0007\"C:\u0001\u0001\u0004\u0005\r\u0011\"\u0001u\u0011%1\b\u00011AA\u0002\u0013\u0005q\u000fC\u0005~\u0001\u0001\u0007\t\u0019!C\u0001}\"1\u0011\u0011\u0001\u0001\u0005\u00029Ba!!\u0007\u0001\t\u0003q\u0003BBA\u000f\u0001\u0011\u0005a\u0006\u0003\u0004\u0002\"\u0001!\tA\f\u0005\u0007\u0003K\u0001A\u0011\u0001\u0018\t\r\u0005%\u0002\u0001\"\u0001/\u0011\u0019\ti\u0003\u0001C\u0001]!1\u0011\u0011\u0007\u0001\u0005\u00029Ba!!\u000e\u0001\t\u0003q\u0003bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CBq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\n\u0011\")Y:f\u0003V$\bn\u001c:ju\u0016\u0014H+Z:u\u0015\t\u0001\u0013%\u0001\u0006bkRDwN]5{KJT!AI\u0012\u0002\u0011M,7-\u001e:jifT\u0011\u0001J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003=\u0002\"\u0001\u000b\u0019\n\u0005EJ#\u0001B+oSR,\u0012a\r\t\u0003iuj\u0011!\u000e\u0006\u0003AYR!a\u000e\u001d\u0002\rM,'O^3s\u0015\t!\u0013H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 6\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u000bgV\u0004XM]+tKJ\u001cX#A!\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015\u0001\u00027b]\u001eT\u0011AR\u0001\u0005U\u00064\u0018-\u0003\u0002I\u0007\n11\u000b\u001e:j]\u001e\f\u0001\"^:fe:\fW.Z\u0001\nkN,'O\\1nKJ\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0016\u00035\u0003\"A\u0014+\u000e\u0003=S!\u0001U)\u0002\t\u0005,H\u000f\u001b\u0006\u0003EIS!a\u0015\u001d\u0002\r\r|W.\\8o\u0013\t)vJ\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\u0002\u0015A\u0014\u0018N\\2ja\u0006d''\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0016\u0003e\u0003\"AW/\u000e\u0003mS!\u0001\u0018*\u0002\u0011I,\u0017/^3tiNL!AX.\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\u0006i1/\u001e9feV\u001bXM\u001d(b[\u0016\faaY8oM&<W#\u00012\u0011\u0005\r,W\"\u00013\u000b\u0005]\u001a\u0013B\u00014e\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u00020S\"9!nCA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005y!p\\8LK\u0016\u0004XM]\"mS\u0016tG/F\u0001n!\tq\u0017/D\u0001p\u0015\t\u00018%A\u0005{_>\\W-\u001a9fe&\u0011!o\u001c\u0002\u00105>|7*Z3qKJ\u001cE.[3oi\u0006\u0019\"p\\8LK\u0016\u0004XM]\"mS\u0016tGo\u0018\u0013fcR\u0011q&\u001e\u0005\bU6\t\t\u00111\u0001n\u0003!\u0011Xm]8ve\u000e,W#\u0001=\u0011\u0005e\\X\"\u0001>\u000b\u0005Y\u0014\u0016B\u0001?{\u0005=\u0011Vm]8ve\u000e,\u0007+\u0019;uKJt\u0017\u0001\u0004:fg>,(oY3`I\u0015\fHCA\u0018\u0000\u0011\u001dQw\"!AA\u0002a\fq\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,W*\u001e7uSBdW-\u00113e\u0003:$'+Z7pm\u0016D3\u0001EA\u0003!\u0011\t9!!\u0006\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t1!\u00199j\u0015\u0011\ty!!\u0005\u0002\u000f),\b/\u001b;fe*\u0019\u00111C\u001e\u0002\u000b),h.\u001b;\n\t\u0005]\u0011\u0011\u0002\u0002\u0005)\u0016\u001cH/\u0001\"uKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/Z%t_2\fG/[8o+:\u0014X\r\\1uK\u0012$UM\\=X_:$Hi\\7j]\u0006$X-\u00117m_^D3!EA\u0003\u00039\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qK\u0012+g.\u001f+bW\u0016\u001c\bK]3dK\u0012,gnY3)\u0007I\t)!A\u001cuKN$\u0018)\u001e;i_JL'0\u001a\"z%\u0016\u001cx.\u001e:dKRK\b/\u001a)sK\u001aL\u00070\u001a3SKN|WO]2f\t\u0016t\u0017\u0010R8nS:\fG/\u001a\u0015\u0004'\u0005\u0015\u0011a\u000e;fgR\fU\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004XmV5mI\u000e\f'\u000f\u001a*fg>,(oY3EK:LHi\\7j]\u0006$X\rK\u0002\u0015\u0003\u000b\ta\u0006^3ti\u0006+H\u000f[8sSj,')\u001f*fg>,(oY3UsB,w+\u001b;i\u00032dw\n]3sCRLwN\\!dK\"\u001aQ#!\u0002\u0002SQ,7\u000f^!vi\"|'/\u001b>f\u0005f\u0014Vm]8ve\u000e,G+\u001f9f/&$\b.\u00117m\u0011>\u001cH/Q2fQ\r1\u0012QA\u0001/i\u0016\u001cH/Q;uQ>\u0014\u0018N_3CsJ+7o\\;sG\u0016$\u0016\u0010]3XSRD\u0017\t\u001c7Qe&t7-\u001b9bY\u0006\u001bW\rK\u0002\u0018\u0003\u000b\tA\u0006^3ti\u0006+H\u000f[8su\u0016\u0014\u0015PU3t_V\u00148-\u001a+za\u0016\u001cV\u000f]3s+N,'\u000fS1t\u0003\u000e\u001cWm]:)\u0007a\t)!A\toK^\u0014V-];fgR\u001cuN\u001c;fqR$r!WA\u001f\u0003\u007f\ty\u0005C\u0003L3\u0001\u0007Q\nC\u0004\u0002Be\u0001\r!a\u0011\u0002\u001b\rd\u0017.\u001a8u\u0003\u0012$'/Z:t!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%\u000b\u0006\u0019a.\u001a;\n\t\u00055\u0013q\t\u0002\f\u0013:,G/\u00113ee\u0016\u001c8\u000fC\u0005\u0002Re\u0001\n\u00111\u0001\u0002T\u00051\u0011\r]5LKf\u0004B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u00033\u0012\u0016\u0001\u00039s_R|7m\u001c7\n\t\u0005u\u0013q\u000b\u0002\b\u0003BL7*Z=t\u0003mqWm\u001e*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\r\u0016\u0005\u0003'\n)g\u000b\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014!C;oG\",7m[3e\u0015\r\t\t(K\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA;\u0003W\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\tW\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004X\r\u0006\u0006\u0002|\u0005\u0005\u00151QAC\u0003+\u00032\u0001KA?\u0013\r\ty(\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015\u00013\u00041\u00014\u0011\u001596\u00041\u0001Z\u0011\u001d\t9i\u0007a\u0001\u0003\u0013\u000b\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$S\u0003\r\t7\r\\\u0005\u0005\u0003'\u000biI\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0002\u0018n\u0001\r!!'\u0002\u0019I,7o\\;sG\u0016$\u0016\u0010]3\u0011\u0007e\fY*C\u0002\u0002\u001ej\u0014ABU3t_V\u00148-\u001a+za\u0016\fq!\u00193e\u0003\u000ed7\u000fF\u00040\u0003G\u000b)+!2\t\u000b\u0001b\u0002\u0019A\u001a\t\u000f\u0005\u001dF\u00041\u0001\u0002*\u0006!\u0011mY3t!\u0019\tY+!/\u0002@:!\u0011QVA[!\r\ty+K\u0007\u0003\u0003cS1!a-&\u0003\u0019a$o\\8u}%\u0019\u0011qW\u0015\u0002\rA\u0013X\rZ3g\u0013\u0011\tY,!0\u0003\u0007M+GOC\u0002\u00028&\u0002B!a#\u0002B&!\u00111YAG\u0005I\t5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\t\r\u0005\u001dG\u00041\u0001y\u0003=\u0011Xm]8ve\u000e,\u0007+\u0019;uKJt\u0017A\u0003:f[>4X-Q2mgRA\u00111PAg\u0003\u001f\f\t\u000eC\u0003!;\u0001\u00071\u0007C\u0004\u0002(v\u0001\r!!+\t\r\u0005\u001dW\u00041\u0001y\u0001")
public interface BaseAuthorizerTest {
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username2_$eq(String var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal2_$eq(KafkaPrincipal var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext var1);

    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String var1);

    public Authorizer authorizer();

    public String superUsers();

    public String username();

    public String username2();

    public KafkaPrincipal principal();

    public KafkaPrincipal principal2();

    public RequestContext requestContext();

    public String superUserName();

    public KafkaConfig config();

    public void config_$eq(KafkaConfig var1);

    public ZooKeeperClient zooKeeperClient();

    public void zooKeeperClient_$eq(ZooKeeperClient var1);

    public ResourcePattern resource();

    public void resource_$eq(ResourcePattern var1);

    public static /* synthetic */ void testAuthorizeByResourceTypeMultipleAddAndRemove$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeMultipleAddAndRemove();
    }

    @Test
    default public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowRead = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
            this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
                this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyRead}))), resource1);
                this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
                Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
            });
            this.removeAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowRead}))), resource1);
            Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
        });
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow();
    }

    @Test
    default public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource3 = new ResourcePattern(ResourceType.GROUP, "s", PatternType.PREFIXED);
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl7 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl6, acl7}))), resource1);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl4}))), resource2);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5}))), resource3);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host2 should not have READ access to any consumer group");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.CLUSTER), (String)"User1 from host2 should not have READ access to any topic");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should have READ access to at least one topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeDenyTakesPrecedence$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeDenyTakesPrecedence();
    }

    @Test
    default public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should have WRITE access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.TOPIC), (String)"User1 from host1 should not have WRITE access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypePrefixedResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypePrefixedResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern a = new ResourcePattern(ResourceType.GROUP, "a", PatternType.PREFIXED);
        ResourcePattern ab = new ResourcePattern(ResourceType.GROUP, "ab", PatternType.PREFIXED);
        ResourcePattern abc = new ResourcePattern(ResourceType.GROUP, "abc", PatternType.PREFIXED);
        ResourcePattern abcd = new ResourcePattern(ResourceType.GROUP, "abcd", PatternType.PREFIXED);
        ResourcePattern abcde = new ResourcePattern(ResourceType.GROUP, "abcde", PatternType.PREFIXED);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abcde);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 should have READ access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), abcd);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), abc);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), a);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 now should not have READ access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), ab);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.GROUP), (String)"User1 from host1 still should not have READ access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWildcardResourceDenyDominate$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWildcardResourceDenyDominate();
    }

    @Test
    default public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern wildcard = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern prefixed = new ResourcePattern(ResourceType.GROUP, "hello", PatternType.PREFIXED);
        ResourcePattern literal = new ResourcePattern(ResourceType.GROUP, "aloha", PatternType.LITERAL);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        AccessControlEntry allowAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry denyAce = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), prefixed);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 should have WRITE access to at least one group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 now should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), wildcard);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAce}))), literal);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.WRITE, ResourceType.GROUP), (String)"User1 from host1 still should not have WRITE access to any group");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllOperationAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllOperationAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllOperationAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry denyAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        AccessControlEntry allowAll = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyWrite = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWrite, allowAll}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now should not have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllHostAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllHostAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllHostAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        String allHost = AclEntry$.MODULE$.WildcardHost();
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyHost1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllHost = new AccessControlEntry(user1.toString(), allHost, AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u1h2Context = this.newRequestContext(user1, host2, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowHost1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyHost1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllHost}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllHost}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h2Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host2 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorizeByResourceTypeWithAllPrincipalAce$(BaseAuthorizerTest $this) {
        $this.testAuthorizeByResourceTypeWithAllPrincipalAce();
    }

    @Test
    default public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        KafkaPrincipal user1 = new KafkaPrincipal("User", "user1");
        KafkaPrincipal user2 = new KafkaPrincipal("User", "user2");
        String allUser = AclEntry$.MODULE$.WildcardPrincipalString();
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb1").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("sb2").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        AccessControlEntry allowUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry denyUser1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry denyAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry allowAllUser = new AccessControlEntry(allUser, host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        RequestContext u1h1Context = this.newRequestContext(user1, host1, this.newRequestContext$default$3());
        RequestContext u2h1Context = this.newRequestContext(user2, host1, this.newRequestContext$default$3());
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should not have READ access to any topic when no ACL exists");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowUser1}))), resource1);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource1);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 now shouldn't have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyUser1}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u1h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User1 from host1 still should not have READ access to any topic");
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should not have READ access to any topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllUser}))), resource2);
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 should now have READ access to at least one topic");
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllUser}))), resource2);
        Assertions.assertFalse((boolean)this.authorizeByResourceType(this.authorizer(), u2h1Context, AclOperation.READ, ResourceType.TOPIC), (String)"User2 from host1 now shouldn't have READ access to any topic");
    }

    public static /* synthetic */ void testAuthorzeByResourceTypeSuperUserHasAccess$(BaseAuthorizerTest $this) {
        $this.testAuthorzeByResourceTypeSuperUserHasAccess();
    }

    @Test
    default public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        AccessControlEntry denyAllAce = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        KafkaPrincipal superUser1 = new KafkaPrincipal("User", this.superUserName());
        InetAddress host1 = InetAddress.getByName("192.0.4.4");
        ResourcePattern allTopicsResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        ResourcePattern groupResource = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        ResourcePattern transactionIdResource = new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "*", PatternType.LITERAL);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), allTopicsResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), clusterResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), groupResource);
        this.addAcls(this.authorizer(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAce}))), transactionIdResource);
        RequestContext superUserContext = this.newRequestContext(superUser1, host1, this.newRequestContext$default$3());
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TOPIC), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.CLUSTER), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.GROUP), (String)"superuser always has access, no matter what acls.");
        Assertions.assertTrue((boolean)this.authorizeByResourceType(this.authorizer(), superUserContext, AclOperation.READ, ResourceType.TRANSACTIONAL_ID), (String)"superuser always has access, no matter what acls.");
    }

    public static /* synthetic */ RequestContext newRequestContext$(BaseAuthorizerTest $this, KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return $this.newRequestContext(principal, clientAddress, apiKey);
    }

    default public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY, null, false);
    }

    public static /* synthetic */ ApiKeys newRequestContext$default$3$(BaseAuthorizerTest $this) {
        return $this.newRequestContext$default$3();
    }

    default public ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    public static /* synthetic */ boolean authorizeByResourceType$(BaseAuthorizerTest $this, Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return $this.authorizeByResourceType(authorizer, requestContext, operation, resourceType);
    }

    default public boolean authorizeByResourceType(Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        AuthorizationResult authorizationResult = authorizer.authorizeByResourceType((AuthorizableRequestContext)requestContext, operation, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        return !(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null);
    }

    public static /* synthetic */ void addAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        $this.addAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public void addAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (AclCreateResult)x$1.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            BaseAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean removeAcls$(BaseAuthorizerTest $this, Authorizer authorizer, Set aces, ResourcePattern resourcePattern) {
        return $this.removeAcls(authorizer, (Set<AccessControlEntry>)aces, resourcePattern);
    }

    default public boolean removeAcls(Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = aces.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)})) : (Set)aces.map((Function1 & Serializable & scala.Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter(), Set$.MODULE$.canBuildFrom());
        return ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (AclDeleteResult)x$2.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)BaseAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    public static /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
        result.aclBindingDeleteResults().forEach(r -> r.exception().ifPresent(e -> {
            throw e;
        }));
        return !result.aclBindingDeleteResults().isEmpty();
    }

    public static void $init$(BaseAuthorizerTest $this) {
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq("User:superuser1; User:superuser2");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq("alice");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$username2_$eq("alex");
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(new KafkaPrincipal("User", $this.username()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal2_$eq(new KafkaPrincipal("User", $this.username2()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq($this.newRequestContext($this.principal(), InetAddress.getByName("192.168.0.1"), $this.newRequestContext$default$3()));
        $this.kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq("superuser1");
    }
}

