/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine;

import java.util.Arrays;
import java.util.HashSet;
import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.configmap.PartitionConfig;
import kafka.restore.db.PartitionRestoreContext;
import kafka.restore.messages.KafkaFenceResponse;
import kafka.restore.messages.MessageResponse;
import kafka.restore.messages.MessageResult;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.statemachine.RestoreFiniteStateMachine;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.events.KafkaRestoreEvent;
import kafka.restore.statemachine.transitions.FenceEventSentToPartitionFencedTransition;
import kafka.restore.statemachine.transitions.StartToFenceEventSentTransition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class RestoreFiniteStateMachineTest {
    String topic = "testTopic";
    NodeConfig partitionLeader = new NodeConfig(0, "localhost", 9072);
    PartitionConfig partitionConfig = new PartitionConfig(0, this.partitionLeader, Arrays.asList(this.partitionLeader));
    int uuid = 0;
    int requestID = 0;

    @Test
    public void testSuccessTransition() throws Exception {
        PartitionRestoreContext partitionCtx = this.buildPartitionRestoreContext();
        FiniteStateMachine fsm = this.buildFiniteStateMachine(partitionCtx);
        Assertions.assertEquals((Object)fsm.currentState(), (Object)State.START);
        Assertions.assertEquals((Object)partitionCtx.status, (Object)PartitionRestoreContext.RestoreStatus.NOT_STARTED);
        KafkaFenceResponse response = new KafkaFenceResponse(this.uuid, this.topic, this.partitionConfig.getPartition(), this.requestID, MessageStatusCode.OK, MessageResult.SUCCESS);
        fsm.fire((Event)new KafkaRestoreEvent((MessageResponse)response));
        Assertions.assertEquals((Object)fsm.currentState(), (Object)State.FENCE_EVENT_SENT);
        Assertions.assertEquals((Object)partitionCtx.status, (Object)PartitionRestoreContext.RestoreStatus.IN_PROGRESS);
    }

    @Test
    void testFailedTransition() throws Exception {
        PartitionRestoreContext partitionCtx = this.buildPartitionRestoreContext();
        FiniteStateMachine fsm = this.buildFiniteStateMachine(partitionCtx);
        MessageStatusCode statusCode = MessageStatusCode.OBJECT_NOT_FOUND;
        MessageResult result = MessageResult.FAILURE;
        KafkaFenceResponse response = new KafkaFenceResponse(this.uuid, this.topic, this.partitionConfig.getPartition(), this.requestID, statusCode, result);
        Assertions.assertEquals((Object)fsm.currentState(), (Object)State.START);
        Assertions.assertEquals((Object)partitionCtx.status, (Object)PartitionRestoreContext.RestoreStatus.NOT_STARTED);
        fsm.fire((Event)new KafkaRestoreEvent((MessageResponse)response));
        Assertions.assertEquals((Object)fsm.currentState(), (Object)State.FAILED);
        Assertions.assertEquals((Object)partitionCtx.status, (Object)PartitionRestoreContext.RestoreStatus.FAILED);
    }

    private PartitionRestoreContext buildPartitionRestoreContext() {
        PartitionRestoreContext partitionCtx = new PartitionRestoreContext(this.topic, this.partitionConfig, System.currentTimeMillis(), PartitionRestoreContext.RestoreStatus.NOT_STARTED, PartitionRestoreContext.RestoreState.RESTORE_SEGMENTS);
        return partitionCtx;
    }

    private FiniteStateMachine buildFiniteStateMachine(PartitionRestoreContext ctx) {
        MessageEmitter messageEmitter = (MessageEmitter)Mockito.mock(MessageEmitter.class);
        HashSet<Object> transitions = new HashSet<Object>();
        transitions.add(new StartToFenceEventSentTransition(messageEmitter));
        transitions.add(new FenceEventSentToPartitionFencedTransition(messageEmitter));
        RestoreFiniteStateMachine fsm = new RestoreFiniteStateMachine(ctx, transitions);
        return fsm;
    }
}

