/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import kafka.network.PrincipalConvertToJson$;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsResponseData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogAction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\u0002\u0011BQ!\u000e\u0001\u0005\u0002\u0011BQa\u000e\u0001\u0005\u0002\u0011BQ!\u000f\u0001\u0005\u0002\u0011BQa\u000f\u0001\u0005\u0002\u0011BQ!\u0010\u0001\u0005\u0002\u0011BQa\u0010\u0001\u0005\u0002\u0011BQ!\u0011\u0001\u0005\u0002\u0011BQa\u0011\u0001\u0005\u0002\u0011BQ!\u0012\u0001\u0005\u0002\u0011BQa\u0012\u0001\u0005\n!CQ\u0001\u0017\u0001\u0005\neCQ!\u001b\u0001\u0005\n)DQ\u0001\u001d\u0001\u0005\nEDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0002\u0019%\u0016\fX/Z:u\u0007>tg/\u001a:u)>T5o\u001c8UKN$(B\u0001\u000b\u0016\u0003\u001dqW\r^<pe.T\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003M\t!\u0004^3ti\u0006cGNU3rk\u0016\u001cH\u000fV=qKND\u0015M\u001c3mK\u0012$\u0012!\n\t\u00035\u0019J!aJ\u000e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002/_\u00059!.\u001e9ji\u0016\u0014(B\u0001\u00192\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0014aA8sO&\u0011Ag\u000b\u0002\u0005)\u0016\u001cH/A\u0011uKN$\u0018\t\u001c7Ba&4VM]:j_:\u001c(+Z:q_:\u001cX\rS1oI2,G\r\u000b\u0002\u0004S\u0005YB/Z:u\u00032d'+Z:q_:\u001cX\rV=qKND\u0015M\u001c3mK\u0012D#\u0001B\u0015\u0002+Q,7\u000f\u001e*fcV,7\u000f\u001e%fC\u0012,'OT8eK\"\u0012Q!K\u0001\u0013i\u0016\u001cHo\u00117jK:$\u0018J\u001c4p\u001d>$W\r\u000b\u0002\u0007S\u0005yA/Z:u%\u0016\fX/Z:u\t\u0016\u001c8\r\u000b\u0002\bS\u00051B/Z:u%\u0016\fX/Z:u\t\u0016\u001c8-T3ue&\u001c7\u000f\u000b\u0002\tS\u0005\u0001C/Z:u\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0015N|gnQ8om\u0016\u00148/[8oQ\tI\u0011&\u0001\u0013uKN$8i\u001c8gYV,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0015N|gnQ8om\u0016\u00148/[8oQ\tQ\u0011&A\u0011uKN$H+\u001a8b]R\u0004&/\u001b8dSB\fGNS:p]\u000e{gN^3sg&|g\u000e\u000b\u0002\fS\u0005\u0019\u0012m]:feR\u0004&/\u001b8dSB\fGNS:p]R\u0011Q%\u0013\u0005\u0006\u00152\u0001\raS\u0001\naJLgnY5qC2\u0004\"\u0001\u0014,\u000e\u00035S!AT(\u0002\t\u0005,H\u000f\u001b\u0006\u0003!F\u000b\u0001b]3dkJLG/\u001f\u0006\u0003%N\u000baaY8n[>t'B\u0001\fU\u0015\t)\u0016'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003/6\u0013abS1gW\u0006\u0004&/\u001b8dSB\fG.\u0001\rbgN,'\u000f^&bM.\f\u0007K]5oG&\u0004\u0018\r\u001c&t_:$2!\n.\\\u0011\u0015QU\u00021\u0001L\u0011\u0015aV\u00021\u0001^\u0003\u0011Q7o\u001c8\u0011\u0005y;W\"A0\u000b\u0005\u0001\f\u0017\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005\t\u001c\u0017a\u00026bG.\u001cxN\u001c\u0006\u0003I\u0016\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003\u0019\f1aY8n\u0013\tAwL\u0001\u0005Kg>tgj\u001c3f\u0003q\t7o]3si\u000e{gN\u001a7vK:$\bK]5oG&\u0004\u0018\r\u001c&t_:$2!J6p\u0011\u0015Qe\u00021\u0001m!\taU.\u0003\u0002o\u001b\n\u00112i\u001c8gYV,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u0011\u0015af\u00021\u0001^\u0003e\t7o]3siR+g.\u00198u!JLgnY5qC2T5o\u001c8\u0015\u0007\u0015\u0012h\u0010C\u0003K\u001f\u0001\u00071\u000f\u0005\u0002uy6\tQO\u0003\u0002wo\u0006YQ.\u001e7uSR,g.\u00198u\u0015\t1\u0002P\u0003\u0002zu\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002w\u0006\u0011\u0011n\\\u0005\u0003{V\u0014A#T;mi&$VM\\1oiB\u0013\u0018N\\2ja\u0006d\u0007\"\u0002/\u0010\u0001\u0004i\u0016a\u0002:fcV,7\u000f\u001e\u000b\u0005\u0003\u0007\t\t\u0002\u0005\u0003\u0002\u0006\u0005-ab\u0001\u0012\u0002\b%\u0019\u0011\u0011B\n\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011QBA\b\u0005\u001d\u0011V-];fgRT1!!\u0003\u0014\u0011\u001d\t\u0019\u0002\u0005a\u0001\u0003+\t1A]3r!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e#\u0006A!/Z9vKN$8/\u0003\u0003\u0002 \u0005e!aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u0002#9,wOU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0006\u0003\u0002&\u0005-\u0002\u0003BA\f\u0003OIA!!\u000b\u0002\u001a\tq!+Z9vKN$8i\u001c8uKb$\bbBA\u0017#\u0001\u0007\u0011qF\u0001\u0007EV4g-\u001a:\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005\u0019a.[8\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\tQ!)\u001f;f\u0005V4g-\u001a:")
public class RequestConvertToJsonTest {
    @Test
    public void testAllRequestTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            Object object = ApiKeys.DESCRIBE_ACLS.equals(key) ? ((DescribeAclsRequestData)ApiMessageType.fromApiKey((short)key.id).newRequest()).setPatternTypeFilter((byte)1).setResourceTypeFilter((byte)1).setPermissionType((byte)1).setOperation((byte)1) : ApiMessageType.fromApiKey((short)key.id).newRequest();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)object, (short)version);
            AbstractRequest req = AbstractRequest.parseRequest((ApiKeys)key, (short)version, (ByteBuffer)bytes, (MessageContext)MessageContext.IDENTITY).request;
            try {
                return RequestConvertToJson$.MODULE$.request(req);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled request keys");
    }

    @Test
    public void testAllApiVersionsResponseHandled() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            RequestConvertToJsonTest.$anonfun$testAllApiVersionsResponseHandled$1(key);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAllResponseTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)ApiMessageType.fromApiKey((short)key.id).newResponse(), (short)version);
            AbstractResponse res = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)version, (MessageContext)MessageContext.IDENTITY);
            try {
                return RequestConvertToJson$.MODULE$.response(res, version);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled response keys");
    }

    @Test
    public void testRequestHeaderNode() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testClientInfoNode() {
        ClientInformation clientInfo = new ClientInformation("name", "1");
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("softwareName", (JsonNode)new TextNode(clientInfo.softwareName()));
        expectedNode.set("softwareVersion", (JsonNode)new TextNode(clientInfo.softwareVersion()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.clientInfoNode(clientInfo);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson$.MODULE$.requestHeaderNode(req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterPartitionRequest alterIsrRequest = new AlterPartitionRequest(new AlterPartitionRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int temporaryMemoryBytes = 8;
        int messageConversionsTimeMs = 9;
        ObjectNode expectedPrincipalNode = new ObjectNode(JsonNodeFactory.instance);
        expectedPrincipalNode.set("class", (JsonNode)new TextNode("KafkaPrincipal"));
        expectedPrincipalNode.set("type", (JsonNode)new TextNode("User"));
        expectedPrincipalNode.set("name", (JsonNode)new TextNode("user"));
        expectedPrincipalNode.set("tokenAuthenticated", (JsonNode)BooleanNode.FALSE);
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)req.responseLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("clientAddress", (JsonNode)new TextNode(req.context().clientAddress.getHostAddress()));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)expectedPrincipalNode);
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        expectedNode.set("isDisconnectedClient", (JsonNode)BooleanNode.TRUE);
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), req.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs, true, LogAction.LOGGED);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testKafkaPrincipalJsonConversion() {
        this.assertPrincipalJson(KafkaPrincipal.ANONYMOUS);
        this.assertPrincipalJson(new KafkaPrincipal("User", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userfoo"));
        this.assertPrincipalJson(new KafkaPrincipal("User", "userbar", true));
        this.assertPrincipalJson(new KafkaPrincipal("group", "userbar", false));
    }

    @Test
    public void testConfluentPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userfoo", "authfoo"));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("group", "userbar", "authfoo", false));
        this.assertPrincipalJson((KafkaPrincipal)new ConfluentPrincipal("User", "userbar", "authfoo", true));
    }

    @Test
    public void testTenantPrincipalJsonConversion() {
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(RequestConvertToJsonTest.tenantMetadata$default$1$1(), RequestConvertToJsonTest.tenantMetadata$default$2$1(), RequestConvertToJsonTest.tenantMetadata$default$3$1(), RequestConvertToJsonTest.tenantMetadata$default$4$1(), RequestConvertToJsonTest.tenantMetadata$default$5$1(), RequestConvertToJsonTest.tenantMetadata$default$6$1())));
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1("clusterbar", RequestConvertToJsonTest.tenantMetadata$default$2$1(), RequestConvertToJsonTest.tenantMetadata$default$3$1(), RequestConvertToJsonTest.tenantMetadata$default$4$1(), RequestConvertToJsonTest.tenantMetadata$default$5$1(), RequestConvertToJsonTest.tenantMetadata$default$6$1())));
        String x$1 = "envbar";
        String x$2 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$3 = RequestConvertToJsonTest.tenantMetadata$default$2$1();
        boolean x$4 = RequestConvertToJsonTest.tenantMetadata$default$4$1();
        boolean x$5 = RequestConvertToJsonTest.tenantMetadata$default$5$1();
        boolean x$6 = RequestConvertToJsonTest.tenantMetadata$default$6$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$2, x$3, x$1, x$4, x$5, x$6)));
        String x$7 = "orgbar";
        String x$8 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$9 = RequestConvertToJsonTest.tenantMetadata$default$3$1();
        boolean x$10 = RequestConvertToJsonTest.tenantMetadata$default$4$1();
        boolean x$11 = RequestConvertToJsonTest.tenantMetadata$default$5$1();
        boolean x$12 = RequestConvertToJsonTest.tenantMetadata$default$6$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$8, x$7, x$9, x$10, x$11, x$12)));
        boolean x$13 = true;
        String x$14 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$15 = RequestConvertToJsonTest.tenantMetadata$default$2$1();
        String x$16 = RequestConvertToJsonTest.tenantMetadata$default$3$1();
        boolean x$17 = RequestConvertToJsonTest.tenantMetadata$default$5$1();
        boolean x$18 = RequestConvertToJsonTest.tenantMetadata$default$6$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userfoo", RequestConvertToJsonTest.tenantMetadata$1(x$14, x$15, x$16, x$13, x$17, x$18)));
        boolean x$19 = true;
        String x$20 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$21 = RequestConvertToJsonTest.tenantMetadata$default$2$1();
        String x$22 = RequestConvertToJsonTest.tenantMetadata$default$3$1();
        boolean x$23 = RequestConvertToJsonTest.tenantMetadata$default$4$1();
        boolean x$24 = RequestConvertToJsonTest.tenantMetadata$default$6$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$20, x$21, x$22, x$23, x$19, x$24)));
        boolean x$25 = true;
        String x$26 = RequestConvertToJsonTest.tenantMetadata$default$1$1();
        String x$27 = RequestConvertToJsonTest.tenantMetadata$default$2$1();
        String x$28 = RequestConvertToJsonTest.tenantMetadata$default$3$1();
        boolean x$29 = RequestConvertToJsonTest.tenantMetadata$default$4$1();
        boolean x$30 = RequestConvertToJsonTest.tenantMetadata$default$5$1();
        this.assertPrincipalJson((KafkaPrincipal)new MultiTenantPrincipal("userbar", RequestConvertToJsonTest.tenantMetadata$1(x$26, x$27, x$28, x$29, x$30, x$25)));
    }

    private void assertPrincipalJson(KafkaPrincipal principal) {
        JsonNode jsonNode = PrincipalConvertToJson$.MODULE$.convert(principal);
        if (principal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
            this.assertTenantPrincipalJson(multiTenantPrincipal, jsonNode);
            return;
        }
        if (principal instanceof ConfluentPrincipal) {
            ConfluentPrincipal confluentPrincipal = (ConfluentPrincipal)principal;
            this.assertConfluentPrincipalJson(confluentPrincipal, jsonNode);
            return;
        }
        if (principal != null) {
            this.assertKafkaPrincipalJson(principal, jsonNode);
            return;
        }
        throw new MatchError(null);
    }

    private void assertKafkaPrincipalJson(KafkaPrincipal principal, JsonNode json) {
        Assertions.assertEquals((Object)principal.getClass().getSimpleName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalClassKey()).textValue());
        Assertions.assertEquals((Object)principal.getPrincipalType(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalTypeKey()).textValue());
        Assertions.assertEquals((Object)principal.getName(), (Object)json.get(PrincipalConvertToJson$.MODULE$.PrincipalNameKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tokenAuthenticated()), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.TokenAuthenticatedKey()).booleanValue()));
    }

    private void assertConfluentPrincipalJson(ConfluentPrincipal principal, JsonNode json) {
        this.assertKafkaPrincipalJson((KafkaPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.authenticationId(), (Object)json.get(PrincipalConvertToJson$.MODULE$.AuthenticationIdKey()).textValue());
    }

    private void assertTenantPrincipalJson(MultiTenantPrincipal principal, JsonNode json) {
        this.assertConfluentPrincipalJson((ConfluentPrincipal)principal, json);
        Assertions.assertEquals((Object)principal.user(), (Object)json.get(PrincipalConvertToJson$.MODULE$.UserKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().tenantName, (Object)json.get(PrincipalConvertToJson$.MODULE$.TenantNameKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().clusterId, (Object)json.get(PrincipalConvertToJson$.MODULE$.ClusterIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().organizationId, (Object)json.get(PrincipalConvertToJson$.MODULE$.OrganizationIdKey()).textValue());
        Assertions.assertEquals((Object)principal.tenantMetadata().environmentId, (Object)json.get(PrincipalConvertToJson$.MODULE$.EnvironmentIdKey()).textValue());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isServiceAccount), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsServiceAccountKey()).booleanValue()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isApiKeyAuthenticated), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsApiKeyAuthenticatedKey()).booleanValue()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)principal.tenantMetadata().isHealthcheckTenant), (Object)BoxesRunTime.boxToBoolean((boolean)json.get(PrincipalConvertToJson$.MODULE$.IsHealthcheckTenantKey()).booleanValue()));
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    public static final /* synthetic */ void $anonfun$testAllApiVersionsResponseHandled$1(ApiKeys key) {
        ArrayBuffer unhandledVersions = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        key.allVersions().forEach(version -> {
            Object object = ApiKeys.DESCRIBE_LOG_DIRS.equals(key) ? ((DescribeLogDirsResponseData)ApiMessageType.fromApiKey((short)key$1.id).newResponse()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()) : ApiMessageType.fromApiKey((short)key$1.id).newResponse();
            ByteBuffer bytes = MessageUtil.toByteBuffer((Message)object, (short)Predef$.MODULE$.Short2short(version));
            AbstractResponse response = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes, (short)Predef$.MODULE$.Short2short(version), (MessageContext)MessageContext.IDENTITY);
            try {
                RequestConvertToJson$.MODULE$.response(response, Predef$.MODULE$.Short2short(version));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                unhandledVersions.$plus$eq(version);
                return;
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledVersions, (String)new StringBuilder(34).append("API: ").append(key.toString()).append(" - Unhandled request versions").toString());
    }

    private static final TenantMetadata tenantMetadata$1(String clusterId, String organizationId, String environmentId, boolean serviceAccount, boolean apiKeyAuthenticated, boolean healthcheckTenant) {
        return new TenantMetadata.Builder(clusterId, null).organizationId(organizationId).environmentId(environmentId).serviceAccount(serviceAccount).apiKeyAuthenticated(apiKeyAuthenticated).healthcheckTenant(healthcheckTenant).build();
    }

    private static final String tenantMetadata$default$1$1() {
        return "clusterfoo";
    }

    private static final String tenantMetadata$default$2$1() {
        return "orgfoo";
    }

    private static final String tenantMetadata$default$3$1() {
        return "envfoo";
    }

    private static final boolean tenantMetadata$default$4$1() {
        return false;
    }

    private static final boolean tenantMetadata$default$5$1() {
        return false;
    }

    private static final boolean tenantMetadata$default$6$1() {
        return false;
    }
}

