/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.EnvelopeResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00045\u0001\u0001\u0006I!\f\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019y\u0004\u0001)A\u0005o!9\u0001\t\u0001b\u0001\n\u0013\t\u0005BB#\u0001A\u0003%!\tC\u0004Y\u0001\t\u0007I\u0011B-\t\r}\u0003\u0001\u0015!\u0003[\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015\u0001\b\u0001\"\u0001b\u0011\u0015\u0011\b\u0001\"\u0001b\u0011\u0015!\b\u0001\"\u0001b\u0011\u00151\b\u0001\"\u0001b\u0011\u0015A\b\u0001\"\u0001b\u0011\u0015Q\b\u0001\"\u0001b\u0011\u0015a\b\u0001\"\u0001b\u0011\u0015q\b\u0001\"\u0001b\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!!\u0005\u0001\t\u0013\t\u0019\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005u\u0001\u0001\"\u0001\u0002B!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003C\u0002A\u0011BAL\u0005I\u0011V-];fgR\u001c\u0005.\u00198oK2$Vm\u001d;\u000b\u0005qi\u0012a\u00028fi^|'o\u001b\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011aG\u0001\u0016e\u0016\fX/Z:u\u0007\"\fgN\\3m\u001b\u0016$(/[2t+\u0005i\u0003C\u0001\u00182\u001d\tQs&\u0003\u000217\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017B\u0001\u001a4\u0005\u001diU\r\u001e:jGNT!\u0001M\u000e\u0002-I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u0002\n\u0001b\u00197jK:$\u0018\nZ\u000b\u0002oA\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005Y\u0006twMC\u0001=\u0003\u0011Q\u0017M^1\n\u0005yJ$AB*ue&tw-A\u0005dY&,g\u000e^%eA\u0005q\u0001O]5oG&\u0004\u0018\r\\*fe\u0012,W#\u0001\"\u0013\u0007\r3\u0015J\u0002\u0003E\u000f\u0001\u0011%\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014a\u00049sS:\u001c\u0017\u000e]1m'\u0016\u0014H-\u001a\u0011\u0011\u0005a:\u0015B\u0001%:\u0005\u0019y%M[3diB\u0011!JV\u0007\u0002\u0017*\u0011A*T\u0001\u0005CV$\bN\u0003\u0002O\u001f\u0006A1/Z2ve&$\u0018P\u0003\u0002Q#\u000611m\\7n_:T!A\b*\u000b\u0005M#\u0016AB1qC\u000eDWMC\u0001V\u0003\ry'oZ\u0005\u0003/.\u00131cS1gW\u0006\u0004&/\u001b8dSB\fGnU3sI\u0016\f\u0001\"\\8dWN+g\u000eZ\u000b\u00025B\u00111,X\u0007\u00029*\u0011AdT\u0005\u0003=r\u0013aBQ=uK\n+hMZ3s'\u0016tG-A\u0005n_\u000e\\7+\u001a8eA\u0005!B/Z:u'\u0016\u0014\u0018.\u00197ju\u0016\u0014V-];fgR$\u0012A\u0019\t\u0003E\rL!\u0001Z\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0015\u0019\u0004\"a\u001a8\u000e\u0003!T!!\u001b6\u0002\u0007\u0005\u0004\u0018N\u0003\u0002lY\u00069!.\u001e9ji\u0016\u0014(BA7U\u0003\u0015QWO\\5u\u0013\ty\u0007N\u0001\u0003UKN$\u0018!\u0005;fgR\fE\u000e^3s%\u0016\fX/Z:ug\"\u00121BZ\u0001\u001di\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:SKF,Xm\u001d;tQ\taa-\u0001\fuKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6tQ\tia-\u0001\u0012uKN$hj\u001c8BYR,'OU3rk\u0016\u001cHo\u001d(piR\u0013\u0018M\\:g_JlW\r\u001a\u0015\u0003\u001d\u0019\f\u0001\u0003^3ti*\u001bxN\u001c*fcV,7\u000f^:)\u0005=1\u0017!\u0013;fgR,eN^3m_B,')^5mIJ+7\u000f]8og\u0016\u001cVM\u001c3TQ>,H\u000e\u001a*fiV\u0014hNT8FeJ|'/\u00134J]:,'OU3ta>t7/\u001a%bg:{WI\u001d:pe\"\u0012\u0001CZ\u0001Wi\u0016\u001cH/\u00128wK2|\u0007/\u001a\"vS2$'+Z:q_:\u001cXmU3oINCw.\u001e7e%\u0016$XO\u001d8O_\u0016\u0013(o\u001c:JM&sg.\u001a:SKN\u0004xN\\:f\u0011\u0006\u001chj\u001c(pi\u000e{g\u000e\u001e:pY2,'/\u0012:s_JD#!\u00054\u0002!R,7\u000f^#om\u0016dw\u000e]3Ck&dGMU3ta>t7/Z*f]\u0012\u001c\u0006n\\;mIJ+G/\u001e:o\u001d>$8i\u001c8ue>dG.\u001a:FeJ|'/\u00134J]:,'OU3ta>t7/\u001a%bg>sW\r\u000b\u0002\u0013M\u0006!\"-^5mI6+G/\u00193bi\u0006\u0014V-];fgR$\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003P\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\b\u0003\u0013\u0011q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f^\u0001/EVLG\u000e\u001a$pe^\f'\u000f\u001a*fcV,7\u000f^,ji\",eN^3m_B,'+Z9vKN$\u0018\t\u001e;bG\",G\r\u0006\u0003\u0002\u0016\u0005m\u0001c\u0001\u0018\u0002\u0018%\u0019\u0011\u0011D\u001a\u0003\u000fI+\u0017/^3ti\"9\u0011Q\u0004\u000bA\u0002\u0005\u0015\u0011a\u0002:fcV,7\u000f^\u0001\fSN4\u0016\r\\5e\u0015N|g\u000e\u0006\u0003\u0002$\u0005%\u0002c\u0001\u0012\u0002&%\u0019\u0011qE\u0012\u0003\u000f\t{w\u000e\\3b]\"9\u00111F\u000bA\u0002\u00055\u0012aA:ueB!\u0011qFA\u001f\u001d\u0011\t\t$!\u000f\u0011\u0007\u0005M2%\u0004\u0002\u00026)\u0019\u0011qG\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\tYdI\u0001\u0007!J,G-\u001a4\n\u0007y\nyDC\u0002\u0002<\r\"B!!\u0006\u0002D!9\u0011Q\t\fA\u0002\u0005\u0015\u0011a\u0001:fc\u0006\tb.Z<SKF,Xm\u001d;D_:$X\r\u001f;\u0015\t\u0005-\u0013\u0011\u000b\t\u0005\u0003\u000f\ti%\u0003\u0003\u0002P\u0005%!A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b\u0003':\u0002\u0019AA+\u0003\u0019\u0011WO\u001a4feB!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\m\n1A\\5p\u0013\u0011\ty&!\u0017\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0003u_6\u000b\u0007\u000f\u0006\u0003\u0002f\u0005E\u0004\u0003CA4\u0003[\ni#!\f\u000e\u0005\u0005%$bAA6G\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0014\u0011\u000e\u0002\u0004\u001b\u0006\u0004\bbBA:1\u0001\u0007\u0011QO\u0001\u0007G>tg-[4\u0011\t\u0005]\u0014\u0011\u0013\b\u0005\u0003s\niI\u0004\u0003\u0002|\u0005-e\u0002BA?\u0003\u0013sA!a \u0002\b:!\u0011\u0011QAC\u001d\u0011\t\u0019$a!\n\u0003UK!a\u0015+\n\u0005y\u0011\u0016B\u0001)R\u0013\r\tYaT\u0005\u0005\u0003\u001f\u000bI!A\nBYR,'oQ8oM&<7OU3rk\u0016\u001cH/\u0003\u0003\u0002\u0014\u0006U%AB\"p]\u001aLwM\u0003\u0003\u0002\u0010\u0006%A\u0003BA3\u00033Cq!a\u001d\u001a\u0001\u0004\tY\n\u0005\u0003\u0002\u001e\u0006%f\u0002BAP\u0003Kk!!!)\u000b\u0007\u0005\rv*A\u0004nKN\u001c\u0018mZ3\n\t\u0005\u001d\u0016\u0011U\u0001#\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\n\t\u0005-\u0016Q\u0016\u0002\u001a\u00032$XM]1cY\u0016\u001cuN\u001c4jO\u000e{G\u000e\\3di&|gN\u0003\u0003\u0002(\u0006\u0005\u0006")
public class RequestChannelTest {
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final String clientId;
    private final KafkaPrincipalSerde principalSerde = new KafkaPrincipalSerde(null){

        public byte[] serialize(KafkaPrincipal principal) {
            return Utils.utf8((String)principal.toString());
        }

        public KafkaPrincipal deserialize(byte[] bytes) {
            return SecurityUtils.parseKafkaPrincipal((String)Utils.utf8((byte[])bytes));
        }
    };
    private final ByteBufferSend mockSend = (ByteBufferSend)Mockito.mock(ByteBufferSend.class);

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private String clientId() {
        return this.clientId;
    }

    private KafkaPrincipalSerde principalSerde() {
        return this.principalSerde;
    }

    private ByteBufferSend mockSend() {
        return this.mockSend;
    }

    @Test
    public void testSerializeRequest() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(brokerResource, new AlterConfigsRequest.Config((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)).asJava())), true).build());
        ByteBuffer serialized = alterConfigs.serialize();
        Assertions.assertEquals((Object)alterConfigs.buffer().rewind(), (Object)serialized.rewind());
    }

    @Test
    public void testAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry keystoreLocation = new AlterConfigsRequest.ConfigEntry("ssl.keystore.location", "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")})), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)keystoreLocation, (List)new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$)), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeyPassword = new AlterConfigsRequest.ConfigEntry(new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeyPassword, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeyPassword.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry listenerKeystore = new AlterConfigsRequest.ConfigEntry(new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString(), "/path/to/keystore");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)listenerKeystore, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)listenerKeystore.name()), (Object)"/path/to/keystore")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainJaasConfig = new AlterConfigsRequest.ConfigEntry(new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString(), sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainJaasConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainJaasConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry plainLoginCallback = new AlterConfigsRequest.ConfigEntry(new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString(), "test.LoginClass");
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)plainLoginCallback, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)plainLoginCallback.name()), (Object)plainLoginCallback.value())})), sensitiveValue);
        AlterConfigsRequest.ConfigEntry customConfig = new AlterConfigsRequest.ConfigEntry("custom.config", sensitiveValue);
        this.verifyConfig$1(brokerResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        AlterConfigsRequest.ConfigEntry compressionType = new AlterConfigsRequest.ConfigEntry("compression.type", "lz4");
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)compressionType, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")})), sensitiveValue);
        this.verifyConfig$1(topicResource, (Seq)new .colon.colon((Object)customConfig, (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)customConfig.name()), (Object)"[hidden]")})), sensitiveValue);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.emptyMap(), true).build());
        Assertions.assertEquals(Collections.emptyMap(), (Object)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs());
    }

    @Test
    public void testIncrementalAlterRequests() {
        String sensitiveValue = "secret";
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        Map keystorePassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeyPassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeyPassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(39).append("listener.name.internal.").append("ssl.key.password").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map listenerKeystore = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.internal.").append("ssl.keystore.location").toString()), (Object)"/path/to/keystore")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, listenerKeystore, listenerKeystore, sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(45).append("listener.name.internal.plain.").append("sasl.jaas.config").toString()), (Object)"[hidden]")})), sensitiveValue);
        Map plainLoginCallback = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(62).append("listener.name.internal.plain.").append("sasl.login.callback.handler.class").toString()), (Object)"test.LoginClass")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, plainLoginCallback, plainLoginCallback, sensitiveValue);
        Map sslProtocols = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.APPEND, sslProtocols, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SUBTRACT, sslProtocols, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.enabled.protocols"), (Object)"TLSv1.1")})), sensitiveValue);
        Map cipherSuites = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.cipher.suites"), null)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.DELETE, cipherSuites, cipherSuites, sensitiveValue);
        Map customConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(brokerResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource topicResource = new ConfigResource(ConfigResource.Type.TOPIC, "testTopic");
        Map compressionType = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression.type"), (Object)"lz4")}));
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, compressionType, compressionType, sensitiveValue);
        this.verifyConfig$2(topicResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
        ConfigResource linkResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "link1");
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map linkJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, linkJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
        this.verifyConfig$2(linkResource, AlterConfigOp.OpType.SET, customConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"custom.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testCreateClusterLinks() {
        String sensitiveValue = "secret";
        Map keystorePassword = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(keystorePassword, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map keystoreLocation = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore")}));
        this.verifyConfigs$1(keystoreLocation, keystoreLocation, sensitiveValue);
        this.verifyConfigs$1(keystoreLocation.$plus$plus((GenTraversableOnce)keystorePassword), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.location"), (Object)"/path/to/keystore"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.password"), (Object)"[hidden]")})), sensitiveValue);
        Map plainJaasConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)sensitiveValue)}));
        this.verifyConfigs$1(plainJaasConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)"[hidden]")})), sensitiveValue);
    }

    @Test
    public void testNonAlterRequestsNotTransformed() {
        RequestChannel.Request metadataRequest = this.request(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"topic", (List)Nil$.MODULE$)).asJava(), true).build());
        Assertions.assertSame((Object)metadataRequest.body(ClassTag$.MODULE$.apply(MetadataRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())), (Object)metadataRequest.loggableRequest());
    }

    @Test
    public void testJsonRequests() {
        String sensitiveValue = "secret";
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigsRequest.ConfigEntry keystorePassword = new AlterConfigsRequest.ConfigEntry("ssl.keystore.password", sensitiveValue);
        .colon.colon entries = new .colon.colon((Object)keystorePassword, (List)Nil$.MODULE$);
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        Assertions.assertTrue((boolean)this.isValidJson(RequestConvertToJson$.MODULE$.request(alterConfigs.loggableRequest()).toString()));
    }

    @Test
    public void testEnvelopeBuildResponseSendShouldReturnNoErrorIfInnerResponseHasNoError() {
        RequestChannel.Request channelRequest = this.buildForwardRequestWithEnvelopeRequestAttached(this.buildMetadataRequest());
        ArgumentCaptor envelopeResponseArgumentCaptor = ArgumentCaptor.forClass(EnvelopeResponse.class);
        ((RequestContext)Mockito.doAnswer(x$1 -> this.mockSend()).when((Object)((RequestChannel.Request)channelRequest.envelope().get()).context())).buildResponseSend((AbstractResponse)envelopeResponseArgumentCaptor.capture());
        MetadataResponse responseWithoutError = RequestTestUtils.metadataUpdateWith((int)2, Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        channelRequest.buildResponseSend((AbstractResponse)responseWithoutError);
        Assertions.assertTrue((boolean)((EnvelopeResponse)envelopeResponseArgumentCaptor.getValue()).error().equals((Object)Errors.NONE));
    }

    @Test
    public void testEnvelopeBuildResponseSendShouldReturnNoErrorIfInnerResponseHasNoNotControllerError() {
        RequestChannel.Request channelRequest = this.buildForwardRequestWithEnvelopeRequestAttached(this.buildMetadataRequest());
        ArgumentCaptor envelopeResponseArgumentCaptor = ArgumentCaptor.forClass(EnvelopeResponse.class);
        ((RequestContext)Mockito.doAnswer(x$2 -> this.mockSend()).when((Object)((RequestChannel.Request)channelRequest.envelope().get()).context())).buildResponseSend((AbstractResponse)envelopeResponseArgumentCaptor.capture());
        MetadataResponse responseWithTimeoutError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.REQUEST_TIMED_OUT), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        channelRequest.buildResponseSend((AbstractResponse)responseWithTimeoutError);
        Assertions.assertTrue((boolean)((EnvelopeResponse)envelopeResponseArgumentCaptor.getValue()).error().equals((Object)Errors.NONE));
    }

    @Test
    public void testEnvelopeBuildResponseSendShouldReturnNotControllerErrorIfInnerResponseHasOne() {
        RequestChannel.Request channelRequest = this.buildForwardRequestWithEnvelopeRequestAttached(this.buildMetadataRequest());
        ArgumentCaptor envelopeResponseArgumentCaptor = ArgumentCaptor.forClass(EnvelopeResponse.class);
        ((RequestContext)Mockito.doAnswer(x$3 -> this.mockSend()).when((Object)((RequestChannel.Request)channelRequest.envelope().get()).context())).buildResponseSend((AbstractResponse)envelopeResponseArgumentCaptor.capture());
        MetadataResponse responseWithNotControllerError = RequestTestUtils.metadataUpdateWith((String)"cluster1", (int)2, Collections.singletonMap("a", Errors.NOT_CONTROLLER), Collections.singletonMap("a", Predef$.MODULE$.int2Integer(2)));
        channelRequest.buildResponseSend((AbstractResponse)responseWithNotControllerError);
        Assertions.assertTrue((boolean)((EnvelopeResponse)envelopeResponseArgumentCaptor.getValue()).error().equals((Object)Errors.NOT_CONTROLLER));
    }

    private AbstractRequest buildMetadataRequest() {
        String resourceName = "topic-1";
        RequestHeader header = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), this.clientId(), 0);
        return new MetadataRequest.Builder(Collections.singletonList(resourceName), true).build(header.apiVersion());
    }

    private RequestChannel.Request buildForwardRequestWithEnvelopeRequestAttached(AbstractRequest request) {
        KafkaPrincipalSerde x$2 = this.principalSerde();
        RequestChannel.Metrics x$3 = this.requestChannelMetrics();
        long x$4 = System.nanoTime();
        boolean x$5 = true;
        boolean x$6 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$5();
        Option<RequestChannel.Request> x$7 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$7();
        RequestChannel.Request envelopeRequest = TestUtils$.MODULE$.buildRequestWithEnvelope(request, x$2, x$3, x$4, x$6, x$5, x$7);
        KafkaPrincipalSerde x$9 = this.principalSerde();
        RequestChannel.Metrics x$10 = this.requestChannelMetrics();
        long x$11 = System.nanoTime();
        Option x$12 = Option$.MODULE$.apply((Object)envelopeRequest);
        boolean x$13 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$5();
        boolean x$14 = TestUtils$.MODULE$.buildRequestWithEnvelope$default$6();
        return TestUtils$.MODULE$.buildRequestWithEnvelope(request, x$9, x$10, x$11, x$13, x$14, (Option<RequestChannel.Request>)x$12);
    }

    private boolean isValidJson(String str) {
        try {
            new ObjectMapper().readTree(str);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = req.serializeWithHeader(new RequestHeader(req.apiKey(), req.version(), "client-id", 1));
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)Mockito.mock(MemoryPool.class), buffer, (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), null, false);
    }

    private Map<String, String> toMap(AlterConfigsRequest.Config config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> toMap(IncrementalAlterConfigsRequestData.AlterableConfigCollection config) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)config).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private final void verifyConfig$1(ConfigResource resource, Seq entries, Map expectedValues, String sensitiveValue$1) {
        RequestChannel.Request alterConfigs = this.request(new AlterConfigsRequest.Builder(Collections.singletonMap(resource, new AlterConfigsRequest.Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)entries).asJavaCollection())), true).build());
        AlterConfigsRequest.Config loggedConfig = (AlterConfigsRequest.Config)((AlterConfigsRequest)alterConfigs.loggableRequest()).configs().get(resource);
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$1), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterRequests$1(IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs$1, AlterConfigOp.OpType op$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String name = (String)x0$1._1();
        String value = (String)x0$1._2();
        boolean bl = alterableConfigs$1.add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterableConfig().setName(name).setValue(value).setConfigOperation(op$1.id()));
        return bl;
    }

    private static final IncrementalAlterConfigsRequest incrementalAlterConfigs$1(ConfigResource resource, Map entries, AlterConfigOp.OpType op) {
        IncrementalAlterConfigsRequestData data = new IncrementalAlterConfigsRequestData();
        IncrementalAlterConfigsRequestData.AlterableConfigCollection alterableConfigs = new IncrementalAlterConfigsRequestData.AlterableConfigCollection();
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestChannelTest.$anonfun$testIncrementalAlterRequests$1(alterableConfigs, op, x0$1)));
        data.resources().add((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName(resource.name()).setResourceType(resource.type().id()).setConfigs(alterableConfigs));
        return (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(data).build();
    }

    private final void verifyConfig$2(ConfigResource resource, AlterConfigOp.OpType op, Map entries, Map expectedValues, String sensitiveValue$2) {
        RequestChannel.Request alterConfigs = this.request((AbstractRequest)RequestChannelTest.incrementalAlterConfigs$1(resource, entries, op));
        IncrementalAlterConfigsRequestData.AlterableConfigCollection loggedConfig = ((IncrementalAlterConfigsRequest)alterConfigs.loggableRequest()).data().resources().find(resource.type().id(), resource.name()).configs();
        Assertions.assertEquals((Object)expectedValues, this.toMap(loggedConfig));
        String alterConfigsDesc = RequestConvertToJson$.MODULE$.requestDesc(alterConfigs.header(), alterConfigs.requestLog(), alterConfigs.isForwarded()).toString();
        Assertions.assertFalse((boolean)alterConfigsDesc.contains(sensitiveValue$2), (String)new StringBuilder(24).append("Sensitive config logged ").append(alterConfigsDesc).toString());
    }

    private final void verifyConfigs$1(Map requestConfigs, Map expectedLoggedConfigs, String sensitiveValue$3) {
        Set<NewClusterLink> link = Collections.singleton(new NewClusterLink("linkName", "clusterId", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(requestConfigs).asJava()));
        CreateClusterLinksRequest createRequest = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(link, false, false, 10000).build();
        RequestChannel.Request createLinks = this.request((AbstractRequest)createRequest);
        CreateClusterLinksRequest loggableRequest = (CreateClusterLinksRequest)createLinks.loggableRequest();
        scala.collection.mutable.Map loggedConfigs = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((NewClusterLink)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(loggableRequest.newClusterLinks()).asScala()).head()).configs()).asScala();
        Assertions.assertEquals((Object)expectedLoggedConfigs, (Object)loggedConfigs);
        String createLinksDesc = RequestConvertToJson$.MODULE$.requestDesc(createLinks.header(), createLinks.requestLog(), true).toString();
        Assertions.assertFalse((boolean)createLinksDesc.contains(sensitiveValue$3), (String)new StringBuilder(24).append("Sensitive config logged ").append(createLinksDesc).toString());
    }

    public RequestChannelTest() {
        this.clientId = "id";
    }
}

