/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberSummary;
import kafka.metrics.ConsumerLagEmitter;
import kafka.metrics.ConsumerLagEmitter$;
import kafka.metrics.MemberTopicPartition;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r]a\u0001\u0002$H\u00011CQa\u0015\u0001\u0005\u0002QCq\u0001\u0013\u0001A\u0002\u0013%q\u000bC\u0004e\u0001\u0001\u0007I\u0011B3\t\r-\u0004\u0001\u0015)\u0003Y\u0011\u001da\u0007\u00011A\u0005\n5DqA\u001e\u0001A\u0002\u0013%q\u000f\u0003\u0004z\u0001\u0001\u0006KA\u001c\u0005\bu\u0002\u0001\r\u0011\"\u0003|\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0004\u0002\u0010\u0001\u0001\u000b\u0015\u0002?\t\u0013\u0005E\u0001\u00011A\u0005\n\u0005M\u0001\"CA\u0011\u0001\u0001\u0007I\u0011BA\u0012\u0011!\t9\u0003\u0001Q!\n\u0005U\u0001\"CA\u0015\u0001\u0001\u0007I\u0011BA\u0016\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0015BA\u0017\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0011BA \u0011%\t9\u0005\u0001b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA&\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA4\u0011%\t9\b\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA4\u0011%\tY\b\u0001b\u0001\n\u0013\ti\b\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0011BA@\u0011%\t9\n\u0001b\u0001\n\u0013\tI\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAN\u0011%\t)\u000b\u0001b\u0001\n\u0013\tI\n\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAN\u0011%\tI\u000b\u0001b\u0001\n\u0013\tI\n\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAN\u0011%\ti\u000b\u0001b\u0001\n\u0013\tI\n\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAN\u0011%\t\t\f\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u00024\u0002\u0001\u000b\u0011BA4\u0011%\t)\f\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u00028\u0002\u0001\u000b\u0011BA4\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!a5\u0001\t\u0003\tY\fC\u0004\u0002^\u0002!\t!a/\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002<\"9\u00111\u001e\u0001\u0005\u0002\u0005m\u0006bBAx\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003g\u0004A\u0011AA^\u0011\u001d\t9\u0010\u0001C\u0001\u0003wCq!a?\u0001\t\u0003\tY\fC\u0004\u0002\u0000\u0002!\t!a/\t\u000f\t\r\u0001\u0001\"\u0001\u0002<\"9!q\u0001\u0001\u0005\u0002\u0005m\u0006b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005'\u0001A\u0011AA^\u0011\u001d\u00119\u0002\u0001C\u0001\u0003wCqAa\u0007\u0001\t\u0003\tY\fC\u0004\u0003 \u0001!\t!a/\t\u000f\t\r\u0002\u0001\"\u0001\u0002<\"9!q\u0005\u0001\u0005\u0002\u0005m\u0006b\u0002B\u0016\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005_\u0001A\u0011AA^\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003wCqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003P\u0001!IA!\u0015\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!1\u0010\u0001\u0005\n\tu\u0004\"\u0003Bd\u0001E\u0005I\u0011\u0002Be\u0011\u001d\u0011y\u000e\u0001C\u0005\u0005CD\u0011Ba>\u0001#\u0003%IA!3\t\u000f\te\b\u0001\"\u0003\u0003|\"911\u0002\u0001\u0005\n\r5!AF\"p]N,X.\u001a:MC\u001e,U.\u001b;uKJ$Vm\u001d;\u000b\u0005!K\u0015aB7fiJL7m\u001d\u0006\u0002\u0015\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001N!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0016\t\u0003-\u0002i\u0011aR\u000b\u00021B\u0011\u0011LY\u0007\u00025*\u0011\u0001j\u0017\u0006\u00039v\u000baaY8n[>t'B\u0001&_\u0015\ty\u0006-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0006\u0019qN]4\n\u0005\rT&aB'fiJL7m]\u0001\f[\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0002gSB\u0011ajZ\u0005\u0003Q>\u0013A!\u00168ji\"9!nAA\u0001\u0002\u0004A\u0016a\u0001=%c\u0005AQ.\u001a;sS\u000e\u001c\b%A\bn_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u+\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\u0015\tG-\\5o\u0015\t\u0019X,A\u0004dY&,g\u000e^:\n\u0005U\u0004(aD'pG.\fE-\\5o\u00072LWM\u001c;\u0002'5|7m[!e[&t7\t\\5f]R|F%Z9\u0015\u0005\u0019D\bb\u00026\u0007\u0003\u0003\u0005\rA\\\u0001\u0011[>\u001c7.\u00113nS:\u001cE.[3oi\u0002\n\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0016\u0003q\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005)qM]8va*\u0019\u00111A%\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0004\u0003\u000fq(\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u0003Q9'o\\;q\u0007>|'\u000fZ5oCR|'o\u0018\u0013fcR\u0019a-!\u0004\t\u000f)L\u0011\u0011!a\u0001y\u0006\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014XCAA\u000b!\u0011\t9\"!\b\u000e\u0005\u0005e!bAA\u000e\u0013\u0006)Q\u000f^5mg&!\u0011qDA\r\u0005%\u00196\r[3ek2,'/A\u0007tG\",G-\u001e7fe~#S-\u001d\u000b\u0004M\u0006\u0015\u0002\u0002\u00036\r\u0003\u0003\u0005\r!!\u0006\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b%\u0001\nd_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014XCAA\u0017!\r1\u0016qF\u0005\u0004\u0003c9%AE\"p]N,X.\u001a:MC\u001e,U.\u001b;uKJ\facY8ogVlWM\u001d'bO\u0016k\u0017\u000e\u001e;fe~#S-\u001d\u000b\u0004M\u0006]\u0002\u0002\u00036\u0010\u0003\u0003\u0005\r!!\f\u0002'\r|gn];nKJd\u0015mZ#nSR$XM\u001d\u0011\u0002\tQLW.Z\u000b\u0003\u0003\u007f\u0001B!a\u0006\u0002B%!\u00111IA\r\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001\u00049s_R|7m\u001c7UsB,WCAA&!\u0011\ti%a\u0017\u000f\t\u0005=\u0013q\u000b\t\u0004\u0003#zUBAA*\u0015\r\t)fS\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005es*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\nyF\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033z\u0015!\u00049s_R|7m\u001c7UsB,\u0007%\u0001\u0005he>,\b/\u001331+\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003c\nAA[1wC&!\u0011QLA6\u0003%9'o\\;q\u0013\u0012\u0004\u0004%\u0001\u0005he>,\b/\u001332\u0003%9'o\\;q\u0013\u0012\f\u0004%\u0001\bhe>,\bo\u0014<feZLWm^:\u0016\u0005\u0005}\u0004CBAA\u0003\u0017\u000by)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003%IW.\\;uC\ndWMC\u0002\u0002\n>\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti)a!\u0003\t1K7\u000f\u001e\t\u0004{\u0006E\u0015bAAJ}\niqI]8va>3XM\u001d<jK^\fqb\u001a:pkB|e/\u001a:wS\u0016<8\u000fI\u0001\u0011i>\u0004\u0018n\u0019\u0019QCJ$\u0018\u000e^5p]B*\"!a'\u0011\t\u0005u\u0015qT\u0007\u00027&\u0019\u0011\u0011U.\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\tBo\u001c9jGB\u0002\u0016M\u001d;ji&|g\u000e\r\u0011\u0002!Q|\u0007/[21!\u0006\u0014H/\u001b;j_:\f\u0014!\u0005;pa&\u001c\u0007\u0007U1si&$\u0018n\u001c82A\u0005\u0001Bo\u001c9jGF\u0002\u0016M\u001d;ji&|g\u000eM\u0001\u0012i>\u0004\u0018nY\u0019QCJ$\u0018\u000e^5p]B\u0002\u0013\u0001\u0005;pa&\u001c\u0017\u0007U1si&$\u0018n\u001c82\u0003E!x\u000e]5dcA\u000b'\u000f^5uS>t\u0017\u0007I\u0001\u0015\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9IC:$G.\u001a:\u0002+\u0011+7o\u0019:jE\u0016<%o\\;q\u0011\u0006tG\r\\3sA\u0005\u0019b)\u001a;dQ>3gm]3ug\"\u000bg\u000e\u001a7fe\u0006!b)\u001a;dQ>3gm]3ug\"\u000bg\u000e\u001a7fe\u0002\n!\"\u001b8ji&\fG.\u001b>f)\u00051\u0007fA\u0014\u0002@B!\u0011\u0011YAh\u001b\t\t\u0019M\u0003\u0003\u0002F\u0006\u001d\u0017aA1qS*!\u0011\u0011ZAf\u0003\u001dQW\u000f]5uKJT1!!4a\u0003\u0015QWO\\5u\u0013\u0011\t\t.a1\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0003dY>\u001cX\rK\u0002)\u0003/\u0004B!!1\u0002Z&!\u00111\\Ab\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\fuKN$8i\u001c8tk6,'\u000fT1h\u001b\u0016$(/[2tQ\rI\u0013\u0011\u001d\t\u0005\u0003\u0003\f\u0019/\u0003\u0003\u0002f\u0006\r'\u0001\u0002+fgR\f\u0001\u0003^3ti\u0016C\b/\u001b:f\u000fJ|W\u000f]:)\u0007)\n\t/A\u0014uKN$H*[:u\u000fJ|W\u000f]:IC:$G.\u001a:FeJ|'o\u00155pk2$7k[5q\u00032d\u0007fA\u0016\u0002b\u0006aC/Z:u\u0019&\u001cHo\u0012:pkB\u001c\b*\u00198eY\u0016\u0014XI\u001d:peNCw.\u001e7e%\u0016$\u0018-\u001b8HCV<Wm\u001d\u0015\u0004Y\u0005\u0005\u0018\u0001\f;fgR$Um]2sS\n,wI]8va\"\u000bg\u000e\u001a7fe\u0016\u0013(o\u001c:TQ>,H\u000eZ*lSB<%o\\;qQ\ri\u0013\u0011]\u0001'i\u0016\u001cH/\u00138wC2LG\r\u0015:pi>\u001cw\u000e\u001c+za\u0016\u001c\u0006n\\;mIN[\u0017\u000e]$s_V\u0004\bf\u0001\u0018\u0002b\u0006YC/Z:u\r\u0016$8\r[(gMN,Go\u001d%b]\u0012dWM]#se>\u00148\u000b[8vY\u0012\u001c6.\u001b9He>,\b\u000fK\u00020\u0003C\f1\u0005^3ti>sG.\u001f$fi\u000eDwJ\u001a4tKR\u001chi\u001c:Ti\u0006\u0014G.Z$s_V\u00048\u000fK\u00021\u0003C\f\u0001\t^3ti\u0012+7o\u0019:jE\u0016<%o\\;q\u0011\u0006tG\r\\3s\u000bJ\u0014xN]*i_VdG-\u0012=qSJ,w)Y;hK^CWM\u001c(pi\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004c\u0005\u0005\u0018a\u0010;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0011\u0006tG\r\\3s\u000bJ\u0014xN]*i_VdG-\u0012=qSJ,w)Y;hK^CWM\u001c(pi\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004e\u0005\u0005\u0018a\f5b]\u0012dWM]#se>\u00148\u000b[8vY\u0012,\u0005\u0010]5sK\u001e\u000bWoZ3XQ\u0016tgj\u001c;D_>\u0014H-\u001b8bi>\u0014Hc\u00014\u0003\u0010!9!\u0011C\u001aA\u0002\u0005-\u0013a\u00025b]\u0012dWM]\u00015i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8J]\u0012+7/\u001a:jC2L'0Z!tg&<g.\\3oiNCw.\u001e7e'.L\u0007/T3nE\u0016\u0014\bf\u0001\u001b\u0002b\u0006AD/Z:u\r\u0016$8\r[(gMN,Go\u001d%b]\u0012dWM\u001d)beRLG/[8o\u000bJ\u0014xN]*i_VdGmU6jaB\u000b'\u000f^5uS>t\u0007fA\u001b\u0002b\u0006\u0001D/Z:u\u0019&\u001cHo\u00144gg\u0016$8\u000fU1si&$\u0018n\u001c8FeJ|'o\u00155pk2$7k[5q!\u0006\u0014H/\u001b;j_:D3ANAq\u0003\u001d\"Xm\u001d;DQ\u0006tw-Z%o\u001b\u0016l'-\u001a:tQ&\u00048\u000b[8vY\u0012,\u0006\u000fZ1uK\u001e\u000bWoZ3)\u0007]\n\t/A\u0013uKN$(+\u001a2bY\u0006t7-\u001b8h\u000fJ|W\u000f]*i_VdGMU3uC&tw)Y;hK\"\u001a\u0001(!9\u0002[Q,7\u000f\u001e(fO\u0006$\u0018N^3D_:\u001cX/\\3s\u0019\u0006<7\u000b[8vY\u0012\u0014UMU3d_J$W\rZ!t5\u0016\u0014x\u000eK\u0002:\u0003C\fa\u0006^3ti\u0016k\u0007\u000f^=DkJ\u0014XM\u001c;PM\u001a\u001cX\r^:TQ>,H\u000e\u001a(pi\u000e{WO\u001c;Bg\u0016C\b/\u001b:fI\"\u001a!(!9\u00029Q,7\u000f^'f[\n,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eV1hg\"\u001a1(!9\u0002aQ,7\u000f^'bs\n,\u0007K]3gSb$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i)\u0016t\u0017M\u001c;Gk:\u001cG/[8oQ\ra\u0014\u0011]\u0001\u0013m\u0016\u0014\u0018NZ=NK6\u0014WM]'fiJL7\rF\u0003g\u0005w\u0011)\u0005C\u0004\u0003>u\u0002\rAa\u0010\u0002\r5,WNY3s!\r1&\u0011I\u0005\u0004\u0005\u0007:%\u0001F'f[\n,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0003Hu\u0002\rA!\u0013\u0002\u0017\u0015D\b/Z2uK\u0012d\u0015m\u001a\t\u0004\u001d\n-\u0013b\u0001B'\u001f\n!Aj\u001c8h\u0003E1XM]5gs6+GO]5d-\u0006dW/Z\u000b\u0005\u0005'\u0012\t\u0007F\u0003g\u0005+\u0012I\u0006C\u0004\u0003Xy\u0002\r!a\u0013\u0002\u00155,GO]5d\u001d\u0006lW\rC\u0004\u0003\\y\u0002\rA!\u0018\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f!\u0011\u0011yF!\u0019\r\u0001\u00119!1\r C\u0002\t\u0015$!\u0001+\u0012\t\t\u001d$Q\u000e\t\u0004\u001d\n%\u0014b\u0001B6\u001f\n9aj\u001c;iS:<\u0007c\u0001(\u0003p%\u0019!\u0011O(\u0003\u0007\u0005s\u00170A\nde\u0016\fG/Z$s_V\u0004xJ^3sm&,w\u000f\u0006\u0003\u0002\u0010\n]\u0004b\u0002B=\u007f\u0001\u0007\u00111J\u0001\bOJ|W\u000f]%e\u0003Q\u0019'/Z1uK\u000e+(O]3oi>3gm]3ugRA!q\u0010BV\u0005\u007f\u0013\u0019\r\u0005\u0005\u0002\u0002\n\u0005\u00151\u0014BC\u0013\u0011\u0011\u0019)a!\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003\b\n\u0015f\u0002\u0002BE\u0005?sAAa#\u0003\u001c:!!Q\u0012BM\u001d\u0011\u0011yIa&\u000f\t\tE%Q\u0013\b\u0005\u0003#\u0012\u0019*C\u0001b\u0013\ty\u0006-\u0003\u0002K=&\u0011A,X\u0005\u0004\u0005;[\u0016\u0001\u0003:fcV,7\u000f^:\n\t\t\u0005&1U\u0001\u0014\u001f\u001a47/\u001a;GKR\u001c\u0007NU3ta>t7/\u001a\u0006\u0004\u0005;[\u0016\u0002\u0002BT\u0005S\u0013Q\u0002U1si&$\u0018n\u001c8ECR\f'\u0002\u0002BQ\u0005GCqA!,A\u0001\u0004\u0011y+A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0019\u0011\tLa/\u0002\u001c:!!1\u0017B\\\u001d\u0011\t\tF!.\n\u0003AK1A!/P\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0003>*\u0019!\u0011X(\t\u000f\t\u0005\u0007\t1\u0001\u0003J\u0005Q!-Y:f\u001f\u001a47/\u001a;\t\u0013\t\u0015\u0007\t%AA\u0002\t%\u0013AE5oGJ,W.\u001a8uS:<wJ\u001a4tKR\fad\u0019:fCR,7)\u001e:sK:$xJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t-'\u0006\u0002B%\u0005\u001b\\#Aa4\u0011\t\tE'1\\\u0007\u0003\u0005'TAA!6\u0003X\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053|\u0015AC1o]>$\u0018\r^5p]&!!Q\u001cBj\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014GJ,\u0017\r^3MCR,7\u000f^(gMN,Go\u001d\u000b\t\u0005G\u0014\tPa=\u0003vBA!Q\u001dBv\u00037\u0013i/\u0004\u0002\u0003h*!!\u0011^A8\u0003\u0011)H/\u001b7\n\t\t\r%q\u001d\t\u0005\u0003S\u0012y/\u0003\u0003\u0003N\u0005-\u0004b\u0002BW\u0005\u0002\u0007!q\u0016\u0005\b\u0005\u0003\u0014\u0005\u0019\u0001B%\u0011%\u0011)M\u0011I\u0001\u0002\u0004\u0011I%A\u000fde\u0016\fG/\u001a'bi\u0016\u001cHo\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003A\u0019'/Z1uK\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0003\u0003~\u000e%\u0001#\u0002(\u0003\u0000\u000e\r\u0011bAB\u0001\u001f\n)\u0011I\u001d:bsB\u0019aj!\u0002\n\u0007\r\u001dqJ\u0001\u0003CsR,\u0007b\u0002BW\t\u0002\u0007!qV\u0001\u0019GJ,\u0017\r^3D_:\u001cX/\\3s\u0019\u0006<W)\\5ui\u0016\u0014H\u0003BA\u0017\u0007\u001fAa!]#A\u0002\rE\u0001cA8\u0004\u0014%\u00191Q\u00039\u0003\u000b\u0005#W.\u001b8")
public class ConsumerLagEmitterTest {
    private Metrics metrics = null;
    private MockAdminClient mockAdminClient = null;
    private GroupCoordinator groupCoordinator = null;
    private Scheduler scheduler = null;
    private ConsumerLagEmitter consumerLagEmitter = null;
    private final MockTime time = new MockTime();
    private final String protocolType;
    private final String groupId0;
    private final String groupId1;
    private final List<GroupOverview> groupOverviews = new .colon.colon((Object)this.createGroupOverview(this.groupId0()), (List)new .colon.colon((Object)this.createGroupOverview(this.groupId1()), (List)Nil$.MODULE$));
    private final TopicPartition topic0Partition0 = new TopicPartition("topic-0", 0);
    private final TopicPartition topic0Partition1 = new TopicPartition("topic-0", 1);
    private final TopicPartition topic1Partition0 = new TopicPartition("topic-1", 0);
    private final TopicPartition topic1Partition1 = new TopicPartition("topic-1", 1);
    private final String DescribeGroupHandler;
    private final String FetchOffsetsHandler;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private MockAdminClient mockAdminClient() {
        return this.mockAdminClient;
    }

    private void mockAdminClient_$eq(MockAdminClient x$1) {
        this.mockAdminClient = x$1;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    private void scheduler_$eq(Scheduler x$1) {
        this.scheduler = x$1;
    }

    private ConsumerLagEmitter consumerLagEmitter() {
        return this.consumerLagEmitter;
    }

    private void consumerLagEmitter_$eq(ConsumerLagEmitter x$1) {
        this.consumerLagEmitter = x$1;
    }

    private MockTime time() {
        return this.time;
    }

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId0() {
        return this.groupId0;
    }

    private String groupId1() {
        return this.groupId1;
    }

    private List<GroupOverview> groupOverviews() {
        return this.groupOverviews;
    }

    private TopicPartition topic0Partition0() {
        return this.topic0Partition0;
    }

    private TopicPartition topic0Partition1() {
        return this.topic0Partition1;
    }

    private TopicPartition topic1Partition0() {
        return this.topic1Partition0;
    }

    private TopicPartition topic1Partition1() {
        return this.topic1Partition1;
    }

    private String DescribeGroupHandler() {
        return this.DescribeGroupHandler;
    }

    private String FetchOffsetsHandler() {
        return this.FetchOffsetsHandler;
    }

    @BeforeEach
    public void initialize() {
        java.util.List brokers = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Node(0, "localhost", 9092), (List)Nil$.MODULE$)).asJava();
        this.metrics_$eq(new Metrics());
        this.groupCoordinator_$eq((GroupCoordinator)Mockito.mock(GroupCoordinator.class));
        this.scheduler_$eq(new MockScheduler((Time)this.time()));
        this.mockAdminClient_$eq(new MockAdminClient(brokers, (Node)brokers.get(0)));
        this.consumerLagEmitter_$eq(this.createConsumerLagEmitter((Admin)this.mockAdminClient()));
    }

    @AfterEach
    public void close() {
        if (this.consumerLagEmitter() != null) {
            this.consumerLagEmitter().shutdown();
        }
        if (this.metrics() != null) {
            this.metrics().close();
        }
        if (this.mockAdminClient() != null) {
            this.mockAdminClient().close();
        }
    }

    @Test
    public void testConsumerLagMetrics() {
        String groupId2 = "lkc-xxxxx_group-2";
        TopicPartition topic2Partition0 = new TopicPartition("lkc-xxxxx_topic-2", 0);
        TopicPartition unprefixedTopic2Partition0 = new TopicPartition("topic-2", 0);
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)new .colon.colon((Object)new NewTopic("topic-1", 2, (short)1), (List)new .colon.colon((Object)new NewTopic("lkc-xxxxx_topic-2", 1, (short)1), (List)Nil$.MODULE$)));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        MemberSummary member0 = new MemberSummary("group-0:member-0", (Option)new Some((Object)"group.instance.0"), "client-0", "host-0", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$)));
        MemberSummary member1 = new MemberSummary("group-0:member-1", (Option)None$.MODULE$, "client-1", "host-1", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$)));
        MemberSummary member2 = new MemberSummary("group-1:member-0", (Option)new Some((Object)"group.instance.1"), "client-2", "host-2", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic1Partition0(), (List)Nil$.MODULE$)));
        MemberSummary member3 = new MemberSummary("group-1:member-1", (Option)None$.MODULE$, "client-3", "host-3", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)new .colon.colon((Object)this.topic1Partition1(), (List)Nil$.MODULE$)));
        MemberSummary member4 = new MemberSummary("lkc-xxxxx_group-2:member-0", (Option)None$.MODULE$, "client-4", "host-4", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)new .colon.colon((Object)unprefixedTopic2Partition0, (List)Nil$.MODULE$)));
        GroupSummary group0 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member0, (List)new .colon.colon((Object)member1, (List)Nil$.MODULE$)));
        GroupSummary group1 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member2, (List)new .colon.colon((Object)member3, (List)Nil$.MODULE$)));
        GroupSummary group2 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member4, (List)Nil$.MODULE$));
        .colon.colon topic0Partitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        .colon.colon topic1Partitions = new .colon.colon((Object)this.topic1Partition0(), (List)new .colon.colon((Object)this.topic1Partition1(), (List)Nil$.MODULE$));
        .colon.colon topic2Partitions = new .colon.colon((Object)topic2Partition0, (List)Nil$.MODULE$);
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)this.createGroupOverview(this.groupId0()), (List)new .colon.colon((Object)this.createGroupOverview(this.groupId1()), (List)new .colon.colon((Object)this.createGroupOverview(groupId2), (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group0));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId1())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group1));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(groupId2)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group2));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topic0Partitions, 10000L, 5000L)));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId1(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topic1Partitions, 15000L, 3500L)));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(groupId2, false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topic2Partitions, 6000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic0Partitions, 25000L, 4000L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic1Partitions, 35000L, 3000L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topic2Partitions, 35000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member0.groupInstanceId(), member0.memberId(), member0.clientId(), this.topic0Partition0()), 15000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member1.groupInstanceId(), member1.memberId(), member1.clientId(), this.topic0Partition1()), 14000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member2.groupInstanceId(), member2.memberId(), member2.clientId(), this.topic1Partition0()), 20000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member3.groupInstanceId(), member3.memberId(), member3.clientId(), this.topic1Partition1()), 19500L);
        this.verifyMemberMetric(new MemberTopicPartition(groupId2, member4.groupInstanceId(), member4.memberId(), member4.clientId(), topic2Partition0), 29000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)5L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)3));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testExpireGroups() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        MemberSummary member0 = new MemberSummary("group-0:member-0", (Option)None$.MODULE$, "client-0", "host-0", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        MemberSummary member1 = new MemberSummary("group-1:member-0", (Option)None$.MODULE$, "client-1", "host-1", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group0 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member0, (List)Nil$.MODULE$));
        GroupSummary group1 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member1, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.groupOverviews())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().apply(1)), (List)Nil$.MODULE$))).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)List$.MODULE$.empty()));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group0));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId1())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group1)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group1));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 10000L, this.createCurrentOffsets$default$3())));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId1(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 5000L, this.createCurrentOffsets$default$3()))).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member0.groupInstanceId(), member0.memberId(), member0.clientId(), this.topic0Partition0()), 15000L);
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member1.groupInstanceId(), member1.memberId(), member1.clientId(), this.topic0Partition0()), 20000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)2L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 35000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member1.groupInstanceId(), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
    }

    @Test
    public void testListGroupsHandlerErrorShouldSkipAll() {
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)List$.MODULE$.empty()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)0))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)0))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
    }

    @Test
    public void testListGroupsHandlerErrorShouldRetainGauges() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$))).thenReturn((Object)new Tuple2((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)List$.MODULE$.empty()));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
    }

    @Test
    public void testDescribeGroupHandlerErrorShouldSkipGroup() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        scala.collection.immutable.Map<TopicPartition, OffsetFetchResponse.PartitionData> currentOffsets = this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.groupOverviews()));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)GroupCoordinator$.MODULE$.EmptyGroup()));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId1())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testInvalidProtocolTypeShouldSkipGroup() {
        String invalidProtocolType = "invalid-protocol";
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        scala.collection.immutable.Map<TopicPartition, OffsetFetchResponse.PartitionData> currentOffsets = this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        GroupSummary invalidGroupSummary = new GroupSummary(ConsumerGroupState.STABLE.toString(), invalidProtocolType, "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.groupOverviews()));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)invalidGroupSummary));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId1())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testFetchOffsetsHandlerErrorShouldSkipGroup() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        scala.collection.immutable.Map<TopicPartition, OffsetFetchResponse.PartitionData> currentOffsets = this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.groupOverviews()));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup((String)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(((GroupOverview)this.groupOverviews().head()).groupId(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)scala.collection.immutable.Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(((GroupOverview)this.groupOverviews().apply(1)).groupId(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId1(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testOnlyFetchOffsetsForStableGroups() {
        String groupId2 = "group-2";
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        scala.collection.immutable.Map<TopicPartition, OffsetFetchResponse.PartitionData> currentOffsets = this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary stableGroup = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        GroupSummary rebalancingGroup = new GroupSummary(ConsumerGroupState.PREPARING_REBALANCE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        GroupSummary emptyGroup = new GroupSummary(ConsumerGroupState.EMPTY.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)new .colon.colon((Object)((GroupOverview)this.groupOverviews().apply(1)), (List)new .colon.colon((Object)this.createGroupOverview(groupId2), (List)Nil$.MODULE$)))));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)rebalancingGroup));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId1())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)emptyGroup));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(groupId2)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)stableGroup));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(groupId2, false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition("group-2", member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
    }

    @Test
    public void testDescribeGroupHandlerErrorShouldExpireGaugeWhenNotCoordinator() {
        this.handlerErrorShouldExpireGaugeWhenNotCoordinator(this.DescribeGroupHandler());
    }

    @Test
    public void testFetchOffsetsHandlerErrorShouldExpireGaugeWhenNotCoordinator() {
        this.handlerErrorShouldExpireGaugeWhenNotCoordinator(this.FetchOffsetsHandler());
    }

    public void handlerErrorShouldExpireGaugeWhenNotCoordinator(String handler) {
        if (!((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.DescribeGroupHandler(), this.FetchOffsetsHandler()}))).contains((Object)handler)) {
            Assertions.fail((String)new StringBuilder(16).append("unknown handler ").append(handler).toString());
        }
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$))).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$))).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        String string = handler;
        String string2 = this.DescribeGroupHandler();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group)).thenReturn((Object)new Tuple2((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)GroupCoordinator$.MODULE$.EmptyGroup())).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)GroupCoordinator$.MODULE$.EmptyGroup()));
            Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3())));
        } else {
            Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
            Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3()))).thenReturn((Object)new Tuple2((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)scala.collection.immutable.Map$.MODULE$.empty())).thenReturn((Object)new Tuple2((Object)Errors.NOT_COORDINATOR, (Object)scala.collection.immutable.Map$.MODULE$.empty()));
        }
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        Assertions.assertEquals((int)1, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        Assertions.assertEquals((int)0, (int)this.consumerLagEmitter().consumerLagMetrics().size());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleListGroups((Set)ArgumentMatchers.any());
        String string3 = handler;
        String string4 = this.DescribeGroupHandler();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
            return;
        }
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)3))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
    }

    @Test
    public void testExceptionInDeserializeAssignmentShouldSkipMember() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        scala.collection.immutable.Map<TopicPartition, OffsetFetchResponse.PartitionData> currentOffsets = this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3());
        MemberSummary member0 = new MemberSummary("group-0:member-0", (Option)None$.MODULE$, "client-0", "host-0", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 1}), ClassTag$.MODULE$.Byte()));
        MemberSummary member1 = new MemberSummary("group-0:member-1", (Option)None$.MODULE$, "client-1", "host-1", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        MemberSummary member2 = new MemberSummary("group-0:member-2", (Option)None$.MODULE$, "client-2", "host-2", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member0, (List)new .colon.colon((Object)member1, (List)new .colon.colon((Object)member2, (List)Nil$.MODULE$))));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member1.groupInstanceId(), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testFetchOffsetsHandlerPartitionErrorShouldSkipPartition() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        scala.collection.immutable.Map currentOffsets = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic0Partition0()), (Object)new OffsetFetchResponse.PartitionData(-1L, Optional.empty(), "", Errors.UNKNOWN_TOPIC_OR_PARTITION)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic0Partition1()), (Object)new OffsetFetchResponse.PartitionData(15000L, Optional.empty(), "", Errors.NONE))}));
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup((String)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)currentOffsets));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition1()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testListOffsetsPartitionErrorShouldSkipPartition() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 2, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)new .colon.colon((Object)this.topic0Partition1(), (List)Nil$.MODULE$));
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        java.util.Map failedTopicPartitions = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topic0Partition0()), (Object)Errors.LEADER_NOT_AVAILABLE.exception())}))).asJava();
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 15000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.mockAdminClient().updateOffsetsWithExceptions(failedTopicPartitions);
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition1()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testChangeInMembershipShouldUpdateGauge() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        MemberSummary member0 = new MemberSummary("group-0:member-0", (Option)None$.MODULE$, "client-0", "host-0", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        MemberSummary member1 = new MemberSummary("group-0:member-1", (Option)None$.MODULE$, "client-1", "host-1", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group0 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member0, (List)Nil$.MODULE$));
        GroupSummary group1 = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member1, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$))).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group0)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group1));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 5000L, this.createCurrentOffsets$default$3()))).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member0.groupInstanceId(), member0.memberId(), member0.clientId(), this.topic0Partition0()), 20000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 35000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member1.groupInstanceId(), member1.memberId(), member1.clientId(), this.topic0Partition0()), 10000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
    }

    @Test
    public void testRebalancingGroupShouldRetainGauge() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        MemberSummary member = new MemberSummary("group-0:member-0", (Option)None$.MODULE$, "client-0", "host-0", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        GroupSummary rebalancingGroup = new GroupSummary(ConsumerGroupState.PREPARING_REBALANCE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group)).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)rebalancingGroup));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any())).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 40000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 46000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 6000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.consumerLagEmitter().emitConsumerLag();
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 6000L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)1));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)2))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
    }

    @Test
    public void testNegativeConsumerLagShouldBeRecordedAsZero() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)topicPartitions, 30000L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMemberMetric(new MemberTopicPartition(this.groupId0(), member.groupInstanceId(), member.memberId(), member.clientId(), this.topic0Partition0()), 0L);
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)1L));
    }

    @Test
    public void testEmptyCurrentOffsetsShouldNotCountAsExpired() {
        .colon.colon topics = new .colon.colon((Object)new NewTopic("topic-0", 1, (short)1), (List)Nil$.MODULE$);
        .colon.colon topicPartitions = new .colon.colon((Object)this.topic0Partition0(), (List)Nil$.MODULE$);
        this.mockAdminClient().createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)topics).asJava());
        MemberSummary member = new MemberSummary("member", (Option)None$.MODULE$, "client", "host", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), this.createAssignment((List<TopicPartition>)topicPartitions));
        GroupSummary group = new GroupSummary(ConsumerGroupState.STABLE.toString(), this.protocolType(), "", (List)new .colon.colon((Object)member, (List)Nil$.MODULE$));
        Mockito.when((Object)this.groupCoordinator().handleListGroups((Set)ConsumerLagEmitter$.MODULE$.ValidStates())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)new .colon.colon((Object)((GroupOverview)this.groupOverviews().head()), (List)Nil$.MODULE$)));
        Mockito.when((Object)this.groupCoordinator().handleDescribeGroup(this.groupId0())).thenReturn((Object)new Tuple2((Object)Errors.NONE, (Object)group));
        Mockito.when((Object)this.groupCoordinator().handleFetchOffsets(this.groupId0(), false, (Option)None$.MODULE$)).thenReturn((Object)new Tuple2((Object)Errors.NONE, this.createCurrentOffsets((List<TopicPartition>)List$.MODULE$.empty(), 0L, this.createCurrentOffsets$default$3())));
        this.mockAdminClient().updateEndOffsets(this.createLatestOffsets((List<TopicPartition>)topicPartitions, 25000L, this.createLatestOffsets$default$3()));
        this.consumerLagEmitter().emitConsumerLag();
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleListGroups((Set)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleDescribeGroup((String)ArgumentMatchers.any());
        ((GroupCoordinator)Mockito.verify((Object)this.groupCoordinator(), (VerificationMode)Mockito.times((int)1))).handleFetchOffsets((String)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()), (Option)ArgumentMatchers.any());
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.MetricsSizeMetricName(), BoxesRunTime.boxToLong((long)0L));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.RebalancingGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.ExpiredGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.FailedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
        this.verifyMetricValue(ConsumerLagEmitter$.MODULE$.UpdatedGroupSizeMetricName(), BoxesRunTime.boxToInteger((int)0));
    }

    @Test
    public void testMemberTopicPartitionTags() {
        scala.collection.mutable.Map externalTags = new MemberTopicPartition("lkc-yyyyy_external-group", (Option)new Some((Object)"group-instance-0"), "member-0", "client-0", new TopicPartition("lkc-yyyyy_external-topic", 0)).tags();
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"external-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group-instance-id"), (Object)"group-instance-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)"member-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"external-topic"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), (Object)"lkc-yyyyy")}))), (Object)externalTags);
        scala.collection.mutable.Map internalTags = new MemberTopicPartition("internal-group", (Option)None$.MODULE$, "member-1", "client-1", new TopicPartition("__consumer_offsets", 50)).tags();
        Assertions.assertEquals((Object)((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer-group"), (Object)"internal-group"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"member"), (Object)"member-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"client-1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)"__consumer_offsets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)"50")}))), (Object)internalTags);
    }

    @Test
    public void testMaybePrefixTopicPartitionsWithTenantFunction() {
        .colon.colon unprefixedTopicPartitions = new .colon.colon((Object)new TopicPartition("test-topic", 0), (List)new .colon.colon((Object)new TopicPartition("test-topic", 1), (List)new .colon.colon((Object)new TopicPartition("test-topic", 2), (List)new .colon.colon((Object)new TopicPartition("test-topic", 3), (List)Nil$.MODULE$))));
        String externalGroup = "lkc-yyyyy_test-group";
        ((List)this.consumerLagEmitter().maybePrefixTopicPartitionsWithTenantFunction(externalGroup).apply((Object)unprefixedTopicPartitions)).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            ConsumerLagEmitterTest.$anonfun$testMaybePrefixTopicPartitionsWithTenantFunction$1(topicPartition);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyMemberMetric(MemberTopicPartition member, long expectedLag) {
        Option metric = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.metrics().metrics()).asScala()).get((Object)this.metrics().metricName(ConsumerLagEmitter$.MODULE$.ConsumerLagMetricName(), "tenant-metrics", (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(member.tags()).asJava()));
        Assertions.assertTrue((boolean)metric.isDefined());
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)expectedLag), (Object)((KafkaMetric)metric.get()).metricValue());
    }

    private <T> void verifyMetricValue(String metricName, T expectedValue) {
        Option metric = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.metrics().metrics()).asScala()).get((Object)this.metrics().metricName(metricName, ConsumerLagEmitter$.MODULE$.MetricGroupName()));
        Assertions.assertTrue((boolean)metric.isDefined());
        Assertions.assertEquals(expectedValue, (Object)((KafkaMetric)metric.get()).metricValue());
    }

    private GroupOverview createGroupOverview(String groupId) {
        return new GroupOverview(groupId, this.protocolType(), ConsumerGroupState.STABLE.toString());
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetFetchResponse.PartitionData> createCurrentOffsets(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return ((TraversableOnce)((List)topicPartitions.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new OffsetFetchResponse.PartitionData(baseOffset + (long)index * incrementingOffset, Optional.empty(), "", Errors.NONE));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private long createCurrentOffsets$default$3() {
        return 0L;
    }

    private java.util.Map<TopicPartition, Long> createLatestOffsets(List<TopicPartition> topicPartitions, long baseOffset, long incrementingOffset) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((List)topicPartitions.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)(baseOffset + (long)index * incrementingOffset));
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    private long createLatestOffsets$default$3() {
        return 0L;
    }

    private byte[] createAssignment(List<TopicPartition> topicPartitions) {
        return ConsumerProtocol.serializeAssignment((ConsumerPartitionAssignor.Assignment)new ConsumerPartitionAssignor.Assignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).array();
    }

    private ConsumerLagEmitter createConsumerLagEmitter(Admin admin) {
        return new ConsumerLagEmitter(this.metrics(), this.scheduler(), (Function1 & Serializable & scala.Serializable)states -> this.groupCoordinator().handleListGroups((Set)states), (Function1 & Serializable & scala.Serializable)groupId -> this.groupCoordinator().handleDescribeGroup(groupId), (Function1 & Serializable & scala.Serializable)groupId -> this.groupCoordinator().handleFetchOffsets(groupId, false, (Option)None$.MODULE$), 60000L, admin);
    }

    public static final /* synthetic */ void $anonfun$testMaybePrefixTopicPartitionsWithTenantFunction$1(TopicPartition topicPartition) {
        Assertions.assertEquals((Object)"lkc-yyyyy_test-topic", (Object)topicPartition.topic());
    }

    public ConsumerLagEmitterTest() {
        this.protocolType = "consumer";
        this.groupId0 = "group-0";
        this.groupId1 = "group-1";
        this.DescribeGroupHandler = "describeGroup";
        this.FetchOffsetsHandler = "fetchOffsets";
    }
}

