/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.metrics.BrokerLoad;
import kafka.metrics.BrokerLoad$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@Timeout(value=120000L)
@ScalaSignature(bytes="\u0006\u0001\t\u001df\u0001\u0002\u001b6\u0001iBQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005A\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0001S\u0011\u00191\u0006\u0001)A\u0005'\"Iq\u000b\u0001a\u0001\u0002\u0004%\t\u0001\u0017\u0005\n9\u0002\u0001\r\u00111A\u0005\u0002uC\u0011b\u0019\u0001A\u0002\u0003\u0005\u000b\u0015B-\t\u0013Y\u0002\u0001\u0019!a\u0001\n\u0003!\u0007\"C9\u0001\u0001\u0004\u0005\r\u0011\"\u0001s\u0011%!\b\u00011A\u0001B\u0003&Q\rC\u0004v\u0001\t\u0007I\u0011\u0001<\t\r}\u0004\u0001\u0015!\u0003x\u0011%\t\t\u0001\u0001b\u0001\n\u0003\t\u0019\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\u0003\u0011!\t9\u0002\u0001b\u0001\n\u00031\bbBA\r\u0001\u0001\u0006Ia\u001e\u0005\n\u00037\u0001!\u0019!C\u0001\u0003;A\u0001\"a\u000b\u0001A\u0003%\u0011q\u0004\u0005\n\u0003[\u0001!\u0019!C\u0001\u0003_A\u0001\"!\u0010\u0001A\u0003%\u0011\u0011\u0007\u0005\b\u0003\u007f\u0001A\u0011BA!\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!!\"\u0001\t\u0013\t9\tC\u0004\u00020\u0002!I!!-\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAc\u0001\u0011%\u0011q\u0019\u0005\n\u0003'\u0004\u0011\u0013!C\u0005\u0003+Dq!a;\u0001\t\u0003\ti\u000fC\u0004\u0003\u0006\u0001!\t!!<\t\u000f\t%\u0001\u0001\"\u0001\u0002n\"9!Q\u0002\u0001\u0005\u0002\u00055\bb\u0002B\t\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005+\u0001A\u0011AAw\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003[DqA!\b\u0001\t\u0013\u0011y\u0002C\u0005\u0003T\u0001\t\n\u0011\"\u0003\u0003V!9!Q\u0004\u0001\u0005\n\te\u0003b\u0002B3\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005S\u0002A\u0011AAw\u0011\u001d\u0011i\u0007\u0001C\u0001\u0003[DqA!\u001d\u0001\t\u0003\ti\u000fC\u0004\u0003v\u0001!\t!!<\t\u000f\te\u0004\u0001\"\u0001\u0002n\"9!Q\u0010\u0001\u0005\u0002\u00055\bb\u0002BA\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005\u000b\u0003A\u0011AAw\u0011\u001d\u0011I\t\u0001C\u0001\u0003[DqA!$\u0001\t\u0003\ti\u000fC\u0004\u0003\u0012\u0002!\t!!<\u0003\u001d\t\u0013xn[3s\u0019>\fG\rV3ti*\u0011agN\u0001\b[\u0016$(/[2t\u0015\u0005A\u0014!B6bM.\f7\u0001A\n\u0004\u0001m\n\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$AB!osJ+g\r\u0005\u0002C\u000b6\t1I\u0003\u0002Eo\u0005)Q\u000f^5mg&\u0011ai\u0011\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011\n\u0005\u0002K\u00015\tQ'\u0001\u0004o_\u0012,\u0017\nZ\u000b\u0002\u001bB\u0011AHT\u0005\u0003\u001fv\u00121!\u00138u\u0003\u001dqw\u000eZ3JI\u0002\nA\u0001^5nKV\t1\u000b\u0005\u0002C)&\u0011Qk\u0011\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Q!M]8lKJdu.\u00193\u0016\u0003e\u0003\"A\u0013.\n\u0005m+$A\u0003\"s_.,'\u000fT8bI\u0006q!M]8lKJdu.\u00193`I\u0015\fHC\u00010b!\tat,\u0003\u0002a{\t!QK\\5u\u0011\u001d\u0011w!!AA\u0002e\u000b1\u0001\u001f\u00132\u0003-\u0011'o\\6fe2{\u0017\r\u001a\u0011\u0016\u0003\u0015\u0004\"AZ8\u000e\u0003\u001dT!A\u000e5\u000b\u0005%T\u0017AB2p[6|gN\u0003\u00029W*\u0011A.\\\u0001\u0007CB\f7\r[3\u000b\u00039\f1a\u001c:h\u0013\t\u0001xMA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0003=NDqA\u0019\u0006\u0002\u0002\u0003\u0007Q-\u0001\u0005nKR\u0014\u0018nY:!\u0003a\u0019V\r\\3di>\u0014X*\u001a;sS\u000e\u001cxI\u001d9Qe\u00164\u0017\u000e_\u000b\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0005Y\u0006twMC\u0001}\u0003\u0011Q\u0017M^1\n\u0005yL(AB*ue&tw-A\rTK2,7\r^8s\u001b\u0016$(/[2t\u000fJ\u0004\bK]3gSb\u0004\u0013\u0001E:fGV\u0014\u0018\u000e^=Qe>$xnY8m+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t\u0005,H\u000f\u001b\u0006\u0004\u0003\u001fA\u0017\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005M\u0011\u0011\u0002\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\f\u0011c]3dkJLG/\u001f)s_R|7m\u001c7!\u0003]iW\u000f\u001c;j)\u0016t\u0017M\u001c;MSN$XM\\3s\u001d\u0006lW-\u0001\rnk2$\u0018\u000eV3oC:$H*[:uK:,'OT1nK\u0002\nA\u0002Z3gCVdG\u000f\u0015:paN,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n|\u0003\u0011)H/\u001b7\n\t\u0005%\u00121\u0005\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00043fM\u0006,H\u000e\u001e)s_B\u001c\b%A\u0007eK\u001a\fW\u000f\u001c;D_:4\u0017nZ\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o9\u0014AB:feZ,'/\u0003\u0003\u0002<\u0005U\"aC&bM.\f7i\u001c8gS\u001e\fa\u0002Z3gCVdGoQ8oM&<\u0007%A\u0007n_\u000e\\7+\u001a7fGR|'o\u001d\u000b\u0005\u0003\u0007\n9\u0007\u0005\u0004\u0002F\u0005U\u00131\f\b\u0005\u0003\u000f\n\tF\u0004\u0003\u0002J\u0005=SBAA&\u0015\r\ti%O\u0001\u0007yI|w\u000e\u001e \n\u0003yJ1!a\u0015>\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0016\u0002Z\t!A*[:u\u0015\r\t\u0019&\u0010\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r5\u0002\u000f9,Go^8sW&!\u0011QMA0\u0005!\u0019V\r\\3di>\u0014\b\"\u0002\u001c\u0017\u0001\u0004)\u0017\u0001E7pG.\\\u0015MZ6b\u0007\"\fgN\\3m)!\ti'a\u001d\u0002~\u0005\u0005\u0005\u0003BA/\u0003_JA!!\u001d\u0002`\ta1*\u00194lC\u000eC\u0017M\u001c8fY\"9\u0011QO\fA\u0002\u0005]\u0014\u0001\u0004:fO&\u001cH/\u001a:US6,\u0007c\u0001\u001f\u0002z%\u0019\u00111P\u001f\u0003\t1{gn\u001a\u0005\b\u0003\u007f:\u0002\u0019AA<\u00035A\u0017M\u001c3tQ\u0006\\W\rV5nK\"9\u00111Q\fA\u0002\u0005]\u0014AE1vi\",g\u000e^5dCRLwN\u001c+j[\u0016\fq#\\8dW6+H\u000e^5UK:\fg\u000e^'fi\u0006$\u0017\r^1\u0015\t\u0005%\u0015q\u0013\t\u0005\u0003\u0017\u000b\u0019*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003-iW\u000f\u001c;ji\u0016t\u0017M\u001c;\u000b\u0007\u0005]\".\u0003\u0003\u0002\u0016\u00065%aE'vYRLG+\u001a8b]RlU\r^1eCR\f\u0007bBAM1\u0001\u0007\u00111T\u0001\u0007Y.\u001c\u0017\nZ:\u0011\r\u0005u\u0015QUAV\u001d\u0011\ty*!)\u0011\u0007\u0005%S(C\u0002\u0002$v\na\u0001\u0015:fI\u00164\u0017\u0002BAT\u0003S\u00131aU3u\u0015\r\t\u0019+\u0010\t\u0005\u0003;\u000bi+C\u0002\u007f\u0003S\u000b\u0011B\\1o_N$v.T:\u0015\t\u0005M\u0016\u0011\u0018\t\u0004y\u0005U\u0016bAA\\{\t1Ai\\;cY\u0016Dq!a/\u001a\u0001\u0004\t9(A\u0003oC:|7/A\bsC:$w.\u001c+j[\u0016t\u0015M\\8t+\t\t9(A\u0006sC:$w.\u001c*bi&|WCAAZ\u0003i9\u0018-\u001b;B]\u0012<U\r\u001e\"s_.,'\u000fT8bI6+GO]5d)\u0011\tI-!5\u0011\t\u0005-\u0017QZ\u0007\u0002Q&\u0019\u0011q\u001a5\u0003\r5+GO]5d\u0011\u001d9F\u0004%AA\u0002e\u000bAe^1ji\u0006sGmR3u\u0005J|7.\u001a:M_\u0006$W*\u001a;sS\u000e$C-\u001a4bk2$H%M\u000b\u0003\u0003/T3!WAmW\t\tY\u000e\u0005\u0003\u0002^\u0006\u001dXBAAp\u0015\u0011\t\t/a9\u0002\u0013Ut7\r[3dW\u0016$'bAAs{\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0018q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007;fgR\u0014%o\\6fe2{\u0017\rZ'fiJL7mV3jO\"$8\u000fF\u0001_Q\rq\u0012\u0011\u001f\t\u0005\u0003g\u0014\t!\u0004\u0002\u0002v*!\u0011q_A}\u0003\r\t\u0007/\u001b\u0006\u0005\u0003w\fi0A\u0004kkBLG/\u001a:\u000b\u0007\u0005}X.A\u0003kk:LG/\u0003\u0003\u0003\u0004\u0005U(\u0001\u0002+fgR\fQ\u0003^3ti:{Go\u0015;beRLgnZ'fiJL7\rK\u0002 \u0003c\f!\u0005^3ti^\u0013\u0018\r]!s_VtGMU3d_J$WM\u001d*fcV,7\u000f^:P]2L\bf\u0001\u0011\u0002r\u0006qC/Z:u/J\f\u0007/\u0011:pk:$'+Z2pe\u0012,'oQ8o]\u0016\u001cG/[8o\u0011\u0006tGm\u001d5bW\u0016\u001cxJ\u001c7zQ\r\t\u0013\u0011_\u00014i\u0016\u001cHo\u0016:ba\u0006\u0013x.\u001e8e%\u0016\u001cwN\u001d3fe\u000e{gN\\3di&|g.Q;uQ\u0016tG/[2bi&|gn](oYfD3AIAy\u0003\u0005\"Xm\u001d;Xe\u0006\u0004\u0018I]8v]\u0012\u0014VmY8sI\u0016\u0014H\u000b\u001b:fC\u0012\u001cxJ\u001c7zQ\r\u0019\u0013\u0011_\u0001\u001bi\u0016\u001cH/\u00138de\u0016lWM\u001c;bY2{\u0017\rZ!wKJ\fw-\u001a\u0015\u0004I\u0005E\u0018a\u0007;fgR<\u0016\u000e\u001e5TC6\u0004H.Z:ESN$(/\u001b2vi&|g\u000eF\u0004_\u0005C\u0011)Ea\u0014\t\u000f\t\rR\u00051\u0001\u0003&\u00051QM^3oiN\u0004bAa\n\u00032\tURB\u0001B\u0015\u0015\u0011\u0011YC!\f\u0002\u000f5,H/\u00192mK*\u0019!qF\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00034\t%\"A\u0003'jgR\u0014UO\u001a4feB9AHa\u000e\u00024\nm\u0012b\u0001B\u001d{\t1A+\u001e9mKJ\u0002BA!\u0010\u0003B5\u0011!q\b\u0006\u0003#nLAAa\u0011\u0003@\tAA)\u001e:bi&|g\u000eC\u0004\u0003H\u0015\u0002\rA!\u0013\u0002\u0013\u0005\u001c8/\u001a:uS>t\u0007\u0003\u0003\u001f\u0003L\u0005M\u00161\u00170\n\u0007\t5SHA\u0005Gk:\u001cG/[8oe!I!\u0011K\u0013\u0011\u0002\u0003\u0007\u0011\u0011G\u0001\u0007G>tg-[4\u0002KQ,7\u000f^,ji\"\u001c\u0016-\u001c9mKN$\u0015n\u001d;sS\n,H/[8oI\u0011,g-Y;mi\u0012\u001aTC\u0001B,U\u0011\t\t$!7\u0015\u0013y\u0013YF!\u0018\u0003b\t\r\u0004\"B,(\u0001\u0004I\u0006b\u0002B0O\u0001\u0007\u00111I\u0001\ng\u0016dWm\u0019;peNDqAa\t(\u0001\u0004\u0011)\u0003C\u0004\u0003H\u001d\u0002\rA!\u0013\u0002%Q,7\u000f^%eY\u0016\u0014%o\\6fe2{\u0017\r\u001a\u0015\u0004Q\u0005E\u0018!\u0006;fgR\u001c\u0016N\\4mKJ+\u0017/^3ti2{\u0017\r\u001a\u0015\u0004S\u0005E\u0018a\u0006;fgRlU\u000f\u001c;ja2,'+Z9vKN$Hj\\1eQ\rQ\u0013\u0011_\u0001\u001di\u0016\u001cHoU5oO2,'+Z9vKN$H+[7f\u0003Z,'/Y4fQ\rY\u0013\u0011_\u00011i\u0016\u001cH/T;mi&\u0004H.\u001a*fcV,7\u000f\u001e+j[\u0016\fe/\u001a:bO\u0016<\u0016\u000e\u001e5j]N\u000bW\u000e\u001d7f!\u0016\u0014\u0018n\u001c3)\u00071\n\t0A\u000fuKN$H)\u001f8b[&\u001c7+\u001a:wS\u000e,'+Z9vKN$H+[7fQ\ri\u0013\u0011_\u0001 i\u0016\u001cH\u000fR=oC6L7mV8sW2|\u0017\rZ\"pK\u001a4\u0017nY5f]R\u001c\bf\u0001\u0018\u0002r\u0006YB/Z:u\u001bVdG/\u001b9mKN\u000bW\u000e\u001d7j]\u001e\u0004VM]5pIND3aLAy\u0003a!Xm\u001d;Nk2$\u0018\u000e\u001d7f'\u0006l\u0007\u000f\\3D_VtGo\u001d\u0015\u0004a\u0005E\u0018a\u0005;fgR\u0014%o\\6fe2{\u0017\rZ\"m_N,\u0007fA\u0019\u0002r\u0006IB/Z:u\u0005J|7.\u001a:M_\u0006$\u0017\nZ3na>$XM\\2zQ\r\u0011\u0014\u0011_\u0001\ti\u0016\f'\u000fR8x]\"\u001a1G!&\u0011\t\u0005M(qS\u0005\u0005\u00053\u000b)PA\u0005BMR,'/R1dQ\":\u0001A!(\u0003$\n\u0015\u0006\u0003BAz\u0005?KAA!)\u0002v\n9A+[7f_V$\u0018!\u0002<bYV,gdA\u0001U\u0002\u0004")
public class BrokerLoadTest
implements Logging {
    private final int nodeId;
    private final MockTime time;
    private BrokerLoad brokerLoad;
    private Metrics metrics;
    private final String SelectorMetricsGrpPrefix;
    private final SecurityProtocol securityProtocol;
    private final String multiTenantListenerName;
    private final Properties defaultProps;
    private final KafkaConfig defaultConfig;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int nodeId() {
        return this.nodeId;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerLoad brokerLoad() {
        return this.brokerLoad;
    }

    public void brokerLoad_$eq(BrokerLoad x$1) {
        this.brokerLoad = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public String SelectorMetricsGrpPrefix() {
        return this.SelectorMetricsGrpPrefix;
    }

    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public String multiTenantListenerName() {
        return this.multiTenantListenerName;
    }

    public Properties defaultProps() {
        return this.defaultProps;
    }

    public KafkaConfig defaultConfig() {
        return this.defaultConfig;
    }

    private List<Selector> mockSelectors(Metrics metrics) {
        ChannelBuilder channelBuilderMock = (ChannelBuilder)Mockito.mock(ChannelBuilder.class);
        LogContext logContextMock = (LogContext)Mockito.mock(LogContext.class);
        Logger loggerMock = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logContextMock.logger(Selector.class)).thenReturn((Object)loggerMock);
        Selector selector = new Selector(0L, metrics, (Time)this.time(), this.SelectorMetricsGrpPrefix(), channelBuilderMock, logContextMock);
        return new .colon.colon((Object)selector, (List)Nil$.MODULE$);
    }

    private KafkaChannel mockKafkaChannel(long registerTime, long handshakeTime, long authenticationTime) {
        KafkaChannel channel = (KafkaChannel)Mockito.mock(KafkaChannel.class);
        KafkaChannel.KafkaChannelMetrics channelMetrics = (KafkaChannel.KafkaChannelMetrics)Mockito.mock(KafkaChannel.KafkaChannelMetrics.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.transportHandshakeTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)handshakeTime));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.authenticationTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)authenticationTime));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)channelMetrics.computeConnectionLocalServiceTimeNanos())).thenReturn((Object)BoxesRunTime.boxToLong((long)(registerTime + handshakeTime + authenticationTime)));
        Mockito.when((Object)channel.metrics()).thenReturn((Object)channelMetrics);
        return channel;
    }

    /*
     * WARNING - void declaration
     */
    private MultiTenantMetadata mockMultiTenantMetadata(Set<String> lkcIds) {
        void var2_2;
        MultiTenantMetadata metadata = (MultiTenantMetadata)Mockito.mock(MultiTenantMetadata.class);
        Mockito.when((Object)metadata.kafkaLogicalClusterIds()).thenReturn(CollectionConverters$.MODULE$.setAsJavaSetConverter(lkcIds).asJava());
        return var2_2;
    }

    private double nanosToMs(long nanos) {
        long positiveNanos = package$.MODULE$.max(nanos, 0L);
        return (double)TimeUnit.NANOSECONDS.toMicros(positiveNanos) / (double)TimeUnit.MILLISECONDS.toMicros(1L);
    }

    private long randomTimeNanos() {
        Random$.MODULE$.setSeed(System.nanoTime());
        return Duration.ofMillis(1L).toNanos() + (long)Random$.MODULE$.nextInt((int)1000000.0);
    }

    private double randomRatio() {
        Random$.MODULE$.setSeed(System.nanoTime());
        return 0.0 + 1.0 * Random$.MODULE$.nextDouble();
    }

    /*
     * WARNING - void declaration
     */
    private Metric waitAndGetBrokerLoadMetric(BrokerLoad brokerLoad) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerLoadTest.$anonfun$waitAndGetBrokerLoadMetric$1(brokerLoad)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BrokerLoadTest.$anonfun$waitAndGetBrokerLoadMetric$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (Metric)brokerLoad.brokerLoadPercentMetric("").get();
    }

    private BrokerLoad waitAndGetBrokerLoadMetric$default$1() {
        return this.brokerLoad();
    }

    @Test
    public void testBrokerLoadMetricWeights() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), KafkaConfig$.MODULE$.fromProps(this.defaultProps()), BrokerLoad$.MODULE$.apply$default$3()));
        this.brokerLoad().startMetric();
        BrokerLoad.BrokerLoadGauge brokerLoadGauge = this.brokerLoad().newBrokerLoadGauge();
        double middle = (this.brokerLoad().brokerLoadConfig().weightsUpperBound() + this.brokerLoad().brokerLoadConfig().weightsLowerBound()) / (double)2;
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(1.0, 0.0), (Object)brokerLoadGauge.weights(0.0));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(1.0, 0.0), (Object)brokerLoadGauge.weights(this.brokerLoad().brokerLoadConfig().weightsLowerBound()));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(0.5, 0.5), (Object)brokerLoadGauge.weights(middle));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(0.0, 1.0), (Object)brokerLoadGauge.weights(this.brokerLoad().brokerLoadConfig().weightsUpperBound()));
        Assertions.assertEquals((Object)new Tuple2.mcDD.sp(0.0, 1.0), (Object)brokerLoadGauge.weights(1.0));
    }

    @Test
    public void testNotStartingMetric() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), KafkaConfig$.MODULE$.fromProps(this.defaultProps()), BrokerLoad$.MODULE$.apply$default$3()));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testNotStartingMetric$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), 0.0, this.time().milliseconds());
        this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, 0.0, this.time().milliseconds());
        this.brokerLoad().recordRequestThreadsIdleRatio(0.0);
        this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), this.randomTimeNanos());
        this.brokerLoad().close();
    }

    @Test
    public void testWrapAroundRecorderRequestsOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)metadata)));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderRequestsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), 0.0, this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, 0.0, this.time().milliseconds());
            this.brokerLoad().recordRequestThreadsIdleRatio(0.0);
            this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), this.randomTimeNanos());
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testWrapAroundRecorderConnectionHandshakesOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)metadata)));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderConnectionHandshakesOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), 0.0, this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, 0.0, this.time().milliseconds());
            this.brokerLoad().recordRequestThreadsIdleRatio(0.0);
            KafkaChannel channel = this.mockKafkaChannel(0L, this.randomTimeNanos(), 0L);
            this.brokerLoad().notifyOnConnection(channel);
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testWrapAroundRecorderConnectionAuthenticationsOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)metadata)));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderConnectionAuthenticationsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        double prevLoad = 0.0;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), 0.0, this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, 0.0, this.time().milliseconds());
            this.brokerLoad().recordRequestThreadsIdleRatio(0.0);
            KafkaChannel channel = this.mockKafkaChannel(0L, 0L, this.randomTimeNanos());
            this.brokerLoad().notifyOnConnection(channel);
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testWrapAroundRecorderThreadsOnly() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)metadata)));
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWrapAroundRecorderThreadsOnly$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        double prevLoad = 0.0;
        double idleRatio = 0.99;
        for (double i = 0.0; i < (double)10000; i += 1.0) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), idleRatio, this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, idleRatio, this.time().milliseconds());
            this.brokerLoad().recordRequestThreadsIdleRatio(idleRatio);
            double currLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis() / 10L);
            if (i > 0.0 && i % 10.0 == 0.0) {
                Assertions.assertNotEquals((double)0.0, (double)currLoad, (double)0.0);
                Predef$.MODULE$.assert(prevLoad != currLoad);
                idleRatio -= 1.0E-4;
            } else {
                Predef$.MODULE$.assert(prevLoad == currLoad);
            }
            prevLoad = currLoad;
        }
    }

    @Test
    public void testIncrementalLoadAverage() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", "10");
        props.put("confluent.broker.load.window.size.ms", "6000");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)metadata)));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testIncrementalLoadAverage$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        double prevLoad = 0.0;
        long timeMs = 1L;
        this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), this.randomRatio(), this.time().milliseconds());
        this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, this.randomRatio(), this.time().milliseconds());
        this.brokerLoad().recordRequestThreadsIdleRatio(this.randomRatio());
        this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), Duration.ofMillis(2L).toNanos());
        this.time().sleep(config.brokerLoadWindowSizeMs().toMillis());
        for (int maxRequests = 50000; maxRequests > 0; --maxRequests) {
            this.brokerLoad().notifyOnThreadUsage(this.multiTenantListenerName(), this.randomRatio(), this.time().milliseconds());
            this.brokerLoad().notifyOnThreadUsage(this.securityProtocol().name, this.randomRatio(), this.time().milliseconds());
            this.brokerLoad().recordRequestThreadsIdleRatio(this.randomRatio());
            this.brokerLoad().recordRequestTimeNanos((Selector)selectors.head(), Duration.ofMillis(timeMs).toNanos());
            this.time().sleep(config.brokerLoadWindowSizeMs().toMillis());
            ++timeMs;
            double curLoad = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
            Predef$.MODULE$.assert(curLoad != prevLoad);
            prevLoad = curLoad;
        }
    }

    private void testWithSamplesDistribution(ListBuffer<Tuple2<Object, Duration>> events, Function2<Object, Object, BoxedUnit> assertion, KafkaConfig config) {
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)metadata)));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        assertion.apply$mcVDD$sp(testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
    }

    private void testWithSamplesDistribution(BrokerLoad brokerLoad, List<Selector> selectors, ListBuffer<Tuple2<Object, Duration>> events, Function2<Object, Object, BoxedUnit> assertion) {
        Metric brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double brokerLoadValue = BoxesRunTime.unboxToDouble((Object)brokerLoadMetric.metricValue());
        Assertions.assertTrue((brokerLoadValue >= 0.0 && brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option optionalServiceTimeMetric = brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)optionalServiceTimeMetric.isDefined());
        double averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        assertion.apply$mcVDD$sp(averageTotalServiceLocalTimeValue, brokerLoadValue);
    }

    private KafkaConfig testWithSamplesDistribution$default$3() {
        return this.defaultConfig();
    }

    @Test
    public void testIdleBrokerLoad() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3600).foreach((Function1 & Serializable & scala.Serializable)_ -> samples.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)Duration.ofSeconds(1L))));
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)BrokerLoadTest.assertion$1(), this.testWithSamplesDistribution$default$3());
    }

    @Test
    public void testSingleRequestLoad() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs())), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config, (Option)new Some((Object)testWithSamplesDistribution_metadata)));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue == 0.0);
        samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) * (double)5)), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config2 = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config2, (Option)new Some((Object)testWithSamplesDistribution_metadata2)));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) / (double)5)), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig testWithSamplesDistribution_config3 = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config3, (Option)new Some((Object)testWithSamplesDistribution_metadata3)));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 == 0.0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleRequestLoad() {
        void testWithSamplesDistribution_config;
        void testWithSamplesDistribution_config2;
        void testWithSamplesDistribution_config3;
        void testWithSamplesDistribution_config4;
        ObjectRef samples = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)Duration.ZERO)}))));
        KafkaConfig kafkaConfig = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config4, (Option)new Some((Object)testWithSamplesDistribution_metadata)));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue > 0.0);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig kafkaConfig2 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events2 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config3, (Option)new Some((Object)testWithSamplesDistribution_metadata2)));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 > 0.0);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.defaultConfig().brokerLoadNumSamples()) - 1).foreach((Function1 & Serializable & scala.Serializable)i -> BrokerLoadTest.$anonfun$testMultipleRequestLoad$3(this, samples, BoxesRunTime.unboxToInt((Object)i)));
        DoubleRef prevLoad = DoubleRef.create((double)0.0);
        KafkaConfig kafkaConfig3 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events3 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config2, (Option)new Some((Object)testWithSamplesDistribution_metadata3)));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events3.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestLoad$4(prevLoad, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3);
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(Predef$.MODULE$.Integer2int(this.defaultConfig().brokerLoadNumSamples()) + 1)), (Object)this.defaultConfig().brokerLoadWindowSizeMs()));
        KafkaConfig kafkaConfig4 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events4 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata4 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config, (Option)new Some((Object)testWithSamplesDistribution_metadata4)));
        List<Selector> testWithSamplesDistribution_selectors4 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors4.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events4.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestLoad$5(prevLoad, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4);
    }

    @Test
    public void testSingleRequestTimeAverage() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)this.assertion$2(samples), this.testWithSamplesDistribution$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleRequestTimeAverageWithinSamplePeriod() {
        void testWithSamplesDistribution_config;
        void testWithSamplesDistribution_config2;
        ObjectRef samples = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}))));
        KafkaConfig kafkaConfig = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config2, (Option)new Some((Object)testWithSamplesDistribution_metadata)));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$1(this, samples, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        KafkaConfig kafkaConfig2 = this.testWithSamplesDistribution$default$3();
        ListBuffer testWithSamplesDistribution_events2 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), (KafkaConfig)testWithSamplesDistribution_config, (Option)new Some((Object)testWithSamplesDistribution_metadata2)));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events2.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$2(this, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", Integer.toString(10));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        samples.elem = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)config.brokerLoadWindowSizeMs())}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(config.brokerLoadNumSamples()) - 2).foreach((Function1 & Serializable & scala.Serializable)_ -> BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$3(samples, config, BoxesRunTime.unboxToInt((Object)_)));
        ListBuffer testWithSamplesDistribution_events3 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)testWithSamplesDistribution_metadata3)));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events3.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        Predef$.MODULE$.assert(this.nanosToMs((long)testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) < 1.0, (Function0 & Serializable & scala.Serializable)() -> "Avg request time should be less than 1.0");
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config.brokerLoadWindowSizeMs()));
        ((ListBuffer)samples.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config.brokerLoadWindowSizeMs()));
        ListBuffer testWithSamplesDistribution_events4 = (ListBuffer)samples.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata4 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), config, (Option)new Some((Object)testWithSamplesDistribution_metadata4)));
        List<Selector> testWithSamplesDistribution_selectors4 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors4.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        testWithSamplesDistribution_events4.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric4.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad4.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric4.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$6(this, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue4, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue4);
    }

    @Test
    public void testDynamicServiceRequestTime() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), this.defaultConfig(), (Option)new Some((Object)metadata)));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}));
        DoubleRef defaultLoad = DoubleRef.create((double)0.0);
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$2(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
        Properties props = this.defaultProps();
        double newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) * (double)5;
        props.put("confluent.broker.load.average.service.request.time.ms", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$3(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_brokerLoadValue2);
        newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadAverageServiceRequestTimeMs()) / (double)5;
        props.put("confluent.broker.load.average.service.request.time.ms", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicServiceRequestTime$4(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testDynamicWorkloadCoefficients() {
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), this.defaultConfig(), (Option)new Some((Object)metadata)));
        List<Selector> selectors = this.mockSelectors(this.metrics());
        selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(2L))}));
        DoubleRef defaultLoad = DoubleRef.create((double)0.0);
        BrokerLoad testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$2(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_brokerLoadValue);
        Properties props = this.defaultProps();
        double newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadWorkloadCoefficient()) * (double)5;
        props.put("confluent.broker.load.workload.coefficient", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$3(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_brokerLoadValue2);
        newCoefficient = Predef$.MODULE$.Double2double(this.defaultConfig().brokerLoadWorkloadCoefficient()) / (double)5;
        props.put("confluent.broker.load.workload.coefficient", Double.toString(newCoefficient));
        this.brokerLoad().updateConfig(KafkaConfig$.MODULE$.fromProps(props));
        BrokerLoad testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testDynamicWorkloadCoefficients$4(defaultLoad, testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testMultipleSamplingPeriods() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs().multipliedBy(5L)), new Tuple2((Object)BoxesRunTime.boxToDouble((double)0.5), (Object)this.defaultConfig().brokerLoadWindowSizeMs()), new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.defaultConfig().brokerLoadWindowSizeMs())}));
        DoubleRef load = DoubleRef.create((double)0.0);
        KafkaConfig testWithSamplesDistribution_config = this.testWithSamplesDistribution$default$3();
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config, (Option)new Some((Object)testWithSamplesDistribution_metadata)));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSamplingPeriods$1(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue);
        Properties props = this.defaultProps();
        long newSamplingPeriod = this.defaultConfig().brokerLoadWindowSizeMs().multipliedBy(5L).toMillis();
        props.put("confluent.broker.load.window.size.ms", Long.toString(newSamplingPeriod));
        KafkaConfig testWithSamplesDistribution_config2 = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config2, (Option)new Some((Object)testWithSamplesDistribution_metadata2)));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSamplingPeriods$2(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        newSamplingPeriod = this.defaultConfig().brokerLoadWindowSizeMs().dividedBy(5L).toMillis();
        props.put("confluent.broker.load.window.size.ms", Long.toString(newSamplingPeriod));
        KafkaConfig testWithSamplesDistribution_config3 = KafkaConfig$.MODULE$.fromProps(props);
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config3, (Option)new Some((Object)testWithSamplesDistribution_metadata3)));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSamplingPeriods$3(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testMultipleSampleCounts() {
        Properties props = this.defaultProps();
        props.put("confluent.broker.load.num.samples", Integer.toString(10));
        ObjectRef config = ObjectRef.create((Object)KafkaConfig$.MODULE$.fromProps(props));
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) * 2).foreach((Function1 & Serializable & scala.Serializable)i -> samples.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)i)), (Object)((KafkaConfig)config.elem).brokerLoadWindowSizeMs())));
        DoubleRef load = DoubleRef.create((double)0.0);
        KafkaConfig testWithSamplesDistribution_config = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config, (Option)new Some((Object)testWithSamplesDistribution_metadata)));
        List<Selector> testWithSamplesDistribution_selectors = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSampleCounts$2(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue);
        long newSampleSize = Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) * 2;
        props.put("confluent.broker.load.num.samples", Long.toString(newSampleSize));
        config.elem = KafkaConfig$.MODULE$.fromProps(props);
        KafkaConfig testWithSamplesDistribution_config2 = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata2 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config2, (Option)new Some((Object)testWithSamplesDistribution_metadata2)));
        List<Selector> testWithSamplesDistribution_selectors2 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors2.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric2.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad2.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric2.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSampleCounts$3(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue2, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue2);
        newSampleSize = Predef$.MODULE$.Integer2int(((KafkaConfig)config.elem).brokerLoadNumSamples()) / 4;
        props.put("confluent.broker.load.num.samples", Long.toString(newSampleSize));
        config.elem = KafkaConfig$.MODULE$.fromProps(props);
        KafkaConfig testWithSamplesDistribution_config3 = (KafkaConfig)config.elem;
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata testWithSamplesDistribution_metadata3 = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        this.brokerLoad_$eq(BrokerLoad$.MODULE$.apply(this.metrics(), testWithSamplesDistribution_config3, (Option)new Some((Object)testWithSamplesDistribution_metadata3)));
        List<Selector> testWithSamplesDistribution_selectors3 = this.mockSelectors(this.metrics());
        testWithSamplesDistribution_selectors3.foreach((Function1 & Serializable & scala.Serializable)selector -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$1(this, selector);
            return BoxedUnit.UNIT;
        });
        this.brokerLoad().startMetric();
        BrokerLoad testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3 = this.brokerLoad();
        Metric testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3 = this.waitAndGetBrokerLoadMetric(this.waitAndGetBrokerLoadMetric$default$1());
        samples.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BrokerLoadTest.$anonfun$testWithSamplesDistribution$3(this, testWithSamplesDistribution_brokerLoad, selectors, x$1);
            return BoxedUnit.UNIT;
        });
        double testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 = BoxesRunTime.unboxToDouble((Object)testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadMetric3.metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 >= 0.0 && testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3 <= 1.0 ? 1 : 0) != 0);
        Option testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3 = testWithSamplesDistribution_testWithSamplesDistribution_brokerLoad3.weightedAverageTotalServiceLocalTimeMetric();
        Assertions.assertTrue((boolean)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.isDefined());
        double testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 = BoxesRunTime.unboxToDouble((Object)((Metric)testWithSamplesDistribution_testWithSamplesDistribution_optionalServiceTimeMetric3.get()).metricValue());
        Assertions.assertTrue((testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3 >= 0.0 || Double.isNaN(testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3) ? 1 : 0) != 0);
        BrokerLoadTest.$anonfun$testMultipleSampleCounts$4(load, testWithSamplesDistribution_testWithSamplesDistribution_averageTotalServiceLocalTimeValue3, testWithSamplesDistribution_testWithSamplesDistribution_brokerLoadValue3);
    }

    @Test
    public void testBrokerLoadClose() {
        ListBuffer samples = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3600).foreach((Function1 & Serializable & scala.Serializable)i -> samples.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToInt((Object)i)), (Object)this.defaultConfig().brokerLoadWindowSizeMs())));
        DoubleRef lastLoad = DoubleRef.create((double)0.0);
        DoubleRef lastServiceLocalTime = DoubleRef.create((double)0.0);
        this.testWithSamplesDistribution((ListBuffer<Tuple2<Object, Duration>>)samples, (Function2<Object, Object, BoxedUnit>)BrokerLoadTest.assertion$3(lastLoad, lastServiceLocalTime), this.testWithSamplesDistribution$default$3());
        this.brokerLoad().close();
        Assertions.assertFalse((boolean)this.brokerLoad().untaggedBrokerLoadPercentMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().brokerLoadPercentMetric("").isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageTotalServiceLocalTimeMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageExternalNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageReplicationNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertFalse((boolean)this.brokerLoad().weightedAverageRequestHandlerThreadIdleRatioMetric().isDefined());
    }

    @Test
    public void testBrokerLoadIdempotency() {
        int requiredInstanceCount = 100;
        ConcurrentLinkedQueue brokerLoadInstances = new ConcurrentLinkedQueue();
        ConcurrentLinkedQueue taskStatus = new ConcurrentLinkedQueue();
        ObjectRef executor = ObjectRef.create((Object)Executors.newSingleThreadExecutor());
        this.metrics_$eq(new Metrics((Time)this.time()));
        MultiTenantMetadata metadata = this.mockMultiTenantMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), requiredInstanceCount).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)_ -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$2(this, metadata, brokerLoadInstances)))));
        Duration waitTimeout = Duration.ofSeconds(10L);
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        ((ExecutorService)executor.elem).shutdown();
        executor.elem = Executors.newFixedThreadPool(10);
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$5(this, brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        DoubleRef firstUntaggedBrokerLoadPercent = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).untaggedBrokerLoadPercentMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadPercent = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).brokerLoadPercentMetric("").get()).metricValue()));
        DoubleRef firstBrokerLoadServiceTime = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadExternalThreadsIdle = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadReplicationThreadsIdle = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue()));
        DoubleRef firstBrokerLoadRequestThreadsIdle = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue()));
        brokerLoadInstances.forEach(brokerLoad -> {
            double untaggedLoad = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.untaggedBrokerLoadPercentMetric().get()).metricValue());
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadPercentMetric("").get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            double requestThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstUntaggedBrokerLoadPercent$1.elem, (double)untaggedLoad);
            Assertions.assertEquals((double)firstBrokerLoadPercent$1.elem, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime$1.elem, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle$1.elem, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle$1.elem, (double)replicationThreadsIdle);
            Assertions.assertEquals((double)firstBrokerLoadRequestThreadsIdle$1.elem, (double)requestThreadsIdle);
        });
        Selector mockSelector = (Selector)this.mockSelectors(this.metrics()).head();
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$9(this, brokerLoad, mockSelector)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        firstUntaggedBrokerLoadPercent.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).untaggedBrokerLoadPercentMetric().get()).metricValue());
        firstBrokerLoadPercent.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).brokerLoadPercentMetric("").get()).metricValue());
        firstBrokerLoadServiceTime.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
        firstBrokerLoadExternalThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadReplicationThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadRequestThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
        brokerLoadInstances.forEach(brokerLoad -> {
            double untaggedLoad = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.untaggedBrokerLoadPercentMetric().get()).metricValue());
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadPercentMetric("").get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            double requestThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstUntaggedBrokerLoadPercent$1.elem, (double)untaggedLoad);
            Assertions.assertEquals((double)firstBrokerLoadPercent$1.elem, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime$1.elem, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle$1.elem, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle$1.elem, (double)replicationThreadsIdle);
            Assertions.assertEquals((double)firstBrokerLoadRequestThreadsIdle$1.elem, (double)requestThreadsIdle);
        });
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$13(this, brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        firstUntaggedBrokerLoadPercent.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).untaggedBrokerLoadPercentMetric().get()).metricValue());
        firstBrokerLoadPercent.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).brokerLoadPercentMetric("").get()).metricValue());
        firstBrokerLoadServiceTime.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
        firstBrokerLoadExternalThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadReplicationThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
        firstBrokerLoadRequestThreadsIdle.elem = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
        brokerLoadInstances.forEach(brokerLoad -> {
            double untaggedLoad = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.untaggedBrokerLoadPercentMetric().get()).metricValue());
            double load = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.brokerLoadPercentMetric("").get()).metricValue());
            double serviceTime = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().get()).metricValue());
            double externalThreadIdle = BoxesRunTime.unboxToDouble((Object)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue());
            double replicationThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue());
            double requestThreadsIdle = BoxesRunTime.unboxToDouble((Object)((Metric)((BrokerLoad)brokerLoadInstances.peek()).weightedAverageRequestHandlerThreadIdleRatioMetric().get()).metricValue());
            Assertions.assertEquals((double)firstUntaggedBrokerLoadPercent$1.elem, (double)untaggedLoad);
            Assertions.assertEquals((double)firstBrokerLoadPercent$1.elem, (double)load);
            Assertions.assertEquals((double)firstBrokerLoadServiceTime$1.elem, (double)serviceTime);
            Assertions.assertEquals((double)firstBrokerLoadExternalThreadsIdle$1.elem, (double)externalThreadIdle);
            Assertions.assertEquals((double)firstBrokerLoadReplicationThreadsIdle$1.elem, (double)replicationThreadsIdle);
            Assertions.assertEquals((double)firstBrokerLoadRequestThreadsIdle$1.elem, (double)requestThreadsIdle);
        });
        brokerLoadInstances.forEach(brokerLoad -> taskStatus.add(((ExecutorService)executor$1.elem).submit(() -> BoxesRunTime.boxToBoolean((boolean)BrokerLoadTest.$anonfun$testBrokerLoadIdempotency$17(brokerLoad)))));
        taskStatus.forEach(task -> Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean(task.get(waitTimeout.toMillis(), TimeUnit.MILLISECONDS))));
        taskStatus.clear();
        ((ExecutorService)executor.elem).shutdown();
    }

    @AfterEach
    public void tearDown() {
        if (this.brokerLoad() != null) {
            this.brokerLoad().close();
        }
        if (this.metrics() != null) {
            this.metrics().close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitAndGetBrokerLoadMetric$1(BrokerLoad brokerLoad$1) {
        return brokerLoad$1.brokerLoadPercentMetric("").isDefined();
    }

    public static final /* synthetic */ String $anonfun$waitAndGetBrokerLoadMetric$2() {
        return "Timed out waiting for broker load metric to populate";
    }

    public static final /* synthetic */ void $anonfun$testNotStartingMetric$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderRequestsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderConnectionHandshakesOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderConnectionAuthenticationsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWrapAroundRecorderThreadsOnly$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalLoadAverage$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWithSamplesDistribution$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testWithSamplesDistribution$3(BrokerLoadTest $this, BrokerLoad brokerLoad$2, List selectors$1, Tuple2 x$1) {
        if (x$1 != null) {
            double value = x$1._1$mcD$sp();
            Duration duration = (Duration)x$1._2();
            if (!Double.isNaN(value)) {
                long timeNanos = (long)(value * 1000000.0);
                brokerLoad$2.notifyOnThreadUsage($this.multiTenantListenerName(), 0.0, $this.time().milliseconds());
                brokerLoad$2.notifyOnThreadUsage($this.securityProtocol().name, 0.0, $this.time().milliseconds());
                brokerLoad$2.recordRequestThreadsIdleRatio(0.0);
                brokerLoad$2.recordRequestTimeNanos((Selector)selectors$1.head(), timeNanos);
            }
            $this.time().sleep(duration.toMillis());
            return;
        }
        throw new MatchError(null);
    }

    private static final Function2 assertion$1() {
        return (JFunction2.mcVDD.sp & Serializable & scala.Serializable)(x$2, brokerLoad) -> Predef$.MODULE$.assert(brokerLoad == 0.0);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleRequestLoad$3(BrokerLoadTest $this, ObjectRef samples$2, int i) {
        return ((ListBuffer)samples$2.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)(i + 1)), (Object)$this.defaultConfig().brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestLoad$4(DoubleRef prevLoad$1, double x$8, double brokerLoad) {
        prevLoad$1.elem = brokerLoad;
        Predef$.MODULE$.assert(prevLoad$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestLoad$5(DoubleRef prevLoad$1, double x$9, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad > prevLoad$1.elem);
    }

    private final Function2 assertion$2(ListBuffer samples$3) {
        return (JFunction2.mcVDD.sp & Serializable & scala.Serializable)(avgRequestTime, x$10) -> Assertions.assertEquals((double)((Tuple2)samples$3.head())._1$mcD$sp(), (double)this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$1(BrokerLoadTest $this, ObjectRef samples$4, double avgRequestTime, double x$11) {
        Assertions.assertEquals((double)((((Tuple2)((ListBuffer)samples$4.elem).apply(0))._1$mcD$sp() + ((Tuple2)((ListBuffer)samples$4.elem).apply(1))._1$mcD$sp()) / (double)2), (double)$this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$2(BrokerLoadTest $this, double avgRequestTime, double x$12) {
        Assertions.assertEquals((double)0.5, (double)$this.nanosToMs((long)avgRequestTime), (double)1.0E-6);
    }

    public static final /* synthetic */ ListBuffer $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$3(ObjectRef samples$4, KafkaConfig config$1, int _) {
        return ((ListBuffer)samples$4.elem).$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)config$1.brokerLoadWindowSizeMs()));
    }

    public static final /* synthetic */ void $anonfun$testMultipleRequestTimeAverageWithinSamplePeriod$6(BrokerLoadTest $this, double avgRequestTime, double x$14) {
        Assertions.assertEquals((double)1.0, (double)$this.nanosToMs((long)avgRequestTime), (double)0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$2(DoubleRef defaultLoad$1, double x$15, double brokerLoad) {
        defaultLoad$1.elem = brokerLoad;
        Predef$.MODULE$.assert(defaultLoad$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$3(DoubleRef defaultLoad$1, double x$16, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$1.elem > brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicServiceRequestTime$4(DoubleRef defaultLoad$1, double x$17, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$1.elem < brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$1(BrokerLoadTest $this, Selector selector) {
        $this.brokerLoad().monitorSelector(selector);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$2(DoubleRef defaultLoad$2, double x$18, double brokerLoad) {
        defaultLoad$2.elem = brokerLoad;
        Predef$.MODULE$.assert(defaultLoad$2.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$3(DoubleRef defaultLoad$2, double x$19, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$2.elem > brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testDynamicWorkloadCoefficients$4(DoubleRef defaultLoad$2, double x$20, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(defaultLoad$2.elem < brokerLoad);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$1(DoubleRef load$1, double x$21, double brokerLoad) {
        load$1.elem = brokerLoad;
        Predef$.MODULE$.assert(load$1.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$2(DoubleRef load$1, double x$22, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSamplingPeriods$3(DoubleRef load$1, double x$23, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$2(DoubleRef load$2, double x$24, double brokerLoad) {
        load$2.elem = brokerLoad;
        Predef$.MODULE$.assert(load$2.elem > 0.0);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$3(DoubleRef load$2, double x$25, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$2.elem);
    }

    public static final /* synthetic */ void $anonfun$testMultipleSampleCounts$4(DoubleRef load$2, double x$26, double brokerLoad) {
        Predef$.MODULE$.assert(brokerLoad > 0.0);
        Predef$.MODULE$.assert(brokerLoad != load$2.elem);
    }

    private static final Function2 assertion$3(DoubleRef lastLoad$1, DoubleRef lastServiceLocalTime$1) {
        return (JFunction2.mcVDD.sp & Serializable & scala.Serializable)(serviceLocalTimeAvg, brokerLoad) -> {
            Predef$.MODULE$.assert(brokerLoad > 0.0);
            Predef$.MODULE$.assert(serviceLocalTimeAvg > 0.0);
            lastLoad$1.elem = brokerLoad;
            lastServiceLocalTime$1.elem = serviceLocalTimeAvg;
        };
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$2(BrokerLoadTest $this, MultiTenantMetadata metadata$1, Queue brokerLoadInstances$1) {
        BrokerLoad brokerLoad = BrokerLoad$.MODULE$.apply($this.metrics(), $this.defaultConfig(), (Option)new Some((Object)metadata$1));
        brokerLoad.startMetric();
        Assertions.assertTrue((boolean)brokerLoad.untaggedBrokerLoadPercentMetric().isDefined());
        $this.waitAndGetBrokerLoadMetric(brokerLoad);
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageTotalServiceLocalTimeMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageReplicationNetworkThreadIdleRatioMetric().isDefined());
        Assertions.assertTrue((boolean)brokerLoad.weightedAverageRequestHandlerThreadIdleRatioMetric().isDefined());
        return brokerLoadInstances$1.add(brokerLoad);
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$5(BrokerLoadTest $this, BrokerLoad brokerLoad$3) {
        KafkaChannel channel = $this.mockKafkaChannel($this.randomTimeNanos(), $this.randomTimeNanos(), $this.randomTimeNanos());
        brokerLoad$3.notifyOnConnection(channel);
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$9(BrokerLoadTest $this, BrokerLoad brokerLoad$4, Selector mockSelector$1) {
        brokerLoad$4.recordRequestTimeNanos(mockSelector$1, $this.randomTimeNanos());
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$13(BrokerLoadTest $this, BrokerLoad brokerLoad$5) {
        brokerLoad$5.notifyOnThreadUsage($this.multiTenantListenerName(), $this.randomRatio(), $this.time().milliseconds());
        brokerLoad$5.notifyOnThreadUsage($this.securityProtocol().name, $this.randomRatio(), $this.time().milliseconds());
        brokerLoad$5.recordRequestThreadsIdleRatio($this.randomRatio());
        $this.time().sleep($this.defaultConfig().brokerLoadWindowSizeMs().toMillis());
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$testBrokerLoadIdempotency$17(BrokerLoad brokerLoad$6) {
        brokerLoad$6.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public BrokerLoadTest() {
        void var1_21;
        Logging.$init$((Logging)this);
        this.nodeId = 0;
        this.time = new MockTime();
        this.SelectorMetricsGrpPrefix = "";
        this.securityProtocol = SecurityProtocol.PLAINTEXT;
        this.multiTenantListenerName = "EXTERNAL";
        int x$1 = this.nodeId();
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        Some x$3 = new Some((Object)this.securityProtocol());
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$6, (Option<SecurityProtocol>)x$3, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        properties.put("confluent.multitenant.listener.names", this.multiTenantListenerName());
        properties.put("confluent.broker.load.enabled", "true");
        properties.put("confluent.broker.load.delay.metric.start.ms", "0");
        properties.put("confluent.broker.load.update.metric.tags.interval.ms", "100");
        this.defaultProps = var1_21;
        this.defaultConfig = KafkaConfig$.MODULE$.apply((Map)this.defaultProps(), KafkaConfig$.MODULE$.apply$default$2());
    }
}

