/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.HarnessParams;
import kafka.log.HarnessParams$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness;
import kafka.log.MergedLogHarness$;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.RecordState;
import kafka.log.TierLogSegment;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EB\u0011\u0002\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001b\t\u0013e\u0002\u0001\u0019!a\u0001\n\u0003Q\u0004\"\u0003!\u0001\u0001\u0004\u0005\t\u0015)\u00037\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!\tC\u0005L\u0001\u0001\u0007\t\u0019!C\u0001\u0019\"Ia\n\u0001a\u0001\u0002\u0003\u0006Ka\u0011\u0005\n\u001f\u0002\u0001\r\u00111A\u0005\u0002AC\u0011\u0002\u0018\u0001A\u0002\u0003\u0007I\u0011A/\t\u0013}\u0003\u0001\u0019!A!B\u0013\t\u0006\"\u00021\u0001\t\u0003\t\u0007\"B7\u0001\t\u0003\t\u0007\"\u0002:\u0001\t\u0003\t\u0007\"B<\u0001\t\u0003\t\u0007\"B=\u0001\t\u0003\t\u0007\"B>\u0001\t\u0003\t\u0007\"B?\u0001\t\u0003\t\u0007\"B@\u0001\t\u0003\t\u0007BBA\u0002\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002\b\u0001!\t!\u0019\u0005\u0007\u0003\u0017\u0001A\u0011A1\t\r\u0005=\u0001\u0001\"\u0001b\u0011\u0019\t\u0019\u0002\u0001C\u0001C\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001BBA\u0013\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002*\u0001!\t!\u0019\u0005\u0007\u0003[\u0001A\u0011A1\t\r\u0005E\u0002\u0001\"\u0001b\u0011\u001d\t)\u0004\u0001C\u0005\u0003oA\u0011\"a\u001e\u0001#\u0003%I!!\u001f\t\u0013\u0005=\u0005!%A\u0005\n\u0005E\u0005\"CAK\u0001E\u0005I\u0011BAL\u0011%\tY\nAI\u0001\n\u0013\t9\nC\u0004\u0002\u001e\u0002!I!a(\u0003%QKWM]\"p[B\f7\r\u001e'pOR+7\u000f\u001e\u0006\u0003K\u0019\n1\u0001\\8h\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001%\u0003\u001dA\u0017M\u001d8fgN,\u0012A\u000e\t\u0003g]J!\u0001\u000f\u0013\u0003!5+'oZ3e\u0019><\u0007*\u0019:oKN\u001c\u0018a\u00035be:,7o]0%KF$\"a\u000f \u0011\u0005-b\u0014BA\u001f-\u0005\u0011)f.\u001b;\t\u000f}\u001a\u0011\u0011!a\u0001m\u0005\u0019\u0001\u0010J\u0019\u0002\u0011!\f'O\\3tg\u0002\na\u0001\\8h\t&\u0014X#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015AA5p\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\t\u0019KG.Z\u0001\u000bY><G)\u001b:`I\u0015\fHCA\u001eN\u0011\u001dyd!!AA\u0002\r\u000bq\u0001\\8h\t&\u0014\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003E\u0003\"A\u0015.\u000e\u0003MS!\u0001V+\u0002\r\r|W.\\8o\u0015\t9cK\u0003\u0002X1\u00061\u0011\r]1dQ\u0016T\u0011!W\u0001\u0004_J<\u0017BA.T\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR\u00111H\u0018\u0005\b\u007f%\t\t\u00111\u0001R\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0003H#A\u001e)\u0005-\u0019\u0007C\u00013l\u001b\u0005)'B\u00014h\u0003\r\t\u0007/\u001b\u0006\u0003Q&\fqA[;qSR,'O\u0003\u0002k1\u0006)!.\u001e8ji&\u0011A.\u001a\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u00051y\u0007C\u00013q\u0013\t\tXMA\u0005BMR,'/R1dQ\u0006ID/Z:u\u0007>l\u0007\u000f\\3uK2LH)\u001a7fi\u0016$7i\\7qC\u000e$X\r\u001a)beRLG/[8o\t\u0016dW\r^3t\u00032d7+Z4nK:$8\u000f\u000b\u0002\u000eiB\u0011A-^\u0005\u0003m\u0016\u0014A\u0001V3ti\u0006\tC/Z:u5\u0016\u0014xnU5{K\u0012\u001cVmZ7f]RL5OT8u\u0003J\u001c\u0007.\u001b<fI\"\u0012a\u0002^\u00018i\u0016\u001cHOU3bI:+\u0007\u0010^(gMN,G\u000f\u0016:bG.,GmQ8se\u0016\u001cG\u000f\\=G_J\u001cu.\u001c9bGR,G\rU1si&$\u0018n\u001c8)\u0005=!\u0018A\u0007;fgR<%o\\<bE2,7i\\7qC\u000e$()\u001e4gKJ\u001c\bF\u0001\tu\u00031!Xm\u001d;UQJ|G\u000f\u001e7fQ\t\tB/A\u0011uKN$hj\\!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001c(+\u001a;bS:,G\r\u000b\u0002\u0013i\u0006AC/Z:u\u0007>l\u0007\u000f\\3uK\u0012\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t%\u0016$\u0018-\u001b8fI\"\u00121\u0003^\u0001'i\u0016\u001cHo\u00148h_&tw-\u00112peR,G\r\u0016:b]N\f7\r^5p]N\u0014V\r^1j]\u0016$\u0007F\u0001\u000bu\u0003I\"Xm\u001d;D_6\u0004H.\u001a;fI\u0006sGm\u00148h_&tw-\u00112peR,G\r\u0016:b]N\f7\r^5p]N\u0014V\r^1j]\u0016$\u0007FA\u000bu\u0003=\"Xm\u001d;NS:\u001cu.\u001c9bGRLwN\u001c'bO\u0016s\u0017M\u00197fI^KG\u000f\u001b$viV\u0014X\rV5nKN$\u0018-\u001c9tQ\t1B/\u0001\u0019uKN$X*\u001b8D_6\u0004\u0018m\u0019;j_:d\u0015m\u001a#jg\u0006\u0014G.\u001a3XSRDg)\u001e;ve\u0016$\u0016.\\3ti\u0006l\u0007o\u001d\u0015\u0003/Q\f\u0001\u0006^3ti6KgnQ8na\u0006\u001cG/[8o\u0019\u0006<w+\u001b;i\rV$XO]3US6,7\u000f^1naN$2aOA\u000e\u0011\u001d\ti\u0002\u0007a\u0001\u0003?\tq#\\5o\u0007>l\u0007/Y2uS>tG*Y4F]\u0006\u0014G.\u001a3\u0011\u0007-\n\t#C\u0002\u0002$1\u0012qAQ8pY\u0016\fg.\u0001\u000buKN$8i\\7qC\u000e$\u0018I\u001c3EK2,G/\u001a\u0015\u00033Q\f\u0011\u0004^3tiJ+G/\u001a8uS>t\u0007k\u001c7jGf\u001c\u0005.\u00198hK\"\u0012!\u0004^\u0001(i\u0016\u001cH\u000fS8ug\u0016$(+\u001a;f]RLwN\u001c$pe\u000e{W\u000e]1di\u0016$7+Z4nK:$8\u000f\u000b\u0002\u001ci\u0006aB/Z:u\tV\fGnQ8na\u0006\u001cG/[8o-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u000fu\u0003\u0019\u0011XmY8sIR\u0001\u0012\u0011HA\"\u0003'\n9&!\u0019\u0002f\u0005=\u00141\u000f\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0019\u0011QG*\n\t\u0005\u0005\u0013Q\b\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\u0005\u0015S\u00041\u0001\u0002H\u0005\u00191.Z=\u0011\u000b-\nI%!\u0014\n\u0007\u0005-CF\u0001\u0004PaRLwN\u001c\t\u0004W\u0005=\u0013bAA)Y\t\u0019\u0011J\u001c;\t\u000f\u0005US\u00041\u0001\u0002H\u0005)a/\u00197vK\"9\u0011\u0011L\u000fA\u0002\u0005m\u0013!\u0003;j[\u0016\u001cH/Y7q!\rY\u0013QL\u0005\u0004\u0003?b#\u0001\u0002'p]\u001eD\u0011\"a\u0019\u001e!\u0003\u0005\r!a\u0017\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0005\u0002hu\u0001\n\u00111\u0001\u0002j\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042aKA6\u0013\r\ti\u0007\f\u0002\u0006'\"|'\u000f\u001e\u0005\n\u0003cj\u0002\u0013!a\u0001\u0003\u001b\n\u0001b]3rk\u0016t7-\u001a\u0005\n\u0003kj\u0002\u0013!a\u0001\u0003\u001b\nA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0017\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00135+\t\tYH\u000b\u0003\u0002\\\u0005u4FAA@!\u0011\t\t)a#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%E&\u0001\u0006b]:|G/\u0019;j_:LA!!$\u0002\u0004\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012*TCAAJU\u0011\tI'! \u0002!I,7m\u001c:eI\u0011,g-Y;mi\u00122TCAAMU\u0011\ti%! \u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012:\u0014aC1c_J$X*\u0019:lKJ$\"\"!\u000f\u0002\"\u0006\r\u0016QUAT\u0011\u001d\tIF\ta\u0001\u00037Bq!a\u0019#\u0001\u0004\tY\u0006C\u0004\u0002h\t\u0002\r!!\u001b\t\u000f\u0005U$\u00051\u0001\u0002N\u0001")
public class TierCompactLogTest {
    private MergedLogHarness harness;
    private File logDir;
    private TopicPartition topicPartition;

    public MergedLogHarness harness() {
        return this.harness;
    }

    public void harness_$eq(MergedLogHarness x$1) {
        this.harness = x$1;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public void topicPartition_$eq(TopicPartition x$1) {
        this.topicPartition = x$1;
    }

    @BeforeEach
    public void setUp() {
        File tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir_$eq(TestUtils$.MODULE$.randomPartitionLogDir(tmpDir));
    }

    @AfterEach
    public void tearDown() {
        this.harness().destroy();
        this.harness_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletelyDeletedCompactedPartitionDeletesAllSegments() {
        void var39_36;
        void var38_35;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 0L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as hwm is too low");
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 1L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as hwm is too low");
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        this.harness().advanceClock(10L);
        this.harness().log().flush(false);
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$5 = this.harness();
        boolean x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$16 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 2L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$17 = 0;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$19 = qual$6.appendAsLeader$default$4();
        RequestLocal x$20 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$16, x$17, (AppendOrigin)x$18, x$19, x$20);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        MergedLog qual$7 = this.harness().log();
        Option x$21 = qual$7.roll$default$1();
        long x$22 = qual$7.roll$default$2();
        qual$7.roll(x$21, x$22);
        this.harness().log().flush(false);
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.maybeClean$default$1();
        qual$8.maybeClean(x$23);
        Assertions.assertTrue((boolean)this.harness().takeStateSnapshot().tieredSegments().isEmpty());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer recordRead = (ListBuffer)tuple2._2();
        void offsetMap2 = var38_35;
        void recordRead2 = var39_36;
        Assertions.assertTrue((boolean)offsetMap2.isEmpty());
        Assertions.assertTrue((boolean)recordRead2.isEmpty());
        Assertions.assertFalse((boolean)this.harness().log().tierPartitionState().compactedSegments().isEmpty(), (String)"there should be compacted segments ready for deletion");
        Assertions.assertTrue((this.harness().tierRetention() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.harness().log().tierPartitionState().compactedSegments().isEmpty(), (String)"compacted segments should now be deleted");
    }

    @Test
    public void testZeroSizedSegmentIsNotArchived() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, false, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 0L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertFalse((boolean)this.harness().log().localLog().segments().values().exists((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testZeroSizedSegmentIsNotArchived$1(seg))));
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as tiered storage is disabled");
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)None$.MODULE$, 1L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertFalse((boolean)this.harness().maybeTierSegment(), (String)"shouldn't have been tiered as tiered storage is disabled");
        this.harness().advanceClock(10L);
        MergedLogHarness qual$5 = this.harness();
        boolean x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        Assertions.assertFalse((boolean)this.harness().log().localLog().segments().values().exists((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testZeroSizedSegmentIsNotArchived$2(seg))));
        Assertions.assertEquals((long)0L, (long)this.harness().log().size());
        this.harness().updateConfig(LogConfig$.MODULE$.TierEnableProp(), "true");
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$16 = this.record((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)3)), 2L, this.record$default$4(), this.record$default$5(), this.record$default$6(), this.record$default$7());
        int x$17 = 0;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$19 = qual$6.appendAsLeader$default$4();
        RequestLocal x$20 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$16, x$17, (AppendOrigin)x$18, x$19, x$20);
        MergedLog qual$7 = this.harness().log();
        Option x$21 = qual$7.roll$default$1();
        long x$22 = qual$7.roll$default$2();
        qual$7.roll(x$21, x$22);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((long)2L, (long)((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).baseOffset());
        Assertions.assertEquals((long)2L, (long)((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).endOffset());
        Assertions.assertTrue((((TierLogSegment)this.harness().log().tierPartitionState().segments().next()).size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadNextOffsetTrackedCorrectlyForCompactedPartition() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, false, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        MergedLogHarness qual$5 = this.harness();
        boolean x$15 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$15);
        Assertions.assertEquals((long)2L, (long)((LogSegment)this.harness().log().localLog().segments().values().head()).readNextOffset());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> read = this.harness().readKeysAndOffsets();
        this.harness().updateConfig(LogConfig$.MODULE$.TierEnableProp(), "true");
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals(this.harness().readKeysAndOffsets(), read);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGrowableCompactBuffers() {
        void var35_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 2000, 86400000L, 0L, true, true, "compact", 2000, MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        int initialCompactBufferSize = 100;
        int maxCompactBufferSize = 10000;
        HarnessParams params = new HarnessParams(10000, -1, initialCompactBufferSize, maxCompactBufferSize, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        String longKey = new StringOps(Predef$.MODULE$.augmentString("f")).$times(1000);
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, longKey.getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$22 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$22, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, longKey.getBytes(), Integer.toString(2).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$14 = 0;
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        Option x$18 = qual$5.roll$default$1();
        long x$19 = qual$5.roll$default$2();
        qual$5.roll(x$18, x$19);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        MergedLogHarness qual$6 = this.harness();
        boolean x$20 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$20);
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)var35_33.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.offset()), ListBuffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testThrottle() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        int throttleRateBytesPerSec = 100;
        int x$1 = 10000;
        int x$2 = -1;
        int x$3 = 10000;
        int x$4 = 10000;
        double x$5 = throttleRateBytesPerSec;
        int x$6 = -1;
        int x$7 = HarnessParams$.MODULE$.apply$default$6();
        HarnessParams params = new HarnessParams(x$1, x$2, x$3, x$4, x$5, x$7, x$6);
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$11 = qual$1.appendAsLeader$default$4();
        RequestLocal x$12 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$13 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(2).getBytes())});
        int x$14 = 0;
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$16 = qual$2.appendAsLeader$default$4();
        RequestLocal x$17 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$3 = this.harness().log();
        Option x$18 = qual$3.roll$default$1();
        long x$19 = qual$3.roll$default$2();
        qual$3.roll(x$18, x$19);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$20 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$21 = 0;
        AppendOrigin.Client$ x$22 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$23 = qual$4.appendAsLeader$default$4();
        RequestLocal x$24 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$20, x$21, (AppendOrigin)x$22, x$23, x$24);
        MergedLog qual$5 = this.harness().log();
        Option x$25 = qual$5.roll$default$1();
        long x$26 = qual$5.roll$default$2();
        qual$5.roll(x$25, x$26);
        this.harness().advanceClock(10L);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        long bytesToRead = this.harness().log().tierPartitionState().totalSize() * 2L;
        long beforeTime = this.harness().log().localLog().time().milliseconds();
        MergedLogHarness qual$6 = this.harness();
        boolean x$27 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$27);
        long wroteBytes = this.harness().log().tierPartitionState().totalSize();
        long afterTime = this.harness().log().localLog().time().milliseconds();
        long shouldTake = (bytesToRead + wroteBytes) * 1000L / (long)throttleRateBytesPerSec;
        long took = afterTime - beforeTime;
        Assertions.assertTrue(((double)Math.abs(shouldTake - took) / (double)took < 0.01 ? 1 : 0) != 0, (String)"should have throttled within 1% ");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoAbortedTransactionsRetained() {
        void var58_56;
        void var57_55;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)4, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(4).getBytes(), Integer.toString(4).getBytes()), new SimpleRecord(5L, Integer.toString(5).getBytes(), Integer.toString(5).getBytes())});
        int x$14 = 0;
        AppendOrigin.Client$ x$15 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$18 = this.abortMarker(6L, 1L, (short)0, -1);
        int x$19 = 0;
        AppendOrigin.Coordinator$ x$20 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$21 = qual$5.appendAsLeader$default$4();
        RequestLocal x$22 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$18, x$19, (AppendOrigin)x$20, x$21, x$22);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$23 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)6, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(7L, Integer.toString(7).getBytes(), Integer.toString(7).getBytes()), new SimpleRecord(8L, Integer.toString(8).getBytes(), Integer.toString(8).getBytes())});
        int x$24 = 0;
        AppendOrigin.Client$ x$25 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$26 = qual$6.appendAsLeader$default$4();
        RequestLocal x$27 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$23, x$24, (AppendOrigin)x$25, x$26, x$27);
        MergedLog qual$7 = this.harness().log();
        Option x$28 = qual$7.roll$default$1();
        long x$29 = qual$7.roll$default$2();
        qual$7.roll(x$28, x$29);
        MergedLog qual$8 = this.harness().log();
        MemoryRecords x$30 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)8, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(9L, Integer.toString(9).getBytes(), Integer.toString(9).getBytes()), new SimpleRecord(10L, Integer.toString(10).getBytes(), Integer.toString(10).getBytes())});
        int x$31 = 0;
        AppendOrigin.Client$ x$32 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$33 = qual$8.appendAsLeader$default$4();
        RequestLocal x$34 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$30, x$31, (AppendOrigin)x$32, x$33, x$34);
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$35 = this.abortMarker(11L, 1L, (short)0, -1);
        int x$36 = 0;
        AppendOrigin.Coordinator$ x$37 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$38 = qual$9.appendAsLeader$default$4();
        RequestLocal x$39 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$35, x$36, (AppendOrigin)x$37, x$38, x$39);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$10 = this.harness();
        boolean x$40 = qual$10.maybeClean$default$1();
        qual$10.maybeClean(x$40);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var57_55;
        void records2 = var58_56;
        Assertions.assertEquals((int)4, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testNoAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testNoAbortedTransactionsRetained$2(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)offsetMap2.size());
        Assertions.assertEquals((long)9L, (long)BoxesRunTime.unboxToLong(offsetMap2.get(new Some((Object)Integer.toString(9)))));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong(offsetMap2.get(new Some((Object)Integer.toString(10)))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletedAbortedTransactionsRetained() {
        void var30_29;
        void var29_28;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$11 = this.abortMarker(4L, 1L, (short)0, -1);
        int x$12 = 0;
        AppendOrigin.Coordinator$ x$13 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        MergedLog qual$4 = this.harness().log();
        Option x$16 = qual$4.roll$default$1();
        long x$17 = qual$4.roll$default$2();
        qual$4.roll(x$16, x$17);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$5 = this.harness();
        boolean x$18 = qual$5.maybeClean$default$1();
        qual$5.maybeClean(x$18);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var29_28;
        void records2 = var30_29;
        Assertions.assertEquals((int)1, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOngoingAbortedTransactionsRetained() {
        void var34_32;
        void var33_31;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 0L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        Option x$11 = qual$3.roll$default$1();
        long x$12 = qual$3.roll$default$2();
        qual$3.roll(x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$13 = this.abortMarker(4L, 1L, (short)0, -1);
        int x$14 = 0;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$16 = qual$4.appendAsLeader$default$4();
        RequestLocal x$17 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$13, x$14, (AppendOrigin)x$15, x$16, x$17);
        MergedLog qual$5 = this.harness().log();
        Option x$18 = qual$5.roll$default$1();
        long x$19 = qual$5.roll$default$2();
        qual$5.roll(x$18, x$19);
        this.harness().log().maybeUpdateHighWatermarkAndRecoveryPoint(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$6 = this.harness();
        boolean x$20 = qual$6.maybeClean$default$1();
        qual$6.maybeClean(x$20);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var33_31;
        void records2 = var34_32;
        Assertions.assertEquals((int)1, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testOngoingAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompletedAndOngoingAbortedTransactionsRetained() {
        void var60_59;
        void var59_58;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, 1L, 1000, 86400000L, 86400000L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        short producerEpoch = 0;
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        MemoryRecords x$6 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)2L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(3L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$7 = 0;
        AppendOrigin.Client$ x$8 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$9 = qual$2.appendAsLeader$default$4();
        RequestLocal x$10 = qual$2.appendAsLeader$default$5();
        qual$2.appendAsLeader(x$6, x$7, (AppendOrigin)x$8, x$9, x$10);
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$11 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)2L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(5L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$12 = 0;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = qual$3.appendAsLeader$default$4();
        RequestLocal x$15 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$11, x$12, (AppendOrigin)x$13, x$14, x$15);
        MergedLog qual$4 = this.harness().log();
        MemoryRecords x$16 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)1L, (short)producerEpoch, (int)2, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(6L, Integer.toString(2).getBytes(), Integer.toString(2).getBytes()), new SimpleRecord(7L, Integer.toString(3).getBytes(), Integer.toString(3).getBytes())});
        int x$17 = 0;
        AppendOrigin.Client$ x$18 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$19 = qual$4.appendAsLeader$default$4();
        RequestLocal x$20 = qual$4.appendAsLeader$default$5();
        qual$4.appendAsLeader(x$16, x$17, (AppendOrigin)x$18, x$19, x$20);
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$21 = this.abortMarker(8L, 2L, (short)0, -1);
        int x$22 = 0;
        AppendOrigin.Coordinator$ x$23 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$24 = qual$5.appendAsLeader$default$4();
        RequestLocal x$25 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$21, x$22, (AppendOrigin)x$23, x$24, x$25);
        MergedLog qual$6 = this.harness().log();
        MemoryRecords x$26 = MemoryRecords.withTransactionalRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)3L, (short)producerEpoch, (int)0, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(9L, Integer.toString(4).getBytes(), Integer.toString(4).getBytes()), new SimpleRecord(10L, Integer.toString(5).getBytes(), Integer.toString(5).getBytes())});
        int x$27 = 0;
        AppendOrigin.Client$ x$28 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$29 = qual$6.appendAsLeader$default$4();
        RequestLocal x$30 = qual$6.appendAsLeader$default$5();
        qual$6.appendAsLeader(x$26, x$27, (AppendOrigin)x$28, x$29, x$30);
        MergedLog qual$7 = this.harness().log();
        Option x$31 = qual$7.roll$default$1();
        long x$32 = qual$7.roll$default$2();
        qual$7.roll(x$31, x$32);
        MergedLog qual$8 = this.harness().log();
        MemoryRecords x$33 = this.abortMarker(8L, 3L, (short)0, -1);
        int x$34 = 0;
        AppendOrigin.Coordinator$ x$35 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$36 = qual$8.appendAsLeader$default$4();
        RequestLocal x$37 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$33, x$34, (AppendOrigin)x$35, x$36, x$37);
        MergedLog qual$9 = this.harness().log();
        MemoryRecords x$38 = this.abortMarker(8L, 1L, (short)0, -1);
        int x$39 = 0;
        AppendOrigin.Coordinator$ x$40 = AppendOrigin.Coordinator$.MODULE$;
        ApiVersion x$41 = qual$9.appendAsLeader$default$4();
        RequestLocal x$42 = qual$9.appendAsLeader$default$5();
        qual$9.appendAsLeader(x$38, x$39, (AppendOrigin)x$40, x$41, x$42);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$10 = this.harness();
        boolean x$43 = qual$10.maybeClean$default$1();
        qual$10.maybeClean(x$43);
        Assertions.assertEquals((int)1, (int)this.harness().log().tieredLogSegments().size());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        HashMap offsetMap = (HashMap)tuple2._1();
        ListBuffer records = (ListBuffer)tuple2._2();
        void offsetMap2 = var59_58;
        void records2 = var60_59;
        Assertions.assertEquals((int)3, (int)records2.size());
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$1(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$2(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((records2.count((Function1 & Serializable & scala.Serializable)rec -> BoxesRunTime.boxToBoolean((boolean)TierCompactLogTest.$anonfun$testCompletedAndOngoingAbortedTransactionsRetained$3(rec))) == 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)offsetMap2.size());
    }

    @Test
    public void testMinCompactionLagEnabledWithFutureTimestamps() {
        this.testMinCompactionLagWithFutureTimestamps(true);
    }

    @Test
    public void testMinCompactionLagDisabledWithFutureTimestamps() {
        this.testMinCompactionLagWithFutureTimestamps(false);
    }

    /*
     * WARNING - void declaration
     */
    private void testMinCompactionLagWithFutureTimestamps(boolean minCompactionLagEnabled) {
        void var64_53;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        int minCompactionLagMs = minCompactionLagEnabled ? 1 : 0;
        long x$1 = -1L;
        long x$2 = 1L;
        long x$3 = -1L;
        long x$4 = 0L;
        int x$5 = 100;
        long x$6 = 86400000L;
        long x$72 = 0L;
        boolean x$82 = true;
        boolean x$92 = true;
        String x$102 = "compact";
        long x$11 = minCompactionLagMs;
        int x$12 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$11();
        int x$13 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$12();
        int x$14 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$13();
        long x$15 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$14();
        boolean x$16 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$15();
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$72, x$82, x$92, x$102, x$12, x$13, x$14, x$15, x$16, x$11);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$17 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(10L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(10L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$18 = 0;
        AppendOrigin.Client$ x$19 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$17, x$18, (AppendOrigin)x$19, x$20, x$21);
        MergedLog qual$2 = this.harness().log();
        Option x$22 = qual$2.roll$default$1();
        long x$23 = qual$2.roll$default$2();
        qual$2.roll(x$22, x$23);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$24 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(20L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(20L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$25 = 0;
        AppendOrigin.Client$ x$26 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$27 = qual$3.appendAsLeader$default$4();
        RequestLocal x$28 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$24, x$25, (AppendOrigin)x$26, x$27, x$28);
        MergedLog qual$4 = this.harness().log();
        Option x$29 = qual$4.roll$default$1();
        long x$30 = qual$4.roll$default$2();
        qual$4.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$31 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(30L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(30L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$32 = 0;
        AppendOrigin.Client$ x$33 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$34 = qual$5.appendAsLeader$default$4();
        RequestLocal x$35 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$31, x$32, (AppendOrigin)x$33, x$34, x$35);
        MergedLog qual$6 = this.harness().log();
        Option x$36 = qual$6.roll$default$1();
        long x$37 = qual$6.roll$default$2();
        qual$6.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertTrue((this.harness().log().deleteOldSegments() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)1, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(25L);
        MergedLogHarness qual$7 = this.harness();
        boolean x$38 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$38);
        if (minCompactionLagEnabled) {
            void var62_51;
            Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
            Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            ListBuffer records = (ListBuffer)tuple2._2();
            Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "2", "3"})), (Object)var62_51.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)x$7.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
            Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "20", "200", "300"})), (Object)var62_51.map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
            return;
        }
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3"})), (Object)var64_53.map((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "200", "300"})), (Object)var64_53.map((Function1 & Serializable & scala.Serializable)x$10 -> (String)x$10.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCompactAndDelete() {
        void var36_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(2L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "compact,delete", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$112 = qual$3.appendAsLeader$default$4();
        RequestLocal x$122 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$112, x$122);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$15 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$16 = 0;
        AppendOrigin.Client$ x$17 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, x$16, (AppendOrigin)x$17, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().advanceClock(4L);
        this.harness().tierRetention();
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().log().deleteOldSegments();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10", "200", "300"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$12 -> (String)x$12.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRetentionPolicyChange() {
        void var38_35;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(2L, 1L, -1L, 1L, 100, 86400000L, 0L, true, true, "delete", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$132 = qual$4.roll$default$1();
        long x$142 = qual$4.roll$default$2();
        qual$4.roll(x$132, x$142);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$15 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$16 = 0;
        AppendOrigin.Client$ x$17 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$15, x$16, (AppendOrigin)x$17, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().advanceClock(4L);
        this.harness().tierRetention();
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)2, (int)this.harness().log().tierPartitionState().numSegments());
        this.harness().updateConfig(LogConfig$.MODULE$.CleanupPolicyProp(), "delete,compact");
        MergedLogHarness qual$8 = this.harness();
        boolean x$23 = qual$8.maybeClean$default$1();
        qual$8.maybeClean(x$23);
        this.harness().log().deleteOldSegments();
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1", "2", "3"})), (Object)var38_35.map((Function1 & Serializable & scala.Serializable)x$13 -> (String)x$13.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10", "200", "300"})), (Object)var38_35.map((Function1 & Serializable & scala.Serializable)x$14 -> (String)x$14.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHotsetRetentionForCompactedSegments() {
        void var36_33;
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(-1L, 1L, -1L, -1L, 100, 86400000L, 0L, true, true, "compact", MergedLogHarnessHelpers$.MODULE$.logConfig$default$11(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$12(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$13(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$14(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$15(), MergedLogHarnessHelpers$.MODULE$.logConfig$default$16());
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$1 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$2 = 0;
        AppendOrigin.Client$ x$3 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, (AppendOrigin)x$3, x$4, x$5);
        MergedLog qual$2 = this.harness().log();
        Option x$6 = qual$2.roll$default$1();
        long x$7 = qual$2.roll$default$2();
        qual$2.roll(x$6, x$7);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$8 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$9 = 0;
        AppendOrigin.Client$ x$10 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$11 = qual$3.appendAsLeader$default$4();
        RequestLocal x$12 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$8, x$9, (AppendOrigin)x$10, x$11, x$12);
        MergedLog qual$4 = this.harness().log();
        Option x$13 = qual$4.roll$default$1();
        long x$14 = qual$4.roll$default$2();
        qual$4.roll(x$13, x$14);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$152 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$162 = 0;
        AppendOrigin.Client$ x$17 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$18 = qual$5.appendAsLeader$default$4();
        RequestLocal x$19 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$152, x$162, (AppendOrigin)x$17, x$18, x$19);
        MergedLog qual$6 = this.harness().log();
        Option x$20 = qual$6.roll$default$1();
        long x$21 = qual$6.roll$default$2();
        qual$6.roll(x$20, x$21);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        Assertions.assertEquals((int)1, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)3, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        boolean x$22 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$22);
        Assertions.assertEquals((int)2, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)1, (int)this.harness().log().tierPartitionState().numSegments());
        Tuple2<HashMap<Option<String>, Object>, ListBuffer<RecordState>> tuple2 = this.harness().readKeysAndOffsets();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListBuffer records = (ListBuffer)tuple2._2();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2", "3"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$15 -> (String)x$15.key().get(), ListBuffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "10", "200", "300"})), (Object)var36_33.map((Function1 & Serializable & scala.Serializable)x$16 -> (String)x$16.value().get(), ListBuffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDualCompactionValidation() {
        this.topicPartition_$eq(MergedLog$.MODULE$.parseTopicPartitionName(this.logDir()));
        long x$1 = -1L;
        long x$2 = 1L;
        long x$3 = -1L;
        long x$4 = -1L;
        int x$5 = 100;
        long x$6 = 86400000L;
        long x$7 = 0L;
        boolean x$8 = true;
        boolean x$9 = true;
        String x$10 = "compact";
        boolean x$11 = true;
        int x$12 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$11();
        int x$13 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$12();
        int x$14 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$13();
        long x$15 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$14();
        long x$16 = MergedLogHarnessHelpers$.MODULE$.logConfig$default$16();
        LogConfig logConfig = MergedLogHarnessHelpers$.MODULE$.logConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$12, x$13, x$14, x$15, x$11, x$16);
        HarnessParams params = new HarnessParams(10000, -1, 100000, 100000, HarnessParams$.MODULE$.apply$default$5(), HarnessParams$.MODULE$.apply$default$6(), HarnessParams$.MODULE$.apply$default$7());
        this.harness_$eq(MergedLogHarness$.MODULE$.apply(this.topicPartition(), logConfig, params));
        MergedLog qual$1 = this.harness().log();
        MemoryRecords x$17 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1L, Integer.toString(0).getBytes(), Integer.toString(0).getBytes()), new SimpleRecord(1L, Integer.toString(1).getBytes(), Integer.toString(1).getBytes())});
        int x$18 = 0;
        AppendOrigin.Client$ x$19 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$20 = qual$1.appendAsLeader$default$4();
        RequestLocal x$21 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$17, x$18, (AppendOrigin)x$19, x$20, x$21);
        MergedLog qual$2 = this.harness().log();
        Option x$22 = qual$2.roll$default$1();
        long x$23 = qual$2.roll$default$2();
        qual$2.roll(x$22, x$23);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$3 = this.harness().log();
        MemoryRecords x$24 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(2L, Integer.toString(1).getBytes(), Integer.toString(10).getBytes()), new SimpleRecord(2L, Integer.toString(2).getBytes(), Integer.toString(20).getBytes())});
        int x$25 = 0;
        AppendOrigin.Client$ x$26 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$27 = qual$3.appendAsLeader$default$4();
        RequestLocal x$28 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$24, x$25, (AppendOrigin)x$26, x$27, x$28);
        MergedLog qual$4 = this.harness().log();
        Option x$29 = qual$4.roll$default$1();
        long x$30 = qual$4.roll$default$2();
        qual$4.roll(x$29, x$30);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        MergedLog qual$5 = this.harness().log();
        MemoryRecords x$31 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(3L, Integer.toString(2).getBytes(), Integer.toString(200).getBytes()), new SimpleRecord(3L, Integer.toString(3).getBytes(), Integer.toString(300).getBytes())});
        int x$32 = 0;
        AppendOrigin.Client$ x$33 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$34 = qual$5.appendAsLeader$default$4();
        RequestLocal x$35 = qual$5.appendAsLeader$default$5();
        qual$5.appendAsLeader(x$31, x$32, (AppendOrigin)x$33, x$34, x$35);
        MergedLog qual$6 = this.harness().log();
        Option x$36 = qual$6.roll$default$1();
        long x$37 = qual$6.roll$default$2();
        qual$6.roll(x$36, x$37);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        Assertions.assertEquals((int)3, (int)this.harness().log().tierPartitionState().numSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        this.harness().advanceClock(3L);
        Assertions.assertEquals((int)0, (int)this.harness().log().deleteOldSegments());
        Assertions.assertEquals((int)4, (int)this.harness().log().localLogSegments().size());
        MergedLogHarness qual$7 = this.harness();
        boolean x$38 = qual$7.maybeClean$default$1();
        qual$7.maybeClean(x$38);
        Assertions.assertTrue((this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationPassedPerSec().meanRate() > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)0.0, (double)this.harness().compactionTask().tierCompactionMetrics().cleanerMetrics().validationFailedPerSec().meanRate());
        MergedLog qual$8 = this.harness().log();
        MemoryRecords x$39 = MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)-1L, (short)-1, (int)-1, (int)-1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(4L, Integer.toString(3).getBytes(), Integer.toString(3000).getBytes()), new SimpleRecord(4L, Integer.toString(4).getBytes(), Integer.toString(4000).getBytes())});
        int x$40 = 0;
        AppendOrigin.Client$ x$41 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$42 = qual$8.appendAsLeader$default$4();
        RequestLocal x$43 = qual$8.appendAsLeader$default$5();
        qual$8.appendAsLeader(x$39, x$40, (AppendOrigin)x$41, x$42, x$43);
        MergedLog qual$9 = this.harness().log();
        Option x$44 = qual$9.roll$default$1();
        long x$45 = qual$9.roll$default$2();
        qual$9.roll(x$44, x$45);
        this.harness().log().updateHighWatermark(this.harness().log().logEndOffset());
        Assertions.assertTrue((boolean)this.harness().maybeTierSegment());
        this.harness().simulateDataLoss();
        this.harness().maybeClean(false);
    }

    private MemoryRecords record(Option<Object> key, Option<Object> value, long timestamp, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, (byte[])key.map((Function1 & Serializable & scala.Serializable)x$17 -> TierCompactLogTest.$anonfun$record$1(BoxesRunTime.unboxToInt((Object)x$17))).orNull(Predef$.MODULE$.$conforms()), (byte[])value.map((Function1 & Serializable & scala.Serializable)x$18 -> TierCompactLogTest.$anonfun$record$2(BoxesRunTime.unboxToInt((Object)x$18))).orNull(Predef$.MODULE$.$conforms()))});
    }

    private long record$default$4() {
        return -1L;
    }

    private short record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private int record$default$7() {
        return -1;
    }

    private MemoryRecords abortMarker(long timestamp, long producerId, short producerEpoch, int partitionLeaderEpoch) {
        EndTransactionMarker marker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
        return MemoryRecords.withEndTransactionMarker((long)0L, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    public static final /* synthetic */ boolean $anonfun$testZeroSizedSegmentIsNotArchived$1(LogSegment seg) {
        return seg.scanNextOffset() != seg.readNextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testZeroSizedSegmentIsNotArchived$2(LogSegment seg) {
        return seg.scanNextOffset() != seg.readNextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testNoAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 6L;
    }

    public static final /* synthetic */ boolean $anonfun$testNoAbortedTransactionsRetained$2(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 11L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 4L;
    }

    public static final /* synthetic */ boolean $anonfun$testOngoingAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 4L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$1(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 8L && rec.producerId() == 2L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$2(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 11L && rec.producerId() == 3L;
    }

    public static final /* synthetic */ boolean $anonfun$testCompletedAndOngoingAbortedTransactionsRetained$3(RecordState rec) {
        return rec.isControlBatch() && rec.offset() == 12L && rec.producerId() == 1L;
    }

    public static final /* synthetic */ byte[] $anonfun$record$1(int x$17) {
        return Integer.toString(x$17).getBytes();
    }

    public static final /* synthetic */ byte[] $anonfun$record$2(int x$18) {
        return Integer.toString(x$18).getBytes();
    }
}

