/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.MergedLog;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;

public final class MergedLogHarnessHelpers$ {
    public static MergedLogHarnessHelpers$ MODULE$;

    static {
        new MergedLogHarnessHelpers$();
    }

    public LogConfig logConfig(long retentionMs, long hotsetMs, long retentionBytes, long hotsetRetentionBytes, int segmentBytes, long segmentMs, long deleteRetention, boolean tierEnable, boolean tierCleanerEnable, String cleanupPolicy, int maxMessageBytes, int indexInterval, int indexMaxSize, long preferTierFetchMs, boolean tierCleanerDualCompaction, long minCompactionLagMs) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Long.toString(Long.MAX_VALUE));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentBytes));
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Long.toString(segmentMs));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(retentionBytes));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(maxMessageBytes));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Integer.toString(indexInterval));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Integer.toString(indexMaxSize));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Integer.toString(0));
        logProps.put(LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(tierEnable));
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetBytesProp(), Long.toString(hotsetRetentionBytes));
        logProps.put(LogConfig$.MODULE$.TierLocalHotsetMsProp(), Long.toString(hotsetMs));
        logProps.put(LogConfig$.MODULE$.PreferTierFetchMsProp(), Long.toString(preferTierFetchMs));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Long.toString(minCompactionLagMs));
        logProps.put(LogConfig$.MODULE$.TierCleanerEnableProp(), Boolean.toString(tierCleanerEnable));
        logProps.put(LogConfig$.MODULE$.TierCleanerDualCompactionProp(), Boolean.toString(tierCleanerDualCompaction));
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), Long.toString(deleteRetention));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public int logConfig$default$11() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int logConfig$default$12() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int logConfig$default$13() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public long logConfig$default$14() {
        return Defaults$.MODULE$.PreferTierFetchMs();
    }

    public boolean logConfig$default$15() {
        return Defaults$.MODULE$.TierCleanerDualCompaction();
    }

    public long logConfig$default$16() {
        return Defaults$.MODULE$.MinCompactionLagMs();
    }

    public void ensureTierEnabledState(MergedLog log) {
        if (log.tierPartitionState().isTieringEnabled()) {
            log.tierPartitionState().beginCatchup();
            log.tierPartitionState().onCatchUpComplete();
            log.tierInitializationCompletionCb(true);
        }
    }

    public Option<String> payloadToString(ByteBuffer buf) {
        return Option$.MODULE$.apply((Object)buf).map((Function1 & java.io.Serializable & Serializable)b -> {
            byte[] arr = (byte[])Array$.MODULE$.fill(b.limit(), (Function0)(JFunction0.mcB.sp & java.io.Serializable & Serializable)() -> -1, ClassTag$.MODULE$.Byte());
            b.get(arr);
            return new String(arr, StandardCharsets.UTF_8);
        });
    }

    private MergedLogHarnessHelpers$() {
        MODULE$ = this;
    }
}

