/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import kafka.cluster.Partition;
import kafka.log.Cleaner;
import kafka.log.FakeOffsetMap;
import kafka.log.FaultInjectedTierObjectStoreWrapper;
import kafka.log.HarnessParams;
import kafka.log.LogCleanerMetrics;
import kafka.log.LogCleanerMetrics$;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.MergedLogHarness;
import kafka.log.MergedLogHarnessHelpers$;
import kafka.log.OffsetMap;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompactionTasksConfig;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierCompactionMetrics$;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple7;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class MergedLogHarness$
implements Logging {
    public static MergedLogHarness$ MODULE$;
    private final int MaxTransactionTimeoutMs;
    private final int MaxProducerIdExpirationMs;
    private final int BrokerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new MergedLogHarness$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int MaxTransactionTimeoutMs() {
        return this.MaxTransactionTimeoutMs;
    }

    public int MaxProducerIdExpirationMs() {
        return this.MaxProducerIdExpirationMs;
    }

    public int BrokerId() {
        return this.BrokerId;
    }

    public Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> initializeComponents(MergedLog log, Throttler throttler, HarnessParams params, int leaderEpoch) {
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog(log.topicPartition(), logManager.getLog$default$2())).thenReturn((Object)new Some((Object)log));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog(log.topicPartition())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        CancellationContext ctx = CancellationContext.newContext();
        CompactionTasksConfig compactionTaskConfig = new CompactionTasksConfig(params.skimpyOffsetMapMemory(), Defaults$.MODULE$.LogCleanerDedupeBufferLoadFactor(), params.initialCompactIoBufferSize(), params.maxCompactBufferSize(), params.ioMaxBytesPerSecond(), params.throttleCheckInterval(), 100, Long.MAX_VALUE);
        int x$12 = 1;
        int x$2 = 0;
        long x$3 = 5L;
        boolean x$4 = Predef$.MODULE$.Boolean2boolean(log.config().confluentLogConfig().tierCleanerEnable());
        Some x$5 = new Some((Object)compactionTaskConfig);
        int x$6 = this.BrokerId();
        long x$7 = TierTasksConfig$.MODULE$.$lessinit$greater$default$4();
        int x$8 = TierTasksConfig$.MODULE$.$lessinit$greater$default$6();
        int x$9 = TierTasksConfig$.MODULE$.$lessinit$greater$default$7();
        TierTasksConfig tierTasksConfig = new TierTasksConfig(x$12, x$2, x$6, x$7, x$3, x$8, x$9, x$4, (Option)x$5);
        TopicIdPartition topicIdPartition = new TopicIdPartition(log.topicPartition().topic(), CoreUtils$.MODULE$.toJavaUUID((Uuid)log.topicId().get()), log.topicPartition().partition());
        ArchiveTask archiveTask = new ArchiveTask(ctx, topicIdPartition, (ArchiveTaskState)new BeforeLeader(leaderEpoch), new ArchiverMetrics((Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$), this.BrokerId());
        LogCleanerMetrics logCleanerMetrics = new LogCleanerMetrics(LogCleanerMetrics$.MODULE$.$lessinit$greater$default$1());
        Cleaner localCleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(Integer.MAX_VALUE), params.initialCompactIoBufferSize(), params.maxCompactBufferSize(), 0.75, throttler, log.localLog().time(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            MergedLogHarness$.$anonfun$initializeComponents$1(x$1);
            return BoxedUnit.UNIT;
        }, logCleanerMetrics);
        CompactionTask compactionTask = new CompactionTask(ctx, topicIdPartition, (CompactionTask.CompactionTaskState)new CompactionTask.CleanLog(leaderEpoch, (Option)None$.MODULE$), new TierCompactionMetrics(logCleanerMetrics, TierCompactionMetrics$.MODULE$.apply$default$2()));
        CopyOnWriteArrayList appendedMetadata = new CopyOnWriteArrayList();
        TierTopicAppender appender = new TierTopicAppender(log, appendedMetadata){
            private final MergedLog log$1;
            private final CopyOnWriteArrayList appendedMetadata$1;

            public CompletableFuture<TierPartitionState.AppendResult> addMetadata(AbstractTierMetadata entry) {
                TierPartitionState.AppendResult result;
                TierPartitionState.AppendResult appendResult = result = this.log$1.tierPartitionState().append(entry, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
                TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
                Predef$.MODULE$.assert(!(appendResult != null ? !appendResult.equals(appendResult2) : appendResult2 != null));
                this.appendedMetadata$1.add(entry);
                return CompletableFuture.completedFuture(result);
            }

            public boolean isReady() {
                return true;
            }
            {
                this.log$1 = log$1;
                this.appendedMetadata$1 = appendedMetadata$1;
            }
        };
        return new Tuple7((Object)tierTasksConfig, (Object)archiveTask, (Object)compactionTask, (Object)appender, appendedMetadata, (Object)replicaManager, (Object)localCleaner);
    }

    /*
     * WARNING - void declaration
     */
    public MergedLogHarness apply(TopicPartition topicPartition, LogConfig config, HarnessParams params) {
        void var38_34;
        void var37_33;
        void var36_32;
        void var35_31;
        void var34_30;
        void var33_29;
        void var32_28;
        int epoch;
        String x$6;
        String x$5;
        MockTime time = new MockTime(0L, 0L);
        MockScheduler scheduler = time.scheduler();
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        long recoveryPoint = 0L;
        long initialLogStartOffset = 0L;
        int leaderEpoch = 0;
        TierTestUtils$.MODULE$.setTierTopicOffsetAndEpoch(new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        File logDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        logDir.mkdir();
        File partitionDir = new File(logDir, topicPartition.toString());
        partitionDir.mkdir();
        TopicIdPartition tpid = new TopicIdPartition(topicPartition.topic(), UUID.randomUUID(), topicPartition.partition());
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        MockInMemoryTierObjectStoreConfig tierObjectStoreConfig = new MockInMemoryTierObjectStoreConfig(Optional.of(UUID.randomUUID().toString()), Optional.of(Predef$.MODULE$.int2Integer(0)), new StringBuilder(1).append(tpid.toString()).append("/").toString());
        Map<String, Object> crashDefinition = params.putCrashPeriod() == -1 ? Collections.emptyMap() : Collections.singletonMap("putInMemorySegment", BoxesRunTime.boxToInteger((int)params.putCrashPeriod()));
        FaultInjectedTierObjectStoreWrapper tierObjectStore = new FaultInjectedTierObjectStoreWrapper((TierObjectStore)new MockInMemoryTierObjectStore((Time)time, tierObjectStoreConfig), crashDefinition);
        TierLogComponents tierLogComponents = new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, false, true, false));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(MergedLogHarness$.$anonfun$apply$1(tpid)));
        }
        MergedLog log = MergedLog$.MODULE$.apply(partitionDir, config, initialLogStartOffset, recoveryPoint, (Scheduler)scheduler, new BrokerTopicStats(), new Metrics(), (Time)time, this.MaxTransactionTimeoutMs(), this.MaxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), logDirFailureChannel, tierLogComponents, true, (Option)None$.MODULE$, true, MergedLog$.MODULE$.apply$default$17(), MergedLog$.MODULE$.apply$default$18());
        Predef$.MODULE$.assert(log.tieredLogSegments().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> log.toString());
        log.assignTopicId(CoreUtils$.MODULE$.toKafkaUUID(tpid.topicId()), log.assignTopicId$default$2());
        if (Predef$.MODULE$.Boolean2boolean(config.confluentLogConfig().tierEnable())) {
            log.tierPartitionState().setTieringEnabled();
            MergedLogHarnessHelpers$.MODULE$.ensureTierEnabledState(log);
        }
        double x$1 = params.ioMaxBytesPerSecond();
        long x$2 = params.throttleCheckInterval();
        Time x$3 = log.localLog().time();
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        Throttler throttler = new Throttler(x$1, x$2, x$4, x$5 = Throttler$.MODULE$.$lessinit$greater$default$4(), x$6 = Throttler$.MODULE$.$lessinit$greater$default$5(), x$3);
        Tuple7<TierTasksConfig, ArchiveTask, CompactionTask, TierTopicAppender, CopyOnWriteArrayList<AbstractTierMetadata>, ReplicaManager, Cleaner> tuple7 = this.initializeComponents(log, throttler, params, epoch = 0);
        if (tuple7 == null) {
            throw new MatchError(null);
        }
        TierTasksConfig tierTasksConfig = (TierTasksConfig)tuple7._1();
        ArchiveTask archiveTask = (ArchiveTask)tuple7._2();
        CompactionTask compactionTask = (CompactionTask)tuple7._3();
        TierTopicAppender appender = (TierTopicAppender)tuple7._4();
        CopyOnWriteArrayList appendMetadata = (CopyOnWriteArrayList)tuple7._5();
        ReplicaManager replicaManager = (ReplicaManager)tuple7._6();
        Cleaner cleaner = (Cleaner)tuple7._7();
        void tierTasksConfig2 = var32_28;
        void archiveTask2 = var33_29;
        void compactionTask2 = var34_30;
        void appender2 = var35_31;
        void appendMetadata2 = var36_32;
        void replicaManager2 = var37_33;
        void cleaner2 = var38_34;
        return new MergedLogHarness(log, epoch, params, throttler, (Cleaner)cleaner2, false, (TierTasksConfig)tierTasksConfig2, (ArchiveTask)archiveTask2, (CompactionTask)compactionTask2, (TierTopicAppender)appender2, tierObjectStore, (CopyOnWriteArrayList<AbstractTierMetadata>)appendMetadata2, (ReplicaManager)replicaManager2);
    }

    public void dropFirstRecordFromSegment(FileRecords inputFileRecords, FileRecords outputFileRecords) {
        ByteBuffer buffer = ByteBuffer.allocate(inputFileRecords.sizeInBytes());
        inputFileRecords.readInto(buffer, 0);
        inputFileRecords.close();
        MemoryRecords memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
        ByteBuffer filtered = ByteBuffer.allocate(inputFileRecords.sizeInBytes());
        int toDropCount = 1;
        IntRef droppedCount = IntRef.create((int)0);
        MemoryRecords.FilterResult filterResult = memoryRecords.filterTo(new TopicPartition("dummy", 0), new MemoryRecords.RecordFilter(droppedCount, toDropCount){
            private final IntRef droppedCount$1;
            private final int toDropCount$1;

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY, true);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                if (this.droppedCount$1.elem < this.toDropCount$1) {
                    ++this.droppedCount$1.elem;
                    return false;
                }
                return true;
            }
            {
                this.droppedCount$1 = droppedCount$1;
                this.toDropCount$1 = toDropCount$1;
                super(0L, 0L);
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        Predef$.MODULE$.println((Object)new StringBuilder(18).append("read: ").append(filterResult.messagesRead()).append(", retained: ").append(filterResult.messagesRetained()).toString());
        MemoryRecords newRecords = MemoryRecords.readableRecords((ByteBuffer)filtered);
        outputFileRecords.append(newRecords);
        outputFileRecords.flush();
    }

    public static final /* synthetic */ void $anonfun$initializeComponents$1(TopicPartition x$1) {
    }

    public static final /* synthetic */ String $anonfun$apply$1(TopicIdPartition tpid$1) {
        return new StringBuilder(28).append("Creating partition for run: ").append(tpid$1).toString();
    }

    private MergedLogHarness$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MaxTransactionTimeoutMs = 300000;
        this.MaxProducerIdExpirationMs = 3600000;
        this.BrokerId = 0;
    }
}

