/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogSegments$;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u0013\u0005A\u0005\u0003\u00041\u0001\u0001\u0006I!\n\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\t\u0013\t\u0003\u0001\u0019!A!B\u0013\u0019\u0004\"B\"\u0001\t\u0013!\u0005b\u0002.\u0001#\u0003%Ia\u0017\u0005\bM\u0002\t\n\u0011\"\u0003h\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u00151\b\u0001\"\u0001k\u0011\u0015Y\b\u0001\"\u0003}\u0011\u0019\t\u0019\u0003\u0001C\u0001U\"1\u0011Q\u0006\u0001\u0005\u0002)Da!!\r\u0001\t\u0003Q\u0007BBA\u001b\u0001\u0011\u0005!\u000e\u0003\u0004\u0002:\u0001!\tA\u001b\u0002\u0010\u0019><7+Z4nK:$8\u000fV3ti*\u0011A#F\u0001\u0004Y><'\"\u0001\f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u0012\u0001\u001b\u0005\u0019\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002KA\u0011aEL\u0007\u0002O)\u0011\u0001&K\u0001\u0007G>lWn\u001c8\u000b\u0005YQ#BA\u0016-\u0003\u0019\t\u0007/Y2iK*\tQ&A\u0002pe\u001eL!aL\u0014\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0003S>T\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003{\u0001\u0003\"A\u0007 \n\u0005}Z\"\u0001B+oSRDq!Q\u0003\u0002\u0002\u0003\u00071'A\u0002yIE\nq\u0001\\8h\t&\u0014\b%A\u0007de\u0016\fG/Z*fO6,g\u000e\u001e\u000b\u0005\u000b\"k%\u000b\u0005\u0002#\r&\u0011qi\u0005\u0002\u000b\u0019><7+Z4nK:$\b\"B%\b\u0001\u0004Q\u0015AB8gMN,G\u000f\u0005\u0002\u001b\u0017&\u0011Aj\u0007\u0002\u0005\u0019>tw\rC\u0004O\u000fA\u0005\t\u0019A(\u0002%%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\t\u00035AK!!U\u000e\u0003\u0007%sG\u000fC\u0004T\u000fA\u0005\t\u0019\u0001+\u0002\tQLW.\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/\u001e\nQ!\u001e;jYNL!!\u0017,\u0003\tQKW.Z\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uII*\u0012\u0001\u0018\u0016\u0003\u001fv[\u0013A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\r\\\u0012AC1o]>$\u0018\r^5p]&\u0011Q\r\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF2sK\u0006$XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005A'F\u0001+^\u0003\u0015\u0019X\r^;q)\u0005i\u0004F\u0001\u0006m!\tiG/D\u0001o\u0015\ty\u0007/A\u0002ba&T!!\u001d:\u0002\u000f),\b/\u001b;fe*\u00111\u000fL\u0001\u0006UVt\u0017\u000e^\u0005\u0003k:\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:e_^t\u0007FA\u0006y!\ti\u00170\u0003\u0002{]\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\fCN\u001cXM\u001d;F]R\u0014\u0018\u0010F\u0002>{~DQA \u0007A\u0002\u0015\u000bqa]3h[\u0016tG\u000fC\u0004\u0002\u00021\u0001\r!a\u0001\u0002\rQ,7\u000f^3e!\u0019\t)!!\bK\u000b:!\u0011qAA\f\u001d\u0011\tI!a\u0005\u000f\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\u0018\u0003\u0019a$o\\8u}%\t\u0001(C\u0002\u0002\u0016]\nA!\u001e;jY&!\u0011\u0011DA\u000e\u0003\ri\u0015\r\u001d\u0006\u0004\u0003+9\u0014\u0002BA\u0010\u0003C\u0011Q!\u00128uefTA!!\u0007\u0002\u001c\u0005\u0019B/Z:u\u0005\u0006\u001c\u0018nY(qKJ\fG/[8og\"\u001aQ\"a\n\u0011\u00075\fI#C\u0002\u0002,9\u0014A\u0001V3ti\u0006\tB/Z:u'\u0016<W.\u001a8u\u0003\u000e\u001cWm]:)\u00079\t9#\u0001\u000euKN$8\t\\8tKN$X*\u0019;dQ>\u0003XM]1uS>t7\u000fK\u0002\u0010\u0003O\t!\u0003^3ti\"Kw\r[3s'\u0016<W.\u001a8ug\"\u001a\u0001#a\n\u0002)Q,7\u000f^*ju\u00164uN\u001d'be\u001e,Gj\\4tQ\r\t\u0012q\u0005")
public class LogSegmentsTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        return LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time, LogTestUtils$.MODULE$.createSegment$default$5());
    }

    private int createSegment$default$2() {
        return 10;
    }

    private Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.logDir());
    }

    private void assertEntry(LogSegment segment, Map.Entry<Object, LogSegment> tested) {
        Assertions.assertEquals((long)segment.baseOffset(), (long)BoxesRunTime.unboxToLong((Object)tested.getKey()));
        Assertions.assertEquals((Object)segment, (Object)tested.getValue());
    }

    @Test
    public void testBasicOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        int offset1 = 40;
        LogSegment seg1 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        int offset2 = 80;
        LogSegment seg2 = this.createSegment(offset2, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        segments.add(seg1);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.get((long)offset1));
        segments.add(seg2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset2));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.get((long)offset2));
        segments.add(seg3);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals((Object)new Some((Object)seg3), (Object)segments.get((long)offset1));
        segments.remove((long)offset2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset2));
        segments.clear();
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)0, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset1));
        segments.close();
    }

    @Test
    public void testSegmentAccess() {
        LogSegments segments = new LogSegments(this.topicPartition());
        int offset1 = 1;
        LogSegment seg1 = this.createSegment(offset1, this.createSegment$default$2(), this.createSegment$default$3());
        int offset2 = 2;
        LogSegment seg2 = this.createSegment(offset2, this.createSegment$default$2(), this.createSegment$default$3());
        int offset3 = 3;
        LogSegment seg3 = this.createSegment(offset3, this.createSegment$default$2(), this.createSegment$default$3());
        int offset4 = 4;
        LogSegment seg4 = this.createSegment(offset4, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)seg -> {
            LogSegmentsTest.$anonfun$testSegmentAccess$1(this, segments, seg1, seg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{offset1, offset2, offset3, offset4})), (Object)segments.baseOffsets());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))), (Object)segments.values().toSeq());
        Assertions.assertThrows(IllegalArgumentException.class, () -> segments.values(2L, 1L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)segments.values(1L, 1L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)Nil$.MODULE$), (Object)segments.values(1L, 2L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)Nil$.MODULE$)), (Object)segments.values(1L, 3L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$))), (Object)segments.values(1L, 4L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$)), (Object)segments.values(2L, 4L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg3, (List)Nil$.MODULE$), (Object)segments.values(3L, 4L).toSeq());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)segments.values(4L, 4L).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg4, (List)Nil$.MODULE$), (Object)segments.values(4L, 5L).toSeq());
        segments.close();
    }

    @Test
    public void testClosestMatchOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg2 = this.createSegment(3L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(5L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg4 = this.createSegment(7L, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)segment -> segments.add(segment));
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.floorSegment(2L));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.floorSegment(3L));
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.lowerSegment(3L));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.lowerSegment(4L));
        Assertions.assertEquals((Object)new Some((Object)seg3), (Object)segments.higherSegment(4L));
        this.assertEntry(seg3, (Map.Entry)segments.higherEntry(4L).get());
        Assertions.assertEquals((Object)new Some((Object)seg4), (Object)segments.higherSegment(5L));
        this.assertEntry(seg4, (Map.Entry)segments.higherEntry(5L).get());
        Assertions.assertEquals((Object)new Some((Object)seg1), (Object)segments.nextLogSegment(this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3())));
        Assertions.assertEquals((Object)new Some((Object)seg2), (Object)segments.nextLogSegment(seg1));
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)segments.nextLogSegment(seg4));
        segments.close();
    }

    @Test
    public void testHigherSegments() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg2 = this.createSegment(3L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg3 = this.createSegment(5L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg4 = this.createSegment(7L, this.createSegment$default$2(), this.createSegment$default$3());
        LogSegment seg5 = this.createSegment(9L, this.createSegment$default$2(), this.createSegment$default$3());
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)segment -> segments.add(segment));
        Iterator iterator = segments.higherSegments(0L).iterator();
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$2(iterator, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = segments.higherSegments(1L).iterator();
        new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$3(iterator2, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = segments.higherSegments(8L).iterator();
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((Object)seg5, (Object)iterator3.next());
        Assertions.assertFalse((boolean)iterator3.hasNext());
        Assertions.assertFalse((boolean)segments.higherSegments(9L).iterator().hasNext());
    }

    @Test
    public void testSizeForLargeLogs() {
        long largeSize = (long)Integer.MAX_VALUE * 2L;
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)LogSegments$.MODULE$.sizeInBytes((Iterable)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$)));
        Assertions.assertEquals((long)largeSize, (long)LogSegments$.MODULE$.sizeInBytes((Iterable)new .colon.colon((Object)logSegment, (List)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$))));
        Assertions.assertTrue((MergedLog$.MODULE$.sizeInBytes((Iterable)new .colon.colon((Object)logSegment, (List)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$))) > Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentAccess$1(LogSegmentsTest $this, LogSegments segments$1, LogSegment seg1$1, LogSegment seg) {
        segments$1.add(seg);
        $this.assertEntry(seg1$1, (Map.Entry)segments$1.firstEntry().get());
        Assertions.assertEquals((Object)new Some((Object)seg1$1), (Object)segments$1.firstSegment());
        $this.assertEntry(seg, (Map.Entry)segments$1.lastEntry().get());
        Assertions.assertEquals((Object)new Some((Object)seg), (Object)segments$1.lastSegment());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$2(Iterator iterator$1, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Assertions.assertEquals((Object)segment, (Object)iterator$1.next());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$3(Iterator iterator$2, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$2.hasNext());
        Assertions.assertEquals((Object)segment, (Object)iterator$2.next());
    }
}

