/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import kafka.api.ApiVersion;
import kafka.log.AbstractLog;
import kafka.log.CleanerConfig;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.log.TimeIndex;
import kafka.server.AbstractFetchDataInfo;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.directory.api.util.FileUtils;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001\u0002!B\u0001\u0019CQ!\u0014\u0001\u0005\u00029Cq!\u0015\u0001C\u0002\u0013\u0005!\u000b\u0003\u0004Z\u0001\u0001\u0006Ia\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001\\\u0011\u0019y\u0006\u0001)A\u00059\"9\u0001\r\u0001b\u0001\n\u0003Y\u0006BB1\u0001A\u0003%A\fC\u0004c\u0001\t\u0007I\u0011A2\t\r1\u0004\u0001\u0015!\u0003e\u0011\u001di\u0007A1A\u0005\u00029DaA\u001d\u0001!\u0002\u0013y\u0007bB:\u0001\u0001\u0004%\t\u0001\u001e\u0005\bw\u0002\u0001\r\u0011\"\u0001}\u0011\u001d\t)\u0001\u0001Q!\nUD\u0011\"a\u0002\u0001\u0001\u0004%\t!!\u0003\t\u0013\u0005E\u0001\u00011A\u0005\u0002\u0005M\u0001\u0002CA\f\u0001\u0001\u0006K!a\u0003\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\b\t\u0013\u0005-\u0002A1A\u0005\u0002\u00055\u0002\u0002CA\u001b\u0001\u0001\u0006I!a\f\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011Q\u000b\u0001\u0005\u0002\u0005e\u0002bBA0\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003S\u0002A\u0011AA\u001d\u0011\u001d\ti\u0007\u0001C\u0001\u0003sAq!!\u001d\u0001\t\u0003\tI\u0004C\u0004\u0002v\u0001!\t!!\u000f\t\u000f\u0005e\u0004\u0001\"\u0003\u0002|!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005e\u0002bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003o\u0003A\u0011AA\u001d\u0011\u001d\tY\f\u0001C\u0001\u0003sAq!a0\u0001\t\u0003\tI\u0004C\u0004\u0002D\u0002!\t!!\u000f\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\"9\u00111\u001d\u0001\u0005\u0002\u0005e\u0002bBAt\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003W\u0004A\u0011AA\u001d\u0011\u001d\ty\u000f\u0001C\u0001\u0003sAq!a=\u0001\t\u0003\tI\u0004C\u0004\u0002x\u0002!\t!!\u000f\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!1\u0006\u0001\u0005\n\t5\u0002\"\u0003B*\u0001E\u0005I\u0011\u0002B+\u0011%\u0011Y\u0007AI\u0001\n\u0013\u0011i\u0007C\u0005\u0003r\u0001\t\n\u0011\"\u0003\u0003t!9!q\u000f\u0001\u0005\u0002\u0005e\u0002b\u0002B>\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0005\u007f\u0002A\u0011AA\u001d\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005\u000bC\u0011Ba(\u0001#\u0003%IA!)\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002:!9!\u0011\u0016\u0001\u0005\u0002\u0005e\u0002b\u0002BW\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0005c\u0003A\u0011AA\u001d\u0011\u001d\u0011)\f\u0001C\u0001\u0003sAqA!/\u0001\t\u0003\tI\u0004C\u0004\u0003>\u0002!\tAa0\t\u000f\t%\u0007\u0001\"\u0003\u0003L\"9!q\u001a\u0001\u0005\u0002\u0005e\u0002b\u0002Bj\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0005/\u0004A\u0011AA\u001d\u00059aunZ'b]\u0006<WM\u001d+fgRT!AQ\"\u0002\u00071|wMC\u0001E\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A$\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\n\u0005\u0002Q\u00015\t\u0011)\u0001\u0003uS6,W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u001b\u0015!B;uS2\u001c\u0018B\u0001-V\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aD7bqJ{G\u000e\\%oi\u0016\u0014h/\u00197\u0016\u0003q\u0003\"\u0001S/\n\u0005yK%aA%oi\u0006\u0001R.\u0019=S_2d\u0017J\u001c;feZ\fG\u000eI\u0001\f[\u0006DHj\\4BO\u0016l5/\u0001\u0007nCbdunZ!hK6\u001b\b%\u0001\u0005m_\u001e\u0004&o\u001c9t+\u0005!\u0007CA3k\u001b\u00051'BA4i\u0003\u0011)H/\u001b7\u000b\u0003%\fAA[1wC&\u00111N\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00037pOB\u0013x\u000e]:!\u0003%awnZ\"p]\u001aLw-F\u0001p!\t\u0001\u0006/\u0003\u0002r\u0003\nIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013A\u00027pO\u0012K'/F\u0001v!\t1\u00180D\u0001x\u0015\tA\b.\u0001\u0002j_&\u0011!p\u001e\u0002\u0005\r&dW-\u0001\u0006m_\u001e$\u0015N]0%KF$2!`A\u0001!\tAe0\u0003\u0002\u0000\u0013\n!QK\\5u\u0011!\t\u0019!DA\u0001\u0002\u0004)\u0018a\u0001=%c\u00059An\\4ESJ\u0004\u0013A\u00037pO6\u000bg.Y4feV\u0011\u00111\u0002\t\u0004!\u00065\u0011bAA\b\u0003\nQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR\u0019Q0!\u0006\t\u0013\u0005\r\u0001#!AA\u0002\u0005-\u0011a\u00037pO6\u000bg.Y4fe\u0002\nAA\\1nKV\u0011\u0011Q\u0004\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u00055\u0002\t1\fgnZ\u0005\u0005\u0003O\t\tC\u0001\u0004TiJLgnZ\u0001\u0006]\u0006lW\rI\u0001\u001am\u0016\u0014\u0018\u0010T1sO\u0016dun\u001a$mkND\u0017J\u001c;feZ\fG.\u0006\u0002\u00020A\u0019\u0001*!\r\n\u0007\u0005M\u0012J\u0001\u0003M_:<\u0017A\u0007<fefd\u0015M]4f\u0019><g\t\\;tQ&sG/\u001a:wC2\u0004\u0013!B:fiV\u0003H#A?)\u0007Y\ti\u0004\u0005\u0003\u0002@\u0005ESBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002H\u0005%\u0013a\u00026va&$XM\u001d\u0006\u0005\u0003\u0017\ni%A\u0003kk:LGO\u0003\u0002\u0002P\u0005\u0019qN]4\n\t\u0005M\u0013\u0011\t\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007]\tI\u0006\u0005\u0003\u0002@\u0005m\u0013\u0002BA/\u0003\u0003\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u001bQ,7\u000f^\"sK\u0006$X\rT8hQ\rA\u00121\r\t\u0005\u0003\u007f\t)'\u0003\u0003\u0002h\u0005\u0005#\u0001\u0002+fgR\fA\u0005^3ti\"\u000bg\u000e\u001a7j]\u001e,\u0005pY3qi&|gn\u001d#ve&twm\u00155vi\u0012|wO\u001c\u0015\u00043\u0005\r\u0014A\b;fgR\u001c%/Z1uK2{wmV5uQ&sg/\u00197jI2{w\rR5sQ\rQ\u00121M\u0001 i\u0016\u001cHo\u0011:fCR,Gj\\4XSRDGj\\4ESJ4\u0015\r\u001c7cC\u000e\\\u0007fA\u000e\u0002d\u0005)B/Z:u\u000f\u0016$hj\u001c8Fq&\u001cH/\u001a8u\u0019><\u0007f\u0001\u000f\u0002d\u0005\u0011#/Z2p]\u001aLw-\u001e:f\u001b\u0006D8+Z4nK:$H)\u001a7fi\u0016$\u0007+\u001a:Sk:$2!`A?\u0011\u0019\ty(\ba\u00019\u0006aBn\\4EK2,G/[8o\u001b\u0006D8+Z4nK:$8\u000fU3s%Vt\u0017a\f;fgRdun\u001a#fY\u0016$\u0018n\u001c8NCb\u001cVmZ7f]R\u001c\b+\u001a:Sk:,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\bf\u0001\u0010\u0002d\u00051E/Z:u\u0019><G)\u001a7fi&|g.T1y'\u0016<W.\u001a8ugB+'OU;o\u00032|gnZ,ji\"$\u0016.\u001a:TK\u001elWM\u001c;I_R\u001cX\r\u001e*pY2l\u0015N\u001c\"zi\u0016\u001cHcA?\u0002\n\"9\u00111R\u0010A\u0002\u00055\u0015aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0011\u0007!\u000by)C\u0002\u0002\u0012&\u0013qAQ8pY\u0016\fg\u000eK\u0004 \u0003+\u000b)+a*\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002 \u0006\u0015\u0013A\u00029be\u0006l7/\u0003\u0003\u0002$\u0006e%a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003S\u000bY+G\u0001\u00023\u0005\u0001\u0001fA\u0010\u00020B!\u0011\u0011WAZ\u001b\t\ti*\u0003\u0003\u00026\u0006u%!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006QB/Z:u\u00072,\u0017M\\;q\u000bb\u0004\u0018N]3e'\u0016<W.\u001a8ug\"\u001a\u0001%a\u0019\u0002CQ,7\u000f^\"mK\u0006tW\u000f]*fO6,g\u000e^:U_6\u000b\u0017N\u001c;bS:\u001c\u0016N_3)\u0007\u0005\n\u0019'\u0001\u0016uKN$Hi\\3t]R\u001cE.Z1o\u0019><7oV5uQ\u000e{W\u000e]1di\u0012+G.\u001a;f!>d\u0017nY=)\u0007\t\n\u0019'\u0001\u0013uKN$Hi\\3t]R\u001cE.Z1o\u0019><7oV5uQ\u000e{W\u000e]1diB{G.[2zQ\r\u0019\u00131M\u0001\u0014i\u0016\u001cH\u000fR8fg:$8\t\\3b]2{wm\u001d\u000b\u0004{\u0006-\u0007bBAgI\u0001\u0007\u0011qZ\u0001\u0007a>d\u0017nY=\u0011\t\u0005E\u0017q\u001c\b\u0005\u0003'\fY\u000eE\u0002\u0002V&k!!a6\u000b\u0007\u0005eW)\u0001\u0004=e>|GOP\u0005\u0004\u0003;L\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0005\u0005(bAAo\u0013\u0006\u0011B/Z:u)&lWMQ1tK\u00124E.^:iQ\r)\u00131M\u0001\u001ai\u0016\u001cH\u000fT3bgRdu.\u00193fI\u0006\u001b8/[4o[\u0016tG\u000fK\u0002'\u0003G\n1\u0005^3tiR;x\u000eT8h\u001b\u0006t\u0017mZ3sgV\u001b\u0018N\\4TC6,G)\u001b:GC&d7\u000fK\u0002(\u0003G\nA\u0004^3ti\u000eCWmY6q_&tGOU3d_Z,'/\u001f)pS:$8\u000fK\u0002)\u0003G\nQ\u0006^3tiJ+7m\u001c<fef$\u0015N]3di>\u0014\u00180T1qa&twmV5uQR\u0013\u0018-\u001b7j]\u001e\u001cF.Y:iQ\rI\u00131M\u00012i\u0016\u001cHOU3d_Z,'/\u001f#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8h/&$\bNU3mCRLg/\u001a#je\u0016\u001cGo\u001c:zQ\rQ\u00131M\u0001\u0019m\u0016\u0014\u0018NZ=DQ\u0016\u001c7\u000e]8j]R\u0014VmY8wKJLHcB?\u0002\u0000\n\u001d\"\u0011\u0006\u0005\b\u0005\u0003Y\u0003\u0019\u0001B\u0002\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B\u0003\u0005\u001f\u0011)B\u0004\u0003\u0003\b\t-a\u0002BAk\u0005\u0013I\u0011AS\u0005\u0004\u0005\u001bI\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005#\u0011\u0019BA\u0002TKFT1A!\u0004J!\u0011\u00119Ba\t\u000e\u0005\te!\u0002\u0002B\u000e\u0005;\taaY8n[>t'b\u0001#\u0003 )!!\u0011EA'\u0003\u0019\t\u0007/Y2iK&!!Q\u0005B\r\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a\u0002,\u0001\u0004\tY\u0001C\u0003tW\u0001\u0007Q/\u0001\tde\u0016\fG/\u001a'pO6\u000bg.Y4feRA\u00111\u0002B\u0018\u0005k\u0011I\u0005C\u0005\u000321\u0002\n\u00111\u0001\u00034\u00059An\\4ESJ\u001c\b#\u0002B\u0003\u0005\u001f)\b\"\u0003B\u001cYA\u0005\t\u0019\u0001B\u001d\u0003A\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0003\u0003<\t\u0015SB\u0001B\u001f\u0015\u0011\u0011yD!\u0011\u0002\u00115,G/\u00193bi\u0006T1Aa\u0011D\u0003\u0019\u0019XM\u001d<fe&!!q\tB\u001f\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010C\u0005\u0003L1\u0002\n\u00111\u0001\u0003N\u0005\tB/[3s\u0019><7i\\7q_:,g\u000e^:\u0011\u0007A\u0013y%C\u0002\u0003R\u0005\u0013\u0011\u0003V5fe2{wmQ8na>tWM\u001c;t\u0003i\u0019'/Z1uK2{w-T1oC\u001e,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119F\u000b\u0003\u00034\te3F\u0001B.!\u0011\u0011iFa\u001a\u000e\u0005\t}#\u0002\u0002B1\u0005G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015\u0014*\u0001\u0006b]:|G/\u0019;j_:LAA!\u001b\u0003`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\r\u0014X-\u0019;f\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t=$\u0006\u0002B\u001d\u00053\n!d\u0019:fCR,Gj\\4NC:\fw-\u001a:%I\u00164\u0017-\u001e7uIM*\"A!\u001e+\t\t5#\u0011L\u0001#i\u0016\u001cHOR5mKJ+g-\u001a:f]\u000e,7/\u00114uKJ\f5/\u001f8d\t\u0016dW\r^3)\u0007A\n\u0019'\u0001\u0012uKN$8I]3bi\u0016\fe\u000e\u001a#fY\u0016$Xm\u0014<fe2LHj\u001c8h)>\u0004\u0018n\u0019\u0015\u0004c\u0005\r\u0014!\t;fgR\u001c\u0005.Z2la>Lg\u000e\u001e$pe>sG._!gM\u0016\u001cG/\u001a3M_\u001e\u001c\bf\u0001\u001a\u0002d\u00059!/Z1e\u0019><G\u0003\u0003BD\u0005\u001f\u00139Ja'\u0011\t\t%%1R\u0007\u0003\u0005\u0003JAA!$\u0003B\tia)\u001a;dQ\u0012\u000bG/Y%oM>DaAQ\u001aA\u0002\tE\u0005c\u0001)\u0003\u0014&\u0019!QS!\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u00053\u001b\u0004\u0019AA\u0018\u0003\u0019ygMZ:fi\"A!QT\u001a\u0011\u0002\u0003\u0007A,A\u0005nCbdUM\\4uQ\u0006\t\"/Z1e\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\r&f\u0001/\u0003Z\u0005)C/Z:u)>\u0004\u0018nY\"p]\u001aLwm\u00115b]\u001e,W\u000b\u001d3bi\u0016\u001cHj\\4D_:4\u0017n\u001a\u0015\u0004k\u0005\r\u0014!\b;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f\u000f\u0016$8o\u00117fC:,G-\u00169)\u0007Y\n\u0019'\u0001\u0015uKN$(I]8lKJ\u001cuN\u001c4jO\u000eC\u0017M\\4f\t\u0016d\u0017N^3sK\u0012$v.\u00117m\u0019><7\u000fK\u00028\u0003G\n1\u0007^3tiR{\u0007/[2D_:4\u0017nZ\"iC:<Wm\u0015;pa\u000ecW-\u00198j]\u001eLemQ8na\u0006\u001cG/S:SK6|g/\u001a3)\u0007a\n\u0019'\u0001\u0017uKN$8i\u001c8gS\u001e\u001c\u0005.\u00198hKN<\u0016\u000e\u001e5O_2{wmR3ui&tw-\u00138ji&\fG.\u001b>fI\"\u001a\u0011(a\u0019\u0002=Q,7\u000f^\"iK\u000e\\\u0007o\\5oiRKWM]*uCR,g)Y5mkJ,\u0007f\u0001\u001e\u0002d\u00051C/Z:u\t\u0016dW\r^3B]\u0012$\u0016.\u001a:Ti\u0006$XM\u00127vg\"\u001cuN\\2veJ,gnY=\u0015\u0007u\u0014\t\rC\u0004\u0002\fn\u0002\r!!$)\u000fm\n)*!*\u0003F2\"\u0011\u0011VAVQ\rY\u0014qV\u0001\u0019i&,'/\u00128bE2,G\rT8h\u0007>l\u0007o\u001c8f]R\u001cH\u0003\u0002B'\u0005\u001bDq!a#=\u0001\u0004\ti)\u0001\u0019uKN$X*\u001a;sS\u000e\u001cX\t_5ti^CWM\u001c'pO&\u001b(+Z2sK\u0006$X\r\u001a\"fM>\u0014X\rR3mKRLwN\u001c\u0015\u0004{\u0005\r\u0014!\r;fgRlU\r\u001e:jGN\f%/\u001a*f[>4X\rZ,iK:luN^5oO\u000e+(O]3oiR{g)\u001e;ve\u0016dun\u001a\u0015\u0004}\u0005\r\u0014\u0001\u0007;fgR<\u0016-\u001b;G_J\fE\u000e\u001c+p\u0007>l\u0007\u000f\\3uK\"\u001aq(a\u0019")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
    }

    @AfterEach
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        if (this.logManager() != null) {
            this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LogManagerTest.$anonfun$tearDown$1(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        Assertions.assertEquals((int)1, (int)this.logManager().liveLogDirs().size());
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testHandlingExceptionsDuringShutdown() {
        File logDir1 = TestUtils$.MODULE$.tempDir();
        File logDir2 = TestUtils$.MODULE$.tempDir();
        Option logManagerForTest = Option$.MODULE$.empty();
        try {
            logManagerForTest = new Some((Object)this.createLogManager((Seq<File>)new .colon.colon((Object)logDir1, (List)new .colon.colon((Object)logDir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3()));
            Assertions.assertEquals((int)2, (int)((LogManager)logManagerForTest.get()).liveLogDirs().size());
            ((LogManager)logManagerForTest.get()).startup((Set)Predef$.MODULE$.Set().empty());
            LogManager qual$1 = (LogManager)logManagerForTest.get();
            TopicPartition x$1 = new TopicPartition(this.name(), 0);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            AbstractLog log1 = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            LogManager qual$2 = (LogManager)logManagerForTest.get();
            TopicPartition x$5 = new TopicPartition(this.name(), 1);
            None$ x$6 = None$.MODULE$;
            boolean x$7 = qual$2.getOrCreateLog$default$2();
            boolean x$8 = qual$2.getOrCreateLog$default$3();
            AbstractLog log2 = qual$2.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
            File logFile1 = new File(logDir1, new StringBuilder(2).append(this.name()).append("-0").toString());
            Assertions.assertTrue((boolean)logFile1.exists());
            Assertions.assertTrue((boolean)new File(logDir2, new StringBuilder(2).append(this.name()).append("-1").toString()).exists());
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log1.takeProducerSnapshot();
            log1.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test1".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log1.appendAsLeader$default$3(), log1.appendAsLeader$default$4(), log1.appendAsLeader$default$5());
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            log2.takeProducerSnapshot();
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test2".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3(), log2.appendAsLeader$default$4(), log2.appendAsLeader$default$5());
            FileUtils.deleteDirectory((File)logFile1);
            ((LogManager)logManagerForTest.get()).shutdown();
            Assertions.assertFalse((boolean)Files.exists(new File(logDir1, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
            Assertions.assertTrue((boolean)Files.exists(new File(logDir2, LogLoader$.MODULE$.CleanShutdownFile()).toPath(), new LinkOption[0]));
        }
        finally {
            logManagerForTest.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$1(manager);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$2, x$4, (Option)x$3);
        Assertions.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCreateLogWithLogDirFallback() {
        IndexedSeq dirs = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile(), IndexedSeq$.MODULE$.canBuildFrom());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3())));
        scala.collection.mutable.Set brokenDirs = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = new TopicPartition(this.name(), 0);
        boolean x$22 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$12, x$22, x$4, (Option)x$3);
        Assertions.assertEquals((int)(dirs.length() / 2), (int)brokenDirs.size());
        Function1 & Serializable & scala.Serializable containsLogFile = (Function1 & Serializable & scala.Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$4(this, dir));
        Assertions.assertEquals((int)1, (int)dirs.count((Function1)containsLogFile), (String)"More than one log file created");
        Assertions.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log, (String)"No log should be found.");
        Assertions.assertFalse((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
    }

    private void reconfigureMaxSegmentDeletedPerRun(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = LogManagerTest.kafkaConfigWithCleanerConfig$1(this.logManager().maxSegmentsDeletedPerRun());
        KafkaConfig newConfig = LogManagerTest.kafkaConfigWithCleanerConfig$1(logDeletionMaxSegmentsPerRun);
        this.logManager().reconfigure(oldConfig, newConfig);
    }

    @Test
    public void testLogDeletionMaxSegmentsPerRunExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$32 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$32, x$4, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            byte[] x$5 = "test".getBytes();
            long x$6 = this.time().milliseconds() - (long)this.maxLogAgeMs() - 1L;
            byte[] x$7 = TestUtils$.MODULE$.singletonRecords$default$2();
            CompressionType x$8 = TestUtils$.MODULE$.singletonRecords$default$3();
            byte x$9 = TestUtils$.MODULE$.singletonRecords$default$5();
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords(x$5, x$7, x$8, x$6, x$9);
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$1.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        int numSegments = log.numberOfSegments();
        this.reconfigureMaxSegmentDeletedPerRun(0);
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunExpiredSegments$2(this, x$3)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"No segment should be deleted.");
        this.reconfigureMaxSegmentDeletedPerRun(log.numberOfSegments());
        this.time().sleep(this.logManager().retentionCheckMs() + 1L);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes(boolean checksumEnabled) {
        this.logManager().shutdown();
        int recordSize = this.createRecords$1().sizeInBytes();
        long tierLocalHotsetMs = 36000L;
        int tierSegmentHotsetRollMinBytes = 5 * recordSize;
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(10 * recordSize));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierSegmentHotsetRollMinBytesProp(), Integer.toString(tierSegmentHotsetRollMinBytes));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierLocalHotsetMsProp(), Long.toString(tierLocalHotsetMs));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.SegmentMsProp(), Long.toString(Long.MAX_VALUE));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(Long.MAX_VALUE));
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        TierLogComponents x$1 = this.tierEnabledLogComponents(checksumEnabled);
        Seq<File> x$3 = this.createLogManager$default$1();
        this.logManager_$eq(this.createLogManager(x$3, configRepository, x$1));
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        AbstractLog log1 = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        LogManager qual$2 = this.logManager();
        TopicPartition x$8 = new TopicPartition(this.name(), 1);
        None$ x$9 = None$.MODULE$;
        boolean x$10 = qual$2.getOrCreateLog$default$2();
        boolean x$11 = qual$2.getOrCreateLog$default$3();
        AbstractLog log2 = qual$2.getOrCreateLog(x$8, x$10, x$11, (Option)x$9);
        log1.assignTopicId(Uuid.randomUuid(), log1.assignTopicId$default$2());
        log2.assignTopicId(Uuid.randomUuid(), log2.assignTopicId$default$2());
        Assertions.assertTrue((boolean)log1.tierPartitionState().isTieringEnabled());
        Assertions.assertTrue((boolean)log2.tierPartitionState().isTieringEnabled());
        new .colon.colon((Object)log1, (List)new .colon.colon((Object)log2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)log -> {
            log.tierPartitionState().onCatchUpComplete();
            return log.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader((TopicIdPartition)log.topicIdPartition().get(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 25).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$2(this, log1, log2, BoxesRunTime.unboxToInt((Object)_)));
        Assertions.assertTrue((log1.numberOfSegments() == 3 ? 1 : 0) != 0, (String)"There should be 3 segments now.");
        Assertions.assertTrue((log2.numberOfSegments() == 3 ? 1 : 0) != 0, (String)"There should be 3 segments now.");
        log1.updateHighWatermark(log1.logEndOffset());
        log2.updateHighWatermark(log2.logEndOffset());
        new .colon.colon((Object)log1, (List)new .colon.colon((Object)log2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$3(log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)2, (int)log1.tieredLogSegments().size());
        Assertions.assertEquals((int)2, (int)log2.tieredLogSegments().size());
        this.reconfigureMaxSegmentDeletedPerRun(1);
        this.time().sleep(tierLocalHotsetMs + 1L);
        this.logManager().cleanupLogsAndMaybeForceRoll();
        Assertions.assertTrue((log1.localLogSegments().size() == 3 && log2.localLogSegments().size() == 4 || log1.localLogSegments().size() == 4 && log2.localLogSegments().size() == 3 ? 1 : 0) != 0, (String)"Should have 1 segment removed from either of the 2 logs");
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$42 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$1, x$3, x$42, (Option)x$2);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$2.elem = info.lastOffset();
        });
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.updateHighWatermark(log.logEndOffset());
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$2(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)1, (int)log.numberOfSegments(), (String)"Now there should only be only one segment in the index.");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()), () -> "Should get exception from fetching earlier.");
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes();
        this.logManager().shutdown();
        int segmentBytes = 10 * setSize;
        Properties properties = new Properties();
        properties.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentBytes));
        properties.put(LogConfig$.MODULE$.RetentionBytesProp(), Long.toString(50L * (long)setSize + 10L));
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), properties);
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        LongRef offset = LongRef.create((long)0L);
        int numMessages = 200;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$3.elem = ((LogOffsetMetadata)info.firstOffset().get()).messageOffset();
        });
        log.updateHighWatermark(log.logEndOffset());
        Assertions.assertEquals((int)(numMessages * setSize / segmentBytes), (int)log.numberOfSegments(), (String)"Check we have the expected number of segments.");
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertEquals((int)6, (int)log.numberOfSegments(), (String)"Now there should be exactly 6 segments");
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().fileDeleteDelayMs()) + 1L);
        Assertions.assertEquals((int)(log.numberOfSegments() * 4 + 1), (int)log.dir().list().length, (String)"Files should have been deleted");
        Assertions.assertEquals((int)0, (int)this.readLog(log, offset.elem + 1L, this.readLog$default$3()).records().sizeInBytes(), (String)"Should get empty fetch off new log.");
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> this.readLog(log, 0L, this.readLog$default$3()));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$52 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$52);
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
            LogAppendInfo info = log.appendAsLeader(set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
            offset$4.elem = info.lastOffset();
        });
        int numSegments = log.numberOfSegments();
        Assertions.assertTrue((log.numberOfSegments() > 1 ? 1 : 0) != 0, (String)"There should be more than one segment now.");
        log.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$2(this, x$5)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assertions.assertEquals((int)numSegments, (int)log.numberOfSegments(), (String)"number of segments shouldn't have changed");
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        MockConfigRepository configRepository = MockConfigRepository$.MODULE$.forTopic(this.name(), LogConfig$.MODULE$.FlushMsProp(), "1000");
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, configRepository, x$3));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager qual$1 = this.logManager();
        TopicPartition x$4 = new TopicPartition(this.name(), 0);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = qual$1.getOrCreateLog$default$2();
        boolean x$7 = qual$1.getOrCreateLog$default$3();
        AbstractLog log = qual$1.getOrCreateLog(x$4, x$6, x$7, (Option)x$5);
        long lastFlush = log.lastFlushTime();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach((Function1 & Serializable & scala.Serializable)_ -> LogManagerTest.$anonfun$testTimeBasedFlush$1(log, BoxesRunTime.unboxToInt((Object)_)));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((lastFlush != log.lastFlushTime() ? 1 : 0) != 0, (String)"Time based flush should have been triggered");
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)dirs, this.createLogManager$default$2(), this.createLogManager$default$3()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            LogManager qual$1 = this.logManager();
            TopicPartition x$1 = new TopicPartition("test", partition);
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            Assertions.assertEquals((int)(partition + 1), (int)this.logManager().allLogs().size(), (String)"We should have created the right number of logs");
            Iterable counts = (Iterable)this.logManager().allLogs().groupBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.dir().getParent()).values().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom());
            Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0, (String)"Load should balance evenly");
        });
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        Assertions.assertThrows(KafkaException.class, () -> this.createLogManager(this.createLogManager$default$1(), this.createLogManager$default$2(), this.createLogManager$default$3()));
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.verifyCheckpointRecovery((Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        Seq logs = (Seq)topicPartitions.map((Function1 & Serializable & scala.Serializable)x$8 -> {
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$8, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$2(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)topicPartitions.zip((GenIterable)logs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(Seq<File> logDirs, ConfigRepository configRepository, TierLogComponents tierLogComponents) {
        LogConfig x$1 = this.logConfig();
        MockTime x$4 = this.time();
        CleanerConfig x$6 = TestUtils$.MODULE$.createLogManager$default$4();
        ApiVersion x$7 = TestUtils$.MODULE$.createLogManager$default$6();
        return TestUtils$.MODULE$.createLogManager(logDirs, x$1, configRepository, x$6, x$4, x$7, tierLogComponents);
    }

    private Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    private ConfigRepository createLogManager$default$2() {
        return new MockConfigRepository();
    }

    private TierLogComponents createLogManager$default$3() {
        return TierLogComponents$.MODULE$.EMPTY();
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] indexFilesOnDiskBeforeDelete = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])activeSegment.log().file().getParentFile().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$1(x$10)));
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Option x$8 = qual$2.asyncDelete$default$4();
        AbstractLog removedLog = (AbstractLog)qual$2.asyncDelete(x$5, x$6, x$7, x$8).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assertions.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFilesOnDiskBeforeDelete)).foreach(arg_0 -> LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2$adapted((Seq)indexFilesAfterDelete, arg_0));
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assertions.assertTrue((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs deleted too early");
        this.time().sleep(Predef$.MODULE$.Long2long(this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assertions.assertFalse((boolean)this.logManager().hasLogsToBeDeleted(), (String)"Logs not deleted");
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Option x$8 = qual$2.asyncDelete$default$4();
        qual$2.asyncDelete(x$5, x$6, x$7, x$8);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        Seq allLogs = (Seq)tps.map((Function1 & Serializable & scala.Serializable)x$13 -> {
            LogManager qual$1 = this.logManager();
            None$ x$2 = None$.MODULE$;
            boolean x$3 = qual$1.getOrCreateLog$default$2();
            boolean x$4 = qual$1.getOrCreateLog$default$3();
            return qual$1.getOrCreateLog(x$13, x$3, x$4, (Option)x$2);
        }, Seq$.MODULE$.canBuildFrom());
        allLogs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$2(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsInDir(this.logDir());
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
        ((IterableLike)tps.zip((GenIterable)allLogs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$4(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(AbstractLog log, long offset, int maxLength) {
        AbstractFetchDataInfo abstractFetchDataInfo = log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
        if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
            throw new IllegalStateException(new StringBuilder(18).append("Unexpected result ").append(abstractFetchDataInfo).toString());
        }
        FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
        return fetchDataInfo;
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.topicConfigUpdated(testTopicOne);
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicOnePartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)testTopicTwoPartition), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicTwo);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        spyLogManager.initializingLog(testTopicPartition);
        spyLogManager.finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.never())).topicConfig(testTopicPartition.topic());
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)new MockConfigRepository());
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, spyConfigRepository, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        MergedLog mockLog = (MergedLog)Mockito.mock(MergedLog.class);
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        spyLogManager.initializingLog(testTopicOnePartition);
        spyLogManager.initializingLog(testTopicTwoPartition);
        spyLogManager.brokerConfigUpdated();
        spyLogManager.finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog));
        spyLogManager.finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog));
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicOne);
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(testTopicTwo);
    }

    @Test
    public void testTopicConfigChangeStopCleaningIfCompactIsRemoved() {
        this.logManager().shutdown();
        MockConfigRepository x$1 = new MockConfigRepository();
        Seq<File> x$2 = this.createLogManager$default$1();
        TierLogComponents x$3 = this.createLogManager$default$3();
        this.logManager_$eq(this.createLogManager(x$2, x$1, x$3));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        String topic = "topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Properties oldProperties = new Properties();
        oldProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig oldLogConfig = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), oldProperties);
        None$ x$5 = None$.MODULE$;
        boolean x$6 = spyLogManager.getOrCreateLog$default$2();
        boolean x$7 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log0 = spyLogManager.getOrCreateLog(tp0, x$6, x$7, (Option)x$5);
        log0.updateConfig(oldLogConfig);
        None$ x$9 = None$.MODULE$;
        boolean x$10 = spyLogManager.getOrCreateLog$default$2();
        boolean x$11 = spyLogManager.getOrCreateLog$default$3();
        AbstractLog log1 = spyLogManager.getOrCreateLog(tp1, x$10, x$11, (Option)x$9);
        log1.updateConfig(oldLogConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractLog[]{log0, log1})), (Object)spyLogManager.logsByTopic(topic).toSet());
        Properties newProperties = new Properties();
        newProperties.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        spyLogManager.updateTopicConfig(topic, newProperties);
        Assertions.assertTrue((boolean)log0.config().delete());
        Assertions.assertTrue((boolean)log1.config().delete());
        Assertions.assertFalse((boolean)log0.config().compact());
        Assertions.assertFalse((boolean)log1.config().compact());
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).topicConfigUpdated(topic);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp0);
        ((LogManager)Mockito.verify((Object)spyLogManager, (VerificationMode)Mockito.times((int)1))).abortCleaning(tp1);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assertions.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testCheckpointTierStateFailure() {
        File logDir = TestUtils$.MODULE$.tempDir();
        TierLogComponents tierLogComponents = this.tierEnabledLogComponents(false);
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tierLogComponents.topicConsumerOpt().get();
        HashMap<Integer, OffsetAndEpoch> proposedPositions = new HashMap<Integer, OffsetAndEpoch>();
        proposedPositions.put(Predef$.MODULE$.int2Integer(0), new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(10))));
        proposedPositions.put(Predef$.MODULE$.int2Integer(1), new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(20))));
        Mockito.when((Object)tierTopicConsumer.snapshotPositions()).thenReturn(proposedPositions);
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        .colon.colon x$1 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        LogManager logManager = (LogManager)Mockito.spy((Object)this.createLogManager((Seq<File>)x$1, configRepository, tierLogComponents));
        TierPartitionState okTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)okTierPartitionState.flush())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierPartitionState throwingTierPartitionState = (TierPartitionState)Mockito.mock(TierPartitionState.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)throwingTierPartitionState.flush())).thenThrow(new Throwable[]{new IOException("uh oh")});
        AbstractLog okLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)okLog.tierPartitionState()).thenReturn((Object)okTierPartitionState);
        AbstractLog throwingLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        Mockito.when((Object)throwingLog.dir()).thenReturn((Object)logDir);
        Mockito.when((Object)throwingLog.tierPartitionState()).thenReturn((Object)throwingTierPartitionState);
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)new .colon.colon((Object)okLog, (List)new .colon.colon((Object)throwingLog, (List)Nil$.MODULE$)));
        ((LogManager)Mockito.doReturn((Object)new Some((Object)okLog), (Object[])new Object[]{new Some((Object)throwingLog)}).when((Object)logManager)).getLog((TopicPartition)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
        logManager.tryRunTierStateCheckpoint();
        ((TierTopicConsumer)Mockito.verify((Object)tierTopicConsumer, (VerificationMode)Mockito.never())).writePositions((java.util.Map)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeleteAndTierStateFlushConcurrency(boolean checksumEnabled) {
        File logDir = TestUtils$.MODULE$.tempDir();
        TierLogComponents tierLogComponents = this.tierEnabledLogComponents(checksumEnabled);
        Mockito.when((Object)((TierTopicConsumer)tierLogComponents.topicConsumerOpt().get()).snapshotPositions()).thenReturn(new HashMap());
        MockConfigRepository configRepository = new MockConfigRepository();
        configRepository.setTopicConfig(this.name(), LogConfig$.MODULE$.TierEnableProp(), Boolean.toString(true));
        .colon.colon x$1 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        LogManager logManager = this.createLogManager((Seq<File>)x$1, configRepository, tierLogComponents);
        VolatileBooleanRef isDone = VolatileBooleanRef.create((boolean)false);
        VolatileObjectRef exceptionOpt = VolatileObjectRef.create((Object)None$.MODULE$);
        int numPartitions = 50;
        Thread t = new Thread(null, isDone, logManager, exceptionOpt){
            private final VolatileBooleanRef isDone$1;
            private final LogManager logManager$2;
            private final VolatileObjectRef exceptionOpt$1;

            public void run() {
                try {
                    while (!this.isDone$1.elem) {
                        this.logManager$2.tryRunTierStateCheckpoint();
                    }
                }
                catch (Exception e) {
                    this.exceptionOpt$1.elem = new Some((Object)e);
                }
            }
            {
                this.isDone$1 = isDone$1;
                this.logManager$2 = logManager$2;
                this.exceptionOpt$1 = exceptionOpt$1;
            }
        };
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Uuid topicId = Uuid.randomUuid();
            TopicPartition topicPartition = new TopicPartition(this.name(), i);
            TopicIdPartition topicIdPartition = new TopicIdPartition(topicPartition.topic(), CoreUtils$.MODULE$.toJavaUUID(topicId), topicPartition.partition());
            Some x$5 = new Some((Object)topicId);
            boolean x$6 = logManager.getOrCreateLog$default$2();
            boolean x$7 = logManager.getOrCreateLog$default$3();
            AbstractLog log = logManager.getOrCreateLog(topicPartition, x$6, x$7, (Option)x$5);
            log.tierPartitionState().setTopicId(topicIdPartition.topicId());
            TierPartitionState.AppendResult result = log.tierPartitionState().append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
        });
        t.start();
        IndexedSeq allLogs = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)i -> logManager.asyncDelete(new TopicPartition(this.name(), BoxesRunTime.unboxToInt((Object)i)), logManager.asyncDelete$default$2(), logManager.asyncDelete$default$3(), logManager.asyncDelete$default$4()), IndexedSeq$.MODULE$.canBuildFrom());
        isDone.elem = true;
        t.join();
        allLogs.foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            LogManagerTest.$anonfun$testDeleteAndTierStateFlushConcurrency$3(x$15);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)logDir);
        ((Option)exceptionOpt.elem).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            throw x$16;
        });
    }

    private TierLogComponents tierEnabledLogComponents(boolean checksumEnabled) {
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierPartitionStateFactory tierPartitionStateFactory = new TierPartitionStateFactory(true, checksumEnabled, true, false);
        return new TierLogComponents((Option)new Some((Object)tierTopicConsumer), (Option)new Some((Object)tierObjectStore), tierPartitionStateFactory);
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Option x$8 = qual$2.asyncDelete$default$4();
        AbstractLog removedLog = (AbstractLog)qual$2.asyncDelete(tp, x$6, x$7, x$8).get();
        Assertions.assertTrue((boolean)LogManagerTest.logMetrics$1(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        None$ x$10 = None$.MODULE$;
        boolean x$11 = qual$3.getOrCreateLog$default$2();
        boolean x$12 = qual$3.getOrCreateLog$default$3();
        qual$3.getOrCreateLog(tp, x$11, x$12, (Option)x$10);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        Assertions.assertTrue((boolean)removedLog.localLogSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File dir1 = TestUtils$.MODULE$.tempDir();
        File dir2 = TestUtils$.MODULE$.tempDir();
        this.logManager_$eq(this.createLogManager((Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$)), this.createLogManager$default$2(), this.createLogManager$default$3()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        qual$1.getOrCreateLog(tp, x$3, x$4, (Option)x$2);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        boolean x$6 = true;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.getOrCreateLog$default$2();
        qual$2.getOrCreateLog(tp, x$8, x$6, (Option)x$7);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        this.time().sleep(Predef$.MODULE$.Long2long(this.logConfig().fileDeleteDelayMs()) + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWaitForAllToComplete() {
        void waitForAllToComplete_callback;
        void waitForAllToComplete_jobs;
        void waitForAllToComplete_callback2;
        void waitForAllToComplete_jobs2;
        void waitForAllToComplete_callback3;
        void waitForAllToComplete_jobs3;
        void waitForAllToComplete_callback4;
        void waitForAllToComplete_jobs4;
        IntRef invokedCount = IntRef.create((int)0);
        Future success = (Future)Mockito.mock(Future.class);
        Mockito.when(success.get()).thenAnswer(x$17 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testWaitForAllToComplete$1(invokedCount, x$17)));
        Future failure = (Future)Mockito.mock(Future.class);
        Mockito.when(failure.get()).thenAnswer(x$18 -> {
            ++invokedCount$1.elem;
            throw new RuntimeException();
        });
        IntRef failureCount = IntRef.create((int)0);
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$19 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$3(failureCount, x$19);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon2 = new .colon.colon((Object)success, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl = waitForAllToComplete_jobs4.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback4, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl);
        Assertions.assertEquals((int)2, (int)invokedCount.elem);
        Assertions.assertEquals((int)1, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x$20 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$4(failureCount, x$20);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon3 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl2 = waitForAllToComplete_jobs3.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback3, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl2);
        Assertions.assertEquals((int)4, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$21 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$5(failureCount, x$21);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon4 = new .colon.colon((Object)success, (List)new .colon.colon((Object)success, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl3 = waitForAllToComplete_jobs2.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback2, arg_0)) == 0;
        Assertions.assertTrue((boolean)bl3);
        Assertions.assertEquals((int)6, (int)invokedCount.elem);
        Assertions.assertEquals((int)2, (int)failureCount.elem);
        Function1 & Serializable & scala.Serializable intersect4 = (Function1 & Serializable & scala.Serializable)x$22 -> {
            LogManagerTest.$anonfun$testWaitForAllToComplete$6(failureCount, x$22);
            return BoxedUnit.UNIT;
        };
        .colon.colon colon5 = new .colon.colon((Object)failure, (List)new .colon.colon((Object)failure, (List)Nil$.MODULE$));
        if (LogManager$.MODULE$ == null) {
            throw null;
        }
        boolean bl4 = waitForAllToComplete_jobs.count(arg_0 -> LogManager$.$anonfun$waitForAllToComplete$1$adapted((Function1)waitForAllToComplete_callback, arg_0)) == 0;
        Assertions.assertFalse((boolean)bl4);
        Assertions.assertEquals((int)8, (int)invokedCount.elem);
        Assertions.assertEquals((int)4, (int)failureCount.elem);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$2(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ void $anonfun$testHandlingExceptionsDuringShutdown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogManagerTest.$anonfun$testHandlingExceptionsDuringShutdown$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$4(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    private static final KafkaConfig kafkaConfigWithCleanerConfig$1(int logDeletionMaxSegmentsPerRun) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), Integer.toString(logDeletionMaxSegmentsPerRun));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ boolean $anonfun$testLogDeletionMaxSegmentsPerRunExpiredSegments$2(LogManagerTest $this, LogSegment x$3) {
        return x$3.log().file().setLastModified($this.time().milliseconds());
    }

    private final MemoryRecords createRecords$1() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.time().milliseconds() - (long)this.maxLogAgeMs() - 1L;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$2(LogManagerTest $this, AbstractLog log1$1, AbstractLog log2$1, int _) {
        log1$1.appendAsLeader($this.createRecords$1(), 0, log1$1.appendAsLeader$default$3(), log1$1.appendAsLeader$default$4(), log1$1.appendAsLeader$default$5());
        return log2$1.appendAsLeader($this.createRecords$1(), 0, log2$1.appendAsLeader$default$3(), log2$1.appendAsLeader$default$4(), log2$1.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$4(AbstractLog log$2, LogSegment segment) {
        TierPartitionState.AppendResult appendResult = TierTestUtils$.MODULE$.uploadWithMetadata(log$2.tierPartitionState(), (TopicIdPartition)log$2.topicIdPartition().get(), 0, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.largestTimestamp(), segment.getFirstBatchTimestamp(), segment.size(), false, true, TierTestUtils$.MODULE$.uploadWithMetadata$default$12(), TierTestUtils$.MODULE$.uploadWithMetadata$default$13(), TierTestUtils$.MODULE$.uploadWithMetadata$default$14());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)appendResult);
    }

    public static final /* synthetic */ void $anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$3(AbstractLog log) {
        log.tierableLogSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogManagerTest.$anonfun$testLogDeletionMaxSegmentsPerRunAlongWithTierSegmentHotsetRollMinBytes$4(log, segment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$2(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$2(LogManagerTest $this, LogSegment x$5) {
        return x$5.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$1(AbstractLog log$6, int _) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return log$6.appendAsLeader(set, 0, log$6.appendAsLeader$default$3(), log$6.appendAsLeader$default$4(), log$6.appendAsLeader$default$5());
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$2(AbstractLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$4(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            Assertions.assertEquals((Object)log.localLogSegments().headOption().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.readNextOffset())), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$1(File x$10) {
        return x$10.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$3(File fileBeforeDelete$1, File x$11) {
        String string = x$11.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$2(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(fileBeforeDelete, x$11)));
        Assertions.assertEquals((Object)new Some((Object)fileBeforeDelete.getName()), (Object)fileInIndex.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getName()), (String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString());
        Assertions.assertNotEquals((Object)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (String)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$2(AbstractLog log) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.flush(false);
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$4(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            AbstractLog log = (AbstractLog)x0$1._2();
            Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint(), (String)"Recovery point should equal checkpoint");
            Assertions.assertEquals((Object)log.localLogSegments().headOption().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.readNextOffset())), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDeleteAndTierStateFlushConcurrency$3(Option x$15) {
        ((AbstractLog)x$15.get()).close();
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final scala.collection.mutable.Set logMetrics$1(String topicName$1) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        Assertions.assertEquals((int)LogMetricNames$.MODULE$.allMetricNames().size(), (int)LogManagerTest.logMetrics$1(topicName$1).size());
        LogManagerTest.logMetrics$1(topicName$1).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final scala.collection.mutable.Set logMetrics$2(String topicName$2) {
        return (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assertions.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        Assertions.assertEquals((int)(LogMetricNames$.MODULE$.allMetricNames().size() * logCount), (int)LogManagerTest.logMetrics$2(topicName$2).size());
        LogManagerTest.logMetrics$2(topicName$2).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testWaitForAllToComplete$1(IntRef invokedCount$1, InvocationOnMock x$17) {
        ++invokedCount$1.elem;
        return true;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$3(IntRef failureCount$1, Throwable x$19) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$4(IntRef failureCount$1, Throwable x$20) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$5(IntRef failureCount$1, Throwable x$21) {
        ++failureCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testWaitForAllToComplete$6(IntRef failureCount$1, Throwable x$22) {
        ++failureCount$1.elem;
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(this.maxLogAgeMs()));
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }
}

