/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t]c\u0001\u0002\u000f\u001e\u0001\tBQa\n\u0001\u0005\u0002!BqA\u000b\u0001C\u0002\u0013\u00051\u0006\u0003\u00043\u0001\u0001\u0006I\u0001\f\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0011\u00191\u0005\u0001)A\u0005k!)q\t\u0001C\u0001\u0011\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003c\u0002A\u0011AA:\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u00111\u001c\u0001\u0005\n\u0005u\u0007b\u0002B\u0001\u0001\u0011%!1\u0001\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GA\u0011Ba\u0010\u0001#\u0003%IA!\u0011\b\u000b\u0015l\u0002\u0012\u00014\u0007\u000bqi\u0002\u0012A4\t\u000b\u001d\"B\u0011A6\u0007\t1$\u0002!\u001c\u0005\u0006OY!\t!\u001f\u0005\u0006yZ!\t% \u0004\u0007\u0003s!\u0002!a\u000f\t\r\u001dJB\u0011AA\u001f\u0011\u0019a\u0018\u0004\"\u0011\u0002B\t1Cj\\4DY\u0016\fg.\u001a:QCJ\fW.\u001a;fe&TX\rZ%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005yy\u0012a\u00017pO*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013&\u001b\u0005i\u0012B\u0001\u0014\u001e\u0005\u0005\n%m\u001d;sC\u000e$Hj\\4DY\u0016\fg.\u001a:J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002%\u0001\u0005!A/[7f+\u0005a\u0003CA\u00171\u001b\u0005q#BA\u0018 \u0003\u0015)H/\u001b7t\u0013\t\tdF\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cX#A\u001b\u0011\u0007YJ4(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0015\t%O]1z!\taD)D\u0001>\u0015\tqt(\u0001\u0004d_6lwN\u001c\u0006\u0003A\u0001S!!\u0011\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0015aA8sO&\u0011Q)\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003A!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0006dY\u0016\fg.\u001a:UKN$HCA%M!\t1$*\u0003\u0002Lo\t!QK\\5u\u0011\u0015ie\u00011\u0001O\u0003\u0015\u0019w\u000eZ3d!\ty%+D\u0001Q\u0015\t\tV(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0003'B\u0013qbQ8naJ,7o]5p]RK\b/\u001a\u0015\u0005\rU\u000b'\r\u0005\u0002W?6\tqK\u0003\u0002Y3\u0006A\u0001O]8wS\u0012,'O\u0003\u0002[7\u00061\u0001/\u0019:b[NT!\u0001X/\u0002\u000f),\b/\u001b;fe*\u0011aLQ\u0001\u0006UVt\u0017\u000e^\u0005\u0003A^\u0013q\"\u0011:hk6,g\u000e^:T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002GB\u0011AM\u0006\b\u0003IM\ta\u0005T8h\u00072,\u0017M\\3s!\u0006\u0014\u0018-\\3uKJL'0\u001a3J]R,wM]1uS>tG+Z:u!\t!Cc\u0005\u0002\u0015QB\u0011a'[\u0005\u0003U^\u0012a!\u00118z%\u00164G#\u00014\u0003\u001f\u0005cGnQ8naJ,7o]5p]N\u001c2A\u00068w!\tyG/D\u0001q\u0015\t\t(/\u0001\u0003mC:<'\"A:\u0002\t)\fg/Y\u0005\u0003kB\u0014aa\u00142kK\u000e$\bC\u0001,x\u0013\tAxKA\tBe\u001e,X.\u001a8ugB\u0013xN^5eKJ$\u0012A\u001f\t\u0003wZi\u0011\u0001F\u0001\u0011aJ|g/\u001b3f\u0003J<W/\\3oiN$2A`A\u0013a\ry\u00181\u0003\t\u0007\u0003\u0003\tY!a\u0004\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\taa\u001d;sK\u0006l'bAA\u0005e\u0006!Q\u000f^5m\u0013\u0011\ti!a\u0001\u0003\rM#(/Z1n!\u0011\t\t\"a\u0005\r\u0001\u0011Y\u0011Q\u0003\r\u0002\u0002\u0003\u0005)\u0011AA\f\u0005\ryF%M\t\u0005\u00033\ty\u0002E\u00027\u00037I1!!\b8\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AVA\u0011\u0013\r\t\u0019c\u0016\u0002\n\u0003J<W/\\3oiNDq!a\n\u0019\u0001\u0004\tI#A\u0004d_:$X\r\u001f;\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005IQ\r\u001f;f]NLwN\u001c\u0006\u0004\u0003gY\u0016aA1qS&!\u0011qGA\u0017\u0005A)\u0005\u0010^3og&|gnQ8oi\u0016DHOA\u0006Fq\u000edW\u000fZ3[gR$7cA\romR\u0011\u0011q\b\t\u0003wf!B!a\u0011\u0002NA\"\u0011QIA%!\u0019\t\t!a\u0003\u0002HA!\u0011\u0011CA%\t-\tYeGA\u0001\u0002\u0003\u0015\t!a\u0006\u0003\u0007}##\u0007C\u0004\u0002(m\u0001\r!!\u000b)\u0007\u0019\t\t\u0006\u0005\u0003\u0002T\u0005US\"A-\n\u0007\u0005]\u0013LA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fq\u0005^3ti\u000ecW-\u00198t\u0007>l'-\u001b8fI\u000e{W\u000e]1di\u0006sG\rR3mKR,Gk\u001c9jGR\u0019\u0011*!\u0018\t\u000b5;\u0001\u0019\u0001()\t\u001d)\u0016M\u0019\u0015\u0004\u000f\u0005E\u0013A\b;fgR\u001cE.Z1oKJ<\u0016\u000e\u001e5NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,1)\rI\u0015q\r\u0005\u0006\u001b\"\u0001\rA\u0014\u0015\u0006\u0011U\u000b\u00171N\u0012\u0003\u0003[\u0002\"\u0001Z\r)\u0007!\t\t&A\u0013uKN$8\t\\3b]&twMT3ti\u0016$W*Z:tC\u001e,7oV5uQZ\u0003\u0014I\u001c3WcQ\u0019\u0011*!\u001e\t\u000b5K\u0001\u0019\u0001()\u000b%)\u0016-a\u001b)\u0007%\t\t&A\u0019dY\u0016\fg.\u001a:M_\u001e$U\r\\3uK6\u000b\u0007pU3h[\u0016tGo\u001d)feJ+hnQ8oM&<W\u000b\u001d3bi\u0016$Vm\u001d;\u0015\u0007%\u000by\bC\u0003N\u0015\u0001\u0007a\n\u000b\u0003\u000b+\u0006\u0014\u0007f\u0001\u0006\u0002R\u000592\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0006\u000fZ1uKR+7\u000f\u001e\u000b\u0004\u0013\u0006%\u0005\"B'\f\u0001\u0004q\u0005\u0006B\u0006VC\nD3aCA)\u0003qY\u0017MZ6b\u0007>tg-[4XSRD7\t\\3b]\u0016\u00148i\u001c8gS\u001e$B!a%\u0002 B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a~\taa]3sm\u0016\u0014\u0018\u0002BAO\u0003/\u00131bS1gW\u0006\u001cuN\u001c4jO\"9\u0011\u0011\u0015\u0007A\u0002\u0005\r\u0016!D2mK\u0006tWM]\"p]\u001aLw\rE\u0002%\u0003KK1!a*\u001e\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\u0006\u00012\r[3dW2\u000b7\u000f^\"mK\u0006tW\r\u001a\u000b\b\u0013\u00065\u0016qYAi\u0011\u001d\ty+\u0004a\u0001\u0003c\u000bQ\u0001^8qS\u000e\u0004B!a-\u0002B:!\u0011QWA_!\r\t9lN\u0007\u0003\u0003sS1!a/\"\u0003\u0019a$o\\8u}%\u0019\u0011qX\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019-!2\u0003\rM#(/\u001b8h\u0015\r\tyl\u000e\u0005\b\u0003\u0013l\u0001\u0019AAf\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u0007Y\ni-C\u0002\u0002P^\u00121!\u00138u\u0011\u001d\t\u0019.\u0004a\u0001\u0003+\f!BZ5sgR$\u0015N\u001d;z!\r1\u0014q[\u0005\u0004\u00033<$\u0001\u0002'p]\u001e\f!d\u00195fG.dunZ!gi\u0016\u0014\u0018\t\u001d9f]\u0012Lgn\u001a#vaN$r!SAp\u0003O\fY\u000f\u0003\u0004\u001f\u001d\u0001\u0007\u0011\u0011\u001d\t\u0004I\u0005\r\u0018bAAs;\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\tIO\u0004a\u0001\u0003+\f\u0011b\u001d;beR\u001c\u0016N_3\t\u000f\u00055h\u00021\u0001\u0002p\u00069\u0011\r\u001d9f]\u0012\u001c\bCBAy\u0003o\fY0\u0004\u0002\u0002t*\u0019\u0011Q_\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002z\u0006M(aA*fcBIa'!@\u0002L\u0006E\u0016Q[\u0005\u0004\u0003\u007f<$A\u0002+va2,7'A\u0003u_6\u000b\u0007\u000f\u0006\u0003\u0003\u0006\tE\u0001\u0003CAy\u0005\u000f\tYMa\u0003\n\t\t%\u00111\u001f\u0002\u0004\u001b\u0006\u0004\bc\u0002\u001c\u0003\u000e\u0005E\u0016Q[\u0005\u0004\u0005\u001f9$A\u0002+va2,'\u0007C\u0004\u0003\u0014=\u0001\rA!\u0006\u0002\u00115,7o]1hKN\u0004b!!=\u0003\u0018\u0005m\u0018\u0002\u0002B\r\u0003g\u0014\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\fe\u0016\fGM\u0012:p[2{w\r\u0006\u0003\u0003\u0016\t}\u0001B\u0002\u0010\u0011\u0001\u0004\t\t/A\rxe&$X\rR;qgNKgn\u001a7f\u001b\u0016\u001c8/Y4f'\u0016$HCDAx\u0005K\u0011IC!\f\u00030\tE\"Q\u0007\u0005\b\u0005O\t\u0002\u0019AAf\u0003\u001dqW/\\&fsNDqAa\u000b\u0012\u0001\u0004\tY-A\u0004ok6$U\u000f]:\t\ry\t\u0002\u0019AAq\u0011\u0015i\u0015\u00031\u0001O\u0011%\u0011\u0019$\u0005I\u0001\u0002\u0004\tY-\u0001\u0005ti\u0006\u0014HoS3z\u0011\u001d\u00119$\u0005a\u0001\u0005s\t!\"\\1hS\u000e4\u0016\r\\;f!\r1$1H\u0005\u0004\u0005{9$\u0001\u0002\"zi\u0016\f1e\u001e:ji\u0016$U\u000f]:TS:<G.Z'fgN\fw-Z*fi\u0012\"WMZ1vYR$S'\u0006\u0002\u0003D)\"\u00111\u001aB#W\t\u00119\u0005\u0005\u0003\u0003J\tMSB\u0001B&\u0015\u0011\u0011iEa\u0014\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B)o\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tU#1\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class LogCleanerParameterizedIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerTest(CompressionType codec) {
        void var5_5;
        void var4_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        void largeMessageValue2 = var4_4;
        void largeMessageSet2 = var5_5;
        int maxMessageSize = largeMessageSet2.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = ((LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset();
        int x$13 = largeMessageKey + 1;
        int x$14 = 100;
        int x$15 = 3;
        byte x$18 = this.writeDups$default$6();
        Seq<Tuple3<Object, String, Object>> dups = this.writeDups(x$14, x$15, log, codec, x$13, x$18);
        Seq appends2 = (Seq)((TraversableLike)appends.$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(dups, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        this.cleaner().updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)this.topicPartitions()[0]));
        Assertions.assertFalse((boolean)new OffsetCheckpointFile(new File(this.logDir(), this.cleaner().cleanerManager().offsetCheckpointFile()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read().contains((Object)this.topicPartitions()[0]));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void testCleansCombinedCompactAndDeleteTopic(CompressionType codec) {
        void var10_12;
        void var9_11;
        void var5_5;
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        Tuple2 tuple2 = this.runCleanerAndCheckCompacted$1(100, logProps, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        AbstractLog log = (AbstractLog)tuple2._1();
        var5_5.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long endOffset = var5_5.logEndOffset();
        var5_5.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$4((AbstractLog)var5_5, endOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerParameterizedIntegrationTest.$anonfun$testCleansCombinedCompactAndDeleteTopic$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)var5_5.numberOfSegments());
        this.cleaner().shutdown();
        Tuple2 tuple22 = this.runCleanerAndCheckCompacted$1(20, logProps, codec);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        AbstractLog log2 = (AbstractLog)tuple22._1();
        Seq messages = (Seq)tuple22._2();
        void log22 = var9_11;
        void messages2 = var10_12;
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog((AbstractLog)log22);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)messages2), this.toMap(read), (String)"Contents of the map shouldn't change");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleanerWithMessageFormatV0(CompressionType codec) {
        void var6_5;
        void var5_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)0, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String largeMessageValue = (String)tuple2._1();
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        void largeMessageValue2 = var5_4;
        void largeMessageSet2 = var6_5;
        int n = CompressionType.NONE.equals(codec) ? largeMessageSet2.sizeInBytes() : largeMessageSet2.sizeInBytes() + 5;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        float x$3 = this.makeCleaner$default$2();
        int x$4 = this.makeCleaner$default$3();
        long x$5 = this.makeCleaner$default$4();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$82 = this.makeCleaner$default$8();
        long x$92 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$3, x$4, x$5, n, x$6, x$7, x$82, x$92, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Properties x$14 = this.logConfigProperties$default$1();
        float x$15 = this.logConfigProperties$default$3();
        long x$16 = this.logConfigProperties$default$4();
        int x$17 = this.logConfigProperties$default$5();
        int x$18 = this.logConfigProperties$default$6();
        long x$19 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$14, n, x$15, x$16, x$17, x$18, x$19);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$20 = 100;
        int x$21 = 3;
        byte x$24 = 0;
        int x$25 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> appends = this.writeDups(x$20, x$21, log, codec, x$25, x$24);
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, appends);
        int x$26 = 40;
        int x$27 = 3;
        byte x$30 = 0;
        int x$31 = this.writeDups$default$5();
        Seq<Tuple3<Object, String, Object>> dupsV0 = this.writeDups(x$26, x$27, log, codec, x$31, x$30);
        LogAppendInfo appendInfo = log.appendAsLeader((MemoryRecords)largeMessageSet2, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        long largeMessageOffset = BoxesRunTime.unboxToLong((Object)appendInfo.firstOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())).get());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_11_0_IV0$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$32 = 30;
        int x$33 = 40;
        int x$34 = 3;
        byte x$37 = 1;
        Seq<Tuple3<Object, String, Object>> dupsV1 = this.writeDups(x$33, x$34, log, codec, x$32, x$37);
        int x$38 = 15;
        int x$39 = 5;
        int x$40 = 3;
        byte x$43 = 2;
        Seq<Tuple3<Object, String, Object>> dupsV2 = this.writeDups(x$39, x$40, log, codec, x$38, x$43);
        Seq appends2 = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)appends.$plus$plus(dupsV0, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)largeMessageKey), (Object)largeMessageValue2, (Object)BoxesRunTime.boxToLong((long)largeMessageOffset)), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV1, Seq$.MODULE$.canBuildFrom())).$plus$plus(dupsV2, Seq$.MODULE$.canBuildFrom());
        long firstDirty2 = log.activeSegment().baseOffset();
        this.checkLastCleaned("log", 0, firstDirty2);
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends2);
    }

    @ParameterizedTest
    @ArgumentsSource(value=ExcludeZstd.class)
    public void testCleaningNestedMessagesWithV0AndV1(CompressionType codec) {
        int maxMessageSize = 192;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$3 = 256;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$4();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$102 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$6, maxMessageSize, x$7, x$8, x$3, x$9, x$102, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        int x$14 = 256;
        Properties x$15 = this.logConfigProperties$default$1();
        float x$16 = this.logConfigProperties$default$3();
        long x$17 = this.logConfigProperties$default$4();
        int x$18 = this.logConfigProperties$default$5();
        long x$19 = this.logConfigProperties$default$7();
        Properties props = this.logConfigProperties(x$15, maxMessageSize, x$16, x$17, x$18, x$14, x$19);
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_9_0$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$20 = 2;
        int x$21 = 3;
        byte x$24 = 0;
        int x$25 = this.writeDupsSingleMessageSet$default$5();
        Seq appendsV0 = this.writeDupsSingleMessageSet(x$20, x$21, log, codec, x$25, x$24);
        int x$26 = 2;
        int x$27 = 3;
        int x$28 = 2;
        byte x$31 = 0;
        appendsV0 = (Seq)appendsV0.$plus$plus(this.writeDupsSingleMessageSet(x$26, x$28, log, codec, x$27, x$31), Seq$.MODULE$.canBuildFrom());
        props.put(LogConfig$.MODULE$.MessageFormatVersionProp(), KAFKA_0_10_0_IV1$.MODULE$.version());
        log.updateConfig(new LogConfig((java.util.Map)props, LogConfig$.MODULE$.$lessinit$greater$default$2()));
        int x$32 = 4;
        int x$33 = 2;
        int x$34 = 2;
        byte x$37 = 1;
        Seq appendsV1 = this.writeDupsSingleMessageSet(x$33, x$34, log, codec, x$32, x$37);
        int x$38 = 4;
        int x$39 = 2;
        int x$40 = 2;
        byte x$43 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$39, x$40, log, codec, x$38, x$43), Seq$.MODULE$.canBuildFrom());
        int x$44 = 6;
        int x$45 = 2;
        int x$46 = 2;
        byte x$49 = 1;
        appendsV1 = (Seq)appendsV1.$plus$plus(this.writeDupsSingleMessageSet(x$45, x$46, log, codec, x$44, x$49), Seq$.MODULE$.canBuildFrom());
        Seq appends = (Seq)appendsV0.$plus$plus((GenTraversableOnce)appendsV1, Seq$.MODULE$.canBuildFrom());
        long startSize = log.size();
        this.cleaner().startup();
        long firstDirty = log.activeSegment().baseOffset();
        Assertions.assertTrue((firstDirty > (long)appendsV0.size() ? 1 : 0) != 0);
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        this.checkLogAfterAppendingDups(log, startSize, (Seq<Tuple3<Object, String, Object>>)appends);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest(CompressionType codec) {
        Properties logProps = new Properties();
        Integer retentionMs = Predef$.MODULE$.int2Integer(100000);
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact,delete");
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        long x$3 = 100L;
        int x$4 = 0;
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        int x$7 = this.makeCleaner$default$5();
        long x$8 = this.makeCleaner$default$6();
        int x$9 = this.makeCleaner$default$7();
        int x$10 = this.makeCleaner$default$8();
        long x$11 = this.makeCleaner$default$9();
        Option<Object> x$12 = this.makeCleaner$default$10();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, x$3, x$7, x$8, x$9, x$10, x$11, x$12, logProps, x$4));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.startCleanerAndCheckCompactionProgress$1(log, codec, retentionMs);
        Assertions.assertFalse((log.logStartOffset() == log.logEndOffset() ? 1 : 0) != 0);
        long endOffset = log.logEndOffset();
        this.reconfigureMaxSegmentDeletedPerRun$1(log.numberOfSegments());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerParameterizedIntegrationTest.$anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$3(log, endOffset)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerParameterizedIntegrationTest.$anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)1, (int)log.numberOfSegments());
        this.cleaner().shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ArgumentsSource(value=AllCompressions.class)
    public void cleanerConfigUpdateTest(CompressionType codec) {
        void var4_4;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, codec);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var4_4.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$2 = 1L;
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$5, x$6, x$2, maxMessageSize, x$7, x$8, x$9, x$10, (Option<Object>)x$4, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        this.writeDups(100, 3, log, codec, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        this.cleaner().startup();
        Assertions.assertEquals((int)1, (int)this.cleaner().cleanerCount());
        long firstDirty = log.activeSegment().baseOffset();
        TopicPartition topicPartition = new TopicPartition("log", 0);
        this.cleaner().awaitCleaned(topicPartition, firstDirty, 10L);
        Assertions.assertTrue((boolean)this.cleaner().cleanerManager().allCleanerCheckpoints().isEmpty(), (String)"Should not have cleaned");
        KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig(this.cleaner().currentConfig());
        KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig(new CleanerConfig(2, this.cleaner().currentConfig().dedupeBufferSize(), this.cleaner().currentConfig().dedupeBufferLoadFactor(), 100000, this.cleaner().currentConfig().maxMessageSize(), this.cleaner().currentConfig().maxIoBytesPerSecond(), this.cleaner().currentConfig().backOffMs(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9(), CleanerConfig$.MODULE$.apply$default$10(), CleanerConfig$.MODULE$.apply$default$11()));
        this.cleaner().reconfigure(oldConfig, newConfig);
        Assertions.assertEquals((int)2, (int)this.cleaner().cleanerCount());
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    private KafkaConfig kafkaConfigWithCleanerConfig(CleanerConfig cleanerConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.LogCleanerThreadsProp(), Integer.toString(cleanerConfig.numThreads()));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), Long.toString(cleanerConfig.dedupeBufferSize()));
        props.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferLoadFactorProp(), Double.toString(cleanerConfig.dedupeBufferLoadFactor()));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoBufferSizeProp(), Integer.toString(cleanerConfig.ioBufferSize()));
        props.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(cleanerConfig.maxMessageSize()));
        props.put(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp(), Long.toString(cleanerConfig.backOffMs()));
        props.put(KafkaConfig$.MODULE$.LogCleanerIoMaxBytesPerSecondProp(), Double.toString(cleanerConfig.maxIoBytesPerSecond()));
        props.put(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), Integer.toString(cleanerConfig.logDeletionMaxSegmentsPerRun()));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void checkLastCleaned(String topic, int partitionId, long firstDirty) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        LogCleaner qual$1 = this.cleaner();
        long x$3 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(topicPartition, firstDirty, x$3);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)topicPartition));
        Assertions.assertTrue((lastCleaned >= firstDirty ? 1 : 0) != 0, (String)new StringBuilder(65).append("log cleaner should have processed up to offset ").append(firstDirty).append(", but lastCleaned=").append(lastCleaned).toString());
    }

    private void checkLogAfterAppendingDups(AbstractLog log, long startSize, Seq<Tuple3<Object, String, Object>> appends) {
        Iterable<Tuple3<Object, String, Object>> read = this.readFromLog(log);
        Assertions.assertEquals(this.toMap((Iterable<Tuple3<Object, String, Object>>)appends), this.toMap(read), (String)"Contents of the map shouldn't change");
        Assertions.assertTrue((startSize > log.size() ? 1 : 0) != 0);
    }

    private Map<Object, Tuple2<String, Object>> toMap(Iterable<Tuple3<Object, String, Object>> messages) {
        return ((TraversableOnce)messages.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = BoxesRunTime.unboxToInt((Object)x0$1._1());
            String value = (String)x0$1._2();
            long offset = BoxesRunTime.unboxToLong((Object)x0$1._3());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)new Tuple2((Object)value, (Object)BoxesRunTime.boxToLong((long)offset)));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Iterable<Tuple3<Object, String, Object>> readFromLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            String value = TestUtils$.MODULE$.readString(deepLogEntry.value(), TestUtils$.MODULE$.readString$default$2());
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)key), (Object)value, (Object)BoxesRunTime.boxToLong((long)deepLogEntry.offset()));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple3<Object, String, Object>> writeDupsSingleMessageSet(int numKeys, int numDups, AbstractLog log, CompressionType codec, int startKey, byte magicValue) {
        IndexedSeq kvs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$1(this, startKey, numKeys, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq records = (IndexedSeq)kvs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = x0$1._1$mcI$sp();
            String payload = (String)x0$1._2();
            SimpleRecord simpleRecord = new SimpleRecord(Integer.toString(key).getBytes(), payload.getBytes());
            return simpleRecord;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        LogAppendInfo appendInfo = log.appendAsLeader(MemoryRecords.withRecords((byte)magicValue, (CompressionType)codec, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.updateHighWatermark(log.logEndOffset());
        NumericRange.Inclusive offsets = new RichLong(Predef$.MODULE$.longWrapper(((LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset())).to((Object)BoxesRunTime.boxToLong((long)appendInfo.lastOffset()));
        return (Seq)((TraversableLike)kvs.zip((GenIterable)offsets, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Tuple2 kv = (Tuple2)x0$2._1();
            long offset = x0$2._2$mcJ$sp();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp()), kv._2(), (Object)BoxesRunTime.boxToLong((long)offset));
            return tuple3;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private int writeDupsSingleMessageSet$default$5() {
        return 0;
    }

    private final Tuple2 runCleanerAndCheckCompacted$1(int numKeys, Properties logProps$1, CompressionType codec$1) {
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.topicPartitions())).take(1));
        long x$32 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        int x$6 = this.makeCleaner$default$5();
        long x$7 = this.makeCleaner$default$6();
        int x$8 = this.makeCleaner$default$7();
        int x$9 = this.makeCleaner$default$8();
        long x$10 = this.makeCleaner$default$9();
        Option<Object> x$11 = this.makeCleaner$default$10();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$32, x$6, x$7, x$8, x$9, x$10, x$11, logProps$1, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        Seq<Tuple3<Object, String, Object>> messages = this.writeDups(numKeys, 3, log, codec$1, this.writeDups$default$5(), this.writeDups$default$6());
        long startSize = log.size();
        log.updateHighWatermark(log.logEndOffset());
        long firstDirty = log.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
        return new Tuple2((Object)log, messages);
    }

    public static final /* synthetic */ boolean $anonfun$testCleansCombinedCompactAndDeleteTopic$4(AbstractLog log$1, long endOffset$1) {
        return log$1.logStartOffset() == endOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testCleansCombinedCompactAndDeleteTopic$5() {
        return "Timed out waiting for deletion of old segments";
    }

    private final void reconfigureMaxSegmentDeletedPerRun$1(int logDeletionMaxSegmentsPerRun) {
        KafkaConfig oldConfig = this.kafkaConfigWithCleanerConfig(this.cleaner().currentConfig());
        int x$1 = this.cleaner().currentConfig().numThreads();
        long x$2 = this.cleaner().currentConfig().dedupeBufferSize();
        double x$3 = this.cleaner().currentConfig().dedupeBufferLoadFactor();
        int x$4 = this.cleaner().currentConfig().ioBufferSize();
        int x$5 = this.cleaner().currentConfig().maxMessageSize();
        double x$6 = this.cleaner().currentConfig().maxIoBytesPerSecond();
        long x$7 = this.cleaner().currentConfig().backOffMs();
        boolean x$9 = CleanerConfig$.MODULE$.apply$default$8();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        boolean x$11 = CleanerConfig$.MODULE$.apply$default$11();
        KafkaConfig newConfig = this.kafkaConfigWithCleanerConfig(new CleanerConfig(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$9, logDeletionMaxSegmentsPerRun, x$10, x$11));
        this.cleaner().reconfigure(oldConfig, newConfig);
    }

    private final void startCleanerAndCheckCompactionProgress$1(AbstractLog log$2, CompressionType codec$2, Integer retentionMs$2) {
        this.writeDups(100, 3, log$2, codec$2, this.writeDups$default$5(), this.writeDups$default$6());
        log$2.updateHighWatermark(log$2.logEndOffset());
        log$2.localLogSegments().foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.lastModified_$eq(this.time().milliseconds() - (long)(2 * Predef$.MODULE$.Integer2int(retentionMs$2))));
        long startSize = log$2.size();
        long firstDirty = log$2.activeSegment().baseOffset();
        this.cleaner().startup();
        this.checkLastCleaned("log", 0, firstDirty);
        int compactedSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)log$2.localLogSegments().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((startSize > (long)compactedSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("log should have been compacted: startSize=").append(startSize).append(" compactedSize=").append(compactedSize).toString());
    }

    public static final /* synthetic */ boolean $anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$3(AbstractLog log$2, long endOffset$2) {
        return log$2.logStartOffset() == endOffset$2;
    }

    public static final /* synthetic */ String $anonfun$cleanerLogDeleteMaxSegmentsPerRunConfigUpdateTest$4() {
        return "Timed out waiting for deletion of old segments";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDupsSingleMessageSet$2(LogCleanerParameterizedIntegrationTest $this, int key) {
        String payload = Integer.toString($this.counter());
        $this.incCounter();
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)key), (Object)payload);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDupsSingleMessageSet$1(LogCleanerParameterizedIntegrationTest $this, int startKey$1, int numKeys$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startKey$1), startKey$1 + numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerParameterizedIntegrationTest.$anonfun$writeDupsSingleMessageSet$2($this, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static class AllCompressions
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values())).map((Function1 & Serializable & scala.Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Arguments.class))));
        }
    }

    public static class ExcludeZstd
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Arrays.stream((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CompressionType.values())).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ExcludeZstd.$anonfun$provideArguments$2(x$14))))).map((Function1 & Serializable & scala.Serializable)codec -> Arguments.of((Object[])new Object[]{codec}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Arguments.class))));
        }

        public static final /* synthetic */ boolean $anonfun$provideArguments$2(CompressionType x$14) {
            CompressionType compressionType = x$14;
            CompressionType compressionType2 = CompressionType.ZSTD;
            return compressionType == null ? compressionType2 != null : !compressionType.equals(compressionType2);
        }
    }
}

