/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u000b\u0016\u0001iAQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0011\u0006\u0003\u00048\u0001\u0001\u0006IA\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019\u0001\u0005\u0001)A\u0005u!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB'\u0001A\u0003%1\tC\u0003O\u0001\u0011\u0005q\nC\u0003_\u0001\u0011\u0005q\nC\u0003d\u0001\u0011%A\rC\u0003|\u0001\u0011%A\u0010\u0003\u0004|\u0001\u0011%\u00111\u0007\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'Ba!!\u0018\u0001\t\u0003y\u0005BBA1\u0001\u0011\u0005q\nC\u0004\u0002f\u0001!I!a\u001a\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"1\u0011\u0011\u0017\u0001\u0005\u0002=\u0013\u0011\u0004T8h\u00072,\u0017M\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011acF\u0001\u0004Y><'\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aG\u0010\u0011\u0005qiR\"A\u000b\n\u0005y)\"!I!cgR\u0014\u0018m\u0019;M_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0018\u0003\u001diW\r\u001e:jGNL!\u0001J\u0011\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011A\u0004A\u0001\u0006G>$WmY\u000b\u0002UA\u00111&N\u0007\u0002Y)\u0011QFL\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005=\u0002\u0014AB2p[6|gN\u0003\u0002\u0019c)\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h\u0013\t1DFA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0003\u0019\u0019w\u000eZ3dA\u0005!A/[7f+\u0005Q\u0004CA\u001e?\u001b\u0005a$BA\u001f\u0018\u0003\u0015)H/\u001b7t\u0013\tyDH\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cX#A\"\u0011\u0007\u0011;\u0015*D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0015\t%O]1z!\tQ5*D\u0001/\u0013\taeF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013aB2mK\u0006tW\u000f\u001d\u000b\u0002!B\u0011A)U\u0005\u0003%\u0016\u0013A!\u00168ji\"\u0012\u0001\u0002\u0016\t\u0003+rk\u0011A\u0016\u0006\u0003/b\u000b1!\u00199j\u0015\tI&,A\u0004kkBLG/\u001a:\u000b\u0005m\u001b\u0014!\u00026v]&$\u0018BA/W\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u001euKN$X*\u0019:lgB\u000b'\u000f^5uS>t7/Q:PM\u001ad\u0017N\\3B]\u0012\u0004v\u000e];mCR,7/\u00168dY\u0016\fg.\u00192mK6+GO]5dg\"\u0012\u0011\u0002\u0019\t\u0003+\u0006L!A\u0019,\u0003\tQ+7\u000f^\u0001\nO\u0016$X*\u001a;sS\u000e$\"!\u001a9\u0011\u0005\u0019tW\"A4\u000b\u0005!L\u0017\u0001B2pe\u0016T!A\t6\u000b\u0005-d\u0017AB=b[6,'OC\u0001n\u0003\r\u0019w.\\\u0005\u0003_\u001e\u0014a!T3ue&\u001c\u0007\"B9\u000b\u0001\u0004\u0011\u0018A\u00024jYR,'\u000f\u0005\u0003EgVD\u0018B\u0001;F\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002gm&\u0011qo\u001a\u0002\u000b\u001b\u0016$(/[2OC6,\u0007C\u0001#z\u0013\tQXIA\u0004C_>dW-\u00198\u0002\u0011\u001d,GoR1vO\u0016,2!`A\u0004)\rq\u0018\u0011\u0004\t\u0005M~\f\u0019!C\u0002\u0002\u0002\u001d\u0014QaR1vO\u0016\u0004B!!\u0002\u0002\b1\u0001AaBA\u0005\u0017\t\u0007\u00111\u0002\u0002\u0002)F!\u0011QBA\n!\r!\u0015qB\u0005\u0004\u0003#)%a\u0002(pi\"Lgn\u001a\t\u0004\t\u0006U\u0011bAA\f\u000b\n\u0019\u0011I\\=\t\u000f\u0005m1\u00021\u0001\u0002\u001e\u0005QQ.\u001a;sS\u000et\u0015-\\3\u0011\t\u0005}\u0011Q\u0006\b\u0005\u0003C\tI\u0003E\u0002\u0002$\u0015k!!!\n\u000b\u0007\u0005\u001d\u0012$\u0001\u0004=e>|GOP\u0005\u0004\u0003W)\u0015A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,\u0015+B!!\u000e\u0002<Q1\u0011qGA\u001f\u0003\u007f\u0001BAZ@\u0002:A!\u0011QAA\u001e\t\u001d\tI\u0001\u0004b\u0001\u0003\u0017Aq!a\u0007\r\u0001\u0004\ti\u0002C\u0004\u0002B1\u0001\r!!\b\u0002\u00175,GO]5d'\u000e|\u0007/Z\u0001\tO\u0016$X*\u001a;feR1\u0011qIA'\u0003\u001f\u00022AZA%\u0013\r\tYe\u001a\u0002\u0006\u001b\u0016$XM\u001d\u0005\b\u00037i\u0001\u0019AA\u000f\u0011\u001d\t\t%\u0004a\u0001\u0003;\tAbZ3u\u0011&\u001cHo\\4sC6$B!!\u0016\u0002\\A\u0019a-a\u0016\n\u0007\u0005esMA\u0005ISN$xn\u001a:b[\"9\u00111\u0004\bA\u0002\u0005u\u0011a\u0006;fgRl\u0015\r\u001f'pO\u000e{W\u000e]1di&|g\u000eT1hQ\ty\u0001-A\u000buKN$8i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:)\u0005A\u0001\u0017a\u0003:fC\u00124%o\\7M_\u001e$B!!\u001b\u0002\u0002B1\u00111NA9\u0003kj!!!\u001c\u000b\u0007\u0005=T)\u0001\u0006d_2dWm\u0019;j_:LA!a\u001d\u0002n\tA\u0011\n^3sC\ndW\rE\u0004E\u0003o\nY(a\u001f\n\u0007\u0005eTI\u0001\u0004UkBdWM\r\t\u0004\t\u0006u\u0014bAA@\u000b\n\u0019\u0011J\u001c;\t\rY\t\u0002\u0019AAB!\ra\u0012QQ\u0005\u0004\u0003\u000f+\"aC!cgR\u0014\u0018m\u0019;M_\u001e\fAb\u001e:ji\u0016\\U-\u001f#vaN$\u0002#!$\u0002\u0014\u0006]\u00151TAO\u0003?\u000bI+!,\u0011\r\u0005-\u0014qRA;\u0013\u0011\t\t*!\u001c\u0003\u0007M+\u0017\u000fC\u0004\u0002\u0016J\u0001\r!a\u001f\u0002\u000f9,XnS3zg\"9\u0011\u0011\u0014\nA\u0002\u0005m\u0014a\u00028v[\u0012+\bo\u001d\u0005\u0007-I\u0001\r!a!\t\u000b!\u0012\u0002\u0019\u0001\u0016\t\u000f\u0005\u0005&\u00031\u0001\u0002$\u0006IA/[7fgR\fW\u000e\u001d\t\u0004\t\u0006\u0015\u0016bAAT\u000b\n!Aj\u001c8h\u0011\u001d\tYK\u0005a\u0001\u0003w\n!b\u001d;beR4\u0016\r\\;f\u0011\u001d\tyK\u0005a\u0001\u0003w\nAa\u001d;fa\u0006\u0011B/Z:u\u0013N$\u0006N]3bI\u001a\u000b\u0017\u000e\\3eQ\t\u0019\u0002\r")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest
implements KafkaMetricsGroup {
    private final CompressionType codec;
    private final MockTime time;
    private final TopicPartition[] topicPartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$((KafkaMetricsGroup)this, (String)group, (String)typeName, (String)name, tags);
    }

    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (String)name, metric, tags);
    }

    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$((KafkaMetricsGroup)this);
    }

    public <T> Gauge<T> newGauge(MetricName metricName, Gauge<T> metric) {
        return KafkaMetricsGroup.newGauge$((KafkaMetricsGroup)this, (MetricName)metricName, metric);
    }

    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (String)name, (String)eventType, (TimeUnit)timeUnit, tags);
    }

    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$((KafkaMetricsGroup)this);
    }

    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)this, (MetricName)metricName, (String)eventType, (TimeUnit)timeUnit);
    }

    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$((KafkaMetricsGroup)this, (String)name, (boolean)biased, tags);
    }

    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$((KafkaMetricsGroup)this);
    }

    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$((KafkaMetricsGroup)this);
    }

    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$((KafkaMetricsGroup)this, (String)name, (TimeUnit)durationUnit, (TimeUnit)rateUnit, tags);
    }

    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$((KafkaMetricsGroup)this);
    }

    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (String)name, tags);
    }

    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$((KafkaMetricsGroup)this);
    }

    public void removeMetric(MetricName metricName) {
        KafkaMetricsGroup.removeMetric$((KafkaMetricsGroup)this, (MetricName)metricName);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$32 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$122 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, x$32, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11, x$122));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        AbstractLog log2 = (AbstractLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        this.cleaner().logs().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(x$1);
            return BoxedUnit.UNIT;
        });
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.localLogSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.localLogSegments().last()).baseOffset())._2$mcJ$sp();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.cleaner().logs().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(x$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes.value()));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Gauge compactedPartitionBytes2 = this.getGauge("compacted-partition-bytes", uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.cleaner().logs().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(x$3)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (long)BoxesRunTime.unboxToLong((Object)compactedPartitionBytes2.value()));
    }

    private Metric getMetric(Function1<MetricName, Object> filter) {
        return (Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$1(metricName, mName));
        return (Gauge)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$2(metricName, metricScope, k));
        return (Gauge)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Meter getMeter(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getMeter$1(metricName, metricScope, k));
        return (Meter)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    private Histogram getHistogram(String metricName) {
        Function1 & Serializable & scala.Serializable getMetric_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getHistogram$1(metricName, k));
        return (Histogram)((Metric)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getMetric$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getMetric$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2());
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1(), log.roll$default$2());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, firstBlockCleanableSegmentOffset, x$15);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$17 = activeSegAtT1.baseOffset();
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, x$17, x$18);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
    }

    @Test
    public void testCompactionMetrics() {
        double eps = 1.0E-6;
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11, x$12));
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        this.writeKeyDups(100, 3, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSeg = log.activeSegment();
        this.cleaner().startup();
        Meter readBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSec = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Histogram achievedCleaningRatio = this.getHistogram("AchievedCleaningRatio");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        Assertions.assertEquals((long)0L, (long)readBytesPerSec.count(), (String)"log cleaner should have read 0 bytes");
        Assertions.assertEquals((long)0L, (long)writeBytesPerSec.count(), (String)"log cleaner should have written 0 bytes");
        Assertions.assertEquals((double)0.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        this.writeKeyDups(100, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 0);
        long expectedReadBytes = log.size();
        log.roll(log.roll$default$1(), log.roll$default$2());
        long blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs);
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$13 = new TopicPartition("log", 0);
        long x$15 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$13, blockCleanableSegmentOffset, x$15);
        Assertions.assertEquals((long)expectedReadBytes, (long)readBytesPerSec.count(), (String)new StringBuilder(35).append("log cleaner should have read ").append(expectedReadBytes).append(" bytes").toString());
        Assertions.assertEquals((long)log.size(), (long)writeBytesPerSec.count(), (String)new StringBuilder(8).append("a ").append(log.size()).append(" bytes").toString());
        Assertions.assertEquals((double)100.0, (double)achievedCleaningRatio.mean(), (double)eps, (String)"achieved cleaning ratio should be 0");
        Meter readBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.read");
        Meter writeBytesPerSecForLocal = this.getMeter("CompactionThroughputBytesPerSec", "op.write");
        Assertions.assertEquals((long)readBytesPerSec.count(), (long)readBytesPerSecForLocal.count());
        Assertions.assertEquals((long)writeBytesPerSec.count(), (long)writeBytesPerSecForLocal.count());
        log.size();
        this.writeKeyDups(75, 1, log, CompressionType.NONE, this.time().milliseconds(), 0, 1);
        activeSeg = log.activeSegment();
        log.roll(log.roll$default$1(), log.roll$default$2());
        blockCleanableSegmentOffset = activeSeg.baseOffset();
        this.time().sleep(maxCompactionLagMs * 2);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$16 = new TopicPartition("log", 0);
        long x$18 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$16, blockCleanableSegmentOffset, x$18);
        Assertions.assertTrue((achievedCleaningRatio.mean() < (double)100 ? 1 : 0) != 0, (String)"achieved cleaning ratio should be less than 100");
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(AbstractLog log) {
        return (Iterable)log.localLogSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, AbstractLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = 100000;
        long x$3 = 100L;
        float x$42 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        int x$12 = this.makeCleaner$default$12();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$42, x$5, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        AbstractLog log = (AbstractLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = log.activeSegment().log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ void $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2(Tuple2 x$1) {
        if (x$1 != null) {
            AbstractLog log = (AbstractLog)x$1._2();
            ((MergedLog)log).computeLogSizeDetails().cancel(true);
            ((MergedLog)log).updateSizeDetails();
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$7(Tuple2 x$2) {
        return ((AbstractLog)x$2._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$8(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$9() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ long $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$10(Tuple2 x$3) {
        return ((AbstractLog)x$3._2()).size();
    }

    public static final /* synthetic */ boolean $anonfun$getMetric$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$2(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ boolean $anonfun$getMeter$1(String metricName$3, String metricScope$2, MetricName k) {
        return k.getName().endsWith(metricName$3) && k.getScope().endsWith(metricScope$2);
    }

    public static final /* synthetic */ boolean $anonfun$getHistogram$1(String metricName$4, MetricName k) {
        return k.getName().endsWith(metricName$4) && k.getScope() == null;
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, AbstractLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }

    public LogCleanerIntegrationTest() {
        Logging.$init$((Logging)this);
        KafkaMetricsGroup.$init$((KafkaMetricsGroup)this);
        this.codec = CompressionType.LZ4;
        this.time = new MockTime();
        this.topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
    }
}

