/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iA\u0011\u0002\b\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b%\u0002A\u0011\t\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0005\u0004A\u0011\u00022\t\u000b=\u0004A\u0011\u00029\t\u000b\u0011\u0004A\u0011\u0002=\t\u000be\u0004A\u0011\u0002=\t\u000bi\u0004A\u0011B>\t\u000f\u0005u\u0001\u0001\"\u0003\u0002 !9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA#\u0001\u0011%\u0011q\t\u0002\u001f\u00072,8\u000f^3s\u0019&t7\u000eV5fe&sG/Z4sCRLwN\u001c+fgRT!\u0001E\t\u0002\t1Lgn\u001b\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\u0010\u0013\tArB\u0001\u0012BEN$(/Y2u\u00072,8\u000f^3s\u0019&t7.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002\u0013}#Xm\u001d;J]\u001a|\u0007C\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\nqA[;qSR,'O\u0003\u0002%K\u0005)!.\u001e8ji*\ta%A\u0002pe\u001eL!\u0001K\u0010\u0003\u0011Q+7\u000f^%oM>\fQa]3u+B$\"aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\r\u0001\r!H\u0001\ti\u0016\u001cH/\u00138g_\"\u00121\u0001\u000e\t\u0003=UJ!AN\u0010\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0014uKN$X*\u001b:s_JLgnZ,ji\"$\u0016.\u001a:j]\u001e,e.\u00192mK\u0012|enU8ve\u000e,GCA\u0016:\u0011\u0015QD\u00011\u0001<\u0003\u0019\tXo\u001c:v[B\u0011Ah\u0011\b\u0003{\u0005\u0003\"AP\u0017\u000e\u0003}R!\u0001Q\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0011U&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\".Q\u0011!qi\u0014)\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u00051\u000b\u0013A\u00029be\u0006l7/\u0003\u0002O\u0013\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd\u0013!U\u0011\u0002%\u0006\u0011!p\u001b\u0015\u0005\tQC\u0016\f\u0005\u0002V-6\t1*\u0003\u0002X\u0017\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u00025\u0006A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002]Q,7\u000f^'jeJ|'/\u001b8h/&$\b\u000eV5fe&tw-\u00128bE2,Gm\u00148T_V\u00148-Z!oI\u0012+7\u000f\u001e\u000b\u0003WuCQAO\u0003A\u0002mBC!B$P?2\n\u0011\u000b\u000b\u0003\u0006)bK\u0016!\t<fe&4\u00170T5se>\u0014\u0018N\\4XSRDG+[3sS:<WI\\1cY\u0016$GcA\u0016d[\")AM\u0002a\u0001K\u0006\u00012o\\;sG\u0016$v\u000e]5d!J|\u0007o\u001d\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA!\u001e;jY*\t!.\u0001\u0003kCZ\f\u0017B\u00017h\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006]\u001a\u0001\r!Z\u0001\u000fI\u0016\u001cH\u000fV8qS\u000e\u0004&o\u001c9t\u00035)g.\u00192mKRKWM]5oOR\u00191&\u001d<\t\u000bI<\u0001\u0019A:\u0002\u000f\rdWo\u001d;feB\u0011a\u0003^\u0005\u0003k>\u0011ac\u00117vgR,'\u000fT5oWR+7\u000f\u001e%be:,7o\u001d\u0005\u0006o\u001e\u0001\raO\u0001\u0007EV\u001c7.\u001a;\u0016\u0003\u0015\f\u0011\u0002^5feB\u0013x\u000e]:\u00027A\u0014x\u000eZ;dK\u0006sGmU5nk2\fG/\u001a*fi\u0016tG/[8o)\tYC\u0010C\u0003~\u0015\u0001\u0007a0\u0001\u0005qe>$WoY3s!\u001dy\u0018QBA\t\u0003#i!!!\u0001\u000b\u0007u\f\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011aB2mS\u0016tGo\u001d\u0006\u0004%\u0005%!bAA\u0006K\u00051\u0011\r]1dQ\u0016LA!a\u0004\u0002\u0002\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u0004R\u0001LA\n\u0003/I1!!\u0006.\u0005\u0015\t%O]1z!\ra\u0013\u0011D\u0005\u0004\u00037i#\u0001\u0002\"zi\u0016\fqc^1jiVsG/\u001b7TK\u001elWM\u001c;t)&,'/\u001a3\u0015\u000b-\n\t#a\t\t\u000bI\\\u0001\u0019A:\t\u000f\u0005\u00152\u00021\u0001\u0002(\u0005qQ.\u001b8Ok6\u001cVmZ7f]R\u001c\bc\u0002\u001f\u0002*\u00055\u0012\u0011H\u0005\u0004\u0003W)%aA'baB!\u0011qFA\u001b\u001b\t\t\tD\u0003\u0003\u00024\u0005\u001d\u0011AB2p[6|g.\u0003\u0003\u00028\u0005E\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004Y\u0005m\u0012bAA\u001f[\t\u0019\u0011J\u001c;\u0002#MLW.\u001e7bi\u0016\u0014V\r^3oi&|g\u000eF\u0002,\u0003\u0007BQA\u001d\u0007A\u0002M\f\u0011\u0002\\3bI\u0016\u0014Hj\\4\u0015\r\u0005%\u0013QKA,!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(#\u0005\u0019An\\4\n\t\u0005M\u0013Q\n\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0003s\u001b\u0001\u00071\u000fC\u0004\u0002Z5\u0001\r!!\f\u0002\u0005Q\u0004\bf\u0002\u0001\u0002^\u0005\r\u0014Q\r\t\u0004=\u0005}\u0013bAA1?\t\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\u0005\u001d\u0014aC5oi\u0016<'/\u0019;j_:\u0004")
public class ClusterLinkTierIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$1 = SecurityProtocol.PLAINTEXT;
            int x$2 = 0;
            Option<SecurityProtocol> x$3 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            int x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$3, x$2, x$4));
            SecurityProtocol x$5 = SecurityProtocol.PLAINTEXT;
            int x$6 = 100;
            Option<SecurityProtocol> x$7 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            int x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$7, x$6, x$8));
            return;
        }
        if (this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$9 = SecurityProtocol.SASL_SSL;
            int x$10 = 0;
            Option<SecurityProtocol> x$11 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            int x$12 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$9, x$11, x$10, x$12));
            SecurityProtocol x$13 = SecurityProtocol.SASL_PLAINTEXT;
            int x$14 = 100;
            Option<SecurityProtocol> x$15 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            int x$16 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$13, x$15, x$14, x$16));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testMirroringWithTieringEnabledOnSource(String quorum) {
        this.enableTiering(this.sourceCluster(), "sourceBucket");
        super.setUp(this._testInfo);
        this.verifyMirroringWithTieringEnabled(this.sourceTopicProps(), new Properties());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testMirroringWithTieringEnabledOnSourceAndDest(String quorum) {
        this.enableTiering(this.sourceCluster(), "sourceBucket");
        this.enableTiering(this.destCluster(), "destBucket");
        super.setUp(this._testInfo);
        this.verifyMirroringWithTieringEnabled(this.sourceTopicProps(), this.tierProps());
    }

    private void verifyMirroringWithTieringEnabled(Properties sourceTopicProps, Properties destTopicProps) {
        this.numPartitions_$eq(2);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, sourceTopicProps, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        ByteArraySerializer x$6 = qual$2.createProducer$default$1();
        ByteArraySerializer x$7 = qual$2.createProducer$default$2();
        Properties x$8 = qual$2.createProducer$default$3();
        KafkaProducer producer = qual$2.createProducer(x$6, x$7, x$8);
        this.produceAndSimulateRetention(producer);
        this.consume(this.sourceCluster(), this.consume$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$9 = this.linkName();
        ClusterLinkTestHarness x$10 = this.sourceCluster();
        long x$11 = qual$3.createDestClusterLink$default$3();
        long x$12 = qual$3.createDestClusterLink$default$4();
        long x$13 = qual$3.createDestClusterLink$default$5();
        Properties x$14 = qual$3.createDestClusterLink$default$6();
        qual$3.createDestClusterLink(x$9, x$10, x$11, x$12, x$13, x$14);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$15 = this.topic();
        short x$16 = this.replicationFactor();
        String x$17 = this.linkName();
        scala.collection.mutable.Map x$18 = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(destTopicProps).asScala();
        String x$19 = qual$4.linkTopic$default$5();
        qual$4.linkTopic(x$15, x$16, x$17, (Map<String, String>)x$18, x$19);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.produceAndSimulateRetention(producer);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    private void enableTiering(ClusterLinkTestHarness cluster, String bucket) {
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        cluster.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), bucket);
        cluster.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
    }

    /*
     * WARNING - void declaration
     */
    private Properties sourceTopicProps() {
        void var1_1;
        Properties props = new Properties();
        props.putAll((java.util.Map<?, ?>)this.tierProps());
        props.put("segment.bytes", "2000");
        props.put("retention.bytes", "-1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties tierProps() {
        void var1_1;
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("confluent.tier.local.hotset.bytes", "1000");
        return var1_1;
    }

    private void produceAndSimulateRetention(KafkaProducer<byte[], byte[]> producer) {
        scala.collection.immutable.Map minTiered = ((TraversableOnce)this.partitions(this.partitions$default$1()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)BoxesRunTime.boxToInteger((int)(this.leaderLog(this.sourceCluster(), (TopicPartition)tp).tierPartitionState().numSegments() + 3))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> this.produceRecords(producer, this.topic(), 50, this.produceRecords$default$4()));
        this.waitUntilSegmentsTiered(this.sourceCluster(), (scala.collection.immutable.Map<TopicPartition, Object>)minTiered);
        this.simulateRetention(this.sourceCluster());
    }

    private void waitUntilSegmentsTiered(ClusterLinkTestHarness cluster, scala.collection.immutable.Map<TopicPartition, Object> minNumSegments) {
        this.partitions(this.partitions$default$1()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$1(this, cluster, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(ClusterLinkTestHarness cluster) {
        this.partitions(this.partitions$default$1()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$1(this, cluster, tp);
            return BoxedUnit.UNIT;
        });
    }

    private AbstractLog leaderLog(ClusterLinkTestHarness cluster, TopicPartition tp) {
        LogManager qual$1 = cluster.partitionLeader(tp).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(tp, x$2).get();
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierState$1, int minSegments$1) {
        return tierState$1.numSegments() >= minSegments$1 && tierState$1.endOffset() == tierState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(scala.collection.immutable.Map minNumSegments$1) {
        return new StringBuilder(54).append("Timed out waiting for ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$1, scala.collection.immutable.Map minNumSegments$1, TopicPartition tp) {
        TierPartitionState tierState = $this.leaderLog(cluster$1, tp).tierPartitionState();
        int minSegments = BoxesRunTime.unboxToInt((Object)minNumSegments$1.apply((Object)tp));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$2(tierState, minSegments)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkTierIntegrationTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$simulateRetention$2(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$2, TopicPartition tp$1) {
        return $this.leaderLog(cluster$2, tp$1).deleteOldSegments() > 0;
    }

    public static final /* synthetic */ String $anonfun$simulateRetention$3() {
        return "tiered segments should have been deleted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$simulateRetention$1(ClusterLinkTierIntegrationTest $this, ClusterLinkTestHarness cluster$2, TopicPartition tp) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$2($this, cluster$2, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkTierIntegrationTest.$anonfun$simulateRetention$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }
}

