/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iA\u0011\u0002\b\u0001A\u0002\u0003\u0005\u000b\u0015B\u000f\t\u000b%\u0002A\u0011\t\u0016\t\u000b]\u0002A\u0011\u0001\u001d\t\u000bu\u0002A\u0011\u0001\u001d\t\u000b}\u0002A\u0011\u0002!\t\u000f-\u0003\u0011\u0013!C\u0005\u0019\")q\u000b\u0001C\u0005q!)\u0001\f\u0001C\u00053\")1\u000e\u0001C\u0005Y\")A\u000f\u0001C\u0005k\")Q\u0010\u0001C\u0005}\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r!AE\"mkN$XM\u001d'j].\u001c6\u000f\u001c+fgRT!\u0001E\t\u0002\t1Lgn\u001b\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1r#D\u0001\u0010\u0013\tArB\u0001\u0012BEN$(/Y2u\u00072,8\u000f^3s\u0019&t7.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002\u0013}#Xm\u001d;J]\u001a|\u0007C\u0001\u0010(\u001b\u0005y\"B\u0001\u0011\"\u0003\r\t\u0007/\u001b\u0006\u0003E\r\nqA[;qSR,'O\u0003\u0002%K\u0005)!.\u001e8ji*\ta%A\u0002pe\u001eL!\u0001K\u0010\u0003\u0011Q+7\u000f^%oM>\fQa]3u+B$\"aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\r\u0001\r!H\u0001\ti\u0016\u001cH/\u00138g_\"\u00121\u0001\u000e\t\u0003=UJ!AN\u0010\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0010uKN$8\t\\;ti\u0016\u0014H*\u001b8l/&$\b\u000eU3n'Nd7\u000b^8sKN$\u0012a\u000b\u0015\u0003\ti\u0002\"AH\u001e\n\u0005qz\"\u0001\u0002+fgR\fA\u0004^3ti\u0016s7M]=qi&|gnU3de\u0016$(k\u001c;bi&|g\u000e\u000b\u0002\u0006u\u0005a1o\u001d7MS:\\\u0007K]8qgR\u0011\u0011)\u0013\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0015\u001a\u0001\n\u00111\u0001B\u00035yg/\u001a:sS\u0012,\u0007K]8qg\u000612o\u001d7MS:\\\u0007K]8qg\u0012\"WMZ1vYR$\u0013'F\u0001NU\t\tejK\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0005v]\u000eDWmY6fI*\u0011A+L\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,R\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000bm\u0016\u0014\u0018NZ=MS:\\\u0017a\u00032s_.,'\u000f\u0015:paN,\u0012A\u0017\t\u0005\u0005nk\u0006.\u0003\u0002]\u0007\n9\u0001*Y:i\u001b\u0006\u0004\bC\u00010f\u001d\ty6\r\u0005\u0002a[5\t\u0011M\u0003\u0002c'\u00051AH]8pizJ!\u0001Z\u0017\u0002\rA\u0013X\rZ3g\u0013\t1wM\u0001\u0004TiJLgn\u001a\u0006\u0003I6\u0002\"\u0001L5\n\u0005)l#AB!osJ+g-\u0001\u000bf]\u000e|G-\u001a:XSRDw\n\u001c3TK\u000e\u0014X\r^\u000b\u0002[B\u0011aN]\u0007\u0002_*\u0011\u0001\u0003\u001d\u0006\u0003cF\taa]3sm\u0016\u0014\u0018BA:p\u0005]\u0019VmY;sK2Kgn[\"p]\u001aLw-\u00128d_\u0012,'/\u0001\teK\u000e|G-\u001a'j].\u001cuN\u001c4jOR\u00191F\u001e=\t\u000b]\\\u0001\u0019A7\u0002\u000f\u0015t7m\u001c3fe\")\u0011p\u0003a\u0001u\u00061A.\u001b8l\u0013\u0012\u0004\"AQ>\n\u0005q\u001c%\u0001B+V\u0013\u0012\u000bac^1ji\u001a{'o\u00147e'\u0016\u001c'/\u001a;EK2,G/\u001a\u000b\u0003W}DQ!\u001f\u0007A\u0002i\f\u0001D^3sS\u001aL8i\u001c8gS\u001e\fe\r^3s%\u0016\u001cH/\u0019:u)\u0015Y\u0013QAA\u0004\u0011\u0015IX\u00021\u0001{\u0011\u001d\tI!\u0004a\u0001\u0003\u0017\t\u0011\"\u001a=qK\u000e$x\n\u001c3\u0011\u00071\ni!C\u0002\u0002\u00105\u0012qAQ8pY\u0016\fg\u000eK\u0004\u0001\u0003'\tI\"a\u0007\u0011\u0007y\t)\"C\u0002\u0002\u0018}\u00111\u0001V1h\u0003\u00151\u0018\r\\;fC\t\ti\"A\u0006j]R,wM]1uS>t\u0007")
public class ClusterLinkSslTest
extends AbstractClusterLinkIntegrationTest {
    private TestInfo _testInfo;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this._testInfo = testInfo;
    }

    @Test
    public void testClusterLinkWithPemSslStores() {
        super.setUp(this._testInfo);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.sslLinkProps(this.sslLinkProps$default$1());
        Some x$3 = new Some((Object)((KafkaBroker)this.sourceCluster().brokers().head()).clusterId());
        boolean x$4 = qual$1.createClusterLink$default$4();
        UUID linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        Config linkConfig = this.destCluster().describeClusterLink(this.linkName());
        scala.collection.immutable.Map linkProps = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(linkConfig.entries()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.name()), (Object)e.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.keystore.type"));
        Assertions.assertEquals((Object)"PEM", (Object)linkProps.apply((Object)"ssl.truststore.type"));
        this.verifyConfigAfterRestart(linkId, true);
        this.verifyLink();
        Properties overrideProps = new Properties();
        overrideProps.setProperty("ssl.truststore.location", this.destCluster().clientSecurityProps(this.linkName()).getProperty("ssl.truststore.location"));
        Properties invalidLinkProps = this.sslLinkProps(overrideProps);
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "SSL handshake failed");
        invalidLinkProps.remove("ssl.truststore.certificates");
        invalidLinkProps.setProperty("ssl.truststore.location", "nonexistent.pem");
        this.verifyValidateLinkFailure(invalidLinkProps, InvalidConfigurationException.class, "Unable to create client using provided properties when validating the cluster link: Failed to load PEM SSL keystore nonexistent.pem, root cause: java.nio.file.NoSuchFileException: nonexistent.pem");
    }

    @Test
    public void testEncryptionSecretRotation() {
        this.destCluster().serverConfig().put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "password-encoder-old-secret");
        this.destCluster().serverConfig().put("confluent.password.encoder.old.secret.ttl.ms", "1000");
        super.setUp(this._testInfo);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Properties x$2 = this.sslLinkProps(this.sslLinkProps$default$1());
        Some x$3 = new Some((Object)((KafkaBroker)this.sourceCluster().brokers().head()).clusterId());
        boolean x$4 = qual$1.createClusterLink$default$4();
        UUID linkId = qual$1.createClusterLink(x$1, x$2, (Option<String>)x$3, x$4);
        this.waitForOldSecretDelete(linkId);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$5 = "anotherLink";
        Properties x$6 = this.sslLinkProps(this.sslLinkProps$default$1());
        None$ x$7 = None$.MODULE$;
        boolean x$8 = qual$2.createClusterLink$default$4();
        this.waitForOldSecretDelete(qual$2.createClusterLink(x$5, x$6, (Option<String>)x$7, x$8));
        HashMap<String, Object> encoderProps = this.brokerProps();
        encoderProps.remove("confluent.password.encoder.old.secret.ttl.ms");
        SecureLinkConfigEncoder encoder = new SecureLinkConfigEncoder(new KafkaConfig(encoderProps));
        Properties linkProps = this.destCluster().adminZkClient().fetchClusterLinkConfig(linkId);
        this.destCluster().adminZkClient().changeClusterLinkConfig(linkId, (Properties)encoder.maybeReencode(linkProps).get());
        this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
        this.verifyConfigAfterRestart(linkId, false);
        this.verifyLink();
    }

    /*
     * WARNING - void declaration
     */
    private Properties sslLinkProps(Properties overrideProps) {
        void var2_2;
        Properties props = new Properties();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        ListenerName x$1 = qual$1.bootstrapServers$default$1();
        props.put("bootstrap.servers", qual$1.bootstrapServers(x$1));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(this.sourceCluster().clientSecurityProps(this.linkName()));
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(overrideProps);
        TestSslUtils.convertToPemWithoutFiles((Properties)props);
        Assertions.assertNull((Object)props.get("ssl.keystore.location"));
        Assertions.assertNull((Object)props.get("ssl.truststore.location"));
        return var2_2;
    }

    private Properties sslLinkProps$default$1() {
        return new Properties();
    }

    private void verifyLink() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.produceToSourceCluster(20);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> brokerProps() {
        void var1_1;
        HashMap props = new HashMap();
        props.putAll(((KafkaBroker)this.destCluster().brokers().head()).config().originals());
        return var1_1;
    }

    private SecureLinkConfigEncoder encoderWithOldSecret() {
        HashMap<String, Object> oldEncoderProps = this.brokerProps();
        oldEncoderProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), oldEncoderProps.remove(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp()));
        return new SecureLinkConfigEncoder(new KafkaConfig(oldEncoderProps));
    }

    private void decodeLinkConfig(SecureLinkConfigEncoder encoder, UUID linkId) {
        Properties props = this.destCluster().zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString());
        encoder.clusterLinkConfig(props);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOldSecretDelete(UUID linkId) {
        SecureLinkConfigEncoder oldEncoder = this.encoderWithOldSecret();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$1(this, oldEncoder, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkSslTest.$anonfun$waitForOldSecretDelete$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void verifyConfigAfterRestart(UUID linkId, boolean expectOld) {
        int brokerId = ((KafkaBroker)this.destCluster().brokers().head()).config().brokerId();
        this.destCluster().shutdownBroker(brokerId);
        this.destCluster().startBroker(brokerId);
        if (expectOld) {
            this.decodeLinkConfig(this.encoderWithOldSecret(), linkId);
            return;
        }
        this.waitForOldSecretDelete(linkId);
    }

    public static final /* synthetic */ boolean $anonfun$waitForOldSecretDelete$1(ClusterLinkSslTest $this, SecureLinkConfigEncoder oldEncoder$1, UUID linkId$1) {
        try {
            $this.decodeLinkConfig(oldEncoder$1, linkId$1);
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static final /* synthetic */ String $anonfun$waitForOldSecretDelete$2() {
        return "Configs encrypted with old secret not deleted";
    }

    public ClusterLinkSslTest() {
        SecurityProtocol x$1 = SecurityProtocol.SSL;
        int x$2 = 0;
        Option<SecurityProtocol> x$3 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        int x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
        this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$3, x$2, x$4));
        SecurityProtocol x$5 = SecurityProtocol.SSL;
        int x$6 = 100;
        Option<SecurityProtocol> x$7 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
        int x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$4();
        this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$7, x$6, x$8));
    }
}

