/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.link.MockPolicy;
import kafka.server.KafkaConfig$;
import kafka.utils.TestInfoUtils$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.reflect.ScalaSignature;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019Bq\u0001\u000b\u0001C\u0002\u0013\u0005\u0013\u0006\u0003\u00041\u0001\u0001\u0006IA\u000b\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u0019Y\u0004\u0001)A\u0005g!9A\b\u0001b\u0001\n\u0003i\u0004B\u0002#\u0001A\u0003%a\bC\u0004F\u0001\t\u0007I\u0011A\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u001d9\u0005A1A\u0005\u0002uBa\u0001\u0013\u0001!\u0002\u0013q\u0004bB%\u0001\u0005\u0004%\t!\u0010\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002 \t\u0013-\u0003\u0001\u0019!A!B\u0013a\u0005\"\u0002-\u0001\t\u0003J\u0006\"B2\u0001\t\u0013!\u0007bB=\u0001#\u0003%IA\u001f\u0005\n\u0003\u0017\u0001\u0011\u0013!C\u0005\u0003\u001bAq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA2\u0001\u0011%\u0011\u0011\r\u0005\b\u0003K\u0002A\u0011BA1\u0011\u001d\t9\u0007\u0001C\u0005\u0003C\u0012Qc\u00117vgR,'\u000fT5oWB{G.[2z)\u0016\u001cHO\u0003\u0002\u001d;\u0005!A.\u001b8l\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0012\u000e\u0003mI!\u0001J\u000e\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002#\u0001\u0005\t\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012Qa\u00155peR\f!C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sA\u0005\u0019Bo\u001c9jGNKhnY%oi\u0016\u0014h/\u00197NgV\t1\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005!A.\u00198h\u0015\u0005A\u0014\u0001\u00026bm\u0006L!AO\u001b\u0003\rM#(/\u001b8h\u0003Q!x\u000e]5d'ft7-\u00138uKJ4\u0018\r\\'tA\u0005Ib/[8mCRLgnZ!mo\u0006L8oU=oG\u000e{gNZ5h+\u0005q\u0004CA C\u001b\u0005\u0001%BA!8\u0003\u0011)H/\u001b7\n\u0005\r\u0003%A\u0003)s_B,'\u000f^5fg\u0006Qb/[8mCRLgnZ!mo\u0006L8oU=oG\u000e{gNZ5hA\u0005)b/\u00197jI\u0006cw/Y=t'ft7mQ8oM&<\u0017A\u0006<bY&$\u0017\t\\<bsN\u001c\u0016P\\2D_:4\u0017n\u001a\u0011\u00021YLw\u000e\\1uS:<g*\u001a<feNKhnY\"p]\u001aLw-A\rwS>d\u0017\r^5oO:+g/\u001a:Ts:\u001c7i\u001c8gS\u001e\u0004\u0013\u0001\u0006<bY&$g*\u001a<feNKhnY\"p]\u001aLw-A\u000bwC2LGMT3wKJ\u001c\u0016P\\2D_:4\u0017n\u001a\u0011\u0002\u0013}#Xm\u001d;J]\u001a|\u0007CA'W\u001b\u0005q%BA(Q\u0003\r\t\u0007/\u001b\u0006\u0003#J\u000bqA[;qSR,'O\u0003\u0002T)\u0006)!.\u001e8ji*\tQ+A\u0002pe\u001eL!a\u0016(\u0003\u0011Q+7\u000f^%oM>\fQa]3u+B$\"AW/\u0011\u0005-Z\u0016B\u0001/-\u0005\u0011)f.\u001b;\t\u000by{\u0001\u0019\u0001'\u0002\u0011Q,7\u000f^%oM>D#a\u00041\u0011\u00055\u000b\u0017B\u00012O\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u000eg\u0016$X\u000b]\"mkN$XM]:\u0015\u0007i+'\u000eC\u0004g!A\u0005\t\u0019A4\u0002;=4XM\u001d:jI\u00164\u0016n\u001c7bi&twmS1gW\u0006$UMZ1vYR\u0004\"a\u000b5\n\u0005%d#a\u0002\"p_2,\u0017M\u001c\u0005\bWB\u0001\n\u00111\u0001m\u0003Y\u0019x.\u001e:dK\u000ecWo\u001d;fe>3XM\u001d:jI\u0016\u001c\b\u0003B7uo^t!A\u001c:\u0011\u0005=dS\"\u00019\u000b\u0005E|\u0012A\u0002\u001fs_>$h(\u0003\u0002tY\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\u00075\u000b\u0007O\u0003\u0002tYA\u0011Q\u000e_\u0005\u0003uY\fqc]3u+B\u001cE.^:uKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003mT#a\u001a?,\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015A&\u0001\u0006b]:|G/\u0019;j_:L1!!\u0003\u0000\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018g\u0016$X\u000b]\"mkN$XM]:%I\u00164\u0017-\u001e7uII*\"!a\u0004+\u00051d\u0018!\u0011;fgRl\u0015N\u001d:peR{\u0007/[2De\u0016\fG/[8o\u0007>tg-[4Q_2L7-_*pkJ\u001cWm\u00117vgR,'oV5uQZ\u000bG.\u001b3EK\u001a\fW\u000f\u001c;t)\rQ\u0016Q\u0003\u0005\u0007\u0003/\u0019\u0002\u0019A<\u0002\rE,xN];nQ\u001d\u0019\u00121DA\u0016\u0003[\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\t)\u0003U\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005%\u0012q\u0004\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005=\u00121G\u0011\u0003\u0003c\t!A_6\"\u0005\u0005U\u0012!B6sC\u001a$\bfB\n\u0002:\u0005\u0005\u00131\t\t\u0005\u0003w\ti$\u0004\u0002\u0002$%!\u0011qHA\u0012\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002F\u0005A2\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?\u0002\u000bR,7\u000f^\"sK\u0006$X-T5se>\u00148k\\;sG\u0016\fEn^1zgNKhnY\"p]\u001aLwm\u00117vgR,'\u000fT3wK2|e/\u001a:sS\u0012$WM\u001c,j_2\fG/[8o)\rQ\u00161\n\u0005\u0007\u0003/!\u0002\u0019A<)\u000fQ\tY\"a\u000b\u0002P1\"\u0011qFA\u001aQ\u001d!\u0012\u0011HA!\u0003\u0007\nq\b^3ti\u000e\u0013X-\u0019;f\u001b&\u0014(o\u001c:T_V\u00148-Z!mo\u0006L8oU=oG\u000e{gNZ5h\u0011\u0006\u0014HmQ8eK\u0012$UMZ1vYR4\u0016n\u001c7bi&|g\u000eF\u0002[\u0003/Ba!a\u0006\u0016\u0001\u00049\bfB\u000b\u0002\u001c\u0005-\u00121\f\u0017\u0005\u0003_\t\u0019\u0004K\u0004\u0016\u0003s\t\t%a\u0011\u0002yY,'/\u001b4z\u0007J,\u0017\r^3NSJ\u0014xN]*pkJ\u001cW-\u00117xCf\u001c8+\u001f8d\u0007>tg-[4U_BL7\rT3wK2|e/\u001a:sS\u0012$WM\u001c\u000b\u00025\u0006Yd/\u001a:jMf\u001c%/Z1uK6K'O]8s'>,(oY3OKZ,'oU=oG\u000e{gNZ5h)>\u0004\u0018n\u0019'fm\u0016dwJ^3se&$G-\u001a8\u0002QY,'/\u001b4z\u0007J,\u0017\r^3NSJ\u0014xN\u001d)bgNLgn\u001a,j_2\fG/\u001b8h\u0007>tg-[4\u0002[Y,'/\u001b4z%VtG/[7f\t\u0016\u001cH/\u001b8bi&|gnQ8oM&<7\t[1oO\u00164\u0016n\u001c7bi&|g\u000eK\u0004\u0001\u0003W\n\t(a\u001d\u0011\u00075\u000bi'C\u0002\u0002p9\u00131\u0001V1h\u0003\u00151\u0018\r\\;fC\t\t)(A\u0006j]R,wM]1uS>t\u0007")
public class ClusterLinkPolicyTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor;
    private final String topicSyncIntervalMs;
    private final Properties violatingAlwaysSyncConfig;
    private final Properties validAlwaysSyncConfig;
    private final Properties violatingNeverSyncConfig;
    private final Properties validNeverSyncConfig;
    private TestInfo _testInfo;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    public Properties violatingAlwaysSyncConfig() {
        return this.violatingAlwaysSyncConfig;
    }

    public Properties validAlwaysSyncConfig() {
        return this.validAlwaysSyncConfig;
    }

    public Properties violatingNeverSyncConfig() {
        return this.violatingNeverSyncConfig;
    }

    public Properties validNeverSyncConfig() {
        return this.validNeverSyncConfig;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this._testInfo = testInfo;
    }

    private void setUpClusters(boolean overrideViolatingKafkaDefault, scala.collection.immutable.Map<String, String> sourceClusterOverrides) {
        if (TestInfoUtils$.MODULE$.isKRaft(this._testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$1 = SecurityProtocol.PLAINTEXT;
            int x$2 = 0;
            int x$3 = 1;
            Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$4, x$2, x$3));
            SecurityProtocol x$5 = SecurityProtocol.PLAINTEXT;
            int x$6 = 100;
            int x$7 = 1;
            Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$8, x$6, x$7));
            this.destCluster().controllerConfigOverrides().setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockPolicy.MockCreateTopicPolicy.class.getName());
            this.destCluster().controllerConfigOverrides().setProperty(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), MockPolicy.MockAlterTopicPolicy.class.getName());
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$9 = SecurityProtocol.SASL_SSL;
            int x$10 = 0;
            int x$11 = 1;
            Option<SecurityProtocol> x$12 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$9, x$12, x$10, x$11));
            SecurityProtocol x$13 = SecurityProtocol.SASL_PLAINTEXT;
            int x$14 = 100;
            int x$15 = 1;
            Option<SecurityProtocol> x$16 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$13, x$16, x$14, x$15));
            this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockPolicy.MockCreateTopicPolicy.class.getName());
            this.destCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), MockPolicy.MockAlterTopicPolicy.class.getName());
        }
        if (sourceClusterOverrides.nonEmpty()) {
            sourceClusterOverrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                Object object = this.sourceCluster().serverConfig().setProperty(k, v);
                return object;
            });
        }
        if (overrideViolatingKafkaDefault) {
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp(), "500");
        }
        super.setUp(this._testInfo);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
    }

    private boolean setUpClusters$default$1() {
        return true;
    }

    private scala.collection.immutable.Map<String, String> setUpClusters$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorTopicCreationConfigPolicySourceClusterWithValidDefaults(String quorum) {
        this.setUpClusters(this.setUpClusters$default$1(), this.setUpClusters$default$2());
        this.verifyCreateMirrorSourceAlwaysSyncConfigTopicLevelOverridden();
        this.verifyCreateMirrorSourceNeverSyncConfigTopicLevelOverridden();
        this.verifyCreateMirrorPassingViolatingConfig();
        this.verifyRuntimeDestinationConfigChangeViolation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateMirrorSourceAlwaysSyncConfigClusterLevelOverriddenViolation(String quorum) {
        this.setUpClusters(false, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerMaxCompactionLagMsProp()), (Object)"2000")}))));
        String topic = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        short x$2 = this.replicationFactor();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5);
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$1;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topic$1;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                Map<String, String> x$4 = qual$1.linkTopic$default$4();
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        }, (String)new StringBuilder(87).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source cluster defaults violate the destination policy").toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateMirrorSourceAlwaysSyncConfigHardCodedDefaultViolation(String quorum) {
        this.setUpClusters(false, this.setUpClusters$default$2());
        String topic = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        short x$2 = this.replicationFactor();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5);
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$2;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topic$2;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                Map<String, String> x$4 = qual$1.linkTopic$default$4();
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        }, (String)new StringBuilder(98).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source cluster hard-coded defaults violate the destination policy").toString());
    }

    private void verifyCreateMirrorSourceAlwaysSyncConfigTopicLevelOverridden() {
        String topicWithViolatingAlwaysSyncConfig = UUID.randomUUID().toString();
        String topicWithValidAlwaysSyncConfig = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.violatingAlwaysSyncConfig();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topicWithViolatingAlwaysSyncConfig, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = this.validAlwaysSyncConfig();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topicWithValidAlwaysSyncConfig, x$7, x$8, x$9, x$10);
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topicWithViolatingAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithViolatingAlwaysSyncConfig$1;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topicWithViolatingAlwaysSyncConfig$1;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                Map<String, String> x$4 = qual$1.linkTopic$default$4();
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithViolatingAlwaysSyncConfig$1 = topicWithViolatingAlwaysSyncConfig$1;
            }
        }, (String)new StringBuilder(95).append("Mirror should fail with ").append(PolicyViolationException.class).append(" because ").append("source topic config overridden violates the destination policy").toString());
        Assertions.assertDoesNotThrow(() -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            short x$12 = this.replicationFactor();
            String x$13 = this.linkName();
            Map<String, String> x$14 = qual$3.linkTopic$default$4();
            String x$15 = qual$3.linkTopic$default$5();
            return qual$3.linkTopic(topicWithValidAlwaysSyncConfig, x$12, x$13, x$14, x$15);
        }, (String)"Mirror should not fail");
    }

    private void verifyCreateMirrorSourceNeverSyncConfigTopicLevelOverridden() {
        String topicWithViolatingNeverSyncConfig = UUID.randomUUID().toString();
        String topicWithValidNeverSyncConfig = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.violatingNeverSyncConfig();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topicWithViolatingNeverSyncConfig, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = this.validNeverSyncConfig();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topicWithValidNeverSyncConfig, x$7, x$8, x$9, x$10);
        Assertions.assertDoesNotThrow(() -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            short x$12 = this.replicationFactor();
            String x$13 = this.linkName();
            Map<String, String> x$14 = qual$3.linkTopic$default$4();
            String x$15 = qual$3.linkTopic$default$5();
            qual$3.linkTopic(topicWithViolatingNeverSyncConfig, x$12, x$13, x$14, x$15);
            ClusterLinkTestHarness qual$4 = this.destCluster();
            short x$17 = this.replicationFactor();
            String x$18 = this.linkName();
            Map<String, String> x$19 = qual$4.linkTopic$default$4();
            String x$20 = qual$4.linkTopic$default$5();
            return qual$4.linkTopic(topicWithValidNeverSyncConfig, x$17, x$18, x$19, x$20);
        }, (String)"Mirror should not fail");
    }

    private void verifyCreateMirrorPassingViolatingConfig() {
        String topic = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        short x$2 = this.replicationFactor();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5);
        Assertions.assertThrows(InvalidConfigurationException.class, (Executable)new Executable(this, topic){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topic$3;

            public void execute() {
                ClusterLinkTestHarness qual$1 = this.$outer.destCluster();
                String x$1 = this.topic$3;
                short x$2 = this.$outer.replicationFactor();
                String x$3 = this.$outer.linkName();
                HashMap x$4 = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)"900")}));
                String x$5 = qual$1.linkTopic$default$5();
                qual$1.linkTopic(x$1, x$2, x$3, (Map<String, String>)x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        }, (String)new StringBuilder(124).append("Mirror should fail with ").append(InvalidConfigurationException.class).append(" because ").append("the config overridden passed by user during mirror creation violates the destination policy").toString());
    }

    private void verifyRuntimeDestinationConfigChangeViolation() {
        String topicWithValidAlwaysSyncConfig = UUID.randomUUID().toString();
        String topicWithValidNeverSyncConfig = UUID.randomUUID().toString();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = this.validAlwaysSyncConfig();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topicWithValidAlwaysSyncConfig, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = this.validNeverSyncConfig();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topicWithValidNeverSyncConfig, x$7, x$8, x$9, x$10);
        Assertions.assertDoesNotThrow(() -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            short x$12 = this.replicationFactor();
            String x$13 = this.linkName();
            Map<String, String> x$14 = qual$3.linkTopic$default$4();
            String x$15 = qual$3.linkTopic$default$5();
            qual$3.linkTopic(topicWithValidAlwaysSyncConfig, x$12, x$13, x$14, x$15);
            ClusterLinkTestHarness qual$4 = this.destCluster();
            short x$17 = this.replicationFactor();
            String x$18 = this.linkName();
            Map<String, String> x$19 = qual$4.linkTopic$default$4();
            String x$20 = qual$4.linkTopic$default$5();
            return qual$4.linkTopic(topicWithValidNeverSyncConfig, x$17, x$18, x$19, x$20);
        }, (String)"Mirror should not fail");
        Assertions.assertThrows(InvalidConfigurationException.class, (Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max.compaction.lag.ms"), (Object)"950")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)new StringBuilder(103).append("Alter config should fail with ").append(InvalidConfigurationException.class).append(" because ").append("we don't allow alternation on always-sync configs on destination").toString());
        Assertions.assertThrows(PolicyViolationException.class, (Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"2400")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)new StringBuilder(79).append("Alter config should fail with ").append(PolicyViolationException.class).append(" because ").append("the config value is violating the policy").toString());
        Assertions.assertDoesNotThrow((Executable)new Executable(this, topicWithValidAlwaysSyncConfig){
            private final /* synthetic */ ClusterLinkPolicyTest $outer;
            private final String topicWithValidAlwaysSyncConfig$2;

            public void execute() {
                this.$outer.destCluster().alterTopic(this.topicWithValidAlwaysSyncConfig$2, (Map<String, String>)((Map)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.ms"), (Object)"1600")}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicWithValidAlwaysSyncConfig$2 = topicWithValidAlwaysSyncConfig$2;
            }
        }, (String)"Alter config should not fail");
    }

    public ClusterLinkPolicyTest() {
        this.replicationFactor = 1;
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
        this.violatingAlwaysSyncConfig = new Properties(null){
            {
                this.put("max.compaction.lag.ms", "1050");
            }
        };
        this.validAlwaysSyncConfig = new Properties(null){
            {
                this.put("max.compaction.lag.ms", "950");
            }
        };
        this.violatingNeverSyncConfig = new Properties(null){
            {
                this.put("segment.ms", "500");
            }
        };
        this.validNeverSyncConfig = new Properties(null){
            {
                this.put("segment.ms", "1500");
            }
        };
    }
}

