/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaFetcherThread;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ConnectionMode;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.apache.kafka.common.errors.ClusterLinkInUseException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u00115a\u0001B A\u0001\u0015CQA\u0013\u0001\u0005\u0002-Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004V\u0001\u0001\u0006Ia\u0014\u0005\b-\u0002\u0011\r\u0011\"\u0001O\u0011\u00199\u0006\u0001)A\u0005\u001f\"9\u0001\f\u0001b\u0001\n\u0003I\u0006B\u00022\u0001A\u0003%!\fC\u0004d\u0001\t\u0007I\u0011\u00013\t\r=\u0004\u0001\u0015!\u0003f\u0011\u001d\u0001\bA1A\u0005\u0002\u0011Da!\u001d\u0001!\u0002\u0013)\u0007\"\u0002:\u0001\t\u0003\u0019\bbBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBAA\u0001\u0011\u0005\u00111\u0011\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!!*\u0001\t\u0003\t9\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0005'BqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0004\u0003j\u0001!\tAa\u001b\t\u000f\tU\u0004\u0001\"\u0001\u0003x!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BG\u0001\u0011\u0005!q\u0012\u0005\b\u00053\u0003A\u0011\u0001BN\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqA!-\u0001\t\u0003\u0011\u0019\fC\u0004\u0003>\u0002!\tAa0\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bq\u0001\u0011\u0005!1\u001d\u0005\b\u0005[\u0004A\u0011\u0003Bx\u0011\u001d\u0011\u0019\u0010\u0001C\t\u0005kD\u0011b!\u0002\u0001#\u0003%\tba\u0002\t\u000f\ru\u0001\u0001\"\u0001\u0004 !91\u0011\u0006\u0001\u0005\u0002\r-\u0002bBB\u001b\u0001\u0011\u00051q\u0007\u0005\b\u0007\u0003\u0002A\u0011AB\"\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007\u001fBqa!\u0017\u0001\t\u0003\u0019Y\u0006C\u0004\u0004f\u0001!\taa\u001a\t\u000f\rE\u0004\u0001\"\u0003\u0004t!I1\u0011\u0010\u0001\u0012\u0002\u0013%1q\u0001\u0005\b\u0007w\u0002A\u0011AB?\u0011\u001d\u00199\t\u0001C\u0001\u0007\u0013Cqaa%\u0001\t\u0003\u0019)\nC\u0004\u0004 \u0002!\ta!)\t\u000f\r-\u0006\u0001\"\u0001\u0004.\"91q\u0017\u0001\u0005\u0002\re\u0006bBBb\u0001\u0011\u00051Q\u0019\u0005\b\u0007\u001f\u0004A\u0011ABi\u0011\u001d\u0019\u0019\u0010\u0001C\u0005\u0007k\u0014!d\u00117vgR,'\u000fT5oW&sG/Z4sCRLwN\u001c+fgRT!!\u0011\"\u0002\t1Lgn\u001b\u0006\u0002\u0007\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001G!\t9\u0005*D\u0001A\u0013\tI\u0005I\u0001\u0012BEN$(/Y2u\u00072,8\u000f^3s\u0019&t7.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0003\"a\u0012\u0001\u0002\u001d=4gm]3u)>\u001cu.\\7jiV\tq\n\u0005\u0002Q'6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016K\u0001\u0003M_:<\u0017aD8gMN,G\u000fV8D_6l\u0017\u000e\u001e\u0011\u0002\u0015MLhn\u0019)fe&|G-A\u0006ts:\u001c\u0007+\u001a:j_\u0012\u0004\u0013!D2p]N,X.\u001a:He>,\b/F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003mC:<'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013aa\u0015;sS:<\u0017AD2p]N,X.\u001a:He>,\b\u000fI\u0001\fi>\u0004\u0018n\u0019$jYR,'/F\u0001f!\t1WN\u0004\u0002hWB\u0011\u0001.U\u0007\u0002S*\u0011!\u000eR\u0001\u0007yI|w\u000e\u001e \n\u00051\f\u0016A\u0002)sK\u0012,g-\u0003\u0002b]*\u0011A.U\u0001\ri>\u0004\u0018n\u0019$jYR,'\u000fI\u0001\u0017S:\u001cG.\u001e3f\u00032dGk\u001c9jGN4\u0015\u000e\u001c;fe\u00069\u0012N\\2mk\u0012,\u0017\t\u001c7U_BL7m\u001d$jYR,'\u000fI\u0001\u0016i\u0016\u001cHo\u0011:fCR,W*\u001b:s_J$v\u000e]5d)\t!x\u000f\u0005\u0002Qk&\u0011a/\u0015\u0002\u0005+:LG\u000fC\u0003y\u0019\u0001\u0007Q-\u0001\u0004rk>\u0014X/\u001c\u0015\u0007\u0019i\f\t\"a\u0005\u0011\u0007m\fi!D\u0001}\u0015\tih0\u0001\u0005qe>4\u0018\u000eZ3s\u0015\ry\u0018\u0011A\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\t\u0005\r\u0011QA\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t9!!\u0003\u0002\u000b),h.\u001b;\u000b\u0005\u0005-\u0011aA8sO&\u0019\u0011q\u0002?\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\t)\"!\u0007\"\u0005\u0005]\u0011A\u0001>lC\t\tY\"A\u0003le\u00064G\u000fK\u0004\r\u0003?\t9#!\u000b\u0011\t\u0005\u0005\u00121E\u0007\u0002}&\u0019\u0011Q\u0005@\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA\u0016\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001 i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]N<\u0016\u000e\u001e5NSJ\u0014xN\u001d+pa&\u001cGc\u0001;\u00022!)\u00010\u0004a\u0001K\"2QB_A\t\u0003kaC!!\u0006\u0002\u001a!:Q\"a\b\u0002(\u0005%\u0012!\n;fgR\u001cFo\u001c9NSJ\u0014xN\u001d+pa&\u001cw+\u001b;i\u0013:4\u0018\r\\5e%\u0016\fX/Z:u)\r!\u0018Q\b\u0005\u0006q:\u0001\r!\u001a\u0015\u0007\u001di\f\t\"!\u0011-\t\u0005U\u0011\u0011\u0004\u0015\b\u001d\u0005}\u0011qEA\u0015\u00039!Xm\u001d;Ti>\u0004X*\u001b:s_J$2\u0001^A%\u0011\u0015Ax\u00021\u0001fQ\u0019y!0!\u0005\u0002N1\"\u0011QCA\rQ\u001dy\u0011qDA\u0014\u0003S\tq\u0005^3tiN#x\u000e]'jeJ|'oV5uQN{WO]2f\u00072,8\u000f^3s'\",H\u000fZ8x]R\u0019A/!\u0016\t\u000ba\u0004\u0002\u0019A3)\rAQ\u0018\u0011CA-Y\u0011\t)\"!\u0007)\u000fA\ty\"a\n\u0002*\u0005\u0011C/Z:u\u0007J,\u0017\r^3B]\u0012$U\r\\3uK\u0006sGMU3de\u0016\fG/\u001a'j].$2\u0001^A1\u0011\u0015A\u0018\u00031\u0001fQ\u0019\t\"0!\u0005\u0002f1\"\u0011QCA\rQ\u001d\t\u0012qDA\u0014\u0003S\tA\u0003^3ti6K'O]8s\u001d\u0016<(+Z2pe\u0012\u001cHc\u0001;\u0002n!)\u0001P\u0005a\u0001K\"2!C_A\t\u0003cbC!!\u0006\u0002\u001a!:!#a\b\u0002(\u0005%\u0012!\u0007;fgRl\u0015N\u001d:pe\u0016C\u0018n\u001d;j]\u001e\u0014VmY8sIN$2\u0001^A=\u0011\u0015A8\u00031\u0001fQ\u0019\u0019\"0!\u0005\u0002~1\"\u0011QCA\rQ\u001d\u0019\u0012qDA\u0014\u0003S\t1\u0003^3tiR{\u0007/[2D_:4\u0017nZ*z]\u000e$2\u0001^AC\u0011\u0015AH\u00031\u0001fQ\u0019!\"0!\u0005\u0002\n2\"\u0011QCA\rQ\u001d!\u0012qDA\u0014\u0003S\ta\u0003^3ti2K7\u000f\u001e#fg\u000e\u0014\u0018NY3NSJ\u0014xN\u001d\u000b\u0004i\u0006E\u0005\"\u0002=\u0016\u0001\u0004)\u0007FB\u000b{\u0003#\t)\n\f\u0003\u0002\u0016\u0005e\u0001fB\u000b\u0002 \u0005\u001d\u0012\u0011F\u0001\u0017i\u0016\u001cHoU8ve\u000e,7\t\\;ti\u0016\u0014\u0018+^8uCR\u0019A/!(\t\u000ba4\u0002\u0019A3)\rYQ\u0018\u0011CAQY\t\t)\u0002K\u0004\u0017\u0003?\t9#!\u000b\u0002?Q,7\u000f\u001e#fgRLg.\u0019;j_:\u001cE.^:uKJd\u0015N\\6Rk>$\u0018\rF\u0002u\u0003SCQ\u0001_\fA\u0002\u0015Dca\u0006>\u0002\u0012\u00055F\u0006BA\u000b\u00033AsaFA\u0010\u0003O\tI#\u0001\u0016uKN$H)Z:uS:\fG/[8o\u00072,8\u000f^3s\u0019&t7N\u0011:pW\u0016\u0014H*\u001a<fYF+x\u000e^1\u0015\u0007Q\f)\fC\u0003y1\u0001\u0007Q\r\u000b\u0004\u0019u\u0006E\u0011\u0011\u0018\u0017\u0005\u0003+\tI\u0002K\u0004\u0019\u0003?\t9#!\u000b\u0002CY,'/\u001b4z\t\u0016\u001cH/\u001b8bi&|gn\u00117vgR,'\u000fT5oWF+x\u000e^1\u0015\r\u0005\u0005\u0017QZAz!\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAd=\u0006!Q\u000f^5m\u0013\u0011\tY-!2\u0003\tU+\u0016\n\u0012\u0005\b\u0003\u001fL\u0002\u0019AAi\u0003%\u0011Xm]8ve\u000e,7\u000f\u0005\u0004\u0002T\u0006e\u0017Q\\\u0007\u0003\u0003+T1!a6R\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\f)NA\u0002TKF\u0004B!a8\u0002p6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\f)/\u0001\u0004d_:4\u0017n\u001a\u0006\u0005\u0003O\fI/\u0001\u0004d_6lwN\u001c\u0006\u0004\u0007\u0006-(\u0002BAw\u0003\u0013\ta!\u00199bG\",\u0017\u0002BAy\u0003C\u0014abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0002vf\u0001\r!a>\u0002\u0013E,x\u000e^1N_\u0012,\u0007\u0003BA}\u00057qA!a?\u0003\u00169!\u0011Q B\t\u001d\u0011\tyPa\u0004\u000f\t\t\u0005!Q\u0002\b\u0005\u0005\u0007\u0011YA\u0004\u0003\u0003\u0006\t%ab\u00015\u0003\b%\u0011\u00111B\u0005\u0005\u0003[\fI!C\u0002D\u0003WLA!a:\u0002j&!\u00111]As\u0013\u0011\u0011\u0019\"!9\u0002\u0013%tG/\u001a:oC2\u001c\u0018\u0002\u0002B\f\u00053\t\u0001cQ8oM2,XM\u001c;D_:4\u0017nZ:\u000b\t\tM\u0011\u0011]\u0005\u0005\u0005;\u0011yB\u0001\u000bDYV\u001cH/\u001a:MS:\\\u0017+^8uC6{G-\u001a\u0006\u0005\u0005/\u0011I\"A\bwKJLg-_)v_R\fWj\u001c3f)\r!(Q\u0005\u0005\b\u0003kT\u0002\u0019AA|\u0003\u0001\"Wm\u001d;DYV\u001cH/\u001a:MS:\\'+\u001a9mS\u000e\f7\u000f\u00165s_R$H.\u001a3\u0015\u0005\t-\u0002c\u0001)\u0003.%\u0019!qF)\u0003\u000f\t{w\u000e\\3b]\u00069b/\u001a:jMf4U\r^2i%\u0016\u001c\bo\u001c8tKNK'0\u001a\u000b\u0006i\nU\"\u0011\b\u0005\b\u0005oa\u0002\u0019AAa\u0003\u0019a\u0017N\\6JI\"9!1\b\u000fA\u0002\tu\u0012\u0001D3ya\u0016\u001cG/\u001a3TSj,\u0007#\u0002)\u0003@\t\r\u0013b\u0001B!#\n1q\n\u001d;j_:\u0004BA!\u0012\u0003N5\u0011!q\t\u0006\u0004\u0003\n%#b\u0001B&\u0005\u000611/\u001a:wKJLAAa\u0014\u0003H\t\tb)\u001a;dQJ+7\u000f]8og\u0016\u001c\u0016N_3\u0002aQ,7\u000f\u001e#fgRLg.\u0019;j_:\u001cE.^:uKJd\u0015N\\6Rk>$\u0018mV5uQ\n\u0013xn[3s%\u0016\u001cH/\u0019:u)\r!(Q\u000b\u0005\u0006qv\u0001\r!\u001a\u0015\u0007;i\f\tB!\u0017-\t\u0005U\u0011\u0011\u0004\u0015\b;\u0005}\u0011qEA\u0015\u0003\u0015\"Xm\u001d;EKN$\u0018N\\1uS>tG*Y4MS:\\g)\u001a;dQ\u0016\u0014H\u000b\u001b:piRdW\rF\u0002u\u0005CBQ\u0001\u001f\u0010A\u0002\u0015DcA\b>\u0002\u0012\t\u0015D\u0006BA\u000b\u00033AsAHA\u0010\u0003O\tI#A\tuKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N$2\u0001\u001eB7\u0011\u0015Ax\u00041\u0001fQ\u0019y\"0!\u0005\u0003r1\"\u0011QCA\rQ\u001dy\u0012qDA\u0014\u0003S\t1\u0004^3ti\u0006cG/\u001a:DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u001cHc\u0001;\u0003z!)\u0001\u0010\ta\u0001K\"2\u0001E_A\t\u0005{bC!!\u0006\u0002\u001a!:\u0001%a\b\u0002(\u0005%\u0012!\u000b;fgR|eMZ:fi6KwM]1uS>tw+\u001b;i\u0003\u0012$W\rZ\"p]N,X.\u001a:He>,\b\u000fF\u0002u\u0005\u000bCQ\u0001_\u0011A\u0002\u0015Dc!\t>\u0002\u0012\t%E\u0006BA\u000b\u00033As!IA\u0010\u0003O\tI#A\u0011uKN$xJ\u001a4tKRl\u0015n\u001a:bi&|gnV5uQ\u0006#G-\u001a3U_BL7\rF\u0002u\u0005#CQ\u0001\u001f\u0012A\u0002\u0015DcA\t>\u0002\u0012\tUE\u0006BA\u000b\u00033AsAIA\u0010\u0003O\tI#\u0001\tuKN$H)Z:u%\u0016\fGm\u00148msR\u0019AO!(\t\u000ba\u001c\u0003\u0019A3)\r\rR\u0018\u0011\u0003BQY\u0011\t)\"!\u0007)\u000f\r\ny\"a\n\u0002*\u0005aB/Z:u\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\7\t\\3b]V\u0004Hc\u0001;\u0003*\")\u0001\u0010\na\u0001K\"2AE_A\t\u0005[cC!!\u0006\u0002\u001a!:A%a\b\u0002(\u0005%\u0012\u0001\t;fgRl\u0015N\u001d:pe\u0016$Gk\u001c9jG6\u000b'o[3e\r>\u0014H)\u001a7fi\u0016$2\u0001\u001eB[\u0011\u0015AX\u00051\u0001fQ\u0019)#0!\u0005\u0003:2\"\u0011QCA\rQ\u001d)\u0013qDA\u0014\u0003S\ta\u0002^3tiB\u000bWo]3U_BL7\rF\u0002u\u0005\u0003DQ\u0001\u001f\u0014A\u0002\u0015DcA\n>\u0002\u0012\t\u0015G\u0006BA\u000b\u00033AsAJA\u0010\u0003O\tI#\u0001\u000buKN$\b+Y;tK\u000ecWo\u001d;fe2Kgn\u001b\u000b\u0004i\n5\u0007\"\u0002=(\u0001\u0004)\u0007FB\u0014{\u0003#\u0011\t\u000e\f\u0003\u0002\u0016\u0005e\u0001fB\u0014\u0002 \u0005\u001d\u0012\u0011F\u0001\u0012i\u0016\u001cHOU3qY&\u001c\u0017m\u0015;biV\u001cHc\u0001;\u0003Z\")\u0001\u0010\u000ba\u0001K\"2\u0001F_A\t\u0005;dC!!\u0006\u0002\u001a!:\u0001&a\b\u0002(\u0005%\u0012!\u0005;fgR\fU\u000f^8NSJ\u0014xN]5oOR\u0019AO!:\t\u000baL\u0003\u0019A3)\r%R\u0018\u0011\u0003BuY\u0011\t)\"!\u0007)\u000f%\ny\"a\n\u0002*\u0005y\u0011-\u001e;p\u001b&\u0014(o\u001c:U_BL7\rF\u0002u\u0005cDQA\u0016\u0016A\u0002=\u000bQ\u0004Z3ti2Kgn\u001b)s_B\u001chi\u001c:BkR|W*\u001b:s_JLgn\u001a\u000b\u0007\u0005o\u0014ip!\u0001\u0011\t\u0005\r'\u0011`\u0005\u0005\u0005w\f)M\u0001\u0006Qe>\u0004XM\u001d;jKNDaAa@,\u0001\u0004)\u0017\u0001\u0004;pa&\u001cg)\u001b7uKJ\u001c\b\"CB\u0002WA\u0005\t\u0019\u0001B\u0016\u0003M\u0019wN\u001c4jOV\u0014X\rT5oWB\u0013XMZ5y\u0003\u001d\"Wm\u001d;MS:\\\u0007K]8qg\u001a{'/Q;u_6K'O]8sS:<G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r%!\u0006\u0002B\u0016\u0007\u0017Y#a!\u0004\u0011\t\r=1\u0011D\u0007\u0003\u0007#QAaa\u0005\u0004\u0016\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007/\t\u0016AC1o]>$\u0018\r^5p]&!11DB\t\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u00014i\u0016\u001cH\u000fT1ti\u001a+Go\u00195fI>3gm]3u!J|Wn\u001c;fI6K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001^B\u0011\u0011\u0015AX\u00061\u0001fQ\u0019i#0!\u0005\u0004&1\"\u0011QCA\rQ\u001di\u0013qDA\u0014\u0003S\tQ\u0007^3ti2\u000b7\u000f\u001e$fi\u000eDW\rZ(gMN,GOR1jY\u0016$wJ^3s\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]R\u0019Ao!\f\t\u000bat\u0003\u0019A3)\r9R\u0018\u0011CB\u0019Y\u0011\t)\"!\u0007)\u000f9\ny\"a\n\u0002*\u0005QC/Z:u\u0003V$x.T5se>\u0014\u0018N\\4O_>3XM\u001d7baBLgn\u001a+pa&\u001cg)\u001b7uKJ\u001cHc\u0001;\u0004:!)\u0001p\fa\u0001K\"2qF_A\t\u0007{a#!!\u0006)\u000f=\ny\"a\n\u0002*\u00059C/Z:u\u0003V$x.T5se>\u0014\u0018N\\4BY2|wo\u001d'j].\u001cuN\u001c4jOV\u0003H-\u0019;f)\r!8Q\t\u0005\u0006qB\u0002\r!\u001a\u0015\u0007ai\f\tb!\u0013-\t\u0005U\u0011\u0011\u0004\u0015\ba\u0005}\u0011qEA\u0015\u0003\r\"Xm\u001d;BkR|W*\u001b:s_JLgnZ+qI\u0006$X-\u0012=jgRLgn\u001a'j].$2\u0001^B)\u0011\u0015A\u0018\u00071\u0001fQ\u0019\t$0!\u0005\u0004V1\"\u0011QCA\rQ\u001d\t\u0014qDA\u0014\u0003S\ta\u0005^3ti\u0006+Ho\\'jeJ|'/\u001b8h\u0003\u0012$\u0017N\\4BI\u0012LG/[8oC2$v\u000e]5d)\r!8Q\f\u0005\u0006qJ\u0002\r!\u001a\u0015\u0007ei\f\tb!\u0019-\t\u0005U\u0011\u0011\u0004\u0015\be\u0005}\u0011qEA\u0015\u0003\u0001\"Xm\u001d;BkR|W*\u001b:s_JLgn\u001a(p\u000bbL7\u000f^5oOR{\u0007/[2\u0015\u0007Q\u001cI\u0007C\u0003yg\u0001\u0007Q\r\u000b\u00044u\u0006E1Q\u000e\u0017\u0005\u0003+\tI\u0002K\u00044\u0003?\t9#!\u000b\u0002eQ,7\u000f\u001e'bgR4U\r^2iK\u0012|eMZ:fiN#x\u000e\u001d9fI6K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$2\u0001^B;\u0011%\u00199\b\u000eI\u0001\u0002\u0004\u0011Y#A\u0004qe>lw\u000e^3\u0002yQ,7\u000f\u001e'bgR4U\r^2iK\u0012|eMZ:fiN#x\u000e\u001d9fI6K'O]8s)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018\u000e\u001d;j_:$C-\u001a4bk2$H%M\u0001\u001di\u0016\u001cH\u000fR3mKR,\u0017)\u001e;p\u001b&\u0014(o\u001c:fIR{\u0007/[2t)\r!8q\u0010\u0005\u0006qZ\u0002\r!\u001a\u0015\u0007mi\f\tba!-\t\u0005U\u0011\u0011\u0004\u0015\bm\u0005}\u0011qEA\u0015\u0003\t\"Xm\u001d;J]R,'O^1m\u0007\"\fgnZ3G_J\u0004VM]5pI&\u001cG+Y:lgR\u0019Aoa#\t\u000ba<\u0004\u0019A3)\r]R\u0018\u0011CBHY\t\t)\u0002K\u00048\u0003?\t9#!\u000b\u0002=Q,7\u000f^#yi\u0016\u0014h.\u00197ju\u0016$\u0007+Y:to>\u0014HmQ8oM&<Gc\u0001;\u0004\u0018\")\u0001\u0010\u000fa\u0001K\"2\u0001H_A\t\u00077c#!!\u0006)\u000fa\ny\"a\n\u0002*\u0005IC/Z:u\u001b&\u0014(o\u001c:GC&dwN^3s/\",gnU8ve\u000e,\u0017j]+oCZ\f\u0017\u000e\\1cY\u0016$2\u0001^BR\u0011\u0015A\u0018\b1\u0001fQ\u0019I$0!\u0005\u0004(2\u0012\u0011Q\u0003\u0015\bs\u0005}\u0011qEA\u0015\u0003\u0011\"Xm\u001d;DYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018\rV8qS\u000e\u001c%/Z1uS>tGc\u0001;\u00040\")\u0001P\u000fa\u0001K\"2!H_A\t\u0007gcC!!\u0006\u0002\u001a!:!(a\b\u0002(\u0005%\u0012a\u0006;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014H*\u001b8l)\r!81\u0018\u0005\u0006qn\u0002\r!\u001a\u0015\u0007wi\f\tba0-\u0005\u0005U\u0001fB\u001e\u0002 \u0005\u001d\u0012\u0011F\u0001'i\u0016\u001cH/\u00117uKJ\u001cE.^:uKJd\u0015N\\6XSRD\u0017J\u001c<bY&$7i\u001c8gS\u001e\u001cHc\u0001;\u0004H\")\u0001\u0010\u0010a\u0001K\"2AH_A\t\u0007\u0017d#!!\u0006)\u000fq\ny\"a\n\u0002*\u0005Ib/\u001a:jMf$Um]2sS\n,G*\u001b8lgJ+7/\u001e7u)\u0015!81[Bx\u0011\u001d\u0019).\u0010a\u0001\u0007/\fQ\u0002Z3ti2Kgn[*uCR,\u0007\u0003BBm\u0007StAaa7\u0004f6\u00111Q\u001c\u0006\u0005\u0007?\u001c\t/A\u0003bI6LgN\u0003\u0003\u0004d\u0006%\u0018aB2mS\u0016tGo]\u0005\u0005\u0007O\u001ci.\u0001\fDYV\u001cH/\u001a:MS:\\G)Z:de&\u0004H/[8o\u0013\u0011\u0019Yo!<\u0003\u00131Kgn[*uCR,'\u0002BBt\u0007;Dqa!=>\u0001\u0004\u00199.A\bt_V\u00148-\u001a'j].\u001cF/\u0019;f\u0003u1XM]5gsN\u000b7\u000f\u001c&bCN\u001cuN\u001c4jO\u0016s7M]=qi\u0016$Gc\u0001;\u0004x\"9!q\u0007 A\u0002\u0005\u0005\u0007f\u0002\u0001\u0004|\u0012\u001dA\u0011\u0002\t\u0005\u0007{$\u0019!\u0004\u0002\u0004\u0000*!A\u0011AA\u0001\u0003\r\t\u0007/[\u0005\u0005\t\u000b\u0019yPA\u0002UC\u001e\fQA^1mk\u0016\f#\u0001b\u0003\u0002\u0017%tG/Z4sCRLwN\u001c")
public class ClusterLinkIntegrationTest
extends AbstractClusterLinkIntegrationTest {
    private final long offsetToCommit;
    private final long syncPeriod;
    private final String consumerGroup;
    private final String topicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"").append(this.topic()).append("\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |").toString())).stripMargin();
    private final String includeAllTopicsFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n        |\"topicFilters\": [\n        |  {\n        |     \"name\": \"*\",\n        |     \"patternType\": \"literal\",\n        |     \"filterType\": \"include\"\n        |  }\n        |]}\n        |")).stripMargin();

    public long offsetToCommit() {
        return this.offsetToCommit;
    }

    public long syncPeriod() {
        return this.syncPeriod;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public String topicFilter() {
        return this.topicFilter;
    }

    public String includeAllTopicsFilter() {
        return this.includeAllTopicsFilter;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateMirrorTopic(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        String retentionMs = "10000";
        Properties configs = new Properties();
        configs.put(LogConfig$.MODULE$.RetentionMsProp(), retentionMs);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$12 = this.topic();
        int x$22 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$12, x$22, x$3, configs, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$6 = this.linkName();
        boolean x$8 = true;
        Option<Properties> x$9 = this.createClusterLink$default$3();
        this.createClusterLink(x$6, linkProps, x$9, x$8);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$10 = this.topic();
        short x$11 = this.replicationFactor();
        String x$122 = this.linkName();
        String x$13 = this.clusterLinkPrefix();
        Map<String, String> x$14 = qual$2.linkTopic$default$4();
        CreateTopicsResult result = qual$2.linkTopic(x$10, x$11, x$122, x$14, x$13);
        Assertions.assertEquals((int)this.numPartitions(), (Integer)((Integer)result.numPartitions(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((int)this.replicationFactor(), (Integer)((Integer)result.replicationFactor(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()));
        Assertions.assertEquals((Object)retentionMs, (Object)((Config)result.config(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()).get()).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Config topicConfig = this.destCluster().describeTopicConfig(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        Assertions.assertEquals((Object)retentionMs, (Object)topicConfig.get(LogConfig$.MODULE$.RetentionMsProp()).value());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty() && quorum.equals("zk")) {
            this.verifyLinkWithClusterLinkPrefixCountMetric(1);
        }
        Seq<ClusterLinkListing> listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopic$1(this, x$1)))).head()).topics().get()).asScala()).toSet());
        Seq<ClusterLinkDescription> description = this.destCluster().describeClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkDescription)((IterableLike)description.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateMirrorTopic$2(this, x$2)))).head()).topics().get()).asScala()).toSet());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTransactionsWithMirrorTopic(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        String groupId = "testGroup";
        String topic2 = "anotherTopic";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = qual$2.createTopic$default$4();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topic2, x$7, x$8, x$9, x$10);
        String x$11 = this.linkName();
        boolean x$12 = true;
        Properties x$13 = this.createClusterLink$default$2();
        Option<Properties> x$14 = this.createClusterLink$default$3();
        this.createClusterLink(x$11, x$13, x$14, x$12);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$15 = this.topic();
        short x$16 = this.replicationFactor();
        String x$17 = this.linkName();
        Map<String, String> x$18 = qual$3.linkTopic$default$4();
        String x$19 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$15, x$16, x$17, x$18, x$19);
        Properties producerProps = new Properties();
        producerProps.setProperty("transactional.id", "test_txn");
        producerProps.setProperty("acks", "all");
        ClusterLinkTestHarness qual$4 = this.destCluster();
        ByteArraySerializer x$21 = qual$4.createProducer$default$1();
        ByteArraySerializer x$22 = qual$4.createProducer$default$2();
        try (KafkaProducer producer = qual$4.createProducer(x$21, x$22, producerProps);){
            producer.initTransactions();
            Properties consumerProps = new Properties();
            consumerProps.setProperty("group.id", groupId);
            consumerProps.setProperty("isolation.level", "read_committed");
            ClusterLinkTestHarness qual$5 = this.destCluster();
            ByteArrayDeserializer x$24 = qual$5.createConsumer$default$1();
            ByteArrayDeserializer x$25 = qual$5.createConsumer$default$2();
            List<String> x$26 = qual$5.createConsumer$default$4();
            try (KafkaConsumer consumer = qual$5.createConsumer(x$24, x$25, consumerProps, x$26);){
                consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.partitions(this.partitions$default$1())).asJava());
                Seq consumedRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.producedRecords().size(), 20000L);
                java.util.Map consumedOffsets = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.partitions(this.partitions$default$1())).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition tp = (TopicPartition)x0$1._1();
                    Long offset = (Long)x0$1._2();
                    Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new OffsetAndMetadata(Predef$.MODULE$.Long2long(offset)));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
                producer.beginTransaction();
                consumedRecords.foreach((Function1 & Serializable & scala.Serializable)record -> producer.send(new ProducerRecord(topic2, Predef$.MODULE$.int2Integer(record.partition()), Predef$.MODULE$.long2Long(record.timestamp()), record.key(), record.value())));
                producer.sendOffsetsToTransaction(consumedOffsets, new ConsumerGroupMetadata(groupId));
                producer.commitTransaction();
                Assertions.assertEquals((Object)consumedOffsets, (Object)consumer.committed((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.partitions(this.partitions$default$1()).toSet()).asJava()));
                producer.beginTransaction();
                ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> this.produceRecords((KafkaProducer<byte[], byte[]>)producer, this.topic(), 10, this.produceRecords$default$4()));
                Assertions.assertTrue((boolean)e.getMessage().matches(".*Could not add partitions to transaction due to errors.*INVALID_REQUEST.*"), (String)new StringBuilder(17).append("Unexpected error ").append(e.getMessage()).toString());
                producer.abortTransaction();
                this.producedRecords().clear();
                ClusterLinkTestHarness qual$6 = this.destCluster();
                String x$27 = this.topic();
                String x$28 = this.linkName();
                boolean x$29 = false;
                boolean x$30 = qual$6.unlinkTopic$default$3();
                boolean x$31 = qual$6.unlinkTopic$default$5();
                qual$6.unlinkTopic(x$27, x$28, x$30, x$29, x$31);
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!ClusterLinkIntegrationTest.$anonfun$testTransactionsWithMirrorTopic$4(this)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testTransactionsWithMirrorTopic$8());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                producer.beginTransaction();
                this.produceRecords(producer, this.topic(), 10, this.produceRecords$default$4());
                producer.commitTransaction();
                this.consumeRecords(consumer, this.consumeRecords$default$2());
            }
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testStopMirrorTopicWithInvalidRequest(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$6 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            String x$7 = this.linkName();
            boolean x$8 = false;
            boolean x$9 = false;
            boolean x$10 = qual$2.unlinkTopic$default$5();
            qual$2.unlinkTopic(x$6, x$7, x$8, x$9, x$10);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$12 = this.numPartitions();
        short x$13 = this.replicationFactor();
        Properties x$14 = qual$3.createTopic$default$4();
        ListenerName x$15 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$11, x$12, x$13, x$14, x$15);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$16 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            String x$17 = this.linkName();
            boolean x$18 = false;
            boolean x$19 = false;
            boolean x$20 = qual$4.unlinkTopic$default$5();
            qual$4.unlinkTopic(x$16, x$17, x$18, x$19, x$20);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = this.topic();
        short x$22 = this.replicationFactor();
        String x$23 = this.linkName();
        String x$24 = this.clusterLinkPrefix();
        Map<String, String> x$25 = qual$5.linkTopic$default$4();
        qual$5.linkTopic(x$21, x$22, x$23, x$25, x$24);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$26 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$27 = this.linkName();
        boolean x$28 = qual$6.unlinkTopic$default$3();
        boolean x$29 = qual$6.unlinkTopic$default$4();
        boolean x$30 = qual$6.unlinkTopic$default$5();
        qual$6.unlinkTopic(x$26, x$27, x$28, x$29, x$30);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$31 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            String x$32 = this.linkName();
            boolean x$33 = false;
            boolean x$34 = false;
            boolean x$35 = qual$7.unlinkTopic$default$5();
            qual$7.unlinkTopic(x$31, x$32, x$33, x$34, x$35);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$36 = this.linkName();
        boolean x$37 = qual$8.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$38 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(x$36, x$37, x$38);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testStopMirror(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$12 = this.linkName();
        boolean x$13 = false;
        boolean x$14 = qual$3.unlinkTopic$default$3();
        boolean x$15 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$11, x$12, x$14, x$13, x$15);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.topic();
        short x$17 = this.replicationFactor();
        String x$18 = this.linkName();
        String x$19 = this.clusterLinkPrefix();
        Map<String, String> x$20 = qual$4.linkTopic$default$4();
        qual$4.linkTopic(x$16, x$17, x$18, x$20, x$19);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$22 = this.linkName();
        boolean x$23 = qual$5.unlinkTopic$default$3();
        boolean x$24 = qual$5.unlinkTopic$default$4();
        boolean x$25 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$21, x$22, x$23, x$24, x$25);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$26 = this.linkName();
        boolean x$27 = qual$6.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$28 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$26, x$27, x$28);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testStopMirrorWithSourceClusterShutdown(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(100);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.topic();
        String x$12 = this.linkName();
        boolean x$13 = false;
        boolean x$14 = qual$3.unlinkTopic$default$3();
        boolean x$15 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$11, x$12, x$14, x$13, x$15);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.restartSource$1();
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = this.topic();
        String x$17 = this.linkName();
        boolean x$18 = false;
        boolean x$19 = qual$4.unlinkTopic$default$3();
        boolean x$20 = qual$4.unlinkTopic$default$4();
        qual$4.unlinkTopic(x$16, x$17, x$19, x$20, x$18);
        Thread.sleep(1000L);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.restartSource$1();
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.restartSource$1();
        this.restartMirrorTopic$1();
        this.sourceCluster().killAllBrokers();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = this.topic();
        String x$22 = this.linkName();
        boolean x$23 = false;
        boolean x$24 = qual$5.unlinkTopic$default$3();
        boolean x$25 = qual$5.unlinkTopic$default$4();
        qual$5.unlinkTopic(x$21, x$22, x$24, x$25, x$23);
        Thread.sleep(1000L);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PENDING_STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$26 = this.topic();
        String x$27 = this.linkName();
        boolean x$28 = false;
        boolean x$29 = qual$6.unlinkTopic$default$3();
        boolean x$30 = qual$6.unlinkTopic$default$5();
        qual$6.unlinkTopic(x$26, x$27, x$29, x$28, x$30);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$31 = this.linkName();
        boolean x$32 = qual$7.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$33 = qual$7.deleteClusterLink$default$3();
        qual$7.deleteClusterLink(x$31, x$32, x$33);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAndDeleteAndRecreateLink(String quorum) {
        void var36_41;
        Tuple2 tuple2;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$52 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$52);
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$62 = this.topic();
        short x$72 = this.replicationFactor();
        String x$82 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$62, x$72, x$82, x$9, x$10);
        Seq<ClusterLinkListing> listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$1(this, x$5)))).head()).topics().get()).asScala()).toSet());
        Seq<ClusterLinkDescription> description = this.destCluster().describeClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkDescription)((IterableLike)description.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$2(this, x$6)))).head()).topics().get()).asScala()).toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.linkName();
        boolean x$12 = qual$3.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$13 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$11, x$12, x$13);
        listing = this.destCluster().listClusterLinks(true);
        Assertions.assertTrue((boolean)listing.isEmpty());
        description = this.destCluster().describeClusterLinks(true);
        Assertions.assertTrue((boolean)description.isEmpty());
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$4 = this.sourceCluster();
            String x$14 = this.linkName();
            boolean x$15 = qual$4.deleteClusterLink$default$2();
            Buffer<KafkaBroker> x$16 = qual$4.deleteClusterLink$default$3();
            qual$4.deleteClusterLink(x$14, x$15, x$16);
            listing = this.sourceCluster().listClusterLinks(true);
            Assertions.assertTrue((boolean)listing.isEmpty());
            description = this.sourceCluster().describeClusterLinks(true);
            Assertions.assertTrue((boolean)description.isEmpty());
        }
        UUID newLinkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$17 = this.topic();
        short x$18 = this.replicationFactor();
        String x$19 = this.linkName();
        Map<String, String> x$20 = qual$5.linkTopic$default$4();
        String x$21 = qual$5.linkTopic$default$5();
        qual$5.linkTopic(x$17, x$18, x$19, x$20, x$21);
        listing = this.destCluster().listClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkListing)((IterableLike)listing.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$3(this, x$7)))).head()).topics().get()).asScala()).toSet());
        description = this.destCluster().describeClusterLinks(true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((ClusterLinkDescription)((IterableLike)description.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$4(this, x$8)))).head()).topics().get()).asScala()).toSet());
        this.produceToSourceCluster(numRecords);
        this.waitAndVerifyMetricsAndMirror(this.topic(), newLinkId);
        this.destCluster().deleteLinkNoVerify(this.linkName(), true);
        KafkaBroker broker = (KafkaBroker)this.destCluster().brokers().head();
        this.destCluster().killAllBrokers();
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$22 = qual$6.restartDeadBrokers$default$1();
        qual$6.restartDeadBrokers(x$22);
        this.destCluster().updateBootstrapServers();
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Seq computeUntilTrue_result;
            if (ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$6(computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$5(broker))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq links = (Seq)tuple2._1();
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)var36_41);
        if (!this.useSourceInitiatedLink() && quorum.equals("zk")) {
            Properties invalidLinkProps = this.destLinkProps(this.destLinkProps$default$1());
            invalidLinkProps.setProperty("sasl.jaas.config", invalidLinkProps.getProperty("sasl.jaas.config").replace(this.linkName(), new StringBuilder(6).append("wrong-").append(this.linkName()).toString()));
            this.verifyValidateLinkFailure(invalidLinkProps, SaslAuthenticationException.class, "Authentication failed during authentication due to invalid credentials with SASL mechanism SCRAM-SHA-256");
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorNewRecords(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.produceToSourceCluster(numRecords);
        this.consume(this.sourceCluster(), "");
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
        if (quorum.equals("zk")) {
            this.verifySaslJaasConfigEncrypted(linkId);
        }
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.linkName();
        boolean x$12 = qual$3.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$13 = qual$3.deleteClusterLink$default$3();
        qual$3.deleteClusterLink(x$11, x$12, x$13);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirrorExistingRecords(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.waitAndVerifyMetricsAndMirror(this.topic(), linkId);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicConfigSync(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testTopicConfigSync$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testTopicConfigSync$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyTopicConfigChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListDescribeMirror(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        boolean x$6 = qual$2.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), qual$2.listMirrorTopics(x$6));
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$7 = this.topic();
        short x$8 = 2;
        String x$9 = this.linkName();
        Map<String, String> x$10 = qual$3.linkTopic$default$4();
        String x$11 = qual$3.linkTopic$default$5();
        qual$3.linkTopic(x$7, x$8, x$9, x$10, x$11);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$12 = qual$4.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), qual$4.listMirrorTopics(x$12));
        MirrorTopicDescription desc = this.destCluster().describeMirrorTopic(this.topic());
        Assertions.assertEquals((Object)this.linkName(), (Object)desc.linkName());
        Assertions.assertEquals((Object)this.topic(), (Object)desc.sourceTopic());
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)desc.state());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$13 = this.topic();
        String x$14 = this.linkName();
        boolean x$15 = qual$5.unlinkTopic$default$3();
        boolean x$16 = qual$5.unlinkTopic$default$4();
        boolean x$17 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$13, x$14, x$15, x$16, x$17);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, this.waitUntilMirrorState$default$2());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$18 = qual$6.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), qual$6.listMirrorTopics(x$18));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), this.destCluster().listMirrorTopics(true));
        Assertions.assertEquals((Object)this.destCluster().describeMirrorTopic(this.topic()).state(), (Object)MirrorTopicDescription.State.STOPPED);
        this.destCluster().deleteTopic(this.topic(), true);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), this.destCluster().listMirrorTopics(true));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.destCluster().describeMirrorTopic(this.topic()));
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$19 = this.topic();
        short x$20 = 2;
        String x$21 = this.linkName();
        Map<String, String> x$22 = qual$7.linkTopic$default$4();
        String x$23 = qual$7.linkTopic$default$5();
        qual$7.linkTopic(x$19, x$20, x$21, x$22, x$23);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        boolean x$24 = qual$8.listMirrorTopics$default$1();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()})), qual$8.listMirrorTopics(x$24));
        Assertions.assertEquals((Object)MirrorTopicDescription.State.ACTIVE, (Object)this.destCluster().describeMirrorTopic(this.topic()).state());
        this.destCluster().pauseTopic(this.topic(), true);
        Assertions.assertEquals((Object)MirrorTopicDescription.State.PAUSED, (Object)this.destCluster().describeMirrorTopic(this.topic()).state());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$25 = this.linkName();
        boolean x$26 = true;
        Buffer<KafkaBroker> x$27 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$25, x$26, x$27);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testListDescribeMirror$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testSourceClusterQuota(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp()), (Object)"100")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        Properties x$11 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin sourceAdmin = qual$3.createConfluentAdminClient(x$11);
        this.verifyQuota((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)byteRate -> this.setQuota$1(byteRate, sourceAdmin), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.throttled$1(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationClusterLinkQuota(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        .colon.colon resources = new .colon.colon((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (List)Nil$.MODULE$);
        UUID linkId = this.verifyDestinationClusterLinkQuota((Seq<ConfigResource>)resources, ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND);
        this.verifyFetchResponseSize(linkId, (Option<FetchResponseSize>)None$.MODULE$);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$1.createConfluentAdminClient(x$1);
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.fetch.response.total.bytes", "10000"), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$10), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin.incrementalAlterConfigs(configs).all().get();
        this.verifyFetchResponseSize(linkId, (Option<FetchResponseSize>)new Some((Object)new FetchResponseSize(5000, 10000)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationClusterLinkBrokerLevelQuota(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        Seq resources = ((SeqLike)((TraversableLike)this.destCluster().brokers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkBrokerLevelQuota$1(x$11)), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)brokerId -> ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkBrokerLevelQuota$2(BoxesRunTime.unboxToInt((Object)brokerId)), Buffer$.MODULE$.canBuildFrom())).toSeq();
        this.verifyDestinationClusterLinkQuota((Seq<ConfigResource>)resources, ConfluentConfigs.ClusterLinkQuotaMode.CLUSTER_LINK_ONLY);
    }

    public UUID verifyDestinationClusterLinkQuota(Seq<ConfigResource> resources, ConfluentConfigs.ClusterLinkQuotaMode quotaMode) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$11 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$11);
        AlterConfigOp alterModeOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.replication.quota.mode", quotaMode.toString()), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x$12 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$12), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterModeOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin.incrementalAlterConfigs(configs).all().get();
        this.verifyQuota((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)byteRate -> ClusterLinkIntegrationTest.setQuota$2(byteRate, resources, destAdmin), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.destClusterLinkReplicasThrottled(), true);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyQuotaMode(quotaMode);
        return linkId;
    }

    /*
     * WARNING - void declaration
     */
    public void verifyQuotaMode(ConfluentConfigs.ClusterLinkQuotaMode quotaMode) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        Properties x$1 = qual$1.createConfluentAdminClient$default$1();
        ConfluentAdmin admin = qual$1.createConfluentAdminClient(x$1);
        AlterConfigOp alterModeOp = new AlterConfigOp(new ConfigEntry("confluent.cluster.link.replication.quota.mode", quotaMode.toString()), AlterConfigOp.OpType.SET);
        AlterConfigOp alterProduceQuotaOp = new AlterConfigOp(new ConfigEntry("producer_byte_rate", "100000"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Collection> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterModeOp, alterProduceQuotaOp}))).asJavaCollection());
        admin.incrementalAlterConfigs(configs).all().get();
        KafkaBroker broker = this.sourceCluster().partitionLeader(new TopicPartition(this.topic(), 0));
        if (!TestInfoUtils$.MODULE$.isKRaft(this.linkTestInfo())) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$1(broker)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$3(broker, quotaMode)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$verifyQuotaMode$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(20);
        if (!TestInfoUtils$.MODULE$.isKRaft(this.linkTestInfo())) {
            this.verifyClusterLinkQuotaMetrics((Seq<KafkaBroker>)new .colon.colon((Object)broker, (List)Nil$.MODULE$), quotaMode.equals(ConfluentConfigs.ClusterLinkQuotaMode.TOTAL_INBOUND));
        }
    }

    private boolean destClusterLinkReplicasThrottled() {
        return this.yammerMetricMaxValue("kafka.server:type=ReplicaManager,name=ThrottledClusterLinkReplicasPerSec", (Option<String>)None$.MODULE$) > 0.0;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyFetchResponseSize(UUID linkId, Option<FetchResponseSize> expectedSize) {
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)((IterableLike)((TraversableLike)this.destCluster().brokers().map((Function1 & Serializable & scala.Serializable)x$14 -> (ClusterLinkFetcherManager)x$14.clusterLinkManager().fetcherManager(linkId).get(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$2(x$15)))).head();
        ClusterLinkFetcherThread fetcherThread = (ClusterLinkFetcherThread)((HashMap)TestUtils.fieldValue((Object)fetcherManager, AbstractFetcherManager.class, (String)"fetcherThreadMap")).values().head();
        Object expectedFetchSize = expectedSize.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.perPartitionSize())).getOrElse((Function0 & Serializable & scala.Serializable)() -> fetcherManager.currentConfig().replicaFetchMaxBytes());
        Object expectedFetchResponseSize = expectedSize.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.responseSize())).getOrElse((Function0 & Serializable & scala.Serializable)() -> fetcherManager.currentConfig().replicaFetchResponseMaxBytes());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.fetchSize$1(fetcherThread);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$8(expectedFetchSize, n)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Assertions.assertEquals((Object)expectedFetchSize, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.fetchSize$1(fetcherThread)));
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.fetchResponseSize$1(fetcherThread);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$verifyFetchResponseSize$10(expectedFetchResponseSize, n)) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Assertions.assertEquals((Object)expectedFetchResponseSize, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkIntegrationTest.fetchResponseSize$1(fetcherThread)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationClusterLinkQuotaWithBrokerRestart(String quorum) {
        void var25_25;
        void var24_24;
        void var26_31;
        Tuple2 tuple2;
        void var22_22;
        void var21_21;
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$11 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$11);
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), "100"), AlterConfigOp.OpType.SET);
        java.util.Map<ConfigResource, Collection> configs = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection());
        destAdmin.incrementalAlterConfigs(configs).all().get();
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        Tuple2<Object, Object> tuple22 = this.destCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int oldLeaderId = tuple22._1$mcI$sp();
        int oldLeaderEpoch = tuple22._2$mcI$sp();
        Tuple2<Object, Object> tuple23 = this.destCluster().waitForLeaderChange(tp, (int)var21_21, (int)var22_22);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int newLeaderId = tuple23._1$mcI$sp();
        int newLeaderEpoch = tuple23._2$mcI$sp();
        this.destCluster().startBroker((int)var21_21);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            scala.collection.immutable.Set computeUntilTrue_result;
            if ((computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$1(this, tp)).contains((Object)BoxesRunTime.boxToInteger((int)((int)var21_21)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Assertions.assertTrue((boolean)bl, (String)new StringBuilder(42).append("Broker ").append((int)var21_21).append(" is not part of ISR ").append(var26_31).append(" for partition ").append(tp).toString());
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l3 = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ClusterLinkIntegrationTest.$anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$4(destAdmin, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        Assertions.assertEquals((int)this.destCluster().waitForLeaderChange(tp, (int)var24_24, (int)var25_25)._1$mcI$sp(), (int)var21_21, (String)"Preferred leader not elected");
        this.destCluster().updateBootstrapServers();
        ClusterLinkTestHarness qual$4 = this.sourceCluster();
        ByteArraySerializer x$12 = qual$4.createProducer$default$1();
        ByteArraySerializer x$13 = qual$4.createProducer$default$2();
        Properties x$14 = qual$4.createProducer$default$3();
        this.produceUntil(qual$4.createProducer(x$12, x$13, x$14), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.destClusterLinkReplicasThrottled(), "Destination quota not applied after broker restart");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestinationLagLinkFetcherThrottle(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(2);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.linkName();
        Map x$12 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"-2")}));
        Seq<KafkaBroker> x$13 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$11, (Map<String, String>)x$12, x$13);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) == 0.0 ? 1 : 0) != 0);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.linkName();
        Map x$15 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"-1")}));
        Seq<KafkaBroker> x$16 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$14, (Map<String, String>)x$15, x$16);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) == 0.0 ? 1 : 0) != 0);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$17 = this.linkName();
        Map x$18 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"10485760")}));
        Seq<KafkaBroker> x$19 = qual$5.alterClusterLink$default$3();
        qual$5.alterClusterLink(x$17, (Map<String, String>)x$18, x$19);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) == 0.0 ? 1 : 0) != 0);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$20 = this.linkName();
        Map x$21 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkFetcherFlowControlProp()), (Object)"0")}));
        Seq<KafkaBroker> x$22 = qual$6.alterClusterLink$default$3();
        qual$6.alterClusterLink(x$20, (Map<String, String>)x$21, x$22);
        this.produceToSourceCluster(30);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertTrue((this.totalKafkaMetricValue(this.destCluster().aliveServers(), "destination-lag-link-fetcher-throttle-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()) > 0.0 ? 1 : 0) != 0);
        Assertions.assertEquals((double)2.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "link-fetcher-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAddPartitions(String quorum) {
        void var16_22;
        Tuple2 tuple2;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"1000")}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.numPartitions_$eq(4);
        this.sourceCluster().createPartitions(this.topic(), this.numPartitions());
        this.produceToSourceCluster(8);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.$anonfun$testAddPartitions$1(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testAddPartitions$2(this, n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple2._1$mcI$sp();
        Assertions.assertEquals((int)this.numPartitions(), (int)var16_22);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAddPartitionMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterClusterLinkConfigs(String quorum) {
        void var28_34;
        Tuple2 tuple2;
        ClusterLinkTestHarness connectingCluster;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(8);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.sourceLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness clusterLinkTestHarness = connectingCluster = super.connectingCluster();
        ClusterLinkTestHarness clusterLinkTestHarness2 = this.destCluster();
        ClusterLinkTestHarness otherCluster = !(clusterLinkTestHarness != null ? !clusterLinkTestHarness.equals(clusterLinkTestHarness2) : clusterLinkTestHarness2 != null) ? this.sourceCluster() : this.destCluster();
        String metadataMaxAge = "60000";
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)metadataMaxAge)}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertEquals((Object)metadataMaxAge, (Object)connectingCluster.describeClusterLink(this.linkName()).get("metadata.max.age.ms").value());
        otherCluster.killAllBrokers();
        otherCluster.startAllBrokers();
        connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)otherCluster.bootstrapServers(otherCluster.bootstrapServers$default$1()))}))), connectingCluster.alterClusterLink$default$3());
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            String x$11 = this.linkName();
            Map x$12 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.LinkModeProp()), (Object)"SOURCE")}));
            Seq<KafkaBroker> x$13 = qual$3.alterClusterLink$default$3();
            qual$3.alterClusterLink(x$11, (Map<String, String>)x$12, x$13);
        });
        Assertions.assertThrows(InvalidRequestException.class, () -> connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConnectionModeProp()), (Object)"INBOUND")}))), connectingCluster.alterClusterLink$default$3()));
        Assertions.assertEquals((Object)LinkMode.Destination$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().linkMode());
        Assertions.assertEquals((Object)ConnectionMode.Outbound$.MODULE$, (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)connectingCluster.brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().connectionMode());
        if (quorum.equals("zk")) {
            String trustStoreConfigName = this.useSourceInitiatedLink() ? new StringBuilder(23).append(ClusterLinkConfig$.MODULE$.LocalPrefix()).append("ssl.truststore.location").toString() : "ssl.truststore.location";
            File oldFile = new File(connectingCluster.describeClusterLink(this.linkName()).get(trustStoreConfigName).value());
            File newFile = File.createTempFile("truststore", ".jks");
            Files.copy(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            connectingCluster.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)trustStoreConfigName), (Object)newFile.getAbsolutePath())}))), connectingCluster.alterClusterLink$default$3());
        }
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        int firstBroker = ((KafkaBroker)this.destCluster().brokers().head()).config().brokerId();
        java.util.Map reassignment = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)this.partitions(this.partitions$default$1()).map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(firstBroker))))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        this.destCluster().alterPartitionAssignment(reassignment);
        Assertions.assertEquals((int)1, (int)this.maxFetcherThreadCount(linkId));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.linkName();
        Map x$15 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"3")}));
        Seq<KafkaBroker> x$16 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$14, (Map<String, String>)x$15, x$16);
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = this.maxFetcherThreadCount(linkId);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testAlterClusterLinkConfigs$5(n)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int threads = tuple2._1$mcI$sp();
        Assertions.assertEquals((int)3, (int)var28_34);
        this.produceToSourceCluster(8);
        this.consume(this.destCluster(), this.consume$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMigrationWithAddedConsumerGroup(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        long finalOffset = 20L;
        String additionalConsumerGroup = "testGroup2";
        String multiConsumerGroupFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"groupFilters\": [\n          |  {\n          |     \"name\": \"").append(this.consumerGroup()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(additionalConsumerGroup).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = 2;
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup());
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)multiConsumerGroupFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.linkName();
        Seq<KafkaBroker> x$13 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$11, (Map<String, String>)updatedProps, x$13);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, additionalConsumerGroup);
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, additionalConsumerGroup);
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$15 = this.linkName();
        boolean x$16 = qual$4.unlinkTopic$default$3();
        boolean x$17 = qual$4.unlinkTopic$default$4();
        boolean x$18 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$14, x$15, x$16, x$17, x$18);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = this.linkName();
        boolean x$20 = qual$5.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$21 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$19, x$20, x$21);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMigrationWithAddedTopic(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        long finalOffset = 20L;
        String additionalTopic = "linkedTopic2";
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = qual$2.createTopic$default$4();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(additionalTopic, x$7, x$8, x$9, x$10);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(this.syncPeriod()));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.topic();
        short x$12 = 2;
        String x$13 = this.linkName();
        String x$14 = this.clusterLinkPrefix();
        Map<String, String> x$15 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$11, x$12, x$13, x$15, x$14);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        short x$17 = 2;
        String x$18 = this.linkName();
        String x$19 = this.clusterLinkPrefix();
        Map<String, String> x$20 = qual$4.linkTopic$default$4();
        qual$4.linkTopic(additionalTopic, x$17, x$18, x$20, x$19);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, finalOffset, this.consumerGroup());
        this.commitOffsets(this.sourceCluster(), additionalTopic, 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, finalOffset, this.consumerGroup());
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString(), 0, finalOffset, this.consumerGroup());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.verifyConsumerOffsetMigrationMetrics();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$22 = this.linkName();
        boolean x$23 = false;
        boolean x$24 = qual$5.unlinkTopic$default$4();
        boolean x$25 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$21, x$22, x$23, x$24, x$25);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.consumerGroupFilter(this.consumerGroup()).replaceAll("include", "exclude"))}))));
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", this.consumerGroup());
        ClusterLinkTestHarness qual$6 = this.destCluster();
        ByteArrayDeserializer x$27 = qual$6.createConsumer$default$1();
        ByteArrayDeserializer x$28 = qual$6.createConsumer$default$2();
        List<String> x$29 = qual$6.createConsumer$default$4();
        KafkaConsumer destConsumer = qual$6.createConsumer(x$27, x$28, consumerProps, x$29);
        destConsumer.subscribe(Collections.singleton(additionalTopic));
        do {
            destConsumer.poll(Duration.ofMillis(10L));
        } while (destConsumer.assignment().isEmpty());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> destConsumer.poll(Duration.ofMillis(10L)));
        try {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$30 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString();
            String x$31 = this.linkName();
            boolean x$32 = qual$7.unlinkTopic$default$3();
            boolean x$33 = qual$7.unlinkTopic$default$4();
            boolean x$34 = qual$7.unlinkTopic$default$5();
            qual$7.unlinkTopic(x$30, x$31, x$32, x$33, x$34);
            this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(additionalTopic).toString());
        }
        finally {
            executor.shutdownNow();
        }
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$35 = this.linkName();
        boolean x$36 = qual$8.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$37 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(x$35, x$36, x$37);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestReadOnly(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        UUID linkId = this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        ByteArraySerializer x$11 = qual$3.createProducer$default$1();
        ByteArraySerializer x$12 = qual$3.createProducer$default$2();
        Properties x$13 = qual$3.createProducer$default$3();
        KafkaProducer destProducer = qual$3.createProducer(x$11, x$12, x$13);
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> destProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes())).get(15L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)(e.getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)e.getMessage().contains("Cannot append records to read-only mirror topic"), (String)new StringBuilder(17).append("Unexpected error ").append(e.getMessage()).toString());
        Assertions.assertThrows(InvalidPartitionsException.class, () -> this.destCluster().createPartitions(this.topic(), 8));
        this.destCluster().withAdmin((Function1 & Serializable & scala.Serializable)admin -> {
            ClusterLinkIntegrationTest.$anonfun$testDestReadOnly$3(this, admin);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(4);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.topic();
        String x$15 = this.linkName();
        boolean x$16 = qual$4.unlinkTopic$default$3();
        boolean x$17 = qual$4.unlinkTopic$default$4();
        boolean x$18 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$14, x$15, x$16, x$17, x$18);
        this.destCluster().verifyTopicWritable(this.topic(), this.numPartitions());
        this.produceRecords(destProducer, this.topic(), 10, this.produceRecords$default$4());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = this.linkName();
        boolean x$20 = qual$5.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$21 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$19, x$20, x$21);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteClusterLinkCleanup(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.createClusterLink(this.linkName(), this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)"10000")})))), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        scala.collection.immutable.Set topics = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)idx -> ClusterLinkIntegrationTest.$anonfun$testDeleteClusterLinkCleanup$1(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ClusterLinkTestHarness qual$1 = this.sourceCluster();
            int x$2 = this.numPartitions();
            short x$3 = this.replicationFactor();
            Properties x$4 = qual$1.createTopic$default$4();
            ListenerName x$5 = qual$1.createTopic$default$5();
            qual$1.createTopic((String)topic, x$2, x$3, x$4, x$5);
            ClusterLinkTestHarness qual$2 = this.destCluster();
            short x$7 = this.replicationFactor();
            String x$8 = this.linkName();
            Map<String, String> x$9 = qual$2.linkTopic$default$4();
            String x$10 = qual$2.linkTopic$default$5();
            return qual$2.linkTopic((String)topic, x$7, x$8, x$9, x$10);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        boolean x$11 = qual$3.listMirrorTopics$default$1();
        Assertions.assertEquals((int)topics.size(), (int)qual$3.listMirrorTopics(x$11).size());
        Assertions.assertThrows(ClusterLinkInUseException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$12 = this.linkName();
            boolean x$13 = qual$4.deleteClusterLink$default$2();
            Buffer<KafkaBroker> x$14 = qual$4.deleteClusterLink$default$3();
            qual$4.deleteClusterLink(x$12, x$13, x$14);
        });
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$15 = this.linkName();
        boolean x$16 = true;
        Buffer<KafkaBroker> x$17 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$15, x$16, x$17);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$18 = qual$6.listMirrorTopics$default$1();
        Assertions.assertTrue((boolean)qual$6.listMirrorTopics(x$18).isEmpty());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        boolean x$19 = qual$7.listClusterLinks$default$1();
        Assertions.assertTrue((boolean)qual$7.listClusterLinks(x$19).isEmpty());
        Assertions.assertThrows(ClusterLinkNotFoundException.class, () -> this.destCluster().describeClusterLink(this.linkName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMirroredTopicMarkedForDelete(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        IndexedSeq partitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        int brokerId = this.destCluster().shutdownLeader((TopicPartition)partitions.head())._1$mcI$sp();
        Buffer otherBrokers = (Buffer)this.destCluster().brokers().filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$2(brokerId, x$27)));
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        otherBrokers.foreach((Function1 & Serializable & scala.Serializable)broker -> {
            ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$3(partitions, linkId, broker);
            return BoxedUnit.UNIT;
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.linkName();
        boolean x$13 = qual$3.deleteClusterLink$default$2();
        qual$3.deleteClusterLink(x$11, x$13, (Buffer<KafkaBroker>)otherBrokers);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPauseTopic(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$6 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$7 = qual$2.pauseTopic$default$2();
            qual$2.pauseTopic(x$6, x$7);
        });
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$8 = this.topic();
        short x$9 = this.replicationFactor();
        String x$10 = this.linkName();
        String x$11 = this.clusterLinkPrefix();
        Map<String, String> x$12 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$8, x$9, x$10, x$12, x$11);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$13 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$14 = qual$4.pauseTopic$default$2();
        qual$4.pauseTopic(x$13, x$14);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$15 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        boolean x$16 = qual$5.pauseTopic$default$2();
        qual$5.pauseTopic(x$15, x$16);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testPauseTopic$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testPauseTopic$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyMirrorTopicCountMetric("mirror-topic-count", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)"PausedMirror")}))), this.verifyMirrorTopicCountMetric$default$3(), this.verifyMirrorTopicCountMetric$default$4(), this.verifyMirrorTopicCountMetric$default$5());
        Seq oldLeaderOffsets = this.leaderOffsets$1();
        this.produceToSourceCluster(8);
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)oldLeaderOffsets, (Object)this.leaderOffsets$1());
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.destCluster().pauseTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            ClusterLinkTestHarness qual$7 = this.destCluster();
            String x$20 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$22 = qual$7.replicaStatus$default$3();
            Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)((ReplicaStatus.MirrorInfo)((ReplicaStatus)((IterableLike)qual$7.replicaStatus(x$20, partition, x$22).filter((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.isLeader()))).head()).mirrorInfo().get()).state());
        });
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$23 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$24 = this.linkName();
        boolean x$25 = qual$8.unlinkTopic$default$3();
        boolean x$26 = qual$8.unlinkTopic$default$4();
        boolean x$27 = qual$8.unlinkTopic$default$5();
        qual$8.unlinkTopic(x$23, x$24, x$25, x$26, x$27);
        Assertions.assertThrows(InvalidRequestException.class, () -> {
            ClusterLinkTestHarness qual$9 = this.destCluster();
            String x$28 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$29 = qual$9.pauseTopic$default$2();
            qual$9.pauseTopic(x$28, x$29);
        });
        ClusterLinkTestHarness qual$10 = this.destCluster();
        String x$30 = this.linkName();
        boolean x$31 = qual$10.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$32 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(x$30, x$31, x$32);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPauseClusterLink(String quorum) {
        void var25_37;
        Tuple2 tuple2;
        void var24_30;
        Tuple2 tuple22;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        int oldNumPartitions = this.numPartitions();
        String oldDeleteRetentionMs = "10000";
        int oldOffset = 10;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, oldNumPartitions, x$3, x$4, x$5);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.DeleteRetentionMsProp()), (Object)oldDeleteRetentionMs)}))));
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), "100");
        linkProps.setProperty("metadata.max.age.ms", "100");
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.produceToSourceCluster(8);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, oldOffset, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, oldOffset, this.consumerGroup());
        this.verifyConsumerOffsetMigrationMetrics();
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        int newNumPartitions = oldNumPartitions + 2;
        String newDeleteRetentionMs = "20000";
        int newOffset = 20;
        this.sourceCluster().createPartitions(this.topic(), newNumPartitions);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.DeleteRetentionMsProp()), (Object)newDeleteRetentionMs)}))));
        this.produceToSourceCluster(8);
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, newOffset, this.consumerGroup());
        this.verifyPausedLinkMetrics();
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.PAUSED, ClusterLinkDescription.LinkState.PAUSED);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.topic();
        boolean x$12 = qual$3.pauseTopic$default$2();
        qual$3.pauseTopic(x$11, x$12);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        this.destCluster().pauseTopic(this.topic(), false);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.LINK_PAUSED);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.PAUSED, this.waitUntilMirrorState$default$2());
        Assertions.assertThrows(ClusterLinkPausedException.class, () -> {
            ClusterLinkTestHarness qual$4 = this.destCluster();
            String x$13 = "paused-topic";
            short x$14 = this.replicationFactor();
            String x$15 = this.linkName();
            Map<String, String> x$16 = qual$4.linkTopic$default$4();
            String x$17 = qual$4.linkTopic$default$5();
            qual$4.linkTopic(x$13, x$14, x$15, x$16, x$17);
        });
        Thread.sleep(250L);
        Assertions.assertEquals((int)oldNumPartitions, (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Assertions.assertEquals((Object)oldDeleteRetentionMs, (Object)this.destCluster().describeTopicConfig(this.topic()).get(LogConfig$.MODULE$.DeleteRetentionMsProp()).value());
        Assertions.assertEquals((long)oldOffset, (long)this.destCluster().getOffset(this.topic(), 0, this.consumerGroup()));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, this.waitUntilMirrorState$default$2());
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            int n = ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$2(this);
            Integer computeUntilTrue_result = BoxesRunTime.boxToInteger((int)n);
            if (ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$3(newNumPartitions, n)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int numDestPartitions = tuple22._1$mcI$sp();
        Assertions.assertEquals((int)newNumPartitions, (int)var24_30);
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            String computeUntilTrue_result;
            String string;
            if (ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$5(newDeleteRetentionMs, string = (computeUntilTrue_result = ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$4(this)))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String destDeleteRetentionMs = (String)tuple2._1();
        Assertions.assertEquals((Object)newDeleteRetentionMs, (Object)var25_37);
        this.verifyOffsetMigration(this.topic(), 0, newOffset, this.consumerGroup());
        this.verifyBasicLinkMetrics(linkId, linkProps, this.verifyBasicLinkMetrics$default$3());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$18 = this.topic();
        String x$19 = this.linkName();
        boolean x$20 = qual$5.unlinkTopic$default$3();
        boolean x$21 = qual$5.unlinkTopic$default$4();
        boolean x$22 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$18, x$19, x$20, x$21, x$22);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$6.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$25 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$23, x$24, x$25);
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicaStatus(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(1);
        qual$1 = this.sourceCluster();
        x$1 = this.topic();
        x$2 = this.numPartitions();
        x$3 = this.replicationFactor();
        x$4 = qual$1.createTopic$default$4();
        x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        rs1 = this.sourceCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)2, (int)rs1.size());
        leader1 = (ReplicaStatus)((IterableLike)rs1.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$1$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)leader1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)leader1.mirrorInfo());
        follower1 = (ReplicaStatus)((IterableLike)rs1.filterNot((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$2$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower1.linkName());
        Assertions.assertEquals(Optional.empty(), (Object)follower1.mirrorInfo());
        timestamp = Time.SYSTEM.milliseconds();
        this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        qual$2 = this.destCluster();
        x$6 = this.topic();
        x$7 = this.replicationFactor();
        x$8 = this.linkName();
        x$9 = qual$2.linkTopic$default$4();
        x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        expectedLeaderEpoch = this.destCluster().isKRaftTest() != false ? 0 : 1;
        var51_19 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var49_20 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$3(this, expectedLeaderEpoch)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs2 = this.destCluster().replicaStatus(this.topic(), 0, true);
        Assertions.assertEquals((int)4, (int)rs2.size());
        localLeader2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$5$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)localLeader2.mirrorInfo().isPresent());
        mi2 = (ReplicaStatus.MirrorInfo)localLeader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi2.state());
        Assertions.assertTrue((boolean)(timestamp <= mi2.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(timestamp).append(" <= ").append(mi2.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)numRecords, (long)mi2.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        localFollower2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$6$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)localFollower2.mirrorInfo());
        remoteLeader2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$7$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteLeader2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteLeader2.mirrorInfo());
        remoteFollower2 = (ReplicaStatus)((IterableLike)rs2.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$8$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals((Object)this.linkName(), remoteFollower2.linkName().get());
        Assertions.assertEquals(Optional.empty(), (Object)remoteFollower2.mirrorInfo());
        lastFetchTimeMs = mi2.lastFetchTimeMs();
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        rs3 = this.destCluster().replicaStatus(this.topic(), 0, false);
        Assertions.assertEquals((int)2, (int)rs3.size());
        leader3 = (ReplicaStatus)((IterableLike)rs3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$9$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader3.mirrorInfo().isPresent());
        mi3 = (ReplicaStatus.MirrorInfo)leader3.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi3.state());
        Assertions.assertTrue((boolean)(lastFetchTimeMs <= mi3.lastFetchTimeMs()), (String)new StringBuilder(14).append("Expected: ").append(lastFetchTimeMs).append(" <= ").append(mi3.lastFetchTimeMs()).toString());
        Assertions.assertEquals((long)(numRecords * 2), (long)mi3.lastFetchSourceHighWatermark());
        follower3 = (ReplicaStatus)((IterableLike)rs3.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$10$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower3.mirrorInfo());
        qual$3 = this.destCluster();
        x$11 = this.topic();
        x$12 = this.linkName();
        x$13 = qual$3.unlinkTopic$default$3();
        x$14 = qual$3.unlinkTopic$default$4();
        x$15 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$11, x$12, x$13, x$14, x$15);
        rs4 = ObjectRef.create(null);
        var57_41 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var55_42 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$11(this, rs4)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        leader4 = (ReplicaStatus)((IterableLike)((Seq)rs4.elem).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$13$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertTrue((boolean)leader4.mirrorInfo().isPresent());
        mi4 = (ReplicaStatus.MirrorInfo)leader4.mirrorInfo().get();
        v0 = mi4.state();
        var42_46 = ReplicaStatus.MirrorInfo.State.PENDING_STOPPED;
        if (!(v0 == null ? var42_46 != null : v0.equals(var42_46) == false)) ** GOTO lbl-1000
        v1 = mi4.state();
        var43_47 = ReplicaStatus.MirrorInfo.State.STOPPED;
        if (!(v1 != null ? v1.equals(var43_47) == false : var43_47 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)v2);
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchTimeMs());
        Assertions.assertEquals((long)-1L, (long)mi4.lastFetchSourceHighWatermark());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
        follower4 = (ReplicaStatus)((IterableLike)((Seq)rs4.elem).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testReplicaStatus$14$adapted(org.apache.kafka.common.replica.ReplicaStatus ), (Lorg/apache/kafka/common/replica/ReplicaStatus;)Ljava/lang/Object;)())).head();
        Assertions.assertEquals(Optional.empty(), (Object)follower4.mirrorInfo());
        qual$4 = this.destCluster();
        x$16 = this.linkName();
        x$17 = qual$4.deleteClusterLink$default$2();
        x$18 = qual$4.deleteClusterLink$default$3();
        qual$4.deleteClusterLink(x$16, x$17, x$18);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroring(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.autoMirrorTopic(this.syncPeriod());
        String newTopic = new StringBuilder(2).append(this.topic()).append("-2").toString();
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.linkName();
        Map x$2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
        qual$1.alterClusterLink(x$1, (Map<String, String>)x$2, x$3);
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        String x$4 = String.valueOf(newTopic);
        int x$5 = qual$2.createTopic$default$2();
        int x$6 = qual$2.createTopic$default$3();
        Properties x$7 = qual$2.createTopic$default$4();
        ListenerName x$8 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$4, x$5, x$6, x$7, x$8);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString());
        Thread.sleep(this.syncPeriod() * 5L);
        Assertions.assertEquals((double)0.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-create-failed-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        Assertions.assertEquals((double)2.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-created-total", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        String excludeTopicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(newTopic).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$9 = this.linkName();
        Map x$10 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter)}));
        Seq<KafkaBroker> x$11 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$9, (Map<String, String>)x$10, x$11);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString(), true);
        Thread.sleep(1000L);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$12 = qual$4.listMirrorTopics$default$1();
        Assertions.assertFalse((boolean)qual$4.listMirrorTopics(x$12).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(newTopic).toString()));
        String conflictingTopic = new StringBuilder(9).append(this.topic()).append("-conflict").toString();
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$13 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString();
        int x$14 = qual$5.createTopic$default$2();
        int x$15 = qual$5.createTopic$default$3();
        Properties x$16 = qual$5.createTopic$default$4();
        ListenerName x$17 = qual$5.createTopic$default$5();
        qual$5.createTopic(x$13, x$14, x$15, x$16, x$17);
        ClusterLinkTestHarness qual$6 = this.sourceCluster();
        int x$19 = qual$6.createTopic$default$2();
        int x$20 = qual$6.createTopic$default$3();
        Properties x$21 = qual$6.createTopic$default$4();
        ListenerName x$22 = qual$6.createTopic$default$5();
        qual$6.createTopic(conflictingTopic, x$19, x$20, x$21, x$22);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString(), false);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$23 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(conflictingTopic).toString();
        String x$24 = this.linkName();
        boolean x$25 = false;
        boolean x$26 = qual$7.unlinkTopic$default$4();
        boolean x$27 = qual$7.unlinkTopic$default$5();
        qual$7.unlinkTopic(x$23, x$24, x$25, x$26, x$27);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        String x$28 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$29 = this.linkName();
        boolean x$30 = qual$8.unlinkTopic$default$3();
        boolean x$31 = qual$8.unlinkTopic$default$4();
        boolean x$32 = qual$8.unlinkTopic$default$5();
        qual$8.unlinkTopic(x$28, x$29, x$30, x$31, x$32);
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$33 = this.linkName();
        boolean x$34 = qual$9.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$35 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$33, x$34, x$35);
    }

    public void autoMirrorTopic(long syncPeriod) {
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), Long.toString(syncPeriod * 10L));
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(linkId, this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyAutoMirroringSuccessMetric();
    }

    public Properties destLinkPropsForAutoMirroring(String topicFilters, boolean configureLinkPrefix) {
        scala.collection.mutable.Map autoMirrorOverrides = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)topicFilters);
        autoMirrorOverrides.put((Object)"metadata.max.age.ms", (Object)Long.toString(this.syncPeriod()));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty() && configureLinkPrefix) {
            autoMirrorOverrides.put((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), (Object)this.clusterLinkPrefix());
        }
        return this.destLinkProps((Map<String, String>)autoMirrorOverrides);
    }

    public boolean destLinkPropsForAutoMirroring$default$2() {
        return false;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLastFetchedOffsetPromotedMirrorTopicDescription(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(this.testLastFetchedOffsetStoppedMirrorTopicDescription$default$1());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLastFetchedOffsetFailedOverMirrorTopicDescription(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.testLastFetchedOffsetStoppedMirrorTopicDescription(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAutoMirroringNoOverlappingTopicFilters(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        String topicTwo = "linkedTopicTwo";
        String multipleOverlappingTopicFilters = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(335).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |    \"name\": \"").append(topicTwo).append("\",\n          |    \"patternType\": \"literal\",\n          |    \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        Properties linkProps = this.destLinkPropsForAutoMirroring(multipleOverlappingTopicFilters, this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        Properties linkPropsTwo = this.destLinkPropsForAutoMirroring(this.includeAllTopicsFilter(), this.destLinkPropsForAutoMirroring$default$2());
        UUID linkIdTwo = this.createClusterLink(linkNameTwo, linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        InvalidConfigurationException exceptionTwo = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            Map x$2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
            Seq<KafkaBroker> x$3 = qual$1.alterClusterLink$default$3();
            qual$1.alterClusterLink(linkNameTwo, (Map<String, String>)x$2, x$3);
        });
        Assertions.assertEquals((Object)"Found overlapping topic filter(s): new topic filter linkedTopic overlaps with existing topic filter from cluster link testLink.", (Object)exceptionTwo.getMessage());
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$4 = this.linkName();
        boolean x$5 = qual$2.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$6 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$4, x$5, x$6);
        if (this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$3 = this.sourceCluster();
            String x$7 = this.linkName();
            boolean x$8 = qual$3.deleteClusterLink$default$2();
            Buffer<KafkaBroker> x$9 = qual$3.deleteClusterLink$default$3();
            qual$3.deleteClusterLink(x$7, x$8, x$9);
            ClusterLinkTestHarness qual$4 = this.sourceCluster();
            boolean x$10 = qual$4.listClusterLinks$default$1();
            Assertions.assertTrue((qual$4.listClusterLinks(x$10).size() == 1 ? 1 : 0) != 0);
            ClusterLinkTestHarness qual$5 = this.sourceCluster();
            boolean x$11 = qual$5.describeClusterLinks$default$1();
            Assertions.assertTrue((qual$5.describeClusterLinks(x$11).size() == 1 ? 1 : 0) != 0);
        }
        ClusterLinkTestHarness qual$6 = this.destCluster();
        Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$14 = qual$6.alterClusterLink$default$3();
        qual$6.alterClusterLink(linkNameTwo, (Map<String, String>)x$13, x$14);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$7 = this.destCluster();
        Map x$16 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$17 = qual$7.alterClusterLink$default$3();
        qual$7.alterClusterLink(linkNameTwo, (Map<String, String>)x$16, x$17);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        this.createClusterLink(this.linkName(), linkPropsTwo, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$8 = this.destCluster();
        Map x$19 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.includeAllTopicsFilter())}));
        Seq<KafkaBroker> x$20 = qual$8.alterClusterLink$default$3();
        qual$8.alterClusterLink(linkNameTwo, (Map<String, String>)x$19, x$20);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkIdTwo).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$9 = this.destCluster();
        String x$21 = this.linkName();
        boolean x$22 = qual$9.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$23 = qual$9.deleteClusterLink$default$3();
        qual$9.deleteClusterLink(x$21, x$22, x$23);
        ClusterLinkTestHarness qual$10 = this.destCluster();
        boolean x$25 = qual$10.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$26 = qual$10.deleteClusterLink$default$3();
        qual$10.deleteClusterLink(linkNameTwo, x$25, x$26);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringAllowsLinkConfigUpdate(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(numRecords);
        Properties linkPropsOne = this.destLinkPropsForAutoMirroring(this.topicFilter(), this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(this.linkName(), linkPropsOne, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(this.topic());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.linkName();
        Map x$7 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}));
        Seq<KafkaBroker> x$8 = qual$2.alterClusterLink$default$3();
        qual$2.alterClusterLink(x$6, (Map<String, String>)x$7, x$8);
        String topicTwo = "linkedTopicTwo";
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        int x$10 = this.numPartitions();
        short x$11 = this.replicationFactor();
        Properties x$12 = qual$3.createTopic$default$4();
        ListenerName x$13 = qual$3.createTopic$default$5();
        qual$3.createTopic(topicTwo, x$10, x$11, x$12, x$13);
        this.produceToSourceCluster(numRecords);
        ObjectRef linkPropsTwo = ObjectRef.create((Object)this.destLinkPropsForAutoMirroring(this.topicFilter(), this.destLinkPropsForAutoMirroring$default$2()));
        String linkNameTwo = new StringBuilder(2).append(this.linkName()).append("-2").toString();
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo$1.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        String topicFilterTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(197).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        linkPropsTwo.elem = this.destLinkPropsForAutoMirroring(topicFilterTwo, this.destLinkPropsForAutoMirroring$default$2());
        this.createClusterLink(linkNameTwo, (Properties)linkPropsTwo.elem, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(this.topic());
        this.waitForAutoMirrorCreation(topicTwo);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.linkName();
        Map x$15 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}));
        Seq<KafkaBroker> x$16 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$14, (Map<String, String>)x$15, x$16);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$17 = this.topic();
        String x$18 = this.linkName();
        boolean x$19 = false;
        boolean x$20 = qual$5.unlinkTopic$default$3();
        boolean x$21 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$17, x$18, x$20, x$19, x$21);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        boolean x$24 = false;
        boolean x$25 = qual$6.unlinkTopic$default$3();
        boolean x$26 = qual$6.unlinkTopic$default$5();
        qual$6.unlinkTopic(topicTwo, linkNameTwo, x$25, x$24, x$26);
        ClusterLinkTestHarness qual$7 = this.destCluster();
        String x$27 = this.linkName();
        boolean x$28 = true;
        Buffer<KafkaBroker> x$29 = qual$7.deleteClusterLink$default$3();
        qual$7.deleteClusterLink(x$27, x$28, x$29);
        ClusterLinkTestHarness qual$8 = this.destCluster();
        boolean x$31 = true;
        Buffer<KafkaBroker> x$32 = qual$8.deleteClusterLink$default$3();
        qual$8.deleteClusterLink(linkNameTwo, x$31, x$32);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringUpdateExistingLink(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)Long.toString(this.syncPeriod()))}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = qual$2.createTopic$default$4();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(x$6, x$7, x$8, x$9, x$10);
        scala.collection.mutable.Map autoMirrorProps = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), (Object)"true");
        autoMirrorProps.put((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp(), (Object)this.topicFilter());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$3 = this.destCluster();
            String x$11 = this.linkName();
            Seq<KafkaBroker> x$13 = qual$3.alterClusterLink$default$3();
            qual$3.alterClusterLink(x$11, (Map<String, String>)autoMirrorProps, x$13);
        });
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = this.linkName();
        Seq<KafkaBroker> x$16 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$14, (Map<String, String>)autoMirrorProps, x$16);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.produceToSourceCluster(10);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$17 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$18 = this.linkName();
        boolean x$19 = false;
        boolean x$20 = qual$5.unlinkTopic$default$3();
        boolean x$21 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$17, x$18, x$20, x$19, x$21);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$22 = this.linkName();
        boolean x$23 = qual$6.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$24 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$22, x$23, x$24);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringAddingAdditionalTopic(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        String topicTwo = "linkedTopic2";
        ClusterLinkTestHarness qual$2 = this.sourceCluster();
        int x$7 = this.numPartitions();
        short x$8 = this.replicationFactor();
        Properties x$9 = qual$2.createTopic$default$4();
        ListenerName x$10 = qual$2.createTopic$default$5();
        qual$2.createTopic(topicTwo, x$7, x$8, x$9, x$10);
        String topicFilterTwo = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(topicTwo).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = this.linkName();
        Map x$12 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilterTwo)}));
        Seq<KafkaBroker> x$13 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$11, (Map<String, String>)x$12, x$13);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(topicTwo).toString());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$15 = this.linkName();
        boolean x$16 = false;
        boolean x$17 = false;
        boolean x$18 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$14, x$15, x$16, x$17, x$18);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(topicTwo).toString();
        String x$20 = this.linkName();
        boolean x$21 = false;
        boolean x$22 = qual$5.unlinkTopic$default$3();
        boolean x$23 = qual$5.unlinkTopic$default$5();
        qual$5.unlinkTopic(x$19, x$20, x$22, x$21, x$23);
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$24 = this.linkName();
        boolean x$25 = true;
        Buffer<KafkaBroker> x$26 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$24, x$25, x$26);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoMirroringNoExistingTopic(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$2 = qual$1.createTopic$default$2();
        int x$3 = qual$1.createTopic$default$3();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.topicFilter(), true);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$6 = this.linkName();
            Map x$7 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
            Seq<KafkaBroker> x$8 = qual$2.alterClusterLink$default$3();
            qual$2.alterClusterLink(x$6, (Map<String, String>)x$7, x$8);
        });
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.includeAllTopicsFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$9 = this.linkName();
        Map x$10 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$11 = qual$3.alterClusterLink$default$3();
        qual$3.alterClusterLink(x$9, (Map<String, String>)x$10, x$11);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$12 = this.linkName();
        Map x$13 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicFilter())}));
        Seq<KafkaBroker> x$14 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$12, (Map<String, String>)x$13, x$14);
        Assertions.assertEquals((Object)ClusterLinkFilterJson$.MODULE$.parse(this.topicFilter()), (Object)((ClusterLinkFactory.ConnectionManager)((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().connectionManager(linkId).get()).currentConfig().topicFilters());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$15 = this.linkName();
        boolean x$16 = qual$5.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$17 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$15, x$16, x$17);
    }

    /*
     * WARNING - void declaration
     */
    private void testLastFetchedOffsetStoppedMirrorTopicDescription(boolean promote) {
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        int expectedLeaderEpoch = this.destCluster().isKRaftTest() ? 0 : 1;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(this, expectedLeaderEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$12 = 0;
        boolean x$13 = qual$3.replicaStatus$default$3();
        ReplicaStatus leader = (ReplicaStatus)((IterableLike)qual$3.replicaStatus(x$11, x$12, x$13).filter((Function1 & Serializable & scala.Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(rs)))).head();
        Assertions.assertTrue((boolean)leader.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi = (ReplicaStatus.MirrorInfo)leader.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.ACTIVE, (Object)mi.state());
        Assertions.assertEquals((long)numRecords, (long)mi.lastFetchSourceHighWatermark());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$14 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$15 = this.linkName();
        boolean x$17 = qual$4.unlinkTopic$default$3();
        boolean x$18 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$14, x$15, x$17, promote, x$18);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$19 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        int x$20 = 0;
        boolean x$21 = qual$5.replicaStatus$default$3();
        ReplicaStatus leader2 = (ReplicaStatus)((IterableLike)qual$5.replicaStatus(x$19, x$20, x$21).filter((Function1 & Serializable & scala.Serializable)rs -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(rs)))).head();
        Assertions.assertTrue((boolean)leader2.mirrorInfo().isPresent());
        ReplicaStatus.MirrorInfo mi2 = (ReplicaStatus.MirrorInfo)leader2.mirrorInfo().get();
        Assertions.assertEquals((Object)ReplicaStatus.MirrorInfo.State.STOPPED, (Object)mi2.state());
        Assertions.assertEquals((long)-1L, (long)mi2.lastFetchSourceHighWatermark());
        MirrorTopicDescription desc = this.destCluster().describeMirrorTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        Assertions.assertEquals((Object)desc.state(), (Object)MirrorTopicDescription.State.STOPPED);
        Assertions.assertEquals((int)1, (int)desc.stoppedLogEndOffsets().size());
        Assertions.assertEquals((long)numRecords, (long)Predef$.MODULE$.Long2long((Long)desc.stoppedLogEndOffsets().get(0)));
    }

    private boolean testLastFetchedOffsetStoppedMirrorTopicDescription$default$1() {
        return true;
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteAutoMirroredTopics(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.autoMirrorTopic(this.syncPeriod());
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false));
        ClusterLinkTestHarness qual$1 = this.destCluster();
        boolean x$1 = qual$1.listMirrorTopics$default$1();
        Assertions.assertTrue((boolean)qual$1.listMirrorTopics(x$1).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$2 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$3 = this.linkName();
        boolean x$4 = qual$2.unlinkTopic$default$3();
        boolean x$5 = qual$2.unlinkTopic$default$4();
        boolean x$6 = qual$2.unlinkTopic$default$5();
        qual$2.unlinkTopic(x$2, x$3, x$4, x$5, x$6);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), false);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.FAILED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$3 = this.sourceCluster();
        String x$7 = this.topic();
        int x$8 = this.numPartitions();
        short x$9 = this.replicationFactor();
        Properties x$10 = qual$3.createTopic$default$4();
        ListenerName x$11 = qual$3.createTopic$default$5();
        qual$3.createTopic(x$7, x$8, x$9, x$10, x$11);
        this.produceToSourceCluster(20);
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        String excludeTopicFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("|{\n          |\"topicFilters\": [\n          |  {\n          |     \"name\": \"*\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"include\"\n          |  },\n          |  {\n          |     \"name\": \"").append(this.topic()).append("\",\n          |     \"patternType\": \"literal\",\n          |     \"filterType\": \"exclude\"\n          |  }\n          |]}\n          |").toString())).stripMargin();
        Map updatedProps = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)excludeTopicFilter), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$12 = this.linkName();
        Seq<KafkaBroker> x$14 = qual$4.alterClusterLink$default$3();
        qual$4.alterClusterLink(x$12, (Map<String, String>)updatedProps, x$14);
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        boolean x$15 = qual$5.listMirrorTopics$default$1();
        Assertions.assertFalse((boolean)qual$5.listMirrorTopics(x$15).contains((Object)new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString()));
        ClusterLinkTestHarness qual$6 = this.destCluster();
        String x$16 = this.linkName();
        boolean x$17 = qual$6.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$18 = qual$6.deleteClusterLink$default$3();
        qual$6.deleteClusterLink(x$16, x$17, x$18);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testIntervalChangeForPeriodicTasks(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), this.consumerGroupFilter(this.consumerGroup()));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), String.valueOf(300000));
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), this.includeAllTopicsFilter());
        linkProps.setProperty("metadata.max.age.ms", String.valueOf(300000));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = 2;
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.sourceCluster().alterTopic(this.topic(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete.retention.ms"), (Object)"80000000")}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testIntervalChangeForPeriodicTasks$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyTopicConfigChangeMetrics();
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, this.offsetToCommit(), this.consumerGroup());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncMsProp()), (Object)String.valueOf(this.syncPeriod()))}))));
        this.verifyOffsetMigration(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), 0, this.offsetToCommit(), this.consumerGroup());
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$12 = this.linkName();
        boolean x$13 = qual$3.unlinkTopic$default$3();
        boolean x$14 = qual$3.unlinkTopic$default$4();
        boolean x$15 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$11, x$12, x$13, x$14, x$15);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.destCluster().deleteTopic(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString(), true);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.max.age.ms"), (Object)String.valueOf(this.syncPeriod()))}))));
        this.waitForAutoMirrorCreation(new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"false")}))));
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$16 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$17 = this.linkName();
        boolean x$18 = qual$4.unlinkTopic$default$3();
        boolean x$19 = qual$4.unlinkTopic$default$4();
        boolean x$20 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$16, x$17, x$18, x$19, x$20);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$21 = this.linkName();
        boolean x$22 = qual$5.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$23 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$21, x$22, x$23);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testExternalizedPasswordConfig(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        int numRecords = 20;
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(numRecords);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        File propsFile = TestUtils.tempFile((String)new StringBuilder(17).append("sasl.jaas.config=").append(linkProps.getProperty("sasl.jaas.config")).toString());
        String arg$macro$1 = propsFile.getAbsolutePath();
        linkProps.put("sasl.jaas.config", new StringOps("${file:%s:sasl.jaas.config}").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        linkProps.setProperty("config.providers", "file");
        linkProps.setProperty("config.providers.file.class", FileConfigProvider.class.getName());
        UUID linkId = this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifySaslJaasConfigEncrypted(linkId);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp()), (Object)"1000")}))));
        this.verifySaslJaasConfigEncrypted(linkId);
        this.produceToSourceCluster(numRecords);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
        linkProps.setProperty("sasl.jaas.config", "someprovider:link.props:sasl.jaas.config");
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            String x$11 = "invalidLink1";
            boolean x$13 = true;
            Option<Properties> x$14 = this.createClusterLink$default$3();
            this.createClusterLink(x$11, linkProps, x$14, x$13);
        });
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            String x$15 = "invalidLink2";
            boolean x$17 = false;
            Option<Properties> x$18 = this.createClusterLink$default$3();
            this.createClusterLink(x$15, linkProps, x$18, x$17);
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testMirrorFailoverWhenSourceIsUnavailable(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        this.numPartitions_$eq(1);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps(this.destLinkProps$default$1());
        linkProps.setProperty("metadata.max.age.ms", "100");
        linkProps.setProperty("request.timeout.ms", "1000");
        linkProps.setProperty("default.api.timeout.ms", "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.RetryTimeoutMsProp(), "1000");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp(), "100");
        linkProps.setProperty(ClusterLinkConfig$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdProp(), "2");
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        this.createClusterLink(this.linkName(), linkProps, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        String x$9 = this.clusterLinkPrefix();
        Map<String, String> x$10 = qual$2.linkTopic$default$4();
        qual$2.linkTopic(x$6, x$7, x$8, x$10, x$9);
        int expectedLeaderEpoch = this.destCluster().isKRaftTest() ? 0 : 1;
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(this, expectedLeaderEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirrorFailoverWhenSourceIsUnavailable$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.ACTIVE, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        this.updateCredentials(connectionTarget);
        this.waitUntilOneOfMirrorStates((scala.collection.immutable.Set<ReplicaStatus.MirrorInfo.State>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.SOURCE_AUTHENTICATION_FAILED, ReplicaStatus.MirrorInfo.State.SOURCE_UNAVAILABLE}))));
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.SOURCE_UNAVAILABLE);
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.UNAVAILABLE, ClusterLinkDescription.LinkState.ACTIVE);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$11 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$12 = this.linkName();
        boolean x$13 = false;
        boolean x$14 = qual$3.unlinkTopic$default$3();
        boolean x$15 = qual$3.unlinkTopic$default$5();
        qual$3.unlinkTopic(x$11, x$12, x$14, x$13, x$15);
        this.waitUntilMirrorState(ReplicaStatus.MirrorInfo.State.STOPPED, new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterLinkMetadataTopicCreation(String quorum) {
        Assumptions.assumeFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty());
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.destCluster().killAllBrokers();
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.enable", "true");
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.partitions", "2");
        this.destCluster().serverConfig().setProperty("confluent.cluster.link.metadata.topic.replication.factor", "1");
        this.destCluster().restartDeadBrokers(true);
        this.destCluster().updateBootstrapServers();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testClusterLinkMetadataTopicCreation$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testClusterLinkMetadataTopicCreation$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.enable");
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.partitions");
        this.destCluster().serverConfig().remove("confluent.cluster.link.metadata.topic.replication.factor");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDescribeClusterLink(String quorum) {
        UUID linkId = this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.verifyDescribeLinksResult(ClusterLinkDescription.LinkState.ACTIVE, ClusterLinkDescription.LinkState.ACTIVE);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.destCluster().updateZkLinkConfig(linkId, ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid");
        ClusterLinkTestHarness qual$3 = this.destCluster();
        Properties x$11 = qual$3.createConfluentAdminClient$default$1();
        ConfluentAdmin destAdmin = qual$3.createConfluentAdminClient(x$11);
        this.waitForFailure(destAdmin, FailureType$CorruptConfigs$.MODULE$);
        destAdmin.close();
        ClusterLinkTestHarness qual$4 = this.destCluster();
        boolean x$12 = qual$4.describeClusterLinks$default$1();
        Seq<ClusterLinkDescription> describeResult = qual$4.describeClusterLinks(x$12);
        Assertions.assertEquals((int)1, (int)describeResult.size());
        Assertions.assertEquals((Object)this.linkName(), (Object)((ClusterLinkDescription)describeResult.head()).linkName());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkState.FAILED, (Object)((ClusterLinkDescription)describeResult.head()).linkState());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.UNKNOWN, (Object)((ClusterLinkDescription)describeResult.head()).linkMode());
        Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.UNKNOWN, (Object)((ClusterLinkDescription)describeResult.head()).connectionMode());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAlterClusterLinkWithInvalidConfigs(String quorum) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        Properties linkProps = this.destLinkProps((Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}))));
        if (new StringOps(Predef$.MODULE$.augmentString(this.clusterLinkPrefix())).nonEmpty()) {
            linkProps.setProperty(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        }
        String x$6 = this.linkName();
        boolean x$8 = true;
        Option<Properties> x$9 = this.createClusterLink$default$3();
        UUID linkId = this.createClusterLink(x$6, linkProps, x$9, x$8);
        this.destCluster().updateZkLinkConfig(linkId, ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), "{");
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$10 = this.linkName();
        Map x$11 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.includeAllTopicsFilter().replace("topic", "group"))}));
        Seq<KafkaBroker> x$12 = qual$2.alterClusterLink$default$3();
        qual$2.alterClusterLink(x$10, (Map<String, String>)x$11, x$12);
        ClusterLinkTestHarness qual$3 = this.destCluster();
        String x$13 = this.topic();
        short x$14 = this.replicationFactor();
        String x$15 = this.linkName();
        String x$16 = this.clusterLinkPrefix();
        Map<String, String> x$17 = qual$3.linkTopic$default$4();
        qual$3.linkTopic(x$13, x$14, x$15, x$17, x$16);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        ClusterLinkTestHarness qual$4 = this.destCluster();
        String x$18 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
        String x$19 = this.linkName();
        boolean x$20 = qual$4.unlinkTopic$default$3();
        boolean x$21 = qual$4.unlinkTopic$default$4();
        boolean x$22 = qual$4.unlinkTopic$default$5();
        qual$4.unlinkTopic(x$18, x$19, x$20, x$21, x$22);
        ClusterLinkTestHarness qual$5 = this.destCluster();
        String x$23 = this.linkName();
        boolean x$24 = qual$5.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$25 = qual$5.deleteClusterLink$default$3();
        qual$5.deleteClusterLink(x$23, x$24, x$25);
    }

    public void verifyDescribeLinksResult(ClusterLinkDescription.LinkState destLinkState, ClusterLinkDescription.LinkState sourceLinkState) {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        boolean x$1 = qual$1.describeClusterLinks$default$1();
        Seq<ClusterLinkDescription> sourceLinkDescription = qual$1.describeClusterLinks(x$1);
        if (this.useSourceInitiatedLink()) {
            Assertions.assertEquals((int)1, (int)sourceLinkDescription.size());
            Assertions.assertEquals((Object)this.linkName(), (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkName());
            Assertions.assertEquals((Object)sourceLinkState, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkState());
            Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.SOURCE, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).linkMode());
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.OUTBOUND, (Object)((ClusterLinkDescription)sourceLinkDescription.head()).connectionMode());
        } else {
            Assertions.assertTrue((boolean)sourceLinkDescription.isEmpty());
        }
        ClusterLinkTestHarness qual$2 = this.destCluster();
        boolean x$2 = qual$2.describeClusterLinks$default$1();
        Seq<ClusterLinkDescription> destLinkDescription = qual$2.describeClusterLinks(x$2);
        Assertions.assertEquals((int)1, (int)destLinkDescription.size());
        Assertions.assertEquals((Object)destLinkState, (Object)((ClusterLinkDescription)destLinkDescription.head()).linkState());
        Assertions.assertEquals((Object)ClusterLinkDescription.LinkMode.DESTINATION, (Object)((ClusterLinkDescription)destLinkDescription.head()).linkMode());
        if (this.useSourceInitiatedLink()) {
            Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.INBOUND, (Object)((ClusterLinkDescription)destLinkDescription.head()).connectionMode());
            return;
        }
        Assertions.assertEquals((Object)ClusterLinkDescription.ConnectionMode.OUTBOUND, (Object)((ClusterLinkDescription)destLinkDescription.head()).connectionMode());
    }

    private void verifySaslJaasConfigEncrypted(UUID linkId) {
        String jaasConfig = ((ClusterLinkMetadataManager)((KafkaBroker)this.connectingCluster().brokers().head()).clusterLinkManager().clusterLinkMetadataManager().get()).getClusterLinkConfigProps(linkId).getProperty("sasl.jaas.config");
        Assertions.assertNotNull((Object)jaasConfig);
        Assertions.assertFalse((boolean)jaasConfig.contains("secret-"), (String)new StringBuilder(24).append("Password not encrypted: ").append(jaasConfig).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$1(ClusterLinkIntegrationTest $this, ClusterLinkListing x$1) {
        String string = x$1.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateMirrorTopic$2(ClusterLinkIntegrationTest $this, ClusterLinkDescription x$2) {
        String string = x$2.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testTransactionsWithMirrorTopic$4(ClusterLinkIntegrationTest $this) {
        return ((SeqLike)$this.partitions($this.partitions$default$1()).flatMap((Function1 & Serializable & scala.Serializable)tp -> (Buffer)((TraversableLike)$this.destCluster().brokers().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.replicaManager().onlinePartition(tp)), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.linkedUpdatesOnly())), Seq$.MODULE$.canBuildFrom())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTransactionsWithMirrorTopic$8() {
        return "Mirror not stopped";
    }

    private final void restartMirrorTopic$1() {
        this.destCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        short x$2 = this.replicationFactor();
        String x$3 = this.linkName();
        Map<String, String> x$4 = qual$1.linkTopic$default$4();
        String x$5 = qual$1.linkTopic$default$5();
        qual$1.linkTopic(x$1, x$2, x$3, x$4, x$5);
    }

    private final void restartSource$1() {
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        boolean x$1 = qual$1.restartDeadBrokers$default$1();
        qual$1.restartDeadBrokers(x$1);
        this.sourceCluster().updateBootstrapServers();
        if (!this.useSourceInitiatedLink()) {
            ClusterLinkTestHarness qual$2 = this.destCluster();
            String x$3 = this.linkName();
            Tuple2[] tuple2Array = new Tuple2[1];
            ClusterLinkTestHarness qual$3 = this.sourceCluster();
            ListenerName x$2 = qual$3.bootstrapServers$default$1();
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)qual$3.bootstrapServers(x$2));
            Map x$4 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            Seq<KafkaBroker> x$5 = qual$2.alterClusterLink$default$3();
            qual$2.alterClusterLink(x$3, (Map<String, String>)x$4, x$5);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$1(ClusterLinkIntegrationTest $this, ClusterLinkListing x$5) {
        String string = x$5.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$2(ClusterLinkIntegrationTest $this, ClusterLinkDescription x$6) {
        String string = x$6.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$3(ClusterLinkIntegrationTest $this, ClusterLinkListing x$7) {
        String string = x$7.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$4(ClusterLinkIntegrationTest $this, ClusterLinkDescription x$8) {
        String string = x$8.linkName();
        String string2 = $this.linkName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Seq $anonfun$testCreateAndDeleteAndRecreateLink$5(KafkaBroker broker$1) {
        return broker$1.clusterLinkManager().listClusterLinks();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteAndRecreateLink$6(Seq x$9) {
        Seq seq = x$9;
        Nil$ nil$ = Nil$.MODULE$;
        return !(seq != null ? !seq.equals(nil$) : nil$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicConfigSync$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testTopicConfigSync$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$1(ClusterLinkIntegrationTest $this) {
        MirrorTopicDescription.State state = $this.destCluster().describeMirrorTopic($this.topic()).state();
        MirrorTopicDescription.State state2 = MirrorTopicDescription.State.STOPPED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$2() {
        return "Mirror took too long to stop.";
    }

    public static final /* synthetic */ boolean $anonfun$testListDescribeMirror$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().listMirrorTopics(true).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testListDescribeMirror$5() {
        return "Mirror state not removed";
    }

    private final void setQuota$1(long byteRate, ConfluentAdmin sourceAdmin$1) {
        ClientQuotaEntity quotaUser = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)this.linkUserName(this.linkName()))}))).asJava());
        ClientQuotaAlteration.Op quotaOp = new ClientQuotaAlteration.Op(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), Predef$.MODULE$.double2Double((double)byteRate));
        ClientQuotaAlteration quota = new ClientQuotaAlteration(quotaUser, Collections.singleton(quotaOp));
        sourceAdmin$1.alterClientQuotas(Collections.singleton(quota)).all().get(15L, TimeUnit.SECONDS);
    }

    private final boolean throttled$1() {
        return this.kafkaMetricMaxValue((Seq<KafkaBroker>)this.destCluster().brokers(), "fetch-throttle-time-max", "cluster-link", (Option<String>)new Some((Object)this.linkName()), this.kafkaMetricMaxValue$default$5(), this.kafkaMetricMaxValue$default$6()) > 0.0;
    }

    public static final /* synthetic */ int $anonfun$testDestinationClusterLinkBrokerLevelQuota$1(KafkaBroker x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ ConfigResource $anonfun$testDestinationClusterLinkBrokerLevelQuota$2(int brokerId) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId));
    }

    private static final void setQuota$2(long byteRate, Seq resources$1, ConfluentAdmin destAdmin$1) {
        AlterConfigOp alterOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), Long.toString(byteRate)), AlterConfigOp.OpType.SET);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)resources$1.map((Function1 & Serializable & scala.Serializable)x$13 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$13), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{alterOp}))).asJavaCollection()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        destAdmin$1.incrementalAlterConfigs(configs).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$verifyQuotaMode$1(KafkaBroker broker$2) {
        return broker$2.quotaManagers().produce().quotasEnabled();
    }

    public static final /* synthetic */ String $anonfun$verifyQuotaMode$2() {
        return "Produce quota not enabled";
    }

    public static final /* synthetic */ boolean $anonfun$verifyQuotaMode$3(KafkaBroker broker$2, ConfluentConfigs.ClusterLinkQuotaMode quotaMode$1) {
        ConfluentConfigs.ClusterLinkQuotaMode clusterLinkQuotaMode = broker$2.config().clusterLinkQuotaMode();
        return !(clusterLinkQuotaMode != null ? !clusterLinkQuotaMode.equals(quotaMode$1) : quotaMode$1 != null);
    }

    public static final /* synthetic */ String $anonfun$verifyQuotaMode$4() {
        return "Quota mode not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$2(ClusterLinkFetcherManager x$15) {
        return x$15.fetcherThreadCount() > 0;
    }

    private static final int fetchSize$1(ClusterLinkFetcherThread fetcherThread$1) {
        return BoxesRunTime.unboxToInt((Object)TestUtils.fieldValue((Object)fetcherThread$1, ReplicaFetcherThread.class, (String)"fetchSize"));
    }

    private static final int fetchResponseSize$1(ClusterLinkFetcherThread fetcherThread$1) {
        return BoxesRunTime.unboxToInt((Object)TestUtils.fieldValue((Object)fetcherThread$1, ClusterLinkFetcherThread.class, (String)"fetchResponseSize"));
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$8(Object expectedFetchSize$1, int x$18) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$18), (Object)expectedFetchSize$1);
    }

    public static final /* synthetic */ boolean $anonfun$verifyFetchResponseSize$10(Object expectedFetchResponseSize$1, int x$19) {
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)x$19), (Object)expectedFetchResponseSize$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$1(ClusterLinkIntegrationTest $this, TopicPartition tp$2) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)$this.destCluster().describeTopic($this.topic()).partitions().get(tp$2.partition())).isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ void $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$4(ConfluentAdmin destAdmin$2, TopicPartition tp$2) {
        try {
            destAdmin$2.electLeaders(ElectionType.PREFERRED, Collections.singleton(tp$2)).all().get(15L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable throwable) {
            Assertions.fail((String)"Preferred leader election failed");
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$testAddPartitions$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopic(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitions$2(ClusterLinkIntegrationTest $this, int x$25) {
        return x$25 == $this.numPartitions();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterClusterLinkConfigs$5(int x$26) {
        return x$26 == 3;
    }

    public static final /* synthetic */ void $anonfun$testDestReadOnly$4(ConfluentAdmin admin$1, ConfigResource resource$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            AlterConfigOp alterConfigOp;
            boolean expectSuccess;
            String name = (String)x0$1._1();
            Option value = (Option)x0$1._2();
            String string = name;
            String string2 = LogConfig$.MODULE$.UncleanLeaderElectionEnableProp();
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (expectSuccess = false);
            if (value instanceof Some) {
                String v = (String)((Some)value).value();
                alterConfigOp = new AlterConfigOp(new ConfigEntry(name, v), AlterConfigOp.OpType.SET);
            } else if (None$.MODULE$.equals(value)) {
                alterConfigOp = new AlterConfigOp(new ConfigEntry(name, null), AlterConfigOp.OpType.DELETE);
            } else {
                throw new MatchError((Object)value);
            }
            try {
                java.util.Set<AlterConfigOp> ops = Collections.singleton(alterConfigOp);
                admin$1.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource$1), ops)}))).asJava()).all().get();
                Assertions.assertTrue((boolean)expectSuccess);
                return;
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidConfigurationException));
                Assertions.assertFalse((boolean)expectSuccess);
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDestReadOnly$3(ClusterLinkIntegrationTest $this, ConfluentAdmin admin) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, $this.topic());
        try {
            admin.alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)List$.MODULE$.empty()).asJavaCollection()))}))).asJava()).all().get(20L, TimeUnit.SECONDS);
            Assertions.fail((String)"alterConfigs() on a mirror topic should fail");
        }
        catch (ExecutionException executionException) {
            Assertions.assertTrue((boolean)(executionException.getCause() instanceof InvalidRequestException));
        }
        new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)new Some((Object)"true")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)None$.MODULE$), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)new Some((Object)"compact")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)None$.MODULE$), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkIntegrationTest.$anonfun$testDestReadOnly$4(admin, resource, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testDeleteClusterLinkCleanup$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public static final /* synthetic */ TopicPartition $anonfun$testMirroredTopicMarkedForDelete$1(ClusterLinkIntegrationTest $this, int i) {
        return new TopicPartition(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString(), i);
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$2(int brokerId$1, KafkaBroker x$27) {
        return x$27.config().brokerId() != brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$4(IndexedSeq partitions$1, KafkaBroker broker$3) {
        return ((SeqLike)partitions$1.flatMap((Function1 & Serializable & scala.Serializable)tp -> Option$.MODULE$.option2Iterable(broker$3.replicaManager().onlinePartition(tp)), IndexedSeq$.MODULE$.canBuildFrom())).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$6() {
        return "Partitions not offline after topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testMirroredTopicMarkedForDelete$7(KafkaBroker broker$3, UUID linkId$3) {
        return ((ClusterLinkFetcherManager)broker$3.clusterLinkManager().fetcherManager(linkId$3).get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testMirroredTopicMarkedForDelete$8() {
        return "Fetcher manager not empty after topic deletion";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testMirroredTopicMarkedForDelete$3(IndexedSeq partitions$1, UUID linkId$3, KafkaBroker broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$4(partitions$1, broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$7(broker, linkId$3)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkIntegrationTest.$anonfun$testMirroredTopicMarkedForDelete$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$5(ReplicaStatus.MirrorInfo mi) {
        ReplicaStatus.MirrorInfo.State state = mi.state();
        ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.PAUSED;
        return !(state != null ? !state.equals(state2) : state2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testPauseTopic$2(ClusterLinkIntegrationTest $this) {
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.numPartitions()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)partition -> {
            ClusterLinkTestHarness qual$6 = $this.destCluster();
            String x$17 = new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString();
            boolean x$19 = qual$6.replicaStatus$default$3();
            return Option$.MODULE$.apply(((ReplicaStatus)((IterableLike)qual$6.replicaStatus(x$17, partition, x$19).filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)x$28.isLeader()))).head()).mirrorInfo().orElse(null)).exists((Function1 & Serializable & scala.Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testPauseTopic$5(mi)));
        });
    }

    public static final /* synthetic */ String $anonfun$testPauseTopic$6() {
        return "Topic's partitions not paused";
    }

    private final Seq leaderOffsets$1() {
        return ((scala.collection.immutable.Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)partition -> {
            ClusterLinkTestHarness qual$1 = this.destCluster();
            String x$1 = new StringBuilder(0).append(this.clusterLinkPrefix()).append(this.topic()).toString();
            boolean x$3 = qual$1.replicaStatus$default$3();
            return ((ReplicaStatus)((IterableLike)qual$1.replicaStatus(x$1, partition, x$3).filter((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.isLeader()))).head()).logEndOffset();
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ int $anonfun$testPauseClusterLink$2(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopic($this.topic()).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$3(int newNumPartitions$1, int x$31) {
        return x$31 == newNumPartitions$1;
    }

    public static final /* synthetic */ String $anonfun$testPauseClusterLink$4(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig($this.topic()).get(LogConfig$.MODULE$.DeleteRetentionMsProp()).value();
    }

    public static final /* synthetic */ boolean $anonfun$testPauseClusterLink$5(String newDeleteRetentionMs$1, String x$32) {
        String string = x$32;
        return !(string != null ? !string.equals(newDeleteRetentionMs$1) : newDeleteRetentionMs$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$3(ClusterLinkIntegrationTest $this, int expectedLeaderEpoch$1) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= expectedLeaderEpoch$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$4() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$5(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$6(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$7(ReplicaStatus rs) {
        return rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$8(ReplicaStatus rs) {
        return !rs.isLeader() && rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$9(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$10(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$11(ClusterLinkIntegrationTest $this, ObjectRef rs4$1) {
        rs4$1.elem = $this.destCluster().replicaStatus($this.topic(), 0, true);
        return ((Seq)rs4$1.elem).size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testReplicaStatus$12() {
        return "Cluster link not removed from topic's partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$13(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaStatus$14(ReplicaStatus rs) {
        return !rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$1(ClusterLinkIntegrationTest $this, int expectedLeaderEpoch$2) {
        return $this.destCluster().leaderEpoch(new TopicPartition(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString(), 0)) >= expectedLeaderEpoch$2;
    }

    public static final /* synthetic */ String $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$2() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$3(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testLastFetchedOffsetStoppedMirrorTopicDescription$4(ReplicaStatus rs) {
        return rs.isLeader() && !rs.linkName().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testIntervalChangeForPeriodicTasks$1(ClusterLinkIntegrationTest $this) {
        return $this.destCluster().describeTopicConfig(new StringBuilder(0).append($this.clusterLinkPrefix()).append($this.topic()).toString()).get("delete.retention.ms").value().equals("80000000");
    }

    public static final /* synthetic */ String $anonfun$testIntervalChangeForPeriodicTasks$2() {
        return "Topic configs did not get propagated";
    }

    public static final /* synthetic */ boolean $anonfun$testMirrorFailoverWhenSourceIsUnavailable$1(ClusterLinkIntegrationTest $this, int expectedLeaderEpoch$3) {
        return $this.destCluster().leaderEpoch(new TopicPartition($this.topic(), 0)) >= expectedLeaderEpoch$3;
    }

    public static final /* synthetic */ String $anonfun$testMirrorFailoverWhenSourceIsUnavailable$2() {
        return "Destination leader epoch not updated";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkMetadataTopicCreation$1(ClusterLinkIntegrationTest $this) {
        boolean bl;
        try {
            TopicDescription desc = $this.destCluster().describeTopic("_confluent-link-metadata");
            if (!"_confluent-link-metadata".equals(desc.name())) {
                return false;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkMetadataTopicCreation$2() {
        return "Cluster link metadata topic not created";
    }

    public ClusterLinkIntegrationTest() {
        this.offsetToCommit = 10L;
        this.syncPeriod = 100L;
        this.consumerGroup = "testGroup";
    }

    public static final /* synthetic */ Object $anonfun$testCreateAndDeleteAndRecreateLink$6$adapted(Seq x$9) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testCreateAndDeleteAndRecreateLink$6(x$9));
    }

    public static final /* synthetic */ Object $anonfun$testDestinationClusterLinkQuotaWithBrokerRestart$3$adapted(int oldLeaderId$1, scala.collection.immutable.Set x$23) {
        return BoxesRunTime.boxToBoolean((boolean)x$23.contains((Object)BoxesRunTime.boxToInteger((int)oldLeaderId$1)));
    }

    public static final /* synthetic */ Object $anonfun$testPauseClusterLink$5$adapted(String newDeleteRetentionMs$1, String x$32) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testPauseClusterLink$5(newDeleteRetentionMs$1, x$32));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$1$adapted(ReplicaStatus x$33) {
        return BoxesRunTime.boxToBoolean((boolean)x$33.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$2$adapted(ReplicaStatus x$34) {
        return BoxesRunTime.boxToBoolean((boolean)x$34.isLeader());
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$5$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$5(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$6$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$6(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$7$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$7(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$8$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$8(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$9$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$9(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$10$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$10(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$13$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$13(rs));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaStatus$14$adapted(ReplicaStatus rs) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkIntegrationTest.$anonfun$testReplicaStatus$14(rs));
    }
}

