/*
 * Decompiled with CFR 0.152.
 */
package kafka.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.link.ClusterLinkTestHarness;
import kafka.link.ClusterLinkTestHarness$;
import kafka.link.FailureType;
import kafka.link.FailureType$AuthenticationFailure$;
import kafka.link.FailureType$AuthorizationFailure$;
import kafka.link.FailureType$CorruptConfigs$;
import kafka.link.FailureType$NetworkFailure$;
import kafka.link.FailureType$SourceTopicDelete$;
import kafka.link.FailureType$UndecodableConfigs$;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.ConfigType$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.SecureLinkConfigEncoder;
import kafka.server.link.TopicLinkMirror$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\tud\u0001\u0002\u0014(\u00011BQ!\r\u0001\u0005\u0002IBq\u0001\u000e\u0001C\u0002\u0013\u0005S\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u00199\u0005\u0001)A\u0005\u007f!9\u0001\n\u0001b\u0001\n\u0013I\u0005BB'\u0001A\u0003%!\nC\u0004O\u0001\t\u0007I\u0011B%\t\r=\u0003\u0001\u0015!\u0003K\u0011\u001d\u0001\u0006A1A\u0005\nECa!\u0016\u0001!\u0002\u0013\u0011\u0006\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0003X\u0011%)\u0007\u00011AA\u0002\u0013%a\rC\u0005m\u0001\u0001\u0007\t\u0011)Q\u00051\"IQ\u000e\u0001a\u0001\u0002\u0004%IA\u001c\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD\u0011\u0002\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B8\t\u000be\u0004A\u0011\t>\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003s\u0002A\u0011AA>\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAa\u0001\u0011\u0005\u00111\u0019\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!:\u0001\t\u0003\t9\u000fC\u0004\u0002r\u0002!\t!a=\t\u000f\u0005u\b\u0001\"\u0005\u0002\u0000\"I!1\u0005\u0001\u0012\u0002\u0013E!Q\u0005\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011y\u0004\u0001C\u0005\u0005\u0003BqA!\u001c\u0001\t\u0013\u0011iD\u0001\fDYV\u001cH/\u001a:MS:\\g)Y5mkJ,G+Z:u\u0015\tA\u0013&\u0001\u0003mS:\\'\"\u0001\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\f\t\u0003]=j\u0011aJ\u0005\u0003a\u001d\u0012!%\u00112tiJ\f7\r^\"mkN$XM\u001d'j].Le\u000e^3he\u0006$\u0018n\u001c8UKN$\u0018A\u0002\u001fj]&$h\bF\u00014!\tq\u0003!A\tsKBd\u0017nY1uS>tg)Y2u_J,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0006'\"|'\u000f^\u0001\u0013e\u0016\u0004H.[2bi&|gNR1di>\u0014\b%A\u0007d_:\u001cX/\\3s\u000fJ|W\u000f]\u000b\u0002\u007fA\u0011\u0001)R\u0007\u0002\u0003*\u0011!iQ\u0001\u0005Y\u0006twMC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%AB*ue&tw-\u0001\bd_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0011\u0002\rMLhnY't+\u0005Q\u0005CA\u001cL\u0013\ta\u0005H\u0001\u0003M_:<\u0017aB:z]\u000el5\u000fI\u0001\be\u0016$(/_'t\u0003!\u0011X\r\u001e:z\u001bN\u0004\u0013A\u00038v[J+7m\u001c:egV\t!\u000b\u0005\u00028'&\u0011A\u000b\u000f\u0002\u0004\u0013:$\u0018a\u00038v[J+7m\u001c:eg\u0002\n\u0011\u0002Z3ti\u0006#W.\u001b8\u0016\u0003a\u0003\"!W2\u000e\u0003iS!a\u0017/\u0002\u000b\u0005$W.\u001b8\u000b\u0005us\u0016aB2mS\u0016tGo\u001d\u0006\u0003U}S!\u0001Y1\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0017aA8sO&\u0011AM\u0017\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u00035!Wm\u001d;BI6Lgn\u0018\u0013fcR\u0011qM\u001b\t\u0003o!L!!\u001b\u001d\u0003\tUs\u0017\u000e\u001e\u0005\bW6\t\t\u00111\u0001Y\u0003\rAH%M\u0001\u000bI\u0016\u001cH/\u00113nS:\u0004\u0013A\u00027j].LE-F\u0001p!\t\u00018/D\u0001r\u0015\t\u00118)\u0001\u0003vi&d\u0017B\u0001;r\u0005\u0011)V+\u0013#\u0002\u00151Lgn[%e?\u0012*\u0017\u000f\u0006\u0002ho\"91\u000eEA\u0001\u0002\u0004y\u0017a\u00027j].LE\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003OnDQ\u0001 \nA\u0002u\f\u0001\u0002^3ti&sgm\u001c\t\u0004}\u0006-Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0004CBL'\u0002BA\u0003\u0003\u000f\tqA[;qSR,'OC\u0002\u0002\n\u0005\fQA[;oSRL1!!\u0004\u0000\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\n\u0002\u0012A\u0019a0a\u0005\n\u0007\u0005UqP\u0001\u0006CK\u001a|'/Z#bG\"\fQ\u0004^3tiN{WO]2f\u00072,8\u000f^3s\u001d>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0004O\u0006m\u0001bBA\u000f'\u0001\u0007\u0011qD\u0001\u0007cV|'/^7\u0011\t\u0005\u0005\u0012q\u0006\b\u0005\u0003G\tY\u0003E\u0002\u0002&aj!!a\n\u000b\u0007\u0005%2&\u0001\u0004=e>|GOP\u0005\u0004\u0003[A\u0014A\u0002)sK\u0012,g-C\u0002G\u0003cQ1!!\f9Q\u001d\u0019\u0012QGA#\u0003\u000f\u0002B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\ty$a\u0001\u0002\rA\f'/Y7t\u0013\u0011\t\u0019%!\u000f\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\tI%!\u0014\"\u0005\u0005-\u0013A\u0001>lC\t\ty%A\u0003le\u00064G\u000fK\u0004\u0014\u0003'\nY&!\u0018\u0011\t\u0005U\u0013qK\u0007\u0003\u0003{IA!!\u0017\u0002>\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003?\n\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003e!Xm\u001d;BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\u0007\u001d\f)\u0007C\u0004\u0002\u001eQ\u0001\r!a\b)\u000fQ\t)$!\u0012\u0002j1\u0012\u0011\u0011\n\u0015\b)\u0005M\u00131LA/\u0003a!Xm\u001d;BkRDwN]5{CRLwN\u001c$bS2,(/\u001a\u000b\u0004O\u0006E\u0004bBA\u000f+\u0001\u0007\u0011q\u0004\u0015\b+\u0005U\u0012QIA;Y\t\tI\u0005K\u0004\u0016\u0003'\nY&!\u0018\u0002%Q,7\u000f^\"peJ,\b\u000f^\"p]\u001aLwm\u001d\u000b\u0004O\u0006u\u0004bBA\u000f-\u0001\u0007\u0011q\u0004\u0015\b-\u0005U\u0012QIAAY\t\tI\u0005K\u0004\u0017\u0003'\nY&!\u0018\u0002-Q,7\u000f^+oI\u0016\u001cw\u000eZ1cY\u0016\u001cuN\u001c4jON$2aZAE\u0011\u001d\tib\u0006a\u0001\u0003?AsaFA\u001b\u0003\u000b\ni\t\f\u0002\u0002J!:q#a\u0015\u0002\\\u0005u\u0013!\u0006;fgR\u001cv.\u001e:dKR{\u0007/[2EK2,G/\u001a\u000b\u0004O\u0006U\u0005bBA\u000f1\u0001\u0007\u0011q\u0004\u0015\b1\u0005U\u0012QIAMY\u0011\tI%!\u0014)\u000fa\t\u0019&a\u0017\u0002^\u0005iC/Z:u'>,(oY3U_BL7MU3de\u0016\fG/\u001a#fi\u0016\u001cG/[8o+NLgn\u001a+pa&\u001c\u0017\nZ:\u0015\u0007\u001d\f\t\u000bC\u0004\u0002\u001ee\u0001\r!a\b)\u000fe\t)$!\u0012\u0002&2\u0012\u0011\u0011\n\u0015\b3\u0005M\u00131LA/\u0003]!Xm\u001d;T_V\u00148-\u001a'fC\u0012,'o\u00115b]\u001e,7\u000fF\u0002h\u0003[Cq!!\b\u001b\u0001\u0004\ty\u0002K\u0004\u001b\u0003k\t)%!--\u0005\u0005%\u0003f\u0002\u000e\u0002T\u0005m\u0013QL\u00012i\u0016\u001cH/\u00168dY\u0016\fgnU8ve\u000e,G*Z1eKJ,E.Z2uS>tw+\u001b;i\t\u0016\u001cH/\u00129pG\"\f\u0005.Z1e)\r9\u0017\u0011\u0018\u0005\b\u0003;Y\u0002\u0019AA\u0010Q\u001dY\u0012QGA#\u0003{c#!!\u0013)\u000fm\t\u0019&a\u0017\u0002^\u0005)B/Z:u\t\u0016\u001cH\u000fT3bI\u0016\u00148\t[1oO\u0016\u001cHcA4\u0002F\"9\u0011Q\u0004\u000fA\u0002\u0005}\u0001f\u0002\u000f\u00026\u0005\u0015\u0013\u0011\u001a\u0017\u0005\u0003\u0013\ni\u0005K\u0004\u001d\u0003'\nY&!\u0018\u0002;Q,7\u000f\u001e#fgR4u\u000e\u001c7po\u0016\u0014\u0018\t[3bI>3G*Z1eKJ$2aZAi\u0011\u001d\ti\"\ba\u0001\u0003?As!HA\u001b\u0003\u000b\n)\u000e\f\u0002\u0002J!:Q$a\u0015\u0002\\\u0005u\u0013A\f;fgR$Um\u001d;SKBd\u0017nY1uS>tgj\u001c;J[B\f7\r^3e\u0005f\u001cv.\u001e:dK\u001a\u000b\u0017\u000e\\;sKN$2aZAo\u0011\u001d\tiB\ba\u0001\u0003?AsAHA\u001b\u0003\u000b\n\t\u000f\f\u0003\u0002J\u00055\u0003f\u0002\u0010\u0002T\u0005m\u0013QL\u0001Ci\u0016\u001cH\u000fR3tiJ+\u0007\u000f\\5dCRLwN\u001c(pi&k\u0007/Y2uK\u0012\u0014\u0015pU8ve\u000e,g)Y5mkJ,7oV5uQ>cG-T3tg\u0006<WMR8s[\u0006$HcA4\u0002j\"9\u0011QD\u0010A\u0002\u0005}\u0001fB\u0010\u00026\u0005\u0015\u0013Q\u001e\u0017\u0005\u0003\u0013\ni\u0005K\u0004 \u0003'\nY&!\u0018\u00029Q,7\u000f\u001e#fgRLg.\u0019;j_:D\u0015n\u001a5XCR,'/\\1sWR\u0019q-!>\t\u000f\u0005u\u0001\u00051\u0001\u0002 !:\u0001%!\u000e\u0002F\u0005eHFAA%Q\u001d\u0001\u00131KA.\u0003;\n\u0001D^3sS\u001aLh)Y5mkJ,\u0017I\u001c3SK\u000e|g/\u001a:z)%9'\u0011\u0001B\u0006\u0005+\u0011I\u0002C\u0004\u0003\u0004\u0005\u0002\rA!\u0002\u0002\u0017\u0019\f\u0017\u000e\\;sKRK\b/\u001a\t\u0004]\t\u001d\u0011b\u0001B\u0005O\tYa)Y5mkJ,G+\u001f9f\u0011\u001d\u0011i!\ta\u0001\u0005\u001f\tAb\u001d;beR4\u0015-\u001b7ve\u0016\u0004Ba\u000eB\tO&\u0019!1\u0003\u001d\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004b\u0002B\fC\u0001\u0007!qB\u0001\fgR|\u0007OR1jYV\u0014X\rC\u0005\u0003\u001c\u0005\u0002\n\u00111\u0001\u0003\u001e\u0005)c/\u001a:jMf\fe/Y5mC\nLG.\u001b;z\u001b\u0016$(/[2BMR,'OU3d_Z,'/\u001f\t\u0004o\t}\u0011b\u0001B\u0011q\t9!i\\8mK\u0006t\u0017A\t<fe&4\u0017PR1jYV\u0014X-\u00118e%\u0016\u001cwN^3ss\u0012\"WMZ1vYR$C'\u0006\u0002\u0003()\"!Q\u0004B\u0015W\t\u0011Y\u0003\u0005\u0003\u0003.\t]RB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001bq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te\"q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD<bSR4uN\u001d*fG>4XM]=\u0015\u0003\u001d\f!\"Y2m\u0005&tG-\u001b8h)\u0019\u0011\u0019Ea\u0015\u0003dA!!Q\tB(\u001b\t\u00119E\u0003\u0003\u0003J\t-\u0013aA1dY*\u0019!Q\n0\u0002\r\r|W.\\8o\u0013\u0011\u0011\tFa\u0012\u0003\u0015\u0005\u001bGNQ5oI&tw\rC\u0004\u0003V\u0011\u0002\rAa\u0016\u0002\u0019I,7o\\;sG\u0016$\u0016\u0010]3\u0011\t\te#qL\u0007\u0003\u00057RAA!\u0018\u0003L\u0005A!/Z:pkJ\u001cW-\u0003\u0003\u0003b\tm#\u0001\u0004*fg>,(oY3UsB,\u0007b\u0002B3I\u0001\u0007!qM\u0001\u000fa\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\u0011)E!\u001b\n\t\t-$q\t\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0017aC1eI2Kgn[!dYNDs\u0001\u0001B9\u0005o\u0012I\bE\u0002\u007f\u0005gJ1A!\u001e\u0000\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005w\n1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u0002")
public class ClusterLinkFailureTest
extends AbstractClusterLinkIntegrationTest {
    private final short replicationFactor = (short)3;
    private final String consumerGroup;
    private final long syncMs;
    private final long retryMs;
    private final int numRecords;
    private ConfluentAdmin destAdmin;
    private UUID linkId;

    @Override
    public short replicationFactor() {
        return this.replicationFactor;
    }

    private String consumerGroup() {
        return this.consumerGroup;
    }

    private long syncMs() {
        return this.syncMs;
    }

    private long retryMs() {
        return this.retryMs;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    private void destAdmin_$eq(ConfluentAdmin x$1) {
        this.destAdmin = x$1;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private void linkId_$eq(UUID x$1) {
        this.linkId = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo) && this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$1 = SecurityProtocol.PLAINTEXT;
            int x$2 = 0;
            int x$3 = 3;
            Option<SecurityProtocol> x$4 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$1, x$4, x$2, x$3));
            SecurityProtocol x$5 = SecurityProtocol.PLAINTEXT;
            int x$6 = 100;
            int x$7 = 3;
            Option<SecurityProtocol> x$8 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$5, x$8, x$6, x$7));
        } else if (this.sourceCluster() == null && this.destCluster() == null) {
            SecurityProtocol x$9 = SecurityProtocol.SASL_SSL;
            int x$10 = 0;
            int x$11 = 3;
            Option<SecurityProtocol> x$12 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.sourceCluster_$eq(new ClusterLinkTestHarness(x$9, x$12, x$10, x$11));
            SecurityProtocol x$13 = SecurityProtocol.SASL_PLAINTEXT;
            int x$14 = 100;
            int x$15 = 3;
            Option<SecurityProtocol> x$16 = ClusterLinkTestHarness$.MODULE$.$lessinit$greater$default$2();
            this.destCluster_$eq(new ClusterLinkTestHarness(x$13, x$16, x$14, x$15));
            this.sourceCluster().serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
            this.sourceCluster().serverConfig().setProperty("super.users", new StringBuilder(11).append("User:").append(JaasTestUtils$.MODULE$.KafkaScramAdmin()).append(";User:").append(JaasTestUtils$.MODULE$.KafkaScramUser2()).toString());
        }
        super.setUp(testInfo);
        if (!this.isKraftTest()) {
            this.addLinkAcls();
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        Properties x$17 = qual$1.createConfluentAdminClient$default$1();
        this.destAdmin_$eq(qual$1.createConfluentAdminClient(x$17));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSourceClusterNotAvailable(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.verifyFailureAndRecovery(FailureType$NetworkFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sourceCluster().killAllBrokers(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.restartCluster(this.sourceCluster(), this.restartCluster$default$2()), true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAuthenticationFailure(String quorum) {
        ClusterLinkTestHarness connectionTarget = this.useSourceInitiatedLink() ? this.destCluster() : this.sourceCluster();
        ObjectRef newJaasConfig = ObjectRef.create(null);
        this.verifyFailureAndRecovery(FailureType$AuthenticationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            newJaasConfig$1.elem = this.updateCredentials(connectionTarget);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sasl.jaas.config"), (Object)((String)newJaasConfig$1.elem))})))), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAuthorizationFailure(String quorum) {
        AclBinding denyTopicAcl = this.aclBinding(ResourceType.TOPIC, AclPermissionType.DENY);
        this.verifyFailureAndRecovery(FailureType$AuthorizationFailure$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sourceCluster().addAcls((Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sourceCluster().deleteAcls((Seq<AclBinding>)new .colon.colon((Object)denyTopicAcl, (List)Nil$.MODULE$)), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testCorruptConfigs(String quorum) {
        ConnectionMode.Inbound$ destConnectionMode = this.useSourceInitiatedLink() ? ConnectionMode.Inbound$.MODULE$ : ConnectionMode.Outbound$.MODULE$;
        this.verifyFailureAndRecovery(FailureType$CorruptConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.destCluster().updateZkLinkConfig(this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), "invalid"), (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkFailureTest.$anonfun$testCorruptConfigs$2(this, (Product)destConnectionMode)), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testUndecodableConfigs(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Properties linkConfigs = new Properties();
        this.verifyFailureAndRecovery(FailureType$UndecodableConfigs$.MODULE$, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.makeConfigUndecodable$1(linkConfigs), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.reconfigureLink$1(linkConfigs), this.verifyFailureAndRecovery$default$4());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSourceTopicDelete(String quorum) {
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup()));
        int numRecords = 10;
        this.produceToSourceCluster(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.consumerGroup());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        this.sourceCluster().deleteTopic(this.topic(), true);
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.waitForFailure(this.destAdmin(), FailureType$SourceTopicDelete$.MODULE$);
        Properties topicProps = new Properties();
        topicProps.put("max.message.bytes", "100000");
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = 1;
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, topicProps, x$5);
        this.produceToSourceCluster(numRecords);
        this.truncate(numRecords);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.verifyOffsetMigration(this.topic(), 0, 5L, this.consumerGroup());
        Assertions.assertEquals((int)this.numPartitions(), (int)this.destCluster().describeTopic(this.topic()).partitions().size());
        Option maxMessageSize = Option$.MODULE$.apply((Object)this.destCluster().describeTopicConfig(this.topic()).get("max.message.bytes"));
        Assertions.assertTrue((boolean)maxMessageSize.nonEmpty());
        Assertions.assertNotEquals((Object)"100000", (Object)((ConfigEntry)maxMessageSize.get()).value());
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.FAILED);
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        this.waitForFailure(this.destAdmin(), FailureType$SourceTopicDelete$.MODULE$);
        String x$6 = this.topic();
        boolean x$7 = false;
        Seq<KafkaBroker> x$8 = this.verifyMirror$default$2();
        this.verifyMirror(x$6, x$8, x$7);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testSourceTopicRecreateDetectionUsingTopicIds(String quorum) {
        this.numPartitions_$eq(1);
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(300000L, 300000L, this.consumerGroup()));
        this.produceToSourceCluster(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.sourceCluster().changeLeader(tp);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkFailureTest.$anonfun$testSourceTopicRecreateDetectionUsingTopicIds$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkFailureTest.$anonfun$testSourceTopicRecreateDetectionUsingTopicIds$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.produceToSourceCluster(5);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.sourceCluster().deleteTopic(this.topic(), true);
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.produceToSourceCluster(20);
        this.truncate(20);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.waitForFailure(this.destAdmin(), FailureType$SourceTopicDelete$.MODULE$);
        this.destCluster().killAllBrokers();
        this.destAdmin_$eq((ConfluentAdmin)this.restartCluster(this.destCluster(), !this.useSourceInitiatedLink()).get());
        String x$6 = this.topic();
        boolean x$7 = false;
        Seq<KafkaBroker> x$8 = this.verifyMirror$default$2();
        this.verifyMirror(x$6, x$8, x$7);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testSourceLeaderChanges(String quorum) {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.verifyMirrorWithSourceEpochChanges(false);
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        this.verifyLinkedLeaderChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testUncleanSourceLeaderElectionWithDestEpochAhead(String quorum) {
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        this.verifyMirrorWithSourceEpochChanges(true);
        this.verifyLinkedLeaderChangeMetrics();
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestLeaderChanges(String quorum) {
        void var18_18;
        void var16_16;
        if (quorum.equals("kraft")) {
            Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        }
        this.numPartitions_$eq(this.sourceCluster().brokerCount());
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$5);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int leader1 = tuple2._1$mcI$sp();
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaBroker>)((Seq)this.destCluster().brokers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1$adapted(this, (int)var16_16, arg_0))), this.waitForMirror$default$2());
        Tuple2<Object, Object> tuple22 = this.destCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int leader2 = tuple22._1$mcI$sp();
        this.destCluster().startBroker((int)var16_16);
        this.produceToSourceCluster(this.numPartitions());
        this.waitForMirror((Seq<KafkaBroker>)((Seq)this.destCluster().brokers().filter(arg_0 -> ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2$adapted(this, (int)var18_18, arg_0))), this.waitForMirror$default$2());
        this.destCluster().startBroker((int)var18_18);
        this.produceToSourceCluster(this.numPartitions());
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDestFollowerAheadOfLeader(String quorum) {
        void var22_22;
        void var20_20;
        void var17_17;
        void var16_16;
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        int x$3 = 2;
        Properties x$4 = qual$1.createTopic$default$4();
        ListenerName x$52 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, x$4, x$52);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = 2;
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$10 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$10);
        Tuple2<Object, Object> tuple2 = this.destCluster().shutdownLeader(tp);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int destBroker1 = tuple2._1$mcI$sp();
        int destLeaderEpoch1 = tuple2._2$mcI$sp();
        int destBroker2 = TestUtils$.MODULE$.awaitLeaderAndEpochChange(this.destCluster().aliveServers(), tp, (int)var16_16, (int)var17_17, TestUtils$.MODULE$.awaitLeaderAndEpochChange$default$5());
        this.produceToSourceCluster(100);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> {
            this.sourceCluster().bounceLeader(tp);
            this.produceToSourceCluster(100);
        });
        Tuple2<Object, Object> tuple22 = this.sourceCluster().shutdownLeader(tp);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        int sourceBroker1 = tuple22._1$mcI$sp();
        this.produceToSourceCluster(100);
        this.waitForMirror((Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().serverWithBrokerId(destBroker2), (List)Nil$.MODULE$), this.waitForMirror$default$2());
        this.verifyBasicLinkMetrics(this.linkId(), this.verifyBasicLinkMetrics$default$2(), this.verifyBasicLinkMetrics$default$3());
        Tuple2<Object, Object> tuple23 = this.destCluster().shutdownLeader(tp);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        int destLeaderEpoch2 = tuple23._2$mcI$sp();
        this.sourceCluster().shutdownLeader(tp);
        this.truncate(100);
        this.sourceCluster().startBroker((int)var20_20);
        this.destCluster().startBroker((int)var16_16);
        int newLeader = TestUtils$.MODULE$.awaitLeaderAndEpochChange(this.destCluster().aliveServers(), tp, destBroker2, (int)var22_22, TestUtils$.MODULE$.awaitLeaderAndEpochChange$default$5());
        Assertions.assertEquals((int)var16_16, (int)newLeader);
        this.destCluster().startBroker(destBroker2);
        this.produceToSourceCluster(100);
        this.verifyMirror(this.topic(), this.verifyMirror$default$2(), this.verifyMirror$default$3());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestReplicationNotImpactedBySourceFailures(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(new Properties(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        boolean x$2 = false;
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$3, x$2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDestReplicationNotImpactedBySourceFailuresWithOldMessageFormat(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createLinkAndMirrorWithPartialReplicationAndShutdownSource(topicConfig, this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$2(), this.createLinkAndMirrorWithPartialReplicationAndShutdownSource$default$3());
        String x$1 = this.topic();
        boolean x$2 = false;
        Seq<KafkaBroker> x$3 = this.verifyMirror$default$2();
        this.verifyMirror(x$1, x$3, x$2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDestinationHighWatermark(String quorum) {
        Assumptions.assumeFalse((boolean)this.useSourceInitiatedLink());
        this.numPartitions_$eq(1);
        TopicPartition tp = (TopicPartition)this.partitions(this.partitions$default$1()).head();
        Properties props = new Properties();
        ClusterLinkTestHarness qual$1 = this.sourceCluster();
        String x$1 = this.topic();
        int x$2 = this.numPartitions();
        short x$3 = this.replicationFactor();
        ListenerName x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(x$1, x$2, x$3, props, x$5);
        this.linkId_$eq(this.createClusterLink(this.linkName(), this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.topic();
        short x$7 = this.replicationFactor();
        String x$8 = this.linkName();
        Map<String, String> x$9 = qual$2.linkTopic$default$4();
        String x$102 = qual$2.linkTopic$default$5();
        qual$2.linkTopic(x$6, x$7, x$8, x$9, x$102);
        LongRef startOffset = LongRef.create((long)0L);
        TestUtils$.MODULE$.waitUntilLeaderIsKnown(this.destCluster().brokers(), tp, TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
        Buffer destReplicaManagers = (Buffer)((TraversableLike)this.destCluster().brokers().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.replicaManager(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$9(tp, x$11)));
        ReplicaManager sourceReplicaManager = this.sourceCluster().partitionLeader(tp).replicaManager();
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        destReplicaManagers.foreach((Function1 & Serializable & scala.Serializable)replicaManager -> {
            this.verifyLog$1(replicaManager, this.verifyLog$default$2$1(), tp, startOffset);
            return BoxedUnit.UNIT;
        });
        startOffset.elem = 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable & scala.Serializable)x$12 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$11(x$12);
            return BoxedUnit.UNIT;
        });
        this.produceToSourceCluster(100);
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        destReplicaManagers.foreach((Function1 & Serializable & scala.Serializable)replicaManager -> {
            this.verifyLog$1(replicaManager, this.verifyLog$default$2$1(), tp, startOffset);
            return BoxedUnit.UNIT;
        });
        int follower = ((ReplicaManager)((IterableLike)destReplicaManagers.filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$13(tp, x$13)))).head()).config().brokerId();
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.produceToSourceCluster(100);
        long x$112 = this.producedRecords().size() - 100;
        ReplicaManager x$122 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$122, x$112, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.produceToSourceCluster(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset() - 50L;
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable & scala.Serializable)x$14 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$15(x$14);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))));
        startOffset.elem -= 50L;
        long x$132 = startOffset.elem;
        ReplicaManager x$142 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$142, x$132, tp, startOffset);
        startOffset.elem += 50L;
        this.destCluster().shutdownBroker(follower);
        this.destCluster().startBroker(follower);
        this.produceToSourceCluster(100);
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
        this.destCluster().serverWithBrokerId(follower).replicaManager().replicaFetcherManager().closeAllFetchers();
        this.produceToSourceCluster(100);
        startOffset.elem = ((AbstractLog)sourceReplicaManager.getLog(tp).get()).logEndOffset();
        sourceReplicaManager.deleteRecords(15000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)startOffset.elem))})), (Function1 & Serializable & scala.Serializable)x$15 -> {
            ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$16(x$15);
            return BoxedUnit.UNIT;
        });
        this.verifyLog$1(sourceReplicaManager, this.verifyLog$default$2$1(), tp, startOffset);
        this.destCluster().alterClusterLink(this.linkName(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"false")}))), (Seq<KafkaBroker>)new .colon.colon((Object)this.destCluster().partitionLeader(tp), (List)Nil$.MODULE$));
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.produceToSourceCluster(100);
        long x$152 = startOffset.elem;
        ReplicaManager x$16 = this.verifyLog$default$1$1(tp);
        this.verifyLog$1(x$16, x$152, tp, startOffset);
        this.destCluster().shutdownBroker(follower);
        this.produceToSourceCluster(100);
        this.verifyLog$1(this.verifyLog$default$1$1(tp), this.verifyLog$default$2$1(), tp, startOffset);
        this.destCluster().startBroker(follower);
        this.verifyLog$1(this.destCluster().serverWithBrokerId(follower).replicaManager(), this.verifyLog$default$2$1(), tp, startOffset);
    }

    public void verifyFailureAndRecovery(FailureType failureType, Function0<BoxedUnit> startFailure, Function0<BoxedUnit> stopFailure, boolean verifyAvailabilityMetricAfterRecovery) {
        this.linkId_$eq(this.setupLinkAndMirrorForFailureTest(this.syncMs(), this.retryMs(), this.consumerGroup()));
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 5L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        startFailure.apply$mcV$sp();
        this.waitForFailure(this.destAdmin(), failureType);
        stopFailure.apply$mcV$sp();
        this.waitForRecovery();
        this.produceToSourceCluster(this.numRecords());
        this.commitOffsets(this.sourceCluster(), this.topic(), 0, 10L, this.consumerGroup());
        this.waitForMirror(this.waitForMirror$default$1(), this.waitForMirror$default$2());
        this.verifyOffsetMigration(this.topic(), 0, 10L, this.consumerGroup());
        if (verifyAvailabilityMetricAfterRecovery) {
            double unavailabilityCount = this.unavailabilityCountMetricValue(this.linkName(), this.unavailabilityCountMetricValue$default$2());
            Thread.sleep(5L * this.retryMs());
            Assertions.assertEquals((double)unavailabilityCount, (double)this.unavailabilityCountMetricValue(this.linkName(), this.unavailabilityCountMetricValue$default$2()), (double)0.0);
        }
        ClusterLinkTestHarness qual$1 = this.destCluster();
        String x$1 = this.topic();
        String x$2 = this.linkName();
        boolean x$3 = false;
        boolean x$4 = qual$1.unlinkTopic$default$3();
        boolean x$5 = qual$1.unlinkTopic$default$5();
        qual$1.unlinkTopic(x$1, x$2, x$4, x$3, x$5);
        ClusterLinkTestHarness qual$2 = this.destCluster();
        String x$6 = this.linkName();
        boolean x$7 = qual$2.deleteClusterLink$default$2();
        Buffer<KafkaBroker> x$8 = qual$2.deleteClusterLink$default$3();
        qual$2.deleteClusterLink(x$6, x$7, x$8);
    }

    public boolean verifyFailureAndRecovery$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void waitForRecovery() {
        void var3_14;
        Tuple2 tuple2;
        void var1_6;
        Tuple2 tuple22;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            ClusterLinkListing computeUntilTrue_result;
            if ((computeUntilTrue_result = this.linkInfo(this.destAdmin())).available()) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        ClusterLinkListing link = (ClusterLinkListing)tuple22._1();
        Assertions.assertTrue((boolean)var1_6.available(), (String)"Link not available");
        this.waitUntilMirrorDescriptionState(MirrorTopicDescription.State.ACTIVE);
        Set activePartitionState = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaStatus.MirrorInfo.State[]{ReplicaStatus.MirrorInfo.State.ACTIVE}));
        long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Set computeUntilTrue_result;
            Set set;
            if (ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activePartitionState, set = (computeUntilTrue_result = this.mirrorPartitionStates(this.destAdmin())))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set actualStates = (Set)tuple2._1();
        Assertions.assertEquals((Object)activePartitionState, (Object)var3_14);
        this.waitForLinkCountMetric("destination", "active", this.destCluster());
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "mirror-topic-count", (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)TopicLinkMirror$.MODULE$.name())}))), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        Assertions.assertEquals((double)this.numPartitions(), (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "mirror-partition-count", this.totalKafkaMetricValue$default$3(), this.totalKafkaMetricValue$default$4(), this.totalKafkaMetricValue$default$5()));
        this.kafkaMetricMaxValue(this.destCluster().aliveServers(), "broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), (Option<String>)new Some((Object)this.linkName()), (Map<String, String>)Map$.MODULE$.empty(), false);
    }

    private AclBinding aclBinding(ResourceType resourceType, AclPermissionType permissionType) {
        ResourcePattern resource = new ResourcePattern(resourceType, "*", PatternType.LITERAL);
        AccessControlEntry ace = new AccessControlEntry(new StringBuilder(5).append("User:").append(this.linkUserName(this.linkName())).toString(), "*", AclOperation.ALL, permissionType);
        return new AclBinding(resource, ace);
    }

    private void addLinkAcls() {
        this.sourceCluster().addAcls((Seq<AclBinding>)new .colon.colon((Object)this.aclBinding(ResourceType.TOPIC, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.CLUSTER, AclPermissionType.ALLOW), (List)new .colon.colon((Object)this.aclBinding(ResourceType.GROUP, AclPermissionType.ALLOW), (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ void $anonfun$testCorruptConfigs$2(ClusterLinkFailureTest $this, Product destConnectionMode$1) {
        $this.destCluster().updateZkLinkConfig($this.linkId(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ((ConnectionMode)destConnectionMode$1).name());
    }

    private final void makeConfigUndecodable$1(Properties linkConfigs$1) {
        Properties props = ((KafkaServer)this.destCluster().servers().head()).zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), this.linkId().toString());
        Properties decodedProps = ((KafkaBroker)this.destCluster().brokers().head()).clusterLinkManager().configEncoder().decode(props);
        linkConfigs$1.putAll((java.util.Map<?, ?>)decodedProps);
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        brokerProps.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "bad-secret");
        Properties newProps = new SecureLinkConfigEncoder(KafkaConfig$.MODULE$.fromProps(brokerProps)).encode(decodedProps);
        new AdminZkClient(((KafkaServer)this.destCluster().servers().head()).zkClient()).changeClusterLinkConfig(this.linkId(), newProps);
    }

    public static final /* synthetic */ boolean $anonfun$testUndecodableConfigs$2(Tuple2 x$1) {
        Object object = x$1._1();
        String string = ClusterLinkConfig$.MODULE$.AvailabilityCheckMsProp();
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final void reconfigureLink$1(Properties linkConfigs$1) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkName());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.destAdmin().describeConfigs(Collections.singleton(resource)).all(), InvalidConfigurationException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.alterClusterLink(this.linkName(), (Map<String, String>)((MapLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(linkConfigs$1).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testUndecodableConfigs$2(x$1)))));
        this.alterClusterLink(this.linkName(), (Map<String, String>)((Map)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(linkConfigs$1).asScala()));
    }

    public static final /* synthetic */ boolean $anonfun$testSourceTopicRecreateDetectionUsingTopicIds$1(ClusterLinkFailureTest $this, TopicPartition tp$1) {
        return $this.destCluster().leaderEpoch(tp$1) > 0;
    }

    public static final /* synthetic */ String $anonfun$testSourceTopicRecreateDetectionUsingTopicIds$2() {
        return "Destination epoch not bumped";
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$1(ClusterLinkFailureTest $this, int leader1$1, KafkaBroker x$2) {
        KafkaBroker kafkaBroker = x$2;
        KafkaBroker kafkaBroker2 = $this.destCluster().serverWithBrokerId(leader1$1);
        return kafkaBroker == null ? kafkaBroker2 != null : !kafkaBroker.equals(kafkaBroker2);
    }

    public static final /* synthetic */ boolean $anonfun$testDestLeaderChanges$2(ClusterLinkFailureTest $this, int leader2$1, KafkaBroker x$3) {
        KafkaBroker kafkaBroker = x$3;
        KafkaBroker kafkaBroker2 = $this.destCluster().serverWithBrokerId(leader2$1);
        return kafkaBroker == null ? kafkaBroker2 != null : !kafkaBroker.equals(kafkaBroker2);
    }

    private static final String logDesc$1(ReplicaManager replicaManager$1, TopicPartition tp$3, AbstractLog log$1, LongRef startOffset$1, int endOffset$1, long highWatermark$1) {
        return new StringBuilder(67).append("isLeader=").append(replicaManager$1.onlinePartition(tp$3).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isLeader()))).append(" ").append("actual (start=").append(log$1.logStartOffset()).append(", end=").append(log$1.logEndOffset()).append(", hwm=").append(log$1.highWatermark()).append(") ").append("expected (start=").append(startOffset$1.elem).append(", end=").append(endOffset$1).append(", hwm=").append(highWatermark$1).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$3(LongRef startOffset$1, long x$7) {
        return x$7 == startOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$5(int endOffset$1, long x$8) {
        return x$8 == (long)endOffset$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$7(long highWatermark$1, long x$9) {
        return x$9 == highWatermark$1;
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyLog$1(ReplicaManager replicaManager, long highWatermark, TopicPartition tp$3, LongRef startOffset$1) {
        void var12_27;
        Tuple2 tuple2;
        void var10_20;
        Tuple2 tuple22;
        void var8_13;
        Tuple2 tuple23;
        AbstractLog log = (AbstractLog)replicaManager.getLog(tp$3).get();
        int endOffset = this.producedRecords().size();
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            long l3 = log.logStartOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l3);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$3(startOffset$1, l3)) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        long logStartOffset = tuple23._1$mcJ$sp();
        Assertions.assertEquals((long)startOffset$1.elem, (long)var8_13, (String)new StringBuilder(29).append("Unexpected log start offset: ").append(ClusterLinkFailureTest.logDesc$1(replicaManager, tp$3, log, startOffset$1, endOffset, highWatermark)).toString());
        long l4 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l5 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            long l6 = log.logEndOffset();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l6);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$5(endOffset, l6)) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long logEndOffset = tuple22._1$mcJ$sp();
        Assertions.assertEquals((long)endOffset, (long)var10_20, (String)new StringBuilder(27).append("Unexpected log end offset: ").append(ClusterLinkFailureTest.logDesc$1(replicaManager, tp$3, log, startOffset$1, endOffset, highWatermark)).toString());
        long l7 = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l8 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime3 = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            long l9 = log.highWatermark();
            Long computeUntilTrue_result = BoxesRunTime.boxToLong((long)l9);
            if (ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$7(highWatermark, l9)) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime3 + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long logHighWatermark = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)highWatermark, (long)var12_27, (String)new StringBuilder(27).append("Unexpected high watermark: ").append(ClusterLinkFailureTest.logDesc$1(replicaManager, tp$3, log, startOffset$1, endOffset, highWatermark)).toString());
    }

    private final ReplicaManager verifyLog$default$1$1(TopicPartition tp$3) {
        return this.destCluster().partitionLeader(tp$3).replicaManager();
    }

    private final long verifyLog$default$2$1() {
        return this.producedRecords().size();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$9(TopicPartition tp$3, ReplicaManager x$11) {
        return x$11.getLog(tp$3).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$11(Map x$12) {
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$14(Partition p) {
        return !p.isLeader();
    }

    public static final /* synthetic */ boolean $anonfun$testDestinationHighWatermark$13(TopicPartition tp$3, ReplicaManager x$13) {
        return x$13.onlinePartition(tp$3).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestinationHighWatermark$14(p)));
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$15(Map x$14) {
    }

    public static final /* synthetic */ void $anonfun$testDestinationHighWatermark$16(Map x$15) {
    }

    public static final /* synthetic */ boolean $anonfun$waitForRecovery$4(Set activePartitionState$1, Set x$17) {
        Set set = x$17;
        return !(set != null ? !set.equals(activePartitionState$1) : activePartitionState$1 != null);
    }

    public ClusterLinkFailureTest() {
        this.consumerGroup = "testGroup";
        this.syncMs = 100L;
        this.retryMs = 1000L;
        this.numRecords = 20;
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$1$adapted(ClusterLinkFailureTest $this, int leader1$1, KafkaBroker x$2) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$1($this, leader1$1, x$2));
    }

    public static final /* synthetic */ Object $anonfun$testDestLeaderChanges$2$adapted(ClusterLinkFailureTest $this, int leader2$1, KafkaBroker x$3) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$testDestLeaderChanges$2($this, leader2$1, x$3));
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$2$adapted(ClusterLinkListing x$16) {
        return BoxesRunTime.boxToBoolean((boolean)x$16.available());
    }

    public static final /* synthetic */ Object $anonfun$waitForRecovery$4$adapted(Set activePartitionState$1, Set x$17) {
        return BoxesRunTime.boxToBoolean((boolean)ClusterLinkFailureTest.$anonfun$waitForRecovery$4(activePartitionState$1, x$17));
    }
}

