/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import kafka.api.ApiVersion;
import kafka.cluster.Partition;
import kafka.controller.ControllerStats;
import kafka.controller.ReplicaAssignment$;
import kafka.integration.UncleanLeaderElectionTest$;
import kafka.network.Processor;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t}t!B\u001d;\u0011\u0003yd!B!;\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Q\u0005\"B&\u0002\t\u0003ae\u0001B!;\u0001\u0015DQ!\u0013\u0003\u0005\u00021DqA\u001c\u0003C\u0002\u0013\u0005q\u000e\u0003\u0004t\t\u0001\u0006I\u0001\u001d\u0005\bi\u0012\u0011\r\u0011\"\u0001p\u0011\u0019)H\u0001)A\u0005a\"9a\u000f\u0002b\u0001\n\u0003y\u0007BB<\u0005A\u0003%\u0001\u000fC\u0004y\t\t\u0007I\u0011A=\t\ru$\u0001\u0015!\u0003{\u0011\u001dqH\u00011A\u0005\u0002}D\u0011\"!\u0003\u0005\u0001\u0004%\t!a\u0003\t\u0011\u0005]A\u0001)Q\u0005\u0003\u0003A\u0001\"!\u0007\u0005\u0001\u0004%\ta \u0005\n\u00037!\u0001\u0019!C\u0001\u0003;A\u0001\"!\t\u0005A\u0003&\u0011\u0011\u0001\u0005\t\u0003G!\u0001\u0019!C\u0001\u007f\"I\u0011Q\u0005\u0003A\u0002\u0013\u0005\u0011q\u0005\u0005\t\u0003W!\u0001\u0015)\u0003\u0002\u0002!I\u0011Q\u0006\u0003A\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003\u0007\"\u0001\u0019!C\u0001\u0003\u000bB\u0001\"!\u0013\u0005A\u0003&\u0011\u0011\u0007\u0005\n\u0003\u0017\"\u0001\u0019!C\u0001\u0003\u001bB\u0011\"a\u0016\u0005\u0001\u0004%\t!!\u0017\t\u0011\u0005uC\u0001)Q\u0005\u0003\u001fB\u0011\"a\u0018\u0005\u0005\u0004%\t!!\u0019\t\u0011\u00055D\u0001)A\u0005\u0003GB\u0011\"a\u001c\u0005\u0005\u0004%\t!!\u001d\t\u0011\u0005}D\u0001)A\u0005\u0003gB\u0001\"!!\u0005\u0005\u0004%\ta\u001c\u0005\b\u0003\u0007#\u0001\u0015!\u0003q\u0011%\t)\t\u0002b\u0001\n\u0003\t9\t\u0003\u0005\u0002\u001c\u0012\u0001\u000b\u0011BAE\u0011%\ti\n\u0002b\u0001\n\u0003\ty\n\u0003\u0005\u0002.\u0012\u0001\u000b\u0011BAQ\u0011%\ty\u000b\u0002b\u0001\n\u0003\ty\n\u0003\u0005\u00022\u0012\u0001\u000b\u0011BAQ\u0011\u001d\t\u0019\f\u0002C!\u0003kCq!a4\u0005\t\u0003\n\t\u000eC\u0004\u0002\\\u0012!I!!8\t\u000f\u0005\u0015H\u0001\"\u0001\u0002h\"9!q\u0002\u0003\u0005\u0002\u0005E\u0007b\u0002B\r\t\u0011\u0005\u0011\u0011\u001b\u0005\b\u0005;!A\u0011AAi\u0011\u001d\u0011\t\u0003\u0002C\u0001\u0003#DqA!\n\u0005\t\u0003\t\t\u000eC\u0004\u0003*\u0011!\t!!5\t\u000f\t-B\u0001\"\u0001\u0002R\"9!Q\u0006\u0003\u0005\n\t=\u0002b\u0002B\u001a\t\u0011%!Q\u0007\u0005\b\u0005'\"A\u0011AAi\u0011\u001d\u00119\u0006\u0002C\u0005\u00053BqAa\u001f\u0005\t\u0013\u0011i(A\rV]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8UKN$(BA\u001e=\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u000b\u0003u\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002A\u00035\t!HA\rV]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8UKN$8CA\u0001D!\t!u)D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aP\u0001\u0011CBLg+\u001a:tS>t7k\\;sG\u0016,\u0012!\u0014\t\u0004\u001dV;V\"A(\u000b\u0005A\u000b\u0016AB:ue\u0016\fWN\u0003\u0002S'\u0006!Q\u000f^5m\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV(\u0003\rM#(/Z1n!\tA6-D\u0001Z\u0015\tQ6,\u0001\u0005qe>4\u0018\u000eZ3s\u0015\taV,\u0001\u0004qCJ\fWn\u001d\u0006\u0003=~\u000bqA[;qSR,'O\u0003\u0002aC\u0006)!.\u001e8ji*\t!-A\u0002pe\u001eL!\u0001Z-\u0003\u0013\u0005\u0013x-^7f]R\u001c8C\u0001\u0003g!\t9'.D\u0001i\u0015\tIG(\u0001\u0004tKJ4XM]\u0005\u0003W\"\u0014\u0011#U;peVlG+Z:u\u0011\u0006\u0014h.Z:t)\u0005i\u0007C\u0001!\u0005\u0003%\u0011'o\\6fe&#\u0017'F\u0001q!\t!\u0015/\u0003\u0002s\u000b\n\u0019\u0011J\u001c;\u0002\u0015\t\u0014xn[3s\u0013\u0012\f\u0004%A\u0005ce>\\WM]%ee\u0005Q!M]8lKJLEM\r\u0011\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\u0014A\u00032s_.,'/\u001334A\u0005ARM\\1cY\u0016\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8\u0016\u0003i\u0004\"\u0001R>\n\u0005q,%a\u0002\"p_2,\u0017M\\\u0001\u001aK:\f'\r\\3D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007%\u0001\u0007d_:4\u0017n\u001a)s_B\u001c\u0018'\u0006\u0002\u0002\u0002A!\u00111AA\u0003\u001b\u0005\t\u0016bAA\u0004#\nQ\u0001K]8qKJ$\u0018.Z:\u0002!\r|gNZ5h!J|\u0007o]\u0019`I\u0015\fH\u0003BA\u0007\u0003'\u00012\u0001RA\b\u0013\r\t\t\"\u0012\u0002\u0005+:LG\u000fC\u0005\u0002\u0016=\t\t\u00111\u0001\u0002\u0002\u0005\u0019\u0001\u0010J\u0019\u0002\u001b\r|gNZ5h!J|\u0007o]\u0019!\u00031\u0019wN\u001c4jOB\u0013x\u000e]:3\u0003A\u0019wN\u001c4jOB\u0013x\u000e]:3?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0005}\u0001\"CA\u000b%\u0005\u0005\t\u0019AA\u0001\u00035\u0019wN\u001c4jOB\u0013x\u000e]:3A\u0005a1m\u001c8gS\u001e\u0004&o\u001c9tg\u0005\u00012m\u001c8gS\u001e\u0004&o\u001c9tg}#S-\u001d\u000b\u0005\u0003\u001b\tI\u0003C\u0005\u0002\u0016U\t\t\u00111\u0001\u0002\u0002\u0005i1m\u001c8gS\u001e\u0004&o\u001c9tg\u0001\nqaY8oM&<7/\u0006\u0002\u00022A1\u00111GA\u001d\u0003{i!!!\u000e\u000b\u0007\u0005]R)\u0001\u0006d_2dWm\u0019;j_:LA!a\u000f\u00026\t\u00191+Z9\u0011\u0007\u001d\fy$C\u0002\u0002B!\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Y1m\u001c8gS\u001e\u001cx\fJ3r)\u0011\ti!a\u0012\t\u0013\u0005U\u0001$!AA\u0002\u0005E\u0012\u0001C2p]\u001aLwm\u001d\u0011\u0002\u000fM,'O^3sgV\u0011\u0011q\n\t\u0007\u0003g\tI$!\u0015\u0011\u0007\u001d\f\u0019&C\u0002\u0002V!\u00141bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\u0011\ti!a\u0017\t\u0013\u0005U1$!AA\u0002\u0005=\u0013\u0001C:feZ,'o\u001d\u0011\u0002\rI\fg\u000eZ8n+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005%TBAA4\u0015\t\u0011V)\u0003\u0003\u0002l\u0005\u001d$A\u0002*b]\u0012|W.A\u0004sC:$w.\u001c\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005M\u0004\u0003BA;\u0003wj!!a\u001e\u000b\u0007\u0005e4+\u0001\u0003mC:<\u0017\u0002BA?\u0003o\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0006qCJ$\u0018\u000e^5p]&#\u0017\u0001\u00049beRLG/[8o\u0013\u0012\u0004\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0013\u0003B!a#\u0002\u00186\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0004d_6lwN\u001c\u0006\u0004{\u0005M%bAAKC\u00061\u0011\r]1dQ\u0016LA!!'\u0002\u000e\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u001f-\fgm[1Ba&\u001cHj\\4hKJ,\"!!)\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KSA!a*\u0002\u0014\u0006)An\\45U&!\u00111VAS\u0005\u0019aunZ4fe\u0006\u00012.\u00194lC\u0006\u0003\u0018n\u001d'pO\u001e,'\u000fI\u0001\u0017]\u0016$xo\u001c:l!J|7-Z:t_JdunZ4fe\u00069b.\u001a;x_J\\\u0007K]8dKN\u001cxN\u001d'pO\u001e,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003\u001b\t9\fC\u0004\u0002:&\u0002\r!a/\u0002\u0011Q,7\u000f^%oM>\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0004\u0003\u0003l\u0016aA1qS&!\u0011QYA`\u0005!!Vm\u001d;J]\u001a|\u0007fA\u0015\u0002JB!\u0011QXAf\u0013\u0011\ti-a0\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\ti\u0001K\u0002+\u0003+\u0004B!!0\u0002X&!\u0011\u0011\\A`\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0007ti\u0006\u0014HO\u0011:pW\u0016\u00148\u000f\u0006\u0003\u0002\u000e\u0005}\u0007bBAqW\u0001\u0007\u00111]\u0001\bG2,8\u000f^3s!\u0019\t\u0019$!\u000f\u0002\u0002\u0005iC/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o%\u0016\u001cwN^3ss\u001a{'OR8mY><XM]:\u0015\t\u00055\u0011\u0011\u001e\u0005\b\u0003Wd\u0003\u0019AAw\u0003)\t\u0007/\u001b,feNLwN\u001c\t\u0005\u0003_\f\u00190\u0004\u0002\u0002r*\u0019\u0011\u0011\u0019\u001f\n\t\u0005U\u0018\u0011\u001f\u0002\u000b\u0003BLg+\u001a:tS>t\u0007f\u0002\u0017\u0002z\u0006}(\u0011\u0001\t\u00041\u0006m\u0018bAA\u007f3\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012!1A\u0011\u0002\u0017\"\u001aAFa\u0002\u0011\t\t%!1B\u0007\u00027&\u0019!QB.\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0011uKN$XK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016$\u0007fA\u0017\u0003\u0014A!\u0011Q\u0018B\u000b\u0013\u0011\u00119\"a0\u0003\tQ+7\u000f^\u0001\"i\u0016\u001cH/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eR5tC\ndW\r\u001a\u0015\u0004]\tM\u0011a\f;fgR,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:,e.\u00192mK\u0012\u0014\u0015\u0010V8qS\u000e|e/\u001a:sS\u0012,\u0007fA\u0018\u0003\u0014\u0005\u0001D/Z:u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\nKHk\u001c9jG>3XM\u001d:jI\u0016D3\u0001\rB\n\u00035\"Xm\u001d;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8J]Z\fG.\u001b3U_BL7m\u0014<feJLG-\u001a\u0015\u0004c\tM\u0011A\t<fe&4\u00170\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,G-A\u0012wKJLg-_+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3\u0002\u001dMDW\u000f\u001e3po:\u001cVM\u001d<feR!\u0011Q\u0002B\u0019\u0011\u0019IG\u00071\u0001\u0002R\u0005\u00112m\u001c8tk6,\u0017\t\u001c7NKN\u001c\u0018mZ3t)\u0019\u00119D!\u0014\u0003PA1\u00111GA\u001d\u0005s\u0001BAa\u000f\u0003J9!!Q\bB#!\r\u0011y$R\u0007\u0003\u0005\u0003R1Aa\u0011?\u0003\u0019a$o\\8u}%\u0019!qI#\u0002\rA\u0013X\rZ3g\u0013\u0011\tiHa\u0013\u000b\u0007\t\u001dS\tC\u0004\u0002pU\u0002\rA!\u000f\t\r\tES\u00071\u0001q\u0003-qW/\\'fgN\fw-Z:\u0002IQ,7\u000f\u001e+pa&\u001cWK\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016D3A\u000eB\n\u0003E\tG\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\t\u00057\u0012YG!\u001e\u0003xA!!Q\fB4\u001b\t\u0011yF\u0003\u0003\u0003b\t\r\u0014!B1e[&t'\u0002\u0002B3\u0003#\u000bqa\u00197jK:$8/\u0003\u0003\u0003j\t}#AE!mi\u0016\u00148i\u001c8gS\u001e\u001c(+Z:vYRDqA!\u001c8\u0001\u0004\u0011y'A\u0006bI6Lgn\u00117jK:$\b\u0003\u0002B/\u0005cJAAa\u001d\u0003`\t)\u0011\tZ7j]\"9\u0011qN\u001cA\u0002\te\u0002b\u0002B=o\u0001\u0007\u0011\u0011A\u0001\ri>\u0004\u0018nY\"p]\u001aLwm]\u0001\u0012GJ,\u0017\r^3BI6Lgn\u00117jK:$HC\u0001B8\u0001")
public class UncleanLeaderElectionTest
extends QuorumTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private final int brokerId3;
    private final boolean enableControlledShutdown;
    private Properties configProps1 = null;
    private Properties configProps2 = null;
    private Properties configProps3 = null;
    private Seq<KafkaConfig> configs = Nil$.MODULE$;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final Random random = new Random();
    private final String topic = new StringBuilder(5).append("topic").append(this.random().nextLong()).toString();
    private final int partitionId;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partitionId());
    private final Logger kafkaApisLogger = Logger.getLogger(KafkaApis.class);
    private final Logger networkProcessorLogger = Logger.getLogger(Processor.class);

    public static Stream<Arguments> apiVersionSource() {
        return UncleanLeaderElectionTest$.MODULE$.apiVersionSource();
    }

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public int brokerId3() {
        return this.brokerId3;
    }

    public boolean enableControlledShutdown() {
        return this.enableControlledShutdown;
    }

    public Properties configProps1() {
        return this.configProps1;
    }

    public void configProps1_$eq(Properties x$1) {
        this.configProps1 = x$1;
    }

    public Properties configProps2() {
        return this.configProps2;
    }

    public void configProps2_$eq(Properties x$1) {
        this.configProps2 = x$1;
    }

    public Properties configProps3() {
        return this.configProps3;
    }

    public void configProps3_$eq(Properties x$1) {
        this.configProps3 = x$1;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Random random() {
        return this.random;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Logger kafkaApisLogger() {
        return this.kafkaApisLogger;
    }

    public Logger networkProcessorLogger() {
        return this.networkProcessorLogger;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.configProps1_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.configProps2_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        this.configProps3_$eq(TestUtils$.MODULE$.createBrokerConfig(this.brokerId3(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)new .colon.colon((Object)this.configProps3(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)configProps -> {
            configProps.put("controlled.shutdown.enable", Boolean.toString(this.enableControlledShutdown()));
            configProps.put("controlled.shutdown.max.retries", "1");
            return configProps.put("controlled.shutdown.retry.backoff.ms", "1000");
        });
        this.kafkaApisLogger().setLevel(Level.FATAL);
        this.networkProcessorLogger().setLevel(Level.FATAL);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            CoreUtils$.MODULE$.delete(server.config().logDirs());
            return BoxedUnit.UNIT;
        });
        this.kafkaApisLogger().setLevel(Level.ERROR);
        this.networkProcessorLogger().setLevel(Level.ERROR);
        super.tearDown();
    }

    private void startBrokers(Seq<Properties> cluster) {
        cluster.foreach((Function1 & Serializable & scala.Serializable)props -> {
            UncleanLeaderElectionTest.$anonfun$startBrokers$1(this, props);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"apiVersionSource"})
    public void testUncleanLeaderElectionRecoveryForFollowers(ApiVersion apiVersion) {
        new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)new .colon.colon((Object)this.configProps3(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)configProps -> {
            configProps.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
            configProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            configProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
            configProps.put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            configProps.put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), "1000");
            configProps.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), "1");
            configProps.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
            configProps.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), "1");
            return configProps.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "*");
        });
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)new .colon.colon((Object)this.configProps3(), (List)Nil$.MODULE$))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2(), this.brokerId3()})))}))), this.servers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$3(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, TestUtils$.MODULE$.createProducer$default$2(), TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());){
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1 & Serializable & scala.Serializable)x$2 -> UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$7(this, producer, BoxesRunTime.unboxToInt((Object)x$2)));
        }
        ((IterableLike)this.servers().tail()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$9(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$11(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.servers().head()).shutdown();
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$13(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$14());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l11 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l12 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$15(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$17());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testUncleanLeaderElectionEnabled() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabled() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers());
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionEnabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "false");
        this.configProps2().put("unclean.leader.election.enable", "false");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "true");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionEnabled();
    }

    @Test
    public void testUncleanLeaderElectionDisabledByTopicOverride() {
        this.configProps1().put("unclean.leader.election.enable", "true");
        this.configProps2().put("unclean.leader.election.enable", "true");
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "false");
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})))}))), this.servers(), topicProps);
        this.verifyUncleanLeaderElectionDisabled();
    }

    @Test
    public void testUncleanLeaderElectionInvalidTopicOverride() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)Nil$.MODULE$));
        Properties topicProps = new Properties();
        topicProps.put("unclean.leader.election.enable", "invalid");
        Assertions.assertThrows(ConfigException.class, () -> TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1()})))}))), this.servers(), topicProps));
    }

    public void verifyUncleanLeaderElectionEnabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$3(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)x$4 -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$5(x$4);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$6(leaderId, x$5)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionEnabled$8(followerId, x$6))).get();
        followerServer.startup();
        KafkaZkClient x$3 = this.zkClient();
        String x$42 = this.topic();
        int x$52 = this.partitionId();
        Some x$62 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$7 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$42, x$52, x$7, x$8, (Option<Object>)x$62);
        Assertions.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyUncleanLeaderElectionDisabled() {
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Leader for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is elected to be: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderId)}))).toString());
        Assertions.assertTrue((leaderId == this.brokerId1() || leaderId == this.brokerId2() ? 1 : 0) != 0, (String)new StringBuilder(46).append("Leader id is set to expected value for topic: ").append(this.topic()).toString());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Follower for ").append(this.topic()).append(new StringOps(Predef$.MODULE$.augmentString(" is: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)followerId)}))).toString());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$3(followerId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$5(server);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$6(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$8(followerId, x$7))).get();
        followerServer.startup();
        KafkaZkClient x$3 = this.zkClient();
        String x$4 = this.topic();
        int x$5 = this.partitionId();
        Some x$6 = new Some((Object)BoxesRunTime.boxToInteger((int)-1));
        long x$72 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$8 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$3, x$4, x$5, x$72, x$8, (Option<Object>)x$6);
        Assertions.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaServer> x$9 = this.servers();
            String x$10 = this.topic();
            String x$11 = "third";
            int x$12 = 1000;
            int x$13 = 1000;
            Long x$14 = TestUtils$.MODULE$.produceMessage$default$4();
            TestUtils$.MODULE$.produceMessage(x$9, x$10, x$11, x$14, x$12, x$13);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$10(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            server.startup();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$15 = this.zkClient();
        String x$16 = this.topic();
        int x$17 = this.partitionId();
        Some x$18 = new Some((Object)BoxesRunTime.boxToInteger((int)leaderId));
        long x$19 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$15, x$16, x$17, x$19, x$20, (Option<Object>)x$18);
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$12(this, followerServer, followerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$verifyUncleanLeaderElectionDisabled$14(leaderId, server)))).foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        });
        KafkaZkClient x$21 = this.zkClient();
        String x$22 = this.topic();
        int x$23 = this.partitionId();
        Some x$24 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$25 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$26 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$21, x$22, x$23, x$25, x$26, (Option<Object>)x$24);
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$))), this.consumeAllMessages(this.topic(), 3));
    }

    private void shutdownServer(KafkaServer server) {
        server.shutdown();
        server.awaitShutdown();
    }

    private Seq<String> consumeAllMessages(String topic, int numMessages) {
        Seq seq;
        String brokerList = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        String x$2 = new StringBuilder(5).append("group").append(this.random().nextLong()).toString();
        boolean x$3 = false;
        StringDeserializer x$4 = new StringDeserializer();
        Option<String> x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        String x$6 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        int x$82 = TestUtils$.MODULE$.createConsumer$default$7();
        SecurityProtocol x$9 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<File> x$10 = TestUtils$.MODULE$.createConsumer$default$9();
        Option<Properties> x$11 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$12 = TestUtils$.MODULE$.createConsumer$default$11();
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(brokerList, x$2, x$5, x$6, x$3, x$7, x$82, x$9, x$10, x$11, x$12, x$4);){
            TopicPartition tp = new TopicPartition(topic, this.partitionId());
            consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
            consumer.seek(tp, 0L);
            seq = (Seq)TestUtils$.MODULE$.consumeRecords(consumer, numMessages, TestUtils$.MODULE$.consumeRecords$default$3()).map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.value(), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    @Test
    public void testTopicUncleanLeaderElectionEnable() {
        this.startBrokers((Seq<Properties>)new .colon.colon((Object)this.configProps1(), (List)new .colon.colon((Object)this.configProps2(), (List)Nil$.MODULE$)));
        AdminZkClient qual$1 = this.adminZkClient();
        String x$1 = this.topic();
        Properties x$2 = new Properties();
        Map x$3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.partitionId())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})), (Seq)Nil$.MODULE$))}));
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$6 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(x$1, x$2, x$3, x$4, x$5, x$6, x$7);
        int leaderId = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int followerId = leaderId == this.brokerId1() ? this.brokerId2() : this.brokerId1();
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "first", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)Nil$.MODULE$), this.consumeAllMessages(this.topic(), 1));
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$1(followerId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "second", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"second", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
        this.servers().map((Function1 & Serializable & scala.Serializable)server -> {
            UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$3(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        ((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$4(leaderId, server)))).map((Function1 & Serializable & scala.Serializable)server -> {
            this.shutdownServer(server);
            return BoxedUnit.UNIT;
        }, Seq$.MODULE$.canBuildFrom());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testTopicUncleanLeaderElectionEnable$6(followerId, x$9))).get();
        followerServer.startup();
        Assertions.assertEquals((long)0L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Seq<KafkaServer> x$10 = this.servers();
            String x$11 = this.topic();
            String x$12 = "third";
            int x$13 = 1000;
            int x$14 = 1000;
            Long x$15 = TestUtils$.MODULE$.produceMessage$default$4();
            TestUtils$.MODULE$.produceMessage(x$10, x$11, x$12, x$15, x$13, x$14);
        });
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Assertions.assertEquals((Object)List$.MODULE$.empty(), this.consumeAllMessages(this.topic(), 0));
        Admin adminClient = this.createAdminClient();
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.alterTopicConfigs(adminClient, this.topic(), newProps).all().get();
        adminClient.close();
        KafkaZkClient x$16 = this.zkClient();
        String x$17 = this.topic();
        int x$18 = this.partitionId();
        Some x$19 = new Some((Object)BoxesRunTime.boxToInteger((int)followerId));
        long x$20 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$21 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$16, x$17, x$18, x$20, x$21, (Option<Object>)x$19);
        Assertions.assertEquals((long)1L, (long)followerServer.kafkaController().controllerContext().stats().uncleanLeaderElectionRate().count());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "third", TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new .colon.colon((Object)"first", (List)new .colon.colon((Object)"third", (List)Nil$.MODULE$)), this.consumeAllMessages(this.topic(), 2));
    }

    private AlterConfigsResult alterTopicConfigs(Admin adminClient, String topic, Properties topicConfigs) {
        java.util.List configEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfigs).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            ConfigEntry configEntry = new ConfigEntry(k, v);
            return configEntry;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        Config newConfig = new Config((Collection)configEntries);
        java.util.Map configs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, topic)), (Object)newConfig)}))).asJava();
        return adminClient.alterConfigs(configs);
    }

    private Admin createAdminClient() {
        Properties config = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(this.servers());
        config.put("bootstrap.servers", bootstrapServers);
        config.put("metadata.max.age.ms", "10");
        return Admin.create((Properties)config);
    }

    public static final /* synthetic */ void $anonfun$startBrokers$1(UncleanLeaderElectionTest $this, Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer server = TestUtils$.MODULE$.createServer(config, TestUtils$.MODULE$.createServer$default$2());
        $this.configs_$eq((Seq<KafkaConfig>)((Seq)$this.configs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)config, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        $this.servers_$eq((Seq<KafkaServer>)((Seq)$this.servers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)server, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$2(UncleanLeaderElectionTest $this) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).leader() == $this.brokerId1();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$3(UncleanLeaderElectionTest $this) {
        return new StringBuilder(18).append("Leader should be ").append($this.brokerId1()).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$5(UncleanLeaderElectionTest $this) {
        return 1 == ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().head()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).isr().size();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$6() {
        return "ISR should be down to 1";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testUncleanLeaderElectionRecoveryForFollowers$7(UncleanLeaderElectionTest $this, KafkaProducer producer$1, int x$2) {
        return (RecordMetadata)producer$1.send(new ProducerRecord($this.topic(), (Object)new byte[1024])).get();
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$9(UncleanLeaderElectionTest $this) {
        return ((KafkaServer)$this.servers().head()).metadataCache().getAliveBrokers().size() == $this.servers().size();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$10() {
        return "All brokers should be running.";
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$11(UncleanLeaderElectionTest $this) {
        return 1 == ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().head()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).isr().size();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$12() {
        return "ISR should be down to 1";
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$13(UncleanLeaderElectionTest $this) {
        int leader = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)$this.servers().last()).metadataCache().getPartitionInfo($this.topic(), $this.partitionId()).get()).leader();
        return leader == $this.brokerId2() || leader == $this.brokerId3();
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$14() {
        return "Leader should either be 1 or 2 now";
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$16(UncleanLeaderElectionTest $this, KafkaServer server) {
        return !((Partition)server.replicaManager().onlinePartition($this.topicPartition()).get()).isUncleanLeader();
    }

    public static final /* synthetic */ boolean $anonfun$testUncleanLeaderElectionRecoveryForFollowers$15(UncleanLeaderElectionTest $this) {
        return ((IterableLike)$this.servers().tail()).forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)UncleanLeaderElectionTest.$anonfun$testUncleanLeaderElectionRecoveryForFollowers$16($this, server)));
    }

    public static final /* synthetic */ String $anonfun$testUncleanLeaderElectionRecoveryForFollowers$17() {
        return "Leader and follower should have their `isUncleanLeader` flag cleared.";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$3(int followerId$1, KafkaServer server) {
        return server.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionEnabled$5(KafkaServer x$4) {
        ControllerStats qual$1 = x$4.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$6(int leaderId$1, KafkaServer x$5) {
        return x$5.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionEnabled$8(int followerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$3(int followerId$2, KafkaServer server) {
        return server.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ void $anonfun$verifyUncleanLeaderElectionDisabled$5(KafkaServer server) {
        ControllerStats qual$1 = server.kafkaController().controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$6(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$8(int followerId$2, KafkaServer x$7) {
        return x$7.config().brokerId() == followerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$10(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$12(UncleanLeaderElectionTest $this, KafkaServer followerServer$1, int followerId$2) {
        Option partitionInfoOpt = followerServer$1.metadataCache().getPartitionInfo($this.topic(), $this.partitionId());
        return partitionInfoOpt.isDefined() && ((UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).isr().contains(BoxesRunTime.boxToInteger((int)followerId$2));
    }

    public static final /* synthetic */ String $anonfun$verifyUncleanLeaderElectionDisabled$13() {
        return "Inconsistent metadata after first server startup";
    }

    public static final /* synthetic */ boolean $anonfun$verifyUncleanLeaderElectionDisabled$14(int leaderId$2, KafkaServer server) {
        return server.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$1(int followerId$3, KafkaServer server) {
        return server.config().brokerId() == followerId$3;
    }

    public static final /* synthetic */ void $anonfun$testTopicUncleanLeaderElectionEnable$3(KafkaServer server) {
        ControllerStats qual$2 = server.kafkaController().controllerContext().stats();
        String x$8 = "UncleanLeaderElectionsPerSec";
        Map x$9 = qual$2.removeMetric$default$2();
        qual$2.removeMetric(x$8, x$9);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$4(int leaderId$3, KafkaServer server) {
        return server.config().brokerId() == leaderId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicUncleanLeaderElectionEnable$6(int followerId$3, KafkaServer x$9) {
        return x$9.config().brokerId() == followerId$3;
    }

    public UncleanLeaderElectionTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
        this.brokerId3 = 2;
        this.enableControlledShutdown = true;
        this.partitionId = 0;
    }
}

