/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.materialization;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.audit.AuditManagerRequest;
import kafka.durability.audit.AuditReporter;
import kafka.durability.audit.AuditReporter$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.audit.RegisterPartitionRequest;
import kafka.durability.audit.TestAuditManager;
import kafka.durability.db.DbTestUtils$;
import kafka.durability.db.DurabilityDB;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.events.AbstractDurabilityEvent;
import kafka.durability.events.DeletePartitionEvent;
import kafka.durability.events.DeletePartitionEvent$;
import kafka.durability.events.DeleteRecordsEvent;
import kafka.durability.events.DeleteRecordsEvent$;
import kafka.durability.events.EpochChangeEvent;
import kafka.durability.events.EpochChangeEvent$;
import kafka.durability.events.IsrExpandEvent;
import kafka.durability.events.IsrExpandEvent$;
import kafka.durability.events.RetentionChangeEvent;
import kafka.durability.events.RetentionChangeEvent$;
import kafka.durability.events.RetentionType$;
import kafka.durability.events.StartOffsetChangeEvent;
import kafka.durability.events.StartOffsetChangeEvent$;
import kafka.durability.materialization.DurabilityEventsMaterialize;
import kafka.durability.materialization.Validator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001\u0002\u001f>\u0001\u0011CQa\u0013\u0001\u0005\u00021C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013u\u0003\u0001\u0019!a\u0001\n\u0013q\u0006\"\u00033\u0001\u0001\u0004\u0005\t\u0015)\u0003R\u0011%)\u0007\u00011AA\u0002\u0013%a\rC\u0005n\u0001\u0001\u0007\t\u0019!C\u0005]\"I\u0001\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001a\u0005\nc\u0002\u0001\r\u00111A\u0005\nID\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\t\u0013i\u0004\u0001\u0019!A!B\u0013\u0019\b\"C>\u0001\u0001\u0004\u0005\r\u0011\"\u0003}\u0011-\t9\u0001\u0001a\u0001\u0002\u0004%I!!\u0003\t\u0015\u00055\u0001\u00011A\u0001B\u0003&Q\u0010C\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\n\u0005E\u0001bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?A1\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0014!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0014\u0011-\tI\u0004\u0001a\u0001\u0002\u0004%I!a\u000f\t\u0017\u0005}\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0006\u0005\f\u0003\u0003\u0002\u0001\u0019!a\u0001\n\u0013\t\u0019\u0005C\u0006\u0002V\u0001\u0001\r\u00111A\u0005\n\u0005]\u0003bCA.\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u000bB\u0011\"!\u0018\u0001\u0005\u0004%I!a\u0018\t\u0011\u0005%\u0004\u0001)A\u0005\u0003CB\u0011\"a\u001b\u0001\u0005\u0004%I!a\u0018\t\u0011\u00055\u0004\u0001)A\u0005\u0003CB\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005e\u0004\u0001)A\u0005\u0003gB\u0011\"a\u001f\u0001\u0005\u0004%I!! \t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u007fB\u0011\"!(\u0001\u0005\u0004%I!a(\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003CC\u0011\"!+\u0001\u0005\u0004%\t!a+\t\u0011\u0005M\u0006\u0001)A\u0005\u0003[C\u0011\"!.\u0001\u0005\u0004%\t!a.\t\u0011\u0005]\u0007\u0001)A\u0005\u0003sC1\"!7\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\\\"Y\u0011q\u001d\u0001A\u0002\u0003\u0007I\u0011AAu\u0011-\ti\u000f\u0001a\u0001\u0002\u0003\u0006K!!8\t\u0017\u0005=\b\u00011AA\u0002\u0013\u0005\u0011\u0011\u001f\u0005\f\u0003s\u0004\u0001\u0019!a\u0001\n\u0003\tY\u0010C\u0006\u0002\u0000\u0002\u0001\r\u0011!Q!\n\u0005M\bb\u0003B\u0001\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0007A1B!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u0014!Y!q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u0003\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqAa\r\u0001\t\u0003\u0011Y\u0002C\u0004\u0003>\u0001!\tAa\u0007\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003\u001c!9!1\n\u0001\u0005\u0002\tm\u0001b\u0002B(\u0001\u0011\u0005!1\u0004\u0005\b\u0005'\u0002A\u0011\u0001B\u000e\u0011\u001d\u00119\u0006\u0001C\u0001\u00057AqAa\u0017\u0001\t\u0003\u0011Y\u0002C\u0004\u0003`\u0001!\tAa\u0007\t\u000f\t\r\u0004\u0001\"\u0001\u0003\u001c!9!q\r\u0001\u0005\u0002\tm\u0001b\u0002B6\u0001\u0011\u0005!1\u0004\u0005\b\u0005_\u0002A\u0011\u0001B\u000e\u0005}!UO]1cS2LG/_#wK:$8/T1uKJL\u0017\r\\5{KR+7\u000f\u001e\u0006\u0003}}\nq\"\\1uKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u0001\u0006\u000b!\u0002Z;sC\nLG.\u001b;z\u0015\u0005\u0011\u0015!B6bM.\f7\u0001A\n\u0003\u0001\u0015\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001N!\tq\u0005!D\u0001>\u0003\u001diW\r\u001e:jGN,\u0012!\u0015\t\u0003%nk\u0011a\u0015\u0006\u0003\u001fRS!!\u0016,\u0002\r\r|W.\\8o\u0015\t\u0011uK\u0003\u0002Y3\u00061\u0011\r]1dQ\u0016T\u0011AW\u0001\u0004_J<\u0017B\u0001/T\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011qL\u0019\t\u0003\r\u0002L!!Y$\u0003\tUs\u0017\u000e\u001e\u0005\bG\u000e\t\t\u00111\u0001R\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005A!/\u001a9peR,'/F\u0001h!\tA7.D\u0001j\u0015\tQw(A\u0003bk\u0012LG/\u0003\u0002mS\ni\u0011)\u001e3jiJ+\u0007o\u001c:uKJ\fAB]3q_J$XM]0%KF$\"aX8\t\u000f\r4\u0011\u0011!a\u0001O\u0006I!/\u001a9peR,'\u000fI\u0001\t[6\u000bg.Y4feV\t1\u000f\u0005\u0002uk6\tq(\u0003\u0002w\u007f\tAB)\u001e:bE&d\u0017\u000e^=NKR\u0014\u0018nY:NC:\fw-\u001a:\u0002\u00195l\u0015M\\1hKJ|F%Z9\u0015\u0005}K\bbB2\n\u0003\u0003\u0005\ra]\u0001\n[6\u000bg.Y4fe\u0002\nA\u0001^5nKV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003!\u0016!B;uS2\u001c\u0018bAA\u0003\u007f\n!A+[7f\u0003!!\u0018.\\3`I\u0015\fHcA0\u0002\f!91\rDA\u0001\u0002\u0004i\u0018!\u0002;j[\u0016\u0004\u0013A\u00013c+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\r\tyaP\u0005\u0005\u00037\t9B\u0001\u0007EkJ\f'-\u001b7jif$%)\u0001\u0004eE~#S-\u001d\u000b\u0004?\u0006\u0005\u0002\u0002C2\u0010\u0003\u0003\u0005\r!a\u0005\u0002\u0007\u0011\u0014\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0002j_*\u0011\u00111G\u0001\u0005U\u00064\u0018-\u0003\u0003\u00028\u00055\"\u0001\u0002$jY\u0016\f!\u0002^7q\t&\u0014x\fJ3r)\ry\u0016Q\b\u0005\tGJ\t\t\u00111\u0001\u0002*\u00059A/\u001c9ESJ\u0004\u0013\u0001\u0004;jKJ|%M[*u_J,WCAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\nQa\u001d;pe\u0016T1!a\u0014B\u0003\u0011!\u0018.\u001a:\n\t\u0005M\u0013\u0011\n\u0002\u0010)&,'o\u00142kK\u000e$8\u000b^8sK\u0006\u0001B/[3s\u001f\nT7\u000b^8sK~#S-\u001d\u000b\u0004?\u0006e\u0003\u0002C2\u0016\u0003\u0003\u0005\r!!\u0012\u0002\u001bQLWM](cUN#xN]3!\u0003\u001d!x\u000e]5d\u0013\u0012,\"!!\u0019\u0011\t\u0005\r\u0014QM\u0007\u0002)&\u0019\u0011q\r+\u0003\tU+\u0018\u000eZ\u0001\ti>\u0004\u0018nY%eA\u0005Y!0\u001a:p)>\u0004\u0018nY%e\u00031QXM]8U_BL7-\u00133!\u0003\r!\b/M\u000b\u0003\u0003g\u0002B!a\u0019\u0002v%\u0019\u0011q\u000f+\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017\u0001\u0002;qc\u0001\n!\"\u001a9pG\"\u001c\u0005.Y5o+\t\ty\b\u0005\u0005\u0002\u0002\u0006-\u0015qRAK\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013;\u0015AC2pY2,7\r^5p]&!\u0011QRAB\u0005\u001dA\u0015m\u001d5NCB\u00042ARAI\u0013\r\t\u0019j\u0012\u0002\u0004\u0013:$\bc\u0001$\u0002\u0018&\u0019\u0011\u0011T$\u0003\t1{gnZ\u0001\fKB|7\r[\"iC&t\u0007%\u0001\u0002qgV\u0011\u0011\u0011\u0015\t\u0005\u0003+\t\u0019+\u0003\u0003\u0002&\u0006]!A\u0004)beRLG/[8o'R\fG/Z\u0001\u0004aN\u0004\u0013\u0001\u0002;q\u0013\u0012,\"!!,\u0011\t\u0005=\u0016\u0011W\u0007\u0003\u0003\u001bJA!a\u001e\u0002N\u0005)A\u000f]%eA\u0005aAn\\2bY>3gm]3ugV\u0011\u0011\u0011\u0018\t\u0007\u0003w\u000bY-!5\u000f\t\u0005u\u0016q\u0019\b\u0005\u0003\u007f\u000b)-\u0004\u0002\u0002B*\u0019\u00111Y\"\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015bAAe\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BAg\u0003\u001f\u00141aU3r\u0015\r\tIm\u0012\t\b\r\u0006M\u0017QSAK\u0013\r\t)n\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b1|7-\u00197PM\u001a\u001cX\r^:!\u0003\rawnZ\u000b\u0003\u0003;\u0004B!a8\u0002d6\u0011\u0011\u0011\u001d\u0006\u0004\u00033\f\u0015\u0002BAs\u0003C\u00141\"\u00112tiJ\f7\r\u001e'pO\u00069An\\4`I\u0015\fHcA0\u0002l\"A1MJA\u0001\u0002\u0004\ti.\u0001\u0003m_\u001e\u0004\u0013A\u00037pO6\u000bg.Y4feV\u0011\u00111\u001f\t\u0005\u0003?\f)0\u0003\u0003\u0002x\u0006\u0005(A\u0003'pO6\u000bg.Y4fe\u0006qAn\\4NC:\fw-\u001a:`I\u0015\fHcA0\u0002~\"A1-KA\u0001\u0002\u0004\t\u00190A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0005\u000b\u0001BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0004\u0005\u0017\t\u0015AB:feZ,'/\u0003\u0003\u0003\u0010\t%!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002`\u0005+A\u0001b\u0019\u0017\u0002\u0002\u0003\u0007!QA\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\tq\fK\u0002/\u0005?\u0001BA!\t\u000305\u0011!1\u0005\u0006\u0005\u0005K\u00119#A\u0002ba&TAA!\u000b\u0003,\u00059!.\u001e9ji\u0016\u0014(b\u0001B\u00173\u0006)!.\u001e8ji&!!\u0011\u0007B\u0012\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001aqFa\u000e\u0011\t\t\u0005\"\u0011H\u0005\u0005\u0005w\u0011\u0019CA\u0005BMR,'/R1dQ\u0006yB/Z:u'6\fG\u000e\\3s\u0011&<\u0007nV1uKJl\u0017M]6DQ\u0006tw-Z:)\u0007A\u0012\t\u0005\u0005\u0003\u0003\"\t\r\u0013\u0002\u0002B#\u0005G\u0011A\u0001V3ti\u0006qB/Z:u\u0019\u0006\u0014x-\u001a:IS\u001eDw+\u0019;fe6\f'o[\"iC:<Wm\u001d\u0015\u0004c\t\u0005\u0013a\u0007;fgR\u0014VM[3di&|gn\u00144Ti\u0006dWMU3d_J$7\u000fK\u00023\u0005\u0003\nA\u0004^3ti\"\u000bg\u000e\u001a7f'R\fG.\u001a#fY\u0016$XMU3d_J$7\u000fK\u00024\u0005\u0003\n1\u0003^3ti\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3\u0001\u000eB!\u0003\t\"Xm\u001d;NSN\u001c\u0018N\\4EK2,G/\u001a)beRLG/[8o%\u0016\u001cwN^3ss\"\u001aQG!\u0011\u00021Q,7\u000f^#q_\u000eD7\t[1j]Z\u000bG.\u001b3bi&|g\u000eK\u00027\u0005\u0003\n\u0001\u0005^3tiRKW.\u001a\"bg\u0016$'+\u001a;f]RLwN\u001c,bY&$\u0017\r^5p]\"\u001aqG!\u0011\u0002yQ,7\u000f\u001e+j[\u0016\u0014\u0015m]3e%\u0016$XM\u001c;j_:4\u0016\r\\5eCRLwN\\,ji\"tu\u000eR3mKR,GmU3h[\u0016tG/T3uC\u0012\fG/\u0019\u0015\u0004q\t\u0005\u0013\u0001\r;fgR$\u0016.\\3CCN,GMU3uK:$\u0018n\u001c8WC2LG-\u0019;j_:<\u0016\u000e\u001e5Vg\u0016\u0014H)\u001a7fi&|g\u000eK\u0002:\u0005\u0003\n!\u0004^3ti6K7o]5oO\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:D3A\u000fB!\u0003q!Xm\u001d;Ti\u0006dW-\u0012<f]R<\u0016\u000e\u001e5pkR$v\u000e]5d\u0013\u0012D3a\u000fB!\u0001")
public class DurabilityEventsMaterializeTest {
    private Metrics metrics;
    private AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    private DurabilityMetricsManager mManager;
    private Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    private DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    private File tmpDir;
    private TierObjectStore tierObjStore;
    private final Uuid topicId = Uuid.randomUuid();
    private final Uuid zeroTopicId = Uuid.ZERO_UUID;
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), new TopicPartition("t1", 1));
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)11L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)21L))}));
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp1().topicPartition().partition(), 0L, 40L, 0L, 0L, 0L, 36000000L, 1024L, this.epochChain(), Uuid.randomUuid(), 0L);
    private final kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
    private final Seq<Tuple2<Object, Object>> localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
    private AbstractLog log;
    private LogManager logManager;
    private ReplicaManager replicaManager;

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public AuditReporter kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter_$eq(AuditReporter x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter = x$1;
    }

    private DurabilityMetricsManager mManager() {
        return this.mManager;
    }

    private void mManager_$eq(DurabilityMetricsManager x$1) {
        this.mManager = x$1;
    }

    public Time kafka$durability$materialization$DurabilityEventsMaterializeTest$$time() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$time_$eq(Time x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time = x$1;
    }

    public DurabilityDB kafka$durability$materialization$DurabilityEventsMaterializeTest$$db() {
        return this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db;
    }

    private void kafka$durability$materialization$DurabilityEventsMaterializeTest$$db_$eq(DurabilityDB x$1) {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db = x$1;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    private TierObjectStore tierObjStore() {
        return this.tierObjStore;
    }

    private void tierObjStore_$eq(TierObjectStore x$1) {
        this.tierObjStore = x$1;
    }

    private Uuid topicId() {
        return this.topicId;
    }

    private Uuid zeroTopicId() {
        return this.zeroTopicId;
    }

    private TopicIdPartition tp1() {
        return this.tp1;
    }

    private HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    private PartitionState ps() {
        return this.ps;
    }

    public kafka.tier.TopicIdPartition tpId() {
        return this.tpId;
    }

    public Seq<Tuple2<Object, Object>> localOffsets() {
        return this.localOffsets;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time_$eq((Time)new MockTime(0L, 0L));
        this.metrics_$eq(new Metrics(new MetricConfig(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time()));
        this.mManager_$eq(new DurabilityMetricsManager("0", this.metrics(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), DurabilityMetricsManager$.MODULE$.$lessinit$greater$default$4()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter_$eq(AuditReporter$.MODULE$.apply(this.mManager()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db_$eq(DbTestUtils$.MODULE$.getDbInstance());
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.tierObjStore_$eq(TierObjectStoreFactory.getObjectStoreInstance((Time)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (TierObjectStore.Backend)TierObjectStore.Backend.Mock, (TierObjectStoreConfig)new MockInMemoryTierObjectStoreConfig()));
        this.log_$eq(DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(this.tpId(), this.localOffsets(), this.tmpDir(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6()));
        this.logManager_$eq(DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)this.log())})))));
        this.replicaManager_$eq(DurabilityTestUtils$.MODULE$.mockReplicaManager(this.logManager()));
    }

    @AfterEach
    public void tearDown() {
        DbTestUtils$.MODULE$.cleanup(this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db());
        Utils.delete((File)this.tmpDir());
        this.tierObjStore().close();
    }

    @Test
    public void testSmallerHighWatermarkChanges() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$1;
            }
        };
        materialize.materializeHighWatermarkChanges(this.tp1().topicPartition(), 2, 30L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)10L, (long)lapse);
        Assertions.assertEquals((long)10L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testLargerHighWatermarkChanges() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils$.MODULE$.tempDir();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$2;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
    }

    @Test
    public void testRejectionOfStaleRecords() {
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        PartitionState ps1 = PartitionState$.MODULE$.apply(this.tp1().topicPartition().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, epochChain, this.topicId(), 0L);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$3;
            }
        };
        RetentionChangeEvent event1 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 500L, -1L, 1, -1L, -1L);
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        RetentionChangeEvent event2 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, 2, -1L, -1L);
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 200L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 1000L ? 1 : 0) != 0);
        RetentionChangeEvent event3 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, 3, -1L, -1L);
        ConsumerRecord record3 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event3.serializeKey(), (Object)event3.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record3));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testHandleStaleDeleteRecords() {
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        PartitionState ps1 = PartitionState$.MODULE$.apply(this.tp1().partition(), 5L, 100L, 0L, 2L, 100L, 3600L, 1024L, epochChain, this.tp1().topicId(), 0L);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$4;
            }
        };
        DeleteRecordsEvent event = DeleteRecordsEvent$.MODULE$.apply(this.tp1(), 15L, 1, 60L, 1L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        ConsumerRecord record = new ConsumerRecord(this.tp1().topic(), this.tp1().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event.serializeKey(), (Object)event.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record));
        Predef$.MODULE$.assert(ps1.committedStartOffset() == 15L);
        Predef$.MODULE$.assert(ps1.highWatermark() == 100L);
        Predef$.MODULE$.assert(ps1.latestEpoch() == 2);
        Predef$.MODULE$.assert(ps1.startOffset() == 5L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletePartition() {
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(this.tp1(), 0, true));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testDeletePartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this.replicaManager(), testAuditManager.instance().db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        DeletePartitionEvent evt = DeletePartitionEvent$.MODULE$.apply(this.tp1(), 3);
        materialize.materializeDeletePartition(evt);
        Assertions.assertEquals((Object)testAuditManager.instance().db().fetchPartitionState(this.tp1().topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
    }

    @Test
    public void testMissingDeletePartitionRecovery() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils$.MODULE$.tempDir();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$5;
            }
        };
        this.ps().latestLocalEpoch_$eq(this.ps().latestEpoch());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 2, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(tp.topicPartition()));
        EpochChangeEvent epochChangeEvent = EpochChangeEvent$.MODULE$.apply(tp, 0L, 0, 0, 0L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        materialize.checkMissingTopicDeletion((AbstractDurabilityEvent)epochChangeEvent, this.ps());
        materialize.materializeEpochChangeEvent(epochChangeEvent, this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        materialize.materializeHighWatermarkChanges(tp.topicPartition(), 0, 100L, Predef$.MODULE$.Set().empty(), this.ps(), materialize.materializeHighWatermarkChanges$default$6(), materialize.materializeHighWatermarkChanges$default$7());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
        materialize.materializeEpochChangeEvent(EpochChangeEvent$.MODULE$.apply(tp, 0L, 0, 0, 80L, 0L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), this.ps(), materialize.materializeEpochChangeEvent$default$3());
        Assertions.assertEquals((long)101L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testEpochChainValidation() {
        .colon.colon localOffsets = new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 20L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(21L, 30L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(31L, 40L), (List)Nil$.MODULE$)));
        File tmpDir = TestUtils$.MODULE$.tempDir();
        Uuid topicId = Uuid.randomUuid();
        TopicIdPartition tp = new TopicIdPartition(topicId, new TopicPartition("t2", 2));
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(tp.topicPartition().topic(), UUID.randomUUID(), tp.topicPartition().partition());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData(tpId, (Seq<Tuple2<Object, Object>>)localOffsets, tmpDir, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), (Seq<Tuple2<Object, Object>>)Nil$.MODULE$, DurabilityTestUtils$.MODULE$.mockLogWithPreLoadedData$default$6());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)log)}))));
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), "1");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((Map)props, KafkaConfig$.MODULE$.apply$default$2());
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(config, logManager);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(replicaManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter(), this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time());
        IsrExpandEvent evt = IsrExpandEvent$.MODULE$.apply(tp, 1, 3, this.ps().highWatermark(), this.ps().committedStartOffset());
        LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
            private Seq<EpochEntry> epochs;
            private final File file;

            private Seq<EpochEntry> epochs() {
                return this.epochs;
            }

            private void epochs_$eq(Seq<EpochEntry> x$1) {
                this.epochs = x$1;
            }

            public File file() {
                return this.file;
            }

            public void write(Iterable<EpochEntry> epochs) {
                this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
            }

            public byte[] toByteArray(Seq<EpochEntry> epochs) {
                throw new UnsupportedOperationException();
            }

            public Seq<EpochEntry> read() {
                return this.epochs();
            }
            {
                this.epochs = Nil$.MODULE$;
                this.file = TestUtils$.MODULE$.tempFile();
            }
        };
        LeaderEpochFileCache cache = new LeaderEpochFileCache(tp.topicPartition(), checkpoint);
        cache.assign(0, 0L);
        cache.assign(1, 11L);
        cache.assign(2, 21L);
        Mockito.when((Object)log.leaderEpochCache()).thenReturn((Object)Option$.MODULE$.apply((Object)cache));
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)0L, (long)this.mManager().totalLostMessages());
        cache.assign(2, 15L);
        materialize.materializeISRExpandEvent(evt, this.ps(), materialize.materializeISRExpandEvent$default$3());
        Assertions.assertEquals((long)1L, (long)this.mManager().totalLostMessages());
    }

    @Test
    public void testTimeBasedRetentionValidation() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            long x$13 = LogTestUtils$.MODULE$.createTierLogSegment$default$7();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$6;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, 1L)));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 5L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)5L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 20L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple22 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long lapse2 = tuple22._2$mcJ$sp();
        Assertions.assertEquals((long)15L, (long)lapse2);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)20L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 21L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple23 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        long lapse3 = tuple23._2$mcJ$sp();
        Assertions.assertEquals((long)16L, (long)lapse3);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)21L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 25L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs() / 2L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        RetentionChangeEvent evt2 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, this.ps().latestEpoch(), -1L, -1L);
        materialize.materializeRetentionChangeEvent(evt2, this.ps());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)25L);
        evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 30L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs() / 2L, StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)30L);
    }

    @Test
    public void testTimeBasedRetentionValidationWithNoDeletedSegmentMetadata() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            long x$13 = LogTestUtils$.MODULE$.createTierLogSegment$default$7();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$7;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp);
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 221L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lapse = tuple2._2$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)lapse);
        Assertions.assertEquals((long)this.ps().committedStartOffset(), (long)221L);
    }

    @Test
    public void testTimeBasedRetentionValidationWithUserDeletion() {
        Seq localSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(201L, 300L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(301L, 400L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(401L, 500L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long start = x0$1._1$mcJ$sp();
            long end = x0$1._2$mcJ$sp();
            File x$3 = this.tmpDir();
            Time x$4 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time();
            long x$5 = end * 1000L * 1000L * 1000L;
            int x$6 = LogTestUtils$.MODULE$.createLocalLogSegment$default$4();
            LogSegment logSegment = LogTestUtils$.MODULE$.createLocalLogSegment(start, end, x$3, x$6, x$4, x$5);
            return logSegment;
        }, Seq$.MODULE$.canBuildFrom());
        kafka.tier.TopicIdPartition tpId = new kafka.tier.TopicIdPartition(this.tp1().topicPartition().topic(), UUID.randomUUID(), this.tp1().topicPartition().partition());
        Seq tierSegments = (Seq)new .colon.colon((Object)new Tuple2.mcJJ.sp(10L, 100L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(101L, 150L), (List)new .colon.colon((Object)new Tuple2.mcJJ.sp(151L, 200L), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            long start = x0$2._1$mcJ$sp();
            long end = x0$2._2$mcJ$sp();
            TierObjectStore x$10 = this.tierObjStore();
            long x$11 = end * 1000L * 1000L * 1000L;
            TierObjectMetadata.State x$12 = LogTestUtils$.MODULE$.createTierLogSegment$default$5();
            long x$13 = LogTestUtils$.MODULE$.createTierLogSegment$default$7();
            TierLogSegment tierLogSegment = LogTestUtils$.MODULE$.createTierLogSegment(tpId, start, end, x$10, x$12, x$11, x$13);
            return tierLogSegment;
        }, Seq$.MODULE$.canBuildFrom());
        AbstractLog log = DurabilityTestUtils$.MODULE$.mockLog(this.tp1().topicPartition(), (Seq<LogSegment>)localSegments, (Seq<TierLogSegment>)tierSegments, DurabilityTestUtils$.MODULE$.mockLog$default$4(), DurabilityTestUtils$.MODULE$.mockLog$default$5(), DurabilityTestUtils$.MODULE$.mockLog$default$6(), DurabilityTestUtils$.MODULE$.mockLog$default$7(), DurabilityTestUtils$.MODULE$.mockLog$default$8(), DurabilityTestUtils$.MODULE$.mockLog$default$9());
        DurabilityDB db = (DurabilityDB)Mockito.mock(DurabilityDB.class);
        LogManager logManager = DurabilityTestUtils$.MODULE$.mockLogManager((scala.collection.immutable.Map<TopicPartition, AbstractLog>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1().topicPartition()), (Object)log)}))));
        ReplicaManager replicaManager = DurabilityTestUtils$.MODULE$.mockReplicaManager(logManager);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return true;
            }
        };
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, db, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$8;
            }
        };
        long earliestMaxTimestamp = ((TierLogSegment)tierSegments.head()).maxTimestamp();
        long earliestBatchTimestamp = ((TierLogSegment)tierSegments.head()).firstBatchTimestamp();
        UUID objectId = UUID.fromString("7eaf8e12-6055-4e95-984a-6e0398ef2faf");
        Mockito.when((Object)log.tierPartitionState().previousMetadataBeforeOffset(BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn(Optional.of(new SegmentState(1, objectId, 1L, 1L, 1L, earliestMaxTimestamp, earliestBatchTimestamp, 1, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, TierObjectStore.OpaqueData.ZEROED, 1L)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)this.ps().highWatermark()));
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time().sleep(earliestMaxTimestamp + this.ps().retentionMs() - (long)validatorInst.RetentionTimeMarginOfErrorMs() - 1L);
        DeleteRecordsEvent delEvent = DeleteRecordsEvent$.MODULE$.apply(this.tp1(), 5L, this.ps().latestEpoch(), this.ps().highWatermark(), 0L, DeleteRecordsEvent$.MODULE$.apply$default$6());
        materialize.materializeDeleteRecordEvent(delEvent, this.ps(), materialize.materializeDeleteRecordEvent$default$3(), materialize.materializeDeleteRecordEvent$default$4());
        StartOffsetChangeEvent evt = StartOffsetChangeEvent$.MODULE$.apply(this.tp1(), this.ps().latestEpoch(), this.ps().highWatermark(), 5L, (byte)RetentionType$.MODULE$.TimeBasedRetention().id(), this.ps().retentionMs(), StartOffsetChangeEvent$.MODULE$.apply$default$7());
        materialize.materializeStartOffset(evt, this.ps(), materialize.materializeStartOffset$default$3(), materialize.materializeStartOffset$default$4());
        Tuple2 tuple2 = this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$reporter().getDurabilityCounters(this.tp1().topicPartition());
        if (tuple2 != null) {
            long lapse = tuple2._2$mcJ$sp();
            Assertions.assertEquals((long)0L, (long)lapse);
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingDeletePartition() {
        Uuid exclusiveRandomUUID1 = Uuid.randomUuid();
        Uuid exclusiveRandomUUID2 = Uuid.randomUuid();
        while (true) {
            Uuid uuid = exclusiveRandomUUID1;
            if (uuid != null ? !uuid.equals(exclusiveRandomUUID2) : exclusiveRandomUUID2 != null) break;
            exclusiveRandomUUID2 = Uuid.randomUuid();
        }
        TopicIdPartition tt1 = new TopicIdPartition(exclusiveRandomUUID1, new TopicPartition("test-topic", 0));
        TopicIdPartition tt2 = new TopicIdPartition(exclusiveRandomUUID2, new TopicPartition("test-topic", 0));
        TestAuditManager testAuditManager = new TestAuditManager();
        DurabilityTestUtils$.MODULE$.initializeTestAuditManager(testAuditManager, this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$time(), this.replicaManager(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$4(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$5(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$6(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$7(), DurabilityTestUtils$.MODULE$.initializeTestAuditManager$default$8());
        testAuditManager.startAuditManager();
        Assertions.assertEquals((int)testAuditManager.instance().db().getTopicPartitionsForAudit().length(), (int)0);
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt1, 1, true));
        testAuditManager.instance().doWork();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$1(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Register partition failed");
        Option option = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option instanceof Some) {
            PartitionState value = (PartitionState)((Some)option).value();
            Assertions.assertEquals((int)1, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID1, (Object)value.topicId());
        } else {
            Predef$.MODULE$.assert(false);
        }
        testAuditManager.submitAuditRequest((AuditManagerRequest)new RegisterPartitionRequest(tt2, 2, true));
        testAuditManager.instance().doWork();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$3(testAuditManager)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DurabilityEventsMaterializeTest.$anonfun$testMissingDeletePartition$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertNotEquals((Object)testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition()), (Object)None$.MODULE$, (String)"Deleted partition before fetch");
        Option option2 = testAuditManager.instance().db().fetchPartitionState(tt1.topicPartition());
        if (option2 instanceof Some) {
            PartitionState value = (PartitionState)((Some)option2).value();
            Assertions.assertEquals((int)2, (int)value.latestLocalEpoch());
            Assertions.assertEquals((Object)exclusiveRandomUUID2, (Object)value.topicId());
            return;
        }
        Predef$.MODULE$.assert(false);
    }

    @Test
    public void testStaleEventWithoutTopicId() {
        TopicIdPartition zeroTp1 = new TopicIdPartition(this.zeroTopicId(), new TopicPartition(this.tp1().topic(), this.tp1().partition()));
        HashMap epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
        PartitionState ps1 = PartitionState$.MODULE$.apply(this.tp1().topicPartition().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, epochChain, this.topicId(), 0L);
        ps1.latestTimestamp_$eq(1000L);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Validator validatorInst = new Validator(this, replicaManager){

            public boolean isInSync(Set<Object> isr) {
                return false;
            }
        };
        this.kafka$durability$materialization$DurabilityEventsMaterializeTest$$db().addPartition(this.tp1().topicPartition(), ps1);
        DurabilityEventsMaterialize materialize = new DurabilityEventsMaterialize(this, replicaManager, validatorInst){
            private final Validator validator;

            public Validator validator() {
                return this.validator;
            }
            {
                this.validator = validatorInst$9;
            }
        };
        RetentionChangeEvent event1 = RetentionChangeEvent$.MODULE$.apply(this.tp1(), 1000L, -1L, 3, -1L, -1L);
        ConsumerRecord record1 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 5000L, TimestampType.CREATE_TIME, -1, -1, (Object)event1.serializeKey(), (Object)event1.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertTrue((boolean)materialize.materialize(record1));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
        RetentionChangeEvent event2 = RetentionChangeEvent$.MODULE$.apply(zeroTp1, 1000L, -1L, 4, -1L, -1L);
        ConsumerRecord record2 = new ConsumerRecord(this.tp1().topicPartition().topic(), this.tp1().topicPartition().partition(), 0L, 10000L, TimestampType.CREATE_TIME, -1, -1, (Object)event2.serializeKey(), (Object)event2.serializeValue(), (Headers)new RecordHeaders(), Optional.empty());
        Assertions.assertFalse((boolean)materialize.materialize(record2));
        Assertions.assertTrue((ps1.latestTimestamp() == 5000L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$testDeletePartition$1(TestAuditManager testAuditManager$1) {
        return testAuditManager$1.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$1(TestAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$2() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$testMissingDeletePartition$3(TestAuditManager testAuditManager$2) {
        return testAuditManager$2.instance().db().getTopicPartitionsForAudit().length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testMissingDeletePartition$4() {
        return "";
    }
}

