/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.db;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import kafka.durability.db.PartitionState;
import kafka.durability.db.PartitionState$;
import kafka.durability.db.serdes.EpochChain;
import kafka.durability.db.serdes.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]3Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002BB\u0016\u0001A\u0003%\u0001\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\t\rq\u0002\u0001\u0015!\u0003/\u0011\u001di\u0004A1A\u0005\u0002yBaA\u0011\u0001!\u0002\u0013y\u0004\"B\"\u0001\t\u0003!\u0005\"B*\u0001\t\u0003!\u0005\"B+\u0001\t\u0003!%A\u0005)beRLG/[8o'R\fG/\u001a+fgRT!!\u0004\b\u0002\u0005\u0011\u0014'BA\b\u0011\u0003)!WO]1cS2LG/\u001f\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011\u0001D\u0001\u0003iB,\u0012\u0001\t\t\u0003C%j\u0011A\t\u0006\u0003G\u0011\naaY8n[>t'BA\t&\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\n\u0005)\u0012#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013AC3q_\u000eD7\t[1j]V\ta\u0006\u0005\u00030iYJT\"\u0001\u0019\u000b\u0005E\u0012\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003gY\t!bY8mY\u0016\u001cG/[8o\u0013\t)\u0004GA\u0004ICNDW*\u00199\u0011\u0005U9\u0014B\u0001\u001d\u0017\u0005\rIe\u000e\u001e\t\u0003+iJ!a\u000f\f\u0003\t1{gnZ\u0001\fKB|7\r[\"iC&t\u0007%\u0001\u0002qgV\tq\b\u0005\u0002\u001e\u0001&\u0011\u0011\t\u0004\u0002\u000f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0003\r\u00018\u000fI\u0001\u0013!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0016\u001cH\u000fF\u0001F!\t)b)\u0003\u0002H-\t!QK\\5uQ\tA\u0011\n\u0005\u0002K#6\t1J\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u00059{\u0015a\u00026va&$XM\u001d\u0006\u0003!\u001e\nQA[;oSRL!AU&\u0003\tQ+7\u000f^\u0001%\u001f2$\u0007+\u0019:uSRLwN\\*uCR,G)Z:fe&\fG.\u001b>bi&|g\u000eV3ti\"\u0012\u0011\"S\u0001%\u001d\u0016<\b+\u0019:uSRLwN\\*uCR,G)Z:fe&\fG.\u001b>bi&|g\u000eV3ti\"\u0012!\"\u0013")
public class PartitionStateTest {
    private final TopicPartition tp = new TopicPartition("test", 1);
    private final HashMap<Object, Object> epochChain = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)50L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)80L))}));
    private final PartitionState ps = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), Uuid.randomUuid(), 0L);

    public TopicPartition tp() {
        return this.tp;
    }

    public HashMap<Object, Object> epochChain() {
        return this.epochChain;
    }

    public PartitionState ps() {
        return this.ps;
    }

    @Test
    public void PartitionStateTest() {
        PartitionState orig = this.ps();
        Assertions.assertEquals((long)this.ps().highWatermark(), (long)orig.highWatermark());
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        builder.finish(orig.serialize(builder));
        Assertions.assertEquals((Object)PartitionState$.MODULE$.apply(PartitionInfo.getRootAsPartitionInfo((ByteBuffer)builder.dataBuffer())), (Object)orig, (String)"PartitionState not consistent after recovery");
    }

    @Test
    public void OldPartitionStateDeserializationTest() {
        PartitionState orig = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), Uuid.ZERO_UUID, 0L);
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        PartitionInfo.startEpochChainVector((FlatBufferBuilder)builder, (int)this.epochChain().size());
        this.epochChain().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PartitionStateTest.$anonfun$OldPartitionStateDeserializationTest$1(builder, x0$1)));
        int epochChainsOffset = builder.endVector();
        builder.startObject(10);
        PartitionInfo.addRetentionSize((FlatBufferBuilder)builder, (long)orig.retentionSz());
        PartitionInfo.addRetentionTime((FlatBufferBuilder)builder, (long)orig.retentionMs());
        PartitionInfo.addTotalMessages((FlatBufferBuilder)builder, (long)orig.totalMessages());
        PartitionInfo.addExternalLostMessages((FlatBufferBuilder)builder, (long)orig.externalLostMessages());
        PartitionInfo.addCommittedStartOffset((FlatBufferBuilder)builder, (long)orig.committedStartOffset());
        PartitionInfo.addHighWatermark((FlatBufferBuilder)builder, (long)orig.highWatermark());
        PartitionInfo.addStartOffset((FlatBufferBuilder)builder, (long)orig.startOffset());
        PartitionInfo.addEpochChain((FlatBufferBuilder)builder, (int)epochChainsOffset);
        PartitionInfo.addPartition((FlatBufferBuilder)builder, (int)orig.partition());
        builder.finish(PartitionInfo.endPartitionInfo((FlatBufferBuilder)builder));
        Assertions.assertEquals((Object)PartitionState$.MODULE$.apply(PartitionInfo.getRootAsPartitionInfo((ByteBuffer)builder.dataBuffer())), (Object)orig);
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void NewPartitionStateDeserializationTest() {
        topicId = Uuid.randomUuid();
        orig = PartitionState$.MODULE$.apply(this.tp().partition(), 1L, 100L, 0L, 2L, 100L, 3600L, 1024L, this.epochChain(), topicId, 0L);
        Assertions.assertEquals((long)this.ps().highWatermark(), (long)orig.highWatermark());
        builder = new FlatBufferBuilder(1024);
        builder.finish(orig.serialize(builder));
        state = PartitionInfo.getRootAsPartitionInfo((ByteBuffer)builder.dataBuffer());
        epochChainMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), state.epochChainLength() - 1).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$NewPartitionStateDeserializationTest$1$adapted(scala.collection.mutable.HashMap kafka.durability.db.serdes.PartitionInfo java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)((HashMap)epochChainMap, (PartitionInfo)state));
        if (this.ps().partition() != state.partition() || this.ps().startOffset() != state.startOffset() || this.ps().highWatermark() != state.highWatermark() || this.ps().committedStartOffset() != state.committedStartOffset() || this.ps().externalLostMessages() != state.externalLostMessages() || this.ps().totalMessages() != state.totalMessages() || this.ps().retentionMs() != state.retentionTime() || this.ps().retentionSz() != state.retentionSize()) ** GOTO lbl-1000
        v0 = this.ps().epochChain();
        if (!(v0 != null ? v0.equals(epochChainMap) == false : epochChainMap != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
    }

    public static final /* synthetic */ int $anonfun$OldPartitionStateDeserializationTest$1(FlatBufferBuilder builder$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int k = x0$1._1$mcI$sp();
        long v = x0$1._2$mcJ$sp();
        int n = EpochChain.createEpochChain((FlatBufferBuilder)builder$1, (int)k, (long)v);
        return n;
    }

    public static final /* synthetic */ Option $anonfun$NewPartitionStateDeserializationTest$1$adapted(HashMap epochChainMap$1, PartitionInfo state$1, Object ii) {
        return epochChainMap$1.put((Object)BoxesRunTime.boxToInteger((int)state$1.epochChain(BoxesRunTime.unboxToInt((Object)ii)).epoch()), (Object)BoxesRunTime.boxToLong((long)state$1.epochChain(BoxesRunTime.unboxToInt((Object)ii)).start()));
    }
}

