/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability;

import java.io.Serializable;
import java.util.Collections;
import kafka.durability.DurabilityMetricsManager;
import kafka.durability.DurabilityMetricsManager$;
import kafka.durability.DurabilityStats;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.DurabilityTestUtils$;
import kafka.durability.materialization.DurabilityLapseType$;
import kafka.durability.materialization.MetricNames$;
import kafka.utils.MockTime;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015B\u0011\u0002\u000b\u0001A\u0002\u0003\u0007I\u0011B\u0015\t\u0013]\u0002\u0001\u0019!a\u0001\n\u0013A\u0004\"\u0003 \u0001\u0001\u0004\u0005\t\u0015)\u0003+\u0011%y\u0004\u00011AA\u0002\u0013%\u0001\tC\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\"I\u0011\n\u0001a\u0001\u0002\u0003\u0006K!\u0011\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\n-C\u0011b\u0014\u0001A\u0002\u0003\u0007I\u0011\u0002)\t\u0013I\u0003\u0001\u0019!A!B\u0013a\u0005\"C*\u0001\u0001\u0004\u0005\r\u0011\"\u0003U\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005]\u0001\u0001\u0007\t\u0011)Q\u0005+\"IQ\f\u0001a\u0001\u0002\u0004%IA\u0018\u0005\nE\u0002\u0001\r\u00111A\u0005\n\rD\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015B0\t\u000b\u0019\u0004A\u0011A4\t\u000bM\u0004A\u0011A4\t\u000ba\u0004A\u0011A4\t\u000bi\u0004A\u0011A4\t\u000bq\u0004A\u0011A4\t\u000by\u0004A\u0011B@\u00039\u0011+(/\u00192jY&$\u00180T3ue&\u001c7/T1oC\u001e,'\u000fV3ti*\u0011\u0011DG\u0001\u000bIV\u0014\u0018MY5mSRL(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u0005A\u0012\u0001\u0002;j[\u0016,\u0012A\u000b\t\u0003WUj\u0011\u0001\f\u0006\u0003[9\nQ!\u001e;jYNT!a\f\u0019\u0002\r\r|W.\\8o\u0015\tY\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c-\u0005\u0011!\u0016.\\3\u0002\u0011QLW.Z0%KF$\"!\u000f\u001f\u0011\u0005}Q\u0014BA\u001e!\u0005\u0011)f.\u001b;\t\u000fu\u001a\u0011\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\t\u0011\t\u0005\u0002C\t6\t1I\u0003\u0002@]%\u0011Qi\u0011\u0002\b\u001b\u0016$(/[2t\u0003-iW\r\u001e:jGN|F%Z9\u0015\u0005eB\u0005bB\u001f\u0007\u0003\u0003\u0005\r!Q\u0001\t[\u0016$(/[2tA\u0005\u0011Q.\\\u000b\u0002\u0019B\u0011q%T\u0005\u0003\u001db\u0011\u0001\u0004R;sC\nLG.\u001b;z\u001b\u0016$(/[2t\u001b\u0006t\u0017mZ3s\u0003\u0019iWn\u0018\u0013fcR\u0011\u0011(\u0015\u0005\b{%\t\t\u00111\u0001M\u0003\riW\u000eI\u0001\u0003iB,\u0012!\u0016\t\u0003-^k\u0011AL\u0005\u00031:\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004ua~#S-\u001d\u000b\u0003smCq!\u0010\u0007\u0002\u0002\u0003\u0007Q+A\u0002ua\u0002\nAA\\1nKV\tq\f\u0005\u0002WA&\u0011\u0011M\f\u0002\u000b\u001b\u0016$(/[2OC6,\u0017\u0001\u00038b[\u0016|F%Z9\u0015\u0005e\"\u0007bB\u001f\u0010\u0003\u0003\u0005\raX\u0001\u0006]\u0006lW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002s!\u0012\u0011#\u001b\t\u0003UFl\u0011a\u001b\u0006\u0003Y6\f1!\u00199j\u0015\tqw.A\u0004kkBLG/\u001a:\u000b\u0005A\u001c\u0014!\u00026v]&$\u0018B\u0001:l\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001#'V\u00147)\u0019;fO>\u0014\u0018\u0010T8ti6+7o]1hKNlU\r\u001e:jGN$Vm\u001d;)\u0005I)\bC\u00016w\u0013\t98N\u0001\u0003UKN$\u0018aC'fiJL7m\u001d+fgRD#aE;\u0002-5+GO]5dg\u0016C\bo\\:f\t\u0016d\u0017-\u001f+fgRD#\u0001F;\u0002-5+GO]5dg\"+\u0017\r\u001c;i\u0007\",7m\u001b+fgRD#!F;\u0002'\u0019LG\u000e^3s\u001b\u0016$(/[2t\u0005ft\u0015-\\3\u0015\r\u0005\u0005\u0011qAA\u0010!\u0011y\u00121A0\n\u0007\u0005\u0015\u0001EA\u0003BeJ\f\u0017\u0010\u0003\u0004^-\u0001\u0007\u0011\u0011\u0002\t\u0005\u0003\u0017\tIB\u0004\u0003\u0002\u000e\u0005U\u0001cAA\bA5\u0011\u0011\u0011\u0003\u0006\u0004\u0003'a\u0012A\u0002\u001fs_>$h(C\u0002\u0002\u0018\u0001\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;\u0011aa\u0015;sS:<'bAA\fA!)qH\u0006a\u0001\u0003\u0002")
public class DurabilityMetricsManagerTest {
    private Time time;
    private Metrics metrics;
    private DurabilityMetricsManager mm;
    private TopicPartition tp;
    private MetricName name;

    private Time time() {
        return this.time;
    }

    private void time_$eq(Time x$1) {
        this.time = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    private DurabilityMetricsManager mm() {
        return this.mm;
    }

    private void mm_$eq(DurabilityMetricsManager x$1) {
        this.mm = x$1;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    private void tp_$eq(TopicPartition x$1) {
        this.tp = x$1;
    }

    private MetricName name() {
        return this.name;
    }

    private void name_$eq(MetricName x$1) {
        this.name = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.time_$eq((Time)new MockTime());
        this.metrics_$eq(new Metrics(new MetricConfig(), Collections.emptyList(), this.time()));
        this.mm_$eq(DurabilityMetricsManager$.MODULE$.apply("0", this.metrics(), this.time(), DurabilityMetricsManager$.MODULE$.apply$default$4()));
        this.tp_$eq(new TopicPartition("test", 0));
        this.name_$eq(DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", this.metrics()));
    }

    @Test
    public void SubCategoryLostMessagesMetricsTest() {
        this.mm().resetDurabilityRunSpan(5);
        MetricName hwMetrics = DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics());
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.HighWatermark(), 15L);
        Assertions.assertEquals((long)this.mm().totalLostMessages(), (long)15L, (String)"Variable totalLostMessages not set to 15");
        Assertions.assertEquals((long)((DurabilityMetricsManager.LostMessage)this.mm().externalLostMessageMetricsMap().apply((Object)DurabilityLapseType$.MODULE$.HighWatermark())).count(), (long)15L, (String)"Variable highWatermarkLostMessages not set to 15");
        Assertions.assertEquals((Object)this.metrics().metric(hwMetrics).metricValue(), (Object)BoxesRunTime.boxToLong((long)15L), (String)"Metrics value is not 15, same as totalLostMessages");
        this.mm().resetDurabilityRunSpan(10);
        this.mm().totalLostMessages_$eq(0L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.HighWatermark(), 1L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.StartOffset(), 10L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.LeaderElection(), 100L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.EpochChange(), 1000L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.OtherCustomerFacing(), 10000L);
        this.mm().reportDurabilityLoss(DurabilityLapseType$.MODULE$.NonCustomerFacing(), 100000L);
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.StartOffset().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)10L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.LeaderElection().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)100L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.EpochChange().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1000L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.OtherCustomerFacing().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)10000L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalLostMessages(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L));
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName(MetricNames$.MODULE$.TotalLostMessages(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)111111L));
        Assertions.assertEquals((int)DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().size(), (int)2, (String)"Tag count for 'high_watermark_lost_messages' metrics is not 2");
        Assertions.assertEquals(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().get("durability_run_counter"), (Object)"10", (String)"Metrics 'high_watermark_lost_messages' should have a tag 'durability_run_counter' with a value of '10'");
        Assertions.assertEquals(DurabilityTestUtils$.MODULE$.metricNameWithTag(MetricNames$.MODULE$.ExternalLostMessages(), DurabilityLapseType$.MODULE$.HighWatermark().toString(), this.metrics()).tags().get("durability_lapse_type"), (Object)DurabilityLapseType$.MODULE$.HighWatermark().toString(), (String)"Metrics 'high_watermark_lost_messages' should have a tag 'durability_lapse_type' with a value of 'HighWatermark'");
    }

    @Test
    public void MetricsTest() {
        Assertions.assertEquals((int)this.metrics().metrics().size(), (int)2, (String)"Expected metrics count is not 3");
        Assertions.assertEquals((int)DurabilityTestUtils$.MODULE$.metricName("total_lost_messages", this.metrics()).tags().size(), (int)0, (String)"Metrics 'total_lost_messages' should not have any tags");
        this.mm().reportDurabilityLoss(15L);
        Assertions.assertEquals((long)this.mm().totalLostMessages(), (long)15L, (String)"Variable totalLostMessages not set to 15");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)this.metrics().metric(this.name()).metricValue(), (Object)BoxesRunTime.boxToLong((long)15L), (String)"Metrics value is not 15, same as totalLostMessages");
        this.mm().reportDurabilityLoss(20L);
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS() * 1L / 4L);
        Assertions.assertEquals((Object)this.metrics().metric(this.name()).metricValue(), (Object)BoxesRunTime.boxToLong((long)15L), (String)"Metrics value is not 15, same as totalLostMessages");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS() * 3L / 4L);
        Assertions.assertEquals((Object)this.metrics().metric(this.name()).metricValue(), (Object)BoxesRunTime.boxToLong((long)35L), (String)"Metrics value is not 35, same as totalLostMessages");
        this.mm().resetDurabilityRunSpan(5);
        Assertions.assertEquals((int)this.metrics().metrics().size(), (int)(3 + this.mm().externalLostMessageMetricsMap().size()), (String)new StringBuilder(32).append("Total registered metrics is not ").append(3 + this.mm().externalLostMessageMetricsMap().size()).toString());
        Assertions.assertEquals((int)DurabilityTestUtils$.MODULE$.metricName("total_messages", this.metrics()).tags().size(), (int)1, (String)"Tag count for 'total_messages' metrics is not 1");
        Assertions.assertEquals((int)DurabilityTestUtils$.MODULE$.metricName("external_lost_messages", this.metrics()).tags().size(), (int)2, (String)"Tag count for 'external_lost_messages' metrics is not 1");
        this.mm().updateStats(this.tp(), new DurabilityStats(1000L, 50L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName("total_messages", this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L), (String)"Metrics value for 'total_messages' should not be updated before job completion");
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag("external_lost_messages", DurabilityLapseType$.MODULE$.PeriodicalAudit().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L), (String)"Metrics value for 'external_lost_messages' should not be updated before job completion");
        this.mm().resetDurabilityRunSpan(10);
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName("total_messages", this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)1000L), (String)"Metrics value for 'total_messages' is not 1000");
        this.mm().resetDurabilityRunSpan(15);
        this.mm().updateStats(this.tp(), new DurabilityStats(2000L, 25L));
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName("total_messages", this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L), (String)"Metrics value for 'total_messages' has not reset to 0");
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricNameWithTag("external_lost_messages", DurabilityLapseType$.MODULE$.PeriodicalAudit().toString(), this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L), (String)"Metrics value for 'external_lost_messages' should not be updated before job completion");
        this.mm().resetDurabilityRunSpan(30);
        Assertions.assertEquals((Object)this.metrics().metric(DurabilityTestUtils$.MODULE$.metricName("total_messages", this.metrics())).metricValue(), (Object)BoxesRunTime.boxToLong((long)2000L), (String)"Metrics value for 'total_messages' is not 2000 after job completion.");
    }

    @Test
    public void MetricsExposeDelayTest() {
        Assertions.assertEquals((Object)this.metrics().metric(this.name()).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L), (String)"Metrics value is not 0, same as totalLostMessages");
        this.mm().reportDurabilityLoss(10L);
        this.mm().reportDurabilityLoss(20L);
        this.mm().reportDurabilityLoss(30L);
        Assertions.assertEquals((Object)this.metrics().metric(this.name()).metricValue(), (Object)BoxesRunTime.boxToLong((long)0L), (String)"Metrics value is not 0, same as totalLostMessages");
        this.time().sleep(DurabilityAuditConstants$.MODULE$.LOSS_COUNTER_EXPOSE_UPDATE_TIME_MS());
        Assertions.assertEquals((Object)this.metrics().metric(this.name()).metricValue(), (Object)BoxesRunTime.boxToLong((long)60L), (String)"Metrics value is not 60, same as totalLostMessages");
    }

    @Test
    public void MetricsHealthCheckTest() {
        String brokerId2 = "2";
        String brokerId3 = "3";
        Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.filterMetricsByName("health_check", this.metrics()))).isEmpty());
        long t0 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId2, t0);
        KafkaMetric hcMetrics = this.metrics().metric(this.filterMetricsByName("health_check", this.metrics())[0]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
        this.time().sleep(5L);
        long t1 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId3, t1);
        hcMetrics = this.metrics().metric(this.filterMetricsByName("health_check", this.metrics())[1]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId3, hcMetrics.metricName().tags().get("broker_src"));
        this.time().sleep(10L);
        long t2 = this.time().milliseconds();
        this.mm().updateHealthCheck(brokerId3, t2);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId3, hcMetrics.metricName().tags().get("broker_src"));
        this.mm().updateHealthCheck(brokerId2, t2);
        this.mm().updateHealthCheck(brokerId3, t1);
        hcMetrics = this.metrics().metric(this.filterMetricsByName("health_check", this.metrics())[0]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId2, hcMetrics.metricName().tags().get("broker_src"));
        hcMetrics = this.metrics().metric(this.filterMetricsByName("health_check", this.metrics())[1]);
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)1L), (Object)hcMetrics.metricValue());
        Assertions.assertEquals((Object)brokerId3, hcMetrics.metricName().tags().get("broker_src"));
    }

    private MetricName[] filterMetricsByName(String name, Metrics metrics) {
        return (MetricName[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metrics.metrics().keySet().toArray())).map((Function1 & Serializable & scala.Serializable)x$1 -> (MetricName)x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MetricName.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DurabilityMetricsManagerTest.$anonfun$filterMetricsByName$2(name, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$filterMetricsByName$2(String name$1, MetricName x$2) {
        return x$2.name().equals(name$1);
    }
}

