/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001B\u001f?\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004Y\u0001\u0001\u0006IA\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00028\t\rU\u0004\u0001\u0015!\u0003p\u0011\u001d1\bA1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niD\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0006\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003?A\u0011\"a\n\u0001\u0005\u0004%I!!\b\t\u0011\u0005%\u0002\u0001)A\u0005\u0003?A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%I!!\f\t\u0011\u0005e\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0010\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003/B\u0011\"!\u001a\u0001\u0005\u0004%I!a\u001a\t\u0011\u0005=\u0004\u0001)A\u0005\u0003SB\u0011\"!\u001d\u0001\u0005\u0004%I!a\u001a\t\u0011\u0005M\u0004\u0001)A\u0005\u0003SB\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005u\u0005\u0001)A\u0005\u0003sB\u0011\"a(\u0001\u0005\u0004%I!!)\t\u0011\u0005=\u0006\u0001)A\u0005\u0003GC\u0011\"!-\u0001\u0005\u0004%I!a-\t\u0011\u0005m\u0006\u0001)A\u0005\u0003kCq!!0\u0001\t\u0013\ty\fC\u0004\u0002B\u0002!\t!a0\t\u000f\u0005e\u0007\u0001\"\u0001\u0002@\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0006bBAq\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003K\u0004A\u0011AA`\u0011\u001d\tI\u000f\u0001C\u0001\u0003\u007fCq!!<\u0001\t\u0003\ty\fC\u0004\u0002r\u0002!\t!a0\t\u000f\u0005U\b\u0001\"\u0001\u0002@\"9\u0011\u0011 \u0001\u0005\u0002\u0005}\u0006bBA\u007f\u0001\u0011%\u0011q \u0005\b\u00057\u0001A\u0011AA`\u0005\r\"&/\u00198tC\u000e$\u0018n\u001c8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d+fgRT!a\u0010!\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u0003\n\u000b1bY8pe\u0012Lg.\u0019;pe*\t1)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u001dB\u0011q\nA\u0007\u0002}\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\n\u000baa]3sm\u0016\u0014\u0018BA,U\u00055iU\r^1eCR\f7)Y2iK\u0006qQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u0001\\!\taF-D\u0001^\u0015\tqv,A\u0004dY&,g\u000e^:\u000b\u0005\r\u0003'BA1c\u0003\u0019\t\u0007/Y2iK*\t1-A\u0002pe\u001eL!!Z/\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\nq\u0002\u001e=o'R\fG/Z'b]\u0006<WM]\u000b\u0002SB\u0011qJ[\u0005\u0003Wz\u0012q\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u0002!QDhn\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013A\u00039beRLG/[8ocU\tq\u000e\u0005\u0002qg6\t\u0011O\u0003\u0002s?\u000611m\\7n_:L!\u0001^9\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006Y\u0001/\u0019:uSRLwN\\\u0019!\u0003)\u0001\u0018M\u001d;ji&|gNM\u0001\fa\u0006\u0014H/\u001b;j_:\u0014\u0004%A\u0004ce>\\WM]\u0019\u0016\u0003i\u0004\"\u0001]>\n\u0005q\f(\u0001\u0002(pI\u0016\f\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001332+\t\t)\u0001\u0005\u0003\u0002\b\u0005EQBAA\u0005\u0015\u0011\tY!!\u0004\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\tAA[1wC&!\u00111CA\u0005\u0005\u0019\u0019FO]5oO\u0006\tBO]1og\u0006\u001cG/[8oC2LE-\r\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0014!\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333A\u0005Y\u0001O]8ek\u000e,'/\u001332+\t\ty\u0002E\u0002H\u0003CI1!a\tI\u0005\u0011auN\\4\u0002\u0019A\u0014x\u000eZ;dKJLE-\r\u0011\u0002\u0017A\u0014x\u000eZ;dKJLEMM\u0001\raJ|G-^2fe&#'\u0007I\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0016\u0005\u0005=\u0002cA$\u00022%\u0019\u00111\u0007%\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005\tB.Y:u!J|G-^2fe\u0016\u0003xn\u00195\u0002%1\f7\u000f\u001e)s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017'\u0006\u0002\u0002@A\u0019q)!\u0011\n\u0007\u0005\r\u0003JA\u0002J]R\f1\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8oc\u0001\n!\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8oe\u0005\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c83A\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r[\u0001\u0012G>|'\u000fZ5oCR|'/\u00129pG\"\u0004\u0013\u0001\u0004;y]RKW.Z8vi6\u001b\u0018!\u0004;y]RKW.Z8vi6\u001b\b%A\u0005uq:\u0014Vm];miV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL9\u0002\u0011I,\u0017/^3tiNLA!!\u0019\u0002\\\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0002\u0015QDhNU3tk2$\b%\u0001\u0007uq:lU\r^1eCR\f\u0017'\u0006\u0002\u0002jA\u0019q*a\u001b\n\u0007\u00055dHA\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018-A\u0007uq:lU\r^1eCR\f\u0017\u0007I\u0001\ribtW*\u001a;bI\u0006$\u0018MM\u0001\u000eibtW*\u001a;bI\u0006$\u0018M\r\u0011\u0002-\r\f\u0007\u000f^;sK\u0012,%O]8sg\u000e\u000bG\u000e\u001c2bG.,\"!!\u001f\u0011\r\u0005m\u0014\u0011QAC\u001b\t\tiHC\u0002\u0002\u0000\t\fq!\\8dW&$x.\u0003\u0003\u0002\u0004\u0006u$AD!sOVlWM\u001c;DCB$xN\u001d\t\b\u000f\u0006\u001d\u00151RAL\u0013\r\tI\t\u0013\u0002\n\rVt7\r^5p]F\u0002B!!$\u0002\u00146\u0011\u0011q\u0012\u0006\u0004\u0003#\u000b\u0018\u0001\u00039s_R|7m\u001c7\n\t\u0005U\u0015q\u0012\u0002\u0007\u000bJ\u0014xN]:\u0011\u0007\u001d\u000bI*C\u0002\u0002\u001c\"\u0013A!\u00168ji\u000692-\u00199ukJ,G-\u0012:s_J\u001c8)\u00197mE\u0006\u001c7\u000eI\u0001\u0005i&lW-\u0006\u0002\u0002$B!\u0011QUAV\u001b\t\t9KC\u0002\u0002*F\fQ!\u001e;jYNLA!!,\u0002(\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\u0016\u0005\u0005U\u0006cA(\u00028&\u0019\u0011\u0011\u0018 \u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'/A\bdQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0003%iwnY6DC\u000eDW\r\u0006\u0002\u0002\u0018\u0006\u00013\u000f[8vY\u0012|e\u000e\\=Xe&$X\r\u0016=o\u0007>l\u0007\u000f\\3uS>twJ\\2fQ\r\t\u0014Q\u0019\t\u0005\u0003\u000f\f).\u0004\u0002\u0002J*!\u00111ZAg\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001f\f\t.A\u0004kkBLG/\u001a:\u000b\u0007\u0005M'-A\u0003kk:LG/\u0003\u0003\u0002X\u0006%'\u0001\u0002+fgR\fqf\u001d5pk2$w)\u001a8fe\u0006$X-R7qifl\u0015\r],iK:tuNU3rk\u0016\u001cHo](viN$\u0018M\u001c3j]\u001eD3AMAc\u0003)\u001a\bn\\;mI\u001e+g.\u001a:bi\u0016\u0014V-];fgR\u0004VM\u001d)beRLG/[8o!\u0016\u0014(I]8lKJD3aMAc\u00035\u001a\bn\\;mI:{GoR3oKJ\fG/\u001a(foJ+\u0017/^3tiNLeMU3rk\u0016\u001cH/\u00138GY&<\u0007\u000e\u001e\u0015\u0004i\u0005\u0015\u0017aJ:i_VdGmU6jaN+g\u000eZ'be.,'o],iK:dU-\u00193fe:{GOR8v]\u0012D3!NAc\u0003I\u001a\bn\\;mIN\u000bg/\u001a$pe2\u000bG/\u001a:XQ\u0016tG*Z1eKJ,fn\u001b8po:\u0014U\u000f\u001e(pi\u00063\u0018-\u001b7bE2,\u0007f\u0001\u001c\u0002F\u0006A4\u000f[8vY\u0012\u0014V-\\8wK6\u000b'o[3sg\u001a{'\u000f\u0016=o!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8QCJ$\u0018\u000e^5p]\u0016k\u0017n\u001a:bi\u0016$\u0007fA\u001c\u0002F\u000694\u000f[8vY\u0012\u001cu.\u001c9mKR,\u0017\t\u001d9f]\u0012$v\u000eT8h\u001f:,e\u000e\u001a+y]^CWM\\*f]\u0012l\u0015M]6feN\u001cVoY2fK\u0012D3\u0001OAc\u0003U\u001a\bn\\;mI\u0006\u0013wN\u001d;BaB,g\u000e\u001a+p\u0019><wJ\\#oIRChn\u00165f]:{GoQ8pe\u0012Lg.\u0019;pe\u0016\u0013(o\u001c:)\u0007e\n)-\u0001 tQ>,H\u000e\u001a*fiJL\u0018\t\u001d9f]\u0012$v\u000eT8h\u001f:,e\u000e\u001a+y]^CWM\\\"p_J$\u0017N\\1u_Jtu\u000e^!wC&d\u0017M\u00197f\u000bJ\u0014xN\u001d\u0015\u0004u\u0005\u0015\u0017!E2sK\u0006$X\rU5e\u000bJ\u0014xN]'baR!!\u0011\u0001B\f!!\u0011\u0019A!\u0003\u0003\u000e\tEQB\u0001B\u0003\u0015\u0011\u00119!!\u0004\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u0017\u0011)AA\u0004ICNDW*\u00199\u0011\t\u0005\u001d!qB\u0005\u0005\u0003G\tI\u0001E\u0004\u0003\u0004\tMq.a#\n\t\tU!Q\u0001\u0002\u0004\u001b\u0006\u0004\bb\u0002B\rw\u0001\u0007\u00111R\u0001\u0007KJ\u0014xN]:\u0002;MDw.\u001e7e\u0007J,\u0017\r^3NKR\u0014\u0018nY:P]N#\u0018M\u001d;j]\u001eD3\u0001PAc\u0001")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)Mockito.mock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerId1(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L);
    private final TransactionMetadata txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerId2(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L);
    private final ArgumentCaptor<Function1<Errors, BoxedUnit>> capturedErrorsCallback = ArgumentCaptor.forClass(Function1.class);
    private final MockTime time = new MockTime();
    private final TransactionMarkerChannelManager channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), this.metadataCache(), this.networkClient(), this.txnStateManager(), (Time)this.time());

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    private TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    private ArgumentCaptor<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1()));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2()));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId1()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId2()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata2()))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldOnlyWriteTxnCompletionOnce() {
        Future<Try> addMarkerFuture;
        this.mockCache();
        TxnTransitMetadata expectedTransition = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$1(this, expectedTransition, x$1);
            return BoxedUnit.UNIT;
        });
        ExecutorService executor = Executors.newFixedThreadPool(1);
        this.txnMetadata2().lock().lock();
        try {
            addMarkerFuture = executor.submit(() -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), expectedTransition)));
            RequestHeader header = new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1);
            WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(Collections.singletonMap(Predef$.MODULE$.long2Long(this.producerId2()), Collections.singletonMap(this.partition1(), Errors.NONE)));
            ClientResponse clientResponse = new ClientResponse(header, null, null, this.time().milliseconds(), this.time().milliseconds(), false, null, null, (AbstractResponse)response);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$4(this, clientResponse)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TransactionMarkerChannelManagerTest.$anonfun$shouldOnlyWriteTxnCompletionOnce$5());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            this.txnMetadata2().lock().unlock();
            executor.shutdown();
        }
        Assertions.assertNotNull(addMarkerFuture);
        Assertions.assertTrue((boolean)addMarkerFuture.get().isSuccess(), (String)new StringBuilder(38).append("Add marker task failed with exception ").append(addMarkerFuture.get().get()).toString());
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)expectedTransition), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map requests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldNotGenerateNewRequestsIfRequestInFlight() {
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.networkClient().hasInFlightRequests((String)ArgumentMatchers.eq((Object)this.broker1().idString())))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.channelManager().unsentRequests().put(this.broker2(), new ClientRequest(this.broker2().idString(), null, 0, "0", this.time().milliseconds(), true, 10000, null, null));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.networkClient().hasInFlightRequests((String)ArgumentMatchers.eq((Object)this.broker1().idString())))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.channelManager().unsentRequests().clearUnsentRequests(this.broker2());
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map requests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)requests);
        Assertions.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)Node.noNode())).thenReturn((Object)new Some((Object)this.broker1())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)2, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(ApiKeys.WRITE_TXN_MARKERS.latestVersion(), Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map firstDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker2()), (Object)expectedBroker2Request)})), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.broker1()), (Object)expectedBroker1Request)})), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), this.txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assertions.assertEquals((int)2, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)2, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assertions.assertEquals((int)1, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)1, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(this, txnTransitionMetadata2, x$2);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$2(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$3 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(this, x$3);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$2(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager())).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)PrepareCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    @Test
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError() {
        this.mockCache();
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition1().topic()), ArgumentMatchers.eq((int)this.partition1().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker1()));
        Mockito.when((Object)this.metadataCache().getPartitionLeaderEndpoint((String)ArgumentMatchers.eq((Object)this.partition2().topic()), ArgumentMatchers.eq((int)this.partition2().partition()), (ListenerName)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)this.broker2()));
        TxnTransitMetadata txnTransitionMetadata2 = this.txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$4 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(this, x$4);
            return BoxedUnit.UNIT;
        }).thenAnswer(x$5 -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(this, txnTransitionMetadata2, x$5);
            return BoxedUnit.UNIT;
        });
        this.channelManager().addTxnMarkersToSend(this.coordinatorEpoch(), this.txnResult(), this.txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$3(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        ((TransactionStateManager)Mockito.verify((Object)this.txnStateManager(), (VerificationMode)Mockito.times((int)2))).appendTransactionToLog((String)ArgumentMatchers.eq((Object)this.transactionalId2()), ArgumentMatchers.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)ArgumentMatchers.eq((Object)txnTransitionMetadata2), (Function1)this.capturedErrorsCallback().capture(), (Function1)ArgumentMatchers.any(), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((int)0, (int)this.channelManager().numTxnsWithPendingMarkers());
        Assertions.assertEquals((int)0, (int)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.txnMetadata2().pendingState());
        Assertions.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.txnMetadata2().state());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return var2_2;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x0$1))));
        Assertions.assertEquals((int)1, (int)metrics.count((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x0$2))));
    }

    public static final /* synthetic */ void $anonfun$shouldOnlyWriteTxnCompletionOnce$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata expectedTransition$1, InvocationOnMock x$1) {
        $this.txnMetadata2().completeTransitionTo(expectedTransition$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$shouldOnlyWriteTxnCompletionOnce$4(TransactionMarkerChannelManagerTest $this, ClientResponse clientResponse$1) {
        Iterable requests = $this.channelManager().generateRequests();
        if (requests.nonEmpty()) {
            Assertions.assertEquals((int)1, (int)requests.size());
            ((RequestAndCompletionHandler)requests.head()).handler().onComplete(clientResponse$1);
            return true;
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$shouldOnlyWriteTxnCompletionOnce$5() {
        return "Timed out waiting for expected WriteTxnMarkers request";
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$1, InvocationOnMock x$2) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$1);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$2(WriteTxnMarkersResponse response$1, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$1));
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(TransactionMarkerChannelManagerTest $this, InvocationOnMock x$3) {
        $this.txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$2(WriteTxnMarkersResponse response$2, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$2));
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(TransactionMarkerChannelManagerTest $this, InvocationOnMock x$4) {
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$2(TransactionMarkerChannelManagerTest $this, TxnTransitMetadata txnTransitionMetadata2$2, InvocationOnMock x$5) {
        $this.txnMetadata2().completeTransitionTo(txnTransitionMetadata2$2);
        ((Function1)$this.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$3(WriteTxnMarkersResponse response$3, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.WRITE_TXN_MARKERS, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$3));
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$2._1()).getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
        boolean bl = string != null && string.equals(string2);
        return bl;
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.txnTimeoutMs = 0;
    }
}

