/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Collections;
import kafka.cluster.Partition;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaCoordinatorConfig$;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.quota.QuotaStateManagerTest$;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.QuotaValue$;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.CompressionCodec;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001\u0002!B\u0001!CQa\u0014\u0001\u0005\u0002ACqa\u0015\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004Y\u0001\u0001\u0006I!\u0016\u0005\b3\u0002\u0011\r\u0011\"\u0001U\u0011\u0019Q\u0006\u0001)A\u0005+\"91\f\u0001b\u0001\n\u0003a\u0006B\u00028\u0001A\u0003%Q\fC\u0004p\u0001\t\u0007I\u0011\u00019\t\re\u0004\u0001\u0015!\u0003r\u0011\u001dQ\bA1A\u0005\u0002mDa! \u0001!\u0002\u0013a\bb\u0002@\u0001\u0005\u0004%\t\u0001\u001d\u0005\u0007\u007f\u0002\u0001\u000b\u0011B9\t\u0011\t\u0003!\u0019!C\u0001\u0003\u0003A\u0001\"!\u0003\u0001A\u0003%\u00111\u0001\u0005\n\u0003\u0017\u0001!\u0019!C\u0001\u0003\u0003A\u0001\"!\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#A\u0001\"a\b\u0001A\u0003%\u00111\u0003\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0003\t\u0019\u0003C\u0006\u00022\u0001\u0001\r\u00111A\u0005\u0002\u0005M\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003KA1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002D!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011AA*\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0012\t\u0017\u0005e\u0003\u00011AA\u0002\u0013\u0005\u00111\f\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0003\t)\u0007C\u0006\u0002j\u0001\u0001\r\u0011!Q!\n\u0005u\u0003bCA6\u0001\u0001\u0007\t\u0019!C\u0001\u0003[B1\"!\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002x!Y\u00111\u0010\u0001A\u0002\u0003\u0005\u000b\u0015BA8\u0011-\ti\b\u0001a\u0001\u0002\u0004%\t!a \t\u0017\u00055\u0005\u00011AA\u0002\u0013\u0005\u0011q\u0012\u0005\f\u0003'\u0003\u0001\u0019!A!B\u0013\t\t\tC\u0006\u0002\u0016\u0002\u0001\r\u00111A\u0005\u0002\u0005]\u0005bCAR\u0001\u0001\u0007\t\u0019!C\u0001\u0003KC1\"!+\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001a\"Y\u00111\u0016\u0001A\u0002\u0003\u0007I\u0011AAW\u0011-\tY\r\u0001a\u0001\u0002\u0004%\t!!4\t\u0017\u0005E\u0007\u00011A\u0001B\u0003&\u0011q\u0016\u0005\f\u0003'\u0004\u0001\u0019!a\u0001\n\u0003\t)\u000eC\u0006\u0002^\u0002\u0001\r\u00111A\u0005\u0002\u0005}\u0007bCAr\u0001\u0001\u0007\t\u0011)Q\u0005\u0003/D\u0011\"!:\u0001\u0001\u0004%\t!a:\t\u0013\t\r\u0001\u00011A\u0005\u0002\t\u0015\u0001\u0002\u0003B\u0005\u0001\u0001\u0006K!!;\t\u0017\t-\u0001\u00011AA\u0002\u0013\u0005!Q\u0002\u0005\f\u0005/\u0001\u0001\u0019!a\u0001\n\u0003\u0011I\u0002C\u0006\u0003\u001e\u0001\u0001\r\u0011!Q!\n\t=\u0001\"\u0003B\u0010\u0001\t\u0007I\u0011\u0002B\u0011\u0011!\u0011I\u0003\u0001Q\u0001\n\t\r\u0002b\u0002B\u0016\u0001\u0011\u0005!Q\u0006\u0005\b\u0005\u000b\u0002A\u0011\u0001B\u0017\u0011\u001d\u0011y\u0005\u0001C\u0001\u0005[AqA!\u0017\u0001\t\u0003\u0011i\u0003C\u0004\u0003^\u0001!\tA!\f\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003.!9!Q\r\u0001\u0005\u0002\t5\u0002b\u0002B5\u0001\u0011\u0005!Q\u0006\u0005\b\u0005[\u0002A\u0011\u0002B8\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005\u001fCqAa(\u0001\t\u0013\u0011\t\u000bC\u0004\u00032\u0002!IAa-\u0003+E+x\u000e^1Ti\u0006$X-T1oC\u001e,'\u000fV3ti*\u0011!iQ\u0001\u0006cV|G/\u0019\u0006\u0003\t\u0016\u000b1bY8pe\u0012Lg.\u0019;pe*\ta)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0005C\u0001&N\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002#B\u0011!\u000bA\u0007\u0002\u0003\u0006\u0019b.^7Rk>$\u0018m\u001d)beRLG/[8ogV\tQ\u000b\u0005\u0002K-&\u0011qk\u0013\u0002\u0004\u0013:$\u0018\u0001\u00068v[F+x\u000e^1t!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0005ce>\\WM]%e\u0003%\u0011'o\\6fe&#\u0007%\u0001\u000brk>$\u0018\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002;B\u0019a,Y2\u000e\u0003}S!\u0001Y&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002c?\n\u00191+Z9\u0011\u0005\u0011dW\"A3\u000b\u0005\u0019<\u0017AB2p[6|gN\u0003\u0002GQ*\u0011\u0011N[\u0001\u0007CB\f7\r[3\u000b\u0003-\f1a\u001c:h\u0013\tiWM\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002+E,x\u000e^1U_BL7\rU1si&$\u0018n\u001c8tA\u0005QQM\u001c;jif$\u0016\u0010]3\u0016\u0003E\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\t1\fgn\u001a\u0006\u0002m\u0006!!.\u0019<b\u0013\tA8O\u0001\u0004TiJLgnZ\u0001\fK:$\u0018\u000e^=UsB,\u0007%A\u0006f]RLG/\u001f(b[\u0016\u001cX#\u0001?\u0011\u0007y\u000b\u0017/\u0001\u0007f]RLG/\u001f(b[\u0016\u001c\b%A\u0005rk>$\u0018\rV=qK\u0006Q\u0011/^8uCRK\b/\u001a\u0011\u0016\u0005\u0005\r\u0001c\u0001&\u0002\u0006%\u0019\u0011qA&\u0003\r\u0011{WO\u00197f\u0003\u0019\tXo\u001c;bA\u0005)Qo]1hK\u00061Qo]1hK\u0002\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eQ)A\u0002m_\u001eLA!!\b\u0002\u0018\tIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000bF\u0003\u0015)H/\u001b7t\u0013\u0011\ty#!\u000b\u0003\u00115{7m\u001b+j[\u0016\f\u0001\u0002^5nK~#S-\u001d\u000b\u0005\u0003k\tY\u0004E\u0002K\u0003oI1!!\u000fL\u0005\u0011)f.\u001b;\t\u0013\u0005uR#!AA\u0002\u0005\u0015\u0012a\u0001=%c\u0005)A/[7fA\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014XCAA#!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&\u000b\u000611/\u001a:wKJLA!a\u0014\u0002J\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!!\u000e\u0002V!I\u0011Q\b\r\u0002\u0002\u0003\u0007\u0011QI\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005u\u0003\u0003BA\u000b\u0003?JA!!\u0019\u0002\u0018\tQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR!\u0011QGA4\u0011%\tidGA\u0001\u0002\u0004\ti&A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013!E9v_R\f7\u000b^1uK6\u000bg.Y4feV\u0011\u0011q\u000e\t\u0004%\u0006E\u0014bAA:\u0003\n\t\u0012+^8uCN#\u0018\r^3NC:\fw-\u001a:\u0002+E,x\u000e^1Ti\u0006$X-T1oC\u001e,'o\u0018\u0013fcR!\u0011QGA=\u0011%\tiDHA\u0001\u0002\u0004\ty'\u0001\nrk>$\u0018m\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013!\u00039beRLG/[8o+\t\t\t\t\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9)R\u0001\bG2,8\u000f^3s\u0013\u0011\tY)!\"\u0003\u0013A\u000b'\u000f^5uS>t\u0017!\u00049beRLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005E\u0005\"CA\u001fC\u0005\u0005\t\u0019AAA\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\b[\u0016$(/[2t+\t\tI\n\u0005\u0003\u0002\u001c\u0006}UBAAO\u0015\r\t)*Z\u0005\u0005\u0003C\u000biJA\u0004NKR\u0014\u0018nY:\u0002\u00175,GO]5dg~#S-\u001d\u000b\u0005\u0003k\t9\u000bC\u0005\u0002>\u0011\n\t\u00111\u0001\u0002\u001a\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0007rk>$\u0018-\u00128uSRLWm]\u000b\u0003\u0003_\u0003b!!-\u0002B\u0006\u0015g\u0002BAZ\u0003{sA!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003s;\u0015A\u0002\u001fs_>$h(C\u0001M\u0013\r\tylS\u0001\ba\u0006\u001c7.Y4f\u0013\r\u0011\u00171\u0019\u0006\u0004\u0003\u007f[\u0005c\u0001*\u0002H&\u0019\u0011\u0011Z!\u0003\u0017E+x\u000e^1F]RLG/_\u0001\u0012cV|G/Y#oi&$\u0018.Z:`I\u0015\fH\u0003BA\u001b\u0003\u001fD\u0011\"!\u0010(\u0003\u0003\u0005\r!a,\u0002\u001dE,x\u000e^1F]RLG/[3tA\u0005Q\u0011/^8uCZ\u000bG.^3\u0016\u0005\u0005]\u0007c\u0001*\u0002Z&\u0019\u00111\\!\u0003\u0015E+x\u000e^1WC2,X-\u0001\brk>$\u0018MV1mk\u0016|F%Z9\u0015\t\u0005U\u0012\u0011\u001d\u0005\n\u0003{Q\u0013\u0011!a\u0001\u0003/\f1\"];pi\u00064\u0016\r\\;fA\u0005i\u0011/^8uCZ\u000bG.^3NCB,\"!!;\u0011\u0011\u0005-\u0018\u0011_A{\u0003/l!!!<\u000b\u0007\u0005=x,A\u0004nkR\f'\r\\3\n\t\u0005M\u0018Q\u001e\u0002\u0004\u001b\u0006\u0004\b\u0003BA|\u0003\u007ftA!!?\u0002|B\u0019\u0011QW&\n\u0007\u0005u8*\u0001\u0004Qe\u0016$WMZ\u0005\u0004q\n\u0005!bAA\u007f\u0017\u0006\t\u0012/^8uCZ\u000bG.^3NCB|F%Z9\u0015\t\u0005U\"q\u0001\u0005\n\u0003{i\u0013\u0011!a\u0001\u0003S\fa\"];pi\u00064\u0016\r\\;f\u001b\u0006\u0004\b%\u0001\u0007rk>$\u0018-\u00128ue&,7/\u0006\u0002\u0003\u0010A1\u0011\u0011WAa\u0005#\u00012A\u0015B\n\u0013\r\u0011)\"\u0011\u0002\u000b#V|G/Y#oiJL\u0018\u0001E9v_R\fWI\u001c;sS\u0016\u001cx\fJ3r)\u0011\t)Da\u0007\t\u0013\u0005u\u0002'!AA\u0002\t=\u0011!D9v_R\fWI\u001c;sS\u0016\u001c\b%A\u0006rk>$\u0018mQ8oM&<WC\u0001B\u0012!\r\u0011&QE\u0005\u0004\u0005O\t%AF)v_R\f7i\\8sI&t\u0017\r^8s\u0007>tg-[4\u0002\u0019E,x\u000e^1D_:4\u0017n\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005U\u0002f\u0001\u001b\u00032A!!1\u0007B!\u001b\t\u0011)D\u0003\u0003\u00038\te\u0012aA1qS*!!1\bB\u001f\u0003\u001dQW\u000f]5uKJT1Aa\u0010k\u0003\u0015QWO\\5u\u0013\u0011\u0011\u0019E!\u000e\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r)$\u0011\n\t\u0005\u0005g\u0011Y%\u0003\u0003\u0003N\tU\"!C!gi\u0016\u0014X)Y2i\u0003Q!Xm\u001d;M_\u0006$\u0017+^8uCJ+7m\u001c:eg\"\u001aaGa\u0015\u0011\t\tM\"QK\u0005\u0005\u0005/\u0012)D\u0001\u0003UKN$\u0018a\u0004;fgR\u001cFo\u001c:f#V|G/Y:)\u0007]\u0012\u0019&\u0001\tuKN$X\t\u001f9je\u0016\fVo\u001c;bg\"\u001a\u0001Ha\u0015\u0002AQ,7\u000f^#ya&\u0014X-U;pi\u0006\u001cx+\u001b;i/JLG/\u001a$bS2,(/\u001a\u0015\u0004s\tM\u0013!\u0006;fgR\fVo\u001c;b\u000b:$(/\u001f)beNLgn\u001a\u0015\u0004u\tM\u0013!\u0007;fgR\fVo\u001c;b)>l'm\u001d;p]\u0016\u0004\u0016M]:j]\u001eD3a\u000fB*\u0003Y)\u0007\u0010]3diF+x\u000e^1SK\u000e|'\u000fZ:M_\u0006$G\u0003CA\u001b\u0005c\u0012)Ha \t\r\tMD\b1\u0001d\u0003m9'o\\;q\u001b\u0016$\u0018\rZ1uCR{\u0007/[2QCJ$\u0018\u000e^5p]\"9!q\u000f\u001fA\u0002\te\u0014aC:uCJ$xJ\u001a4tKR\u00042A\u0013B>\u0013\r\u0011ih\u0013\u0002\u0005\u0019>tw\rC\u0004\u0003\u0002r\u0002\rAa!\u0002\u000fI,7m\u001c:egB!!Q\u0011BF\u001b\t\u00119IC\u0002\u0003\n\u0016\faA]3d_J$\u0017\u0002\u0002BG\u0005\u000f\u0013Q\"T3n_JL(+Z2pe\u0012\u001cH\u0003\u0003B=\u0005#\u0013YJ!(\t\u000f\tMU\b1\u0001\u0003\u0016\u00069An\\4N_\u000e\\\u0007\u0003BA\u000b\u0005/KAA!'\u0002\u0018\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\u00119(\u0010a\u0001\u0005sBqA!!>\u0001\u0004\u0011\u0019)A\tde\u0016\fG/Z)v_R\f'+Z2pe\u0012$bAa)\u0003*\n5\u0006\u0003\u0002BC\u0005KKAAa*\u0003\b\na1+[7qY\u0016\u0014VmY8sI\"9!1\u0016 A\u0002\u0005\u0015\u0017aC9v_R\fWI\u001c;jifDqAa,?\u0001\u0004\u0011\t\"\u0001\u0006rk>$\u0018-\u00128uef\fA#\u001a=qK\u000e$\u0018\t\u001d9f]\u0012lUm]:bO\u0016\u001cH\u0003\u0002B[\u0005\u000b\u0004bAa.\u0003>\n\u0005WB\u0001B]\u0015\r\u0011YL[\u0001\tK\u0006\u001c\u00180\\8dW&!!q\u0018B]\u0005\u001d\u0019\u0015\r\u001d;ve\u0016\u0004bA\u0018BbG\n\r\u0015bAAz?\"9!qY A\u0002\t%\u0017AB3se>\u00148\u000f\u0005\u0004\u00022\u0006\u0005'1\u001a\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*\u0019!\u0011[3\u0002\u0011A\u0014x\u000e^8d_2LAA!6\u0003P\n1QI\u001d:peN\u0004")
public class QuotaStateManagerTest {
    private final int numQuotasPartitions;
    private final int brokerId;
    private final Seq<TopicPartition> quotaTopicPartitions = new .colon.colon((Object)new TopicPartition("_confluent-quotas", 0), (List)new .colon.colon((Object)new TopicPartition("_confluent-quotas", 1), (List)Nil$.MODULE$));
    private final String entityType;
    private final Seq<String> entityNames = new .colon.colon((Object)"entityName0", (List)new .colon.colon((Object)"entityName1", (List)Nil$.MODULE$));
    private final String quotaType;
    private final double quota;
    private final double usage;
    private final LogConfig logConfig = new LogConfig(Collections.emptyMap(), LogConfig$.MODULE$.$lessinit$greater$default$2());
    private MockTime time;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private QuotaStateManager quotaStateManager;
    private Partition partition;
    private Metrics metrics;
    private Seq<QuotaEntity> quotaEntities;
    private QuotaValue quotaValue;
    private scala.collection.mutable.Map<String, QuotaValue> quotaValueMap = new HashMap();
    private Seq<QuotaEntry> quotaEntries;
    private final QuotaCoordinatorConfig quotaConfig;

    public int numQuotasPartitions() {
        return this.numQuotasPartitions;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Seq<TopicPartition> quotaTopicPartitions() {
        return this.quotaTopicPartitions;
    }

    public String entityType() {
        return this.entityType;
    }

    public Seq<String> entityNames() {
        return this.entityNames;
    }

    public String quotaType() {
        return this.quotaType;
    }

    public double quota() {
        return this.quota;
    }

    public double usage() {
        return this.usage;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public void time_$eq(MockTime x$1) {
        this.time = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public void quotaStateManager_$eq(QuotaStateManager x$1) {
        this.quotaStateManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public Seq<QuotaEntity> quotaEntities() {
        return this.quotaEntities;
    }

    public void quotaEntities_$eq(Seq<QuotaEntity> x$1) {
        this.quotaEntities = x$1;
    }

    public QuotaValue quotaValue() {
        return this.quotaValue;
    }

    public void quotaValue_$eq(QuotaValue x$1) {
        this.quotaValue = x$1;
    }

    public scala.collection.mutable.Map<String, QuotaValue> quotaValueMap() {
        return this.quotaValueMap;
    }

    public void quotaValueMap_$eq(scala.collection.mutable.Map<String, QuotaValue> x$1) {
        this.quotaValueMap = x$1;
    }

    public Seq<QuotaEntry> quotaEntries() {
        return this.quotaEntries;
    }

    public void quotaEntries_$eq(Seq<QuotaEntry> x$1) {
        this.quotaEntries = x$1;
    }

    private QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    @BeforeEach
    public void setUp() {
        this.metrics_$eq(new Metrics());
        this.time_$eq(new MockTime());
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.logManager_$eq((LogManager)EasyMock.createNiceMock(LogManager.class));
        this.quotaStateManager_$eq(new QuotaStateManager(this.quotaConfig(), (Scheduler)this.time().scheduler(), this.replicaManager(), this.metrics(), (Time)this.time()));
        this.quotaStateManager().startup((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.numQuotasPartitions(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
        this.partition_$eq((Partition)EasyMock.niceMock(Partition.class));
        this.quotaEntities_$eq((Seq<QuotaEntity>)((Seq)this.entityNames().map((Function1 & Serializable & scala.Serializable)name -> new QuotaEntity((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), name)}))), Seq$.MODULE$.canBuildFrom())));
        this.quotaValue_$eq(QuotaValue$.MODULE$.loadValue(this.usage(), false, this.quota(), this.time().milliseconds()));
        this.quotaValueMap().update((Object)this.quotaType(), (Object)this.quotaValue());
        this.quotaEntries_$eq((Seq<QuotaEntry>)((Seq)this.quotaEntities().map((Function1 & Serializable & scala.Serializable)entity -> new QuotaEntry(entity, this.time().milliseconds()), Seq$.MODULE$.canBuildFrom())));
        this.quotaEntries().foreach((Function1 & Serializable & scala.Serializable)quotaEntry -> {
            quotaEntry.putQuotaValue(this.brokerId(), this.quotaType(), this.quotaValue());
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getLogConfig((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.logConfig())).anyTimes();
    }

    @AfterEach
    public void tearDown() {
        this.quotaStateManager().shutdown();
        this.metrics().close();
    }

    @Test
    public void testLoadQuotaRecords() {
        long startOffset = 10L;
        SimpleRecord quotaRecord = this.createQuotaRecord((QuotaEntity)this.quotaEntities().head(), (QuotaEntry)this.quotaEntries().head());
        TopicPartition quotaTopicPartition = (TopicPartition)this.quotaTopicPartitions().apply(this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().head()));
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{quotaRecord});
        this.expectQuotaRecordsLoad(quotaTopicPartition, startOffset, records);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaStateManager().loadQuotaState(quotaTopicPartition.partition(), 0);
        this.time().sleep(5L);
        QuotaEntry loadedQuota = this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head());
        Assertions.assertEquals((Object)this.quotaEntities().head(), (Object)loadedQuota.quotaEntity());
        int loadedBroker = ((Tuple2)loadedQuota.computedQuotas().head())._1$mcI$sp();
        Assertions.assertEquals((int)this.brokerId(), (int)loadedBroker);
        scala.collection.mutable.Map loadedQuotaValues = (scala.collection.mutable.Map)((Tuple2)loadedQuota.computedQuotas().head())._2();
        Assertions.assertEquals(this.quotaValueMap(), (Object)loadedQuotaValues);
        EasyMock.verify((Object[])new Object[]{this.replicaManager(), this.logManager()});
    }

    @Test
    public void testStoreQuotas() {
        .colon.colon expectedErrors = new .colon.colon((Object)Errors.NONE, (List)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$));
        Capture<Map<TopicPartition, MemoryRecords>> capturedRecords = this.expectAppendMessages((Seq<Errors>)expectedErrors);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        ObjectRef maybeErrors = ObjectRef.create((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$1))), (Object)None$.MODULE$), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        QuotaStateManager qual$1 = this.quotaStateManager();
        scala.collection.immutable.Map x$12 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.quotaTopicPartitions().apply(BoxesRunTime.unboxToInt((Object)i))), (Object)new .colon.colon((Object)((QuotaEntry)this.quotaEntries().apply(BoxesRunTime.unboxToInt((Object)i))), (List)Nil$.MODULE$)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)errors -> {
            QuotaStateManagerTest.callback$1(errors, maybeErrors);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$3 = qual$1.storeQuotas$default$3();
        qual$1.storeQuotas((Map)x$12, (Function1)x$2, x$3);
        ((Map)maybeErrors.elem).foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testStoreQuotas$5$adapted((Seq)expectedErrors, arg_0));
        Assertions.assertTrue((boolean)capturedRecords.hasCaptured());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numQuotasPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            List records = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)((MapLike)capturedRecords.getValue()).apply(this.quotaTopicPartitions().apply(partition))).records()).asScala()).toList();
            Assertions.assertEquals((int)1, (int)records.size());
            Record record = (Record)records.head();
            QuotaEntity capturedQuotaKey = QuotaStateManager$.MODULE$.readMessageKey(record.key());
            Assertions.assertEquals((Object)this.quotaEntities().apply(partition), (Object)capturedQuotaKey);
            Option capturedQuotaValue = QuotaStateManager$.MODULE$.readMessageValue((QuotaEntity)this.quotaEntities().apply(partition), record.value());
            int capturedBrokerId = ((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._1$mcI$sp();
            Assertions.assertEquals((int)this.brokerId(), (int)capturedBrokerId);
            scala.collection.mutable.Map capturedQuotaValues = (scala.collection.mutable.Map)((Tuple2)((QuotaEntry)capturedQuotaValue.get()).computedQuotas().head())._2();
            Assertions.assertEquals(this.quotaValueMap(), (Object)capturedQuotaValues);
        });
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testExpireQuotas() {
        Capture recordsCapture = EasyMock.newCapture();
        Capture callbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)recordsCapture), (Function1)EasyMock.capture((Capture)callbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, callbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture callbackCapture$1;

            public void answer() {
                ((Function1)this.callbackCapture$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callbackCapture$1 = callbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotas$1(this.quotaStateManager(), arg_0));
        this.time().sleep(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().head()).updateConsumptionAndRecomputeQuotas(0, new QuotaConsumption(ClientQuotaType.PRODUCE.toString(), 1000.0, false), 100000.0, this.time().milliseconds(), Long.MAX_VALUE);
        this.time().sleep(2 * (this.quotaConfig().quotasExpirationTimeMs() / 3));
        Assertions.assertEquals((int)1, (int)((MapLike)recordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapLike)recordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)((MapLike)recordsCapture.getValue()).values().head()).records()).asScala()).size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    @Test
    public void testExpireQuotasWithWriteFailure() {
        Capture firstRecordsCapture = EasyMock.newCapture();
        Capture firstCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)firstRecordsCapture), (Function1)EasyMock.capture((Capture)firstCallbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, firstCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture firstCallbackCapture$1;

            public void answer() {
                ((Function1)this.firstCallbackCapture$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NOT_ENOUGH_REPLICAS, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.firstCallbackCapture$1 = firstCallbackCapture$1;
            }
        }).once();
        Capture secondRecordsCapture = EasyMock.newCapture();
        Capture secondCallbackCapture = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)secondRecordsCapture), (Function1)EasyMock.capture((Capture)secondCallbackCapture), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, secondCallbackCapture){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture secondCallbackCapture$1;

            public void answer() {
                ((Function1)this.secondCallbackCapture$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("_confluent-quotas", this.$outer.quotaStateManager().partitionFor((QuotaEntity)this.$outer.quotaEntities().apply(1)))), (Object)new ProduceResponse.PartitionResponse(Errors.NONE, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.secondCallbackCapture$1 = secondCallbackCapture$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.quotaEntities().foreach(arg_0 -> QuotaStateManagerTest.$anonfun$testExpireQuotasWithWriteFailure$1(this.quotaStateManager(), arg_0));
        this.quotaStateManager().getAndMaybePutQuota((QuotaEntity)this.quotaEntities().apply(1)).lastUpdatedTimestamp_$eq(this.time().milliseconds() - (long)(this.quotaConfig().quotasExpirationTimeMs() * 2));
        this.time().sleep(this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapLike)firstRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapLike)firstRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)((MapLike)firstRecordsCapture.getValue()).values().head()).records()).asScala()).size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
        this.time().sleep(this.quotaConfig().quotasExpirationIntervalMs());
        Assertions.assertEquals((int)1, (int)((MapLike)secondRecordsCapture.getValue()).keySet().size());
        Assertions.assertEquals((Object)new TopicPartition("_confluent-quotas", this.quotaStateManager().partitionFor((QuotaEntity)this.quotaEntities().apply(1))), (Object)((MapLike)secondRecordsCapture.getValue()).keySet().head());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((AbstractRecords)((MapLike)secondRecordsCapture.getValue()).values().head()).records()).asScala()).size());
        Assertions.assertTrue((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().head()).isDefined());
        Assertions.assertFalse((boolean)this.quotaStateManager().getQuota((QuotaEntity)this.quotaEntities().apply(1)).isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaEntryParsing() {
        void var8_8;
        void var7_7;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        QuotaEntry quotaEntry = new QuotaEntry(quotaEntity, this.time().milliseconds());
        quotaEntry.putQuotaValue(0, this.quotaType(), this.quotaValue());
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] valueBytes = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        Record quotaRecord = (Record)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, valueBytes), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()).records()).asScala()).head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        void keyStringOpt2 = var7_7;
        void valueStringOpt2 = var8_8;
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)keyStringOpt2);
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(37).append("computedQuotas:").append(quotaEntry.computedQuotasString()).append(",lastUpdatedTimestamp:").append(this.time().milliseconds()).toString()), (Object)valueStringOpt2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaTombstoneParsing() {
        void var6_6;
        void var5_5;
        QuotaEntity quotaEntity = new QuotaEntity((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.entityType()), this.entityNames().head())})));
        byte[] keyBytes = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        Record quotaRecord = (Record)((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(keyBytes, null), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()).records()).asScala()).head();
        Tuple2 tuple2 = QuotaStateManager$.MODULE$.formatRecordKeyAndValue(quotaRecord);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option keyStringOpt = (Option)tuple2._1();
        Option valueStringOpt = (Option)tuple2._2();
        void keyStringOpt2 = var5_5;
        void valueStringOpt2 = var6_6;
        Assertions.assertEquals((Object)new Some((Object)new StringBuilder(26).append("quota_entity::entityTypes=").append(quotaEntity.entityTypes()).toString()), (Object)keyStringOpt2);
        Assertions.assertEquals((Object)new Some((Object)"<DELETE>"), (Object)valueStringOpt2);
    }

    private void expectQuotaRecordsLoad(TopicPartition groupMetadataTopicPartition, long startOffset, MemoryRecords records) {
        AbstractLog logMock = (AbstractLog)EasyMock.mock(AbstractLog.class);
        EasyMock.expect((Object)this.replicaManager().getLog(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)logMock));
        long endOffset = this.expectQuotaRecordsLoad(logMock, startOffset, records);
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(groupMetadataTopicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.replay((Object[])new Object[]{logMock});
        EasyMock.expect((Object)this.replicaManager().logManager()).andStubReturn((Object)this.logManager());
        this.logManager().abortAndPauseCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.logManager().resumeCleaning(groupMetadataTopicPartition);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.logManager()});
    }

    private long expectQuotaRecordsLoad(AbstractLog logMock, long startOffset, MemoryRecords records) {
        long endOffset = startOffset + (long)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{fileRecordsMock});
        return endOffset;
    }

    private SimpleRecord createQuotaRecord(QuotaEntity quotaEntity, QuotaEntry quotaEntry) {
        byte[] quotaRecordKey = QuotaStateManager$.MODULE$.quotaEntryKey(quotaEntity);
        byte[] quotaRecordValue = QuotaStateManager$.MODULE$.quotaEntryValue(quotaEntry);
        return new SimpleRecord(quotaRecordKey, quotaRecordValue);
    }

    /*
     * WARNING - void declaration
     */
    private Capture<Map<TopicPartition, MemoryRecords>> expectAppendMessages(Seq<Errors> errors) {
        void var3_3;
        Capture capturedCallback = EasyMock.newCapture();
        Capture capturedRecords = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), (AppendOrigin)EasyMock.eq((Object)AppendOrigin.Coordinator$.MODULE$), (Map)EasyMock.capture((Capture)capturedRecords), (Function1)EasyMock.capture((Capture)capturedCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (RequestLocal)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedCallback, errors){
            private final /* synthetic */ QuotaStateManagerTest $outer;
            private final Capture capturedCallback$1;
            private final Seq errors$1;

            public void answer() {
                ((Function1)this.capturedCallback$1.getValue()).apply((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.numQuotasPartitions()).map((Function1 & Serializable & scala.Serializable)i -> $anon$5.$anonfun$answer$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            }

            public static final /* synthetic */ Tuple2 $anonfun$answer$1($anon$5 $this, int i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc($this.$outer.quotaTopicPartitions().apply(i)), (Object)new ProduceResponse.PartitionResponse((Errors)$this.errors$1.apply(i), 0L, -1L, 0L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.capturedCallback$1 = capturedCallback$1;
                this.errors$1 = errors$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(kafka.coordinator.quota.QuotaStateManagerTest$$anon$5 java.lang.Object )}, serializedLambda);
            }
        });
        return var3_3;
    }

    private static final void callback$1(Map errors, ObjectRef maybeErrors$1) {
        maybeErrors$1.elem = (Map)errors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Errors error = (Errors)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)new Some((Object)error));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testStoreQuotas$5(Seq expectedErrors$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int i = x0$1._1$mcI$sp();
            Option errorOpt = (Option)x0$1._2();
            if (errorOpt instanceof Some) {
                Errors error = (Errors)((Some)errorOpt).value();
                Assertions.assertEquals((Object)expectedErrors$1.apply(i), (Object)error);
                return;
            }
            if (None$.MODULE$.equals(errorOpt)) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(51).append("Partition ").append(i).append(" was not processed by the append callback").toString());
                return;
            }
            throw new MatchError((Object)errorOpt);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotas$1(QuotaStateManager eta$0$1$1, QuotaEntity quotaEntity) {
        return eta$0$1$1.getAndMaybePutQuota(quotaEntity);
    }

    public static final /* synthetic */ QuotaEntry $anonfun$testExpireQuotasWithWriteFailure$1(QuotaStateManager eta$0$1$2, QuotaEntity quotaEntity) {
        return eta$0$1$2.getAndMaybePutQuota(quotaEntity);
    }

    public QuotaStateManagerTest() {
        this.numQuotasPartitions = 2;
        this.brokerId = 0;
        this.entityType = "entityType";
        this.quotaType = "quotaType";
        this.quota = 60000.0;
        this.usage = 3000.0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        int x$1 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasLoadBufferSize());
        int x$2 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicPartitions());
        int x$3 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicSegmentBytes());
        short x$4 = Predef$.MODULE$.Short2short(config.confluentConfig().quotasTopicReplicationFactor());
        CompressionCodec x$5 = config.confluentConfig().quotasTopicCompressionCodec();
        int x$6 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasTopicAppendTimeoutMs());
        String x$7 = config.confluentConfig().quotasTopicPlacementConstraints();
        int x$8 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationTimeMs());
        int x$9 = Predef$.MODULE$.Integer2int(config.confluentConfig().quotasExpirationIntervalMs());
        int x$10 = QuotaCoordinatorConfig$.MODULE$.apply$default$10();
        this.quotaConfig = new QuotaCoordinatorConfig(x$2, x$4, x$3, x$1, x$5, x$6, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ Object $anonfun$testStoreQuotas$5$adapted(Seq expectedErrors$1, Tuple2 x0$1) {
        QuotaStateManagerTest.$anonfun$testStoreQuotas$5(expectedErrors$1, x0$1);
        return BoxedUnit.UNIT;
    }
}

