/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.Block$;
import kafka.controller.Continue$;
import kafka.controller.ContinueMerged$;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00041\u0001\u0001\u0006I!\f\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u0019I\u0004\u0001)A\u0005g!9!\b\u0001b\u0001\n\u0003\u0011\u0004BB\u001e\u0001A\u0003%1\u0007C\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\u0019\u0003\u0001\u0015!\u0003?\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015I\u0006\u0001\"\u0001I\u0011\u0015Y\u0006\u0001\"\u0001I\u0011\u0015i\u0006\u0001\"\u0001I\u0011\u0015y\u0006\u0001\"\u0001I\u0011\u0015\t\u0007\u0001\"\u0001I\u0011\u0015\u0019\u0007\u0001\"\u0001I\u0011\u0015i\u0006\u0001\"\u0001f\u0011\u0015i\u0007\u0001\"\u0001I\u0011\u0015y\u0007\u0001\"\u0001I\u0011\u0015\t\b\u0001\"\u0001I\u0011\u0015\u0019\b\u0001\"\u0001I\u0011\u0015)\b\u0001\"\u0001I\u0011\u00159\b\u0001\"\u0001I\u0011\u00159\b\u0001\"\u0001z\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\t9R\u000b\u001d3bi\u0016lU\r^1eCR\f')\u0019;dQR+7\u000f\u001e\u0006\u00039u\t!bY8oiJ|G\u000e\\3s\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001*!\tQ\u0003!D\u0001\u001c\u0003E\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u000b\u0002[A\u0011!FL\u0005\u0003_m\u0011\u0011c\u0015;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\u0002\u000f\t\u0013xn[3saU\t1\u0007\u0005\u00025o5\tQG\u0003\u00027;\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u001d6\u0005\u0019\u0011%o\\6fe\u0006A!I]8lKJ\u0004\u0004%A\u0004Ce>\\WM]\u0019\u0002\u0011\t\u0013xn[3sc\u0001\nqA\u0011:pW\u0016\u00148/F\u0001?!\ryDiM\u0007\u0002\u0001*\u0011\u0011IQ\u0001\nS6lW\u000f^1cY\u0016T!aQ\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002F\u0001\n\u00191+\u001a;\u0002\u0011\t\u0013xn[3sg\u0002\n1\u0003^3ti\n\u000b7/[2Pa\u0016\u0014\u0018\r^5p]N$\u0012!\u0013\t\u0003E)K!aS\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u00155\u0003\"AT,\u000e\u0003=S!\u0001U)\u0002\u0007\u0005\u0004\u0018N\u0003\u0002S'\u00069!.\u001e9ji\u0016\u0014(B\u0001+V\u0003\u0015QWO\\5u\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0014\u0002\u0005)\u0016\u001cH/\u0001\buKN$\u0018\t\u001a3U_BL7-\u00133)\u0005-i\u0015!\u0006;fgR\fE\r\u001a)beRLG/[8o'R\fG/\u001a\u0015\u0003\u00195\u000b!\u0005^3tiB\u0013xnY3tg^KG\u000f[+qI\u0006$X-T3uC\u0012\fG/\u0019\"bi\u000eD\u0007FA\u0007N\u0003I\"Xm\u001d;Qe>\u001cWm]:ICZLgn\u001a(fo\n\u0013xn[3sg^KG\u000f[+qI\u0006$X-T3uC\u0012\fG/\u0019\"bi\u000eD\u0007F\u0001\bN\u0003Y\"Xm\u001d;Qe>\u001cWm]:XSRDW\u000b\u001d3bi\u0016lU\r^1eCR\f')\u0019;dQ\u000e{g\u000e^1j]&twMT3x\u0005J|7.\u001a:tQ\tyQ*\u0001$uKN$\bK]8dKN\u001c\b*\u0019<j]\u001etUm\u001e\"s_.,'o],ji\",\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014\u0015\r^2i\u0007>tG/Y5oS:<g*Z<Ce>\\WM]:)\u0005AiEcA%gW\")q-\u0005a\u0001Q\u0006q\u0001.Y:OK^\u0014%o\\6feN\f\u0004C\u0001\u0012j\u0013\tQ7EA\u0004C_>dW-\u00198\t\u000b1\f\u0002\u0019\u00015\u0002\u001d!\f7OT3x\u0005J|7.\u001a:te\u0005\u0001C/Z:u!J|7-Z:t/&$\b\u000eT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014\u0015\r^2iQ\t\u0011R*A\u0017uKN$\bK]8dKN\u001c\b*Y:OK^\u0014%o\\6feN<\u0016\u000e\u001e5MK\u0006$WM]!oI&\u001b(OQ1uG\"D#aE'\u0002?Q,7\u000f\u001e)s_\u000e,7o],ji\"\u001cFo\u001c9SKBd\u0017nY1CCR\u001c\u0007\u000e\u000b\u0002\u0015\u001b\u0006aC/Z:u!J|7-Z:t\u0011\u0006\u001ch*Z<Ce>\\WM]:XSRD7\u000b^8q%\u0016\u0004H.[2b\u0005\u0006$8\r\u001b\u0015\u0003+5\u000b!\u0005^3tiB\u0013xnY3tg^KG\u000f[%oG>t7/[:uK:$Hk\u001c9jG&#\u0007F\u0001\fN\u0003E!Xm\u001d;Ck&dGMU3rk\u0016\u001cHo\u001d\u0015\u0003/5#\"!\u0013>\t\u000bmD\u0002\u0019\u0001?\u0002\u000fY,'o]5p]B\u0011!%`\u0005\u0003}\u000e\u0012Qa\u00155peR\f!#\\1lKB\u000b'\u000f^5uS>t7\u000b^1uKRA\u00111AA\u001d\u0003\u000b\ny\u0005\u0005\u0003\u0002\u0006\u0005Mb\u0002BA\u0004\u0003[qA!!\u0003\u0002(9!\u00111BA\u0011\u001d\u0011\ti!!\b\u000f\t\u0005=\u0011\u0011\u0004\b\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u0010\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0016bAA\u000e+\u00061\u0011\r]1dQ\u0016L1AHA\u0010\u0015\r\tY\"V\u0005\u0005\u0003G\t)#\u0001\u0004d_6lwN\u001c\u0006\u0004=\u0005}\u0011\u0002BA\u0015\u0003W\tq!\\3tg\u0006<WM\u0003\u0003\u0002$\u0005\u0015\u0012\u0002BA\u0018\u0003c\t\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC*!\u0011\u0011FA\u0016\u0013\u0011\t)$a\u000e\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*!\u0011qFA\u0019\u0011\u001d\tY$\u0007a\u0001\u0003{\t!\u0001\u001e9\u0011\t\u0005}\u0012\u0011I\u0007\u0003\u0003WIA!a\u0011\u0002,\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA$3\u0001\u0007\u0011\u0011J\u0001\u0007Y\u0016\fG-\u001a:\u0011\u0007\t\nY%C\u0002\u0002N\r\u00121!\u00138u\u0011\u001d\t\t&\u0007a\u0001\u0003\u0013\n1\u0002\\3bI\u0016\u0014X\t]8dQ\u0002")
public class UpdateMetadataBatchTest {
    private final StateChangeLogger stateChangeLogger = new StateChangeLogger(0, true, (Option)None$.MODULE$);
    private final Broker Broker0 = Broker$.MODULE$.apply(0, (Seq)new .colon.colon((Object)new EndPoint("localhost", 9090, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)new .colon.colon((Object)new EndPoint("localhost", 9190, new ListenerName("SASL_SSL"), SecurityProtocol.SASL_SSL), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr0"), (Object)"value0")})));
    private final Broker Broker1 = Broker$.MODULE$.apply(1, (Seq)new .colon.colon((Object)new EndPoint("localhost", 9091, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT), (List)new .colon.colon((Object)new EndPoint("localhost", 9191, new ListenerName("SASL_SSL"), SecurityProtocol.SASL_SSL), (List)Nil$.MODULE$)), (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attr1"), (Object)"value1")})));
    private final Set<Broker> Brokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0(), this.Broker1()}));

    public StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Broker Broker0() {
        return this.Broker0;
    }

    public Broker Broker1() {
        return this.Broker1;
    }

    public Set<Broker> Brokers() {
        return this.Brokers;
    }

    @Test
    public void testBasicOperations() {
        UpdateMetadataBatch batch = new UpdateMetadataBatch(0);
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.latestVersion(), (short)batch.version());
        Assertions.assertEquals((int)0, (int)batch.controllerId());
        Assertions.assertEquals((int)0, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)0L, (long)batch.brokerEpoch());
        Assertions.assertFalse((boolean)batch.hasNewBrokers());
        Assertions.assertTrue((boolean)batch.partitions().isEmpty());
        Assertions.assertTrue((boolean)batch.liveBrokers().isEmpty());
        Assertions.assertTrue((boolean)batch.isEmpty());
        TopicPartition tp = new TopicPartition("topic", 0);
        Uuid topicId = Uuid.randomUuid();
        UpdateMetadataRequestData.UpdateMetadataPartitionState tpState = new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeader(0).setLeaderEpoch(0);
        batch.setVersion(ApiKeys.UPDATE_METADATA.oldestVersion()).setControllerId(1).setControllerEpoch(2).setBrokerEpoch(3L).setHasNewBrokers().addPartitionState(tp, tpState).addTopicId(tp.topic(), topicId).setLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0()})));
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.oldestVersion(), (short)batch.version());
        Assertions.assertEquals((int)1, (int)batch.controllerId());
        Assertions.assertEquals((int)2, (int)batch.controllerEpoch());
        Assertions.assertEquals((long)3L, (long)batch.brokerEpoch());
        Assertions.assertTrue((boolean)batch.hasNewBrokers());
        Assertions.assertFalse((boolean)batch.partitions().isEmpty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)tpState)})), (Object)batch.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topic()), (Object)topicId)})), (Object)batch.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0()})), (Object)batch.liveBrokers());
        Assertions.assertFalse((boolean)batch.isEmpty());
    }

    @Test
    public void testAddTopicId() {
        UpdateMetadataBatch batch = new UpdateMetadataBatch(0);
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        String topic = "topic";
        batch.addTopicId(topic, topicId0);
        batch.addTopicId(topic, topicId0);
        Assertions.assertThrows(IllegalStateException.class, () -> batch.addTopicId(topic, topicId1));
    }

    @Test
    public void testAddPartitionState() {
        UpdateMetadataBatch batch = new UpdateMetadataBatch(0);
        TopicPartition tp = new TopicPartition("topic", 0);
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 0));
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 1));
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)1, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
        batch.addPartitionState(tp, this.makePartitionState(tp, 0, 0));
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leader());
        Assertions.assertEquals((int)0, (int)((UpdateMetadataRequestData.UpdateMetadataPartitionState)batch.partitions().apply((Object)tp)).leaderEpoch());
    }

    @Test
    public void testProcessWithUpdateMetadataBatch() {
        this.testProcessWithUpdateMetadataBatch(false, false);
    }

    @Test
    public void testProcessHavingNewBrokersWithUpdateMetadataBatch() {
        this.testProcessWithUpdateMetadataBatch(true, false);
    }

    @Test
    public void testProcessWithUpdateMetadataBatchContainingNewBrokers() {
        this.testProcessWithUpdateMetadataBatch(false, true);
    }

    @Test
    public void testProcessHavingNewBrokersWithUpdateMetadataBatchContainingNewBrokers() {
        this.testProcessWithUpdateMetadataBatch(true, true);
    }

    public void testProcessWithUpdateMetadataBatch(boolean hasNewBrokers1, boolean hasNewBrokers2) {
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        UpdateMetadataBatch batch1 = new UpdateMetadataBatch(0).setVersion((short)(ApiKeys.UPDATE_METADATA.latestVersion() - 1)).setControllerId(0).setControllerEpoch(0).setBrokerEpoch(0L).addPartitionState(tp0, this.makePartitionState(tp0, 0, 1)).addTopicId(tp0.topic(), topicId0).setLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0()})));
        if (hasNewBrokers1) {
            batch1.setHasNewBrokers();
        }
        UpdateMetadataBatch batch2 = new UpdateMetadataBatch(0).setVersion(ApiKeys.UPDATE_METADATA.latestVersion()).setControllerId(1).setControllerEpoch(1).setBrokerEpoch(1L).addPartitionState(tp0, this.makePartitionState(tp0, 1, 2)).addPartitionState(tp1, this.makePartitionState(tp1, 1, 1)).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).setLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker1()})));
        if (hasNewBrokers2) {
            batch2.setHasNewBrokers();
        }
        Assertions.assertEquals((Object)ContinueMerged$.MODULE$, (Object)batch1.process((ControlMetadataBatch)batch2));
        Assertions.assertEquals((short)ApiKeys.UPDATE_METADATA.latestVersion(), (short)batch1.version());
        Assertions.assertEquals((int)1, (int)batch1.controllerId());
        Assertions.assertEquals((int)1, (int)batch1.controllerEpoch());
        Assertions.assertEquals((long)1L, (long)batch1.brokerEpoch());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((hasNewBrokers1 || hasNewBrokers2 ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)batch1.hasNewBrokers()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)this.makePartitionState(tp0, 1, 2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)this.makePartitionState(tp1, 1, 1))})), (Object)batch1.partitions());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)batch1.topicIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker1()})), (Object)batch1.liveBrokers());
    }

    @Test
    public void testProcessWithLeaderAndIsrBatch() {
        Assertions.assertEquals((Object)Continue$.MODULE$, (Object)new UpdateMetadataBatch(0).process((ControlMetadataBatch)new LeaderAndIsrBatch(0)));
    }

    @Test
    public void testProcessHasNewBrokersWithLeaderAndIsrBatch() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).setHasNewBrokers().process((ControlMetadataBatch)new LeaderAndIsrBatch(0)));
    }

    @Test
    public void testProcessWithStopReplicaBatch() {
        Assertions.assertEquals((Object)Continue$.MODULE$, (Object)new UpdateMetadataBatch(0).process((ControlMetadataBatch)new StopReplicaBatch(0)));
    }

    @Test
    public void testProcessHasNewBrokersWithStopReplicaBatch() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).setHasNewBrokers().process((ControlMetadataBatch)new StopReplicaBatch(0)));
    }

    @Test
    public void testProcessWithInconsistentTopicId() {
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new StopReplicaBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new LeaderAndIsrBatch(0).addTopicId("topic", Uuid.randomUuid())));
        Assertions.assertEquals((Object)Block$.MODULE$, (Object)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid()).process((ControlMetadataBatch)new UpdateMetadataBatch(0).addTopicId("topic", Uuid.randomUuid())));
    }

    @Test
    public void testBuildRequests() {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.UPDATE_METADATA.oldestVersion()), (int)ApiKeys.UPDATE_METADATA.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> this.testBuildRequests((short)version));
    }

    public void testBuildRequests(short version) {
        int controllerId = 0;
        int controllerEpoch = 1;
        int brokerEpoch = 2;
        Uuid topicId0 = Uuid.randomUuid();
        Uuid topicId1 = Uuid.randomUuid();
        TopicPartition tp0 = new TopicPartition("topic-0", 0);
        TopicPartition tp1 = new TopicPartition("topic-1", 1);
        UpdateMetadataRequestData.UpdateMetadataPartitionState state0 = this.makePartitionState(tp0, 0, 2);
        UpdateMetadataRequestData.UpdateMetadataPartitionState state1 = this.makePartitionState(tp1, 1, 3);
        Seq requests = new UpdateMetadataBatch(0).setVersion(version).setControllerId(controllerId).setControllerEpoch(controllerEpoch).setBrokerEpoch((long)brokerEpoch).addPartitionState(tp0, state0).addPartitionState(tp1, state1).addTopicId(tp0.topic(), topicId0).addTopicId(tp1.topic(), topicId1).setLiveBrokers(this.Brokers()).requests(this.stateChangeLogger());
        Assertions.assertEquals((int)1, (int)requests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)((AbstractRequest.Builder)requests.head()).build();
        Assertions.assertEquals((short)version, (short)updateMetadataRequest.version());
        Assertions.assertEquals((int)controllerId, (int)updateMetadataRequest.controllerId());
        Assertions.assertEquals((int)controllerEpoch, (int)updateMetadataRequest.controllerEpoch());
        Assertions.assertEquals((long)brokerEpoch, (long)updateMetadataRequest.brokerEpoch());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{state0, state1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).toSet());
        Assertions.assertEquals((Object)this.Brokers().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.id()), Set$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)this.Brokers().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.tags(), Set$.MODULE$.canBuildFrom()), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)broker -> (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(UpdateMetadataRequest.tagMapFromBrokerTagCollection((java.util.List)broker.tags())).asScala(), Buffer$.MODULE$.canBuildFrom())).toSet());
        if (version >= 5) {
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0.topic()), (Object)topicId0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1)})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.topicStates()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionState -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionState.topicName()), (Object)partitionState.topicId()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        Set ports = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$16.endpoints()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.port()), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).toSet();
        if (version == 0) {
            ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
            Assertions.assertEquals((Object)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0(), this.Broker1()}))).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)UpdateMetadataBatchTest.$anonfun$testBuildRequests$12(listenerName, x$18)), Set$.MODULE$.canBuildFrom()), (Object)ports);
            return;
        }
        Assertions.assertEquals((Object)((TraversableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.Broker0(), this.Broker1()}))).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> (Seq)x$19.endPoints().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.port()), Seq$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()), (Object)ports);
    }

    public UpdateMetadataRequestData.UpdateMetadataPartitionState makePartitionState(TopicPartition tp, int leader, int leaderEpoch) {
        return new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setLeader(leader).setLeaderEpoch(leaderEpoch);
    }

    public static final /* synthetic */ int $anonfun$testBuildRequests$12(ListenerName listenerName$1, Broker x$18) {
        return x$18.node(listenerName$1).port();
    }
}

