/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001\u0002(P\u0001QCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001A\u0002\u0013%\u0001\rC\u0004e\u0001\u0001\u0007I\u0011B3\t\r-\u0004\u0001\u0015)\u0003b\u0011\u001da\u0007\u00011A\u0005\n5Dq\u0001\u001e\u0001A\u0002\u0013%Q\u000f\u0003\u0004x\u0001\u0001\u0006KA\u001c\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0011\u001di\b\u00011A\u0005\nyDq!!\u0001\u0001A\u0003&!\u0010C\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!I\u0011Q\u0002\u0001A\u0002\u0013%\u0011q\u0002\u0005\t\u0003'\u0001\u0001\u0015)\u0003\u0002\b!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002&!I\u00111\u0007\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011\b\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002<!I\u00111\u000b\u0001C\u0002\u0013%\u0011Q\u000b\u0005\t\u0003G\u0002\u0001\u0015!\u0003\u0002X!I\u0011Q\r\u0001C\u0002\u0013%\u0011q\r\u0005\t\u0003_\u0002\u0001\u0015!\u0003\u0002j!I\u0011\u0011\u000f\u0001C\u0002\u0013%\u00111\u000f\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002v!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003?\u0003A\u0011AA>\u0011\u001d\tI\u000b\u0001C\u0001\u0003wBq!!,\u0001\t\u0003\tY\bC\u0004\u00022\u0002!\t!a\u001f\t\u000f\u0005U\u0006\u0001\"\u0001\u0002|!9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0004bBA_\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u0003\u0004A\u0011AA>\u0011\u001d\t)\r\u0001C\u0001\u0003wBq!!3\u0001\t\u0003\tY\bC\u0004\u0002N\u0002!\t!a\u001f\t\u000f\u0005E\u0007\u0001\"\u0001\u0002|!9\u0011Q\u001b\u0001\u0005\u0002\u0005m\u0004bBAm\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003;\u0004A\u0011AA>\u0011\u001d\t\t\u000f\u0001C\u0001\u0003wBq!!:\u0001\t\u0003\tY\bC\u0004\u0002j\u0002!\t!a\u001f\t\u000f\u00055\b\u0001\"\u0001\u0002|!9\u0011\u0011\u001f\u0001\u0005\u0002\u0005m\u0004bBA{\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003s\u0004A\u0011AA>\u0011\u001d\ti\u0010\u0001C\u0001\u0003wBqA!\u0001\u0001\t\u0003\tY\bC\u0004\u0003\u0006\u0001!\t!a\u001f\t\u000f\t%\u0001\u0001\"\u0001\u0002|!9!Q\u0002\u0001\u0005\u0002\u0005m\u0004b\u0002B\t\u0001\u0011\u0005\u00111\u0010\u0005\b\u0005+\u0001A\u0011AA>\u0011\u001d\u0011I\u0002\u0001C\u0001\u0003wBqA!\b\u0001\t\u0003\tY\bC\u0004\u0003\"\u0001!\t!a\u001f\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002|!9!\u0011\u0006\u0001\u0005\u0002\u0005m\u0004b\u0002B\u0017\u0001\u0011\u0005\u00111\u0010\u0005\b\u0005c\u0001A\u0011AA>\u0011\u001d\u0011)\u0004\u0001C\u0001\u0003wBqA!\u000f\u0001\t\u0003\tY\bC\u0004\u0003>\u0001!\t!a\u001f\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002|!9!Q\t\u0001\u0005\u0002\u0005m\u0004b\u0002B%\u0001\u0011\u0005\u00111\u0010\u0005\b\u0005\u001b\u0002A\u0011AA>\u0011\u001d\u0011\t\u0006\u0001C\u0001\u0003wBqA!\u0016\u0001\t\u0003\tY\bC\u0004\u0003Z\u0001!\t!a\u001f\t\u000f\tu\u0003\u0001\"\u0003\u0003`!9!\u0011\u000e\u0001\u0005\n\t-$a\u0006*fa2L7-Y*uCR,W*Y2iS:,G+Z:u\u0015\t\u0001\u0016+\u0001\u0006d_:$(o\u001c7mKJT\u0011AU\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u000b\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0003\"A\u0018\u0001\u000e\u0003=\u000b\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u+\u0005\t\u0007C\u00010c\u0013\t\u0019wJA\tD_:$(o\u001c7mKJ\u001cuN\u001c;fqR\fQcY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u0002gSB\u0011akZ\u0005\u0003Q^\u0013A!\u00168ji\"9!nAA\u0001\u0002\u0004\t\u0017a\u0001=%c\u0005\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u00031iwnY6[W\u000ec\u0017.\u001a8u+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9R\u0003\tQ8.\u0003\u0002ta\ni1*\u00194lCj[7\t\\5f]R\f\u0001#\\8dWj[7\t\\5f]R|F%Z9\u0015\u0005\u00194\bb\u00026\u0007\u0003\u0003\u0005\rA\\\u0001\u000e[>\u001c7NW6DY&,g\u000e\u001e\u0011\u0002A5|7m[\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u000b\u0002uB\u0011al_\u0005\u0003y>\u0013AdQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.\u0001\u0013n_\u000e\\7i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eDw\fJ3r)\t1w\u0010C\u0004k\u0013\u0005\u0005\t\u0019\u0001>\u0002C5|7m[\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r\u001b\u0011\u0002'I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0016\u0005\u0005\u001d\u0001c\u00010\u0002\n%\u0019\u00111B(\u0003'I+\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3\u0002/I,\u0007\u000f\\5dCN#\u0018\r^3NC\u000eD\u0017N\\3`I\u0015\fHc\u00014\u0002\u0012!A!\u000eDA\u0001\u0002\u0004\t9!\u0001\u000bsKBd\u0017nY1Ti\u0006$X-T1dQ&tW\rI\u0001\tEJ|7.\u001a:JIV\u0011\u0011\u0011\u0004\t\u0004-\u0006m\u0011bAA\u000f/\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013AB2p]\u001aLw-\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,E\u000baa]3sm\u0016\u0014\u0018\u0002BA\u0018\u0003S\u00111bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0002!\r|g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0013!\u00039beRLG/[8o+\t\tY\u0004\u0005\u0003\u0002>\u00055SBAA \u0015\u0011\t\t%a\u0011\u0002\r\r|W.\\8o\u0015\r\u0011\u0016Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\n1a\u001c:h\u0013\u0011\ty%a\u0010\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006Q\u0001/\u0019:uSRLwN\u001c\u0011\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002XA1\u0011\u0011LA0\u0003wi!!a\u0017\u000b\u0007\u0005us+\u0001\u0006d_2dWm\u0019;j_:LA!!\u0019\u0002\\\t\u00191+Z9\u0002\u0017A\f'\u000f^5uS>t7\u000fI\u0001\be\u0016\u0004H.[2b+\t\tI\u0007E\u0002_\u0003WJ1!!\u001cP\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b\u0003!\u0011X\r\u001d7jG\u0006\u0004\u0013\u0001\u0003:fa2L7-Y:\u0016\u0005\u0005U\u0004CBA-\u0003?\nI'A\u0005sKBd\u0017nY1tA\u0005)1/\u001a;VaR\ta\rK\u0002\u001d\u0003\u007f\u0002B!!!\u0002\u00106\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0002ba&TA!!#\u0002\f\u00069!.\u001e9ji\u0016\u0014(\u0002BAG\u0003\u0013\nQA[;oSRLA!!%\u0002\u0004\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0019I,\u0007\u000f\\5dCN#\u0018\r^3\u0015\t\u0005]\u0015Q\u0014\t\u0004=\u0006e\u0015bAAN\u001f\na!+\u001a9mS\u000e\f7\u000b^1uK\"9\u0011QM\u000fA\u0002\u0005%\u0014A\u0007;fgR\u001cF/\u0019:ukB|e\u000e\\5oKB\u000b'\u000f^5uS>t\u0007f\u0001\u0010\u0002$B!\u0011\u0011QAS\u0013\u0011\t9+a!\u0003\tQ+7\u000f^\u0001\u001ci\u0016\u001cHo\u0015;beR,\bo\u00144gY&tW\rU1si&$\u0018n\u001c8)\u0007}\t\u0019+A\u0012uKN$8\u000b^1siV\u0004x+\u001b;i%\u0016\u0004H.[2b/&$\bn\\;u\u0019\u0016\fG-\u001a:)\u0007\u0001\n\u0019+\u0001\u0017uKN$hj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>tUm\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011%a)\u0002mQ,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007\t\n\u0019+A\u001cuKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)>|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004G\u0005\r\u0016a\u0010;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0004I\u0005\r\u0016A\u0011;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aQ%a)\u0002\u0005R,7\u000f^%om\u0006d\u0017\u000e\u001a(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eK\u0002'\u0003G\u000b1\u0007^3ti&sg/\u00197jI:+wOU3qY&\u001c\u0017\rV8O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007\u001d\n\u0019+\u0001\u001buKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\\,ji\"\fV/Z;fI\u0012+G.\u001a;j_:D3\u0001KAR\u0003\u001d\"Xm\u001d;OK^\u0014V\r\u001d7jG\u0006$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007%\n\u0019+\u0001\u0015uKN$h*Z<SKBd\u0017nY1U_>3g\r\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002+\u0003G\u000bq\u0007^3ti&sg/\u00197jI:+wOU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)J\fgn]5uS>t\u0007fA\u0016\u0002$\u0006QD/Z:u\u0013:4\u0018\r\\5e\u001d\u0016<(+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004Y\u0005\r\u0016A\u000f;fgRLeN^1mS\u0012tUm\u001e*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000e\u0016:b]NLG/[8oQ\ri\u00131U\u00017i\u0016\u001cH/\u00138wC2LGm\u00148mS:,'+\u001a9mS\u000e\fGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004]\u0005\r\u0016A\f;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{g*Z<SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aLAR\u0003)\"Xm\u001d;P]2Lg.\u001a*fa2L7-\u0019+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3\u0001MAR\u0003-\"Xm\u001d;P]2Lg.\u001a*fa2L7-\u0019+p\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA\u0019\u0002$\u0006QD/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0004e\u0005\r\u0016!\u0010;fgRLeN^1mS\u0012|e\u000e\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007fA\u001a\u0002$\u0006iD/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aA'a)\u0002oQ,7\u000f^%om\u0006d\u0017\u000eZ(gM2Lg.\u001a*fa2L7-\u0019+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r)\u00141U\u00010i\u0016\u001cH/\u00138wC2LGm\u00144gY&tWMU3qY&\u001c\u0017\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004m\u0005\r\u0016a\u000b;fgR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007]\n\u0019+\u0001\u001buKN$xJ\u001a4mS:,'+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ue\u0006t7/\u001b;j_:D3\u0001OAR\u0003]\"Xm\u001d;PM\u001ad\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011(a)\u0002}Q,7\u000f^%om\u0006d\u0017\u000eZ(gM2Lg.\u001a*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000e\u0016:b]NLG/[8oQ\rQ\u00141U\u0001@i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rY\u00141U\u00018i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+p\u001d\u0016<(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007q\n\u0019+\u0001\u001euKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\rV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aQ(a)\u0002wQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3U_>3g\r\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002?\u0003G\u000bq\b^3tiJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vNU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR\u0013\u0018M\\:ji&|g\u000eK\u0002@\u0003G\u000bq\b^3tiJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vNU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eK\u0002A\u0003G\u000b1\b^3tiJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+p\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\t\u00151U\u0001;i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{g*Z<SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3AQAR\u0003u\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\u0019\u00151U\u0001?i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{wJ\u001a4mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007\u0011\u000b\u0019+\u0001$uKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\u0007\u0015\u000b\u0019+A%uKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3Ue\u0006t7/\u001b;j_:D3ARAR\u0003\t#Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,Gk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004\u000f\u0006\r\u0016A\u000f;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rA\u00151U\u00017i\u0016\u001cHOU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR{wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004\u0013\u0006\r\u0016A\u0012;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0004\u0015\u0006\r\u0016!\u0013;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a1*a)\u0002+Q,7\u000f^%om\u0006d\u0017\u000e\u001a+sC:\u001c\u0018\u000e^5p]R)aM!\u0019\u0003f!9!1\r'A\u0002\u0005]\u0015!\u00034s_6\u001cF/\u0019;f\u0011\u001d\u00119\u0007\u0014a\u0001\u0003/\u000bq\u0001^8Ti\u0006$X-A\tsKBd\u0017nY1BgNLwM\\7f]R$BA!\u001c\u0003tA\u0019aLa\u001c\n\u0007\tEtJA\tSKBd\u0017nY1BgNLwM\\7f]RDq!!\u001dN\u0001\u0004\u0011)\b\u0005\u0004\u0003x\t\u001d\u0015\u0011\u0004\b\u0005\u0005s\u0012\u0019I\u0004\u0003\u0003|\t\u0005UB\u0001B?\u0015\r\u0011yhU\u0001\u0007yI|w\u000e\u001e \n\u0003aK1A!\"X\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0019\u0003\n*\u0019!QQ,")
public class ReplicaStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final Seq<PartitionAndReplica> replicas = new .colon.colon((Object)this.replica(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.replicaStateMachine_$eq((ReplicaStateMachine)new ZkReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private ReplicaState replicaState(PartitionAndReplica replica) {
        return this.controllerContext().replicaState(replica);
    }

    @Test
    public void testStartupOnlinePartition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupOfflinePartition() {
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupWithReplicaWithoutLeader() {
        int shutdownBrokerId = 100;
        PartitionAndReplica offlineReplica = new PartitionAndReplica(this.partition(), shutdownBrokerId);
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{shutdownBrokerId})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)offlineReplica));
        this.replicaStateMachine().startup();
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(offlineReplica));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        NewReplica$ x$2 = NewReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OfflineReplica$ x$2 = OfflineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionStarted$ x$2 = ReplicaDeletionStarted$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionIneligible$ x$2 = ReplicaDeletionIneligible$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionSuccessful$ x$2 = ReplicaDeletionSuccessful$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaTransitionWithQueuedDeletion() {
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.controllerContext().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.replica().topic()})));
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OfflineReplica$ x$2 = OfflineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addStopReplicaRequestForBrokers((Seq)ArgumentMatchers.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)ArgumentMatchers.eq((Object)this.partition()), ArgumentMatchers.eq((boolean)false));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addUpdateMetadataRequestForBrokers((Seq)ArgumentMatchers.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (Set)ArgumentMatchers.eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}))));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(ArgumentMatchers.eq((int)this.controllerEpoch()));
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        int otherBrokerId = this.brokerId() + 1;
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}));
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)replicaIds, (Seq)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)adjustedLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OfflineReplica$ x$2 = OfflineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addStopReplicaRequestForBrokers((Seq)ArgumentMatchers.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)ArgumentMatchers.eq((Object)this.partition()), ArgumentMatchers.eq((boolean)false));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)replicaIds), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo(this.partition()).get());
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionStarted$ x$2 = ReplicaDeletionStarted$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionIneligible$ x$2 = ReplicaDeletionIneligible$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionIneligible$ x$2 = ReplicaDeletionIneligible$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        ReplicaDeletionSuccessful$ x$2 = ReplicaDeletionSuccessful$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        NonExistentReplica$ x$2 = NonExistentReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        OnlineReplica$ x$2 = OnlineReplica$.MODULE$;
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, (ReplicaState)x$2, x$3);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.controllerContext().putReplicaState(this.replica(), fromState);
        ReplicaStateMachine qual$1 = this.replicaStateMachine();
        Seq<PartitionAndReplica> x$1 = this.replicas();
        boolean x$3 = qual$1.handleStateChanges$default$3();
        qual$1.handleStateChanges(x$1, toState, x$3);
        Assertions.assertEquals((Object)fromState, (Object)this.replicaState(this.replica()));
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)Nil$.MODULE$);
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

