/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.MockPartitionStateMachine;
import kafka.controller.MockReplicaStateMachine;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.controller.ZkPartitionStateMachine;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import kafka.zookeeper.ZooKeeperClientException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001\u0002\u001e<\u0001\u0001CQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001A\u0002\u0013%A\nC\u0004Q\u0001\u0001\u0007I\u0011B)\t\r]\u0003\u0001\u0015)\u0003N\u0011\u001dA\u0006\u00011A\u0005\neCq\u0001\u0019\u0001A\u0002\u0013%\u0011\r\u0003\u0004d\u0001\u0001\u0006KA\u0017\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0011\u001dI\u0007\u00011A\u0005\n)Da\u0001\u001c\u0001!B\u00131\u0007bB7\u0001\u0001\u0004%IA\u001c\u0005\be\u0002\u0001\r\u0011\"\u0003t\u0011\u0019)\b\u0001)Q\u0005_\"9a\u000f\u0001b\u0001\n\u00139\bBB>\u0001A\u0003%\u0001\u0010C\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u0005%\u0001\u0001)A\u0005}\"A\u00111\u0002\u0001C\u0002\u0013%q\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002=\t\u0013\u0005=\u0001A1A\u0005\n\u0005E\u0001\u0002CA\u0015\u0001\u0001\u0006I!a\u0005\t\u0013\u0005-\u0002A1A\u0005\n\u00055\u0002\u0002CA\u001e\u0001\u0001\u0006I!a\f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBA2\u0001\u0011%\u0011Q\r\u0005\b\u0003k\u0002A\u0011AA \u0011\u001d\ty\b\u0001C\u0001\u0003\u007fAq!a!\u0001\t\u0003\ty\u0004C\u0004\u0002\b\u0002!\t!a\u0010\t\u000f\u0005-\u0005\u0001\"\u0001\u0002@!9\u0011q\u0012\u0001\u0005\u0002\u0005}\u0002bBAJ\u0001\u0011\u0005\u0011q\b\u0005\b\u0003/\u0003A\u0011AA \u0011\u001d\tY\n\u0001C\u0001\u0003\u007fAq!a(\u0001\t\u0003\ty\u0004C\u0004\u0002$\u0002!\t!a\u0010\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002@!9\u00111\u0016\u0001\u0005\u0002\u0005}\u0002bBAX\u0001\u0011\u0005\u0011q\b\u0005\b\u0003g\u0003A\u0011AA \u0011\u001d\t9\f\u0001C\u0001\u0003sCq!!;\u0001\t\u0003\ty\u0004C\u0004\u0002n\u0002!\t!a\u0010\t\u000f\u0005E\b\u0001\"\u0001\u0002@!9\u0011Q\u001f\u0001\u0005\u0002\u0005}\u0002bBA}\u0001\u0011\u0005\u0011q\b\u0005\b\u0003{\u0004A\u0011AA \u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003\u007fAqA!\u0002\u0001\t\u0003\ty\u0004C\u0004\u0003\n\u0001!IAa\u0003\t\u000f\t\u0015\u0002\u0001\"\u0001\u0002@!9!\u0011\u0006\u0001\u0005\u0002\u0005}\u0002b\u0002B\u0017\u0001\u0011\u0005\u0011q\b\u0005\b\u0005c\u0001A\u0011AA \u0011\u001d\u0011)\u0004\u0001C\u0001\u0003\u007fAqA!\u000f\u0001\t\u0013\u0011YDA\rQCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3UKN$(B\u0001\u001f>\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002}\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001B!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0013\t\u0003\u0015\u0002i\u0011aO\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A'\u0011\u0005)s\u0015BA(<\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\t\u0011V\u000b\u0005\u0002C'&\u0011Ak\u0011\u0002\u0005+:LG\u000fC\u0004W\u0007\u0005\u0005\t\u0019A'\u0002\u0007a$\u0013'\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013\u0001D7pG.T6n\u00117jK:$X#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uk\u0014A\u0001>l\u0013\tyFLA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u0011[>\u001c7NW6DY&,g\u000e^0%KF$\"A\u00152\t\u000fY3\u0011\u0011!a\u00015\u0006iQn\\2l5.\u001cE.[3oi\u0002\n\u0001%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQV\ta\r\u0005\u0002KO&\u0011\u0001n\u000f\u0002\u001d\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u0011jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195`I\u0015\fHC\u0001*l\u0011\u001d1\u0016\"!AA\u0002\u0019\f\u0011%\\8dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002\nQ\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW-F\u0001p!\tQ\u0005/\u0003\u0002rw\t)\u0002+\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0017!\u00079beRLG/[8o'R\fG/Z'bG\"Lg.Z0%KF$\"A\u0015;\t\u000fYc\u0011\u0011!a\u0001_\u00061\u0002/\u0019:uSRLwN\\*uCR,W*Y2iS:,\u0007%\u0001\u0005ce>\\WM]%e+\u0005A\bC\u0001\"z\u0013\tQ8IA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002\r\r|gNZ5h+\u0005q\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007i\u0014AB:feZ,'/\u0003\u0003\u0002\b\u0005\u0005!aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u00111\u0003\t\u0005\u0003+\t)#\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u0019\u0019w.\\7p]*\u0019a(!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0012aA8sO&!\u0011qEA\f\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003_\u0001b!!\r\u00028\u0005MQBAA\u001a\u0015\r\t)dQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001d\u0003g\u00111aU3r\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003IC3\u0001GA\"!\u0011\t)%a\u0015\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n1!\u00199j\u0015\u0011\ti%a\u0014\u0002\u000f),\b/\u001b;fe*!\u0011\u0011KA\u0011\u0003\u0015QWO\\5u\u0013\u0011\t)&a\u0012\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\bqCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\u0005m\u0013\u0011\r\t\u0004\u0015\u0006u\u0013bAA0w\tq\u0001+\u0019:uSRLwN\\*uCR,\u0007bBA\b3\u0001\u0007\u00111C\u0001\u0018a\u0006\u0014H/\u001b;j_:dU-\u00193feND\u0017\u000e]%oM>$B!a\u001a\u0002tA)!)!\u001b\u0002n%\u0019\u00111N\"\u0003\r=\u0003H/[8o!\rQ\u0015qN\u0005\u0004\u0003cZ$a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002\u0010i\u0001\r!a\u0005\u0002aQ,7\u000f\u001e(p]\u0016D\u0018n\u001d;f]R\u0004\u0016M\u001d;ji&|g\u000eV8OK^\u0004\u0016M\u001d;ji&|g\u000e\u0016:b]NLG/[8oQ\rY\u0012\u0011\u0010\t\u0005\u0003\u000b\nY(\u0003\u0003\u0002~\u0005\u001d#\u0001\u0002+fgR\f!\b^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007q\tI(A\u001euKN$\u0018J\u001c<bY&$gj\u001c8fq&\u001cH/\u001a8u!\u0006\u0014H/\u001b;j_:$vn\u00144gY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3!HA=\u0003-\"Xm\u001d;OK^\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u0010\u0002z\u0005\u0019F/Z:u\u001d\u0016<\b+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|gNW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e^#yG\u0016\u0004H/[8o\rJ|Wn\u0011:fCR,7\u000b^1uKND3aHA=\u0003\u0011#Xm\u001d;OK^\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>tWI\u001d:pe\u000e{G-\u001a$s_6\u001c%/Z1uKN#\u0018\r^3tQ\r\u0001\u0013\u0011P\u0001-i\u0016\u001cHOT3x!\u0006\u0014H/\u001b;j_:$vn\u00144gY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3!IA=\u0003]\"Xm\u001d;J]Z\fG.\u001b3OK^\u0004\u0016M\u001d;ji&|g\u000eV8O_:,\u00070[:uK:$\b+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a!%!\u001f\u0002KQ,7\u000f^(oY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f)J\fgn]5uS>t\u0007fA\u0012\u0002z\u0005QD/Z:u\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R{wJ\u001c7j]\u0016$&/\u00198tSRLwN\u001c$pe\u000e{g\u000e\u001e:pY2,Gm\u00155vi\u0012|wO\u001c\u0015\u0004I\u0005e\u0014A\n;fgR|e\u000e\\5oKB\u000b'\u000f^5uS>tGk\\(gM2Lg.\u001a+sC:\u001c\u0018\u000e^5p]\"\u001aQ%!\u001f\u0002uQ,7\u000f^%om\u0006d\u0017\u000eZ(oY&tW\rU1si&$\u0018n\u001c8U_:{g.\u001a=jgR,g\u000e\u001e)beRLG/[8o)J\fgn]5uS>t\u0007f\u0001\u0014\u0002z\u0005\u0011D/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R{g*Z<QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u0002(\u0003s\nq\u0006^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:D3\u0001KA=\u0003i\"Xm\u001d;EK\u000e|G-\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\*uCR,'LT8eK^KG\u000f[8viVs7\r\\3b]2+\u0017\rZ3s\r2\fw\rK\u0002*\u0003s\na\u0007^3ti>3g\r\\5oKB\u000b'\u000f^5uS>tGk\\+oG2,\u0017M\\(oY&tW\rU1si&$\u0018n\u001c8Ue\u0006t7/\u001b;j_:$2AUA^\u0011\u001d\tiL\u000ba\u0001\u0003\u007f\u000b\u0011$[:MK\u0006$WM\u001d*fG>4XM]=TkB\u0004xN\u001d;fIB\u0019!)!1\n\u0007\u0005\r7IA\u0004C_>dW-\u00198)\u000f)\n9-a6\u0002ZB!\u0011\u0011ZAj\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005E\u00171J\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005U\u00171\u001a\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\tY.!8\u001a\u0003\u0005I\u0012\u0001\u0001\u0015\u0004U\u0005\u0005\b\u0003BAr\u0003Kl!!a4\n\t\u0005\u001d\u0018q\u001a\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018!\u0010;fgR,fn\u00197fC:|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8V]\u000edW-\u00198P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t\u0007fA\u0016\u0002z\u00051D/Z:u+:\u001cG.Z1o\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$vn\u00148mS:,\u0007+\u0019:uSRLwN\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aA&!\u001f\u0002\u0013R,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>|e\u000e\\5oKB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8XSRDWK\\2mK\u0006tW\t\\3di&|g.\u00128bE2,G\rK\u0002.\u0003s\nA\u0005^3ti\n\u0013xn[3s\u0005>,hnY3BMR,'/\u00168dY\u0016\fg.\u00127fGRLwN\u001c\u0015\u0004]\u0005e\u0014A\u0016;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>t'l\\8LK\u0016\u0004XM]\"mS\u0016tG/\u0012=dKB$\u0018n\u001c8Ge>l7\u000b^1uK2{wn[;qQ\ry\u0013\u0011P\u0001Hi\u0016\u001cHo\u00144gY&tW\rU1si&$\u0018n\u001c8U_>sG.\u001b8f!\u0006\u0014H/\u001b;j_:$&/\u00198tSRLwN\\#se>\u00148i\u001c3f\rJ|Wn\u0015;bi\u0016dun\\6va\"\u001a\u0001'!\u001f\u0002iQ,7\u000f^(gM2Lg.\u001a)beRLG/[8o)>tuN\\3ySN$XM\u001c;QCJ$\u0018\u000e^5p]R\u0013\u0018M\\:ji&|g\u000eK\u00022\u0003s\n1\u0007^3ti&sg/\u00197jI>3g\r\\5oKB\u000b'\u000f^5uS>tGk\u001c(foB\u000b'\u000f^5uS>tGK]1og&$\u0018n\u001c8)\u0007I\nI(A\u0013qe\u0016\u0004\u0018M]3N_\u000e\\Gk\\#mK\u000e$H*Z1eKJ4uN\u001d)beRLG/[8ogR\u0019!K!\u0004\t\u000f\u0005-2\u00071\u0001\u0003\u0010A1!\u0011\u0003B\u0011\u0003'qAAa\u0005\u0003\u001e9!!Q\u0003B\u000e\u001b\t\u00119BC\u0002\u0003\u001a}\na\u0001\u0010:p_Rt\u0014\"\u0001#\n\u0007\t}1)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\"1\u0005\u0006\u0004\u0005?\u0019\u0015A\t;fgR,\u0006\u000fZ1uS:<wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:D_VtG\u000fK\u00025\u0003s\n!\u0007^3ti:{wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:DQ\u0006tw-\u001a$peR{\u0007/[2t\u0005\u0016Lgn\u001a#fY\u0016$X\r\u001a\u0015\u0004k\u0005e\u0014!\u000e;fgR,\u0006\u000fZ1uS:<wJ\u001a4mS:,\u0007+\u0019:uSRLwN\\:D_VtG\u000fR;sS:<Gk\u001c9jG\u0012+G.\u001a;j_:D3ANA=\u0003u\"Xm\u001d;OK^\u0004\u0016M\u001d;ji&|g\u000eV8P]2Lg.\u001a)beRLG/[8o)J\fgn]5uS>tw+\u001b;i\t\u0016lw\u000e^3e\u0005J|7.\u001a:tQ\r9\u0014\u0011P\u00018i\u0016\u001cHo\u00148mS:,\u0007+\u0019:uSRLwN\u001c+p\u001f:d\u0017N\\3Ue\u0006t7/\u001b;j_:<\u0016\u000e\u001e5EK6|G/\u001a3Ce>\\WM]:)\u0007a\nI(A\tsKBd\u0017nY1BgNLwM\\7f]R$BA!\u0010\u0003DA\u0019!Ja\u0010\n\u0007\t\u00053HA\tSKBd\u0017nY1BgNLwM\\7f]RDqA!\u0012:\u0001\u0004\u00119%\u0001\u0005sKBd\u0017nY1t!\u0015\u0011\tB!\ty\u0001")
public class PartitionStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private PartitionStateMachine partitionStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    private void partitionStateMachine_$eq(PartitionStateMachine x$1) {
        this.partitionStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.partitionStateMachine_$eq((PartitionStateMachine)new ZkPartitionStateMachine(this.config(), new Metrics(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private PartitionState partitionState(TopicPartition partition) {
        return this.controllerContext().partitionState(partition);
    }

    private Option<LeaderIsrAndControllerEpoch> partitionLeadershipInfo(TopicPartition partition) {
        return this.controllerContext().partitionLeadershipInfo(partition);
    }

    @Test
    public void testNonexistentPartitionToNewPartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOnlinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNonexistentPartitionToOfflinePartitionTransition() {
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenThrow(new Throwable[]{new ZooKeeperClientException("test")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionErrorCodeFromCreateStates() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.NODEEXISTS, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).createTopicPartitionStatesRaw((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testNewPartitionToOfflinePartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidNewPartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NewPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransition() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionForControlledShutdown() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5()), TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)this.brokerId()));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOnlinePartitionToOfflineTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOnlinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransition() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition().topic()), (Object)LogConfig$.MODULE$.apply())})), (Object)Map$.MODULE$.empty()));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeader(this.brokerId());
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getLogConfigs((scala.collection.immutable.Set)ArgumentMatchers.any(), (java.util.Map)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testDecodeTopicPartitionStateZNodeWithoutUncleanLeaderFlag() {
        byte[] zNodeData = Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)LeaderAndIsr$.MODULE$.initialLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))).asJava())}))).asJava());
        Stat zNodeDataStat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        PartitionStateMachineTest.decodeTopicPartitionStateZNodeAndValidate$1(zNodeData, zNodeDataStat, this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), LeaderRecoveryState.RECOVERED, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), this.controllerEpoch());
        PartitionStateMachineTest.decodeTopicPartitionStateZNodeAndValidate$1(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader"), (Object)BoxesRunTime.boxToInteger((int)this.brokerId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leader_epoch"), (Object)BoxesRunTime.boxToInteger((int)LeaderAndIsr$.MODULE$.initialLeaderEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controller_epoch"), (Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isr"), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confluent_is_unclean_leader"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}))).asJava()), zNodeDataStat, this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), LeaderRecoveryState.RECOVERING, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), this.controllerEpoch());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testOfflinePartitionToUncleanOnlinePartitionTransition(boolean isLeaderRecoverySupported) {
        KAFKA_2_4_IV1$ apiVersion = isLeaderRecoverySupported ? KAFKA_2_4_IV1$.MODULE$ : KAFKA_2_4_IV0$.MODULE$;
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        properties.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
        ZkPartitionStateMachine partitionStateMachine = new ZkPartitionStateMachine(KafkaConfig$.MODULE$.fromProps(properties), new Metrics(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch());
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = isLeaderRecoverySupported ? leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))) : leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        partitionStateMachine.handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testUncleanOfflinePartitionToUncleanOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), LeaderRecoveryState.RECOVERING, LeaderAndIsr$.MODULE$.initialZKVersion(), (Option)None$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testUncleanOfflinePartitionToOnlinePartitionTransition() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(leaderBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), LeaderRecoveryState.RECOVERING, LeaderAndIsr$.MODULE$.initialZKVersion(), (Option)None$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newRecoveringLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionWithUncleanElectionEnabled() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testBrokerBounceAfterUncleanElection() {
        int leaderBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(leaderBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr qual$1 = LeaderAndIsr$.MODULE$.apply(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderRecoveryState x$1 = LeaderRecoveryState.RECOVERING;
        int x$2 = qual$1.copy$default$1();
        int x$3 = qual$1.copy$default$2();
        List x$4 = qual$1.copy$default$3();
        int x$5 = qual$1.copy$default$5();
        Option x$6 = qual$1.copy$default$6();
        LeaderAndIsr leaderAndIsr = qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.empty());
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OfflinePartition$.MODULE$);
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(leaderBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, Option$.MODULE$.apply((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L), new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        LeaderAndIsr leaderAndIsrAfterElection = leaderAndIsr.newLeaderAndIsr(leaderBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = leaderAndIsrAfterElection.withZkVersion(2);
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderAndIsrAfterElection)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(true)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch(), (VerificationMode)Mockito.times((int)2))).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId})), this.partition(), new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch()), this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId, this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch(), (VerificationMode)Mockito.times((int)2))).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionZooKeeperClientExceptionFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenThrow(new Throwable[]{new ZooKeeperClientException("")});
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToOnlinePartitionTransitionErrorCodeFromStateLookup() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.NONODE, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testOfflinePartitionToNonexistentPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NonExistentPartition$.MODULE$);
        Assertions.assertEquals((Object)NonExistentPartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    @Test
    public void testInvalidOfflinePartitionToNewPartitionTransition() {
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OfflinePartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)NewPartition$.MODULE$);
        Assertions.assertEquals((Object)OfflinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
    }

    private void prepareMockToElectLeaderForPartitions(Seq<TopicPartition> partitions) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.prepareMockToGetTopicPartitionsStatesRaw$1(leaderAndIsr, partitions);
        this.prepareMockToGetLogConfigs$1();
        this.prepareMockToUpdateLeaderAndIsr$1(partitions, leaderAndIsr);
    }

    @Test
    public void testUpdatingOfflinePartitionsCount() {
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$1(topic, BoxesRunTime.unboxToInt((Object)x$1)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCount$2(this, partition);
            return BoxedUnit.UNIT;
        });
        this.prepareMockToElectLeaderForPartitions((Seq<TopicPartition>)partitions);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OnlinePartition$.MODULE$, (Option)new Some((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNoOfflinePartitionsChangeForTopicsBeingDeleted() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$2 -> PartitionStateMachineTest.$anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(topic, BoxesRunTime.unboxToInt((Object)x$2)), Seq$.MODULE$.canBuildFrom());
        this.controllerContext().topicsToBeDeleted().add((Object)topic);
        this.controllerContext().topicsWithDeletionStarted().add((Object)topic);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        this.partitionStateMachine().handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testUpdatingOfflinePartitionsCountDuringTopicDeletion() {
        Seq partitionIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        String topic = "test";
        Seq partitions = (Seq)partitionIds.map((Function1 & Serializable & scala.Serializable)x$3 -> PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(BoxesRunTime.unboxToInt((Object)x$3)), Seq$.MODULE$.canBuildFrom());
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(this, partition);
            return BoxedUnit.UNIT;
        });
        MockPartitionStateMachine partitionStateMachine = new MockPartitionStateMachine(this.controllerContext(), false, true);
        MockReplicaStateMachine replicaStateMachine = new MockReplicaStateMachine(this.controllerContext());
        DeletionClient deletionClient = (DeletionClient)Mockito.mock(DeletionClient.class);
        TopicDeletionManager topicDeletionManager = new TopicDeletionManager(this.config(), this.controllerContext(), (ReplicaStateMachine)replicaStateMachine, (PartitionStateMachine)partitionStateMachine, deletionClient, (Option)None$.MODULE$);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)NewPartition$.MODULE$);
        partitionStateMachine.handleStateChanges(partitions, (PartitionState)OfflinePartition$.MODULE$);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            PartitionStateMachineTest.$anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(this, partition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)partitions.size(), (int)this.controllerContext().offlinePartitionCount(), (String)new StringBuilder(37).append("There should be ").append(partitions.size()).append(" offline partition(s)").toString());
        topicDeletionManager.enqueueTopicsForDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Assertions.assertEquals((int)0, (int)this.controllerContext().offlinePartitionCount(), (String)"There should be no offline partition(s)");
    }

    @Test
    public void testNewPartitionToOnlinePartitionTransitionWithDemotedBrokers() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5()), TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().setDemotedReasons(this.brokerId(), (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"demoted broker for test"})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)NewPartition$.MODULE$);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}))), this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().createTopicPartitionStatesRaw((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)leaderIsrAndControllerEpoch)})), this.controllerContext().epochZkVersion())).thenReturn((Object)new .colon.colon((Object)new CreateResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), null, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)new OfflinePartitionLeaderElectionStrategy(false)));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})))), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
        Assertions.assertNotEquals((int)((LeaderIsrAndControllerEpoch)this.partitionLeadershipInfo(this.partition()).get()).leaderAndIsr().leader(), (int)this.brokerId());
    }

    @Test
    public void testOnlinePartitionToOnlineTransitionWithDemotedBrokers() {
        int otherBrokerId = this.brokerId() + 1;
        this.controllerContext().setLiveBrokers((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{TestUtils$.MODULE$.createBrokerAndEpoch(this.brokerId(), "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5()), TestUtils$.MODULE$.createBrokerAndEpoch(otherBrokerId, "host", 0, TestUtils$.MODULE$.createBrokerAndEpoch$default$4(), TestUtils$.MODULE$.createBrokerAndEpoch$default$5())})));
        this.controllerContext().setDemotedReasons(this.brokerId(), (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"demoted broker for test"})));
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})), (Seq)Nil$.MODULE$));
        this.controllerContext().putPartitionState(this.partition(), (PartitionState)OnlinePartition$.MODULE$);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(otherBrokerId, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$));
        LeaderAndIsr newLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId})));
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)newLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)newLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        Assertions.assertEquals((int)((LeaderIsrAndControllerEpoch)this.partitionLeadershipInfo(this.partition()).get()).leaderAndIsr().leader(), (int)otherBrokerId);
        this.controllerContext().setDemotedReasons(this.brokerId(), (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        this.partitionStateMachine().handleStateChanges(this.partitions(), (PartitionState)OnlinePartition$.MODULE$, Option$.MODULE$.apply((Object)PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$));
        Assertions.assertEquals((Object)OnlinePartition$.MODULE$, (Object)this.partitionState(this.partition()));
        Assertions.assertEquals((int)((LeaderIsrAndControllerEpoch)this.partitionLeadershipInfo(this.partition()).get()).leaderAndIsr().leader(), (int)this.brokerId());
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)Nil$.MODULE$);
    }

    private static final void decodeTopicPartitionStateZNodeAndValidate$1(byte[] responseData, Stat responseStat, int leader, List isr, LeaderRecoveryState expectedLeaderRecoveryState, int leaderEpoch, int controllerEpoch) {
        Option option = TopicPartitionStateZNode$.MODULE$.decode(responseData, responseStat);
        if (option instanceof Some) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
            Assertions.assertEquals((int)leader, (int)leaderIsrAndControllerEpoch.leaderAndIsr().leader(), (String)"Leader mismatch");
            Assertions.assertEquals((Object)isr, (Object)leaderIsrAndControllerEpoch.leaderAndIsr().isr(), (String)"Isr mismatch");
            Assertions.assertEquals((Object)expectedLeaderRecoveryState, (Object)leaderIsrAndControllerEpoch.leaderAndIsr().leaderRecoveryState(), (String)"Leader recovery state mismatch");
            Assertions.assertEquals((int)leaderEpoch, (int)leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch(), (String)"Leader Epoch mismatch");
            Assertions.assertEquals((int)controllerEpoch, (int)leaderIsrAndControllerEpoch.controllerEpoch(), (String)"Controller Epoch mismatch");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.assert(true, (Function0 & Serializable & scala.Serializable)() -> "Could not decode TopicPartitionStateZNode data");
            return;
        }
        throw new MatchError((Object)option);
    }

    private final void prepareMockToGetTopicPartitionsStatesRaw$1(LeaderAndIsr leaderAndIsr$1, Seq partitions$1) {
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr$1, this.controllerEpoch());
        Seq getDataResponses = (Seq)partitions$1.map((Function1 & Serializable & scala.Serializable)p -> new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some(p), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), Seq$.MODULE$.canBuildFrom());
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(partitions$1)).thenReturn((Object)getDataResponses);
    }

    private final void prepareMockToGetLogConfigs$1() {
        Mockito.when((Object)this.mockZkClient().getLogConfigs(Predef$.MODULE$.Set().empty(), this.config().originals())).thenReturn((Object)new Tuple2((Object)Map$.MODULE$.empty(), (Object)Map$.MODULE$.empty()));
    }

    private final void prepareMockToUpdateLeaderAndIsr$1(Seq partitions$1, LeaderAndIsr leaderAndIsr$1) {
        scala.collection.immutable.Map updatedLeaderAndIsr = ((TraversableOnce)partitions$1.map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)leaderAndIsr$1.newLeaderAndIsr(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)updatedLeaderAndIsr, this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)updatedLeaderAndIsr.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            LeaderAndIsr v = (LeaderAndIsr)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)package$.MODULE$.Right().apply((Object)v));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCount$1(String topic$1, int x$1) {
        return new TopicPartition(topic$1, x$1);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCount$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ TopicPartition $anonfun$testNoOfflinePartitionsChangeForTopicsBeingDeleted$1(String topic$2, int x$2) {
        return new TopicPartition(topic$2, x$2);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$1(int x$3) {
        return new TopicPartition("test", x$3);
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$2(PartitionStateMachineTest $this, TopicPartition partition) {
        $this.controllerContext().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.brokerId()})), (Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$testUpdatingOfflinePartitionsCountDuringTopicDeletion$3(PartitionStateMachineTest $this, TopicPartition partition) {
        PartitionAndReplica replica = new PartitionAndReplica(partition, $this.brokerId());
        $this.controllerContext().putReplicaState(replica, (ReplicaState)OfflineReplica$.MODULE$);
    }

    public PartitionStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

