/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicReference;
import kafka.common.BalancerStatusDescriptionInternal;
import kafka.controller.ClusterBalanceManager;
import kafka.controller.NoOpClusterBalanceManager;
import org.apache.kafka.clients.admin.BalancerStatus;
import org.apache.kafka.common.errors.BalancerLoadError;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NoOpClusterBalanceManagerTest {
    @Test
    public void testDataBalancerClassLoadFailureReturnsExpectedBalancerStatus() {
        NoOpClusterBalanceManager balanceManager = new NoOpClusterBalanceManager("error loading exception", (Exception)new ClassNotFoundException("not found"));
        AtomicReference managerStatus = new AtomicReference();
        ClusterBalanceManager.BalanceManagerStatusQueryClientCallback callback = (error, result) -> {
            Assertions.assertTrue((boolean)result.isPresent(), (String)"No balancer status description result was returned");
            managerStatus.set(result.get());
        };
        Assertions.assertNull(managerStatus.get(), (String)"Expected the returned status to not be populated yet");
        balanceManager.balancerStatus(callback);
        Assertions.assertNotNull(managerStatus.get(), (String)"Expected the returned status to be populated");
        Assertions.assertEquals((Object)BalancerStatus.LOAD_FAILURE, (Object)((BalancerStatusDescriptionInternal)managerStatus.get()).balancerStatus());
        Assertions.assertEquals(BalancerLoadError.class, ((BalancerStatusDescriptionInternal)managerStatus.get()).exception().getClass());
    }
}

