/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.common.ReplicaExclusionCache;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001A\u0002\u0013\u00051\bC\u0004@\u0001\u0001\u0007I\u0011\u0001!\t\r\u0019\u0003\u0001\u0015)\u0003=\u0011\u001d9\u0005A1A\u0005\u0002!Caa\u0014\u0001!\u0002\u0013I\u0005b\u0002)\u0001\u0005\u0004%\t!\u0015\u0005\u0007C\u0002\u0001\u000b\u0011\u0002*\t\u000f\t\u0004!\u0019!C\u0001G\"1a\u000e\u0001Q\u0001\n\u0011Dqa\u001c\u0001C\u0002\u0013\u00051\r\u0003\u0004q\u0001\u0001\u0006I\u0001\u001a\u0005\bc\u0002\u0011\r\u0011\"\u0001d\u0011\u0019\u0011\b\u0001)A\u0005I\")1\u000f\u0001C\u0001i\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\u0007\u0003g\u0001A\u0011\u0001;\t\r\u0005u\u0002\u0001\"\u0001u\u0011\u0019\t\t\u0005\u0001C\u0001i\"1\u0011Q\t\u0001\u0005\u0002QDa!!\u0013\u0001\t\u0003!\bBBA'\u0001\u0011\u0005A\u000f\u0003\u0004\u0002R\u0001!\t\u0001\u001e\u0005\u0007\u0003+\u0002A\u0011\u0001;\t\r\u0005e\u0003\u0001\"\u0001u\u0011\u0019\ti\u0006\u0001C\u0001i\"1\u0011\u0011\r\u0001\u0005\u0002QDa!!\u001a\u0001\t\u0003!\bBBA5\u0001\u0011\u0005A\u000f\u0003\u0004\u0002n\u0001!\t\u0001\u001e\u0005\u0007\u0003c\u0002A\u0011\u0001;\t\r\u0005U\u0004\u0001\"\u0001u\u0011\u0019\tI\b\u0001C\u0001i\"1\u0011Q\u0010\u0001\u0005\u0002QDa!!!\u0001\t\u0003!\bBBAC\u0001\u0011\u0005A\u000f\u0003\u0004\u0002\n\u0002!\t\u0001\u001e\u0005\u0007\u0003\u001b\u0003A\u0011\u0001;\t\r\u0005E\u0005\u0001\"\u0001u\u0005U\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e+fgRT!a\u000b\u0017\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001.\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\b\u0005\u0002:\u00015\t!&A\u0004d_:$X\r\u001f;\u0016\u0003q\u0002\"!O\u001f\n\u0005yR#!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0006Y1m\u001c8uKb$x\fJ3r)\t\tE\t\u0005\u00022\u0005&\u00111I\r\u0002\u0005+:LG\u000fC\u0004F\u0007\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013'\u0001\u0005d_:$X\r\u001f;!\u00039)\u0007p\u00197vg&|gnQ1dQ\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u00192\naaY8n[>t\u0017B\u0001(L\u0005U\u0011V\r\u001d7jG\u0006,\u0005p\u00197vg&|gnQ1dQ\u0016\fq\"\u001a=dYV\u001c\u0018n\u001c8DC\u000eDW\rI\u0001\bEJ|7.\u001a:t+\u0005\u0011\u0006cA*\\=:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/:\na\u0001\u0010:p_Rt\u0014\"A\u001a\n\u0005i\u0013\u0014a\u00029bG.\fw-Z\u0005\u00039v\u00131aU3r\u0015\tQ&\u0007\u0005\u00022?&\u0011\u0001M\r\u0002\u0004\u0013:$\u0018\u0001\u00032s_.,'o\u001d\u0011\u0002\u0007Q\u0004\u0018'F\u0001e!\t)G.D\u0001g\u0015\tauM\u0003\u0002.Q*\u0011\u0011N[\u0001\u0007CB\f7\r[3\u000b\u0003-\f1a\u001c:h\u0013\tigM\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\n1\u0001\u001e94\u0003\u0011!\bo\r\u0011\u0002\u000bM,G/\u00169\u0015\u0003\u0005C#a\u0004<\u0011\u0005]tX\"\u0001=\u000b\u0005eT\u0018aA1qS*\u00111\u0010`\u0001\bUV\u0004\u0018\u000e^3s\u0015\ti(.A\u0003kk:LG/\u0003\u0002\u0000q\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8ogR\u0019\u0011)!\u0002\t\u000f\u0005\u001d\u0001\u00031\u0001\u0002\n\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u0007M[F-\u0001\u000bhK:,'/\u0019;f\u0005J|7.\u001a:Fa>\u001c\u0007n\u001d\u000b\u0005\u0003\u001f\ti\u0003\u0005\u0005\u0002\u0012\u0005]\u00111DA\u0014\u001b\t\t\u0019BC\u0002\u0002\u0016I\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI\"a\u0005\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003L\u0001\bG2,8\u000f^3s\u0013\u0011\t)#a\b\u0003\r\t\u0013xn[3s!\r\t\u0014\u0011F\u0005\u0004\u0003W\u0011$\u0001\u0002'p]\u001eDq!a\f\u0012\u0001\u0004\t\t$A\bce>\\WM]!oI\u0016\u0003xn\u00195t!\u001d\t\t\"a\u0006_\u0003O\t\u0001\t^3tiV\u0003H-\u0019;f!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^+qI\u0006$Xm\u001d*fa2L7-Y!tg&<g.\\3oi>sG.\u001f\u0015\u0004%\u0005]\u0002cA<\u0002:%\u0019\u00111\b=\u0003\tQ+7\u000f^\u0001Ai\u0016\u001cH/\u00169eCR,\u0007+\u0019:uSRLwN\u001c$vY2\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e^+qI\u0006$Xm\u001d*fa2L7-Y!tg&<g.\\3oi\"\u001a1#a\u000e\u0002\u0017R,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$(+\u001a;ve:\u001cX)\u001c9usN+\u0017/\u00134U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0007Q\t9$\u0001,uKN$\b+\u0019:uSRLwN\u001c$vY2\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e*fiV\u0014hn]#naRL\u0018i]:jO:lWM\u001c;JMR{\u0007/[2PeB\u000b'\u000f^5uS>tGi\\3t\u001d>$X\t_5ti\"\u001aQ#a\u000e\u0002\u0011R,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$hi\u001c:U_BL7MU3ukJt7/R7qifl\u0015\r]%g)>\u0004\u0018n\u0019#pKNtu\u000e^#ySN$\bf\u0001\f\u00028\u00059E/Z:u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e$peR{\u0007/[2SKR,(O\\:FqB,7\r^3e%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$8\u000fK\u0002\u0018\u0003o\ta\u0004^3tiB\u000b'\u000f^5uS>t'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0007a\t9$A\u0015uKN$(+Z1tg&<g.\\3oi\u001a\u0013x.\\(cg\u0016\u0014h/\u001a:U_NKhn\u0019*fa2L7-\u0019\u0015\u00043\u0005]\u0012\u0001\u0007;fgR\u0014V-\\8wC2|emU=oGJ+\u0007\u000f\\5dC\"\u001a!$a\u000e\u0002+Q,7\u000f\u001e*f[>4\u0018\r\\(g\u001f\n\u001cXM\u001d<fe\"\u001a1$a\u000e\u0002gQ,7\u000f\u001e*f[>4\u0018\r\\(g\u001f\n\u001cXM\u001d<fe\u0006sG-T1lKNKhn\u0019*fa2L7-Y%oi>|%m]3sm\u0016\u0014\bf\u0001\u000f\u00028\u0005IC/Z:u%\u0016lwN^1m\u001f\u001a\u001c\u0016P\\2SKBd\u0017nY1B]\u0012|%m]3sm\u0016\u00148\t[1oO\u0016D3!HA\u001c\u00035\"Xm\u001d;SK\u0006\u001c8/[4o[\u0016tGoU<baN|%m]3sm\u0016\u00148/\u00118e'ft7MU3qY&\u001c\u0017m\u001d\u0015\u0004=\u0005]\u0012!\u0007;fgR\u0014V-Y:tS\u001etGk\\%eK6\u0004x\u000e^3oG\u0016D3aHA\u001c\u00039!Xm\u001d;SK\u0006\u001c8/[4o)>D3\u0001IA\u001c\u0003\u0005\"Xm\u001d;SK6|g/\u001b8h%\u0016\u0004H.[2b)\u0006\u0014x-\u001a;PEN,'O^3sQ\r\t\u0013qG\u0001$i\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1J[\n\fG.\u00198dK6+GO]5dQ\r\u0011\u0013qG\u0001 i\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>t\u0007fA\u0012\u00028\u0005)C/Z:u!J,g-\u001a:sK\u0012dU-\u00193fe^KG\u000f\u001b#f[>$X\r\u001a\"s_.,'o\u001d\u0015\u0004I\u0005]\u0012A\t;fgR\u0004\u0016M\u001d;ji&|gn],ji\"dU-\u00193feN|eN\u0011:pW\u0016\u00148\u000fK\u0002&\u0003o\t1\u0006^3tiB\u000b'\u000f^5uS>t7oV5uQB\u0013XMZ3se\u0016$G*Z1eKJ\u001cxJ\u001c\"s_.,'o\u001d\u0015\u0004M\u0005]\u0012\u0001\u0007;fgR\u001cV\r\u001e#f[>$X\r\u001a\"s_.,'/\u00138g_\"\u001aq%a\u000e\u0002yQ,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u00136\u0014\u0017\r\\1oG\u0016lU\r\u001e:jG>s7i\u001c8dkJ\u0014XM\u001c;U_BL7\rR3mKRLwN\u001c")
public class ControllerContextTest {
    private ControllerContext context = null;
    private final ReplicaExclusionCache exclusionCache = new ReplicaExclusionCache();
    private final Seq<Object> brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public ReplicaExclusionCache exclusionCache() {
        return this.exclusionCache;
    }

    public Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @BeforeEach
    public void setUp() {
        this.context_$eq(new ControllerContext());
        Map<Broker, Object> brokerEpochs = this.generateBrokerEpochs((Map<Object, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToLong((long)1L))}))));
        this.context().setLiveBrokers(brokerEpochs);
        this.createTopicPartitions((Seq<TopicPartition>)new .colon.colon((Object)this.tp1(), (List)new .colon.colon((Object)this.tp2(), (List)new .colon.colon((Object)this.tp3(), (List)Nil$.MODULE$))));
    }

    private void createTopicPartitions(Seq<TopicPartition> partitions) {
        IntRef leaderIndex = IntRef.create((int)0);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ControllerContextTest.$anonfun$createTopicPartitions$1(this, leaderIndex, partition);
            return BoxedUnit.UNIT;
        });
    }

    private Map<Broker, Object> generateBrokerEpochs(Map<Object, Object> brokerAndEpochs) {
        return (Map)brokerAndEpochs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            long brokerEpoch = x0$1._2$mcJ$sp();
            EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)brokerEpoch));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
    }

    @Test
    public void testUpdatePartitionReplicaAssignmentUpdatesReplicaAssignmentOnly() {
        Seq expectedReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(expectedReplicas, (Seq)Nil$.MODULE$));
        Seq assignment = this.context().partitionReplicaAssignment(this.tp1());
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedReplicas, (Object)assignment);
        Assertions.assertEquals((Object)expectedReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        Seq initialReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(initialReplicas, (Seq)Nil$.MODULE$));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assertions.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assertions.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.empty();
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assertions.assertEquals((Object)Map$.MODULE$.empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        Map expectedAssignments = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assertions.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition.targetAssignment());
        ReplicaAssignment reassigningPartition2 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition2.targetAssignment());
        ReplicaAssignment reassigningPartition3 = new ReplicaAssignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition3.targetAssignment());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$);
        Assertions.assertFalse((boolean)partition.isBeingReassigned());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$), (Object)partition.targetReplicaAssignment());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition4.targetAssignment());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assertions.assertEquals((Object)new Some((Object)new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Nil$.MODULE$)), (Object)reassigningPartition5.targetAssignment());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$).reassignTo(new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Nil$.MODULE$), (Object)nonReassigningPartition.targetReplicaAssignment());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assertions.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignmentFromObserverToSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplica() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfObserverAndMakeSyncReplicaIntoObserver() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testRemovalOfSyncReplicaAndObserverChange() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 3})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 3})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2, 3})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassignment.removingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassignment.effectiveObservers());
    }

    @Test
    public void testReassignmentSwapsObserversAndSyncReplicas() {
        ReplicaAssignment initialAssignment = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        ReplicaAssignment.Assignment newAssignment = new ReplicaAssignment.Assignment((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        ReplicaAssignment reassignment = initialAssignment.reassignTo(newAssignment);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 1, 2})), (Object)reassignment.replicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)reassignment.effectiveObservers());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)reassignment.removingReplicas());
    }

    @Test
    public void testReassignToIdempotence() {
        ReplicaAssignment assignment1 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        Assertions.assertEquals((Object)assignment1, (Object)assignment1.reassignTo(new ReplicaAssignment.Assignment(assignment1.replicas(), assignment1.observers())));
        ReplicaAssignment assignment2 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertEquals((Object)assignment2, (Object)assignment2.reassignTo((ReplicaAssignment.Assignment)assignment2.targetAssignment().get()));
        ReplicaAssignment assignment3 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$));
        Assertions.assertEquals((Object)assignment3, (Object)assignment3.reassignTo((ReplicaAssignment.Assignment)assignment3.targetAssignment().get()));
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$);
        ReplicaAssignment firstReassign = assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$)), (Object)firstReassign);
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$)), (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Nil$.MODULE$)), (Object)assignment.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Nil$.MODULE$)));
        Assertions.assertEquals((Object)assignment, (Object)firstReassign.reassignTo(new ReplicaAssignment.Assignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$)));
    }

    @Test
    public void testRemovingReplicaTargetObserver() {
        Assertions.assertEquals((Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))).removeReplica(3), (Object)new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Nil$.MODULE$, (Option)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})))));
    }

    @Test
    public void testPreferredReplicaImbalanceMetric() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp3(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp3().topic()})));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().removeTopic(this.tp1().topic());
        this.context().removeTopic(this.tp2().topic());
        this.context().removeTopic(this.tp3().topic());
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    @Test
    public void testPreferredLeaderForPartition() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)2, (int)this.context().preferredLeaderForPartition(this.tp1()));
    }

    @Test
    public void testPreferredLeaderWithDemotedBrokers() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
        this.context().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.context().demotedBrokerIds());
        Assertions.assertEquals((int)1, (int)this.context().preferredLeaderForPartition(this.tp1()));
    }

    @Test
    public void testPartitionsWithLeadersOnBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()})), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))));
        String topic = "large topic";
        this.createTopicPartitions((Seq<TopicPartition>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> ControllerContextTest.$anonfun$testPartitionsWithLeadersOnBrokers$1(topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
        Assertions.assertEquals((Object)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 33).map((Function1 & Serializable & scala.Serializable)i -> ControllerContextTest.$anonfun$testPartitionsWithLeadersOnBrokers$2(topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toSet(), (Object)this.context().partitionsWithLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
    }

    @Test
    public void testPartitionsWithPreferredLeadersOnBrokers() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithPreferredLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()})), (Object)this.context().partitionsWithPreferredLeadersOnGivenBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
    }

    @Test
    public void testSetDemotedBrokerInfo() {
        this.context().setDemotedReasons(1, (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.context().demotedBrokerIds());
        this.context().setDemotedReasons(2, (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.context().demotedBrokerIds());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})), (Object)this.context().demotedReasons(1));
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"reason"})), (Object)this.context().demotedReasons(2));
        this.context().setDemotedReasons(1, Set$.MODULE$.empty());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.context().demotedBrokerIds());
    }

    public void testPreferredReplicaImbalanceMetricOnConcurrentTopicDeletion() {
        String topicA = "A";
        String topicB = "B";
        TopicPartition tpA = new TopicPartition(topicA, 0);
        TopicPartition tpB = new TopicPartition(topicB, 0);
        this.context().updatePartitionFullReplicaAssignment(tpA, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        this.context().updatePartitionFullReplicaAssignment(tpB, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Nil$.MODULE$));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicA})));
        this.context().putPartitionLeadershipInfo(tpA, new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicA, topicB})));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    public static final /* synthetic */ void $anonfun$createTopicPartitions$1(ControllerContextTest $this, IntRef leaderIndex$1, TopicPartition partition) {
        IndexedSeq replicas = (IndexedSeq)$this.brokers().indices().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)$this.brokers().apply((i + leaderIndex$1.elem) % $this.brokers().size())), IndexedSeq$.MODULE$.canBuildFrom());
        $this.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas, (Seq)Nil$.MODULE$));
        $this.context().putPartitionLeadershipInfo(partition, new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)replicas.head()), replicas.toList()), 0));
        ++leaderIndex$1.elem;
    }

    public static final /* synthetic */ TopicPartition $anonfun$testPartitionsWithLeadersOnBrokers$1(String topic$1, int i) {
        return new TopicPartition(topic$1, i);
    }

    public static final /* synthetic */ TopicPartition $anonfun$testPartitionsWithLeadersOnBrokers$2(String topic$1, int i) {
        return new TopicPartition(topic$1, i * 3);
    }
}

