/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControlMetadataAccumulator;
import kafka.controller.ControlMetadataBatch;
import kafka.controller.ControlMetadataBatchResult;
import kafka.controller.LeaderAndIsrBatch;
import kafka.controller.QueueItem;
import kafka.controller.StopReplicaBatch;
import kafka.controller.UpdateMetadataBatch;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004:\u0001\u0001\u0006IA\u000e\u0005\bu\u0001\u0011\r\u0011\"\u0001<\u0011\u00191\u0005\u0001)A\u0005y!)q\t\u0001C\u0001\u0011\")\u0011\f\u0001C\u0001\u0011\")a\f\u0001C\u0001\u0011\")\u0001\r\u0001C\u0001\u0011\")!\r\u0001C\u0001\u0011\")A\r\u0001C\u0001\u0011\")a\r\u0001C\u0001\u0011\")\u0001\u000e\u0001C\u0001\u0011\")!\u000e\u0001C\u0001W\u001a9A\u000f\u0001I\u0001$\u0003)\bbBA\u0001\u001f\u0019\u0005\u00111\u0001\u0004\u0007\u00037\u0001\u0001!!\b\t\u0015\u0005%\u0012C!b\u0001\n\u0003\tY\u0003\u0003\u0006\u00024E\u0011\t\u0011)A\u0005\u0003[A\u0011\u0002]\t\u0003\u0006\u0004%\t!!\u000e\t\u0013\u0005]\u0012C!A!\u0002\u0013\t\bB\u0002\u0019\u0012\t\u0003\tI\u0004C\u0005\u0002BE\u0011\r\u0011\"\u0001\u0002D!A\u0011qJ\t!\u0002\u0013\t)\u0005\u0003\u0004\u0002RE!\t\u0001\u0013\u0005\b\u0003\u0003\tB\u0011AA*\r\u0019\t)\u0006\u0001\u0001\u0002X!Q\u0011\u0011F\u000e\u0003\u0006\u0004%\t!a\u000b\t\u0015\u0005M2D!A!\u0002\u0013\ti\u0003\u0003\u000417\u0011\u0005\u00111\f\u0005\n\u0003\u0003Z\"\u0019!C\u0001\u0003CB\u0001\"a\u0014\u001cA\u0003%\u00111\r\u0005\u0007\u0003#ZB\u0011\u0001%\t\u000f\u0005\u00051\u0004\"\u0001\u0002f\tq2i\u001c8ue>dW*\u001a;bI\u0006$\u0018-Q2dk6,H.\u0019;peR+7\u000f\u001e\u0006\u0003K\u0019\n!bY8oiJ|G\u000e\\3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001%\u0003!qG\u000b\u001b:fC\u0012\u001cX#\u0001\u001c\u0011\u0005-:\u0014B\u0001\u001d-\u0005\rIe\u000e^\u0001\n]RC'/Z1eg\u0002\n\u0001\"\u001a=fGV$xN]\u000b\u0002yA\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u000bG>t7-\u001e:sK:$(BA!C\u0003\u0011)H/\u001b7\u000b\u0003\r\u000bAA[1wC&\u0011QI\u0010\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\u0006IQ\r_3dkR|'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\t\u0011\n\u0005\u0002,\u0015&\u00111\n\f\u0002\u0005+:LG\u000f\u000b\u0002\u0007\u001bB\u0011ajV\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0004CBL'B\u0001*T\u0003\u001dQW\u000f]5uKJT!\u0001V+\u0002\u000b),h.\u001b;\u000b\u0003Y\u000b1a\u001c:h\u0013\tAvJA\u0005BMR,'/R1dQ\u0006\tB/Z:u\u0007\u0006t\u0007+\u001e;B]\u0012$\u0016m[3)\u0005\u001dY\u0006C\u0001(]\u0013\tivJ\u0001\u0003UKN$\u0018!\u0007;fgR\u0004V\u000f^'fe\u001e,\u0017I\u001c3J]Z\fG.\u001b3bi\u0016D#\u0001C.\u00023Q,7\u000f\u001e)viJ+7\u000f]3di\ncwnY6Ti\u0006$Xo\u001d\u0015\u0003\u0013m\u000b\u0011\u0004^3tiB+HOU3n_Z,W)\u001c9us\n\u000bGo\u00195fg\"\u0012!bW\u0001\u000fi\u0016\u001cH\u000fV1lK\ncwnY6tQ\tY1,A\u0014uKN$8i\u001c8dkJ\u0014XM\u001c;QkR\u001c\u0018I\u001c3UC.,7/\u00138SC:$w.\\(sI\u0016\u0014\bF\u0001\u0007\\\u0003%!Xm\u001d;DY>\u001cX\r\u000b\u0002\u000e7\u0006aa.Z<Rk\u0016,X-\u0013;f[R\u0011An\u001c\t\u0003g5L!A\u001c\u0013\u0003\u0013E+X-^3Ji\u0016l\u0007\"\u00029\u000f\u0001\u0004\t\u0018!\u00022bi\u000eD\u0007CA\u001as\u0013\t\u0019HE\u0001\u000bD_:$(o\u001c7NKR\fG-\u0019;b\u0005\u0006$8\r\u001b\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0016\u0007Y\fIaE\u0002\u0010ov\u0004\"\u0001_>\u000e\u0003eT!A\u001f\"\u0002\t1\fgnZ\u0005\u0003yf\u0014aa\u00142kK\u000e$\bC\u0001=\u007f\u0013\ty\u0018P\u0001\u0005Sk:t\u0017M\u00197f\u0003\u0015\tw/Y5u)\t\t)\u0001\u0005\u0003\u0002\b\u0005%A\u0002\u0001\u0003\b\u0003\u0017y!\u0019AA\u0007\u0005\u0005!\u0016\u0003BA\b\u0003+\u00012aKA\t\u0013\r\t\u0019\u0002\f\u0002\b\u001d>$\b.\u001b8h!\rY\u0013qC\u0005\u0004\u00033a#aA!os\n\u0019\u0001+\u001e;\u0014\tE9\u0018q\u0004\t\u0006\u0003Cy\u00111E\u0007\u0002\u0001A\u00191&!\n\n\u0007\u0005\u001dBFA\u0004C_>dW-\u00198\u0002\u000bE,X-^3\u0016\u0005\u00055\u0002cA\u001a\u00020%\u0019\u0011\u0011\u0007\u0013\u00035\r{g\u000e\u001e:pY6+G/\u00193bi\u0006\f5mY;nk2\fGo\u001c:\u0002\rE,X-^3!+\u0005\t\u0018A\u00022bi\u000eD\u0007\u0005\u0006\u0004\u0002<\u0005u\u0012q\b\t\u0004\u0003C\t\u0002bBA\u0015-\u0001\u0007\u0011Q\u0006\u0005\u0006aZ\u0001\r!]\u0001\baJ|W.[:f+\t\t)\u0005\u0005\u0004\u0002H\u0005-\u00131E\u0007\u0003\u0003\u0013R!a\u0010\u0017\n\t\u00055\u0013\u0011\n\u0002\b!J|W.[:f\u0003!\u0001(o\\7jg\u0016\u0004\u0013a\u0001:v]R\u0011\u00111\u0005\u0002\u0005)\u0006\\Wm\u0005\u0003\u001co\u0006e\u0003\u0003BA\u0011\u001fE$B!!\u0018\u0002`A\u0019\u0011\u0011E\u000e\t\u000f\u0005%b\u00041\u0001\u0002.U\u0011\u00111\r\t\u0006\u0003\u000f\nY%\u001d\u000b\u0002c\u0002")
public class ControlMetadataAccumulatorTest {
    private final int nThreads;
    private final ExecutorService executor = Executors.newFixedThreadPool(this.nThreads());

    public int nThreads() {
        return this.nThreads;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    @AfterEach
    public void tearDown() {
        if (this.executor() != null) {
            this.executor().shutdownNow();
        }
    }

    @Test
    public void testCanPutAndTake() {
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        StopReplicaBatch stopReplica = new StopReplicaBatch(0).addPartitionState(new TopicPartition("topic", 0), new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0).setLeaderEpoch(0));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica));
        Assertions.assertEquals((Object)accumulator.take().batch(), (Object)stopReplica);
    }

    @Test
    public void testPutMergeAndInvalidate() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        LeaderAndIsrBatch leaderAndIsr = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1)).addPartitionState(tp1, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(2));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        StopReplicaBatch stopReplica2 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(3));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica2));
        Assertions.assertEquals((int)2, (int)accumulator.size());
        QueueItem firstItem = accumulator.take();
        Assertions.assertTrue((boolean)(firstItem.batch() instanceof LeaderAndIsrBatch));
        LeaderAndIsrBatch takenLeaderAndIsr = (LeaderAndIsrBatch)firstItem.batch();
        Assertions.assertEquals((int)1, (int)takenLeaderAndIsr.partitions().size());
        Assertions.assertNotNull((Object)takenLeaderAndIsr.partitions().get((Object)tp1).orNull(Predef$.MODULE$.$conforms()));
        QueueItem secondItem = accumulator.take();
        Assertions.assertTrue((boolean)(secondItem.batch() instanceof StopReplicaBatch));
        StopReplicaBatch takenStopReplica = (StopReplicaBatch)secondItem.batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica.partitions().get((Object)tp0).orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testPutRespectBlockStatus() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 3);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(0));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp1, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1)).addPartitionState(tp2, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1)).setContainsAllReplicas();
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr1));
        LeaderAndIsrBatch leaderAndIsr2 = new LeaderAndIsrBatch(0).addPartitionState(tp1, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(3)).addPartitionState(tp2, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(3));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr2));
        StopReplicaBatch stopReplica2 = new StopReplicaBatch(0).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(4));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica2));
        Assertions.assertEquals((int)3, (int)accumulator.size());
        StopReplicaBatch takenStopReplica1 = (StopReplicaBatch)accumulator.take().batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica1.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica1.partitions().get((Object)tp0).orNull(Predef$.MODULE$.$conforms()));
        LeaderAndIsrBatch takenLeaderAndIsr1 = (LeaderAndIsrBatch)accumulator.take().batch();
        Assertions.assertEquals((int)2, (int)takenLeaderAndIsr1.partitions().size());
        Assertions.assertNotNull((Object)takenLeaderAndIsr1.partitions().get((Object)tp1).orNull(Predef$.MODULE$.$conforms()));
        Assertions.assertNotNull((Object)takenLeaderAndIsr1.partitions().get((Object)tp2).orNull(Predef$.MODULE$.$conforms()));
        StopReplicaBatch takenStopReplica2 = (StopReplicaBatch)accumulator.take().batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica2.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica2.partitions().get((Object)tp1).orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testPutRemoveEmptyBatches() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr1));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp0, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(2));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        Assertions.assertEquals((int)1, (int)accumulator.size());
        QueueItem item1 = accumulator.take();
        Assertions.assertTrue((boolean)(item1.batch() instanceof StopReplicaBatch));
        StopReplicaBatch takenStopReplica1 = (StopReplicaBatch)item1.batch();
        Assertions.assertEquals((int)1, (int)takenStopReplica1.partitions().size());
        Assertions.assertNotNull((Object)takenStopReplica1.partitions().get((Object)tp0).orNull(Predef$.MODULE$.$conforms()));
        Assertions.assertEquals((int)0, (int)accumulator.size());
    }

    @Test
    public void testTakeBlocks() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 2);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable & scala.Serializable)x$1 -> ControlMetadataAccumulatorTest.$anonfun$testTakeBlocks$1(this, accumulator, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataAccumulatorTest.$anonfun$testTakeBlocks$3(x$2))));
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)leaderAndIsr1));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)stopReplica1));
        UpdateMetadataBatch updateMetadata1 = new UpdateMetadataBatch(0).addPartitionState(tp2, new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeaderEpoch(1));
        accumulator.put(this.newQueueItem((ControlMetadataBatch)updateMetadata1));
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataAccumulatorTest.$anonfun$testTakeBlocks$4(x$3))));
        accumulator.close();
    }

    @Test
    public void testConcurrentPutsAndTakesInRandomOrder() {
        TopicPartition tp0 = new TopicPartition("topic", 0);
        TopicPartition tp1 = new TopicPartition("topic", 1);
        TopicPartition tp2 = new TopicPartition("topic", 2);
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        LeaderAndIsrBatch leaderAndIsr1 = new LeaderAndIsrBatch(0).addPartitionState(tp0, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setLeaderEpoch(1));
        StopReplicaBatch stopReplica1 = new StopReplicaBatch(0).addPartitionState(tp1, new StopReplicaRequestData.StopReplicaPartitionState().setLeaderEpoch(1));
        UpdateMetadataBatch updateMetadata1 = new UpdateMetadataBatch(0).addPartitionState(tp2, new UpdateMetadataRequestData.UpdateMetadataPartitionState().setLeaderEpoch(1));
        .colon.colon puts = new .colon.colon((Object)new Put(this, accumulator, (ControlMetadataBatch)leaderAndIsr1), (List)new .colon.colon((Object)new Put(this, accumulator, (ControlMetadataBatch)stopReplica1), (List)new .colon.colon((Object)new Put(this, accumulator, (ControlMetadataBatch)updateMetadata1), (List)Nil$.MODULE$)));
        IndexedSeq takes = (IndexedSeq)puts.indices().map((Function1 & Serializable & scala.Serializable)x$4 -> ControlMetadataAccumulatorTest.$anonfun$testConcurrentPutsAndTakesInRandomOrder$1(this, accumulator, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        ((List)Random$.MODULE$.shuffle((TraversableOnce)puts.$plus$plus((GenTraversableOnce)takes, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> this.executor().submit((Runnable)x$1), List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true})), (Object)((TraversableOnce)puts.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.await()), List$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ControlMetadataBatch[]{leaderAndIsr1, stopReplica1, updateMetadata1})), (Object)((TraversableOnce)takes.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.await(), IndexedSeq$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testClose() {
        ControlMetadataAccumulator accumulator = new ControlMetadataAccumulator();
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1 & Serializable & scala.Serializable)x$7 -> ControlMetadataAccumulatorTest.$anonfun$testClose$1(this, accumulator, BoxesRunTime.unboxToInt((Object)x$7)), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataAccumulatorTest.$anonfun$testClose$3(x$8))));
        accumulator.close();
        Assertions.assertTrue((boolean)futures.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControlMetadataAccumulatorTest.$anonfun$testClose$4(x$9))));
    }

    public QueueItem newQueueItem(ControlMetadataBatch batch) {
        return new QueueItem(batch, (Function2 & Serializable & scala.Serializable)(x$10, x$11) -> {
            ControlMetadataAccumulatorTest.$anonfun$newQueueItem$1(x$10, x$11);
            return BoxedUnit.UNIT;
        }, Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ Future $anonfun$testTakeBlocks$1(ControlMetadataAccumulatorTest $this, ControlMetadataAccumulator accumulator$1, int x$1) {
        return $this.executor().submit(() -> accumulator$1.take());
    }

    public static final /* synthetic */ boolean $anonfun$testTakeBlocks$3(Future x$2) {
        return !x$2.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testTakeBlocks$4(Future x$3) {
        return x$3.get() instanceof QueueItem;
    }

    public static final /* synthetic */ Take $anonfun$testConcurrentPutsAndTakesInRandomOrder$1(ControlMetadataAccumulatorTest $this, ControlMetadataAccumulator accumulator$2, int x$4) {
        return new Take($this, accumulator$2);
    }

    public static final /* synthetic */ Future $anonfun$testClose$1(ControlMetadataAccumulatorTest $this, ControlMetadataAccumulator accumulator$3, int x$7) {
        return $this.executor().submit(() -> accumulator$3.take());
    }

    public static final /* synthetic */ boolean $anonfun$testClose$3(Future x$8) {
        return !x$8.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testClose$4(Future x$9) {
        return x$9.get() == null;
    }

    public static final /* synthetic */ void $anonfun$newQueueItem$1(ControlMetadataBatch x$10, ControlMetadataBatchResult x$11) {
    }

    public ControlMetadataAccumulatorTest() {
        this.nThreads = 5;
    }

    public interface Action<T>
    extends Runnable {
        public T await();
    }

    public class Put
    implements Action<Object> {
        private final ControlMetadataAccumulator queue;
        private final ControlMetadataBatch batch;
        private final Promise<Object> promise;
        public final /* synthetic */ ControlMetadataAccumulatorTest $outer;

        public ControlMetadataAccumulator queue() {
            return this.queue;
        }

        public ControlMetadataBatch batch() {
            return this.batch;
        }

        public Promise<Object> promise() {
            return this.promise;
        }

        @Override
        public void run() {
            this.queue().put(this.kafka$controller$ControlMetadataAccumulatorTest$Put$$$outer().newQueueItem(this.batch()));
            this.promise().success((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }

        @Override
        public boolean await() {
            return BoxesRunTime.unboxToBoolean((Object)Await$.MODULE$.result((Awaitable)this.promise().future(), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS)));
        }

        public /* synthetic */ ControlMetadataAccumulatorTest kafka$controller$ControlMetadataAccumulatorTest$Put$$$outer() {
            return this.$outer;
        }

        public Put(ControlMetadataAccumulatorTest $outer, ControlMetadataAccumulator queue, ControlMetadataBatch batch) {
            this.queue = queue;
            this.batch = batch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.promise = Promise$.MODULE$.apply();
        }
    }

    public class Take
    implements Action<ControlMetadataBatch> {
        private final ControlMetadataAccumulator queue;
        private final Promise<ControlMetadataBatch> promise;
        public final /* synthetic */ ControlMetadataAccumulatorTest $outer;

        public ControlMetadataAccumulator queue() {
            return this.queue;
        }

        public Promise<ControlMetadataBatch> promise() {
            return this.promise;
        }

        @Override
        public void run() {
            QueueItem item = this.queue().take();
            if (item == null) {
                this.promise().success(null);
                return;
            }
            this.promise().success((Object)item.batch());
        }

        @Override
        public ControlMetadataBatch await() {
            return (ControlMetadataBatch)Await$.MODULE$.result((Awaitable)this.promise().future(), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
        }

        public /* synthetic */ ControlMetadataAccumulatorTest kafka$controller$ControlMetadataAccumulatorTest$Take$$$outer() {
            return this.$outer;
        }

        public Take(ControlMetadataAccumulatorTest $outer, ControlMetadataAccumulator queue) {
            this.queue = queue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.promise = Promise$.MODULE$.apply();
        }
    }
}

