/*
 * Decompiled with CFR 0.152.
 */
package kafka.api.test;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kafka.api.test.ProducerCompressionTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\n\u0014\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u00030\u0011\u0019A\u0004\u0001)A\u0005a!9\u0011\b\u0001b\u0001\n\u00131\u0003B\u0002\u001e\u0001A\u0003%q\u0005C\u0004\u001f\u0001\u0001\u0007I\u0011B\u001e\t\u000f}\u0002\u0001\u0019!C\u0005\u0001\"1a\t\u0001Q!\nqBQa\u0012\u0001\u0005B!CQA\u0017\u0001\u0005BmCQ\u0001\u0019\u0001\u0005\u0002\u0005<q!!\u0001\u0014\u0011\u0003\t\u0019A\u0002\u0004\u0013'!\u0005\u0011Q\u0001\u0005\u0007C=!\t!!\u0004\t\ri|A\u0011AA\b\u0005]\u0001&o\u001c3vG\u0016\u00148i\\7qe\u0016\u001c8/[8o)\u0016\u001cHO\u0003\u0002\u0015+\u0005!A/Z:u\u0015\t1r#A\u0002ba&T\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f/\u000511/\u001a:wKJL!\u0001I\u000f\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002GA\u0011A\u0005A\u0007\u0002'\u0005A!M]8lKJLE-F\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\nQ\u0001^8qS\u000e,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!B\\;n%\u0016\u001cwN\u001d3t\u0003-qW/\u001c*fG>\u0014Hm\u001d\u0011\u0016\u0003q\u0002\"\u0001H\u001f\n\u0005yj\"aC&bM.\f7+\u001a:wKJ\f!b]3sm\u0016\u0014x\fJ3r)\t\tE\t\u0005\u0002)\u0005&\u00111)\u000b\u0002\u0005+:LG\u000fC\u0004F\u0013\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013'A\u0004tKJ4XM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005K\u0005\"\u0002&\f\u0001\u0004Y\u0015\u0001\u0003;fgRLeNZ8\u0011\u00051#V\"A'\u000b\u0005Yq%BA(Q\u0003\u001dQW\u000f]5uKJT!!\u0015*\u0002\u000b),h.\u001b;\u000b\u0003M\u000b1a\u001c:h\u0013\t)VJ\u0001\u0005UKN$\u0018J\u001c4pQ\tYq\u000b\u0005\u0002M1&\u0011\u0011,\u0014\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0005C#\u0001D/\u0011\u00051s\u0016BA0N\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\buKN$8i\\7qe\u0016\u001c8/[8o)\t\t%\rC\u0003d\u001b\u0001\u0007A-A\u0006d_6\u0004(/Z:tS>t\u0007CA3m\u001d\t1'\u000e\u0005\u0002hS5\t\u0001N\u0003\u0002j3\u00051AH]8pizJ!a[\u0015\u0002\rA\u0013X\rZ3g\u0013\t9TN\u0003\u0002lS!\"Qb\\<y!\t\u0001X/D\u0001r\u0015\t\u00118/\u0001\u0005qe>4\u0018\u000eZ3s\u0015\t!h*\u0001\u0004qCJ\fWn]\u0005\u0003mF\u0014A\"T3uQ>$7k\\;sG\u0016\fQA^1mk\u0016d\u0013!_\u0011\u0002u\u0006Q\u0001/\u0019:b[\u0016$XM]:)\u00055a\bCA?\u007f\u001b\u0005\u0019\u0018BA@t\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0018!J|G-^2fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgR\u0004\"\u0001J\b\u0014\u0007=\t9\u0001E\u0002)\u0003\u0013I1!a\u0003*\u0005\u0019\te.\u001f*fMR\u0011\u00111A\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001e\u0005\u0005RBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\rM$(/Z1n\u0015\r\tY\u0002N\u0001\u0005kRLG.\u0003\u0003\u0002 \u0005U!AB*ue\u0016\fW\u000eE\u0002q\u0003GI1!!\nr\u0005%\t%oZ;nK:$8\u000f")
public class ProducerCompressionTest
extends QuorumTestHarness {
    private final int brokerId;
    private final String topic;
    private final int numRecords;
    private KafkaServer server = null;

    public static Stream<Arguments> parameters() {
        return ProducerCompressionTest$.MODULE$.parameters();
    }

    private int brokerId() {
        return this.brokerId;
    }

    private String topic() {
        return this.topic;
    }

    private int numRecords() {
        return this.numRecords;
    }

    private KafkaServer server() {
        return this.server;
    }

    private void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.server_$eq(TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(new .colon.colon((Object)this.server(), (List)Nil$.MODULE$), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testCompression(String compression) {
        Properties producerProps = new Properties();
        String bootstrapServers = TestUtils$.MODULE$.plaintextBootstrapServers(new .colon.colon((Object)this.server(), (List)Nil$.MODULE$));
        producerProps.put("bootstrap.servers", bootstrapServers);
        producerProps.put("compression.type", compression);
        producerProps.put("batch.size", "66000");
        producerProps.put("linger.ms", "200");
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(bootstrapServers, TestUtils$.MODULE$.createConsumer$default$2(), TestUtils$.MODULE$.createConsumer$default$3(), TestUtils$.MODULE$.createConsumer$default$4(), TestUtils$.MODULE$.createConsumer$default$5(), TestUtils$.MODULE$.createConsumer$default$6(), TestUtils$.MODULE$.createConsumer$default$7(), TestUtils$.MODULE$.createConsumer$default$8(), TestUtils$.MODULE$.createConsumer$default$9(), TestUtils$.MODULE$.createConsumer$default$10(), TestUtils$.MODULE$.createConsumer$default$11(), TestUtils$.MODULE$.createConsumer$default$12());
        try {
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaBroker>)new .colon.colon((Object)this.server(), (List)Nil$.MODULE$), TestUtils$.MODULE$.createTopic$default$6());
            int partition = 0;
            IndexedSeq messageValues = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRecords()).map((Function1 & Serializable & scala.Serializable)i -> ProducerCompressionTest.$anonfun$testCompression$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            long now = System.currentTimeMillis();
            ((TraversableLike)((IndexedSeq)messageValues.map((Function1 & Serializable & scala.Serializable)message -> producer.send(new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(now), null, (Object)message.getBytes())), IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                ProducerCompressionTest.$anonfun$testCompression$4(x$1);
                return BoxedUnit.UNIT;
            });
            TopicPartition tp = new TopicPartition(this.topic(), partition);
            consumer.assign(Collections.singleton(tp));
            consumer.seek(tp, 0L);
            Seq records = TestUtils$.MODULE$.consumeRecords(consumer, this.numRecords(), TestUtils$.MODULE$.consumeRecords$default$3());
            ((TraversableLike)((IterableLike)messageValues.zip(records, IndexedSeq$.MODULE$.canBuildFrom())).zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null && (Tuple2)check$ifrefutable$2._1() != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                ProducerCompressionTest.$anonfun$testCompression$6(now, x$2);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            producer.close();
            consumer.close();
        }
    }

    public static final /* synthetic */ String $anonfun$testCompression$1(int i) {
        return new StringBuilder(5).append("value").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompression$4(Tuple2 x$1) {
        if (x$1 != null) {
            Future future = (Future)x$1._1();
            Assertions.assertEquals((long)x$1._2$mcI$sp(), (long)((RecordMetadata)future.get()).offset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testCompression$6(long now$1, Tuple2 x$2) {
        if (x$2 != null) {
            Tuple2 tuple2 = (Tuple2)x$2._1();
            int index = x$2._2$mcI$sp();
            if (tuple2 != null) {
                String messageValue = (String)tuple2._1();
                ConsumerRecord record = (ConsumerRecord)tuple2._2();
                Assertions.assertEquals((Object)messageValue, (Object)new String((byte[])record.value()));
                Assertions.assertEquals((long)now$1, (long)record.timestamp());
                Assertions.assertEquals((long)index, (long)record.offset());
                return;
            }
        }
        throw new MatchError((Object)x$2);
    }

    public ProducerCompressionTest() {
        this.brokerId = 0;
        this.topic = "topic";
        this.numRecords = 2000;
    }
}

