/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.QuotaTestClients$;
import kafka.server.ClientQuotaManager;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5v!B\u00181\u0011\u0003)d!B\u001c1\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\u001d\u0006\u0001\u000b\u0011B\"\t\u000b=\u000bA\u0011\u0001)\u0007\u000b]\u0002\u0014\u0011A1\t\u0011\t4!\u0011!Q\u0001\n\rC\u0001b\u0019\u0004\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tU\u001a\u0011\t\u0011)A\u0005\u0007\"A1N\u0002B\u0001B\u0003%1\t\u0003\u0005m\r\t\u0015\r\u0011\"\u0001n\u0011!YhA!A!\u0002\u0013q\u0007\u0002\u0003?\u0007\u0005\u000b\u0007I\u0011A?\t\u0013\u0005\u001daA!A!\u0002\u0013q\bBCA\u0005\r\t\u0015\r\u0011\"\u0001\u0002\f!Q\u0011\u0011\u0004\u0004\u0003\u0002\u0003\u0006I!!\u0004\t\r}2A\u0011AA\u000e\u0011\u001d\tiC\u0002D\u0001\u0003_Aq!!\u0013\u0007\r\u0003\tY\u0005C\u0004\u0002N\u00191\t\"a\u0014\t\u000f\u0005\u0005dA\"\u0005\u0002d!9\u0011Q\u000f\u0004\u0005\u0002\u0005]\u0004\"CAG\rE\u0005I\u0011AAH\u0011\u001d\t)K\u0002C\u0001\u0003OC\u0011\"!,\u0007#\u0003%\t!a$\t\u000f\u0005=f\u0001\"\u0003\u00022\"9\u0011Q\u001a\u0004\u0005\n\u0005=\u0007bBAv\r\u0011\u0005\u0011Q\u001e\u0005\n\u0003s4\u0011\u0013!C\u0001\u0003\u001fC\u0011\"a?\u0007#\u0003%\t!a$\t\u000f\u0005uh\u0001\"\u0001\u0002\u0000\"I!q\u0001\u0004\u0012\u0002\u0013\u0005\u0011q\u0012\u0005\n\u0005\u00131\u0011\u0013!C\u0001\u0003\u001fCqAa\u0003\u0007\t\u0013\u0011i\u0001C\u0004\u0003\u001e\u0019!IAa\b\t\u000f\t-b\u0001\"\u0001\u0003.!9!\u0011\b\u0004\u0005\n\tm\u0002b\u0002B!\r\u0011\u0005!1\t\u0005\b\u0005\u000b2A\u0011\u0002B$\u0011\u001d\u0011YE\u0002C\u0001\u0005\u001bB\u0011Ba\u0017\u0007#\u0003%\tA!\u0018\t\u000f\t\u0005d\u0001\"\u0001\u0003d!9!q\u000f\u0004\u0005\u0002\te\u0004b\u0002BG\r\u0011\u0005!q\u0012\u0005\b\u000573A\u0011\u0001BO\u0011%\u00119KBI\u0001\n\u0003\u0011I+\u0001\tRk>$\u0018\rV3ti\u000ec\u0017.\u001a8ug*\u0011\u0011GM\u0001\u0004CBL'\"A\u001a\u0002\u000b-\fgm[1\u0004\u0001A\u0011a'A\u0007\u0002a\t\u0001\u0012+^8uCR+7\u000f^\"mS\u0016tGo]\n\u0003\u0003e\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00016\u00035!UMZ1vYR,e\u000e^5usV\t1\t\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\rnj\u0011a\u0012\u0006\u0003\u0011R\na\u0001\u0010:p_Rt\u0014B\u0001&<\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)[\u0014A\u0004#fM\u0006,H\u000e^#oi&$\u0018\u0010I\u0001\f[\u0016$(/[2WC2,X\r\u0006\u0002R)B\u0011!HU\u0005\u0003'n\u0012a\u0001R8vE2,\u0007\"B+\u0006\u0001\u00041\u0016AB7fiJL7\r\u0005\u0002X?6\t\u0001L\u0003\u0002Z5\u000611m\\7n_:T!aM.\u000b\u0005qk\u0016AB1qC\u000eDWMC\u0001_\u0003\ry'oZ\u0005\u0003Ab\u0013a!T3ue&\u001c7C\u0001\u0004:\u0003\u0015!x\u000e]5d\u0003)aW-\u00193fe:{G-\u001a\t\u0003K\"l\u0011A\u001a\u0006\u0003OJ\naa]3sm\u0016\u0014\u0018BA5g\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002!A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0017\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003!\u0001(o\u001c3vG\u0016\u0014X#\u00018\u0011\t=\u001cX/^\u0007\u0002a*\u0011A.\u001d\u0006\u0003ej\u000bqa\u00197jK:$8/\u0003\u0002ua\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u00042A\u000f<y\u0013\t98HA\u0003BeJ\f\u0017\u0010\u0005\u0002;s&\u0011!p\u000f\u0002\u0005\u0005f$X-A\u0005qe>$WoY3sA\u0005A1m\u001c8tk6,'/F\u0001\u007f!\u0015y\u00181A;v\u001b\t\t\tA\u0003\u0002}c&!\u0011QAA\u0001\u00055Y\u0015MZ6b\u0007>t7/^7fe\u0006I1m\u001c8tk6,'\u000fI\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014E\fQ!\u00193nS:LA!a\u0006\u0002\u0012\t)\u0011\tZ7j]\u0006a\u0011\rZ7j]\u000ec\u0017.\u001a8uAQ\u0001\u0012QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121\u0006\t\u0003m\u0019AQAY\tA\u0002\rCQaY\tA\u0002\u0011DQA[\tA\u0002\rCQa[\tA\u0002\rCQ\u0001\\\tA\u00029DQ\u0001`\tA\u0002yDq!!\u0003\u0012\u0001\u0004\ti!\u0001\bpm\u0016\u0014(/\u001b3f#V|G/Y:\u0015\u0011\u0005E\u0012qGA!\u0003\u000b\u00022AOA\u001a\u0013\r\t)d\u000f\u0002\u0005+:LG\u000fC\u0004\u0002:I\u0001\r!a\u000f\u0002\u001bA\u0014x\u000eZ;dKJ\fVo\u001c;b!\rQ\u0014QH\u0005\u0004\u0003\u007fY$\u0001\u0002'p]\u001eDq!a\u0011\u0013\u0001\u0004\tY$A\u0007d_:\u001cX/\\3s#V|G/\u0019\u0005\u0007\u0003\u000f\u0012\u0002\u0019A)\u0002\u0019I,\u0017/^3tiF+x\u000e^1\u0002)I,Wn\u001c<f#V|G/Y(wKJ\u0014\u0018\u000eZ3t)\t\t\t$A\u0007vg\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u000b\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0003bkRD'bAA.1\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002`\u0005U#AD&bM.\f\u0007K]5oG&\u0004\u0018\r\\\u0001\u0010cV|G/Y'fiJL7\rV1hgR!\u0011QMA9!\u0019\t9'!\u001cD\u00076\u0011\u0011\u0011\u000e\u0006\u0004\u0003WZ\u0014AC2pY2,7\r^5p]&!\u0011qNA5\u0005\ri\u0015\r\u001d\u0005\u0007\u0003g*\u0002\u0019A\"\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\fQ\u0003\u001d:pIV\u001cW-\u00168uS2$\u0006N]8ui2,G\r\u0006\u0004\u0002z\u0005}\u00141\u0011\t\u0004u\u0005m\u0014bAA?w\t\u0019\u0011J\u001c;\t\u000f\u0005\u0005e\u00031\u0001\u0002z\u0005QQ.\u0019=SK\u000e|'\u000fZ:\t\u0013\u0005\u0015e\u0003%AA\u0002\u0005\u001d\u0015\u0001G<bSR4uN\u001d*fcV,7\u000f^\"p[BdW\r^5p]B\u0019!(!#\n\u0007\u0005-5HA\u0004C_>dW-\u00198\u0002?A\u0014x\u000eZ;dKVsG/\u001b7UQJ|G\u000f\u001e7fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0012*\"\u0011qQAJW\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u0013Ut7\r[3dW\u0016$'bAAPw\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0016\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!F2p]N,X.Z+oi&dG\u000b\u001b:piRdW\r\u001a\u000b\u0007\u0003s\nI+a+\t\u000f\u0005\u0005\u0005\u00041\u0001\u0002z!I\u0011Q\u0011\r\u0011\u0002\u0003\u0007\u0011qQ\u0001 G>t7/^7f+:$\u0018\u000e\u001c+ie>$H\u000f\\3eI\u0011,g-Y;mi\u0012\u0012\u0014!B9v_R\fG\u0003CAZ\u0003\u007f\u000bI-a3\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/Y\u0003\u001diW\r\u001e:jGNLA!!0\u00028\n)\u0011+^8uC\"9\u0011\u0011\u0019\u000eA\u0002\u0005\r\u0017\u0001D9v_R\fW*\u00198bO\u0016\u0014\bcA3\u0002F&\u0019\u0011q\u00194\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM\u001d\u0005\b\u0003\u001bR\u0002\u0019AA)\u0011\u0019\t\u0019H\u0007a\u0001\u0007\u00061c/\u001a:jMf$\u0006N]8ui2,G+[7f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u001b\u0016$(/[2\u0015\u0015\u0005E\u0012\u0011[Aq\u0003K\f9\u000fC\u0004\u0002Tn\u0001\r!!6\u0002\r\u0005\u0004\u0018nS3z!\u0011\t9.!8\u000e\u0005\u0005e'bAAn1\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002`\u0006e'aB!qS.+\u0017p\u001d\u0005\u0007\u0003G\\\u0002\u0019A\"\u0002!5,GO]5d\u001d\u0006lWmU;gM&D\bBBA:7\u0001\u00071\tC\u0004\u0002jn\u0001\r!a\"\u0002\u001d\u0015D\b/Z2u)\"\u0014x\u000e\u001e;mK\u0006)b/\u001a:jMf\u0004&o\u001c3vG\u0016$\u0006N]8ui2,G\u0003CA\u0019\u0003_\f\t0!>\t\u000f\u0005%H\u00041\u0001\u0002\b\"I\u00111\u001f\u000f\u0011\u0002\u0003\u0007\u0011qQ\u0001\u0013m\u0016\u0014\u0018NZ=DY&,g\u000e^'fiJL7\rC\u0005\u0002xr\u0001\n\u00111\u0001\u0002\b\u0006Qb/\u001a:jMf\u0014V-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jG\u0006yb/\u001a:jMf\u0004&o\u001c3vG\u0016$\u0006N]8ui2,G\u0005Z3gCVdG\u000f\n\u001a\u0002?Y,'/\u001b4z!J|G-^2f)\"\u0014x\u000e\u001e;mK\u0012\"WMZ1vYR$3'A\u000bwKJLg-_\"p]N,X.\u001a+ie>$H\u000f\\3\u0015\u0011\u0005E\"\u0011\u0001B\u0002\u0005\u000bAq!!; \u0001\u0004\t9\tC\u0005\u0002t~\u0001\n\u00111\u0001\u0002\b\"I\u0011q_\u0010\u0011\u0002\u0003\u0007\u0011qQ\u0001 m\u0016\u0014\u0018NZ=D_:\u001cX/\\3UQJ|G\u000f\u001e7fI\u0011,g-Y;mi\u0012\u0012\u0014a\b<fe&4\u0017pQ8ogVlW\r\u00165s_R$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005Ab/\u001a:jMf$\u0006N]8ui2,G+[7f\u001b\u0016$(/[2\u0015\u0011\u0005E\"q\u0002B\r\u00057AqA!\u0005#\u0001\u0004\u0011\u0019\"A\u0005rk>$\u0018\rV=qKB\u0019QM!\u0006\n\u0007\t]aMA\u0005Rk>$\u0018\rV=qK\"1\u00111\u000f\u0012A\u0002\rCq!!;#\u0001\u0004\t9)\u0001\nuQJ|G\u000f\u001e7f\u001b\u0016$(/[2OC6,GC\u0002B\u0011\u0005O\u0011I\u0003E\u0002X\u0005GI1A!\nY\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0005#\u0019\u0003\u0019\u0001B\n\u0011\u0019\t\u0019h\ta\u0001\u0007\u0006qA\u000f\u001b:piRdW-T3ue&\u001cGC\u0002B\u0018\u0005k\u00119\u0004\u0005\u0003\u00026\nE\u0012\u0002\u0002B\u001a\u0003o\u00131bS1gW\u0006lU\r\u001e:jG\"9!\u0011\u0003\u0013A\u0002\tM\u0001BBA:I\u0001\u00071)\u0001\u0012ce>\\WM\u001d*fcV,7\u000f^'fiJL7m\u001d+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0006#\nu\"q\b\u0005\b\u0003',\u0003\u0019AAk\u0011\u0019\t\u0019/\na\u0001\u0007\u0006\u0019R\r_3naR\u0014V-];fgRlU\r\u001e:jGV\u0011!qF\u0001'm\u0016\u0014\u0018NZ=Qe>$WoY3s\u00072LWM\u001c;UQJ|G\u000f\u001e7f)&lW-T3ue&\u001cG\u0003BA\u0019\u0005\u0013Bq!!;(\u0001\u0004\t9)\u0001\u0014wKJLg-_\"p]N,X.\u001a:DY&,g\u000e\u001e+ie>$H\u000f\\3US6,W*\u001a;sS\u000e$b!!\r\u0003P\tE\u0003bBAuQ\u0001\u0007\u0011q\u0011\u0005\n\u0005'B\u0003\u0013!a\u0001\u0005+\nq\"\\1y)\"\u0014x\u000e\u001e;mKRKW.\u001a\t\u0005u\t]\u0013+C\u0002\u0003Zm\u0012aa\u00149uS>t\u0017\u0001\r<fe&4\u0017pQ8ogVlWM]\"mS\u0016tG\u000f\u00165s_R$H.\u001a+j[\u0016lU\r\u001e:jG\u0012\"WMZ1vYR$#'\u0006\u0002\u0003`)\"!QKAJ\u0003E\u0019G.[3oiF+x\u000e^1F]RLG/\u001f\u000b\u0007\u0005K\u0012yG!\u001e\u0011\t\t\u001d$1N\u0007\u0003\u0005SR1!a,Y\u0013\u0011\u0011iG!\u001b\u0003#\rc\u0017.\u001a8u#V|G/Y#oi&$\u0018\u0010C\u0004\u0003r)\u0002\rAa\u001d\u0002\tU\u001cXM\u001d\t\u0005u\t]3\tC\u0004\u0002t)\u0002\rAa\u001d\u0002+\rd\u0017.\u001a8u#V|G/Y!mi\u0016\u0014\u0018\r^5p]RQ!1\u0010BA\u0005\u000b\u0013IIa#\u0011\t\t\u001d$QP\u0005\u0005\u0005\u007f\u0012IGA\u000bDY&,g\u000e^)v_R\f\u0017\t\u001c;fe\u0006$\u0018n\u001c8\t\u000f\t\r5\u00061\u0001\u0003f\u0005Y\u0011/^8uC\u0016sG/\u001b;z\u0011\u001d\tId\u000ba\u0001\u0005\u000f\u0003RA\u000fB,\u0003wAq!a\u0011,\u0001\u0004\u00119\tC\u0004\u0002H-\u0002\rA!\u0016\u0002#\u0005dG/\u001a:DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u00022\tE\u0005b\u0002BJY\u0001\u0007!QS\u0001\u0011cV|G/Y!mi\u0016\u0014\u0018\r^5p]N\u0004RA\u000fBL\u0005wJ1A!'<\u0005)a$/\u001a9fCR,GMP\u0001\u0013o\u0006LGOR8s#V|G/Y+qI\u0006$X\r\u0006\u0006\u00022\t}%\u0011\u0015BR\u0005KCq!!\u000f.\u0001\u0004\tY\u0004C\u0004\u0002D5\u0002\r!a\u000f\t\r\u0005\u001dS\u00061\u0001R\u0011\u001d9W\u0006%AA\u0002\u0011\fAd^1ji\u001a{'/U;pi\u0006,\u0006\u000fZ1uK\u0012\"WMZ1vYR$C'\u0006\u0002\u0003,*\u001aA-a%")
public abstract class QuotaTestClients {
    private final String topic;
    private final KafkaServer leaderNode;
    private final String producerClientId;
    private final String consumerClientId;
    private final KafkaProducer<byte[], byte[]> producer;
    private final KafkaConsumer<byte[], byte[]> consumer;
    private final Admin adminClient;

    public static double metricValue(org.apache.kafka.common.Metric metric) {
        return QuotaTestClients$.MODULE$.metricValue(metric);
    }

    public static String DefaultEntity() {
        return QuotaTestClients$.MODULE$.DefaultEntity();
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public abstract void overrideQuotas(long var1, long var3, double var5);

    public abstract void removeQuotaOverrides();

    public abstract KafkaPrincipal userPrincipal();

    public abstract Map<String, String> quotaMetricTags(String var1);

    /*
     * WARNING - void declaration
     */
    public int produceUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        void var3_3;
        boolean throttled;
        int numProduced = 0;
        do {
            byte[] payload = Integer.toString(numProduced).getBytes();
            Future future = this.producer().send(new ProducerRecord(this.topic, null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.topic, null, null, true));
            ++numProduced;
            do {
                KafkaMetric metric;
                boolean bl = throttled = (metric = this.throttleMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId)) != null && QuotaTestClients$.MODULE$.metricValue((org.apache.kafka.common.Metric)metric) > 0.0;
            } while (!future.isDone() && (!throttled || waitForRequestCompletion));
        } while (numProduced < maxRecords && !throttled);
        return (int)var3_3;
    }

    public boolean produceUntilThrottled$default$2() {
        return true;
    }

    public int consumeUntilThrottled(int maxRecords, boolean waitForRequestCompletion) {
        boolean throttled;
        long timeoutMs = TimeUnit.MINUTES.toMillis(1L);
        this.consumer().subscribe(Collections.singleton(this.topic));
        int numConsumed = 0;
        long startMs = System.currentTimeMillis();
        do {
            KafkaMetric metric;
            boolean bl = throttled = (metric = this.throttleMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId)) != null && QuotaTestClients$.MODULE$.metricValue((org.apache.kafka.common.Metric)metric) > 0.0;
        } while ((numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count()) < maxRecords && !throttled && System.currentTimeMillis() < startMs + timeoutMs);
        if (throttled && numConsumed < maxRecords && waitForRequestCompletion) {
            int minRecords = numConsumed + 1;
            long startMs2 = System.currentTimeMillis();
            while (numConsumed < minRecords && System.currentTimeMillis() < startMs2 + timeoutMs) {
                numConsumed += this.consumer().poll(Duration.ofMillis(100L)).count();
            }
        }
        return numConsumed;
    }

    public boolean consumeUntilThrottled$default$2() {
        return true;
    }

    private Quota quota(ClientQuotaManager quotaManager, KafkaPrincipal userPrincipal, String clientId) {
        return quotaManager.quota(userPrincipal, clientId);
    }

    private void verifyThrottleTimeRequestChannelMetric(ApiKeys apiKey, String metricNameSuffix, String clientId, boolean expectThrottle) {
        double throttleTimeMs = this.brokerRequestMetricsThrottleTimeMs(apiKey, metricNameSuffix);
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(44).append("Client with id=").append(clientId).append(" should have been throttled, ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((double)0.0, (double)throttleTimeMs, (double)0.0, (String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString());
    }

    public void verifyProduceThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric((QuotaType)QuotaType.Produce$.MODULE$, this.producerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.PRODUCE, "", this.producerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyProducerClientThrottleTimeMetric(expectThrottle);
        }
    }

    public boolean verifyProduceThrottle$default$2() {
        return true;
    }

    public boolean verifyProduceThrottle$default$3() {
        return true;
    }

    public void verifyConsumeThrottle(boolean expectThrottle, boolean verifyClientMetric, boolean verifyRequestChannelMetric) {
        this.verifyThrottleTimeMetric((QuotaType)QuotaType.Fetch$.MODULE$, this.consumerClientId, expectThrottle);
        if (verifyRequestChannelMetric) {
            this.verifyThrottleTimeRequestChannelMetric(ApiKeys.FETCH, "Consumer", this.consumerClientId, expectThrottle);
        }
        if (verifyClientMetric) {
            this.verifyConsumerClientThrottleTimeMetric(expectThrottle, this.verifyConsumerClientThrottleTimeMetric$default$2());
        }
    }

    public boolean verifyConsumeThrottle$default$2() {
        return true;
    }

    public boolean verifyConsumeThrottle$default$3() {
        return true;
    }

    private void verifyThrottleTimeMetric(QuotaType quotaType, String clientId, boolean expectThrottle) {
        double throttleMetricValue = QuotaTestClients$.MODULE$.metricValue((org.apache.kafka.common.Metric)this.throttleMetric(quotaType, clientId));
        if (expectThrottle) {
            Assertions.assertTrue((throttleMetricValue > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Client with id=").append(clientId).append(" should have been throttled").toString());
            return;
        }
        Assertions.assertTrue((boolean)Double.isNaN(throttleMetricValue), (String)new StringBuilder(46).append("Client with id=").append(clientId).append(" should not have been throttled").toString());
    }

    private MetricName throttleMetricName(QuotaType quotaType, String clientId) {
        return this.leaderNode.metrics().metricName("throttle-time", quotaType.toString(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.quotaMetricTags(clientId)).asJava());
    }

    public KafkaMetric throttleMetric(QuotaType quotaType, String clientId) {
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(this.throttleMetricName(quotaType, clientId));
    }

    private double brokerRequestMetricsThrottleTimeMs(ApiKeys apiKey, String metricNameSuffix) {
        return QuotaTestClients.yammerMetricValue$1(new StringBuilder(62).append("kafka.network:type=RequestMetrics,name=ThrottleTimeMs,request=").append(apiKey.name).append(metricNameSuffix).toString());
    }

    public KafkaMetric exemptRequestMetric() {
        MetricName metricName = this.leaderNode.metrics().metricName("exempt-request-time", QuotaType.Request$.MODULE$.toString(), "");
        return (KafkaMetric)this.leaderNode.metrics().metrics().get(metricName);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyProducerClientThrottleTimeMetric(boolean expectThrottle) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.producerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-avg", "producer-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.producer().metrics().get(new MetricName("produce-throttle-time-max", "producer-metrics", "", tags));
        if (expectThrottle) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)QuotaTestClients.$anonfun$verifyProducerClientThrottleTimeMetric$2(avgMetric, maxMetric));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        Assertions.assertEquals((double)0.0, (double)QuotaTestClients$.MODULE$.metricValue(maxMetric), (double)0.0, (String)"Should not have been throttled");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyConsumerClientThrottleTimeMetric(boolean expectThrottle, Option<Object> maxThrottleTime) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("client-id", this.consumerClientId);
        org.apache.kafka.common.Metric avgMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-avg", "consumer-fetch-manager-metrics", "", tags));
        org.apache.kafka.common.Metric maxMetric = (org.apache.kafka.common.Metric)this.consumer().metrics().get(new MetricName("fetch-throttle-time-max", "consumer-fetch-manager-metrics", "", tags));
        if (expectThrottle) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$1(avgMetric, maxMetric)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)QuotaTestClients.$anonfun$verifyConsumerClientThrottleTimeMetric$2(avgMetric, maxMetric));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            maxThrottleTime.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)max -> Assertions.assertTrue((QuotaTestClients$.MODULE$.metricValue(maxMetric) <= max ? 1 : 0) != 0, (String)new StringBuilder(36).append("Maximum consumer throttle too high: ").append(QuotaTestClients$.MODULE$.metricValue(maxMetric)).toString()));
            return;
        }
        Assertions.assertEquals((double)0.0, (double)QuotaTestClients$.MODULE$.metricValue(maxMetric), (double)0.0, (String)"Should not have been throttled");
    }

    public Option<Object> verifyConsumerClientThrottleTimeMetric$default$2() {
        return None$.MODULE$;
    }

    public ClientQuotaEntity clientQuotaEntity(Option<String> user2, Option<String> clientId2) {
        ObjectRef entries = ObjectRef.create((Object)Map$.MODULE$.empty());
        user2.foreach((Function1 & Serializable & scala.Serializable)user -> {
            entries.elem = ((scala.collection.immutable.Map)entries.elem).$plus$plus((GenTraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)user)})));
            return BoxedUnit.UNIT;
        });
        clientId2.foreach((Function1 & Serializable & scala.Serializable)clientId -> {
            entries.elem = ((scala.collection.immutable.Map)entries.elem).$plus$plus((GenTraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)clientId)})));
            return BoxedUnit.UNIT;
        });
        return new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)entries.elem)).asJava());
    }

    public ClientQuotaAlteration clientQuotaAlteration(ClientQuotaEntity quotaEntity, Option<Object> producerQuota, Option<Object> consumerQuota, Option<Object> requestQuota) {
        ObjectRef ops = ObjectRef.create((Object)Nil$.MODULE$);
        QuotaTestClients.addOp$1("producer_byte_rate", producerQuota.map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$2 -> x$2), ops);
        QuotaTestClients.addOp$1("consumer_byte_rate", consumerQuota.map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$3 -> x$3), ops);
        QuotaTestClients.addOp$1("request_percentage", requestQuota, ops);
        return new ClientQuotaAlteration(quotaEntity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)ops.elem).asJava());
    }

    public void alterClientQuotas(Seq<ClientQuotaAlteration> quotaAlterations) {
        this.adminClient().alterClientQuotas((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(quotaAlterations).asJava()).all().get();
    }

    /*
     * WARNING - void declaration
     */
    public void waitForQuotaUpdate(long producerQuota, long consumerQuota, double requestQuota, KafkaServer server) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                QuotaTestClients.$anonfun$waitForQuotaUpdate$1(this, server, producerQuota, consumerQuota, requestQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public KafkaServer waitForQuotaUpdate$default$4() {
        return this.leaderNode;
    }

    public static final /* synthetic */ boolean $anonfun$brokerRequestMetricsThrottleTimeMs$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith(name$1);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final double yammerMetricValue$1(String name) {
        double d;
        void var5_3;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaTestClients.$anonfun$brokerRequestMetricsThrottleTimeMs$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var5_3 instanceof Meter) {
            d = ((Meter)var5_3).count();
        } else if (var5_3 instanceof Histogram) {
            d = ((Histogram)var5_3).max();
        } else {
            throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var5_3.getClass()).toString());
        }
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$verifyProducerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        return QuotaTestClients$.MODULE$.metricValue(avgMetric$1) > 0.0 && QuotaTestClients$.MODULE$.metricValue(maxMetric$1) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyProducerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$1, org.apache.kafka.common.Metric maxMetric$1) {
        return new StringBuilder(47).append("Producer throttle metric not updated: avg=").append(QuotaTestClients$.MODULE$.metricValue(avgMetric$1)).append(" max=").append(QuotaTestClients$.MODULE$.metricValue(maxMetric$1)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyConsumerClientThrottleTimeMetric$1(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        return QuotaTestClients$.MODULE$.metricValue(avgMetric$2) > 0.0 && QuotaTestClients$.MODULE$.metricValue(maxMetric$2) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyConsumerClientThrottleTimeMetric$2(org.apache.kafka.common.Metric avgMetric$2, org.apache.kafka.common.Metric maxMetric$2) {
        return new StringBuilder(47).append("Consumer throttle metric not updated: avg=").append(QuotaTestClients$.MODULE$.metricValue(avgMetric$2)).append(" max=").append(QuotaTestClients$.MODULE$.metricValue(maxMetric$2)).toString();
    }

    public static final /* synthetic */ Double $anonfun$clientQuotaAlteration$1(double x) {
        return BoxesRunTime.boxToDouble((double)x);
    }

    private static final void addOp$1(String key, Option value, ObjectRef ops$1) {
        ops$1.elem = (Seq)((Seq)ops$1.elem).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new ClientQuotaAlteration.Op(key, (Double)value.map((Function1 & Serializable & scala.Serializable)x -> QuotaTestClients.$anonfun$clientQuotaAlteration$1(BoxesRunTime.unboxToDouble((Object)x))).orNull(Predef$.MODULE$.$conforms())), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$waitForQuotaUpdate$1(QuotaTestClients $this, KafkaServer server$1, long producerQuota$1, long consumerQuota$1, double requestQuota$1) {
        QuotaFactory.QuotaManagers quotaManagers = server$1.dataPlaneRequestProcessor().quotas();
        Quota overrideProducerQuota = $this.quota(quotaManagers.produce(), $this.userPrincipal(), $this.producerClientId);
        Quota overrideConsumerQuota = $this.quota(quotaManagers.fetch(), $this.userPrincipal(), $this.consumerClientId);
        Quota overrideProducerRequestQuota = $this.quota((ClientQuotaManager)quotaManagers.request(), $this.userPrincipal(), $this.producerClientId);
        Quota overrideConsumerRequestQuota = $this.quota((ClientQuotaManager)quotaManagers.request(), $this.userPrincipal(), $this.consumerClientId);
        Assertions.assertEquals((Object)Quota.upperBound((double)producerQuota$1), (Object)overrideProducerQuota, (String)new StringBuilder(43).append("ClientId ").append($this.producerClientId).append(" of user ").append($this.userPrincipal()).append(" must have producer quota").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)consumerQuota$1), (Object)overrideConsumerQuota, (String)new StringBuilder(43).append("ClientId ").append($this.consumerClientId).append(" of user ").append($this.userPrincipal()).append(" must have consumer quota").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)requestQuota$1), (Object)overrideProducerRequestQuota, (String)new StringBuilder(42).append("ClientId ").append($this.producerClientId).append(" of user ").append($this.userPrincipal()).append(" must have request quota").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)requestQuota$1), (Object)overrideConsumerRequestQuota, (String)new StringBuilder(42).append("ClientId ").append($this.consumerClientId).append(" of user ").append($this.userPrincipal()).append(" must have request quota").toString());
    }

    public QuotaTestClients(String topic, KafkaServer leaderNode, String producerClientId, String consumerClientId, KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer, Admin adminClient) {
        this.topic = topic;
        this.leaderNode = leaderNode;
        this.producerClientId = producerClientId;
        this.consumerClientId = consumerClientId;
        this.producer = producer;
        this.consumer = consumer;
        this.adminClient = adminClient;
    }
}

